/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.blocks.parsers;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import rebound.bits.Bytes;
import rebound.io.util.JRECompatIOUtilities;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.pray.BlockHeader;
import rebound.jagent.lib.pray.blocks.BlockParser;
import rebound.jagent.lib.pray.template.Group;
import rebound.jagent.lib.pray.template.PrayTemplate;
import rebound.text.StringUtilities;
import rebound.util.objectutil.BasicObjectUtilities;

public class TagBlockParser
implements BlockParser {
    @Override
    public void parseBlock(BlockHeader b, InputStream data, PrayTemplate template) throws IOException, FormatMismatchException {
        Group g = new Group();
        template.addGroup(g);
        g.setID(StringUtilities.decodeTextToStringReporting(b.getId(), StandardCharsets.UTF_8));
        g.setName(b.getName());
        int intTagCount = Bytes.getLittleInt(data);
        int ival = 0;
        String name = null;
        int i = 0;
        while (i < intTagCount) {
            name = this.readLString(data);
            ival = Bytes.getLittleInt(data);
            g.addIntTag(name, ival);
            ++i;
        }
        int strTagCount = Bytes.getLittleInt(data);
        String sval = null;
        boolean hasAtLeastOneScript = false;
        boolean hasOtherScripts = false;
        int i2 = 0;
        while (i2 < strTagCount) {
            name = this.readLString(data);
            if (Group.isScriptTag(name)) {
                String script;
                hasAtLeastOneScript = true;
                int scriptNumber = Group.getScriptNumber(name);
                if (scriptNumber != 1) {
                    hasOtherScripts = true;
                }
                int len = Bytes.getLittleInt(data);
                byte[] encoded = new byte[len];
                JRECompatIOUtilities.readFully(data, encoded);
                try {
                    script = StringUtilities.decodeTextToStringReporting(encoded, StandardCharsets.UTF_8);
                }
                catch (CharacterCodingException exc) {
                    System.err.println("Warning: malformed or non-UTF8 input on tag " + StringUtilities.repr(name));
                    script = null;
                    g.writeRawScriptToFile(encoded, scriptNumber);
                }
                if (script != null) {
                    g.writeScriptToFile(script, scriptNumber);
                }
            } else {
                sval = this.readLString(data);
                g.addStringTag(name, sval);
                if (BasicObjectUtilities.eq((Object)name, (Object)"Remove script")) {
                    g.writeRemoveScriptToFile(sval);
                }
            }
            ++i2;
        }
        if (hasAtLeastOneScript && !hasOtherScripts) {
            g.recognizeSingletonScript();
        }
    }

    protected String readLString(InputStream in) throws IOException, EOFException {
        int len = Bytes.getLittleInt(in);
        byte[] raw = new byte[len];
        JRECompatIOUtilities.readFully(in, raw);
        return StringUtilities.universalNewlines(StringUtilities.decodeTextToStringReporting(raw, StandardCharsets.UTF_8));
    }

    @Override
    public boolean canHandle(BlockHeader b) {
        return b.getID() == 1 || b.getID() == 2 || b.getID() == 3 || b.getID() == 4 || b.getID() == 6 || b.getID() == 5 || b.getID() == 8 || b.getID() == 9 || b.getID() == 14;
    }
}

