/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.pray.blocks.makers;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import rebound.bits.Bytes;
import rebound.io.util.FSIOUtilities;
import rebound.jagent.lib.PathBoss;
import rebound.jagent.lib.pray.BlockHeader;
import rebound.jagent.lib.pray.CaosUtilitiesForJagent;
import rebound.jagent.lib.pray.InvalidNameException;
import rebound.jagent.lib.pray.blocks.MetaBlockMaker;
import rebound.jagent.lib.pray.template.Group;
import rebound.text.StringUtilities;
import rebound.util.collections.CollectionUtilities;
import rebound.util.objectutil.BasicObjectUtilities;

public class TagBlockMaker {
    protected boolean mergeScripts = true;

    public void make(OutputStream out, Group g) throws IOException, InvalidNameException {
        String removeScriptFromFile;
        if (!PathBoss.getInstance().isNameCrossplatformFriendly(g.getName())) {
            throw new InvalidNameException(g.getName(), "characters in the name are illegal on some platforms");
        }
        BlockHeader b = new BlockHeader();
        b.setId(g.getID().getBytes(StandardCharsets.UTF_8));
        b.setName(StringUtilities.universalNewlines(g.getName()));
        byte[] blockContents = null;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int scriptCount = this.isMergeScripts() ? (g.hasScripts() ? 1 : 0) : g.getScriptFileNames().size();
        Bytes.putLittleInt(buffer, g.getIntValCount() + (g.hasScripts() ? 1 : 0));
        int i = 0;
        while (i < g.getIntValCount()) {
            this.writeLString(buffer, g.getIntTagName(i));
            Bytes.putLittleInt(buffer, g.getIntTagValue(i));
            ++i;
        }
        if (g.hasScripts()) {
            this.writeLString(buffer, "Script Count");
            Bytes.putLittleInt(buffer, scriptCount);
        }
        Bytes.putLittleInt(buffer, g.getStrValCount() + scriptCount);
        boolean mergingScripts = g.hasScripts() && this.isMergeScripts();
        Integer removeScriptTagIndex = null;
        int i2 = 0;
        while (i2 < g.getStrValCount()) {
            String n = g.getStrTagName(i2);
            if (BasicObjectUtilities.eq((Object)n, (Object)"Remove script") && mergingScripts) {
                removeScriptTagIndex = i2;
            } else {
                this.writeLString(buffer, n);
                this.writeLString(buffer, g.getStrTagValue(i2));
            }
            ++i2;
        }
        File removeScriptFile = g.getRemoveScriptFile();
        String string = removeScriptFromFile = removeScriptFile == null ? null : FSIOUtilities.readAllText(removeScriptFile);
        if (removeScriptFromFile != null && !mergingScripts) {
            this.writeLString(buffer, "Remove script");
            this.writeLString(buffer, removeScriptFromFile);
        }
        if (g.hasScripts()) {
            if (this.isMergeScripts()) {
                List<File> scriptFiles = g.getScriptFiles();
                ArrayList<String> scripts = new ArrayList<String>();
                for (File f : scriptFiles) {
                    scripts.add(FSIOUtilities.readAllText(f));
                }
                ArrayList<String> wholes = new ArrayList<String>();
                ArrayList<String> removes = new ArrayList<String>();
                if (removeScriptTagIndex != null) {
                    removes.add(g.getStrTagValue(removeScriptTagIndex));
                }
                removes.add(removeScriptFromFile);
                ArrayList<String> removeScriptsInGivenOrder = new ArrayList<String>(scripts.size());
                boolean first = true;
                for (String script : scripts) {
                    CaosUtilitiesForJagent.CaosAndRemoveScript r = CaosUtilitiesForJagent.parse(script);
                    if (!StringUtilities.isAllWhitespace(r.otherCaos)) {
                        wholes.add(r.otherCaos);
                    }
                    if (!(StringUtilities.isAllWhitespace(r.removeScript) || first && g.getCutOutRemoveScriptFromFirstScript())) {
                        removeScriptsInGivenOrder.add(r.removeScript);
                    }
                    first = false;
                }
                removes.addAll(CollectionUtilities.reversed(removeScriptsInGivenOrder));
                String wholeScript = CaosUtilitiesForJagent.mergeCaosen(wholes);
                String completeRemoveScript = CaosUtilitiesForJagent.mergeCaosen(removes);
                this.writeLString(buffer, "Script 1");
                this.writeLString(buffer, wholeScript);
                this.writeLString(buffer, "Remove script");
                this.writeLString(buffer, completeRemoveScript);
            } else {
                List<File> scriptFiles = g.getScriptFiles();
                int i3 = 0;
                while (i3 < scriptFiles.size()) {
                    byte[] newEncoding;
                    String script;
                    File scriptFile = scriptFiles.get(i3);
                    byte[] originalEncoding = FSIOUtilities.readAll(scriptFile);
                    try {
                        script = StringUtilities.decodeTextToStringReporting(originalEncoding, StandardCharsets.UTF_8);
                    }
                    catch (CharacterCodingException exc) {
                        System.err.println("Warning: malformed or non-UTF8 input at " + scriptFile.getAbsolutePath());
                        script = null;
                    }
                    if (script != null) {
                        if (g.getCutOutRemoveScriptFromFirstScript() && i3 == 0) {
                            script = CaosUtilitiesForJagent.parse((String)script).otherCaos;
                        }
                        newEncoding = script.getBytes(StandardCharsets.UTF_8);
                    } else {
                        newEncoding = originalEncoding;
                    }
                    this.writeLString(buffer, "Script " + (i3 + 1));
                    Bytes.putLittleInt(buffer, newEncoding.length);
                    buffer.write(newEncoding);
                    ++i3;
                }
            }
        }
        blockContents = buffer.toByteArray();
        buffer = null;
        int blockContentsLength = blockContents.length;
        b.setLengthInFile(blockContentsLength);
        b.setCompressed(false);
        b.setOriginalLength(blockContentsLength);
        MetaBlockMaker.writeHeader(out, b);
        out.write(blockContents);
    }

    protected void writeLString(OutputStream out, String str) throws IOException {
        byte[] bstr = StringUtilities.universalNewlines(str).getBytes(StandardCharsets.UTF_8);
        Bytes.putLittleInt(out, bstr.length);
        out.write(bstr);
    }

    public boolean isMergeScripts() {
        return this.mergeScripts;
    }

    public void setMergeScripts(boolean mergeScripts) {
        this.mergeScripts = mergeScripts;
    }
}

