/*
 * Decompiled with CFR 0.152.
 */
package rebound.applied.calendars;

import java.util.Objects;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.simpledata.Positive;
import rebound.exceptions.HeuristicException;
import rebound.exceptions.ImpossibleException;
import rebound.math.SmallIntegerMathUtilities;
import rebound.testing.WidespreadTestingUtilities;
import rebound.util.BasicExceptionUtilities;
import rebound.util.functional.ContinueSignal;
import rebound.util.objectutil.JavaNamespace;

public class GregorianCalendarCode
implements JavaNamespace {
    public static final int GregorianDayNumberAD_To_Julian_Day_Number_Offset = 1721060;
    public static final int GregorianDayNumberAD_Of_Unix_Epoch_Day = 719528;
    @ReadonlyValue
    public static final String[] ISO8601DayOfWeekNamesEnglish;
    public static boolean asserts;

    static {
        String[] stringArray = new String[8];
        stringArray[1] = "Monday";
        stringArray[2] = "Tuesday";
        stringArray[3] = "Wednesday";
        stringArray[4] = "Thursday";
        stringArray[5] = "Friday";
        stringArray[6] = "Saturday";
        stringArray[7] = "Sunday";
        ISO8601DayOfWeekNamesEnglish = stringArray;
        asserts = false;
    }

    public static int convertADGregorianDayNumberToJulianDayNumber(int gregorianDayNumberADEpoch) {
        return gregorianDayNumberADEpoch + 1721060;
    }

    public static int convertJulianDayNumberToADGregorianDayNumber(int julianDayNumber) {
        return julianDayNumber - 1721060;
    }

    public static boolean isLeapYear(int year) {
        if (year % 4 == 0) {
            if (year % 100 == 0) {
                return year % 400 == 0;
            }
            return true;
        }
        return false;
    }

    public static int getLengthOfYear(int year) {
        return GregorianCalendarCode.isLeapYear(year) ? 366 : 365;
    }

    public static int getGregorianAstronomicalYear(int gregorianActualCalendarYear, WesternEpochParity epochParity) {
        if (gregorianActualCalendarYear < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (epochParity == WesternEpochParity.AD) {
            return gregorianActualCalendarYear;
        }
        if (epochParity == WesternEpochParity.BC) {
            return -gregorianActualCalendarYear + 1;
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)epochParity);
    }

    public static int getActualGregorianCalendarYear(int gregorianAstronomicalYear) {
        if (gregorianAstronomicalYear > 0) {
            return gregorianAstronomicalYear;
        }
        return -gregorianAstronomicalYear + 1;
    }

    public static WesternEpochParity getGregorianCalendarYearEpochParity(int gregorianAstronomicalYear) {
        return gregorianAstronomicalYear > 0 ? WesternEpochParity.AD : WesternEpochParity.BC;
    }

    public static int convertYearDayofyearToADGregorianDayNumber(int year, int dayOfYear) {
        if (dayOfYear < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (dayOfYear > GregorianCalendarCode.getLengthOfYear(year)) {
            throw new IndexOutOfBoundsException();
        }
        int gregorianDayNumberADEpoch = year * 365 + SmallIntegerMathUtilities.floorDivision(year + 4 - 1, 4) - SmallIntegerMathUtilities.floorDivision(year + 100 - 1, 100) + SmallIntegerMathUtilities.floorDivision(year + 400 - 1, 400) + (dayOfYear - 1);
        if (year >= 0 && asserts) {
            WidespreadTestingUtilities.asrt(gregorianDayNumberADEpoch == year * 365 + (year + 4 - 1) / 4 - (year + 100 - 1) / 100 + (year + 400 - 1) / 400 + (dayOfYear - 1));
        }
        return gregorianDayNumberADEpoch;
    }

    public static int convertADGregorianDayNumberToYear(int gregorianDayNumberADEpoch) {
        if (gregorianDayNumberADEpoch < 0) {
            return -GregorianCalendarCode.convertADGregorianDayNumberToYear(-gregorianDayNumberADEpoch - 1 + 366);
        }
        int i = gregorianDayNumberADEpoch;
        return (((i % 146097 - 1) % 36524 + 1) % 1461 - 1) / 365 + 4 * (((i % 146097 - 1) % 36524 + 1) / 1461) + 100 * ((i % 146097 - 1) / 36524) + 400 * (i / 146097);
    }

    public static int[] convertADGregorianDayNumberToYearDayofyear(int gregorianDayNumberADEpoch) {
        int year = GregorianCalendarCode.convertADGregorianDayNumberToYear(gregorianDayNumberADEpoch);
        if (asserts) {
            WidespreadTestingUtilities.asrt(GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, 1) <= gregorianDayNumberADEpoch);
        }
        int dayOfYear = gregorianDayNumberADEpoch - GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, 1) + 1;
        if (asserts) {
            WidespreadTestingUtilities.asrt(dayOfYear >= 1 && dayOfYear <= GregorianCalendarCode.getLengthOfYear(year));
        }
        return new int[]{year, dayOfYear};
    }

    public static int convertYearDayofyearToJulianDayNumber(int year, int dayOfYear) {
        return GregorianCalendarCode.convertADGregorianDayNumberToJulianDayNumber(GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, dayOfYear));
    }

    public static int[] convertJulianDayNumberToYearDayofyear(int julianDayNumber) {
        return GregorianCalendarCode.convertADGregorianDayNumberToYearDayofyear(GregorianCalendarCode.convertJulianDayNumberToADGregorianDayNumber(julianDayNumber));
    }

    public static int convertJulianDayNumberToYear(int julianDayNumber) {
        return GregorianCalendarCode.convertADGregorianDayNumberToYear(GregorianCalendarCode.convertJulianDayNumberToADGregorianDayNumber(julianDayNumber));
    }

    public static int getLengthOfMonthExceptFebruary(int monthNumber) {
        if (monthNumber < 1 || monthNumber > 12) {
            throw new IndexOutOfBoundsException("Month: " + monthNumber);
        }
        return 30 + (monthNumber + monthNumber / 8 & 1);
    }

    public static int getLengthOfMonth(int year, int monthNumber) {
        if (monthNumber == 2) {
            return GregorianCalendarCode.isLeapYear(year) ? 29 : 28;
        }
        return GregorianCalendarCode.getLengthOfMonthExceptFebruary(monthNumber);
    }

    public static Month convertADGregorianDayNumberToMonth(int gregorianDayNumberADEpoch) {
        return Month.forMonthNumber(GregorianCalendarCode.convertADGregorianDayNumberToYearMonthDayofmonth(gregorianDayNumberADEpoch)[1]);
    }

    public static Month convertJulianDayNumberToMonth(int julianDayNumber) {
        return GregorianCalendarCode.convertADGregorianDayNumberToMonth(GregorianCalendarCode.convertJulianDayNumberToADGregorianDayNumber(julianDayNumber));
    }

    public static int[] convertYearDayofyearToYearMonthDayofmonth(int year, int dayOfYear) {
        if (dayOfYear <= 0) {
            throw new IndexOutOfBoundsException();
        }
        if (dayOfYear > GregorianCalendarCode.getLengthOfYear(year)) {
            throw new IndexOutOfBoundsException();
        }
        int currentlyConsideredTotalOfDaysInYear = 0;
        int currentlyConsideredMonth = 1;
        while (currentlyConsideredMonth <= 12) {
            int lengthOfM = GregorianCalendarCode.getLengthOfMonth(year, currentlyConsideredMonth);
            if (dayOfYear - 1 < currentlyConsideredTotalOfDaysInYear + lengthOfM) {
                int month = currentlyConsideredMonth;
                int dayOfMonth = dayOfYear - currentlyConsideredTotalOfDaysInYear;
                return new int[]{year, month, dayOfMonth};
            }
            currentlyConsideredTotalOfDaysInYear += lengthOfM;
            ++currentlyConsideredMonth;
        }
        throw new ImpossibleException();
    }

    public static int convertYearMonthDayofmonthToDayofyear(int year, int month, int dayOfMonth) {
        if (month < 1 || month > 12) {
            throw new IndexOutOfBoundsException(String.valueOf(month));
        }
        if (dayOfMonth < 1 || dayOfMonth > GregorianCalendarCode.getLengthOfMonth(year, month)) {
            throw new IndexOutOfBoundsException(String.valueOf(String.valueOf(dayOfMonth)) + " in " + year + "-" + month);
        }
        int currentlyConsideredTotalOfDaysInYear = 0;
        int currentlyConsideredMonth = 1;
        while (currentlyConsideredMonth <= 12) {
            if (currentlyConsideredMonth == month) {
                int dayOfYear = currentlyConsideredTotalOfDaysInYear + dayOfMonth;
                return dayOfYear;
            }
            currentlyConsideredTotalOfDaysInYear += GregorianCalendarCode.getLengthOfMonth(year, currentlyConsideredMonth);
            ++currentlyConsideredMonth;
        }
        throw new ImpossibleException();
    }

    public static int[] convertYearMonthDayofmonthToYearDayofyear(int year, int month, int dayOfMonth) {
        return new int[]{year, GregorianCalendarCode.convertYearMonthDayofmonthToDayofyear(year, month, dayOfMonth)};
    }

    public static int convertYearMonthDayofmonthToJulianDayNumber(int year, int month, int dayOfMonth) {
        int dayOfYear = GregorianCalendarCode.convertYearMonthDayofmonthToDayofyear(year, month, dayOfMonth);
        int julianDayNumber = GregorianCalendarCode.convertYearDayofyearToJulianDayNumber(year, dayOfYear);
        return julianDayNumber;
    }

    public static int[] convertJulianDayNumberToYearMonthDayofmonth(int julianDayNumber) {
        int[] yearAndDayOfYear = GregorianCalendarCode.convertJulianDayNumberToYearDayofyear(julianDayNumber);
        int year = yearAndDayOfYear[0];
        int dayOfYear = yearAndDayOfYear[1];
        return GregorianCalendarCode.convertYearDayofyearToYearMonthDayofmonth(year, dayOfYear);
    }

    public static int convertYearMonthDayofmonthToADGregorianDayNumber(int year, int month, int dayOfMonth) {
        int dayOfYear = GregorianCalendarCode.convertYearMonthDayofmonthToDayofyear(year, month, dayOfMonth);
        int gregorianDayNumberADEpoch = GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, dayOfYear);
        if (asserts) {
            WidespreadTestingUtilities.asrt(GregorianCalendarCode.convertADGregorianDayNumberToJulianDayNumber(gregorianDayNumberADEpoch) == GregorianCalendarCode.convertYearMonthDayofmonthToJulianDayNumber(year, month, dayOfMonth));
        }
        return gregorianDayNumberADEpoch;
    }

    public static int[] convertADGregorianDayNumberToYearMonthDayofmonth(int gregorianDayNumberADEpoch) {
        int[] yearAndDayOfYear = GregorianCalendarCode.convertADGregorianDayNumberToYearDayofyear(gregorianDayNumberADEpoch);
        int year = yearAndDayOfYear[0];
        int dayOfYear = yearAndDayOfYear[1];
        return GregorianCalendarCode.convertYearDayofyearToYearMonthDayofmonth(year, dayOfYear);
    }

    public static int convertDayOfWeekNumber(int dayOfWeekNumber, DayOfWeek startingDay, DayOfWeek destinationStartingDay) {
        return startingDay.modularAddition(dayOfWeekNumber - 1).getDayOfWeekNumber(destinationStartingDay);
    }

    public static int convertDayOfWeekNumberToISO8601ToMondayFirst(int dayOfWeekNumber, DayOfWeek startingDay) {
        return startingDay.modularAddition(dayOfWeekNumber - 1).getISO8601MondayFirstDayOfWeekNumber();
    }

    public static DayOfWeek convertADGregorianDayNumberToDayofweek(int gregorianDayNumberADEpoch) {
        return DayOfWeek.Saturday.modularAddition(gregorianDayNumberADEpoch);
    }

    public static DayOfWeek convertJulianDayNumberToDayofweek(int julianDayNumber) {
        return GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(GregorianCalendarCode.convertJulianDayNumberToADGregorianDayNumber(julianDayNumber));
    }

    public static DayOfWeek convertYearDayofyearToDayofweek(int year, int dayOfYear) {
        return GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, dayOfYear));
    }

    public static DayOfWeek convertYearMonthDayofmonthToDayofweek(int year, int month, int dayOfMonth) {
        return GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(GregorianCalendarCode.convertYearMonthDayofmonthToADGregorianDayNumber(year, month, dayOfMonth));
    }

    public static int getLengthOfYearInWeekofyears(int year, DayOfWeek startingDayInWeek) {
        int gregorianDayNumberADEpochOfYearStart = GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, 1);
        DayOfWeek dayOfWeekYearStartedOn = GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(gregorianDayNumberADEpochOfYearStart);
        int priorDaysInFirstWeekOfYearBeforeFirstDayOfYear = DayOfWeek.modularDifference(dayOfWeekYearStartedOn, startingDayInWeek);
        int daysInFirstWeekOfYearAfterAndIncludingFirstDayInYear = 7 - priorDaysInFirstWeekOfYearBeforeFirstDayOfYear;
        int numberOfWeekofyearsInYearSUM = 0;
        int daysInYearSUB = GregorianCalendarCode.getLengthOfYear(year);
        ++numberOfWeekofyearsInYearSUM;
        return numberOfWeekofyearsInYearSUM += SmallIntegerMathUtilities.ceilingDivision(daysInYearSUB -= daysInFirstWeekOfYearAfterAndIncludingFirstDayInYear, 7);
    }

    public static boolean doesYearStartOnWeekStart(int year, DayOfWeek startingDayInWeek) {
        int gregorianDayNumberADEpochOfYearStart = GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, 1);
        DayOfWeek dayOfWeekYearStartedOn = GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(gregorianDayNumberADEpochOfYearStart);
        boolean startsOnWeekStart = dayOfWeekYearStartedOn == startingDayInWeek;
        return startsOnWeekStart;
    }

    public static int getLengthOfWeekofyear(int year, int weekOfYear, DayOfWeek startingDayInWeek) {
        int lengthOfYearInWeekofyears = GregorianCalendarCode.getLengthOfYearInWeekofyears(year, startingDayInWeek);
        if (weekOfYear < 1 || weekOfYear > lengthOfYearInWeekofyears) {
            throw new IndexOutOfBoundsException();
        }
        int gregorianDayNumberADEpochOfYearStart = GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, 1);
        DayOfWeek dayOfWeekYearStartedOn = GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(gregorianDayNumberADEpochOfYearStart);
        int priorDaysInFirstWeekOfYearBeforeFirstDayOfYear = DayOfWeek.modularDifference(dayOfWeekYearStartedOn, startingDayInWeek);
        int daysInFirstWeekOfYearAfterAndIncludingFirstDayInYear = 7 - priorDaysInFirstWeekOfYearBeforeFirstDayOfYear;
        if (weekOfYear == 1) {
            return daysInFirstWeekOfYearAfterAndIncludingFirstDayInYear;
        }
        if (weekOfYear < lengthOfYearInWeekofyears) {
            return 7;
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(weekOfYear == lengthOfYearInWeekofyears);
        }
        int daysPrior = daysInFirstWeekOfYearAfterAndIncludingFirstDayInYear + (weekOfYear - 1 - 1) * 7;
        return GregorianCalendarCode.getLengthOfYear(year) - daysPrior;
    }

    public static int convertYearWeekofyearDayofweekToDayofyear(int year, int weekOfYear, DayOfWeek dayOfWeek, DayOfWeek startingDayInWeek) {
        int lengthOfYearInWeekofyears = GregorianCalendarCode.getLengthOfYearInWeekofyears(year, startingDayInWeek);
        if (weekOfYear < 1 || weekOfYear > lengthOfYearInWeekofyears) {
            throw new IndexOutOfBoundsException();
        }
        int gregorianDayNumberADEpochOfYearStart = GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, 1);
        DayOfWeek dayOfWeekYearStartedOn = GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(gregorianDayNumberADEpochOfYearStart);
        int priorDaysInFirstWeekOfYearBeforeFirstDayOfYear = DayOfWeek.modularDifference(dayOfWeekYearStartedOn, startingDayInWeek);
        int daysInFirstWeekOfYearAfterAndIncludingFirstDayInYear = 7 - priorDaysInFirstWeekOfYearBeforeFirstDayOfYear;
        int dayOfYear = 0;
        dayOfYear = weekOfYear == 1 ? DayOfWeek.modularDifference(dayOfWeek, dayOfWeekYearStartedOn) + 1 : (weekOfYear - 1 - 1) * 7 + daysInFirstWeekOfYearAfterAndIncludingFirstDayInYear + DayOfWeek.modularDifference(dayOfWeek, startingDayInWeek) + 1;
        if (asserts) {
            WidespreadTestingUtilities.asrt(dayOfYear >= 1 && dayOfYear <= GregorianCalendarCode.getLengthOfYear(year));
        }
        return dayOfYear;
    }

    public static int convertYearWeekofyearDayofweekToADGregorianDayNumber(int year, int weekOfYear, DayOfWeek dayOfWeek, DayOfWeek startingDayInWeek) {
        return GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, GregorianCalendarCode.convertYearWeekofyearDayofweekToDayofyear(year, weekOfYear, dayOfWeek, startingDayInWeek));
    }

    public static int convertYearWeekofyearDayofweekToJulianDayNumber(int year, int weekOfYear, DayOfWeek dayOfWeek, DayOfWeek startingDayInWeek) {
        return GregorianCalendarCode.convertJulianDayNumberToADGregorianDayNumber(GregorianCalendarCode.convertYearWeekofyearDayofweekToADGregorianDayNumber(year, weekOfYear, dayOfWeek, startingDayInWeek));
    }

    public static int[] convertADGregorianDayNumberToYearWeekofyear(int gregorianDayNumberADEpoch, DayOfWeek startingDayInWeek) {
        int year = 0;
        int dayOfYear = 0;
        int[] s = GregorianCalendarCode.convertADGregorianDayNumberToYearDayofyear(gregorianDayNumberADEpoch);
        year = s[0];
        dayOfYear = s[1];
        int gregorianDayNumberADEpochOfYearStart = GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, 1);
        DayOfWeek dayOfWeekYearStartedOn = GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(gregorianDayNumberADEpochOfYearStart);
        int priorDaysInFirstWeekOfYearBeforeFirstDayOfYear = DayOfWeek.modularDifference(dayOfWeekYearStartedOn, startingDayInWeek);
        int daysInFirstWeekOfYearAfterAndIncludingFirstDayInYear = 7 - priorDaysInFirstWeekOfYearBeforeFirstDayOfYear;
        int weekOfYear = 0;
        int days = dayOfYear - 1 - daysInFirstWeekOfYearAfterAndIncludingFirstDayInYear;
        weekOfYear = days < 0 ? 1 : days / 7 + 1 + 1;
        if (asserts) {
            WidespreadTestingUtilities.asrt(weekOfYear >= 1 && weekOfYear <= GregorianCalendarCode.getLengthOfYearInWeekofyears(year, startingDayInWeek));
        }
        return new int[]{year, weekOfYear};
    }

    public static Object[] convertADGregorianDayNumberToYearWeekofyearDayofweek(int gregorianDayNumberADEpoch, DayOfWeek startingDayInWeek) {
        int[] s = GregorianCalendarCode.convertADGregorianDayNumberToYearWeekofyear(gregorianDayNumberADEpoch, startingDayInWeek);
        return new Object[]{s[0], s[1], GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(gregorianDayNumberADEpoch)};
    }

    public static int[] convertJulianDayNumberToYearWeekofyear(int julianDayNumber, DayOfWeek startingDayInWeek) {
        return GregorianCalendarCode.convertADGregorianDayNumberToYearWeekofyear(GregorianCalendarCode.convertJulianDayNumberToADGregorianDayNumber(julianDayNumber), startingDayInWeek);
    }

    public static Object[] convertJulianDayNumberToYearWeekofyearDayofweek(int julianDayNumber, DayOfWeek startingDayInWeek) {
        return GregorianCalendarCode.convertADGregorianDayNumberToYearWeekofyearDayofweek(GregorianCalendarCode.convertJulianDayNumberToADGregorianDayNumber(julianDayNumber), startingDayInWeek);
    }

    public static Object[] convertYearDayofyearToYearWeekofyearDayofweek(int year, int dayOfYear, DayOfWeek startingDayInWeek) {
        return GregorianCalendarCode.convertADGregorianDayNumberToYearWeekofyearDayofweek(GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, dayOfYear), startingDayInWeek);
    }

    public static Object[] convertYearMonthDayofMonthToYearWeekofyearDayofweek(int year, int month, int dayOfMonth, DayOfWeek startingDayInWeek) {
        return GregorianCalendarCode.convertADGregorianDayNumberToYearWeekofyearDayofweek(GregorianCalendarCode.convertYearMonthDayofmonthToADGregorianDayNumber(year, month, dayOfMonth), startingDayInWeek);
    }

    public static int[] convertYearWeekofyearDayofweekToYearDayofyear(int year, int weekOfYear, DayOfWeek dayOfWeek, DayOfWeek startingDayInWeek) {
        return GregorianCalendarCode.convertADGregorianDayNumberToYearDayofyear(GregorianCalendarCode.convertYearWeekofyearDayofweekToADGregorianDayNumber(year, weekOfYear, dayOfWeek, startingDayInWeek));
    }

    public static int[] convertYearWeekofyearDayofweekToYearMonthDayofmonth(int year, int weekOfYear, DayOfWeek dayOfWeek, DayOfWeek startingDayInWeek) {
        return GregorianCalendarCode.convertADGregorianDayNumberToYearMonthDayofmonth(GregorianCalendarCode.convertYearWeekofyearDayofweekToADGregorianDayNumber(year, weekOfYear, dayOfWeek, startingDayInWeek));
    }

    @Positive
    public static int getOrdinalOfDayOfWeekInMonth(DayOfWeek dayOfWeekOfFirstDayInMonth, @Positive int dayOfMonth, @Positive int lengthOfMonth) {
        if (lengthOfMonth < 1) {
            throw new IllegalArgumentException();
        }
        if (dayOfMonth < 1) {
            throw new IllegalArgumentException();
        }
        if (dayOfMonth > lengthOfMonth) {
            throw new IllegalArgumentException();
        }
        DayOfWeek dayOfWeekOfThisDay = dayOfWeekOfFirstDayInMonth.modularAddition(dayOfMonth - 1);
        int r = DayOfWeek.modularDifference(dayOfWeekOfThisDay, dayOfWeekOfFirstDayInMonth);
        int s = dayOfMonth - (r + 1);
        if (s % 7 != 0) {
            throw new IllegalArgumentException("This is an impossible combination of date parameters!");
        }
        return s / 7 + 1;
    }

    @Positive
    public static int getOrdinalOfDayOfWeekInMonth(int gregorianDayNumber) {
        int[] r = GregorianCalendarCode.convertADGregorianDayNumberToYearMonthDayofmonth(gregorianDayNumber);
        int year = r[0];
        int month = r[1];
        int dayOfMonth = r[2];
        return GregorianCalendarCode.getOrdinalOfDayOfWeekInMonth(GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(GregorianCalendarCode.convertYearMonthDayofmonthToADGregorianDayNumber(year, month, 1)), dayOfMonth, GregorianCalendarCode.getLengthOfMonth(year, month));
    }

    public static void observeGregorianDates(final int gregorianDayNumberToStartOn, final GregorianFullDateObserver observer) {
        GregorianCalendarCode.observeGregorianDatesWithoutHeuristicLimiter(gregorianDayNumberToStartOn, new GregorianFullDateObserver(){

            @Override
            public ContinueSignal observe(int year, int dayOfYear, int month, DayOfWeek dayOfWeekOfFirstDayInMonth, int ordinalOfDayOfWeekInMonth, int dayOfMonth, DayOfWeek dayOfWeekOfFirstDayInYear, DayOfWeek dayOfWeek, int gregorianDayNumber) {
                if (year == 100000) {
                    throw new HeuristicException("You probably didn't mean this XD'");
                }
                return observer.observe(year, dayOfYear, month, dayOfWeekOfFirstDayInMonth, ordinalOfDayOfWeekInMonth, dayOfMonth, dayOfWeekOfFirstDayInYear, dayOfWeek, gregorianDayNumberToStartOn);
            }
        });
    }

    public static void observeGregorianDatesWithoutHeuristicLimiter(int gregorianDayNumberToStartOn, GregorianFullDateObserver observer) {
        int[] r = GregorianCalendarCode.convertADGregorianDayNumberToYearDayofyear(gregorianDayNumberToStartOn);
        int year = r[0];
        int dayOfYear = r[1];
        int gdn = gregorianDayNumberToStartOn;
        int[] r2 = GregorianCalendarCode.convertYearDayofyearToYearMonthDayofmonth(year, dayOfYear);
        WidespreadTestingUtilities.asrt(r2[0] == year);
        int month = r2[1];
        int dayOfMonth = r2[2];
        DayOfWeek dayOfWeekOfMonthStart = GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(GregorianCalendarCode.convertYearMonthDayofmonthToADGregorianDayNumber(year, month, 1));
        DayOfWeek dayOfWeekOfYearStart = month == 1 ? dayOfWeekOfMonthStart : GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(GregorianCalendarCode.convertYearMonthDayofmonthToADGregorianDayNumber(year, 1, 1));
        int dayOfWeekInMonthOrdinal = GregorianCalendarCode.getOrdinalOfDayOfWeekInMonth(dayOfWeekOfMonthStart, dayOfMonth, GregorianCalendarCode.getLengthOfMonth(year, month));
        DayOfWeek dayOfWeek = GregorianCalendarCode.convertADGregorianDayNumberToDayofweek(gdn);
        while (true) {
            int yearLengthInDays = GregorianCalendarCode.getLengthOfYear(year);
            int monthLengthInDays = GregorianCalendarCode.getLengthOfMonth(year, month);
            while (true) {
                WidespreadTestingUtilities.asrt(GregorianCalendarCode.convertYearDayofyearToADGregorianDayNumber(year, dayOfYear) == gdn);
                WidespreadTestingUtilities.asrt(GregorianCalendarCode.convertYearMonthDayofmonthToADGregorianDayNumber(year, month, dayOfMonth) == gdn);
                ContinueSignal cs = observer.observe(year, dayOfYear, month, dayOfWeekOfMonthStart, dayOfWeekInMonthOrdinal, dayOfMonth, dayOfWeekOfYearStart, dayOfWeek, gdn);
                Objects.requireNonNull(cs);
                if (cs == ContinueSignal.Stop) {
                    return;
                }
                dayOfWeek = dayOfWeek.modularAddition(1);
                ++gdn;
                if (dayOfYear == yearLengthInDays) break;
                ++dayOfYear;
                if (dayOfMonth == monthLengthInDays) {
                    dayOfMonth = 1;
                    dayOfWeekOfMonthStart = dayOfWeek;
                    dayOfWeekInMonthOrdinal = 1;
                    monthLengthInDays = GregorianCalendarCode.getLengthOfMonth(year, ++month);
                    continue;
                }
                ++dayOfMonth;
                if (dayOfWeek != dayOfWeekOfMonthStart) continue;
                ++dayOfWeekInMonthOrdinal;
            }
            WidespreadTestingUtilities.asrt(month == 12);
            WidespreadTestingUtilities.asrt(dayOfMonth == 31);
            month = 1;
            dayOfMonth = 1;
            dayOfWeekOfMonthStart = dayOfWeek;
            dayOfWeekInMonthOrdinal = 1;
            ++year;
            dayOfYear = 1;
            dayOfWeekOfYearStart = dayOfWeek;
        }
    }

    public static int _convertYearMonthDayofmonthToJulianDayNumber_UTSanAntonio(int year, int month, int dayOfMonth) {
        if (month < 1 || month > 12) {
            throw new IndexOutOfBoundsException();
        }
        if (dayOfMonth < 1 || dayOfMonth > GregorianCalendarCode.getLengthOfMonth(year, month)) {
            throw new IndexOutOfBoundsException();
        }
        if (year < -4800 || year == -4800 && month < 3 || month == 3 && dayOfMonth < 1) {
            throw new IllegalArgumentException("Algorithm not defined for dates before (-4800)-03-01, JDN -32044,  (March 1, 4799 BC)    (very proleptic Gregorian N.S. XD)");
        }
        int a = (14 - month) / 12;
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(true);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month == 1 || month == 2 ? a == 1 : a == 0);
        }
        int y = year + 4800 - a;
        int oldStyleMonthZeroIndex = SmallIntegerMathUtilities.progmod(month - 3, 12);
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(-2, 12) == 10);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(-1, 12) == 11);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(0, 12) == 0);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(1, 12) == 1);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(2, 12) == 2);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(3, 12) == 3);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(4, 12) == 4);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(5, 12) == 5);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(6, 12) == 6);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(7, 12) == 7);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(8, 12) == 8);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(SmallIntegerMathUtilities.progmod(9, 12) == 9);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 1 || oldStyleMonthZeroIndex == 10);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 2 || oldStyleMonthZeroIndex == 11);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 3 || oldStyleMonthZeroIndex == 0);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 4 || oldStyleMonthZeroIndex == 1);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 5 || oldStyleMonthZeroIndex == 2);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 6 || oldStyleMonthZeroIndex == 3);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 7 || oldStyleMonthZeroIndex == 4);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 8 || oldStyleMonthZeroIndex == 5);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 9 || oldStyleMonthZeroIndex == 6);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 10 || oldStyleMonthZeroIndex == 7);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 11 || oldStyleMonthZeroIndex == 8);
        }
        if (asserts) {
            WidespreadTestingUtilities.asrt(month != 12 || oldStyleMonthZeroIndex == 9);
        }
        int m = month + 12 * a - 3;
        if (asserts) {
            WidespreadTestingUtilities.asrt(m == oldStyleMonthZeroIndex);
        }
        return dayOfMonth + (153 * m + 2) / 5 + 365 * y + y / 4 - y / 100 + y / 400 - 32045;
    }

    public static enum DayOfWeek {
        Monday(1, "Mon", 'M'),
        Tuesday(2, "Tue", 'T'),
        Wednesday(3, "Wed", 'W'),
        Thursday(4, "Thu", 'R'),
        Friday(5, "Fri", 'F'),
        Saturday(6, "Sat", 'S'),
        Sunday(7, "Sun", 'U');

        protected int iso8601MondayFirstWeekNumber;
        protected String abbreviatedEnglishName;
        protected char abbreviationCharacter;
        protected static final DayOfWeek[] ByISO8601DayOfWeekNumber;

        static {
            DayOfWeek[] dayOfWeekArray = new DayOfWeek[8];
            dayOfWeekArray[1] = Monday;
            dayOfWeekArray[2] = Tuesday;
            dayOfWeekArray[3] = Wednesday;
            dayOfWeekArray[4] = Thursday;
            dayOfWeekArray[5] = Friday;
            dayOfWeekArray[6] = Saturday;
            dayOfWeekArray[7] = Sunday;
            ByISO8601DayOfWeekNumber = dayOfWeekArray;
        }

        private DayOfWeek(int iso8601MondayFirstWeekNumber, String abbreviatedEnglishName, char abbreviationCharacter) {
            this.iso8601MondayFirstWeekNumber = iso8601MondayFirstWeekNumber;
            this.abbreviatedEnglishName = abbreviatedEnglishName;
            this.abbreviationCharacter = abbreviationCharacter;
        }

        public int getISO8601MondayFirstDayOfWeekNumber() {
            return this.iso8601MondayFirstWeekNumber;
        }

        public int getSundayFirstDayOfWeekNumber() {
            return this.iso8601MondayFirstWeekNumber % 7 + 1;
        }

        public int getDayOfWeekNumber(DayOfWeek startingDayInWeek) {
            return DayOfWeek.modularDifference(this, startingDayInWeek);
        }

        public String getNameInEnglish() {
            return this.name();
        }

        public String getAbbreviatedEnglishName() {
            return this.abbreviatedEnglishName;
        }

        public char getAbbreviationCharacter() {
            return this.abbreviationCharacter;
        }

        public String toString() {
            return this.getNameInEnglish();
        }

        public DayOfWeek modularAddition(int adden) {
            return DayOfWeek.forISO8601DayOfWeekNumber(SmallIntegerMathUtilities.progmod(this.iso8601MondayFirstWeekNumber - 1 + adden, 7) + 1);
        }

        public static DayOfWeek forISO8601DayOfWeekNumber(int iso8601DayOfWeekNumber) {
            if (iso8601DayOfWeekNumber < 1) {
                throw new IndexOutOfBoundsException();
            }
            if (iso8601DayOfWeekNumber > 7) {
                throw new IndexOutOfBoundsException();
            }
            return ByISO8601DayOfWeekNumber[iso8601DayOfWeekNumber];
        }

        public static DayOfWeek forSundayFirstDayOfWeekNumber(int sundayFirstDayOfWeekNumber) {
            return DayOfWeek.forISO8601DayOfWeekNumber(GregorianCalendarCode.convertDayOfWeekNumberToISO8601ToMondayFirst(sundayFirstDayOfWeekNumber, Sunday));
        }

        public static DayOfWeek forDayOfWeekNumber(int sundayFirstDayOfWeekNumber, DayOfWeek startingDay) {
            return DayOfWeek.forISO8601DayOfWeekNumber(GregorianCalendarCode.convertDayOfWeekNumberToISO8601ToMondayFirst(sundayFirstDayOfWeekNumber, startingDay));
        }

        @Nonnegative
        public static int modularDifference(DayOfWeek minuend, DayOfWeek subtrahend) {
            return SmallIntegerMathUtilities.progmod(minuend.iso8601MondayFirstWeekNumber - subtrahend.iso8601MondayFirstWeekNumber, 7);
        }
    }

    public static interface GregorianFullDateObserver {
        @Nonnull
        public ContinueSignal observe(int var1, @Positive int var2, @Positive int var3, DayOfWeek var4, @Positive int var5, @Positive int var6, DayOfWeek var7, DayOfWeek var8, int var9);
    }

    public static interface GregorianFullDatePattern {
        public boolean test(int var1, @Positive int var2, @Positive int var3, DayOfWeek var4, @Positive int var5, @Positive int var6, DayOfWeek var7, DayOfWeek var8, int var9);
    }

    public static enum Month {
        January(1, 31, "Jan"),
        February(2, -1, "Feb"),
        March(3, 31, "Mar"),
        April(4, 30, "Apr"),
        May(5, 31, "May"),
        June(6, 30, "Jun"),
        July(7, 31, "Jul"),
        August(8, 31, "Aug"),
        September(9, 30, "Sep"),
        October(10, 31, "Oct"),
        November(11, 30, "Nov"),
        December(12, 31, "Dec");

        protected int monthNumber;
        protected int monthLengthExcludingFebruary;
        protected String abbreviatedEnglishName;
        protected static final Month[] ByMonthNumber;

        static {
            Month[] monthArray = new Month[13];
            monthArray[1] = January;
            monthArray[2] = February;
            monthArray[3] = March;
            monthArray[4] = April;
            monthArray[5] = May;
            monthArray[6] = June;
            monthArray[7] = July;
            monthArray[8] = August;
            monthArray[9] = September;
            monthArray[10] = October;
            monthArray[11] = November;
            monthArray[12] = December;
            ByMonthNumber = monthArray;
        }

        private Month(int monthNumber, int monthLengthExcludingFebruary, String abbreviatedEnglishName) {
            this.monthNumber = monthNumber;
            this.monthLengthExcludingFebruary = monthLengthExcludingFebruary;
            this.abbreviatedEnglishName = abbreviatedEnglishName;
        }

        public int getMonthLengthExcludingFebruary() {
            if (this == February) {
                throw new IllegalArgumentException("February isn't always the same length! :>");
            }
            return this.monthLengthExcludingFebruary;
        }

        public int getMonthLength(int year) {
            if (this == February) {
                return GregorianCalendarCode.isLeapYear(year) ? 29 : 28;
            }
            return this.monthLengthExcludingFebruary;
        }

        public int getMonthNumber() {
            return this.monthNumber;
        }

        public String getNameInEnglish() {
            return this.name();
        }

        public String toString() {
            return this.getNameInEnglish();
        }

        public String getAbbreviatedNameInEnglish() {
            return this.abbreviatedEnglishName;
        }

        public Month modularAddition(int adden) {
            return Month.forMonthNumber(SmallIntegerMathUtilities.progmod(this.monthNumber - 1 + adden, 12) + 1);
        }

        public static Month forMonthNumber(int monthNumber) {
            if (monthNumber < 1) {
                throw new IndexOutOfBoundsException();
            }
            if (monthNumber > 12) {
                throw new IndexOutOfBoundsException();
            }
            return ByMonthNumber[monthNumber];
        }

        @Nonnegative
        public static int modularDifference(Month minuend, Month subtrahend) {
            return SmallIntegerMathUtilities.progmod(minuend.monthNumber - subtrahend.monthNumber, 12);
        }
    }

    public static enum WesternEpochParity {
        BC,
        AD;

    }
}

