Attribute VB_Name = "modTranslate"
Option Explicit

Dim IgnoreList() As String
Dim Data() As String

Const begin = 0
Const count = 1

'Dim Index(255, 255, 1) As Long

Public Sub Initialize(Optional ByVal DataFile As String = "")
    Dim Line As String, Section As String, ID As String, Value As String
    Dim pos As Long, hFile As Long
    Dim NotFirstTime As Boolean
    
    Dim indx As String
    
    
    ReDim Data(1, 0)
    If DataFile = "" Then DataFile = App.Path & "\translation.txt"
    
    hFile = FreeFile
    Open DataFile For Input As hFile
    
    Do While Not EOF(hFile)
        Line Input #hFile, Line
        Line = Replace(Line, Chr(9), " ")
        If InStr(Line, "#") > 0 Then Line = Mid(Line, 1, InStr(Line, "#") - 1)
        Line = Trim(Line)
        
        If Line <> "" Then
            If Left(Line, 1) = "[" And Right(Line, 1) = "]" Then
                Section = Mid(Line, 2, Len(Line) - 2)
            Else
                pos = InStr(Line, "=")
                ID = Section & "." & Trim(Mid(Line, 1, pos - 1))
                Value = Trim(Mid(Line, pos + 1))
                If Len(Value) > 2 Then
                    Value = Mid(Value, 2, Len(Value) - 2)
                Else
                    Value = ""
                End If
                
                If NotFirstTime Then ReDim Preserve Data(1, UBound(Data, 2) + 1)
                NotFirstTime = True
                
                Data(0, UBound(Data, 2)) = ID
                Data(1, UBound(Data, 2)) = Value
    '            If Value = "Crear" Then Stop
                
              
            End If
        End If
    Loop
        
    Close hFile
    
   
    
End Sub

Public Sub AddIgnore(IgnoreList() As String)

End Sub

Public Function TranslateForm(fForm As Form) As String
    Dim i As Long
    Dim form_name As String, name_length As String
    Dim elems() As String
    Dim obj As Object
    Dim elem As String, Index As Long
    Dim errors As String
    Dim start As Double
    
    start = Timer
    form_name = fForm.Name
    name_length = Len(form_name)
    
    i = FindFirst(form_name & ".")
    
    On Error GoTo errh
    
    If i >= 0 Then
        Do While Mid(Data(0, i), 1, name_length) = form_name
            elems = Split(Data(0, i), ".")
            Select Case UBound(elems)
                Case 1
                    'Set the property of the form
                    CallByName fForm, elems(1), VbLet, Data(1, i)
                Case 2
                    CallByName fForm.Controls(elems(1)), elems(2), VbLet, Data(1, i)
                Case 3
                    'Set obj = CallByName(fForm.Controls(elems(1)), elems(2), VbGet)
                    get_index elems(2), elem, Index
                    
                    If elem <> "" Then
                        Set obj = CallByName(fForm.Controls(elems(1)), elem, VbGet)
                        CallByName obj(Index), elems(3), VbLet, Data(1, i)
                    End If
                    
                    
            End Select
            i = i + 1
            If i > UBound(Data, 2) Then Exit Do
        Loop
    End If
    Debug.Print errors
    TranslateForm = errors
    Debug.Print "Translation took " & Format(Timer - start, "0.00000") & " seconds"
    Exit Function
errh:
    errors = errors & "Error #" & Err.Number & " (" & Err.Description & ") when processing '" & Data(0, i) & "'"
    Resume Next
End Function

Public Sub get_index(text As String, elem As String, Index As Long)
    
    If InStr(text, "(") > 0 And InStr(text, ")") = Len(text) Then
        elem = Mid(text, 1, InStr(text, "(") - 1)
        Index = Val(Mid(text, InStr(text, "(") + 1, Len(text) - 1))
        'Debug.Print elem, Index
    End If
End Sub


Public Function Translate(ID As String, ParamArray replacements())
    Dim ret As String, i As Long
    ret = BinarySearch(ID)
    
    For i = 0 To UBound(replacements)
        ret = Replace(ret, "$" & Trim(Str(i)), replacements(i))
    Next
    
    Translate = ret
End Function

Private Function BinarySearch(text As String) As String

    Dim upper As Long, lower As Long, middle As Long
    Dim elem As String
    
    upper = 0
    lower = UBound(Data, 2)
    
    Do While upper <= lower
        middle = upper + ((lower - upper) / 2)
        elem = Data(0, middle)
        
        If text > elem Then
            upper = middle + 1
        ElseIf text < elem Then
            lower = middle - 1
        Else
            BinarySearch = Data(1, middle)
        '    If Data(1, middle) = "Crear" Then Stop
        '    Debug.Print text & "=" & Data(1, middle)
            Exit Function
        End If
    Loop
End Function

' This function attempts to find the first ocurrence of a partial string in an array as
' fast as possible. First it does a binary search to find the group, and then a linear
' search to find the first position

Private Function FindFirst(text As String) As Long
    
    Dim upper As Long, lower As Long, middle As Long
    Dim elem As String, matching_chars As Long
    matching_chars = Len(text)
    
    upper = 0
    lower = UBound(Data, 2)
    
    Do While upper <= lower
        middle = upper + ((lower - upper) / 2)
        
        elem = Mid(Data(0, middle), 1, matching_chars)
        
        If text > elem Then
            upper = middle + 1
        ElseIf text < elem Then
            lower = middle - 1
        Else
        
            Do
                If middle > 0 Then
                    If Mid(Data(0, middle - 1), 1, matching_chars) = text Then
                        middle = middle - 1
                    Else
                        Exit Do
                    End If
                Else
                    Exit Do
                End If
            Loop
                        
            FindFirst = middle
            
            Exit Function
        End If
    Loop
    FindFirst = -1
End Function

