Attribute VB_Name = "modSaveLoad"
Option Explicit

Public Sub LoadPositions()
    Dim hFile As Long
    Dim txtPose As String, lData As Long
    Dim lItem As ListItem
    On Error GoTo ErrH
    hFile = FreeFile()
    frmMain.lvBreed.ListItems.Clear
    Open App.Path & "\positions.txt" For Input As hFile
        Do While Not EOF(1)
            Input #hFile, txtPose
            Input #hFile, lData
            Set lItem = frmMain.lvPosition.ListItems.Add(, , txtPose)
            lItem.SubItems(1) = Str(lData)
            lItem.Tag = Str(lData)
        Loop
    Close
    Exit Sub
ErrH:
    If frmLog.chkPopupOnErrors <> 1 Then Beep
    frmLog.dLog DL_ERRORS, "LoadPositions: Error " & Err.Number & ":" & Err.Description
    frmLog.dLog DL_ERRORS, "LoadPositions: The file positions.txt is not found or is broken"
    frmLog.dLog DL_ERRORS, "LoadPositions: Fatal error. Cannot continue"
    frmLog.Show
    gFatalError = True
    
    Exit Sub
End Sub

Public Sub LoadBreedNames()
    Dim hFile As Long
    Dim lN1 As Long, lN2 As Long, sName As String
    On Error GoTo ErrH
    hFile = FreeFile()
    Open App.Path & "\breeds.txt" For Input As hFile
    Do While Not EOF(hFile)
        Input #hFile, lN1
        Input #hFile, lN2
        Input #hFile, sName
        aBreedNames(lN2, lN1) = sName
    Loop
    Close hFile
    
    Exit Sub
ErrH:
    If frmLog.chkPopupOnErrors <> 1 Then Beep
    frmLog.dLog DL_ERRORS, "LoadBreedNames: Error " & Err.Number & ":" & Err.Description
    frmLog.dLog DL_ERRORS, "LoadBreedNames: The file breeds.txt is not found or is broken"
    frmLog.dLog DL_ERRORS, "LoadBreedNames: Fatal error. Cannot continue"
    frmLog.Show
    gFatalError = True
    
    Exit Sub
    
End Sub

Public Sub SaveBreedNames()
    Dim hFile As Long
    Dim lN1 As Long, lN2 As Long, sName As String
    Dim i As Long, f As Long
    Dim pos As String
    On Error GoTo 0 'ErrH

    With frmMain.lvBreed.ListItems
    For i = 1 To .count
        sName = Trim(.Item(i).Text)
        pos = InStr(sName, "]")
        If pos > 0 Then
            .Item(i).Text = "[" & Left(.Item(i).Tag, 1) & "] " & Trim(Mid(sName, pos + 1))
            sName = Trim(Mid(sName, pos + 1))
        Else
            .Item(i).Text = "[" & Left(.Item(i).Tag, 1) & "] " & sName
        End If
        aBreedNames(Asc(Left(.Item(i).Tag, 1)) - 65, Val(Right(.Item(i).Tag, 1))) = sName
    Next
    End With
    hFile = FreeFile()
    Open App.Path & "\breeds.txt" For Output As hFile
    For i = 0 To UBound(aBreedNames, 1)
        For f = 0 To UBound(aBreedNames, 2)
            Write #hFile, f, i, aBreedNames(i, f)
        Next
    Next
    Close hFile
    
    Exit Sub
ErrH:
    If hFile <> 0 Then Close hFile
    frmLog.dLog DL_ERRORS, "SaveBreedNames: Error " & Err.Number & ":" & Err.Description
    
    Exit Sub
    
End Sub


Public Sub LoadZOrder()
    Dim hFile As Long
    Dim i As Long
    Dim lN1 As Long, lN2 As Long, lZ As Long
    On Error GoTo ErrH
    hFile = FreeFile()
    Open App.Path & "\ZOrder.txt" For Input As hFile
    Do While Not EOF(hFile)
        Input #hFile, lN1
        Input #hFile, lN2
        Input #hFile, lZ
        aZOrder(lN1, lN2) = lZ
    Loop
    
 '   For i = 0 To UBound(aZOrder, 1)
 '       aZOrder(i, 30) = 14
 '       aZOrder(i, 31) = 15
 '       aZOrder(i, 32) = 16
 '   Next

    Close hFile
    Exit Sub
ErrH:
    If frmLog.chkPopupOnErrors <> 1 Then Beep
    frmLog.dLog DL_ERRORS, "LoadZOrder: Error " & Err.Number & ":" & Err.Description
    frmLog.dLog DL_ERRORS, "LoadZOrder: The file zorder.txt is not found or is broken"
    frmLog.dLog DL_ERRORS, "LoadZOrder: Fatal error. Cannot continue"
    frmLog.Show
    gFatalError = True
    
    Exit Sub
    
End Sub

Public Sub SaveZOrder()
    Dim hFile As Long
    Dim lN1 As Long, lN2 As Long, sName As String
    Dim i As Integer
    Dim f As Integer
    On Error GoTo ErrH
    hFile = FreeFile()
    Open App.Path & "\ZOrder.txt" For Output As hFile
    For i = 0 To UBound(aZOrder, 1)
        For f = 0 To UBound(aZOrder, 2)
            Write #hFile, i, f, aZOrder(i, f)
        Next
    Next

    Close hFile
    Exit Sub
ErrH:
    frmLog.dLog DL_ERRORS, "SaveZOrder: Error " & Err.Number & ":" & Err.Description
    Exit Sub

End Sub

Public Sub SaveBreeds()
    Dim hFile As Long
    Dim i As Long


    hFile = FreeFile()
    Open App.Path & "\det_breed.txt" For Output As hFile
    With frmMain.lvBreed.ListItems
    For i = 1 To .count
        Write #hFile, .Item(i).Text, .Item(i).SubItems(1), .Item(i).SubItems(2), .Item(i).Tag
    Next
    End With
    Close hFile

    Exit Sub
ErrH:
    If hFile <> 0 Then Close hFile
    frmLog.dLog DL_ERRORS, "SaveBreeds: Error " & Err.Number & ":" & Err.Description
    Exit Sub


End Sub


Public Sub SavePigmentPresets()
    Dim hFile As Long
    Dim i As Long


    hFile = FreeFile()
    Open App.Path & "\pigments.txt" For Output As hFile
    With frmPigment.lvPresets.ListItems
    For i = 1 To .count
        Write #hFile, .Item(i).Text, .Item(i).SubItems(1), .Item(i).SubItems(2), .Item(i).SubItems(3), .Item(i).SubItems(4), .Item(i).SubItems(5), .Item(i).SubItems(6), .Item(i).SubItems(7), .Item(i).SubItems(8), .Item(i).SubItems(9), .Item(i).SubItems(10), .Item(i).SubItems(11), .Item(i).SubItems(12), .Item(i).SubItems(13), .Item(i).SubItems(14)
    Next
    End With
    Close hFile

    Exit Sub
ErrH:
    If hFile <> 0 Then Close hFile
    frmLog.dLog DL_ERRORS, "SavePigmentPresets: Error " & Err.Number & ":" & Err.Description
    Exit Sub


End Sub

Public Sub LoadPigmentPresets()
    Dim hFile As Long
    Dim i As Long
    Dim lItem As ListItem
    Dim sTemp As String
    On Error GoTo ErrH
    hFile = FreeFile()
    Open App.Path & "\pigments.txt" For Input As hFile
    With frmPigment.lvPresets.ListItems
    .Clear
    Do While Not EOF(1)
        Input #hFile, sTemp
        Set lItem = .Add(, , sTemp)
        
        For i = 1 To 14
            Input #hFile, sTemp
            lItem.SubItems(i) = sTemp
        Next
    Loop
    End With
    Close hFile

    Exit Sub
ErrH:
    If hFile <> 0 Then Close hFile
    frmLog.dLog DL_ERRORS, "LoadPigmentPresets: Error " & Err.Number & ":" & Err.Description
    Exit Sub


End Sub

Public Function LoadBreeds() As Boolean
Dim i As Long
Dim lItem As ListItem
Dim hFile As Long
Dim ret As String
Dim lNull As Long
Dim sVal As String
On Error GoTo ErrH
hFile = FreeFile()
frmMain.lvBreed.ListItems.Clear
Open App.Path & "\det_breed.txt" For Input As hFile
    
    With frmMain.lvBreed.ListItems
    Do While Not EOF(hFile)
        Input #hFile, sVal
        Set lItem = .Add(, , sVal)
        Input #hFile, sVal: lItem.SubItems(1) = sVal
        Input #hFile, sVal: lItem.SubItems(2) = sVal
        Input #hFile, sVal: lItem.Tag = sVal
    Loop
    End With
Close hFile
LoadBreeds = True
Exit Function

ErrH:
    frmMain.lvBreed.ListItems.Clear
    LoadBreeds = False
    frmLog.dLog DL_ERRORS, "LoadBreeds: Error " & Err.Number & ":" & Err.Description
    Exit Function

End Function

Public Sub LoadLogConfig()
    With frmLog
        .chkPopupOnErrors = CInt(GetSetting("Nornimator", "Log", "PopupOnErrors", .chkPopupOnErrors.Value))
        .optInit.Value = CBool(GetSetting("Nornimator", "Log", "Init", .optInit.Value))
        .optError.Value = CBool(GetSetting("Nornimator", "Log", "Error", .optError.Value))
        .optBasic.Value = CBool(GetSetting("Nornimator", "Log", "Basic", .optBasic.Value))
        .optDetailed.Value = CBool(GetSetting("Nornimator", "Log", "Detailed", .optDetailed.Value))
    End With
End Sub

Public Sub SaveConfig()
        frmLog.dLog DL_INIT, "Saving ZOrder"
        SaveZOrder
        frmLog.dLog DL_INIT, "Saving breed names"
        SaveBreedNames
        frmLog.dLog DL_INIT, "Saving breed list"
        SaveBreeds
      '  frmLog.dLog DL_INIT, "Saving pigmenting presets'"
      '  SavePigmentPresets
        frmLog.dLog DL_INIT, "Saving settings"
        
        SaveSetting "Nornimator", "Config", "C3Dir", C3Dir
        SaveSetting "Nornimator", "Config", "UseCache", frmOptions.chkUseCache.Value
        
        SaveSetting "Nornimator", "Config", "AutoSet", frmMain.chkAutosave.Value
        SaveSetting "Nornimator", "Config", "AutoRedraw", frmMain.chkAutoredraw.Value

End Sub
