Attribute VB_Name = "modGlobal"
Option Explicit
Declare Function SetPixel Lib "gdi32" (ByVal hDC As Long, ByVal X As Long, ByVal Y As Long, ByVal crColor As Long) As Long


'Pigments
Global Const PG_NONE = 0

Global Const PG_TINT = 200
Global Const PG_ROTATION = 100
Global Const PG_SWAP = 101
Global Const PG_RANGE = 201
Global Const PG_INVERT = 202
Global Const PG_MASK = 203
Global Const PG_MASK_EXCLUDE = 204

Global Const PG_RGB_BASE = 200
Global Const PG_AMOUNT_BASE = 100

'*************** C16 Data types **************************
Type typeRGB
    R As Long
    G As Long
    B As Long
End Type

Type typePigment
    Effect As Long
    rngStart As typeRGB
    rngEnd As typeRGB
    rngNStart As typeRGB
    rngNEnd As typeRGB
    sCheck As String    'This is used to check very fast the pigment.
                        'It contains all the data in a string
End Type

Type C16Header
    lFlags As Long
    iSpriteCount As Integer
End Type

Type C16SprHead
    lOffset As Long
    iWidth As Integer
    iHeight As Integer
    lLines() As Long
End Type

Type C16Sprite
    
    uHeader As C16SprHead
    iTag As Integer
    iData() As Integer
    iZeroTag As Integer
End Type

Type C16Image
    uHeader As C16Header
    uSprite() As C16Sprite
    iZero As Integer
End Type

Type typePart
    Number As Long
    Parent As Long
    pos As Long
    id As String
    IsHead As Boolean
    Symmetric As Long
End Type

Type typePartSettings
    Position As Long
    XOffset As Long
    YOffset As Long
    Gender As EnumGender
    Breed As String
    Visible As Boolean
    Pigment(31) As typePigment
    sCheck(31) As String
End Type

'Sprite cache
'Never load something if it is already loaded
Type typeSpriteCache
    uSprites() As C16Sprite
    sFile As String
    lAge As Long
End Type

Type typeImageCache
    lData() As Long
    Position As typePartSettings
    cPigment As typePigment
    lAge As Long
    EyesClosed As Long
    Expression As Long
    
End Type


Global Const ALL_OK = 0 'Universal for all the functions

'***************** ReadImage errors **********************

Enum ReadImageErrors
    RI_NO_FILE = 1                 'The file does not exits
    RI_NOT_C16 = 2                 'The file is not a C16
    RI_BAD_HEADER = 3              'C16, but wrong header
    RI_BAD_SPRITE_HEADER = 4       'Wrong sprite header
    RI_BAD_TERM_TAG = 5            'Wrong sprite run terminator
    RI_BAD_ZERO_VALUE = 6          'Wrong file zero terminator
    RI_BAD_FILELEN = 7             'The file is smaller or bigger than the size calculated from headers
End Enum

Enum EnumBodyPart
    BP_HEAD = 0
    BP_BODY = 1
    BP_LEFT_THIGH = 2
    BP_LEFT_SHIN = 3
    BP_LEFT_FOOT = 4
    BP_RIGHT_THIGH = 5
    BP_RIGHT_SHIN = 6
    BP_RIGHT_FOOT = 7
    BP_LEFT_HUMERUS = 8
    BP_LEFT_RADIUS = 9
    BP_RIGHT_HUMERUS = 10
    BP_RIGHT_RADIUS = 11
    BP_TAIL_ROOT = 12
    BP_TAIL_TIP = 13
End Enum

Enum EnumAge
    AGE_BABY = 0
    AGE_CHILD = 1
    AGE_ADOLESCENT = 2
    AGE_YOUTH = 3
    AGE_ADULT = 4
    AGE_OLD = 5
    AGE_SENILE = 6
End Enum

Enum EnumNornSpecies
    SP_BRUIN = 0
    SP_BENGAL = 1
    SP_CIVET = 2
End Enum

Enum EnumGender
    GEN_MALE_NORN = 0
    GEN_MALE_ETTIN = 1
    GEN_MALE_GRENDEL = 2
    GEN_MALE_GEAT = 3
    GEN_FEMALE_NORN = 4
    GEN_FEMALE_ETTIN = 5
    GEN_FEMALE_GRENDEL = 6
    GEN_FEMALE_GEAT = 7
End Enum

Enum enumDebugLevel
    DL_INTERNAL = 0
    DL_ERRORS = 1
    DL_INIT = 2
    DL_BASIC = 3
    DL_DETAILED = 4
End Enum
Public aNornAtt(64, 32, 16) As Long

Public aATTIndex(25, 9, 9) As Integer

Public aATTs() As Integer '(X, 16, 16, 16)
Public aZOrder(64, 32) As Long
Public aParts(64) As typePart
Public aGSex(9) As Boolean
Public aGSpecie(9) As String
Public aPartsData(64) As typePartSettings
Public aBreedNames(25, 9) As String

Public sImageDir As String
Public sAttDir As String
Public C3Dir As String

Public gFatalError As Boolean
Public gLoadFinished As Boolean
Public gNotFirstLoad As Boolean

'Cache
Public uHeads(16) As C16Header
Public uSprCache(16) As typeSpriteCache
Public uImageCache(16) As typeImageCache
