Attribute VB_Name = "modGeneral"
Option Explicit
Dim Parts() As Long
Dim Ages() As String
Dim Species() As String
Public Function GetPart(Part As Long) As String
    GetPart = Chr(65 + Part)
End Function

Public Function C3FileName(C3Dir As String, Part As EnumBodyPart, ByVal Age As EnumAge, Specie As EnumNornSpecies, Gender As EnumGender)
    Dim ret As String
    Dim AllOK As Boolean
    Dim OldAge As EnumAge
    OldAge = Age
    ret = Chr(65 + Part) + Trim(Str(Gender)) + Trim(Str(Age)) + Chr(65 + Specie)
    
    Do While Not AllOK
        If Age < AGE_BABY Then
            'If not found, return an empty string
            ret = ""
            ret = Chr(65 + Part) + Trim(Str(Gender)) + Trim(Str(OldAge)) + Chr(65 + Specie)
            Exit Do
        End If
        If (Dir(C3Dir & "\" & ret & ".c16") = "") And (Dir(C3Dir & "\" & ret & ".att") = "") Then
            Age = Age - 1
            ret = Chr(65 + Part) + Trim(Str(Gender)) + Trim(Str(Age)) + Chr(65 + Specie)
        Else
            AllOK = True
        End If
    Loop
    C3FileName = ret
End Function

Public Function C3FileNameNoAge(C3Dir As String, Part As EnumBodyPart, ByVal Age As EnumAge, Specie As EnumNornSpecies, Gender As EnumGender)
    Dim ret As String
    Dim AllOK As Boolean
    C3FileNameNoAge = Chr(65 + Part) + Trim(Str(Gender)) + Trim(Str(Age)) + Chr(65 + Specie)
End Function

Public Function DetectBreed(C3Dir As String, Part As EnumBodyPart, Specie As EnumNornSpecies, Gender As EnumGender) As Boolean
    Dim ret As String
    Dim AllOK As Boolean
    ret = Chr(65 + Part) + Trim(Str(Gender)) + "?" + Chr(65 + Specie)
    
        If Dir(C3Dir & "\" & ret & ".c16") <> "" Then
            DetectBreed = True
        Else
            DetectBreed = False
        End If
    
End Function

Public Function GetFileName(sPath As String) As String
Dim start As Long
Dim pos As Long
Dim lastpos As Long
start = 1
pos = 1
Do While pos <> 0
    pos = InStr(start, sPath, "\")
    If pos <> 0 Then
        lastpos = pos
        start = pos + 1
    Else
        Exit Do
    End If
Loop
GetFileName = Mid(sPath, lastpos + 1)
End Function
Public Sub Init()
    Dim i As Long, b As Long
    For i = 0 To UBound(aParts)
        aParts(i).Number = -1
        aParts(i).IsHead = False
        aParts(i).Symmetric = -1
    Next
    
    aParts(0).id = "Body"
    aParts(1).id = "Head"
    aParts(2).id = "Left thigh"
    aParts(3).id = "Right thigh"
    aParts(4).id = "Left humerus"
    aParts(5).id = "Right humerus"
    aParts(6).id = "Tail root"
    aParts(7).id = "Left shin"
    aParts(8).id = "Right shin"
    aParts(9).id = "Left radius"
    aParts(10).id = "Right radius"
    aParts(11).id = "Left foot"
    aParts(12).id = "Right foot"
    aParts(13).id = "Tail tip"
    aParts(0).Parent = -1
    
    aParts(2).Symmetric = 3
    aParts(3).Symmetric = 2
    
    aParts(4).Symmetric = 5
    aParts(5).Symmetric = 4
    
    aParts(7).Symmetric = 8
    aParts(8).Symmetric = 7
    
    aParts(9).Symmetric = 10
    aParts(10).Symmetric = 9
    
    aParts(11).Symmetric = 12
    aParts(12).Symmetric = 11
    
    aParts(0).Number = 1  'body
    aParts(1).Number = 0  'head
    aParts(1).IsHead = True
    aParts(2).Number = 2  'Left thigh
    aParts(3).Number = 5  'right thigh
    
    aParts(4).Number = 8  'left humerus
    aParts(5).Number = 10  'right humerus
    
    aParts(6).Number = 12  'tail root
    
    aParts(7).Number = 3 'left shin
    aParts(7).Parent = 2
    
    aParts(8).Number = 6 'right shin
    aParts(8).Parent = 3
    
    aParts(9).Number = 9 'left radius
    aParts(9).Parent = 4
    
    aParts(10).Number = 11 'right radius
    aParts(10).Parent = 5
    
    
    
    aParts(11).Number = 4 'left foot
    aParts(11).Parent = 7
    
    aParts(12).Number = 7 'right foot
    aParts(12).Parent = 8
    
    
    
    'aParts(13).Number = 6 'right tail tip
    aParts(13).Number = 13
    aParts(13).Parent = 6
    
    aParts(0).pos = -1
    aParts(1).pos = 0
    
    aParts(2).pos = 1 '1
    aParts(3).pos = 3 '3
    
    aParts(4).pos = 5
    aParts(5).pos = 7
    aParts(6).pos = 9
    
    '**********************
    aParts(0).pos = -1
    aParts(1).pos = 0
    
    aParts(2).pos = 2 '1
    aParts(3).pos = 4 '3
    
    aParts(4).pos = 6
    aParts(5).pos = 8
    aParts(6).pos = 10
    
    
    aParts(0).Parent = -1 'Body does not attach anywhere
    'First six parts attached to the body
    For i = 1 To 6
        aParts(i).Parent = 0
    Next
    
    'Init ZOrder array
    For i = 0 To UBound(aZOrder)
        For b = 0 To UBound(aZOrder, 2)
            aZOrder(i, b) = -1
        Next
    Next
    aZOrder(0, 0) = 6
    aZOrder(0, 1) = 2
    aZOrder(0, 2) = 4
    aZOrder(0, 3) = 9
    
    aZOrder(0, 4) = 0
    aZOrder(0, 5) = 1
    aZOrder(0, 6) = 5

    aZOrder(0, 7) = 3
    aZOrder(0, 8) = 7
    aZOrder(0, 9) = 8
    
    aZOrder(0, 10) = 10
    aZOrder(0, 11) = 11
    aZOrder(0, 12) = 12
    aZOrder(0, 13) = 13
    
    'aZOrder(3, 0) = 6
    'aZOrder(3, 1) = 3
    'aZOrder(3, 2) = 5
    'aZOrder(3, 3) = 10
    
    'aZOrder(3, 4) = 0
    'aZOrder(3, 5) = 1
    'aZOrder(3, 6) = 4
    'aZOrder(3, 7) = 2
    'aZOrder(3, 8) = 7
    'azorder(3,9)
    
    For b = 0 To 15
        For i = 0 To 13
            aZOrder(b, i) = aZOrder(0, i)
        Next
    Next
    
    
   ' aZOrder(0, 0) = 0
   ' aZOrder(0, 1) = 1
   ' aZOrder(0, 2) = 3
   ' aZOrder(0, 3) = 8

   'aParts(3).Parent = -1
   
'   aZOrder(0, 0) = 3
'   aZOrder(0, 1) = 8

aGSpecie(0) = "Norn"
aGSpecie(1) = "Grendel"
aGSpecie(2) = "Ettin"
aGSpecie(3) = "Geat"
aGSpecie(4) = "Norn"
aGSpecie(5) = "Grendel"
aGSpecie(6) = "Ettin"
aGSpecie(7) = "Geat"
For i = 0 To 3
    aGSex(i) = True
Next
For i = 4 To 7
    aGSex(i) = False
Next
End Sub

Public Sub DrawNorn(ByRef aData() As typePartSettings)
    Dim lX As Long
    Dim lY As Long
    Dim lImageOffset As Long
    Dim bX As Long, bY As Long
    Dim uSprites() As C16Sprite
    Dim uHead As C16Header
    Dim i As Long
    Dim Parent As Long
    Dim PartCoords(32, 1) As Long
    Dim aX As Long
    Dim aY As Long
    Dim iPose As Long
    Dim t As Long
    Dim BodyPose As Long
    Dim cx As Long
    Dim cy As Long
    Dim iIteration As Long
    Dim sFileName As String
    
    Dim nX As Long
    Dim nY As Long
    
    Dim MinX As Long
    Dim MinY As Long
    Dim MaxX As Long
    Dim MaxY As Long
    
    Dim CorrectX As Long
    Dim CorrectY As Long
    Dim MaxPart As Long
    
    Dim lSpecie As Long
    Dim lGender As Long
    
    Dim lID As Long
    Dim lPID As Long
    
    Dim uHeads(16) As C16Header
    Dim uSprCache(16) As typeSpriteCache
    Dim temp As Long
    
    Const ITER_RANGE = 0 'Iteration zero. Nothing is drawn, the picture size is calculated
    Const ITER_DRAW = 1 'The picture is drawn with the offset of the previous iteration
    
    On Error GoTo ErrH
    
    MaxX = -16777214
    MaxY = MaxX
    
    MinX = 16777215
    MinY = MinX
    BodyPose = aData(0).Position
    frmLog.dLog DL_BASIC, "DrawNorn: Drawing"
For iIteration = 0 To 1
    If iIteration = ITER_DRAW Then
        frmLog.dLog DL_BASIC, "DrawNorn: Iteration: ITER_DRAW"
        CorrectX = -MinX
        CorrectY = -MinY
        frmMain.pbDraw.Value = 0
        frmMain.pbDraw.Max = MaxPart
        If frmMain.optISAuto Then
            frmMain.picImage.Width = (MaxX + (-MinX) + Val(frmMain.txtGXOffset.Text))
            frmMain.picImage.Height = (MaxY + (-MinY) + Val(frmMain.txtGYOffset.Text))
            frmMain.picImage.ToolTipText = Str(MaxX + (-MinX) + Val(frmMain.txtGXOffset.Text)) & "x" & Trim(Str(MaxY + (-MinY) + Val(frmMain.txtGYOffset.Text)))
        
            temp = (MaxX + (-MinX) + Val(frmMain.txtGXOffset.Text)) - (frmMain.picBlank.ScaleWidth): If temp < 0 Then temp = 0
            frmMain.hscX.Max = temp
            temp = (MaxY + (-MinY) + Val(frmMain.txtGYOffset.Text)) - (frmMain.picBlank.ScaleHeight): If temp < 0 Then temp = 0
            frmMain.hscY.Max = temp
        
        ElseIf frmMain.optISBackground Then
            frmMain.picImage.Width = frmMain.bgXSize
            frmMain.picImage.Height = frmMain.bgYSize
            frmMain.picImage.ToolTipText = Trim(Str(frmMain.bgXSize)) & "x" & Trim(frmMain.bgYSize)
            
            temp = frmMain.bgXSize - (frmMain.picBlank.ScaleWidth): If temp < 0 Then temp = 0
            frmMain.hscX.Max = temp
            temp = frmMain.bgYSize - (frmMain.picBlank.ScaleHeight): If temp < 0 Then temp = 0
            frmMain.hscY.Max = temp
        
        ElseIf frmMain.optISCustom Then
            frmMain.picImage.Width = Val(frmMain.txtISXSize.Text)
            frmMain.picImage.Height = Val(frmMain.txtISYSize.Text)
            frmMain.picImage.ToolTipText = Trim(Str(Val(frmMain.txtISXSize.Text))) & "x" & Trim(Str(Val(frmMain.txtISXSize.Text)))
        
            temp = Val(frmMain.txtISXSize.Text) - (frmMain.picBlank.ScaleWidth): If temp < 0 Then temp = 0
            frmMain.hscX.Max = temp
            temp = Val(frmMain.txtISYSize.Text) - (frmMain.picBlank.ScaleHeight): If temp < 0 Then temp = 0
            frmMain.hscY.Max = temp
        
        End If

    Else
        frmLog.dLog DL_BASIC, "DrawNorn: Iteration: ITER_RANGE"
    End If

For i = 0 To UBound(aZOrder, 2)
    If aZOrder(BodyPose, i) = -1 Then Exit For
    If iIteration = ITER_RANGE Then
        MaxPart = i
    End If
   
    lSpecie = Asc(aData(aZOrder(BodyPose, i)).Breed) - 65
    lGender = aData(aZOrder(BodyPose, i)).Gender
    
    'Get the ATT id
    lID = aATTIndex(lSpecie, lGender, frmMain.cmbAge.ItemData(frmMain.cmbAge.ListIndex))
    
    lSpecie = Asc(aData(0).Breed) - 65
    lGender = aData(0).Gender
    
    'Get the ATT id
    lPID = aATTIndex(lSpecie, lGender, frmMain.cmbAge.ItemData(frmMain.cmbAge.ListIndex))
    
    iPose = aData(aZOrder(BodyPose, i)).Position
    Select Case aParts(aZOrder(BodyPose, i)).Parent
        Case -1
            bX = 0
            bY = 0
        Case 0
            bX = aATTs(lID, 0, iPose, 0)
            bY = aATTs(lID, 0, iPose, 1)
        Case Else
            bX = aATTs(lID, aParts(aParts(aZOrder(BodyPose, i)).Parent).Number, iPose, 0)
            bY = aATTs(lID, aParts(aParts(aZOrder(BodyPose, i)).Parent).Number, iPose, 1)
    End Select
  '  Debug.Print aParts(aZOrder(BodyPose, i)).id
    Select Case aParts(aZOrder(BodyPose, i)).Parent
        Case -1
            lX = 0
            lY = 0
            If iIteration = ITER_DRAW Then
                lX = CorrectX + Val(frmMain.txtGXOffset.Text)
                lY = CorrectY + Val(frmMain.txtGYOffset.Text)
            End If
        Case 0
            If iIteration = ITER_DRAW Then
                'If aParts(aZOrder(BodyPose, i)).id = "Head" Then Stop
            End If
            'lX = aATTs(lID, 1, iPose, aParts(aZOrder(BodyPose, i)).pos)
            'lY = aATTs(lID, 1, iPose, aParts(aZOrder(BodyPose, i)).pos + 1)
            
'            lX = aATTs(lID, 1, BodyPose, aParts(aZOrder(BodyPose, i)).pos)
'            lY = aATTs(lID, 1, BodyPose, aParts(aZOrder(BodyPose, i)).pos + 1)
            lX = aATTs(lPID, 1, BodyPose, aParts(aZOrder(BodyPose, i)).pos)
            lY = aATTs(lPID, 1, BodyPose, aParts(aZOrder(BodyPose, i)).pos + 1)
            
            If iIteration = ITER_DRAW Then
                lX = lX + CorrectX + Val(frmMain.txtGXOffset.Text)
                lY = lY + CorrectY + Val(frmMain.txtGYOffset.Text)
            End If
            'frmMain.picImage.PSet (CSng(lX), CSng(lY)), CLng(2)
            lX = lX - aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 0)
            lY = lY - aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 1)
            'frmMain.picImage.Circle (lX, lY), 1225, QBColor(2)
            nX = lX + aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 2)
            nY = lY + aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 3)
            
            cx = PartCoords(Parent, 0)
            cy = PartCoords(Parent, 1)
            cx = nX
            cy = nY
            'frmMain.picImage.Circle (cx, cy), 2, QBColor(11)
       
        
        Case Else
            Parent = aParts(aParts(aZOrder(BodyPose, i)).Parent).Number
            lX = PartCoords(Parent, 0) - aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 0)
            lY = PartCoords(Parent, 1) - aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 1)
            
            nX = lX + aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 2)
            nY = lY + aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 3)
            
            
         '   Debug.Print "PX: " & PartCoords(Parent, 0) & " PY: " & PartCoords(Parent, 1)
          '  Debug.Print "X: " & lX & " Y: " & lY
            

    End Select
    aX = lX
    aY = lY
    If aParts(aZOrder(BodyPose, i)).Parent <> -1 Then
    
    lX = lX + aData(aZOrder(BodyPose, i)).XOffset
    lY = lY + aData(aZOrder(BodyPose, i)).YOffset
    End If
    
    PartCoords(aParts(aZOrder(BodyPose, i)).Number, 0) = nX
    PartCoords(aParts(aZOrder(BodyPose, i)).Number, 1) = nY

   ' frmMain.picImage.Circle (aX, aY), 2, QBColor(14)
    
    If aData(aZOrder(BodyPose, i)).Visible Then
        
    '        sFileName = "f:\c3\images\" & GetPart(aParts(aZOrder(BodyPose, i)).Number) & "04b.c16"
'            lSpecie = Asc(Left(frmMain.lvBreed.SelectedItem.Tag, 1)) - 65
'            lGender = Val(Right(frmMain.lvBreed.SelectedItem.Tag, 1))
            lSpecie = Asc(aData(aZOrder(BodyPose, i)).Breed) - 65
            lGender = aData(aZOrder(BodyPose, i)).Gender
            sFileName = C3Dir & sImageDir & "\" & C3FileName(C3Dir & sImageDir, aParts(aZOrder(BodyPose, i)).Number, frmMain.cmbAge.ItemData(frmMain.cmbAge.ListIndex), lSpecie, lGender)
            sFileName = sFileName & ".c16"
    On Error Resume Next
            If aParts(aZOrder(BodyPose, i)).IsHead Then
                lImageOffset = 0
                If frmMain.chkEyesClosed Then lImageOffset = 16
                lImageOffset = lImageOffset + (frmMain.cmbFace.ItemData(frmMain.cmbFace.ListIndex) * 32)
            End If
                                
            'InitGraph sFileName, uHead, uSprites(), True
            If iIteration = ITER_RANGE Then
                InitGraph sFileName, uHeads(i), uSprCache(i).uSprites(), True
            End If
            
        If iIteration = ITER_DRAW Then
            modC16.ShowImageFromDisk sFileName, uHeads(i), uSprCache(i).uSprites(iPose + lImageOffset), frmMain.picImage, lX, lY
            'modC16.ShowImageFromDisk sFileName, uHead, uSprites(iPose + lImageOffset), frmMain.picImage, lX, lY
            
    On Error GoTo ErrH
        Else
            If MinX > lX Then MinX = lX
            If MinY > lY Then MinY = lY
            If MaxX < lX + uSprCache(i).uSprites(iPose + lImageOffset).uHeader.iWidth Then
                MaxX = lX + uSprCache(i).uSprites(iPose + lImageOffset).uHeader.iWidth
            End If
            If MaxY < lY + uSprCache(i).uSprites(iPose + lImageOffset).uHeader.iHeight Then
                MaxY = lY + uSprCache(i).uSprites(iPose + lImageOffset).uHeader.iHeight
            End If
            
            
        End If
        lImageOffset = 0
    End If
    frmMain.pbDraw.Increase 1
    DoEvents
    

Next


Next
frmLog.dLog DL_BASIC, "DrawNorn: Done."
Exit Sub
ErrH:
    frmLog.dLog DL_ERRORS, "DrawNorn: Error " & Err.Number & ":" & Err.Description
    Exit Sub

End Sub



'Public Sub OldDrawNorn2(ByRef aData() As typePartSettings)
'    Dim lX As Long
'    Dim lY As Long
'
'    Dim bX As Long, bY As Long
'    Dim uSprites() As C16Sprite
'    Dim uHead As C16Header
'    Dim i As Long
'    Dim Parent As Long
'    Dim PartCoords(32, 1) As Long
'    Dim aX As Long
'    Dim aY As Long
'    Dim iPose As Long
'    Dim t As Long
'    Dim BodyPose As Long
'    Dim cx As Long
'    Dim cy As Long
'    Dim iIteration As Long
'    Dim sFileName As String
'
'    Dim nX As Long
'    Dim nY As Long
'
'    Dim MinX As Long
'    Dim MinY As Long
'    Dim MaxX As Long
'    Dim MaxY As Long
'
'    Dim CorrectX As Long
'    Dim CorrectY As Long
'    Dim MaxPart As Long
'
'    Dim lSpecie As Long
'    Dim lGender As Long
'
'    Const ITER_RANGE = 0 'Iteration zero. Nothing is drawn, the picture size is calculated
'    Const ITER_DRAW = 1 'The picture is drawn with the offset of the previous iteration
'
'    MaxX = -16777214
'    MaxY = MaxX
'
'    MinX = 16777215
'    MinY = MinX
'For iIteration = 0 To 1
'    If iIteration = ITER_DRAW Then
'        CorrectX = -MinX
'        CorrectY = -MinY
'        frmMain.pbDraw.Value = 0
'        frmMain.pbDraw.Max = MaxPart
'    End If
'
'For i = 0 To UBound(aZOrder, 2)
'    If aZOrder(0, i) = -1 Then Exit For
'    If iIteration = ITER_RANGE Then
'        MaxPart = i
'    End If
'    iPose = aData(aZOrder(0, i)).Position
'    Select Case aParts(aZOrder(BodyPose, i)).Parent
'        Case -1
'            bX = 0
'            bY = 0
'        Case 0
'            bX = aATTs(lID, 0, iPose, 0)
'            bY = aATTs(lID, 0, iPose, 1)
'        Case Else
'            bX = aATTs(lID, aParts(aParts(aZOrder(BodyPose, i)).Parent).Number, iPose, 0)
'            bY = aATTs(lID, aParts(aParts(aZOrder(BodyPose, i)).Parent).Number, iPose, 1)
'    End Select
'    Select Case aParts(aZOrder(BodyPose, i)).Parent
'        Case -1
'            lX = 0
'            lY = 0
'            If iIteration = ITER_DRAW Then
'                lX = CorrectX + Val(frmMain.txtGXOffset.Text)
'                lY = CorrectY + Val(frmMain.txtGYOffset.Text)
'            End If
'        Case 0
'            lX = aATTs(lID, 1, iPose, aParts(aZOrder(BodyPose, i)).pos)
'            lY = aATTs(lID, 1, iPose, aParts(aZOrder(BodyPose, i)).pos + 1)
'            If iIteration = ITER_DRAW Then
'                lX = lX + CorrectX + Val(frmMain.txtGXOffset.Text)
'                lY = lY + CorrectY + Val(frmMain.txtGYOffset.Text)
'            End If
'
'            lX = lX - aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 0)
'            lY = lY - aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 1)
'
'            nX = lX + aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 2)
'            nY = lY + aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 3)
'
'            cx = PartCoords(Parent, 0)
'            cy = PartCoords(Parent, 1)
'            cx = nX
'            cy = nY
'            'frmMain.picImage.Circle (cx, cy), 2, QBColor(11)
'
'
'        Case Else
'            Parent = aParts(aParts(aZOrder(BodyPose, i)).Parent).Number
'            lX = PartCoords(Parent, 0) - aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 0)
'            lY = PartCoords(Parent, 1) - aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 1)
'
'            nX = lX + aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 2)
'            nY = lY + aATTs(lID, aParts(aZOrder(BodyPose, i)).Number, iPose, 3)
'
'
'            Debug.Print "PX: " & PartCoords(Parent, 0) & " PY: " & PartCoords(Parent, 1)
'            Debug.Print "X: " & lX & " Y: " & lY
'
'
'    End Select
'    aX = lX
'    aY = lY
'    If aParts(aZOrder(BodyPose, i)).Parent <> -1 Then
'
'    aX = aX + aData(aZOrder(BodyPose, i)).XOffset
'    aX = aX + aData(aZOrder(BodyPose, i)).YOffset
'    End If
'
'    PartCoords(aParts(aZOrder(BodyPose, i)).Number, 0) = nX
'    PartCoords(aParts(aZOrder(BodyPose, i)).Number, 1) = nY
'
'   ' frmMain.picImage.Circle (aX, aY), 2, QBColor(14)
'
'    If aData(aZOrder(0, i)).Visible Then
'        If iIteration = ITER_DRAW Then
'    '        sFileName = "f:\c3\images\" & GetPart(aParts(aZOrder(BodyPose, i)).Number) & "04b.c16"
'            lSpecie = Asc(Left(frmMain.lvBreed.SelectedItem.Tag, 1)) - 65
'            lGender = Val(Right(frmMain.lvBreed.SelectedItem.Tag, 1))
'            lSpecie = Asc(aData(aZOrder(BodyPose, i)).Breed) - 65
'            lGender = aData(aZOrder(BodyPose, i)).Gender
'            sFileName = "f:\c3\images\" & C3FileName("f:\c3\images", aParts(aZOrder(BodyPose, i)).Number, frmMain.cmbAge.ItemData(frmMain.cmbAge.ListIndex), lSpecie, lGender)
'            sFileName = sFileName & ".c16"
'    On Error Resume Next
'            InitGraph sFileName, uHead, uSprites(), True
'            modC16.ShowImageFromDisk sFileName, uHead, uSprites(iPose), frmMain.picImage, lX, lY
'    On Error GoTo 0
'        Else
'            If MinX > lX Then MinX = lX
'            If MinY > lY Then MinY = lY
'            'If MaxX < lX + uSprites(iPose).uHeader.iWidth Then
'            '    MaxX = lX + uSprites(iPose).uHeader.iWidth
'            'End If
'            'If MaxY < lY + uSprites(iPose).uHeader.iHeight Then
'            '    MaxY = lY + uSprites(iPose).uHeader.iHeight
'            'End If
'
'
'        End If
'    End If
'    frmMain.pbDraw.Increase 1
'    DoEvents
'
'
'Next
'
'
'Next
'
'End Sub
'
'
'Public Sub OldDrawNorn(iPose As Integer)
'    Dim lX As Long
'    Dim lY As Long
'    Dim bX As Long, bY As Long
'    Dim uSprites() As C16Sprite
'    Dim uHead As C16Header
'    Dim i As Long
'    Dim Parent As Long
'    Dim PartCoords(32, 1) As Long
'    Dim aX As Long
'    Dim aY As Long
'
'    Dim t As Long
'
'For i = 0 To UBound(aZOrder, 2)
'    If aZOrder(0, i) = -1 Then Exit For
'
'    Select Case aParts(aZOrder(iPose, i)).Parent
'        Case -1
'            bX = 0
'            bY = 0
'        Case 0
'            bX = aATTs(lID, 0, iPose, 0)
'            bY = aATTs(lID, 0, iPose, 1)
'        Case Else
'            bX = aATTs(lID, aParts(aParts(aZOrder(iPose, i)).Parent).Number, iPose, 0)
'            bY = aATTs(lID, aParts(aParts(aZOrder(iPose, i)).Parent).Number, iPose, 1)
'    End Select
'    Select Case aParts(aZOrder(iPose, i)).Parent
'        Case -1
'            lX = aATTs(lID, 0, iPose, 0)
'            lY = aATTs(lID, 0, iPose, 1)
'        Case 0
'            lX = (bX - aATTs(lID, aParts(aZOrder(iPose, i)).Number, iPose, 0)) + aATTs(lID, 1, iPose, aParts(aZOrder(iPose, i)).pos)
'            lY = (bY - aATTs(lID, aParts(aZOrder(iPose, i)).Number, iPose, 1)) + aATTs(lID, 1, iPose, aParts(aZOrder(iPose, i)).pos + 1)
'
'        Case Else
'            Parent = aParts(aParts(aZOrder(iPose, i)).Parent).Number
'            lX = PartCoords(Parent, 0) - aATTs(lID, aParts(aZOrder(iPose, i)).Number, iPose, 0)
'            lY = PartCoords(Parent, 1) - aATTs(lID, aParts(aZOrder(iPose, i)).Number, iPose, 1)
'            Debug.Print "PX: " & PartCoords(Parent, 0) & " PY: " & PartCoords(Parent, 1)
'            Debug.Print "X: " & lX & " Y: " & lY
'
'    End Select
'    aX = lX
'    aY = lY
'    aX = aX + aATTs(lID, aParts(aZOrder(iPose, i)).Number, 0, 2) '- aATTs(lID,aParts(aZOrder(iPose, i)).Number, 0, 0)
'    aY = aY + aATTs(lID, aParts(aZOrder(iPose, i)).Number, 0, 3) '- aATTs(lID,aParts(aZOrder(iPose, i)).Number, 0, 1)
'
'    PartCoords(aParts(aZOrder(iPose, i)).Number, 0) = aX
'    PartCoords(aParts(aZOrder(iPose, i)).Number, 1) = aY
'    InitGraph "f:\c3\images\" & GetPart(aParts(aZOrder(iPose, i)).Number) & "04b.c16", uHead, uSprites(), True
'    modC16.ShowImageFromDisk "f:\c3\images\" & GetPart(aParts(aZOrder(iPose, i)).Number) & "04b.c16", uHead, uSprites(iPose), frmMain.picImage, lX, lY
'    DoEvents
'    t = Timer
'
'Next
'
'End Sub

Public Sub GenerateTree()
    Dim i As Long
    Dim bAdded As Boolean
    Dim lNode As Node
    On Error GoTo ErrH
    With frmMain.tvParts
        .Nodes.Clear
        For i = 0 To UBound(aParts)
            If aParts(i).Number = -1 Then Exit For
            If aParts(i).Parent = -1 Then
                Set lNode = .Nodes.Add(, , aParts(i).id, aParts(i).id)
                lNode.Tag = Trim(Str(i))
            End If
        Next
        
        Do
            bAdded = False
            For i = 0 To UBound(aParts)
                If aParts(i).Number = -1 Then Exit For
                If aParts(i).Parent >= 0 Then
                    If FoundInTree(aParts(aParts(i).Parent).id) Then
                        If Not FoundInTree(aParts(i).id) Then
                            Set lNode = .Nodes.Add(aParts(aParts(i).Parent).id, tvwChild, aParts(i).id, aParts(i).id)
                            lNode.Tag = Trim(Str(i))
                            bAdded = True
                            
                        End If
                    End If
                End If
            Next
            If Not bAdded Then Exit Do
        Loop
        
        For i = 1 To .Nodes.count
            .Nodes(i).Expanded = True
        Next
    End With
    Exit Sub
ErrH:
    frmLog.dLog DL_ERRORS, "GenerateTree: Error " & Err.Number & ":" & Err.Description
    Exit Sub

End Sub

Public Function FoundInTree(id As String) As Boolean
    On Error GoTo ErrH
    
    frmMain.tvParts.Nodes(id).Tag = frmMain.tvParts.Nodes(id).Tag
    FoundInTree = True
    Exit Function
ErrH:
    FoundInTree = False
    Exit Function
End Function

Public Sub LocateBreeds()
Dim i As Long
Dim f As Long
Dim count As Long
Dim lItem As ListItem
Dim hFile As Long
Dim ret As String
Dim sDbg As String

On Error GoTo ErrH
    For f = 0 To 25
        For i = 0 To 7
            
            'If C3FileName("f:\c3\images", BP_HEAD, AGE_SENILE, f, i) <> "" Then
            sDbg = "I was detecting: " & f & "," & i
            If DetectBreed(C3Dir & sImageDir, BP_HEAD, f, i) Then
                Set lItem = frmMain.lvBreed.ListItems.Add(, , "[" & Chr(65 + f) & "] " & aBreedNames(f, i))
                If aGSex(i) Then
                    lItem.SubItems(1) = "Male"
                Else
                    lItem.SubItems(1) = "Female"
                End If
                lItem.SubItems(2) = aGSpecie(i)
                lItem.Tag = Trim(Chr(65 + f)) & Trim(Str(i))
                'Debug.Print Chr(65 + f), i
                'frmMain.cmbBreed.AddItem aGenderNames(i) & " SLOT " & Chr(65 + f)
            End If
        Next
        frmSplash.pbProgress.Increase 1
        DoEvents
    Next
    sDbg = "I was saving to " & App.Path & "\det_breed.txt"
    hFile = FreeFile()
    Open App.Path & "\det_breed.txt" For Output As hFile
    With frmMain.lvBreed.ListItems
    For i = 1 To .count
        Write #hFile, .Item(i).Text, .Item(i).SubItems(1), .Item(i).SubItems(2), .Item(i).Tag
    Next
    End With
    Close hFile

    Exit Sub
ErrH:
    If hFile <> 0 Then Close hFile
    frmLog.dLog DL_ERRORS, "LocateBreeds: Error " & Err.Number & ":" & Err.Description
    frmLog.dLog DL_ERRORS, "LocateBreeds: " & sDbg
    Exit Sub

End Sub

Public Function SaveArray(sFile, aArray() As Integer) As Boolean
    Dim hFile As Long, i As Integer
    On Error GoTo ErrH
    hFile = FreeFile
    Open sFile For Binary As hFile
        'For i = 0 To 15
        Put hFile, , aArray()
        'Next
    Close hFile
    SaveArray = True
    Exit Function
ErrH:
    If hFile <> 0 Then Close hFile
    SaveArray = False
End Function

Public Function SaveArray4(sFile, aArray() As Integer) As Boolean
    Dim hFile As Long, i As Integer, lDim As Long
    On Error GoTo ErrH
    hFile = FreeFile
    Open sFile For Binary As hFile
        'For i = 0 To 15
        lDim = UBound(aArray, 1)
        Put hFile, , lDim
        lDim = UBound(aArray, 2)
        Put hFile, , lDim
        lDim = UBound(aArray, 3)
        Put hFile, , lDim
        lDim = UBound(aArray, 4)
        Put hFile, , lDim
        
        Put hFile, , aArray()
        'Next
    Close hFile
    SaveArray4 = True
    Exit Function
ErrH:
    If hFile <> 0 Then Close hFile
    SaveArray4 = False
End Function

Public Function LoadArray4(sFile, aArray() As Integer) As Boolean
    Dim hFile As Long
    Dim lDim1 As Long
    Dim lDim2 As Long
    Dim lDim3 As Long
    Dim lDim4 As Long
    
    On Error GoTo ErrH
    hFile = FreeFile
    Open sFile For Binary As hFile
        Get hFile, , lDim1
        Get hFile, , lDim2
        Get hFile, , lDim3
        Get hFile, , lDim4
        ReDim aArray(lDim1, lDim2, lDim3, lDim4)
        Get hFile, , aArray()
    Close hFile
    LoadArray4 = True
    Exit Function
ErrH:
    If hFile <> 0 Then Close hFile
    LoadArray4 = False
End Function

Public Function LoadArray(sFile, aArray() As Integer) As Boolean
    Dim hFile As Long
   
    On Error GoTo ErrH
    hFile = FreeFile
    Open sFile For Binary As hFile
        Get hFile, , aArray()
    Close hFile
    LoadArray = True
    Exit Function
ErrH:
    If hFile <> 0 Then Close hFile
    LoadArray = False
End Function

Public Function DetectC3(sDir As String) As Boolean

If sDir <> "" Then
    If Right(sDir, 1) = "\" Then
        sDir = Mid(sDir, 1, Len(sDir) - 1)
    End If

    On Error GoTo ErrH
    Open sDir & sAttDir & "C3Detect.TMP" For Output As #1
    Close #1
    Kill sDir & sAttDir & "C3Detect.TMP"

    DetectC3 = True
Else
    DetectC3 = False
End If
Exit Function
ErrH:
    DetectC3 = False
End Function

Public Function CountFiles(sMask As String, lAttr As VbFileAttribute) As Long
    Dim count As Long, ret As String
    On Error GoTo ErrH
    
    ret = Dir(sMask, lAttr)
    Do While ret <> ""
        count = count + 1
        ret = Dir
    Loop
    CountFiles = count
    Exit Function
ErrH:
    CountFiles = count
    frmLog.dLog DL_ERRORS, "CountFiles: Error " & Err.Number & ": " & Err.Description
    Exit Function
End Function

Public Function CountChecked(tvTree As TreeView) As Long
Dim i As Long, count As Long
For i = 1 To tvTree.Nodes.count
    If tvTree.Nodes(i).Selected = True Or tvTree.Nodes(i).Checked = True Then
        count = count + 1
    End If
Next
CountChecked = count
End Function
