Attribute VB_Name = "modC16"
Option Explicit


'This function reads a C1 graphic from disk and places
'it in a structure. It returns an error code if something goes wrong
'Set blnErrorCheck to true to enable file checking, but degrading performance
'If it is not enabled, the function will read almost any stuff, sometimes with really
'bad results.
Public Function InitGraph(strFile As String, ByRef C16Header As C16Header, C16Sprite() As C16Sprite, blnDoErrorCheck As Boolean) As Integer
    Dim hImage As Integer
    Dim h As C16Header
    Dim i As Long
    Dim iZero As Integer
    hImage = FreeFile()
    On Error GoTo ErrH
    If Dir(strFile, vbArchive + vbHidden + vbReadOnly + vbNormal) = "" Then
        'Debug.Print "InitGraph: " & strFile & " not found!"
        frmLog.dLog DL_DETAILED, "InitGraph: " & strFile & " not found"
        Exit Function
    End If
    
    Open strFile For Binary As hImage
        'Debug.Print "ReadImage: Reading header..."
        Get hImage, , C16Header 'Get header
        ReDim C16Sprite(C16Header.iSpriteCount) 'Allocate space for sprites
        'Debug.Print "ReadImage: Reading " & C16Header.iSpriteCount & " sprite headers..."
        
        'Read all headers for slightly better performance later
        For i = 0 To C16Header.iSpriteCount
            ReadHeader hImage, C16Sprite(i)
        Next
        Seek hImage, LOF(hImage) - 2
        Get hImage, , iZero
        If iZero <> 0 Then
            'Debug.Print "ReadImage: Wrong terminator! Should be zero. Value: 0x" & Hex(iZero)
            frmLog.dLog DL_ERRORS, "ReadImage: Wrong terminator! Should be zero. Value: 0x" & Hex(iZero)
            frmLog.dLog DL_ERRORS, "ReadImage: I was working with " & strFile
            InitGraph = RI_BAD_ZERO_VALUE
        Else
         '   Debug.Print "ReadImage: All done!"
        End If
    Close hImage
    
    Exit Function
ErrH:
    If hImage <> 0 Then Close hImage
    frmLog.dLog DL_ERRORS, "InitGraph: Error " & Err.Number & ":" & Err.Description
    frmLog.dLog DL_ERRORS, "InitGraph: I was working with " & strFile
    Exit Function

End Function

'Head reader
'reads a sprite head. I prefer to divide the code into small chunks, as
'the calling of this function shouldn't be too frequent. By default headers
'will be read only at program start

Private Sub ReadHeader(hFile, ByRef C16Sprite As C16Sprite)
    'Dim CurrPos As Long
'    CurrPos = Loc(hFile)
    Dim a As Long
    With C16Sprite.uHeader 'Why do I see lots of programs without this?
        'Get the basic data
        Get hFile, , .lOffset
        Get hFile, , .iWidth
        Get hFile, , .iHeight
        
        'Do not read lines buffer if the image is zero lines high.
        'I don't know if this appears in some image, but I put this
        'anyway to be sure that the program won't fail in this case
        If .iHeight > 0 Then
            ReDim .lLines(.iHeight - 2) 'Allocate space for the lines offsets
            Get hFile, , .lLines()      'And read the lines buffer
        End If
        
    End With
    Exit Sub
ErrH:
    frmLog.dLog DL_ERRORS, "ReadHeader: Error " & Err.Number & ":" & Err.Description
    Exit Sub

End Sub

Public Function ShowImageFromDisk(sFile As String, ByRef uHeader As C16Header, ByRef uSprite As C16Sprite, pPicture As PictureBox, lX As Long, lY As Long)
    Dim hFile As Integer
    Dim lTag As Integer
    Dim i As Long, f As Long
    Dim lRunLength As Long
    Dim iBuffer() As Integer
    Dim lColor As Long
    Dim lR_MASK As Integer
    Dim lG_MASK As Integer
    Dim lB_MASK As Integer
    Dim x As Long, y As Long
    Dim DivG As Long
    Dim c As Long
    Dim PrevWasTransparent As Boolean
    Dim lR As Long, lG As Long, lB As Long
    Dim hLog As Long
    Dim DivR As Long
    DivR = 128
    If Dir(sFile, vbArchive + vbHidden + vbReadOnly + vbNormal) = "" Then
        'Debug.Print "ShowImageFromDisk: " & sFile & " not found!"
        frmLog.dLog DL_DETAILED, "ShowImageFromDisk: " & sFile & " not found!"
        Exit Function
    End If
    'Debug.Print "Loading " & sFile & "(" & uSprite.uHeader.iWidth & "x" & uSprite.uHeader.iHeight; ") image..."
    hFile = FreeFile()
    
        '555 Format
        DivG = 4
        On Error Resume Next
        lR_MASK = 0
        lB_MASK = SetBit32(lB_MASK, 0, True)
        lB_MASK = SetBit32(lB_MASK, 1, True)
        lB_MASK = SetBit32(lB_MASK, 2, True)
        lB_MASK = SetBit32(lB_MASK, 3, True)
        lB_MASK = SetBit32(lB_MASK, 4, True)

        
        lG_MASK = SetBit32(lG_MASK, 5, True)
        lG_MASK = SetBit32(lG_MASK, 6, True)
        lG_MASK = SetBit32(lG_MASK, 7, True)
        lG_MASK = SetBit32(lG_MASK, 8, True)
        lG_MASK = SetBit32(lG_MASK, 9, True)
        
        lR_MASK = SetBit32(lR_MASK, 11, True)
        lR_MASK = SetBit32(lR_MASK, 12, True)
        lR_MASK = SetBit32(lR_MASK, 13, True)
        lR_MASK = SetBit32(lR_MASK, 14, True)
        lR_MASK = SetBit32(lR_MASK, 15, True)
 '       If uHeader.lFlags <> 2 Then Stop
    If GetBit32(uHeader.lFlags, 0) Then
        '565 format
        lG_MASK = SetBit32(lG_MASK, 10, True)
        DivG = 8
        lR_MASK = -2048 ' 63488
        DivR = 256
        
    End If
    On Error GoTo ErrH
    With uSprite.uHeader
        Open sFile For Binary As hFile
       ' hLog = FreeFile()
       ' Open App.Path & "\pdata" For Output As hLog
            Seek hFile, .lOffset + 1
            Get hFile, , lTag
            'Debug.Print GetBit32(lTag, 0), lTag And 1
            lRunLength = (lTag And 65534) \ 2 'Remove bit 0 and right shift
            
            
            If (lTag And 1) = 1 Then 'If not transparent
                ReDim iBuffer(lRunLength - 1)
                Get hFile, , iBuffer()

                For f = 0 To lRunLength - 1
                    lR = (iBuffer(f) And lR_MASK) / DivR
                    lG = (iBuffer(f) And lG_MASK) / DivG
                    lB = (iBuffer(f) And lB_MASK) * 8
              '      Print #hLog, iBuffer(f), lR, lG, lB
                    'lColor = RGB(lR, lG, lB)
                    lColor = 65536 * lB + 256 * lG + lR
                  '  pPicture.PSet (lX + x, lY + y), lColor
                    SetPixel pPicture.hdc, lX + x, lY + y, lColor
                    x = x + 1
                    If x >= uSprite.uHeader.iWidth Then x = 0: y = y + 1
                Next
            Else
                PrevWasTransparent = True

                x = x + lRunLength
                Do While x > uSprite.uHeader.iWidth
                    x = x - uSprite.uHeader.iWidth
                    y = y + 1
                Loop
            End If
            
        '    Debug.Print .lLines(.iHeight - 2) + .iWidth
            Do While Loc(hFile) < .lLines(.iHeight - 2) ' + .iWidth
'                If PrevWasTransparent = False Then
'          '          Seek hFile, .lLines(i - 1) + 1
'                End If
                PrevWasTransparent = False
                Get hFile, , lTag
         
                lRunLength = (lTag And 65534) \ 2 'Remove bit 0 and right shift
                c = c + lRunLength
                If (lTag And 1) = 1 Then 'If not transparent
                    ReDim iBuffer(lRunLength - 1)
                    Get hFile, , iBuffer()

                    For f = 0 To lRunLength - 1
                        lR = (iBuffer(f) And lR_MASK) / DivR
                        lG = (iBuffer(f) And lG_MASK) / DivG
                        lB = (iBuffer(f) And lB_MASK) * 8
                     '   Print #hLog, iBuffer(f), lR, lG, lB
                        'lColor = RGB(lR, lG, lB)
                        lColor = 65536 * lB + 256 * lG + lR
                       ' pPicture.PSet (lX + x, lY + y), RGB(lR, lG, lB)
                        SetPixel pPicture.hdc, lX + x, lY + y, lColor
                        x = x + 1
                        If x >= uSprite.uHeader.iWidth Then x = 0: y = y + 1
                    Next

                Else
                    PrevWasTransparent = True
                    x = x + lRunLength
                    Do While x > uSprite.uHeader.iWidth
                        x = x - uSprite.uHeader.iWidth
                        y = y + 1
                    Loop
                End If
            Loop
        Close hFile
    End With
  '  Debug.Print c
    If x <> uSprite.uHeader.iWidth Or y <> uSprite.uHeader.iHeight Then
      '  Debug.Print "Warning! Wrong picture size (" & x & "x" & y & ")"
    End If
    If frmMain.picImage.AutoRedraw Then pPicture.Refresh
   ' Close hLog
    Exit Function
ErrH:
    If Err.Number = 480 Then
        frmLog.dLog DL_ERRORS, "ShowImageFromDisk: Error " & Err.Number & ":" & Err.Description
        frmLog.dLog DL_ERRORS, "ShowImageFromDisk: Not enough memory for AutoRedraw. Disabling."
        frmMain.picImage.AutoRedraw = False
        Resume
    End If
    If hFile <> 0 Then Close hFile
    frmLog.dLog DL_ERRORS, "ShowImageFromDisk: Error " & Err.Number & ":" & Err.Description
    Exit Function

End Function
