VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "Mscomctl.ocx"
Begin VB.Form frmLog 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Log"
   ClientHeight    =   4230
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7470
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   ScaleHeight     =   4230
   ScaleWidth      =   7470
   StartUpPosition =   2  'CenterScreen
   Begin VB.CheckBox chkPopupOnErrors 
      Caption         =   "Popup on errors"
      Height          =   195
      Left            =   60
      TabIndex        =   7
      ToolTipText     =   "If you check this, the log window will appear automatically if an error occurs"
      Top             =   3960
      Value           =   1  'Checked
      Width           =   1635
   End
   Begin VB.CommandButton cmdClose 
      Caption         =   "Close"
      Height          =   375
      Left            =   6300
      TabIndex        =   6
      Top             =   3840
      Width           =   1155
   End
   Begin MSComctlLib.ListView lvLog 
      Height          =   3015
      Left            =   60
      TabIndex        =   5
      Top             =   780
      Width           =   7395
      _ExtentX        =   13044
      _ExtentY        =   5318
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   0   'False
      AllowReorder    =   -1  'True
      FullRowSelect   =   -1  'True
      _Version        =   393217
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   2
      BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         Text            =   "Message"
         Object.Width           =   10760
      EndProperty
      BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
         SubItemIndex    =   1
         Text            =   "Time"
         Object.Width           =   1764
      EndProperty
   End
   Begin VB.Frame Frame1 
      Caption         =   "Debug level"
      Height          =   675
      Left            =   60
      TabIndex        =   0
      Top             =   60
      Width           =   7395
      Begin VB.OptionButton optDetailed 
         Caption         =   "Detailed"
         Height          =   255
         Left            =   3720
         TabIndex        =   4
         ToolTipText     =   "Detailed debug messages are shown in cyan"
         Top             =   360
         Width           =   1395
      End
      Begin VB.OptionButton optBasic 
         Caption         =   "Basic"
         Height          =   255
         Left            =   2820
         TabIndex        =   3
         ToolTipText     =   "Basic debug messages are shown in black"
         Top             =   360
         Width           =   795
      End
      Begin VB.OptionButton optInit 
         Caption         =   "Init"
         Height          =   255
         Left            =   2100
         TabIndex        =   2
         ToolTipText     =   "Init messages are shown in green"
         Top             =   360
         Value           =   -1  'True
         Width           =   555
      End
      Begin VB.OptionButton optError 
         Caption         =   "Error messages only"
         Height          =   195
         Left            =   120
         TabIndex        =   1
         ToolTipText     =   "Error messages are shown in red"
         Top             =   360
         Width           =   1755
      End
   End
End
Attribute VB_Name = "frmLog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdClose_Click()
    If Not gFatalError Then
        Me.Hide
    Else
        Unload frmSplash
        Unload frmMain
        Unload frmZOrder
        Unload Me
    End If
    SaveLogConfig
End Sub

Public Sub dLog(uDebugLevel As enumDebugLevel, msgMessage As String)
    Dim CurrentDL As enumDebugLevel
    Dim lItem As ListItem
    Dim hFile As Long
    
    On Error GoTo ErrH
    CurrentDL = DL_INTERNAL
    
    If optError.Value Then
        CurrentDL = DL_ERRORS
    ElseIf optInit.Value Then
        CurrentDL = DL_INIT
    ElseIf optBasic.Value Then
        CurrentDL = DL_BASIC
    ElseIf optDetailed.Value Then
        CurrentDL = DL_DETAILED
    End If
    If uDebugLevel <= CurrentDL Then
        Set lItem = lvLog.ListItems.Add(, , msgMessage)
        lItem.SubItems(1) = CStr(Time)
        Select Case uDebugLevel
            Case DL_INTERNAL
                lItem.ForeColor = QBColor(1)
            Case DL_ERRORS
                lItem.ForeColor = QBColor(4)
                If chkPopupOnErrors.Value = 1 Then
                    Beep
                    Me.Show
                End If
            Case DL_INIT
                lItem.ForeColor = QBColor(2)
            Case DL_BASIC
                lItem.ForeColor = QBColor(0)
            Case DL_DETAILED
                lItem.ForeColor = QBColor(3)
        End Select
        
        hFile = FreeFile()
        Open App.Path & "\nornimator.log" For Append As hFile
        Print #hFile, "[" & uDebugLevel & "] " & Time, msgMessage
        Close hFile
        Debug.Print Time, msgMessage
    End If
    Exit Sub
ErrH:
    Debug.Print "LOG: Error " & Err.Number & ": " & Err.Description
    Exit Sub
End Sub

Private Sub Form_Load()
    chkPopupOnErrors = CInt(GetSetting("Nornimator", "Log", "PopupOnErrors", chkPopupOnErrors.Value))
    optInit.Value = CBool(GetSetting("Nornimator", "Log", "Init", optInit.Value))
    optError.Value = CBool(GetSetting("Nornimator", "Log", "Error", optError.Value))
    optBasic.Value = CBool(GetSetting("Nornimator", "Log", "Basic", optBasic.Value))
    optDetailed.Value = CBool(GetSetting("Nornimator", "Log", "Detailed", optDetailed.Value))
End Sub

Private Sub Form_QueryUnload(Cancel As Integer, UnloadMode As Integer)
    If Not gFatalError Then
        If UnloadMode = vbFormControlMenu Then
            Cancel = 1
            Me.Hide
        End If
    Else
        Unload frmSplash
        Unload frmMain
        Unload frmZOrder
        Unload Me
    End If
    SaveLogConfig
End Sub

Private Sub SaveLogConfig()
    SaveSetting "Nornimator", "Log", "PopupOnErrors", chkPopupOnErrors.Value
    SaveSetting "Nornimator", "Log", "Init", optInit.Value
    SaveSetting "Nornimator", "Log", "Error", optError.Value
    SaveSetting "Nornimator", "Log", "Basic", optBasic.Value
    SaveSetting "Nornimator", "Log", "Detailed", optDetailed.Value
End Sub
