;NSIS Modern User Interface version 1.63
;Basic Example Script
;Written by Joost Verburg

!define MUI_PRODUCT "Creatures Sprite Finder" ;Define your own software name here
!define MUI_VERSION "1.0.4" ;Define your own software version here

!include "MUI.nsh"
!include "Sections.nsh"

!include "common.nsh"
!include "vbruntime.nsh"

!define VLIBDIR "..\..\ds_fuentes\VLib"
!define CLIBDIR "..\..\C16Lib"

;--------------------------------
;Configuration

  ;General
  OutFile "CreaturesSpriteFinder.exe"

  ;Folder selection page
  InstallDir "$PROGRAMFILES\CreaturesSpriteFinder"
  
  ;Remember install folder
  InstallDirRegKey HKCU "Software\${MUI_PRODUCT}" ""

;--------------------------------
;Modern UI Configuration

; !define MUI_LICENSEPAGE
; !define MUI_COMPONENTSPAGE
  !define MUI_DIRECTORYPAGE
  
  !define MUI_ABORTWARNING
  
  !define MUI_UNINSTALLER
  !define MUI_UNCONFIRMPAGE
  
;--------------------------------
;Languages
 
  !insertmacro MUI_LANGUAGE "English"
  
;--------------------------------
;Language Strings

  ;Description
;  LangString DESC_SecCopyUI ${LANG_SPANISH} "Programas de DS"

;--------------------------------
;Data
  
;  LicenseData "${NSISDIR}\Contrib\Modern UI\License.txt"

;--------------------------------
;Installer Sections

Section "Sprite Finder"
  SectionIn RO

  !insertmacro UpgradeDLL ${VLIBDIR}\VLib2.dll         $SYSDIR\VLib2.dll
  !insertmacro UpgradeDLL ${CLIBDIR}\C16FileReader.dll $SYSDIR\C16FileReader.dll

  # skip shared count increasing if already done once for this application
  IfFileExists $INSTDIR\SpriteFinder.exe skipAddShared

  Push $SYSDIR\VLib2.dll
  Call AddSharedDLL


  Push $SYSDIR\C16FileReader.dll
  Call AddSharedDLL

skipAddShared:

  SetOutPath "$INSTDIR"
  File "..\source\SpriteFinder.exe"
  File "..\source\SpriteFinder.reg"
  File "..\source\ChangeLog.txt"
  File "..\source\AddingNewBreeds.txt"
  File "..\source\LICENSE.txt"

  EXEC '$WINDIR\regedit.exe /s "$INSTDIR\SpriteFinder.reg"'
    
  SetOutPath "$SMPROGRAMS\Creatures Sprite Finder\"
  CreateShortcut "$SMPROGRAMS\Creatures Sprite Finder\Sprite Finder.lnk"     "$INSTDIR\SpriteFinder.exe"
  CreateShortcut "$SMPROGRAMS\Creatures Sprite Finder\Change log.lnk"        "$INSTDIR\ChangeLog.txt"
  CreateShortcut "$SMPROGRAMS\Creatures Sprite Finder\Adding new breeds.lnk" "$INSTDIR\AddingNewBreeds.txt"
  CreateShortcut "$SMPROGRAMS\Creatures Sprite Finder\License.lnk"           "$INSTDIR\LICENSE.txt"

  ;Create uninstaller
  WriteUninstaller "$INSTDIR\Uninstall.exe"

  CreateShortcut "$SMPROGRAMS\Creatures Sprite Finder\Uninstall.lnk" "$INSTDIR\Uninstall.exe"

SectionEnd

;Display the Finish header
;Insert this macro after the sections if you are not using a finish page
!insertmacro MUI_SECTIONS_FINISHHEADER

;--------------------------------
;Descriptions

;!insertmacro MUI_FUNCTIONS_DESCRIPTION_BEGIN
;  !insertmacro MUI_DESCRIPTION_TEXT ${SecCopyUI} $(DESC_SecCopyUI)
;!insertmacro MUI_FUNCTIONS_DESCRIPTION_END
 
;--------------------------------
;Uninstaller Section

Section "Uninstall"

  Delete "$INSTDIR\SpriteFinder.exe"
  Delete "$INSTDIR\SpriteFinder.reg"

  RMDir "$INSTDIR"

  Delete "$SMPROGRAMS\Creatures Sprite Finder\Sprite Finder.lnk"
  Delete "$SMPROGRAMS\Creatures Sprite Finder\Uninstall.lnk"
  Delete "$SMPROGRAMS\Creatures Sprite Finder\Change log.lnk"
  Delete "$SMPROGRAMS\Creatures Sprite Finder\Adding new breeds.lnk"
  Delete "$SMPROGRAMS\Creatures Sprite Finder\License.lnk"

  RMDir  "$SMPROGRAMS\Creatures Sprite Finder"

  DeleteRegKey /ifempty HKCU "Software\${MUI_PRODUCT}"
  DeleteRegKey HKCU "Software\VB and VBA Program Settings\CreaturesSpriteFinder"
  
  ;Display the Finish header
  !insertmacro MUI_UNFINISHHEADER

SectionEnd

