VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.0#0"; "MSCOMCTL.OCX"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Creatures Sprite Finder"
   ClientHeight    =   7890
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   10500
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   526
   ScaleMode       =   3  'Pixel
   ScaleWidth      =   700
   StartUpPosition =   3  'Windows Default
   Begin VB.Frame Frame6 
      Caption         =   "Preview"
      Height          =   3675
      Left            =   7500
      TabIndex        =   26
      Top             =   3780
      Width           =   2955
      Begin VB.HScrollBar scrPreview 
         Height          =   255
         LargeChange     =   10
         Left            =   120
         Max             =   0
         TabIndex        =   28
         Top             =   2940
         Width           =   2715
      End
      Begin VB.PictureBox picPreview 
         AutoRedraw      =   -1  'True
         Height          =   2715
         Left            =   120
         ScaleHeight     =   2655
         ScaleWidth      =   2655
         TabIndex        =   27
         Top             =   240
         Width           =   2715
      End
      Begin VB.Label lblMaxImages 
         Caption         =   "0"
         Height          =   195
         Left            =   1500
         TabIndex        =   32
         Top             =   3240
         Width           =   495
      End
      Begin VB.Label Label4 
         Caption         =   "of"
         Height          =   195
         Left            =   1260
         TabIndex        =   31
         Top             =   3240
         Width           =   375
      End
      Begin VB.Label lblCurImage 
         Caption         =   "0"
         Height          =   195
         Left            =   720
         TabIndex        =   30
         Top             =   3240
         Width           =   495
      End
      Begin VB.Label Label2 
         Caption         =   "Image"
         Height          =   195
         Left            =   180
         TabIndex        =   29
         Top             =   3240
         Width           =   675
      End
   End
   Begin MSComctlLib.StatusBar StatusBar 
      Align           =   2  'Align Bottom
      Height          =   315
      Left            =   0
      TabIndex        =   13
      Top             =   7575
      Width           =   10500
      _ExtentX        =   18521
      _ExtentY        =   556
      _Version        =   393216
      BeginProperty Panels {8E3867A5-8586-11D1-B16A-00C0F0283628} 
         NumPanels       =   1
         BeginProperty Panel1 {8E3867AB-8586-11D1-B16A-00C0F0283628} 
            AutoSize        =   1
            Object.Width           =   18468
         EndProperty
      EndProperty
   End
   Begin VB.Frame Frame5 
      Caption         =   "Files"
      Height          =   3675
      Left            =   120
      TabIndex        =   11
      Top             =   3780
      Width           =   7275
      Begin MSComctlLib.ListView lvFiles 
         Height          =   3255
         Left            =   120
         TabIndex        =   12
         Top             =   240
         Width           =   6975
         _ExtentX        =   12303
         _ExtentY        =   5741
         View            =   3
         LabelEdit       =   1
         Sorted          =   -1  'True
         MultiSelect     =   -1  'True
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         OLEDragMode     =   1
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         OLEDragMode     =   1
         NumItems        =   5
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "File"
            Object.Width           =   1693
         EndProperty
         BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   1
            Text            =   "Part"
            Object.Width           =   2028
         EndProperty
         BeginProperty ColumnHeader(3) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   2
            Text            =   "Gender"
            Object.Width           =   2028
         EndProperty
         BeginProperty ColumnHeader(4) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   3
            Text            =   "Age"
            Object.Width           =   1852
         EndProperty
         BeginProperty ColumnHeader(5) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   4
            Text            =   "Breed"
            Object.Width           =   3969
         EndProperty
      End
   End
   Begin VB.CommandButton cmdConfigureGames 
      Caption         =   "Configure..."
      Height          =   315
      Left            =   9060
      TabIndex        =   10
      Top             =   120
      Width           =   1395
   End
   Begin VB.ComboBox cmbGame 
      Height          =   315
      Left            =   900
      Style           =   2  'Dropdown List
      TabIndex        =   9
      Top             =   120
      Width           =   7995
   End
   Begin VB.Frame Frame4 
      Caption         =   "Breeds"
      Height          =   3135
      Left            =   7500
      TabIndex        =   4
      Top             =   540
      Width           =   2955
      Begin VB.CommandButton cmdBreedsAll 
         Caption         =   "All"
         Height          =   315
         Left            =   120
         TabIndex        =   25
         Top             =   2700
         Width           =   615
      End
      Begin VB.CommandButton cmdBreedsNone 
         Caption         =   "None"
         Height          =   315
         Left            =   1200
         TabIndex        =   24
         Top             =   2700
         Width           =   615
      End
      Begin VB.CommandButton cmdBreedsInvert 
         Caption         =   "Invert"
         Height          =   315
         Left            =   2160
         TabIndex        =   23
         Top             =   2700
         Width           =   675
      End
      Begin MSComctlLib.ListView lvBreeds 
         Height          =   2415
         Left            =   120
         TabIndex        =   7
         Top             =   240
         Width           =   2715
         _ExtentX        =   4789
         _ExtentY        =   4260
         View            =   3
         LabelEdit       =   1
         Sorted          =   -1  'True
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         HideColumnHeaders=   -1  'True
         Checkboxes      =   -1  'True
         FullRowSelect   =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         NumItems        =   2
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "Code"
            Object.Width           =   882
         EndProperty
         BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   1
            Text            =   "Name"
            Object.Width           =   3175
         EndProperty
      End
   End
   Begin VB.Frame Frame3 
      Caption         =   "Species/Gender"
      Height          =   3135
      Left            =   2580
      TabIndex        =   3
      Top             =   540
      Width           =   2355
      Begin VB.CommandButton cmdGenderAll 
         Caption         =   "All"
         Height          =   315
         Left            =   120
         TabIndex        =   19
         Top             =   2700
         Width           =   615
      End
      Begin VB.CommandButton cmdGenderNone 
         Caption         =   "None"
         Height          =   315
         Left            =   840
         TabIndex        =   18
         Top             =   2700
         Width           =   615
      End
      Begin VB.CommandButton cmdGenderInvert 
         Caption         =   "Invert"
         Height          =   315
         Left            =   1560
         TabIndex        =   17
         Top             =   2700
         Width           =   675
      End
      Begin MSComctlLib.ListView lvGenders 
         Height          =   2415
         Left            =   120
         TabIndex        =   6
         Top             =   240
         Width           =   2115
         _ExtentX        =   3731
         _ExtentY        =   4260
         View            =   3
         LabelEdit       =   1
         Sorted          =   -1  'True
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         HideColumnHeaders=   -1  'True
         Checkboxes      =   -1  'True
         FullRowSelect   =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         NumItems        =   2
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "Code"
            Object.Width           =   882
         EndProperty
         BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   1
            Text            =   "Name"
            Object.Width           =   2293
         EndProperty
      End
   End
   Begin VB.Frame Frame2 
      Caption         =   "Ages"
      Height          =   3135
      Left            =   5040
      TabIndex        =   2
      Top             =   540
      Width           =   2355
      Begin VB.CommandButton cmdAgesAll 
         Caption         =   "All"
         Height          =   315
         Left            =   120
         TabIndex        =   22
         Top             =   2700
         Width           =   615
      End
      Begin VB.CommandButton cmdAgesNone 
         Caption         =   "None"
         Height          =   315
         Left            =   840
         TabIndex        =   21
         Top             =   2700
         Width           =   615
      End
      Begin VB.CommandButton cmdAgesInvert 
         Caption         =   "Invert"
         Height          =   315
         Left            =   1560
         TabIndex        =   20
         Top             =   2700
         Width           =   675
      End
      Begin MSComctlLib.ListView lvAges 
         Height          =   2415
         Left            =   120
         TabIndex        =   5
         Top             =   240
         Width           =   2115
         _ExtentX        =   3731
         _ExtentY        =   4260
         View            =   3
         LabelEdit       =   1
         Sorted          =   -1  'True
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         HideColumnHeaders=   -1  'True
         Checkboxes      =   -1  'True
         FullRowSelect   =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         NumItems        =   2
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Text            =   "Code"
            Object.Width           =   882
         EndProperty
         BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   1
            Text            =   "Name"
            Object.Width           =   2293
         EndProperty
      End
   End
   Begin VB.Frame Frame1 
      Caption         =   "Body parts"
      Height          =   3135
      Left            =   120
      TabIndex        =   0
      Top             =   540
      Width           =   2355
      Begin VB.CommandButton cmdBodyInvert 
         Caption         =   "Invert"
         Height          =   315
         Left            =   1560
         TabIndex        =   16
         Top             =   2700
         Width           =   675
      End
      Begin VB.CommandButton cmdBodyNone 
         Caption         =   "None"
         Height          =   315
         Left            =   840
         TabIndex        =   15
         Top             =   2700
         Width           =   615
      End
      Begin VB.CommandButton cmdBodyAll 
         Caption         =   "All"
         Height          =   315
         Left            =   120
         TabIndex        =   14
         Top             =   2700
         Width           =   615
      End
      Begin MSComctlLib.ListView lvBodyParts 
         Height          =   2415
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   2115
         _ExtentX        =   3731
         _ExtentY        =   4260
         View            =   3
         LabelEdit       =   1
         Sorted          =   -1  'True
         LabelWrap       =   -1  'True
         HideSelection   =   0   'False
         HideColumnHeaders=   -1  'True
         Checkboxes      =   -1  'True
         FullRowSelect   =   -1  'True
         _Version        =   393217
         ForeColor       =   -2147483640
         BackColor       =   -2147483643
         BorderStyle     =   1
         Appearance      =   1
         NumItems        =   2
         BeginProperty ColumnHeader(1) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            Object.Width           =   882
         EndProperty
         BeginProperty ColumnHeader(2) {BDD1F052-858B-11D1-B16A-00C0F0283628} 
            SubItemIndex    =   1
            Text            =   "Name"
            Object.Width           =   2293
         EndProperty
      End
   End
   Begin VB.Label Label1 
      Caption         =   "Game:"
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Top             =   180
      Width           =   735
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'    Creatures Sprite Finder
'    Copyright (C) 2003 Vadim Trochinsky (vadim_t@teleline.es)
'
'    This program is free software; you can redistribute it and/or modify
'    it under the terms of the GNU General Public License as published by
'    the Free Software Foundation; either version 2 of the License, or
'    (at your option) any later version.
'
'    This program is distributed in the hope that it will be useful,
'    but WITHOUT ANY WARRANTY; without even the implied warranty of
'    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
'    GNU General Public License for more details.
'
'    You should have received a copy of the GNU General Public License
'    along with this program; if not, write to the Free Software
'    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA


' This file has comments that can be processed by VBDOX to generate
' documentation for developers.
'
' See http://vbdox.sourceforge.net


''
' Creatures Image Selector
' Main program form
'
' @remarks Not done yet
' @author  vadim
' @version 0.1
' @date    20030716

Option Explicit

Dim C16Reader As New C16File
Dim EmptyPigment() As C16FileReader.Pigment
Dim RightButtonPressed As Boolean
Dim mImageLoaded As Boolean



Private Sub cmbGame_Click()
    SaveSetting APPNAME, "Paths", "Current", cmbGame.ListIndex + 1
    LoadBreedList GenderList:=lvGenders, List:=lvBreeds
    LoadBreedsLookup
    SelectFiles
End Sub

Private Sub cmdAgesAll_Click()
    SetList lvAges, True
End Sub

Private Sub cmdAgesInvert_Click()
    InvertList lvAges
End Sub

Private Sub cmdAgesNone_Click()
    SetList lvAges, False
End Sub

Private Sub cmdBodyAll_Click()
    SetList lvBodyParts, True
End Sub

Private Sub cmdBodyInvert_Click()
    InvertList lvBodyParts
End Sub

Private Sub cmdBodyNone_Click()
    SetList lvBodyParts, False
End Sub

Private Sub cmdBreedsAll_Click()
    SetList lvBreeds, True
End Sub

Private Sub cmdBreedsInvert_Click()
    InvertList lvBreeds
End Sub

Private Sub cmdBreedsNone_Click()
    SetList lvBreeds, False
End Sub

Private Sub cmdConfigureGames_Click()
    frmFolders.Show vbModal, Me
End Sub

Private Sub cmdGenderAll_Click()
    SetList lvGenders, True
    LoadBreedList GenderList:=lvGenders, List:=lvBreeds
    
    SelectFiles
End Sub

Private Sub cmdGenderInvert_Click()
    InvertList lvGenders
    LoadBreedList GenderList:=lvGenders, List:=lvBreeds
    SelectFiles
End Sub

Private Sub cmdGenderNone_Click()
    SetList lvGenders, False
    LoadBreedList GenderList:=lvGenders, List:=lvBreeds
    SelectFiles
    
End Sub

Private Sub Form_Load()
    ReDim EmptyPigment(0)
    Dim CurGame As Variant
    
    'Load current game, show config dialog if not defined
    CurGame = GetSetting(APPNAME, "Paths", "Current", 0)
    If CurGame = 0 Then
        frmFolders.Show vbModal, Me
    End If
    
    'Convert settings from previous version
    If Not IsNumeric(CurGame) Then
        SaveSetting APPNAME, "Paths", "1", "Creatures 3 or Docking Station" & "|C3|" & GetSetting(APPNAME, "Paths", "Current")
        SaveSetting APPNAME, "Paths", "Current", "1"
        CurGame = 1
        Status "Converted settings from previous version"
    End If
    
    If Not LoadGameList Then
        'The dialog has been shown, but the user cancelled, so
        'no games are defined. Nothing to do, so we exit.
    
        End 'Not a good way of finishing things, got to do something better
    End If
        
    If CurGame > 0 And CurGame <= cmbGame.ListCount - 1 Then
        cmbGame.ListIndex = CurGame - 1
    Else
        cmbGame.ListIndex = 0
    End If
    
    LoadRegList "Ages", lvAges
    LoadRegList "Body parts", lvBodyParts
    LoadRegList "Genders", lvGenders
    
    LoadBreedsLookup
    
    ListToCollection lvAges, gAges
    ListToCollection lvBodyParts, gParts
    ListToCollection lvGenders, gGenders
    
    'cmbFolder.Text = GetSetting("CreaturesSpriteFinder", "Paths", "Current", cmbFolder.Text)
    Caption = Caption & " " & App.Major & "." & App.Minor & "." & App.Revision


    
    SelectFiles
End Sub


Private Sub lvAges_ItemCheck(ByVal Item As MSComctlLib.ListItem)
    SelectFiles
End Sub

Private Sub lvBodyParts_ItemCheck(ByVal Item As MSComctlLib.ListItem)
    SelectFiles
End Sub


Private Sub lvBreeds_ItemCheck(ByVal Item As MSComctlLib.ListItem)
    SelectFiles
End Sub

Private Sub lvFiles_ColumnClick(ByVal ColumnHeader As MSComctlLib.ColumnHeader)
    With lvFiles
        lvFiles.Sorted = True
        
        If .SortKey <> ColumnHeader.Index - 1 Then
            .SortKey = ColumnHeader.Index - 1
            .SortOrder = lvwAscending
        Else
            If .SortOrder = lvwAscending Then
                .SortOrder = lvwDescending
            Else
                .SortOrder = lvwAscending
            End If
        End If
    End With
End Sub

Private Sub lvFiles_ItemClick(ByVal Item As MSComctlLib.ListItem)
On Error GoTo ErrH
    If GameType = C3 Then
        With C16Reader
            .Load PWJoin(GameFolder, Item.Text)
            
            mImageLoaded = True 'Ugly workaround for C16Lib bug, fix library
            
            picPreview.Cls
            .DrawImage picPreview.hDC, 1, 1, 1, EmptyPigment
            
            scrPreview.Value = 0
            scrPreview.Max = .GetImageCount
            
            lblCurImage = scrPreview.Value
            lblMaxImages = scrPreview.Max
        End With
        
    ElseIf GameType = C2 Then
        lblCurImage = 0
        lblMaxImages = 0
        scrPreview.Value = 0
        scrPreview.Max = 0
        picPreview.Cls
        mImageLoaded = False
        picPreview.Print "Not supported for C2"
    End If
Exit Sub

ErrH:
    MsgBox "Error while trying to load image for preview:" & vbCrLf & "Error #" & Err.Number & ": " & Err.Description
End Sub

Private Sub lvFiles_MouseDown(Button As Integer, Shift As Integer, x As Single, y As Single)
    If Button = vbRightButton Then
        RightButtonPressed = True
    End If
End Sub

Private Sub lvFiles_MouseMove(Button As Integer, Shift As Integer, x As Single, y As Single)
    If Button = vbRightButton And RightButtonPressed Then
        lvFiles.OLEDrag
    End If
End Sub

Private Sub lvFiles_MouseUp(Button As Integer, Shift As Integer, x As Single, y As Single)
    If Button = vbRightButton Then
        RightButtonPressed = False
    End If
End Sub

Private Sub lvFiles_OLECompleteDrag(Effect As Long)
    If Effect = vbDropEffectMove Then
        'Files were moved, so refresh
        SelectFiles
    End If
End Sub

Private Sub lvFiles_OLEStartDrag(Data As MSComctlLib.DataObject, AllowedEffects As Long)
    Dim li As ListItem
    
    Data.SetData , vbCFFiles
    For Each li In lvFiles.ListItems
        If li.Selected Then Data.Files.Add PWJoin(GameFolder, li.Text)
    Next
   ' Data.SetData
    AllowedEffects = vbDropEffectCopy Or vbDropEffectMove
End Sub


Private Sub SetList(List As ListView, Value As Boolean)
    Dim li As ListItem
    For Each li In List.ListItems
        li.Checked = Value
    Next
    
    SelectFiles
End Sub

Private Sub InvertList(List As ListView)
    Dim li As ListItem
    For Each li In List.ListItems
        li.Checked = Not li.Checked
    Next
    
    SelectFiles
End Sub

Private Sub lvGenders_ItemCheck(ByVal Item As MSComctlLib.ListItem)
    LoadBreedList GenderList:=lvGenders, List:=lvBreeds
    SelectFiles
End Sub

Private Sub scrPreview_Change()
    On Error GoTo ErrH
    
    If mImageLoaded Then
        picPreview.Cls
        C16Reader.DrawImage picPreview.hDC, 0, 0, scrPreview.Value, EmptyPigment
        lblCurImage = scrPreview.Value
        DoEvents
    End If
    
    Exit Sub
    
ErrH:
    MsgBox "Error while trying to load image for preview:" & vbCrLf & "Error #" & Err.Number & ": " & Err.Description
End Sub

