/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.res;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import rebound.exceptions.BinarySyntaxIOException;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.ResourceLoadException;
import rebound.exceptions.ResourceNotFoundException;
import rebound.exceptions.UnsupportedOptionException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.file.FSUtilities;
import rebound.io.util.BasicIOUtilities;
import rebound.io.util.FSIOUtilities;
import rebound.io.util.JRECompatIOUtilities;
import rebound.io.util.TextIOUtilities;
import rebound.text.StringUtilities;
import rebound.util.FlushableCache;
import rebound.util.collections.CollectionUtilities;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.objectutil.ObjectUtilities;
import rebound.util.res.ResourceClassAndRelpath;

public class ResourceUtilities
implements JavaNamespace {
    protected static final Map<URI, List<ZipEntry>> staticDecodedZips = new HashMap<URI, List<ZipEntry>>();

    public static List<String> getServiceProviderClassNames(Class serviceSpecificationClass) {
        ArrayList<String> all = new ArrayList<String>();
        all.addAll(ResourceUtilities.getServiceProviderClassNamesFromMetaInfs(serviceSpecificationClass));
        all.addAll(ResourceUtilities.getServiceProviderClassNamesFromSystemProperty(serviceSpecificationClass));
        return all;
    }

    public static List<String> getServiceProviderClassNamesFromMetaInfs(Class serviceSpecificationClass) {
        String fullName = "META-INF/services/" + serviceSpecificationClass.getName();
        Enumeration<URL> configs = null;
        try {
            configs = ClassLoader.getSystemResources(fullName);
        }
        catch (IOException exc) {
            throw new ServiceConfigurationError(String.valueOf(serviceSpecificationClass.getName()) + ": Error locating configuration files", exc);
        }
        ArrayList<String> names = new ArrayList<String>();
        while (configs.hasMoreElements()) {
            URL u = configs.nextElement();
            ResourceUtilities.parse(serviceSpecificationClass, u, names);
        }
        return names;
    }

    protected static void parse(Class serviceSpecificationClass, URL u, Collection<String> names) throws ServiceConfigurationError {
        BufferedReader r = null;
        try {
            r = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
        }
        catch (IOException exc) {
            throw new ServiceConfigurationError(String.valueOf(serviceSpecificationClass.getName()) + ": Error opening configuration file " + u, exc);
        }
        try {
            String line;
            while ((line = r.readLine()) != null) {
                int cp = line.indexOf(35);
                if (cp != -1) {
                    line = line.substring(0, cp);
                }
                if ((line = line.trim()).isEmpty()) continue;
                names.add(line);
            }
        }
        catch (IOException exc) {
            ServiceConfigurationError e = new ServiceConfigurationError(String.valueOf(serviceSpecificationClass.getName()) + ": Error reading configuration file " + u, exc);
            try {
                r.close();
            }
            catch (IOException exc2) {
                e.addSuppressed(exc2);
            }
            throw e;
        }
        try {
            r.close();
        }
        catch (IOException exc) {
            throw new ServiceConfigurationError(String.valueOf(serviceSpecificationClass.getName()) + ": Error closing configuration file " + u, exc);
        }
    }

    public static List<String> getServiceProviderClassNamesFromSystemProperty(Class serviceSpecificationClass) {
        String[] splitPropertyValues = null;
        String rawPropertyValue = null;
        try {
            rawPropertyValue = System.getProperty(serviceSpecificationClass.getName());
        }
        catch (SecurityException exc) {
            rawPropertyValue = null;
        }
        if (rawPropertyValue == null) {
            splitPropertyValues = null;
        } else {
            splitPropertyValues = rawPropertyValue.split(",");
            splitPropertyValues = CollectionUtilities.mapToNewArray(input -> input.trim(), String.class, splitPropertyValues);
            splitPropertyValues = CollectionUtilities.filterToNewArray(input -> !input.isEmpty(), splitPropertyValues);
        }
        return Arrays.asList(splitPropertyValues);
    }

    public static <P> P loadAndInstantiateServiceProvider(Class<P> serviceSpecificationClass, String implementationClassName) {
        try {
            return (P)ObjectUtilities.newInstance(Class.forName(implementationClassName));
        }
        catch (ClassNotFoundException exc) {
            throw new ServiceConfigurationError(String.valueOf(serviceSpecificationClass.getName()) + ": Provider " + implementationClassName + " from system property not found!", exc);
        }
        catch (WrappedThrowableRuntimeException wexc) {
            Throwable exc = wexc.getCause();
            if (exc instanceof InstantiationException) {
                throw new ServiceConfigurationError(String.valueOf(serviceSpecificationClass.getName()) + ": Provider " + implementationClassName + " from system property could not be instantiated: " + exc, exc);
            }
            if (exc instanceof IllegalAccessException) {
                throw new ServiceConfigurationError(String.valueOf(serviceSpecificationClass.getName()) + ": Provider " + implementationClassName + " from system property could not be instantiated: " + exc, exc);
            }
            throw wexc;
        }
    }

    public static <P> P loadAndInstantiateServiceProvider(String className) {
        try {
            return (P)ObjectUtilities.newInstance(Class.forName(className));
        }
        catch (ClassNotFoundException exc) {
            throw new ServiceConfigurationError("Provider " + className + " from system property not found!", exc);
        }
        catch (WrappedThrowableRuntimeException wexc) {
            Throwable exc = wexc.getCause();
            if (exc instanceof InstantiationException) {
                throw new ServiceConfigurationError("Provider " + className + " from system property could not be instantiated: " + exc, exc);
            }
            if (exc instanceof IllegalAccessException) {
                throw new ServiceConfigurationError("Provider " + className + " from system property could not be instantiated: " + exc, exc);
            }
            throw wexc;
        }
    }

    public static <P> List<P> getServiceProvidersEager(Class<P> serviceSpecificationClass) {
        List<P> justMetaInfOnes = ResourceUtilities.getServiceProvidersEagerJustMetaInf(serviceSpecificationClass);
        List<P> justSystemPropertyOnes = ResourceUtilities.getServiceProvidersEagerJustSystemProperty(serviceSpecificationClass);
        class Fi
        extends ArrayList<P>
        implements List<P>,
        FlushableCache {
            private static final long serialVersionUID = 1L;
            private final /* synthetic */ Object val$justMetaInfOnes;
            private final /* synthetic */ Object val$justSystemPropertyOnes;

            Fi(Object object, Object object2) {
                this.val$justMetaInfOnes = object;
                this.val$justSystemPropertyOnes = object2;
            }

            @Override
            public void resetCache() {
                ((FlushableCache)this.val$justMetaInfOnes).resetCache();
                ((FlushableCache)this.val$justSystemPropertyOnes).resetCache();
                super.addAll((Collection)this.val$justMetaInfOnes);
                super.addAll((Collection)this.val$justSystemPropertyOnes);
            }
        }
        Fi theFlushableList = new Fi(justMetaInfOnes, justSystemPropertyOnes);
        return theFlushableList;
    }

    public static <P> List<P> getServiceProvidersEagerJustMetaInf(Class<P> serviceSpecificationClass) {
        class Fi
        extends ArrayList<P>
        implements List<P>,
        FlushableCache {
            private static final long serialVersionUID = 1L;
            private final /* synthetic */ Class val$serviceSpecificationClass;

            Fi(Class clazz) {
                this.val$serviceSpecificationClass = clazz;
            }

            @Override
            public void resetCache() {
                for (String name : ResourceUtilities.getServiceProviderClassNamesFromMetaInfs(this.val$serviceSpecificationClass)) {
                    super.add(ResourceUtilities.loadAndInstantiateServiceProvider(this.val$serviceSpecificationClass, name));
                }
            }
        }
        Fi theFlushableList = new Fi(serviceSpecificationClass);
        theFlushableList.resetCache();
        return theFlushableList;
    }

    public static <P> List<P> getServiceProvidersEagerJustSystemProperty(Class<P> serviceSpecificationClass) {
        class Fi
        extends ArrayList<P>
        implements List<P>,
        FlushableCache {
            private static final long serialVersionUID = 1L;
            private final /* synthetic */ Class val$serviceSpecificationClass;

            Fi(Class clazz) {
                this.val$serviceSpecificationClass = clazz;
            }

            @Override
            public void resetCache() {
                super.clear();
                for (String individualRawPropertyValue : ResourceUtilities.getServiceProviderClassNamesFromSystemProperty(this.val$serviceSpecificationClass)) {
                    super.add(ResourceUtilities.loadAndInstantiateServiceProvider(this.val$serviceSpecificationClass, individualRawPropertyValue));
                }
            }
        }
        Fi theFlushableList = new Fi(serviceSpecificationClass);
        theFlushableList.resetCache();
        return theFlushableList;
    }

    public static URI getSubURI(String scheme, URI containerURI, String entry) throws URISyntaxException {
        try {
            return new URI(scheme, String.valueOf(URLEncoder.encode(containerURI.toString(), "UTF-8")) + "!" + URLEncoder.encode(entry, "UTF-8"), "");
        }
        catch (UnsupportedEncodingException exc) {
            throw new ImpossibleException("No UTF-8!");
        }
    }

    public static URI getSubURIContainerURI(URI suburi) throws URISyntaxException, SubURISyntaxException {
        try {
            String ssp = suburi.getSchemeSpecificPart();
            int separatorPos = ssp.indexOf(33);
            if (separatorPos == -1) {
                throw new SubURISyntaxException(suburi.toString(), "Missing separator \"!\" in scheme-specific part of the SubURI.");
            }
            return new URI(URLDecoder.decode(ssp.substring(separatorPos), "UTF-8"));
        }
        catch (UnsupportedEncodingException exc) {
            throw new ImpossibleException("No UTF-8!");
        }
    }

    public static String getSubURIEntry(URI suburi) throws SubURISyntaxException {
        try {
            String ssp = suburi.getSchemeSpecificPart();
            int separatorPos = ssp.indexOf(33);
            if (separatorPos == -1) {
                throw new SubURISyntaxException(suburi.toString(), "Missing separator \"!\" in scheme-specific part of the SubURI.");
            }
            return URLDecoder.decode(ssp.substring(separatorPos + 1), "UTF-8");
        }
        catch (UnsupportedEncodingException exc) {
            throw new ImpossibleException("No UTF-8!");
        }
    }

    public static boolean isSubURI(URI uri) {
        return uri.getScheme().toLowerCase().contains("+su");
    }

    public static URL getJarURL(URL jarFileURL, String entry) throws MalformedURLException {
        if (jarFileURL.getProtocol().equalsIgnoreCase("jar")) {
            throw new IllegalArgumentException("jar: scheme URL's cannot be nested as per the spec.  (it doesn't work in the JRE anyway; if you're rolling your own, use a fully escaped, nestable syntax like SubURI.)");
        }
        StringBuilder url = null;
        url = new StringBuilder("jar:");
        char[] cArray = jarFileURL.toString().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '!') {
                url.append("%21");
            } else {
                url.append(c);
            }
            ++n2;
        }
        url.append("!/");
        try {
            url.append(URLEncoder.encode(entry, "UTF-8"));
        }
        catch (UnsupportedEncodingException exc) {
            throw new ImpossibleException("No UTF-8!");
        }
        return new URL(url.toString());
    }

    public static boolean isJarURL(URL url) {
        return "jar".equalsIgnoreCase(url.getProtocol());
    }

    public static URL getJarURLContainerURL(URL jarURL) throws MalformedURLException {
        return ResourceUtilities.getDummyJarURLConnection(jarURL).getJarFileURL();
    }

    public static String getJarURLEntry(URL jarURL) throws MalformedURLException {
        return ResourceUtilities.getDummyJarURLConnection(jarURL).getEntryName();
    }

    public static JarURLConnection getDummyJarURLConnection(URL jarURL) throws MalformedURLException {
        return new JarURLConnection(jarURL){

            @Override
            public void connect() throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            public JarFile getJarFile() throws IOException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean isFileURL(URL url) {
        return "file".equalsIgnoreCase(url.getProtocol());
    }

    public static boolean isFileURI(URI url) {
        return "file".equalsIgnoreCase(url.getScheme());
    }

    public static boolean isLocal(URL url) {
        if (ResourceUtilities.isFileURL(url)) {
            return true;
        }
        if (ResourceUtilities.isJarURL(url)) {
            try {
                URL jarurl = ResourceUtilities.getJarURLContainerURL(url);
                return ResourceUtilities.isLocal(jarurl);
            }
            catch (MalformedURLException exc) {
                return false;
            }
        }
        URI uriform = null;
        try {
            uriform = url.toURI();
        }
        catch (URISyntaxException exc) {
            return false;
        }
        if (ResourceUtilities.isSubURI(uriform)) {
            try {
                URI container = ResourceUtilities.getSubURIContainerURI(uriform);
                return ResourceUtilities.isLocal(container);
            }
            catch (SubURISyntaxException exc) {
                return false;
            }
            catch (URISyntaxException exc) {
                return false;
            }
        }
        return false;
    }

    public static boolean isLocal(URI uri) {
        if (ResourceUtilities.isFileURI(uri)) {
            return true;
        }
        if (ResourceUtilities.isSubURI(uri)) {
            try {
                URI container = ResourceUtilities.getSubURIContainerURI(uri);
                return ResourceUtilities.isLocal(container);
            }
            catch (SubURISyntaxException exc) {
                return false;
            }
            catch (URISyntaxException exc) {
                return false;
            }
        }
        URL urlform = null;
        try {
            urlform = uri.toURL();
        }
        catch (MalformedURLException exc1) {
            return false;
        }
        if (ResourceUtilities.isJarURL(urlform)) {
            try {
                URL jarurl = ResourceUtilities.getJarURLContainerURL(urlform);
                return ResourceUtilities.isLocal(jarurl);
            }
            catch (MalformedURLException exc) {
                return false;
            }
        }
        return false;
    }

    public static URI getContainerURI(URI uri) {
        if (ResourceUtilities.isSubURI(uri)) {
            try {
                return ResourceUtilities.getSubURIContainerURI(uri);
            }
            catch (SubURISyntaxException exc) {
                return null;
            }
            catch (URISyntaxException exc) {
                return null;
            }
        }
        URL urlform = null;
        try {
            urlform = uri.toURL();
        }
        catch (MalformedURLException exc1) {
            return null;
        }
        if (ResourceUtilities.isJarURL(urlform)) {
            try {
                return ResourceUtilities.getJarURLContainerURL(urlform).toURI();
            }
            catch (MalformedURLException exc) {
                return null;
            }
            catch (URISyntaxException exc) {
                return null;
            }
        }
        return null;
    }

    public static File getLocalmostURI(URI uri) {
        if (ResourceUtilities.isFileURI(uri)) {
            return new File(uri);
        }
        URI container = ResourceUtilities.getContainerURI(uri);
        if (container != null) {
            return ResourceUtilities.getLocalmostURI(container);
        }
        return null;
    }

    @Nonnull
    public static byte[] loadBinaryResourceRelativeToClass(Class c, String name) throws ResourceNotFoundException, ResourceLoadException {
        name = StringUtilities.ltrimstr(name, "/");
        Package p = c.getPackage();
        String path = "/";
        if (p != null) {
            path = String.valueOf(path) + p.getName().replace('.', '/') + "/";
        }
        path = String.valueOf(path) + name;
        return ResourceUtilities.loadBinaryResource(c, path);
    }

    @Nonnull
    public static String loadTextResourceRelativeToClass(Class c, String name, Charset encoding) throws ResourceNotFoundException, ResourceLoadException {
        name = StringUtilities.ltrimstr(name, "/");
        Package p = c.getPackage();
        String path = "/";
        if (p != null) {
            path = String.valueOf(path) + p.getName().replace('.', '/') + "/";
        }
        path = String.valueOf(path) + name;
        return ResourceUtilities.loadTextResource(c, path, encoding);
    }

    @Nonnull
    public static byte[] loadBinaryResource(ResourceClassAndRelpath locator) throws ResourceNotFoundException, ResourceLoadException {
        return ResourceUtilities.loadBinaryResource(locator.getBaseClass(), locator.getPathRelativeToClassFile());
    }

    @Nonnull
    public static byte[] loadBinaryResource(Class c, String name) throws ResourceNotFoundException, ResourceLoadException {
        InputStream in = c.getResourceAsStream(name);
        if (in == null) {
            throw new ResourceNotFoundException(c, name);
        }
        try {
            byte[] byArray = JRECompatIOUtilities.readAll(in);
            return byArray;
        }
        catch (IOException exc) {
            throw new ResourceLoadException(c, name, exc);
        }
        finally {
            BasicIOUtilities.closeWithoutError(in);
        }
    }

    @Nonnull
    public static byte[] loadBinaryResourceAbsolute(ClassLoader c, String name) throws ResourceNotFoundException, ResourceLoadException {
        InputStream in = c.getResourceAsStream(name);
        if (in == null) {
            throw new ResourceNotFoundException(name);
        }
        try {
            byte[] byArray = JRECompatIOUtilities.readAll(in);
            return byArray;
        }
        catch (IOException exc) {
            throw new ResourceLoadException(name, exc);
        }
        finally {
            BasicIOUtilities.closeWithoutError(in);
        }
    }

    @Nonnull
    public static String loadTextResource(ResourceClassAndRelpath locator, Charset encoding) throws ResourceNotFoundException, ResourceLoadException {
        return ResourceUtilities.loadTextResource(locator.getBaseClass(), locator.getPathRelativeToClassFile(), encoding);
    }

    @Nonnull
    public static String loadTextResource(Class c, String name, Charset encoding) throws ResourceNotFoundException, ResourceLoadException {
        InputStream in = c.getResourceAsStream(name);
        if (in == null) {
            throw new ResourceNotFoundException(c, name);
        }
        try {
            String string = TextIOUtilities.readAllText(in, encoding);
            return string;
        }
        catch (IOException exc) {
            throw new ResourceLoadException(c, name, exc);
        }
        finally {
            BasicIOUtilities.closeWithoutError(in);
        }
    }

    @Nonnull
    public static String loadTextResourceAbsolute(ClassLoader c, String name, Charset encoding) throws ResourceNotFoundException, ResourceLoadException {
        InputStream in = c.getResourceAsStream(name);
        if (in == null) {
            throw new ResourceNotFoundException(name);
        }
        try {
            String string = TextIOUtilities.readAllText(in, encoding);
            return string;
        }
        catch (IOException exc) {
            throw new ResourceLoadException(name, exc);
        }
        finally {
            BasicIOUtilities.closeWithoutError(in);
        }
    }

    @Nonnull
    public static byte[] loadBinaryResource(File file) throws ResourceNotFoundException, ResourceLoadException {
        if (!FSUtilities.lexists(file)) {
            throw new ResourceNotFoundException(file.getAbsolutePath());
        }
        try {
            return FSIOUtilities.readAll(file);
        }
        catch (IOException exc) {
            throw new ResourceLoadException(file.getAbsolutePath(), exc);
        }
    }

    @Nonnull
    public static String loadTextResource(File file, Charset encoding) throws ResourceNotFoundException, ResourceLoadException {
        if (!FSUtilities.lexists(file)) {
            throw new ResourceNotFoundException(file.getAbsolutePath());
        }
        try {
            return FSIOUtilities.readAllText(file, encoding);
        }
        catch (IOException exc) {
            throw new ResourceLoadException(file.getAbsolutePath(), exc);
        }
    }

    public static BufferedImage loadStandardImageResource(Class c, String resourceName) throws ResourceNotFoundException, ResourceLoadException {
        InputStream ii = c.getResourceAsStream(resourceName);
        if (ii == null) {
            throw new ResourceNotFoundException(c, resourceName);
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream i = ii;){
                return ImageIO.read(i);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException exc) {
            throw new ResourceLoadException(c, resourceName);
        }
    }

    public static BufferedImage loadStandardImageResource(File file) throws ResourceNotFoundException, ResourceLoadException {
        if (!file.isFile()) {
            throw new ResourceNotFoundException(file.getAbsolutePath());
        }
        try {
            return ImageIO.read(file);
        }
        catch (IOException exc) {
            throw new ResourceLoadException(file.getAbsolutePath());
        }
    }

    public static ZipEntry[] readAllZipEntriesFromZipfile(URL url, boolean jmod) throws IOException {
        InputStream in;
        try {
            in = url.openStream();
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
        try {
            ZipEntry[] zipEntryArray = ResourceUtilities.readAllZipEntriesFromZipfile(in, jmod);
            return zipEntryArray;
        }
        finally {
            in.close();
        }
    }

    public static ZipEntry[] readAllZipEntriesFromZipfile(InputStream in, boolean jmod) throws IOException {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        if (jmod) {
            byte[] magic = new byte[4];
            JRECompatIOUtilities.readFully(in, magic);
            if (magic[0] != 74) {
                throw BinarySyntaxIOException.inst("Bag JMOD magic");
            }
            if (magic[1] != 77) {
                throw BinarySyntaxIOException.inst("Bag JMOD magic");
            }
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipInputStream zipDecoder = new ZipInputStream(in);){
            ZipEntry e;
            while ((e = zipDecoder.getNextEntry()) != null) {
                entries.add(e);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return entries.toArray(new ZipEntry[entries.size()]);
    }

    public static synchronized List<ZipEntry> getStaticZipEntries(URI zipfileURI, boolean jmod) {
        List<ZipEntry> entries = staticDecodedZips.get(zipfileURI);
        if (entries == null) {
            ZipEntry[] a;
            URL url;
            try {
                url = zipfileURI.toURL();
            }
            catch (MalformedURLException exc) {
                throw new WrappedThrowableRuntimeException(exc);
            }
            try {
                a = ResourceUtilities.readAllZipEntriesFromZipfile(url, jmod);
            }
            catch (IOException exc) {
                throw new WrappedThrowableRuntimeException(exc);
            }
            entries = Collections.unmodifiableList(Arrays.asList(a));
            staticDecodedZips.put(zipfileURI, entries);
        }
        return entries;
    }

    public static boolean isDirectoryTypeResourceURL(URL url) {
        if (url.getPath().endsWith("/")) {
            return true;
        }
        if (url.getProtocol().equalsIgnoreCase("file")) {
            try {
                File f = new File(url.toURI());
                return f.isDirectory();
            }
            catch (URISyntaxException exc) {
                throw new IllegalArgumentException(exc);
            }
        }
        if (url.getProtocol().equalsIgnoreCase("jar")) {
            String entryInJarfile;
            URI jarfileURI;
            try {
                jarfileURI = ResourceUtilities.getJarURLContainerURL(url).toURI();
                entryInJarfile = ResourceUtilities.getJarURLEntry(url);
            }
            catch (MalformedURLException exc) {
                throw new IllegalArgumentException(exc);
            }
            catch (URISyntaxException exc) {
                throw new IllegalArgumentException(exc);
            }
            entryInJarfile = StringUtilities.trim(entryInJarfile, '/');
            String entryInJarfileWithTrailingSlash = String.valueOf(entryInJarfile) + '/';
            for (ZipEntry e : ResourceUtilities.getStaticZipEntries(jarfileURI, jarfileURI.getPath().endsWith(".jmod"))) {
                String n = StringUtilities.rtrim(e.getName(), '/');
                if (BasicObjectUtilities.eq((Object)n, (Object)entryInJarfile)) {
                    return e.isDirectory();
                }
                if (!n.startsWith(entryInJarfileWithTrailingSlash)) continue;
                return true;
            }
            throw new IllegalArgumentException("The given entry " + StringUtilities.repr(entryInJarfile) + " was not explicitly found as an entry (or implied as a parent directory of other entries) in the jarfile " + StringUtilities.repr(jarfileURI.toString()) + "     (perhaps the jar file needs to be created with actual entries for the directories?? ie, the opposite of 'zip --no-dir-entries')");
        }
        if (url.getProtocol().equalsIgnoreCase("jrt")) {
            return false;
        }
        throw new UnsupportedOptionException("Currently we can't tell if '" + url.getProtocol() + ":' URLs are directories or not (or if that concept even makes sense for that protocol/scheme! xD'' )");
    }

    public static class SubURISyntaxException
    extends URISyntaxException {
        private static final long serialVersionUID = 1L;

        public SubURISyntaxException(String input, String reason, int index) {
            super(input, reason, index);
        }

        public SubURISyntaxException(String input, String reason) {
            super(input, reason);
        }
    }
}

