/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.container;

import rebound.concurrency.immutability.JavaImmutability;
import rebound.util.Primitives;
import rebound.util.container.ContainerInterfaces;
import rebound.util.container.ProperContainer;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.RuntimeImmutability;

public class SimpleContainers {

    public static class SimpleBooleanContainer
    implements ProperContainer<SimpleBooleanContainer>,
    ContainerInterfaces.BooleanContainer,
    RuntimeImmutability {
        protected boolean value;

        public SimpleBooleanContainer() {
            this.value = false;
        }

        public SimpleBooleanContainer(boolean value) {
            this.value = value;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Mutable;
        }

        @Override
        public boolean get() {
            return this.value;
        }

        @Override
        public void set(boolean value) {
            this.value = value;
        }

        @Override
        public void setFrom(Object source) {
            if (!(source instanceof ContainerInterfaces.BooleanContainer)) {
                if (source == null) {
                    throw new NullPointerException();
                }
                throw new ClassCastException(source.getClass().getName());
            }
            this.set(((ContainerInterfaces.BooleanContainer)source).get());
        }

        @Override
        public SimpleBooleanContainer clone() {
            return new SimpleBooleanContainer(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerInterfaces.BooleanContainer) {
                return ((ContainerInterfaces.BooleanContainer)obj).get() == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Primitives.hashprim(this.value);
        }

        @Override
        public SimpleBooleanContainer newInstance() {
            return new SimpleBooleanContainer();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":(" + this.value + ")";
        }
    }

    public static class SimpleByteContainer
    implements ProperContainer<SimpleByteContainer>,
    ContainerInterfaces.ByteContainer,
    RuntimeImmutability {
        protected byte value;

        public SimpleByteContainer() {
            this.value = 0;
        }

        public SimpleByteContainer(byte value) {
            this.value = value;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Mutable;
        }

        @Override
        public byte get() {
            return this.value;
        }

        @Override
        public void set(byte value) {
            this.value = value;
        }

        @Override
        public void setFrom(Object source) {
            if (!(source instanceof ContainerInterfaces.ByteContainer)) {
                if (source == null) {
                    throw new NullPointerException();
                }
                throw new ClassCastException(source.getClass().getName());
            }
            this.set(((ContainerInterfaces.ByteContainer)source).get());
        }

        @Override
        public SimpleByteContainer clone() {
            return new SimpleByteContainer(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerInterfaces.ByteContainer) {
                return ((ContainerInterfaces.ByteContainer)obj).get() == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Primitives.hashprim(this.value);
        }

        @Override
        public SimpleByteContainer newInstance() {
            return new SimpleByteContainer();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":(" + this.value + ")";
        }
    }

    public static class SimpleCharacterContainer
    implements ProperContainer<SimpleCharacterContainer>,
    ContainerInterfaces.CharacterContainer,
    RuntimeImmutability {
        protected char value;

        public SimpleCharacterContainer() {
            this.value = '\u0000';
        }

        public SimpleCharacterContainer(char value) {
            this.value = value;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Mutable;
        }

        @Override
        public char get() {
            return this.value;
        }

        @Override
        public void set(char value) {
            this.value = value;
        }

        @Override
        public void setFrom(Object source) {
            if (!(source instanceof ContainerInterfaces.CharacterContainer)) {
                if (source == null) {
                    throw new NullPointerException();
                }
                throw new ClassCastException(source.getClass().getName());
            }
            this.set(((ContainerInterfaces.CharacterContainer)source).get());
        }

        @Override
        public SimpleCharacterContainer clone() {
            return new SimpleCharacterContainer(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerInterfaces.CharacterContainer) {
                return ((ContainerInterfaces.CharacterContainer)obj).get() == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Primitives.hashprim(this.value);
        }

        @Override
        public SimpleCharacterContainer newInstance() {
            return new SimpleCharacterContainer();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":(" + this.value + ")";
        }
    }

    public static class SimpleDoubleContainer
    implements ProperContainer<SimpleDoubleContainer>,
    ContainerInterfaces.DoubleContainer,
    RuntimeImmutability {
        protected double value;

        public SimpleDoubleContainer() {
            this.value = 0.0;
        }

        public SimpleDoubleContainer(double value) {
            this.value = value;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Mutable;
        }

        @Override
        public double get() {
            return this.value;
        }

        @Override
        public void set(double value) {
            this.value = value;
        }

        @Override
        public void setFrom(Object source) {
            if (!(source instanceof ContainerInterfaces.DoubleContainer)) {
                if (source == null) {
                    throw new NullPointerException();
                }
                throw new ClassCastException(source.getClass().getName());
            }
            this.set(((ContainerInterfaces.DoubleContainer)source).get());
        }

        @Override
        public SimpleDoubleContainer clone() {
            return new SimpleDoubleContainer(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerInterfaces.DoubleContainer) {
                return ((ContainerInterfaces.DoubleContainer)obj).get() == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Primitives.hashprim(this.value);
        }

        @Override
        public SimpleDoubleContainer newInstance() {
            return new SimpleDoubleContainer();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":(" + this.value + ")";
        }
    }

    public static class SimpleFloatContainer
    implements ProperContainer<SimpleFloatContainer>,
    ContainerInterfaces.FloatContainer,
    RuntimeImmutability {
        protected float value;

        public SimpleFloatContainer() {
            this.value = 0.0f;
        }

        public SimpleFloatContainer(float value) {
            this.value = value;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Mutable;
        }

        @Override
        public float get() {
            return this.value;
        }

        @Override
        public void set(float value) {
            this.value = value;
        }

        @Override
        public void setFrom(Object source) {
            if (!(source instanceof ContainerInterfaces.FloatContainer)) {
                if (source == null) {
                    throw new NullPointerException();
                }
                throw new ClassCastException(source.getClass().getName());
            }
            this.set(((ContainerInterfaces.FloatContainer)source).get());
        }

        @Override
        public SimpleFloatContainer clone() {
            return new SimpleFloatContainer(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerInterfaces.FloatContainer) {
                return ((ContainerInterfaces.FloatContainer)obj).get() == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Primitives.hashprim(this.value);
        }

        @Override
        public SimpleFloatContainer newInstance() {
            return new SimpleFloatContainer();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":(" + this.value + ")";
        }
    }

    public static class SimpleIntegerContainer
    implements ProperContainer<SimpleIntegerContainer>,
    ContainerInterfaces.IntegerContainer,
    RuntimeImmutability {
        protected int value;

        public SimpleIntegerContainer() {
            this.value = 0;
        }

        public SimpleIntegerContainer(int value) {
            this.value = value;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Mutable;
        }

        @Override
        public int get() {
            return this.value;
        }

        @Override
        public void set(int value) {
            this.value = value;
        }

        @Override
        public void setFrom(Object source) {
            if (!(source instanceof ContainerInterfaces.IntegerContainer)) {
                if (source == null) {
                    throw new NullPointerException();
                }
                throw new ClassCastException(source.getClass().getName());
            }
            this.set(((ContainerInterfaces.IntegerContainer)source).get());
        }

        @Override
        public SimpleIntegerContainer clone() {
            return new SimpleIntegerContainer(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerInterfaces.IntegerContainer) {
                return ((ContainerInterfaces.IntegerContainer)obj).get() == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Primitives.hashprim(this.value);
        }

        @Override
        public SimpleIntegerContainer newInstance() {
            return new SimpleIntegerContainer();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":(" + this.value + ")";
        }
    }

    public static class SimpleLongContainer
    implements ProperContainer<SimpleLongContainer>,
    ContainerInterfaces.LongContainer,
    RuntimeImmutability {
        protected long value;

        public SimpleLongContainer() {
            this.value = 0L;
        }

        public SimpleLongContainer(long value) {
            this.value = value;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Mutable;
        }

        @Override
        public long get() {
            return this.value;
        }

        @Override
        public void set(long value) {
            this.value = value;
        }

        @Override
        public void setFrom(Object source) {
            if (!(source instanceof ContainerInterfaces.LongContainer)) {
                if (source == null) {
                    throw new NullPointerException();
                }
                throw new ClassCastException(source.getClass().getName());
            }
            this.set(((ContainerInterfaces.LongContainer)source).get());
        }

        @Override
        public SimpleLongContainer clone() {
            return new SimpleLongContainer(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerInterfaces.LongContainer) {
                return ((ContainerInterfaces.LongContainer)obj).get() == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Primitives.hashprim(this.value);
        }

        @Override
        public SimpleLongContainer newInstance() {
            return new SimpleLongContainer();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":(" + this.value + ")";
        }
    }

    public static class SimpleObjectContainer<T>
    implements ProperContainer<SimpleObjectContainer<T>>,
    ContainerInterfaces.ObjectContainer<T>,
    RuntimeImmutability {
        protected T value;

        public SimpleObjectContainer() {
            this.value = null;
        }

        public SimpleObjectContainer(T value) {
            this.value = value;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Mutable;
        }

        @Override
        public T get() {
            return this.value;
        }

        @Override
        public void set(T value) {
            this.value = value;
        }

        @Override
        public void setFrom(Object source) {
            if (!(source instanceof ContainerInterfaces.ObjectContainer)) {
                if (source == null) {
                    throw new NullPointerException();
                }
                throw new ClassCastException(source.getClass().getName());
            }
            this.set(((ContainerInterfaces.ObjectContainer)source).get());
        }

        @Override
        public SimpleObjectContainer<T> clone() {
            return new SimpleObjectContainer<T>(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerInterfaces.ObjectContainer) {
                return ((ContainerInterfaces.ObjectContainer)obj).get() == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return BasicObjectUtilities.hashNT(this.value);
        }

        @Override
        public SimpleObjectContainer<T> newInstance() {
            return new SimpleObjectContainer<T>();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":(" + this.value + ")";
        }
    }

    public static class SimpleShortContainer
    implements ProperContainer<SimpleShortContainer>,
    ContainerInterfaces.ShortContainer,
    RuntimeImmutability {
        protected short value;

        public SimpleShortContainer() {
            this.value = 0;
        }

        public SimpleShortContainer(short value) {
            this.value = value;
        }

        @Override
        public JavaImmutability isImmutable() {
            return JavaImmutability.Mutable;
        }

        @Override
        public short get() {
            return this.value;
        }

        @Override
        public void set(short value) {
            this.value = value;
        }

        @Override
        public void setFrom(Object source) {
            if (!(source instanceof ContainerInterfaces.ShortContainer)) {
                if (source == null) {
                    throw new NullPointerException();
                }
                throw new ClassCastException(source.getClass().getName());
            }
            this.set(((ContainerInterfaces.ShortContainer)source).get());
        }

        @Override
        public SimpleShortContainer clone() {
            return new SimpleShortContainer(this.value);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof ContainerInterfaces.ShortContainer) {
                return ((ContainerInterfaces.ShortContainer)obj).get() == this.value;
            }
            return false;
        }

        @Override
        public int hashCode() {
            return Primitives.hashprim(this.value);
        }

        @Override
        public SimpleShortContainer newInstance() {
            return new SimpleShortContainer();
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ":(" + this.value + ")";
        }
    }
}

