/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections.prim;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.List;
import rebound.bits.BitfieldSafeCasts;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;

public class RandomAccessFileBackedByteList
implements PrimitiveCollections.DefaultShiftingBasedByteList {
    protected final RandomAccessFile underlying;
    protected int currentPosition;
    protected Boolean writable;

    public RandomAccessFileBackedByteList(RandomAccessFile underlying, Boolean writable) {
        try {
            this.underlying = underlying;
            this.currentPosition = BitfieldSafeCasts.safeCastU64toS32(underlying.getFilePointer());
            this.writable = writable;
            this.size();
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    @Override
    public int size() {
        try {
            return BitfieldSafeCasts.safeCastU64toS32(this.underlying.length());
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    protected void ensurePositionS32(int index) {
        try {
            if (index < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (index > this.size()) {
                throw new IndexOutOfBoundsException();
            }
            if (this.currentPosition != index) {
                this.underlying.seek(index);
            }
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    @Override
    public byte getByte(int index) {
        try {
            this.ensurePositionS32(index);
            int c = this.underlying.read();
            if (c == -1) {
                throw new IndexOutOfBoundsException();
            }
            ++this.currentPosition;
            return (byte)c;
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    @Override
    public void setByte(int index, byte value) {
        try {
            this.ensurePositionS32(index);
            this.underlying.write(value);
            ++this.currentPosition;
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    @Override
    public boolean addByte(byte value) {
        try {
            this.ensurePositionS32(this.size());
            this.underlying.write(value);
            ++this.currentPosition;
            return true;
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    @Override
    public void getAllBytes(int start, byte[] array, int offset, int length) {
        try {
            this.ensurePositionS32(start);
            this.underlying.readFully(array, offset, length);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    protected void writeAllBytes(int position, byte[] array, int offset, int length) {
        try {
            this.ensurePositionS32(position);
            this.underlying.write(array, offset, length);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    protected void writeAll(int position, Collection<? extends Byte> c) {
        Slice<byte[]> s = PrimitiveCollections.wrappedByteCollection(c).toByteArraySlicePossiblyLive();
        this.writeAllBytes(position, s.getUnderlying(), s.getOffset(), s.getLength());
    }

    @Override
    public boolean addAll(Collection<? extends Byte> c) {
        this.writeAll(this.size(), c);
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends Byte> c) {
        if (index == this.size()) {
            this.addAll(c);
        } else {
            PrimitiveCollections.DefaultShiftingBasedByteList.super.addAll(index, c);
        }
        return true;
    }

    @Override
    public void setAll(int destIndex, List source, int sourceIndex, int amount) throws IndexOutOfBoundsException {
        CollectionUtilities.rangeCheckIntervalByLength(source.size(), sourceIndex, amount);
        CollectionUtilities.rangeCheckIntervalByLength(this.size(), destIndex, amount);
        this.writeAll(destIndex, CollectionUtilities.subListBySize(source, sourceIndex, amount));
    }

    @Override
    public void setSizeByte(int newSize, byte elementToAddIfGrowing) {
        if (newSize < 0) {
            throw new IllegalArgumentException();
        }
        int oldSize = this.size();
        int amount = newSize - oldSize;
        try {
            this.underlying.setLength(newSize);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
        this.fillBySettingByte(oldSize, amount, elementToAddIfGrowing);
    }

    @Override
    public PrimitiveCollections.ByteList clone() {
        return new PrimitiveCollections.ByteArrayList(this.toByteArray());
    }

    @Override
    public Boolean isWritableCollection() {
        return this.writable;
    }
}

