/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections.prim;

import java.nio.ByteBuffer;
import java.util.BitSet;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.SnapshotValue;
import rebound.math.SmallIntegerMathUtilities;
import rebound.util.NIOBufferUtilities;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.ShiftableList;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.objectutil.Copyable;

public class BitSetBackedBooleanList
implements PrimitiveCollections.DefaultShiftingBasedBooleanList,
ShiftableList,
PrimitiveCollections.BooleanListWithByteListConversion,
Copyable,
RandomAccess {
    protected BitSet bitSet;
    protected int size;

    public BitSetBackedBooleanList() {
        this.bitSet = new BitSet();
        this.size = 0;
    }

    public BitSetBackedBooleanList(int capacity, Void v) {
        this.bitSet = new BitSet(capacity);
        this.size = 0;
    }

    public static BitSetBackedBooleanList newBooleanListZerofilled(int size) {
        return new BitSetBackedBooleanList(new BitSet(), size);
    }

    public BitSetBackedBooleanList(@LiveValue BitSet bitSet, int size) {
        this.bitSet = Objects.requireNonNull(bitSet);
        this.size = size;
    }

    public static BitSetBackedBooleanList instCopying(@ReadonlyValue @SnapshotValue List<Boolean> other) {
        if (other instanceof BitSetBackedBooleanList) {
            return ((BitSetBackedBooleanList)other).clone();
        }
        BitSetBackedBooleanList l = new BitSetBackedBooleanList();
        l.setFrom(other);
        return l;
    }

    @Override
    public BitSetBackedBooleanList clone() {
        return new BitSetBackedBooleanList((BitSet)this.bitSet.clone(), this.size);
    }

    @Override
    public Boolean isWritableCollection() {
        return true;
    }

    @Override
    public void setFrom(Object source) {
        if (source instanceof BitSetBackedBooleanList) {
            BitSetBackedBooleanList s = (BitSetBackedBooleanList)source;
            this.size = s.size;
            this.bitSet = (BitSet)s.bitSet.clone();
        } else {
            PrimitiveCollections.DefaultShiftingBasedBooleanList.super.setFrom(source);
        }
    }

    @ImplementationTransparency
    public BitSet getLiveBitSetBackingUNSAFE() {
        return this.bitSet;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean getBoolean(int index) {
        CollectionUtilities.rangeCheckMember(this.size(), index);
        return this.bitSet.get(index);
    }

    @Override
    public void setBoolean(int index, boolean value) {
        CollectionUtilities.rangeCheckMember(this.size(), index);
        this.bitSet.set(index, value);
    }

    @Override
    public void shiftRegionStretchingFromIndexToEndByAmountChangingSize(int start, int amount) {
        this.size += amount;
        BitSetBackedBooleanList.shiftBitSubset(this.bitSet, start, this.size, amount);
    }

    public static void shiftBitSubset(BitSet b, int start, int pastEnd, int amount) {
        block3: {
            block2: {
                if (amount <= 0) break block2;
                int i = pastEnd - 1;
                while (i >= start) {
                    b.set(i + amount, b.get(i));
                    --i;
                }
                break block3;
            }
            if (amount >= 0) break block3;
            int i = start;
            while (i < pastEnd) {
                b.set(i + amount, b.get(i));
                ++i;
            }
        }
    }

    @Override
    public int getNumberOfOnes() {
        return this.bitSet.cardinality();
    }

    @Override
    public void setSizeBoolean(int newSize, boolean elementToAddIfGrowing) {
        if (newSize > this.size && elementToAddIfGrowing) {
            int i = this.size;
            while (i < newSize) {
                this.bitSet.set(i, elementToAddIfGrowing);
                ++i;
            }
        }
        this.size = newSize;
    }

    @Override
    public void setSize(int newSize) {
        this.size = newSize;
    }

    @Override
    public PrimitiveCollections.ByteList byteList() {
        return this.toNewByteList();
    }

    @Override
    public PrimitiveCollections.ByteList toNewByteList() {
        byte[] b;
        int nBytes = SmallIntegerMathUtilities.ceilingDivision(this.size(), 8);
        byte[] a = this.bitSet.toByteArray();
        int al = a.length;
        if (al < nBytes) {
            b = new byte[nBytes];
            System.arraycopy(a, 0, b, 0, a.length);
        } else if (al > nBytes) {
            b = new byte[nBytes];
            System.arraycopy(a, 0, b, 0, b.length);
        } else {
            b = a;
        }
        return PrimitiveCollections.byteArrayAsList(b);
    }

    public String toString() {
        return this._toString();
    }

    public static BitSetBackedBooleanList newFromBytesArray(byte[] bytes, int sizeInBits) {
        return new BitSetBackedBooleanList(BitSet.valueOf(bytes), sizeInBits);
    }

    public static BitSetBackedBooleanList newFromBytesNIOBuffer(ByteBuffer bytes, int sizeInBits) {
        return new BitSetBackedBooleanList(BitSet.valueOf(bytes), sizeInBits);
    }

    public static BitSetBackedBooleanList newFromBytesArraySlice(Slice<byte[]> bytes, int sizeInBits) {
        return BitSetBackedBooleanList.newFromBytesNIOBuffer(NIOBufferUtilities.wrapInBufferBySliceByte(bytes));
    }

    public static BitSetBackedBooleanList newFromBytesArray(byte[] bytes) {
        return BitSetBackedBooleanList.newFromBytesArray(bytes, SmallIntegerMathUtilities.safe_mul_s32(bytes.length, 8));
    }

    public static BitSetBackedBooleanList newFromBytesNIOBuffer(ByteBuffer bytes) {
        return BitSetBackedBooleanList.newFromBytesNIOBuffer(bytes, SmallIntegerMathUtilities.safe_mul_s32(bytes.remaining(), 8));
    }

    public static BitSetBackedBooleanList newFromBytesArraySlice(Slice<byte[]> bytes) {
        return BitSetBackedBooleanList.newFromBytesArraySlice(bytes, bytes.getLength() * 8);
    }
}

