/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.lang.reflect.Array;
import java.nio.Buffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.PriorityQueue;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.w3c.dom.NodeList;
import rebound.annotations.hints.PerformanceSetting;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.operationspecification.CollectionValue;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.PossiblySnapshotPossiblyLiveValue;
import rebound.annotations.semantic.reachability.SnapshotValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.exceptions.AlreadyExistsException;
import rebound.exceptions.NoSuchElementReturnPath;
import rebound.exceptions.NoSuchMappingReturnPath;
import rebound.exceptions.ReadonlyPossiblyUnsupportedOperationException;
import rebound.exceptions.ReadonlyUnsupportedOperationException;
import rebound.exceptions.StopIterationReturnPath;
import rebound.math.MathUtilities;
import rebound.util.AngryReflectionUtility;
import rebound.util.BasicExceptionUtilities;
import rebound.util.NIOBufferUtilities;
import rebound.util.Primitives;
import rebound.util.classhacking.jre.BetterJREGlassbox;
import rebound.util.collections.BasicCollectionUtilities;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.FastRandomAccess;
import rebound.util.collections.KnowsLengthFixedness;
import rebound.util.collections.RuntimeReadabilityCollection;
import rebound.util.collections.RuntimeWriteabilityCollection;
import rebound.util.collections.SimpleIterator;
import rebound.util.collections.Slice;
import rebound.util.collections.Sublist;
import rebound.util.collections.SublistOverride;
import rebound.util.collections.TransparentContiguousArrayBackedCollection;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.functional.EqualityComparator;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.objectutil.BasicObjectUtilities;

public class PolymorphicCollectionUtilities {
    public static final EqualityComparator<Object> acyclicDeepEqv = PolymorphicCollectionUtilities::acyclicDeepEqv;

    @CollectionValue
    @PossiblySnapshotPossiblyLiveValue
    public static Object anySublist(@CollectionValue Object list, int start, int length) {
        if (list instanceof SublistOverride) {
            return ((SublistOverride)list).sublist(start, length);
        }
        if (list instanceof Sublist) {
            Sublist listC = (Sublist)list;
            CollectionUtilities.rangeCheckIntervalByLength(listC.size(), start, length);
            return PolymorphicCollectionUtilities.anySublist(listC.getUnderlying(), listC.getSublistStartingIndex() + start, length);
        }
        if (list instanceof List) {
            return ((List)list).subList(start, start + length);
        }
        if (list instanceof CharSequence) {
            return ((CharSequence)list).subSequence(start, start + length);
        }
        if (list instanceof Buffer) {
            Buffer listC = (Buffer)list;
            CollectionUtilities.rangeCheckIntervalByLength(listC.remaining(), start, length);
            Buffer slice = NIOBufferUtilities.slice(listC);
            slice.limit(listC.position() + start + length);
            slice.position(listC.position() + start);
            return slice;
        }
        if (list.getClass().isArray()) {
            return PolymorphicCollectionUtilities.anySublist(PolymorphicCollectionUtilities.anyToList(list), start, length);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(list);
    }

    public static Object getuni(Object mapOrList, Object key) {
        if (mapOrList instanceof Map) {
            return ((Map)mapOrList).get(key);
        }
        if (mapOrList instanceof List) {
            int indexkey = MathUtilities.safeCastIntegerToS32(key);
            if (indexkey < 0 || indexkey >= ((List)mapOrList).size()) {
                return null;
            }
            return ((List)mapOrList).get(indexkey);
        }
        if (mapOrList.getClass().isArray()) {
            int indexkey = MathUtilities.safeCastIntegerToS32(key);
            if (indexkey < 0 || indexkey >= Array.getLength(mapOrList)) {
                return null;
            }
            return Array.get(mapOrList, indexkey);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(mapOrList);
    }

    public static Object getunirp(Object mapOrList, Object key) throws NoSuchMappingReturnPath {
        if (mapOrList instanceof Map) {
            return CollectionUtilities.getrp((Map)mapOrList, key);
        }
        if (mapOrList instanceof List) {
            int indexkey = MathUtilities.safeCastIntegerToS32(key);
            if (indexkey < 0 || indexkey >= ((List)mapOrList).size()) {
                throw NoSuchMappingReturnPath.I;
            }
            return ((List)mapOrList).get(indexkey);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(mapOrList);
    }

    public static void setuni(Object mapOrList, Object key, Object value) throws IndexOutOfBoundsException {
        if (mapOrList instanceof Map) {
            ((Map)mapOrList).put(key, value);
        } else if (mapOrList instanceof List) {
            int indexkey = MathUtilities.safeCastIntegerToS32(key);
            int len = ((List)mapOrList).size();
            if (indexkey < 0 || indexkey > len) {
                throw new IndexOutOfBoundsException(String.valueOf(indexkey));
            }
            if (indexkey == len) {
                ((List)mapOrList).add(value);
            } else {
                ((List)mapOrList).set(indexkey, value);
            }
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(mapOrList);
        }
    }

    public static Collection contentsuni(Object thing) {
        if (thing instanceof Map) {
            return ((Map)thing).values();
        }
        if (thing instanceof Collection) {
            return (Collection)thing;
        }
        if (thing == null) {
            return null;
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(thing);
    }

    @PerformanceSetting
    public static boolean isRandomAccessFast(Object list) {
        if (list.getClass().isArray()) {
            return true;
        }
        if (list instanceof RandomAccess) {
            return true;
        }
        return FastRandomAccess.is(list);
    }

    public static Iterator anyToReversedIterator(Object list) {
        if (list instanceof Object[]) {
            return CollectionUtilities.reversedIterator((Object[])list);
        }
        if (list instanceof ListIterator) {
            return CollectionUtilities.reversedIterator((ListIterator)list);
        }
        return CollectionUtilities.reversedIterator(PolymorphicCollectionUtilities.anyToList(list));
    }

    public static SimpleIterator anyToReversedSimpleIterator(Object list) {
        return PolymorphicCollectionUtilities.anyToSimpleIterator(PolymorphicCollectionUtilities.anyToReversedIterator(list));
    }

    public static int indexOf(Predicate predicate, @CollectionValue Object list) {
        if (list instanceof Object[]) {
            return CollectionUtilities.indexOf(predicate, (Object[])list);
        }
        if (list instanceof List) {
            return CollectionUtilities.indexOf(predicate, (List)list);
        }
        int i = 0;
        Iterator it = PolymorphicCollectionUtilities.anyToIterator(list);
        while (it.hasNext()) {
            Object element = it.next();
            if (predicate.test(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(Predicate predicate, @CollectionValue Object list) {
        return PolymorphicCollectionUtilities.indexOf(predicate, list) != -1;
    }

    public static int count(Predicate predicate, @CollectionValue Object collection) {
        if (collection instanceof Object[]) {
            return CollectionUtilities.count(predicate, (Object[])collection);
        }
        if (collection instanceof List) {
            return CollectionUtilities.count(predicate, (List)collection);
        }
        int count = 0;
        Iterator it = PolymorphicCollectionUtilities.anyToIterator(collection);
        while (it.hasNext()) {
            Object element = it.next();
            if (!predicate.test(element)) continue;
            ++count;
        }
        return count;
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static Object anyToArray(Object x, Class componentType) {
        if (x == null) {
            return null;
        }
        if (x instanceof Object[]) {
            if (componentType.isPrimitive()) {
                if (!Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(componentType).isAssignableFrom(x.getClass().getComponentType())) {
                    throw new ClassCastException("Trying to convert a " + x.getClass().getCanonicalName() + " into a " + componentType.getCanonicalName() + "[]");
                }
                return PolymorphicCollectionUtilities.anyToNewArray(x, componentType);
            }
            if (x.getClass().getComponentType() == componentType) {
                return x;
            }
            return Arrays.copyOf((Object[])x, Array.getLength(x), AngryReflectionUtility.arrayClassOf(componentType));
        }
        if (x.getClass().isArray()) {
            if (componentType.isPrimitive()) {
                if (componentType != x.getClass().getComponentType()) {
                    throw new ClassCastException("Trying to convert a " + x.getClass().getCanonicalName() + " into a " + componentType.getCanonicalName() + "[]");
                }
                return x;
            }
            if (!componentType.isAssignableFrom(Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(x.getClass().getComponentType()))) {
                throw new ClassCastException("Trying to convert a " + x.getClass().getCanonicalName() + " into a " + componentType.getCanonicalName() + "[]");
            }
            return PolymorphicCollectionUtilities.anyToNewArray(x, componentType);
        }
        if (x instanceof PrimitiveCollections.BooleanList && componentType == Boolean.TYPE) {
            return ((PrimitiveCollections.BooleanList)x).toBooleanArrayPossiblyLive();
        }
        if (x instanceof PrimitiveCollections.ByteList && componentType == Byte.TYPE) {
            return ((PrimitiveCollections.ByteList)x).toByteArrayPossiblyLive();
        }
        if (x instanceof PrimitiveCollections.CharacterList && componentType == Character.TYPE) {
            return ((PrimitiveCollections.CharacterList)x).toCharArrayPossiblyLive();
        }
        if (x instanceof PrimitiveCollections.ShortList && componentType == Short.TYPE) {
            return ((PrimitiveCollections.ShortList)x).toShortArrayPossiblyLive();
        }
        if (x instanceof PrimitiveCollections.FloatList && componentType == Float.TYPE) {
            return ((PrimitiveCollections.FloatList)x).toFloatArrayPossiblyLive();
        }
        if (x instanceof PrimitiveCollections.IntegerList && componentType == Integer.TYPE) {
            return ((PrimitiveCollections.IntegerList)x).toIntArrayPossiblyLive();
        }
        if (x instanceof PrimitiveCollections.DoubleList && componentType == Double.TYPE) {
            return ((PrimitiveCollections.DoubleList)x).toDoubleArrayPossiblyLive();
        }
        if (x instanceof PrimitiveCollections.LongList && componentType == Long.TYPE) {
            return ((PrimitiveCollections.LongList)x).toLongArrayPossiblyLive();
        }
        if (TransparentContiguousArrayBackedCollection.is(x)) {
            Slice underlyingArraySlice = ((TransparentContiguousArrayBackedCollection)x).getLiveContiguousArrayBackingUNSAFE();
            Object underlyingArray = underlyingArraySlice.getUnderlying();
            int size = underlyingArraySlice.getLength();
            int underlyingArrayOffset = underlyingArraySlice.getOffset();
            Class<?> xComponentType = underlyingArray.getClass().getComponentType();
            if (!componentType.isAssignableFrom(xComponentType)) {
                throw new ClassCastException("Source elements are " + xComponentType.getCanonicalName() + " but dest elements are " + componentType.getCanonicalName() + " it's not assignable!  :P!");
            }
            if (underlyingArrayOffset == 0 && size == Array.getLength(underlyingArray) && underlyingArray.getClass().getComponentType() == componentType) {
                return underlyingArray;
            }
            Object newArray = Array.newInstance(componentType, size);
            System.arraycopy(underlyingArray, underlyingArrayOffset, newArray, 0, size);
            return newArray;
        }
        if (x instanceof Sublist) {
            Object underlying = ((Sublist)x).getUnderlying();
            if (((Sublist)x).getSublistStartingIndex() == 0 && ((Sublist)x).size() == BasicCollectionUtilities.sizeOfCollectionlike(underlying)) {
                return PolymorphicCollectionUtilities.anyToArray(underlying, componentType);
            }
        }
        return PolymorphicCollectionUtilities.anyToNewArray(x, componentType);
    }

    @SnapshotValue
    @ThrowAwayValue
    public static Object anyToNewArray(Object x, Class componentType) throws ClassCastException {
        ArrayList<Object> list;
        if (componentType.isPrimitive()) {
            throw new IllegalArgumentException("Generics don't allow us to support primitive arrays; sorries ._.");
        }
        if (x == null) {
            throw new NullPointerException();
        }
        if (x instanceof Object[]) {
            if (!componentType.isAssignableFrom(x.getClass().getComponentType())) {
                throw new ClassCastException("Trying to convert a " + x.getClass().getCanonicalName() + " into a " + componentType.getCanonicalName() + "[]");
            }
            if (x.getClass().getComponentType() == componentType) {
                return ((Object[])x).clone();
            }
            return Arrays.copyOf((Object[])x, Array.getLength(x), AngryReflectionUtility.arrayClassOf(componentType));
        }
        if (x.getClass().isArray()) {
            if (!componentType.isAssignableFrom(Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(x.getClass().getComponentType()))) {
                throw new ClassCastException("Trying to convert a " + x.getClass().getCanonicalName() + " into a " + componentType.getCanonicalName() + "[]");
            }
            Object[] r = (Object[])Array.newInstance(componentType, Array.getLength(x));
            Primitives.boxInto(x, r);
            return r;
        }
        if (x instanceof PrimitiveCollections.BooleanList && componentType == Boolean.TYPE) {
            return ((PrimitiveCollections.BooleanList)x).toBooleanArray();
        }
        if (x instanceof PrimitiveCollections.ByteList && componentType == Byte.TYPE) {
            return ((PrimitiveCollections.ByteList)x).toByteArray();
        }
        if (x instanceof PrimitiveCollections.CharacterList && componentType == Character.TYPE) {
            return ((PrimitiveCollections.CharacterList)x).toCharArray();
        }
        if (x instanceof PrimitiveCollections.ShortList && componentType == Short.TYPE) {
            return ((PrimitiveCollections.ShortList)x).toShortArray();
        }
        if (x instanceof PrimitiveCollections.FloatList && componentType == Float.TYPE) {
            return ((PrimitiveCollections.FloatList)x).toFloatArray();
        }
        if (x instanceof PrimitiveCollections.IntegerList && componentType == Integer.TYPE) {
            return ((PrimitiveCollections.IntegerList)x).toIntArray();
        }
        if (x instanceof PrimitiveCollections.DoubleList && componentType == Double.TYPE) {
            return ((PrimitiveCollections.DoubleList)x).toDoubleArray();
        }
        if (x instanceof PrimitiveCollections.LongList && componentType == Long.TYPE) {
            return ((PrimitiveCollections.LongList)x).toLongArray();
        }
        if (TransparentContiguousArrayBackedCollection.is(x)) {
            Slice underlyingArraySlice = ((TransparentContiguousArrayBackedCollection)x).getLiveContiguousArrayBackingUNSAFE();
            Object underlyingArray = underlyingArraySlice.getUnderlying();
            int size = underlyingArraySlice.getLength();
            int underlyingArrayOffset = underlyingArraySlice.getOffset();
            Class<?> xComponentType = underlyingArray.getClass().getComponentType();
            if (!componentType.isAssignableFrom(xComponentType)) {
                throw new ClassCastException("Source elements are " + xComponentType.getCanonicalName() + " but dest elements are " + componentType.getCanonicalName() + "; it's not assignable!  :P!");
            }
            Object newArray = Array.newInstance(componentType, size);
            System.arraycopy(underlyingArray, underlyingArrayOffset, newArray, 0, size);
            return newArray;
        }
        if (x instanceof Sublist) {
            Object underlying = ((Sublist)x).getUnderlying();
            if (((Sublist)x).getSublistStartingIndex() == 0 && ((Sublist)x).size() == BasicCollectionUtilities.sizeOfCollectionlike(underlying)) {
                return PolymorphicCollectionUtilities.anyToNewArray(underlying, componentType);
            }
        }
        if (componentType.isPrimitive()) {
            Object[] objectArray = (Object[])PolymorphicCollectionUtilities.anyToArray(x, Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(componentType));
            return Primitives.unbox(objectArray);
        }
        if (x instanceof Collection) {
            return ((Collection)x).toArray((Object[])Array.newInstance(componentType, ((Collection)x).size()));
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return PolymorphicCollectionUtilities.anyToNewArray(((SimpleIterator.SimpleIterable)x).simpleIterator(), componentType);
        }
        if (x instanceof Iterable) {
            list = new ArrayList<Object>();
            for (Object e : (Iterable)x) {
                list.add(e);
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        if (x instanceof Iterator) {
            list = new ArrayList();
            while (((Iterator)x).hasNext()) {
                list.add(((Iterator)x).next());
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        if (x instanceof SimpleIterator) {
            list = new ArrayList();
            try {
                while (true) {
                    list.add(((SimpleIterator)x).nextrp());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return list.toArray((Object[])Array.newInstance(componentType, list.size()));
            }
        }
        if (x instanceof Enumeration) {
            list = new ArrayList();
            while (((Enumeration)x).hasMoreElements()) {
                list.add(((Enumeration)x).nextElement());
            }
            return list.toArray((Object[])Array.newInstance(componentType, list.size()));
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static Object[] anyToObjectArray(Object x) {
        return (Object[])PolymorphicCollectionUtilities.anyToArray(x, Object.class);
    }

    @SnapshotValue
    @ThrowAwayValue
    public static Object[] anyToNewObjectArray(Object x) {
        return (Object[])PolymorphicCollectionUtilities.anyToNewArray(x, Object.class);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static Iterable anyToIterable(final Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Iterable) {
            return (Iterable)x;
        }
        if (x instanceof Object[]) {
            return Arrays.asList((Object[])x);
        }
        if (x.getClass().isArray() || x instanceof Slice && ((Slice)x).getUnderlying().getClass().isArray()) {
            return new Iterable(){

                public Iterator iterator() {
                    return PolymorphicCollectionUtilities.anyToIterator(x);
                }
            };
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return new Iterable(){

                public Iterator iterator() {
                    return PolymorphicCollectionUtilities.anyToIterator(((SimpleIterator.SimpleIterable)x).simpleIterator());
                }
            };
        }
        if (x instanceof Iterator) {
            return PolymorphicCollectionUtilities.anyToCollection(x);
        }
        if (x instanceof Enumeration) {
            return PolymorphicCollectionUtilities.anyToCollection(x);
        }
        if (x instanceof SimpleIterator) {
            return PolymorphicCollectionUtilities.anyToCollection(x);
        }
        if (x instanceof NodeList) {
            return PolymorphicCollectionUtilities.anyToIterable(PolymorphicCollectionUtilities.anyToSimpleIterable(x));
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static SimpleIterator.SimpleIterable anyToSimpleIterable(final Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return (SimpleIterator.SimpleIterable)x;
        }
        if (x instanceof Object[] || x instanceof Iterable || x instanceof Map || x.getClass().isArray()) {
            return new SimpleIterator.SimpleIterable(){

                public SimpleIterator simpleIterator() {
                    return PolymorphicCollectionUtilities.anyToSimpleIterator(x);
                }
            };
        }
        if (x instanceof NodeList) {
            return () -> PolymorphicCollectionUtilities.anyToSimpleIterator(x);
        }
        if (x instanceof Iterator) {
            return PolymorphicCollectionUtilities.anyToSimpleIterable(PolymorphicCollectionUtilities.anyToIterable(x));
        }
        if (x instanceof Enumeration) {
            return PolymorphicCollectionUtilities.anyToSimpleIterable(PolymorphicCollectionUtilities.anyToIterable(x));
        }
        if (x instanceof SimpleIterator) {
            return PolymorphicCollectionUtilities.anyToSimpleIterable(PolymorphicCollectionUtilities.anyToIterable(x));
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static Collection anyToCollection(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Collection) {
            return (Collection)x;
        }
        if (x instanceof Object[]) {
            return PolymorphicCollectionUtilities.anyToList(x);
        }
        if (x.getClass().isArray()) {
            return PolymorphicCollectionUtilities.anyToList(x);
        }
        if (x instanceof Iterable) {
            return PolymorphicCollectionUtilities.anyToList(x);
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return PolymorphicCollectionUtilities.anyToList(x);
        }
        if (x instanceof Iterator) {
            return PolymorphicCollectionUtilities.anyToList(x);
        }
        if (x instanceof Enumeration) {
            return PolymorphicCollectionUtilities.anyToList(x);
        }
        if (x instanceof SimpleIterator) {
            return PolymorphicCollectionUtilities.anyToList(x);
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @SnapshotValue
    @ThrowAwayValue
    public static Collection anyToNewMutableVariablelengthCollection(Object x) {
        return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(x);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static List anyToList(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof List) {
            return (List)x;
        }
        if (x instanceof Slice) {
            Slice s = (Slice)x;
            int o = s.getOffset();
            return PolymorphicCollectionUtilities.anyToList(s.getUnderlying()).subList(o, o + s.getLength());
        }
        if (x instanceof Object[]) {
            return Arrays.asList((Object[])x);
        }
        if (x instanceof boolean[]) {
            return PrimitiveCollections.booleanArrayAsList((boolean[])x);
        }
        if (x instanceof byte[]) {
            return PrimitiveCollections.byteArrayAsList((byte[])x);
        }
        if (x instanceof char[]) {
            return PrimitiveCollections.charArrayAsList((char[])x);
        }
        if (x instanceof short[]) {
            return PrimitiveCollections.shortArrayAsList((short[])x);
        }
        if (x instanceof float[]) {
            return PrimitiveCollections.floatArrayAsList((float[])x);
        }
        if (x instanceof int[]) {
            return PrimitiveCollections.intArrayAsList((int[])x);
        }
        if (x instanceof double[]) {
            return PrimitiveCollections.doubleArrayAsList((double[])x);
        }
        if (x instanceof long[]) {
            return PrimitiveCollections.longArrayAsList((long[])x);
        }
        if (x instanceof Iterable) {
            return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(x);
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(x);
        }
        if (x instanceof Iterator) {
            return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(x);
        }
        if (x instanceof Enumeration) {
            return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(x);
        }
        if (x instanceof SimpleIterator) {
            return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(x);
        }
        if (x instanceof String) {
            return PolymorphicCollectionUtilities.anyToList(((String)x).toCharArray());
        }
        if (x instanceof CharSequence) {
            return PolymorphicCollectionUtilities.anyToList(((CharSequence)x).toString().toCharArray());
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @SnapshotValue
    @ThrowAwayValue
    public static List anyToNewMutableVariablelengthList(Object x) {
        if (x == null) {
            throw new NullPointerException();
        }
        if (x instanceof Object[]) {
            return new ArrayList<Object>(Arrays.asList((Object[])x));
        }
        if (x instanceof boolean[]) {
            return PrimitiveCollections.booleanArrayAsMutableList((boolean[])x);
        }
        if (x instanceof byte[]) {
            return PrimitiveCollections.byteArrayAsMutableList((byte[])x);
        }
        if (x instanceof char[]) {
            return PrimitiveCollections.charArrayAsMutableList((char[])x);
        }
        if (x instanceof short[]) {
            return PrimitiveCollections.shortArrayAsMutableList((short[])x);
        }
        if (x instanceof float[]) {
            return PrimitiveCollections.floatArrayAsMutableList((float[])x);
        }
        if (x instanceof int[]) {
            return PrimitiveCollections.intArrayAsMutableList((int[])x);
        }
        if (x instanceof double[]) {
            return PrimitiveCollections.doubleArrayAsMutableList((double[])x);
        }
        if (x instanceof long[]) {
            return PrimitiveCollections.longArrayAsMutableList((long[])x);
        }
        if (x instanceof Collection) {
            return new ArrayList((Collection)x);
        }
        if (x instanceof Iterable) {
            ArrayList list = new ArrayList();
            for (Object e : (Iterable)x) {
                list.add(e);
            }
            return list;
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(((SimpleIterator.SimpleIterable)x).simpleIterator());
        }
        if (x instanceof Iterator) {
            ArrayList list = new ArrayList();
            while (((Iterator)x).hasNext()) {
                list.add(((Iterator)x).next());
            }
            return list;
        }
        if (x instanceof Enumeration) {
            ArrayList list = new ArrayList();
            while (((Enumeration)x).hasMoreElements()) {
                list.add(((Enumeration)x).nextElement());
            }
            return list;
        }
        if (x instanceof SimpleIterator) {
            ArrayList list = new ArrayList();
            try {
                while (true) {
                    list.add(((SimpleIterator)x).nextrp());
                }
            }
            catch (StopIterationReturnPath stopIterationReturnPath) {
                return list;
            }
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static Set anyToSet(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Set) {
            return (Set)x;
        }
        if (x instanceof Object[]) {
            return PolymorphicCollectionUtilities.anyToNewMutableSet(x);
        }
        if (x.getClass().isArray()) {
            return PolymorphicCollectionUtilities.anyToNewMutableSet(x);
        }
        if (x instanceof Iterable) {
            return PolymorphicCollectionUtilities.anyToNewMutableSet(x);
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return PolymorphicCollectionUtilities.anyToNewMutableSet(x);
        }
        if (x instanceof Iterator) {
            return PolymorphicCollectionUtilities.anyToNewMutableSet(x);
        }
        if (x instanceof Enumeration) {
            return PolymorphicCollectionUtilities.anyToNewMutableSet(x);
        }
        if (x instanceof SimpleIterator) {
            return PolymorphicCollectionUtilities.anyToNewMutableSet(x);
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @SnapshotValue
    @ThrowAwayValue
    public static Set anyToNewMutableSet(Object x) {
        return PolymorphicCollectionUtilities.anyToNewMutableSet(x, false);
    }

    @SnapshotValue
    @ThrowAwayValue
    public static Set anyToNewMutableSet(Object x, boolean throwOnDuplicates) throws AlreadyExistsException {
        if (x == null) {
            throw new NullPointerException();
        }
        if (x instanceof Object[]) {
            HashSet<Object> r = new HashSet<Object>(Arrays.asList((Object[])x));
            if (r.size() != ((Object[])x).length && throwOnDuplicates) {
                throw new AlreadyExistsException();
            }
            return r;
        }
        if (x.getClass().isArray()) {
            E[] a = Primitives.box(x);
            HashSet r = new HashSet(Arrays.asList(a));
            if (r.size() != a.length && throwOnDuplicates) {
                throw new AlreadyExistsException();
            }
            return r;
        }
        if (x instanceof Collection) {
            HashSet r = new HashSet((Collection)x);
            if (r.size() != ((Collection)x).size() && throwOnDuplicates) {
                throw new AlreadyExistsException();
            }
            return r;
        }
        if (x instanceof Iterable) {
            HashSet set = new HashSet();
            for (Object e : (Iterable)x) {
                if (throwOnDuplicates) {
                    CollectionUtilities.addNewMandatory(set, e);
                    continue;
                }
                set.add(e);
            }
            return set;
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return PolymorphicCollectionUtilities.anyToNewMutableSet(((SimpleIterator.SimpleIterable)x).simpleIterator(), throwOnDuplicates);
        }
        if (x instanceof Iterator) {
            HashSet set = new HashSet();
            while (((Iterator)x).hasNext()) {
                Object e = ((Iterator)x).next();
                if (throwOnDuplicates) {
                    CollectionUtilities.addNewMandatory(set, e);
                    continue;
                }
                set.add(e);
            }
            return set;
        }
        if (x instanceof Enumeration) {
            HashSet set = new HashSet();
            while (((Enumeration)x).hasMoreElements()) {
                Object e = ((Enumeration)x).nextElement();
                if (throwOnDuplicates) {
                    CollectionUtilities.addNewMandatory(set, e);
                    continue;
                }
                set.add(e);
            }
            return set;
        }
        if (x instanceof SimpleIterator) {
            HashSet set = new HashSet();
            while (true) {
                Object e;
                try {
                    e = ((SimpleIterator)x).nextrp();
                }
                catch (StopIterationReturnPath exc) {
                    break;
                }
                if (throwOnDuplicates) {
                    CollectionUtilities.addNewMandatory(set, e);
                    continue;
                }
                set.add(e);
            }
            return set;
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @ReadonlyValue
    public static Set anyToNewSet(Object x) {
        return PolymorphicCollectionUtilities.anyToNewMutableSet(x);
    }

    @LiveValue
    public static Iterator anyToIterator(final Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Object[] || x instanceof Slice && ((Slice)x).getUnderlying() instanceof Object[]) {
            int length;
            int offset;
            Object[] array;
            if (x instanceof Object[]) {
                array = (Object[])x;
                offset = 0;
                length = Array.getLength(x);
            } else {
                Slice s = (Slice)x;
                array = (Object[])s.getUnderlying();
                offset = s.getOffset();
                length = s.getLength();
            }
            return new Iterator(){
                int cursor = 0;

                @Override
                public boolean hasNext() {
                    return this.cursor < length;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("Has only " + length + " elements, no more! sorries! ;_;");
                    }
                    Object r = array[offset + this.cursor];
                    ++this.cursor;
                    return r;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (x.getClass().isArray() || x instanceof Slice && ((Slice)x).getUnderlying().getClass().isArray()) {
            int length;
            int offset;
            Object array;
            if (x instanceof Slice) {
                Slice s = (Slice)x;
                array = s.getUnderlying();
                offset = s.getOffset();
                length = s.getLength();
            } else {
                array = x;
                offset = 0;
                length = Array.getLength(x);
            }
            return new Iterator(){
                int cursor = 0;

                @Override
                public boolean hasNext() {
                    return this.cursor < length;
                }

                public Object next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException("Has only " + length + " elements, no more! sorries! ;_;");
                    }
                    Object r = Primitives.getBoxing(array, offset + this.cursor);
                    ++this.cursor;
                    return r;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (x instanceof Iterable) {
            return ((Iterable)x).iterator();
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return PolymorphicCollectionUtilities.anyToIterator(((SimpleIterator.SimpleIterable)x).simpleIterator());
        }
        if (x instanceof NodeList) {
            return PolymorphicCollectionUtilities.anyToIterator(PolymorphicCollectionUtilities.anyToSimpleIterator(x));
        }
        if (x instanceof Iterator) {
            return (Iterator)x;
        }
        if (x instanceof Enumeration) {
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return ((Enumeration)x).hasMoreElements();
                }

                public Object next() {
                    return ((Enumeration)x).nextElement();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (x instanceof SimpleIterator) {
            return new Iterator(){
                boolean hasBuffer = false;
                Object buffer = null;

                @Override
                public boolean hasNext() {
                    try {
                        this.buffer = ((SimpleIterator)x).nextrp();
                        this.hasBuffer = true;
                        return true;
                    }
                    catch (StopIterationReturnPath exc) {
                        return false;
                    }
                }

                public Object next() {
                    if (this.hasBuffer) {
                        this.hasBuffer = false;
                        return this.buffer;
                    }
                    try {
                        return ((SimpleIterator)x).nextrp();
                    }
                    catch (StopIterationReturnPath exc) {
                        throw new NoSuchElementException();
                    }
                }

                @Override
                public void remove() {
                    if (!(x instanceof SimpleIterator.SimpleIteratorWithRemove)) {
                        throw new UnsupportedOperationException();
                    }
                    ((SimpleIterator.SimpleIteratorWithRemove)x).remove();
                }
            };
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @LiveValue
    public static Enumeration anyToEnumerator(Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof Enumeration) {
            return (Enumeration)x;
        }
        final Iterator i = PolymorphicCollectionUtilities.anyToIterator(x);
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            public Object nextElement() {
                return i.next();
            }
        };
    }

    @LiveValue
    public static SimpleIterator anyToSimpleIterator(final Object x) {
        if (x == null) {
            return null;
        }
        if (x instanceof SimpleIterator) {
            return (SimpleIterator)x;
        }
        if (x instanceof SimpleIterator.SimpleIterable) {
            return ((SimpleIterator.SimpleIterable)x).simpleIterator();
        }
        if (x instanceof Object[]) {
            return new SimpleIterator(){
                int cursor = 0;

                public Object nextrp() throws StopIterationReturnPath {
                    if (this.cursor >= ((Object[])x).length) {
                        throw StopIterationReturnPath.I;
                    }
                    Object r = ((Object[])x)[this.cursor];
                    ++this.cursor;
                    return r;
                }
            };
        }
        if (x.getClass().isArray()) {
            final int l = Array.getLength(x);
            return new SimpleIterator(){
                int cursor = 0;

                public Object nextrp() throws StopIterationReturnPath {
                    if (this.cursor >= l) {
                        throw StopIterationReturnPath.I;
                    }
                    Object r = Primitives.getBoxing(x, this.cursor);
                    ++this.cursor;
                    return r;
                }
            };
        }
        if (x instanceof NodeList) {
            final NodeList l = (NodeList)x;
            return new SimpleIterator(){
                int i = 0;

                public Object nextrp() throws StopIterationReturnPath {
                    if (this.i >= l.getLength()) {
                        throw StopIterationReturnPath.I;
                    }
                    return l.item(this.i);
                }
            };
        }
        if (x instanceof Iterable || x instanceof Iterator) {
            final Iterator i = x instanceof Iterable ? ((Iterable)x).iterator() : (Iterator)x;
            return new SimpleIterator(){

                public Object nextrp() throws StopIterationReturnPath {
                    if (!i.hasNext()) {
                        throw StopIterationReturnPath.I;
                    }
                    return i.next();
                }
            };
        }
        if (x instanceof Enumeration) {
            return new SimpleIterator(){

                public Object nextrp() throws StopIterationReturnPath {
                    if (!((Enumeration)x).hasMoreElements()) {
                        throw StopIterationReturnPath.I;
                    }
                    return ((Enumeration)x).nextElement();
                }
            };
        }
        throw new ClassCastException(String.valueOf(CollectionUtilities.Converters_ClassCastException_Message_Prefix) + x.getClass().getName() + "'s   sorries ._.");
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <T> T[] anyToArrayTyped(Object x, Class<T> componentType) {
        return (Object[])PolymorphicCollectionUtilities.anyToArray(x, componentType);
    }

    @ThrowAwayValue
    public static <T> T[] anyToNewArrayTyped(Object x, Class<T> componentType) {
        return (Object[])PolymorphicCollectionUtilities.anyToNewArray(x, componentType);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static boolean[] anyToArrayBoolean(Object x) {
        return (boolean[])PolymorphicCollectionUtilities.anyToArray(x, Boolean.TYPE);
    }

    @ThrowAwayValue
    public static boolean[] anyToNewArrayBoolean(Object x) {
        return (boolean[])PolymorphicCollectionUtilities.anyToNewArray(x, Boolean.TYPE);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static byte[] anyToArrayByte(Object x) {
        return (byte[])PolymorphicCollectionUtilities.anyToArray(x, Byte.TYPE);
    }

    @ThrowAwayValue
    public static byte[] anyToNewArrayByte(Object x) {
        return (byte[])PolymorphicCollectionUtilities.anyToNewArray(x, Byte.TYPE);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static char[] anyToArrayChar(Object x) {
        return (char[])PolymorphicCollectionUtilities.anyToArray(x, Character.TYPE);
    }

    @ThrowAwayValue
    public static char[] anyToNewArrayChar(Object x) {
        return (char[])PolymorphicCollectionUtilities.anyToNewArray(x, Character.TYPE);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static short[] anyToArrayShort(Object x) {
        return (short[])PolymorphicCollectionUtilities.anyToArray(x, Short.TYPE);
    }

    @ThrowAwayValue
    public static short[] anyToNewArrayShort(Object x) {
        return (short[])PolymorphicCollectionUtilities.anyToNewArray(x, Short.TYPE);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static float[] anyToArrayFloat(Object x) {
        return (float[])PolymorphicCollectionUtilities.anyToArray(x, Float.TYPE);
    }

    @ThrowAwayValue
    public static float[] anyToNewArrayFloat(Object x) {
        return (float[])PolymorphicCollectionUtilities.anyToNewArray(x, Float.TYPE);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static int[] anyToArrayInt(Object x) {
        return (int[])PolymorphicCollectionUtilities.anyToArray(x, Integer.TYPE);
    }

    @ThrowAwayValue
    public static int[] anyToNewArrayInt(Object x) {
        return (int[])PolymorphicCollectionUtilities.anyToNewArray(x, Integer.TYPE);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static double[] anyToArrayDouble(Object x) {
        return (double[])PolymorphicCollectionUtilities.anyToArray(x, Double.TYPE);
    }

    @ThrowAwayValue
    public static double[] anyToNewArrayDouble(Object x) {
        return (double[])PolymorphicCollectionUtilities.anyToNewArray(x, Double.TYPE);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static long[] anyToArrayLong(Object x) {
        return (long[])PolymorphicCollectionUtilities.anyToArray(x, Long.TYPE);
    }

    @ThrowAwayValue
    public static long[] anyToNewArrayLong(Object x) {
        return (long[])PolymorphicCollectionUtilities.anyToNewArray(x, Long.TYPE);
    }

    @LiveValue
    public static Iterable anyToSingleUseIterable(Object x) {
        return CollectionUtilities.singleUseIterable(PolymorphicCollectionUtilities.anyToIterator(x));
    }

    public static boolean checkSet(Object x) {
        return PolymorphicCollectionUtilities.anyToSet(x).size() == BasicCollectionUtilities.sizeOfCollectionlike(x);
    }

    public static boolean isAll(Object listOfBooleans) {
        if (listOfBooleans instanceof boolean[]) {
            boolean[] blArray = (boolean[])listOfBooleans;
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean e = blArray[n2];
                if (!e) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        for (Boolean e : PolymorphicCollectionUtilities.anyToSingleUseIterable(listOfBooleans)) {
            if (e.booleanValue()) continue;
            return false;
        }
        return true;
    }

    public static boolean isAny(Object listOfBooleans) {
        if (listOfBooleans instanceof boolean[]) {
            boolean[] blArray = (boolean[])listOfBooleans;
            int n = blArray.length;
            int n2 = 0;
            while (n2 < n) {
                boolean e = blArray[n2];
                if (e) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        for (Boolean e : PolymorphicCollectionUtilities.anyToSingleUseIterable(listOfBooleans)) {
            if (e.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Object findFirstRP(Predicate predicate, @CollectionValue Object list) throws NoSuchElementReturnPath {
        if (list instanceof Object[]) {
            return CollectionUtilities.findFirstRP(predicate, (Object[])list);
        }
        if (list instanceof List) {
            return CollectionUtilities.findFirstRP(predicate, (List)list);
        }
        Iterator it = PolymorphicCollectionUtilities.anyToIterator(list);
        while (it.hasNext()) {
            Object element = it.next();
            if (!predicate.test(element)) continue;
            return element;
        }
        throw NoSuchElementReturnPath.I;
    }

    public static void addAll(Collection self, Object source) {
        if (source instanceof Iterable) {
            CollectionUtilities.addAll(self, (Iterable)source);
        } else if (source instanceof Object[]) {
            CollectionUtilities.addAll(self, (Object[])source);
        } else {
            CollectionUtilities.addAll(self, PolymorphicCollectionUtilities.anyToSingleUseIterable(source));
        }
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static List anyToListUniqueifying(Object x) {
        return PolymorphicCollectionUtilities.anyToList(PolymorphicCollectionUtilities.anyToSet(x));
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static <E> E[] anyToArrayUniqueifying(Object x, Class<E> componentType) {
        return (Object[])PolymorphicCollectionUtilities.anyToArray(PolymorphicCollectionUtilities.anyToSet(x), componentType);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static Object[] anyToObjectArrayUniqueifying(Object x) {
        return PolymorphicCollectionUtilities.anyToObjectArray(PolymorphicCollectionUtilities.anyToSet(x));
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static List mergeLists(Object ... listthings) {
        if (listthings.length == 0) {
            return Collections.emptyList();
        }
        if (listthings.length == 1) {
            return PolymorphicCollectionUtilities.anyToList(listthings[0]);
        }
        return PolymorphicCollectionUtilities.mergeListsToNew(listthings);
    }

    @SnapshotValue
    @ThrowAwayValue
    public static List mergeListsToNew(Object ... listthings) {
        ArrayList merged = new ArrayList();
        Object[] objectArray = listthings;
        int n = listthings.length;
        int n2 = 0;
        while (n2 < n) {
            Object listthing = objectArray[n2];
            PolymorphicCollectionUtilities.addAll(merged, listthing);
            ++n2;
        }
        return merged;
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static Set mergeSets(Object ... setthings) {
        if (setthings.length == 0) {
            return Collections.emptySet();
        }
        if (setthings.length == 1) {
            return PolymorphicCollectionUtilities.anyToSet(setthings[0]);
        }
        return PolymorphicCollectionUtilities.mergeSetsToNew(setthings);
    }

    @SnapshotValue
    @ThrowAwayValue
    public static Set mergeSetsToNew(Object ... setthings) {
        HashSet merged = new HashSet();
        Object[] objectArray = setthings;
        int n = setthings.length;
        int n2 = 0;
        while (n2 < n) {
            Object listthing = objectArray[n2];
            PolymorphicCollectionUtilities.addAll(merged, listthing);
            ++n2;
        }
        return merged;
    }

    @LiveValue
    public static Object anyToUnmodifiableList(@CollectionValue Object list) {
        if (Primitives.isFalseAndNotNull(PolymorphicCollectionUtilities.isWritableCollection(list))) {
            return list;
        }
        if (list instanceof PrimitiveCollections.BooleanList) {
            return PrimitiveCollections.unmodifiableBooleanList((PrimitiveCollections.BooleanList)list);
        }
        if (list instanceof PrimitiveCollections.ByteList) {
            return PrimitiveCollections.unmodifiableByteList((PrimitiveCollections.ByteList)list);
        }
        if (list instanceof PrimitiveCollections.CharacterList) {
            return PrimitiveCollections.unmodifiableCharacterList((PrimitiveCollections.CharacterList)list);
        }
        if (list instanceof PrimitiveCollections.ShortList) {
            return PrimitiveCollections.unmodifiableShortList((PrimitiveCollections.ShortList)list);
        }
        if (list instanceof PrimitiveCollections.FloatList) {
            return PrimitiveCollections.unmodifiableFloatList((PrimitiveCollections.FloatList)list);
        }
        if (list instanceof PrimitiveCollections.IntegerList) {
            return PrimitiveCollections.unmodifiableIntegerList((PrimitiveCollections.IntegerList)list);
        }
        if (list instanceof PrimitiveCollections.DoubleList) {
            return PrimitiveCollections.unmodifiableDoubleList((PrimitiveCollections.DoubleList)list);
        }
        if (list instanceof PrimitiveCollections.LongList) {
            return PrimitiveCollections.unmodifiableLongList((PrimitiveCollections.LongList)list);
        }
        if (list instanceof List) {
            return Collections.unmodifiableList((List)list);
        }
        if (list.getClass().isArray()) {
            return PolymorphicCollectionUtilities.anyToUnmodifiableList(PolymorphicCollectionUtilities.anyToList(list));
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(list);
    }

    @Nullable
    public static Boolean isReadableCollection(@Nonnull Object collectionThing) {
        if (collectionThing == null) {
            throw new NullPointerException();
        }
        if (collectionThing instanceof RuntimeReadabilityCollection) {
            return ((RuntimeReadabilityCollection)collectionThing).isReadableCollection();
        }
        if (collectionThing.getClass().isArray()) {
            return true;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableCollection) {
            return true;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableList) {
            return true;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableSet) {
            return true;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableSortedSet) {
            return true;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Arrays_asList) {
            return true;
        }
        if (collectionThing.getClass() == ArrayList.class) {
            return true;
        }
        if (collectionThing.getClass() == HashSet.class) {
            return true;
        }
        if (collectionThing.getClass() == LinkedList.class) {
            return true;
        }
        if (collectionThing.getClass() == Vector.class) {
            return true;
        }
        if (collectionThing.getClass() == Stack.class) {
            return true;
        }
        if (collectionThing.getClass() == PriorityQueue.class) {
            return true;
        }
        return null;
    }

    @Nullable
    public static Boolean isWritableCollection(@Nonnull Object collectionThing) {
        if (collectionThing == null) {
            throw new NullPointerException();
        }
        if (collectionThing instanceof RuntimeWriteabilityCollection) {
            return ((RuntimeWriteabilityCollection)collectionThing).isWritableCollection();
        }
        if (collectionThing.getClass().isArray()) {
            return true;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableCollection) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableList) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableSet) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableSortedSet) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_emptyList) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_emptySet) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_singletonList) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_singletonSet) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Arrays_asList) {
            return true;
        }
        if (collectionThing.getClass() == ArrayList.class) {
            return true;
        }
        if (collectionThing.getClass() == HashSet.class) {
            return true;
        }
        if (collectionThing.getClass() == LinkedList.class) {
            return true;
        }
        if (collectionThing.getClass() == Vector.class) {
            return true;
        }
        if (collectionThing.getClass() == Stack.class) {
            return true;
        }
        if (collectionThing.getClass() == PriorityQueue.class) {
            return true;
        }
        return null;
    }

    public static void ensureWritableCollection(@Nonnull Object collectionThing) {
        Boolean b = PolymorphicCollectionUtilities.isWritableCollection(collectionThing);
        if (b == null) {
            throw new ReadonlyPossiblyUnsupportedOperationException();
        }
        if (!b.booleanValue()) {
            throw new ReadonlyUnsupportedOperationException();
        }
    }

    @Nullable
    public static Boolean isCollectionVariableSize(@Nonnull Object collectionThing) {
        if (collectionThing == null) {
            throw new NullPointerException();
        }
        if (collectionThing.getClass().isArray()) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableCollection) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableList) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableSet) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableSortedSet) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_emptyList) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_emptySet) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_singletonList) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Collections_singletonSet) {
            return false;
        }
        if (collectionThing.getClass() == BetterJREGlassbox.Type_Arrays_asList) {
            return false;
        }
        if (collectionThing.getClass() == ArrayList.class) {
            return true;
        }
        if (collectionThing.getClass() == HashSet.class) {
            return true;
        }
        if (collectionThing.getClass() == LinkedList.class) {
            return true;
        }
        if (collectionThing.getClass() == Vector.class) {
            return true;
        }
        if (collectionThing.getClass() == Stack.class) {
            return true;
        }
        if (collectionThing.getClass() == PriorityQueue.class) {
            return true;
        }
        if (Primitives.isFalseAndNotNull(PolymorphicCollectionUtilities.isWritableCollection(collectionThing))) {
            return false;
        }
        return null;
    }

    public static List toListMultidimensional(Object mdArray, int dimensions) {
        if (dimensions < 1) {
            throw new IllegalArgumentException();
        }
        if (dimensions == 1) {
            return PolymorphicCollectionUtilities.anyToList(mdArray);
        }
        ArrayList<List> mdList = new ArrayList<List>();
        for (Object o : PolymorphicCollectionUtilities.anyToSingleUseIterable(mdArray)) {
            mdList.add(PolymorphicCollectionUtilities.toListMultidimensional(o, dimensions - 1));
        }
        return mdList;
    }

    public static <E> List<List<E>> toList2D(Object array2d) {
        return PolymorphicCollectionUtilities.toListMultidimensional(array2d, 2);
    }

    public static boolean any(Predicate predicate, @CollectionValue Object list) {
        for (Object e : PolymorphicCollectionUtilities.anyToSingleUseIterable(list)) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static boolean all(Predicate predicate, @CollectionValue Object list) {
        for (Object e : PolymorphicCollectionUtilities.anyToSingleUseIterable(list)) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> void check(FunctionInterfaces.UnaryFunction<E, ? extends RuntimeException> thrower, @CollectionValue Object list) {
        Iterator it = PolymorphicCollectionUtilities.anyToIterator(list);
        while (it.hasNext()) {
            Object element = it.next();
            RuntimeException exc = thrower.f(element);
            if (exc == null) continue;
            throw exc;
        }
    }

    public static boolean acyclicDeepEqv(Object a, Object b) {
        if (a instanceof List && b instanceof List) {
            return CollectionUtilities.acyclicDeepEqvLists((List)a, (List)b);
        }
        if (a instanceof Map && b instanceof Map) {
            return CollectionUtilities.acyclicDeepEqvMaps((Map)a, (Map)b);
        }
        return BasicObjectUtilities.eq(a, b);
    }

    public static Boolean isFixedLengthNotVariableLength(Object x) {
        if (x instanceof KnowsLengthFixedness) {
            return ((KnowsLengthFixedness)x).isFixedLengthNotVariableLength();
        }
        if (x.getClass() == BetterJREGlassbox.Type_Arrays_asList) {
            return true;
        }
        if (x.getClass() == ArrayList.class) {
            return false;
        }
        if (x.getClass() == Vector.class) {
            return false;
        }
        if (x.getClass() == LinkedList.class) {
            return false;
        }
        if (x.getClass() == ArrayDeque.class) {
            return false;
        }
        if (x.getClass() == HashSet.class) {
            return false;
        }
        if (x.getClass() == HashMap.class) {
            return false;
        }
        if (x.getClass() == TreeSet.class) {
            return false;
        }
        if (x.getClass() == TreeMap.class) {
            return false;
        }
        if (x.getClass() == ArrayBlockingQueue.class) {
            return true;
        }
        return null;
    }
}

