/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.List;
import rebound.annotations.hints.IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.ListWithRemoveRange;

public interface NiceList<E>
extends List<E>,
ListWithRemoveRange {
    @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
    default public List<E> subListToEnd(int start) {
        return this.subList(start, this.size());
    }

    @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
    default public List<E> subListFromBeginning(int lengthWhichIsEndExclusiveInThisCaseXD) {
        return this.subList(0, lengthWhichIsEndExclusiveInThisCaseXD);
    }

    @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
    default public List<E> subListByLength(int start, int length) {
        return this.subList(start, start + length);
    }

    @Override
    default public void removeRange(int start, int pastEnd) throws IndexOutOfBoundsException {
        CollectionUtilities.rangeCheckIntervalByLength(this.size(), start, pastEnd);
        int i = pastEnd - 1;
        while (i >= start) {
            this.remove(i);
            --i;
        }
    }
}

