/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import java.io.IOException;
import rebound.annotations.semantic.temporal.NeverReturns;
import rebound.exceptions.StructuredClassCastException;
import rebound.exceptions.UnexpectedHardcodedEnumValueException;
import rebound.exceptions.UnreachableCodeException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.functional.throwing.FunctionalInterfacesThrowingCheckedExceptionsStandard;

public class BasicExceptionUtilities {
    public static void tryelse(Runnable tryBody, FunctionInterfaces.UnaryProcedureBoolean resolutionBody) {
        boolean success = false;
        try {
            tryBody.run();
            success = true;
        }
        finally {
            resolutionBody.f(success);
        }
    }

    public static void tryelse(Runnable tryBody, Runnable successBody, Runnable failureBody) {
        BasicExceptionUtilities.tryelse(tryBody, success -> {
            if (success) {
                successBody.run();
            } else {
                failureBody.run();
            }
        });
    }

    public static RuntimeException newClassCastExceptionOrNullPointerException(Object o) {
        if (o == null) {
            return new NullPointerException();
        }
        return new StructuredClassCastException(o.getClass());
    }

    public static RuntimeException newClassCastExceptionOrNullPointerException(Object o, String message) {
        if (o == null) {
            return new NullPointerException(message);
        }
        return new StructuredClassCastException(message, o.getClass());
    }

    public static RuntimeException newClassCastExceptionOrNullPointerException(Object o, Class classItWasSupposedToBe) {
        if (o == null) {
            return new NullPointerException();
        }
        return new StructuredClassCastException(o.getClass(), classItWasSupposedToBe);
    }

    public static RuntimeException newUnexpectedHardcodedEnumValueExceptionOrNullPointerException(Object o) {
        if (o == null) {
            return new NullPointerException();
        }
        return new UnexpectedHardcodedEnumValueException(o);
    }

    @NeverReturns
    public static RuntimeException rethrowSafe(Throwable target) throws RuntimeException, Error {
        if (target instanceof RuntimeException) {
            throw (RuntimeException)target;
        }
        if (target instanceof Error) {
            throw (Error)target;
        }
        throw new WrappedThrowableRuntimeException(target);
    }

    public static boolean isFatalError(Throwable t) {
        if (t instanceof Error) {
            return !(t instanceof AssertionError) && !(t instanceof LinkageError);
        }
        return false;
    }

    public static void rethrowIfFatalError(Throwable t) {
        if (t instanceof Error && !(t instanceof AssertionError) && !(t instanceof LinkageError)) {
            throw (Error)t;
        }
    }

    public static void tryFinallyProperlyThrowingAnything(FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingAnything tryBody, FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingAnything finallyBody) throws Throwable {
        try {
            tryBody.run();
        }
        finally {
            finallyBody.run();
        }
    }

    public static void tryFinallyProperlyThrowingNothing(Runnable tryBody, Runnable finallyBody) {
        try {
            BasicExceptionUtilities.tryFinallyProperlyThrowingAnything(tryBody::run, finallyBody::run);
        }
        catch (Throwable exc) {
            BasicExceptionUtilities.rethrowSafe(exc);
            throw new UnreachableCodeException();
        }
    }

    public static void tryFinallyProperlyThrowingIOException(FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingIOException tryBody, FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingIOException finallyBody) throws IOException {
        try {
            BasicExceptionUtilities.tryFinallyProperlyThrowingAnything(tryBody::run, finallyBody::run);
        }
        catch (IOException exc) {
            throw exc;
        }
        catch (Throwable exc) {
            BasicExceptionUtilities.rethrowSafe(exc);
            throw new UnreachableCodeException();
        }
    }
}

