/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.encodings.detection.detectors;

import java.nio.charset.StandardCharsets;
import rebound.dataformats.html.HTMLTextEncodingDetectorMinusXMLDetector;
import rebound.dataformats.xml.XMLTextEncodingDetector;
import rebound.text.encodings.detection.TextEncodingDetector;
import rebound.text.encodings.detection.detectors.StandardTextEditorConventionsTextEncodingDetector;
import rebound.text.encodings.detection.util.CascadedTextEncodingDetector;
import rebound.text.encodings.detection.util.ExhhaustiveTextEncodingDetector;

public class StandardTextEncodingDetection {
    private static final TextEncodingDetector CertainDetector = new CascadedTextEncodingDetector(StandardTextEditorConventionsTextEncodingDetector.I, XMLTextEncodingDetector.I, HTMLTextEncodingDetectorMinusXMLDetector.I);
    private static final TextEncodingDetector CertainPlusHeuristicsDetector = new CascadedTextEncodingDetector(CertainDetector);
    private static final TextEncodingDetector CertainPlusHeuristicsPlusExhaustiveDetector = new CascadedTextEncodingDetector(CertainPlusHeuristicsDetector, new ExhhaustiveTextEncodingDetector(StandardCharsets.UTF_8, StandardCharsets.UTF_16LE, StandardCharsets.UTF_16BE, StandardCharsets.US_ASCII, StandardCharsets.ISO_8859_1));

    public static TextEncodingDetector certain() {
        return CertainDetector;
    }

    public static TextEncodingDetector certainPlusHeuristics() {
        return CertainPlusHeuristicsDetector;
    }

    public static TextEncodingDetector certainPlusHeuristicsPlusExhaustive() {
        return CertainPlusHeuristicsPlusExhaustiveDetector;
    }
}

