/*
 * Decompiled with CFR 0.152.
 */
package rebound.math;

import java.util.Comparator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.annotations.semantic.simpledata.Negative;
import rebound.annotations.semantic.simpledata.Nonpositive;
import rebound.annotations.semantic.simpledata.Positive;
import rebound.bits.BitUtilities;
import rebound.bits.Unsigned;
import rebound.exceptions.DivisionByZeroException;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.OutOfDomainArithmeticException;
import rebound.exceptions.OverflowException;
import rebound.exceptions.TruncationException;
import rebound.math.SmallFloatMathUtilities;
import rebound.util.collections.prim.PrimitiveCollections;

public class SmallIntegerMathUtilities {
    public static Comparator<Byte> ByteComparison = (a, b) -> SmallIntegerMathUtilities.cmp(a, b);
    public static Comparator<Short> ShortComparison = (a, b) -> SmallIntegerMathUtilities.cmp(a, b);
    public static Comparator<Character> CharacterComparison = (a, b) -> SmallIntegerMathUtilities.cmp(a.charValue(), b.charValue());
    public static Comparator<Integer> IntComparison = (a, b) -> SmallIntegerMathUtilities.cmp(a, b);
    public static Comparator<Long> LongComparison = (a, b) -> SmallIntegerMathUtilities.cmp(a, b);

    public static long awayfromzeroDivision(long numerator, long divisor) {
        return SmallIntegerMathUtilities.towardzeroDivision(numerator, divisor) + (long)(numerator % divisor != 0L ? SmallIntegerMathUtilities.signum(numerator) * SmallIntegerMathUtilities.signum(divisor) : 0);
    }

    public static long towardzeroDivision(long numerator, long divisor) {
        return numerator / divisor;
    }

    public static long halftowardzeroDivision(long numerator, long divisor) {
        throw new NotYetImplementedException();
    }

    public static long halfawayfromzeroDivision(long numerator, long divisor) {
        throw new NotYetImplementedException();
    }

    public static long halfevenDivision(long numerator, long divisor) {
        throw new NotYetImplementedException();
    }

    public static int ceildiv(int numerator, int divisor) {
        return SmallIntegerMathUtilities.ceilingDivision(numerator, divisor);
    }

    public static long ceildiv(long numerator, long divisor) {
        return SmallIntegerMathUtilities.ceilingDivision(numerator, divisor);
    }

    public static int ceilingDivision(int numerator, int divisor) {
        return SmallIntegerMathUtilities.floorDivision(numerator, divisor) + (numerator % divisor != 0 ? 1 : 0);
    }

    public static int getTheOnlyOneNotXAsserting(int x, int ... values) throws AssertionError {
        int rv = x;
        boolean hasOne = false;
        int[] nArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (v != x) {
                if (hasOne) {
                    throw new IllegalArgumentException();
                }
                rv = v;
                hasOne = true;
            }
            ++n2;
        }
        return rv;
    }

    public static int getTheOnlyOneNotzeroAsserting(int ... values) throws AssertionError {
        return SmallIntegerMathUtilities.getTheOnlyOneNotXAsserting(0, values);
    }

    public static boolean unsignedAddOverflows(long a, long b, long bitlength) {
        long highestBitA = a >>> 63;
        long highestBitB = b >>> 63;
        long carryIntoHighestBit = 0L;
        long lowA = a & Integer.MAX_VALUE;
        long lowB = b & Integer.MAX_VALUE;
        carryIntoHighestBit = lowA + lowB >>> 63;
        return highestBitA + highestBitB + carryIntoHighestBit > 1L;
    }

    public static byte checkNotZeroForDivide(byte x) {
        if (x == 0) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static Byte checkNotZeroForDivide(Byte x) {
        if (x == 0) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static short checkNotZeroForDivide(short x) {
        if (x == 0) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static Short checkNotZeroForDivide(Short x) {
        if (x == 0) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static int checkNotZeroForDivide(int x) {
        if (x == 0) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static Integer checkNotZeroForDivide(Integer x) {
        if (x == 0) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static long checkNotZeroForDivide(long x) {
        if (x == 0L) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static Long checkNotZeroForDivide(Long x) {
        if (x == 0L) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static int cmp(long a, long b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmp(int a, int b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmp(short a, short b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmp(byte a, byte b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmp(char a, char b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmpChainable(int prev, long a, long b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmp(a, b);
    }

    public static int cmpChainable(int prev, int a, int b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmp(a, b);
    }

    public static int cmpChainable(int prev, short a, short b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmp(a, b);
    }

    public static int cmpChainable(int prev, byte a, byte b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmp(a, b);
    }

    public static int cmpChainable(int prev, char a, char b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmp(a, b);
    }

    public static int cmpNullAsNinf(@Nullable Long a, @Nullable Long b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmpNullAsNinf(@Nullable Integer a, @Nullable Integer b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmpNullAsNinf(@Nullable Short a, @Nullable Short b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmpNullAsNinf(@Nullable Byte a, @Nullable Byte b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmpNullAsNinf(@Nullable Character a, @Nullable Character b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.charValue() < b.charValue()) {
            return -1;
        }
        if (a.charValue() > b.charValue()) {
            return 1;
        }
        return 0;
    }

    public static int cmpChainableNullAsNinf(int prev, @Nullable Long a, @Nullable Long b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmpNullAsNinf(a, b);
    }

    public static int cmpChainableNullAsNinf(int prev, @Nullable Integer a, @Nullable Integer b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmpNullAsNinf(a, b);
    }

    public static int cmpChainableNullAsNinf(int prev, @Nullable Short a, @Nullable Short b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmpNullAsNinf(a, b);
    }

    public static int cmpChainableNullAsNinf(int prev, @Nullable Byte a, @Nullable Byte b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmpNullAsNinf(a, b);
    }

    public static int cmpChainableNullAsNinf(int prev, @Nullable Character a, @Nullable Character b) {
        return prev != 0 ? prev : SmallIntegerMathUtilities.cmpNullAsNinf(a, b);
    }

    public static int gcd(@WritableValue int[] numbers) {
        return SmallIntegerMathUtilities.gcd(numbers, 0, numbers.length);
    }

    public static int gcd(@WritableValue int[] numbers, int start, int end) {
        return SmallIntegerMathUtilities.gcd_binary(numbers, start, end);
    }

    public static int gcd_binary(@WritableValue int[] numbers, int start, int end) {
        int n = numbers.length;
        int i = 0;
        while (i < n) {
            int x = numbers[i];
            if (x < 0) {
                numbers[i] = -x;
            }
            ++i;
        }
        i = 0;
        int shift = -1;
        int cShift = 0;
        int curr = 0;
        i = start;
        while (i < end) {
            curr = numbers[i];
            if (curr != 0) {
                cShift = BitUtilities.dcd32(curr & -curr);
                if (shift == -1 || cShift < shift) {
                    shift = cShift;
                }
                numbers[i] = curr >>>= cShift;
            }
            ++i;
        }
        boolean moreThanOneLeft = false;
        boolean minimumSet = false;
        int min = 0;
        int curr2 = 0;
        boolean skippedOnce = false;
        block2: while (true) {
            moreThanOneLeft = false;
            minimumSet = false;
            min = 0;
            i = start;
            while (i < end) {
                curr2 = numbers[i];
                if (curr2 != 0) {
                    if (!minimumSet) {
                        min = curr2;
                        minimumSet = true;
                    } else {
                        moreThanOneLeft = true;
                        if (curr2 < min) {
                            min = curr2;
                        }
                    }
                }
                ++i;
            }
            if (!moreThanOneLeft) {
                return min << shift;
            }
            skippedOnce = false;
            i = start;
            while (true) {
                if (i >= end) continue block2;
                curr2 = numbers[i];
                if (curr2 != 0) {
                    if (curr2 == min && !skippedOnce) {
                        skippedOnce = true;
                    } else {
                        curr2 -= min;
                        curr2 >>>= BitUtilities.dcd32(curr2 & -curr2);
                        numbers[i] = curr2;
                    }
                }
                ++i;
            }
            break;
        }
    }

    public static int gcd(int a, int b) {
        if (a < 0) {
            a = -a;
        }
        if (b < 0) {
            b = -b;
        }
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        if (a == 1 || b == 1) {
            return 1;
        }
        int gcd = (int)SmallIntegerMathUtilities.gcd_binary(a, b);
        if (a % gcd != 0 || b % gcd != 0) {
            throw new AssertionError((Object)("Bug in GCD algorithm, for parameters: " + a + ", " + b + "  (result was " + gcd + ")"));
        }
        return gcd;
    }

    public static long gcd(long a, long b) {
        if (a < 0L) {
            a = -a;
        }
        if (b < 0L) {
            b = -b;
        }
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        if (a == 1L || b == 1L) {
            return 1L;
        }
        long gcd = SmallIntegerMathUtilities.gcd_binary(a, b);
        if (a % gcd != 0L || b % gcd != 0L) {
            throw new AssertionError((Object)("Bug in GCD algorithm, for parameters: " + a + ", " + b + "  (result was " + gcd + ")"));
        }
        return gcd;
    }

    public static int gcd_euclidean(int a, int b) {
        if (a < 0) {
            a = -a;
        }
        if (b < 0) {
            b = -b;
        }
        if (a == 0) {
            return b;
        }
        if (b == 0) {
            return a;
        }
        if (a == 1 || b == 1) {
            return 1;
        }
        int mod = 0;
        while (a != 0) {
            mod = b % a;
            b = a;
            a = mod;
        }
        return b;
    }

    public static long gcd_binary(long a, long b) {
        int bShift;
        if (a < 0L) {
            a = -a;
        }
        if (b < 0L) {
            b = -b;
        }
        if (a == 0L) {
            return b;
        }
        if (b == 0L) {
            return a;
        }
        if (a == 1L || b == 1L) {
            return 1L;
        }
        int aShift = BitUtilities.dcd64(a & -a);
        int shift = aShift > (bShift = BitUtilities.dcd64(b & -b)) ? bShift : aShift;
        a >>>= aShift;
        b >>>= bShift;
        while (true) {
            if (b > a) {
                b ^= (a ^= b);
                a ^= b;
            }
            if ((a -= b) == 0L) {
                return b << shift;
            }
            a >>>= BitUtilities.dcd64(a & -a);
        }
    }

    public static int safe_abs_s32(int a) {
        return a < 0 ? SmallIntegerMathUtilities.safe_neg_s32(a) : a;
    }

    @Nonnegative
    public static int lossyAbs(int a) {
        if (a < 0) {
            if (a == Integer.MIN_VALUE) {
                return Integer.MAX_VALUE;
            }
            return -a;
        }
        return a;
    }

    public static boolean isOverflow_neg_s32(int a) {
        return a == Integer.MIN_VALUE;
    }

    public static boolean isOverflow_neg_s64(long a) {
        return a == Long.MIN_VALUE;
    }

    public static boolean isOverflow_inc_s32(int a) {
        return a == Integer.MAX_VALUE;
    }

    public static boolean isOverflow_dec_s32(int a) {
        return a == Integer.MIN_VALUE;
    }

    public static boolean isOverflow_inc_s64(long a) {
        return a == Long.MAX_VALUE;
    }

    public static boolean isOverflow_dec_s64(long a) {
        return a == Long.MIN_VALUE;
    }

    public static boolean isOverflow_add_u32(@ActuallyUnsigned int a, @ActuallyUnsigned int b) {
        return SmallIntegerMathUtilities._isOverflow_add_u32__a(a, b);
    }

    @ImplementationTransparency
    public static boolean _isOverflow_add_u32__a(@ActuallyUnsigned int a, @ActuallyUnsigned int b) {
        return Unsigned.greaterThanU32(a, -1 - b);
    }

    @ImplementationTransparency
    public static boolean _isOverflow_add_u32__control(@ActuallyUnsigned int a, @ActuallyUnsigned int b) {
        long bb;
        long aa = Unsigned.upcast(a);
        long cc = aa + (bb = Unsigned.upcast(b));
        return cc >= 0x100000000L;
    }

    public static boolean isOverflow_add_u64(@ActuallyUnsigned long a, @ActuallyUnsigned long b) {
        return Unsigned.greaterThanU64(a, -1L - b);
    }

    public static boolean isOverflow_add_s32(int a, int b) {
        return (a ^ b) >= 0 && (a ^ a + b) < 0;
    }

    public static boolean isOverflow_sub_s32(int a, int b) {
        return (a ^ b) >= 0 && (a ^ a + b) < 0;
    }

    public static boolean isOverflow_mul_s32(int a, int b) {
        int cb;
        if (a == 0 || a == 1 || b == 0 || b == 1) {
            return false;
        }
        if (a == -1) {
            return SmallIntegerMathUtilities.isOverflow_neg_s32(b);
        }
        if (b == -1) {
            return SmallIntegerMathUtilities.isOverflow_neg_s32(a);
        }
        if (SmallIntegerMathUtilities.isOverflow_neg_s32(a) || SmallIntegerMathUtilities.isOverflow_neg_s32(b)) {
            return true;
        }
        a = Math.abs(a);
        b = Math.abs(b);
        int ah = Integer.highestOneBit(a);
        int bh = Integer.highestOneBit(b);
        int ab = BitUtilities.dcd32(ah) + 1;
        int bb = BitUtilities.dcd32(bh) + 1;
        boolean neitherArePowers = a != ah && b != bh;
        int n = cb = neitherArePowers ? ab + bb : ab + bb - 1;
        return cb > 31;
    }

    public static boolean isOverflow_add_s64(long a, long b) {
        return (a ^ b) >= 0L && (a ^ a + b) < 0L;
    }

    public static boolean isOverflow_sub_s64(long a, long b) {
        return (a ^ b) >= 0L && (a ^ a + b) < 0L;
    }

    public static boolean isOverflow_mul_s64(long a, long b) {
        int maximumNBitsRequiredForResult;
        if (a == 0L || a == 1L || b == 0L || b == 1L) {
            return false;
        }
        if (a == -1L) {
            return SmallIntegerMathUtilities.isOverflow_neg_s64(b);
        }
        if (b == -1L) {
            return SmallIntegerMathUtilities.isOverflow_neg_s64(a);
        }
        if (SmallIntegerMathUtilities.isOverflow_neg_s64(a) || SmallIntegerMathUtilities.isOverflow_neg_s64(b)) {
            return true;
        }
        a = Math.abs(a);
        b = Math.abs(b);
        long aHigh = Long.highestOneBit(a);
        long bHigh = Long.highestOneBit(b);
        int nBitsRequiredForA = BitUtilities.dcd64(aHigh) + 1;
        int nBitsRequiredForB = BitUtilities.dcd64(bHigh) + 1;
        boolean neitherArePowers = a != aHigh && b != bHigh;
        int n = maximumNBitsRequiredForResult = neitherArePowers ? nBitsRequiredForA + nBitsRequiredForB : nBitsRequiredForA + nBitsRequiredForB - 1;
        return maximumNBitsRequiredForResult > 63;
    }

    public static int safe_neg_s32(int a) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_neg_s32(a)) {
            throw new OverflowException();
        }
        return -a;
    }

    public static int safe_inc_s32(int a) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_inc_s32(a)) {
            throw new OverflowException();
        }
        return a + 1;
    }

    public static int safe_dec_s32(int a) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_dec_s32(a)) {
            throw new OverflowException();
        }
        return a - 1;
    }

    public static int safe_add_s32(int a, int b) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_add_s32(a, b)) {
            throw new OverflowException();
        }
        return a + b;
    }

    public static int safe_sub_s32(int a, int b) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_sub_s32(a, b)) {
            throw new OverflowException();
        }
        return a + b;
    }

    public static int safe_mul_s32(int a, int b) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_mul_s32(a, b)) {
            throw new OverflowException();
        }
        return a * b;
    }

    public static long safe_neg_s64(long a) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_neg_s64(a)) {
            throw new OverflowException();
        }
        return -a;
    }

    public static long safe_inc_s64(long a) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_inc_s64(a)) {
            throw new OverflowException();
        }
        return a + 1L;
    }

    public static long safe_dec_s64(long a) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_dec_s64(a)) {
            throw new OverflowException();
        }
        return a - 1L;
    }

    public static long safe_add_s64(long a, long b) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_add_s64(a, b)) {
            throw new OverflowException();
        }
        return a + b;
    }

    public static long safe_add_u64(long a, long b) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_add_u64(a, b)) {
            throw new OverflowException();
        }
        return a + b;
    }

    public static long safe_sub_s64(long a, long b) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_sub_s64(a, b)) {
            throw new OverflowException();
        }
        return a - b;
    }

    public static long safe_mul_s64(long a, long b) throws OverflowException {
        if (SmallIntegerMathUtilities.isOverflow_mul_s64(a, b)) {
            throw new OverflowException();
        }
        return a * b;
    }

    public static int safe_div_s32(int a, int b) throws TruncationException, DivisionByZeroException {
        if (b == 0) {
            throw new DivisionByZeroException();
        }
        if (a % b != 0) {
            throw new TruncationException("Lossy integer division");
        }
        return a / b;
    }

    public static long safe_div_s64(long a, long b) throws TruncationException, DivisionByZeroException {
        if (b == 0L) {
            throw new DivisionByZeroException();
        }
        if (a % b != 0L) {
            throw new TruncationException("Lossy integer division");
        }
        return a / b;
    }

    public static int losslessDivision(int numerator, int divisor) throws ArithmeticException {
        if (numerator % divisor != 0) {
            throw new ArithmeticException("Lossy division detected");
        }
        return numerator / divisor;
    }

    public static long losslessDivision(long numerator, long divisor) throws ArithmeticException {
        if (numerator % divisor != 0L) {
            throw new ArithmeticException("Lossy division detected");
        }
        return numerator / divisor;
    }

    public static int floorDivision(int numerator, int divisor) {
        boolean negative = numerator < 0 ^ divisor < 0;
        if (negative) {
            int nearzeroQuotient = numerator / divisor;
            if (nearzeroQuotient * divisor == numerator) {
                return nearzeroQuotient;
            }
            return nearzeroQuotient - 1;
        }
        if (numerator < 0 && divisor < 0) {
            numerator = -numerator;
            divisor = -divisor;
        }
        return numerator / divisor;
    }

    public static long floorDivision(long numerator, long divisor) {
        boolean negative = numerator < 0L ^ divisor < 0L;
        if (negative) {
            long nearzeroQuotient = numerator / divisor;
            if (nearzeroQuotient * divisor == numerator) {
                return nearzeroQuotient;
            }
            return nearzeroQuotient - 1L;
        }
        if (numerator < 0L && divisor < 0L) {
            numerator = -numerator;
            divisor = -divisor;
        }
        return numerator / divisor;
    }

    public static int floorLog(int value, int base) throws ArithmeticException {
        if (value <= 0) {
            throw new ArithmeticException("Log of non-positive integer");
        }
        double v = Math.log(value) / Math.log(base);
        if (v > 2.147483647E9 || v < -2.147483648E9) {
            throw new OverflowException();
        }
        int exponent = (int)v;
        return exponent;
    }

    public static int signum(long a) {
        return a > 0L ? 1 : (a < 0L ? -1 : 0);
    }

    public static int signum(int a) {
        return a > 0 ? 1 : (a < 0 ? -1 : 0);
    }

    public static int signum(short a) {
        return a > 0 ? 1 : (a < 0 ? -1 : 0);
    }

    public static int signum(byte a) {
        return a > 0 ? 1 : (a < 0 ? -1 : 0);
    }

    public static int signum(char a) {
        return a > '\u0000' ? 1 : 0;
    }

    public static long truncate(long x, long min, long max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static int truncate(int x, int min, int max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static short truncate(short x, short min, short max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static char truncate(char x, char min, char max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static byte truncate(byte x, byte min, byte max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static byte least(byte ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        byte e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static byte greatest(byte ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        byte e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] > e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static byte least(PrimitiveCollections.ByteList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        byte e = values.getByte(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getByte(i) < e) {
                e = values.getByte(i);
            }
            ++i;
        }
        return e;
    }

    public static byte greatest(PrimitiveCollections.ByteList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        byte e = values.getByte(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getByte(i) > e) {
                e = values.getByte(i);
            }
            ++i;
        }
        return e;
    }

    public static char least(char ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        char e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static char greatest(char ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        char e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] > e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static char least(PrimitiveCollections.CharacterList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        char e = values.getChar(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getChar(i) < e) {
                e = values.getChar(i);
            }
            ++i;
        }
        return e;
    }

    public static char greatest(PrimitiveCollections.CharacterList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        char e = values.getChar(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getChar(i) > e) {
                e = values.getChar(i);
            }
            ++i;
        }
        return e;
    }

    public static short least(short ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        short e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static short greatest(short ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        short e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] > e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static short least(PrimitiveCollections.ShortList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        short e = values.getShort(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getShort(i) < e) {
                e = values.getShort(i);
            }
            ++i;
        }
        return e;
    }

    public static short greatest(PrimitiveCollections.ShortList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        short e = values.getShort(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getShort(i) > e) {
                e = values.getShort(i);
            }
            ++i;
        }
        return e;
    }

    public static int least(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        int e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static int greatest(int ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        int e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] > e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static int least(PrimitiveCollections.IntegerList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        int e = values.getInt(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getInt(i) < e) {
                e = values.getInt(i);
            }
            ++i;
        }
        return e;
    }

    public static int greatest(PrimitiveCollections.IntegerList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        int e = values.getInt(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getInt(i) > e) {
                e = values.getInt(i);
            }
            ++i;
        }
        return e;
    }

    public static long least(long ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        long e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] < e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static long greatest(long ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        long e = values[0];
        int i = 1;
        while (i < values.length) {
            if (values[i] > e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static long least(PrimitiveCollections.LongList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        long e = values.getLong(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getLong(i) < e) {
                e = values.getLong(i);
            }
            ++i;
        }
        return e;
    }

    public static long greatest(PrimitiveCollections.LongList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        long e = values.getLong(0);
        int i = 1;
        while (i < values.size()) {
            if (values.getLong(i) > e) {
                e = values.getLong(i);
            }
            ++i;
        }
        return e;
    }

    public static byte least(byte a, byte b) {
        return b < a ? b : a;
    }

    public static byte greatest(byte a, byte b) {
        return b > a ? b : a;
    }

    public static char least(char a, char b) {
        return b < a ? b : a;
    }

    public static char greatest(char a, char b) {
        return b > a ? b : a;
    }

    public static short least(short a, short b) {
        return b < a ? b : a;
    }

    public static short greatest(short a, short b) {
        return b > a ? b : a;
    }

    public static int greatest(int a, int b) {
        return b > a ? b : a;
    }

    public static int least(int a, int b) {
        return b < a ? b : a;
    }

    public static long least(long a, long b) {
        return b < a ? b : a;
    }

    public static long greatest(long a, long b) {
        return b > a ? b : a;
    }

    public static byte least(byte a, byte b, byte c) {
        if (c >= a && c >= b) {
            return SmallIntegerMathUtilities.least(a, b);
        }
        if (b >= a && b >= c) {
            return SmallIntegerMathUtilities.least(a, c);
        }
        if (a >= b && a >= c) {
            return SmallIntegerMathUtilities.least(b, c);
        }
        throw new AssertionError();
    }

    public static byte greatest(byte a, byte b, byte c) {
        if (c <= a && c <= b) {
            return SmallIntegerMathUtilities.greatest(a, b);
        }
        if (b <= a && b <= c) {
            return SmallIntegerMathUtilities.greatest(a, c);
        }
        if (a <= b && a <= c) {
            return SmallIntegerMathUtilities.greatest(b, c);
        }
        throw new AssertionError();
    }

    public static byte least(byte a, byte b, byte c, byte d) {
        if (d >= a && d >= b && d >= c) {
            return SmallIntegerMathUtilities.least(a, b, c);
        }
        if (c >= a && c >= b && c >= d) {
            return SmallIntegerMathUtilities.least(a, b, d);
        }
        if (b >= a && b >= c && b >= d) {
            return SmallIntegerMathUtilities.least(a, c, d);
        }
        if (a >= b && a >= c && a >= d) {
            return SmallIntegerMathUtilities.least(b, c, d);
        }
        throw new AssertionError();
    }

    public static byte greatest(byte a, byte b, byte c, byte d) {
        if (d <= a && d <= b && d <= c) {
            return SmallIntegerMathUtilities.greatest(a, b, c);
        }
        if (c <= a && c <= b && c <= d) {
            return SmallIntegerMathUtilities.greatest(a, b, d);
        }
        if (b <= a && b <= c && b <= d) {
            return SmallIntegerMathUtilities.greatest(a, c, d);
        }
        if (a <= b && a <= c && a <= d) {
            return SmallIntegerMathUtilities.greatest(b, c, d);
        }
        throw new AssertionError();
    }

    public static short least(short a, short b, short c) {
        if (c >= a && c >= b) {
            return SmallIntegerMathUtilities.least(a, b);
        }
        if (b >= a && b >= c) {
            return SmallIntegerMathUtilities.least(a, c);
        }
        if (a >= b && a >= c) {
            return SmallIntegerMathUtilities.least(b, c);
        }
        throw new AssertionError();
    }

    public static short greatest(short a, short b, short c) {
        if (c <= a && c <= b) {
            return SmallIntegerMathUtilities.greatest(a, b);
        }
        if (b <= a && b <= c) {
            return SmallIntegerMathUtilities.greatest(a, c);
        }
        if (a <= b && a <= c) {
            return SmallIntegerMathUtilities.greatest(b, c);
        }
        throw new AssertionError();
    }

    public static short least(short a, short b, short c, short d) {
        if (d >= a && d >= b && d >= c) {
            return SmallIntegerMathUtilities.least(a, b, c);
        }
        if (c >= a && c >= b && c >= d) {
            return SmallIntegerMathUtilities.least(a, b, d);
        }
        if (b >= a && b >= c && b >= d) {
            return SmallIntegerMathUtilities.least(a, c, d);
        }
        if (a >= b && a >= c && a >= d) {
            return SmallIntegerMathUtilities.least(b, c, d);
        }
        throw new AssertionError();
    }

    public static short greatest(short a, short b, short c, short d) {
        if (d <= a && d <= b && d <= c) {
            return SmallIntegerMathUtilities.greatest(a, b, c);
        }
        if (c <= a && c <= b && c <= d) {
            return SmallIntegerMathUtilities.greatest(a, b, d);
        }
        if (b <= a && b <= c && b <= d) {
            return SmallIntegerMathUtilities.greatest(a, c, d);
        }
        if (a <= b && a <= c && a <= d) {
            return SmallIntegerMathUtilities.greatest(b, c, d);
        }
        throw new AssertionError();
    }

    public static char least(char a, char b, char c) {
        if (c >= a && c >= b) {
            return SmallIntegerMathUtilities.least(a, b);
        }
        if (b >= a && b >= c) {
            return SmallIntegerMathUtilities.least(a, c);
        }
        if (a >= b && a >= c) {
            return SmallIntegerMathUtilities.least(b, c);
        }
        throw new AssertionError();
    }

    public static char greatest(char a, char b, char c) {
        if (c <= a && c <= b) {
            return SmallIntegerMathUtilities.greatest(a, b);
        }
        if (b <= a && b <= c) {
            return SmallIntegerMathUtilities.greatest(a, c);
        }
        if (a <= b && a <= c) {
            return SmallIntegerMathUtilities.greatest(b, c);
        }
        throw new AssertionError();
    }

    public static char least(char a, char b, char c, char d) {
        if (d >= a && d >= b && d >= c) {
            return SmallIntegerMathUtilities.least(a, b, c);
        }
        if (c >= a && c >= b && c >= d) {
            return SmallIntegerMathUtilities.least(a, b, d);
        }
        if (b >= a && b >= c && b >= d) {
            return SmallIntegerMathUtilities.least(a, c, d);
        }
        if (a >= b && a >= c && a >= d) {
            return SmallIntegerMathUtilities.least(b, c, d);
        }
        throw new AssertionError();
    }

    public static char greatest(char a, char b, char c, char d) {
        if (d <= a && d <= b && d <= c) {
            return SmallIntegerMathUtilities.greatest(a, b, c);
        }
        if (c <= a && c <= b && c <= d) {
            return SmallIntegerMathUtilities.greatest(a, b, d);
        }
        if (b <= a && b <= c && b <= d) {
            return SmallIntegerMathUtilities.greatest(a, c, d);
        }
        if (a <= b && a <= c && a <= d) {
            return SmallIntegerMathUtilities.greatest(b, c, d);
        }
        throw new AssertionError();
    }

    public static int least(int a, int b, int c) {
        if (c >= a && c >= b) {
            return SmallIntegerMathUtilities.least(a, b);
        }
        if (b >= a && b >= c) {
            return SmallIntegerMathUtilities.least(a, c);
        }
        if (a >= b && a >= c) {
            return SmallIntegerMathUtilities.least(b, c);
        }
        throw new AssertionError();
    }

    public static int greatest(int a, int b, int c) {
        if (c <= a && c <= b) {
            return SmallIntegerMathUtilities.greatest(a, b);
        }
        if (b <= a && b <= c) {
            return SmallIntegerMathUtilities.greatest(a, c);
        }
        if (a <= b && a <= c) {
            return SmallIntegerMathUtilities.greatest(b, c);
        }
        throw new AssertionError();
    }

    public static int least(int a, int b, int c, int d) {
        if (d >= a && d >= b && d >= c) {
            return SmallIntegerMathUtilities.least(a, b, c);
        }
        if (c >= a && c >= b && c >= d) {
            return SmallIntegerMathUtilities.least(a, b, d);
        }
        if (b >= a && b >= c && b >= d) {
            return SmallIntegerMathUtilities.least(a, c, d);
        }
        if (a >= b && a >= c && a >= d) {
            return SmallIntegerMathUtilities.least(b, c, d);
        }
        throw new AssertionError();
    }

    public static int greatest(int a, int b, int c, int d) {
        if (d <= a && d <= b && d <= c) {
            return SmallIntegerMathUtilities.greatest(a, b, c);
        }
        if (c <= a && c <= b && c <= d) {
            return SmallIntegerMathUtilities.greatest(a, b, d);
        }
        if (b <= a && b <= c && b <= d) {
            return SmallIntegerMathUtilities.greatest(a, c, d);
        }
        if (a <= b && a <= c && a <= d) {
            return SmallIntegerMathUtilities.greatest(b, c, d);
        }
        throw new AssertionError();
    }

    public static long greatest(long a, long b, long c, long d) {
        if (d <= a && d <= b && d <= c) {
            return SmallIntegerMathUtilities.greatest(a, b, c);
        }
        if (c <= a && c <= b && c <= d) {
            return SmallIntegerMathUtilities.greatest(a, b, d);
        }
        if (b <= a && b <= c && b <= d) {
            return SmallIntegerMathUtilities.greatest(a, c, d);
        }
        if (a <= b && a <= c && a <= d) {
            return SmallIntegerMathUtilities.greatest(b, c, d);
        }
        throw new AssertionError();
    }

    public static long least(long a, long b, long c, long d) {
        if (d >= a && d >= b && d >= c) {
            return SmallIntegerMathUtilities.least(a, b, c);
        }
        if (c >= a && c >= b && c >= d) {
            return SmallIntegerMathUtilities.least(a, b, d);
        }
        if (b >= a && b >= c && b >= d) {
            return SmallIntegerMathUtilities.least(a, c, d);
        }
        if (a >= b && a >= c && a >= d) {
            return SmallIntegerMathUtilities.least(b, c, d);
        }
        throw new AssertionError();
    }

    public static long greatest(long a, long b, long c) {
        if (c <= a && c <= b) {
            return SmallIntegerMathUtilities.greatest(a, b);
        }
        if (b <= a && b <= c) {
            return SmallIntegerMathUtilities.greatest(a, c);
        }
        if (a <= b && a <= c) {
            return SmallIntegerMathUtilities.greatest(b, c);
        }
        throw new AssertionError();
    }

    public static long least(long a, long b, long c) {
        if (c >= a && c >= b) {
            return SmallIntegerMathUtilities.least(a, b);
        }
        if (b >= a && b >= c) {
            return SmallIntegerMathUtilities.least(a, c);
        }
        if (a >= b && a >= c) {
            return SmallIntegerMathUtilities.least(b, c);
        }
        throw new AssertionError((Object)(String.valueOf(a) + "," + b + "," + c));
    }

    public static long ceilingDivision(long numerator, long divisor) {
        return SmallIntegerMathUtilities.floorDivision(numerator, divisor) + (long)(numerator % divisor != 0L ? 1 : 0);
    }

    public static int progmod(int index, int highBound) {
        if (highBound == 0) {
            throw new DivisionByZeroException();
        }
        return (index % highBound + highBound) % highBound;
    }

    public static long progmod(long index, long highBound) {
        if (highBound == 0L) {
            throw new DivisionByZeroException();
        }
        return (index % highBound + highBound) % highBound;
    }

    public static char checkNotZeroForDivide(char x) {
        if (x == '\u0000') {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static Character checkNotZeroForDivide(Character x) {
        if (x.charValue() == '\u0000') {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static int lastBlockLength(int entireSizeAkaNumerator, int blockSizeAkaDenominator) {
        int r = entireSizeAkaNumerator % blockSizeAkaDenominator;
        return r == 0 ? blockSizeAkaDenominator : r;
    }

    public static long lastBlockLength(long entireSizeAkaNumerator, long blockSizeAkaDenominator) {
        long r = entireSizeAkaNumerator % blockSizeAkaDenominator;
        return r == 0L ? blockSizeAkaDenominator : r;
    }

    public static int pow(int base, int length) throws ArithmeticException, OverflowException, TruncationException {
        long rv = SmallIntegerMathUtilities.pow((long)base, (long)length);
        if ((long)((int)rv) != rv) {
            throw new OverflowException();
        }
        return (int)rv;
    }

    public static long pow(long base, long exponent) throws ArithmeticException, OverflowException, TruncationException {
        return SmallIntegerMathUtilities.pow_new(base, exponent);
    }

    public static long pow_old(long base, long exponent) throws ArithmeticException, OverflowException, TruncationException {
        double quickCheck;
        boolean negativeBase;
        if (base == 1L) {
            return 1L;
        }
        if (exponent == 0L) {
            if (base == 0L) {
                throw new ArithmeticException("0^0 is undefined");
            }
            return 1L;
        }
        if (base == -1L) {
            return exponent % 2L == 0L ? 1 : -1;
        }
        if (exponent < 0L) {
            if (base == 0L) {
                throw new ArithmeticException("0^(-P) is undefined (division by zero)");
            }
            if (base == 1L && exponent == -1L) {
                return 1L;
            }
            throw new TruncationException("x^(-P) is not an integer");
        }
        if (base == 0L) {
            return 0L;
        }
        boolean bl = negativeBase = base < 0L;
        if (negativeBase) {
            base = -base;
        }
        if ((quickCheck = Math.pow(base, exponent)) > 9.223372036854776E18) {
            throw new OverflowException();
        }
        long rv = 1L;
        long l = exponent;
        while (l > 0L) {
            if (negativeBase && -rv * base > -rv || !negativeBase && rv * base < rv) {
                throw new OverflowException();
            }
            rv *= base;
            --l;
        }
        if (negativeBase && exponent % 2L != 0L) {
            return -rv;
        }
        return rv;
    }

    public static int roundingIntegerDivision(int numerator, int divisor) {
        int negative = 0;
        if (numerator < 0) {
            numerator = -numerator;
            if (divisor < 0) {
                negative = 1;
                divisor = -divisor;
            } else {
                negative = -1;
            }
        } else if (divisor < 0) {
            negative = -1;
            divisor = -divisor;
        } else {
            negative = 1;
        }
        int result = numerator / divisor;
        int remainder = numerator % divisor;
        if (remainder * 2 >= divisor) {
            ++result;
        }
        return negative * result;
    }

    public static long roundingIntegerDivision(long numerator, long divisor) {
        int negative = 0;
        if (numerator < 0L) {
            numerator = -numerator;
            if (divisor < 0L) {
                negative = 1;
                divisor = -divisor;
            } else {
                negative = -1;
            }
        } else if (divisor < 0L) {
            negative = -1;
            divisor = -divisor;
        } else {
            negative = 1;
        }
        long result = numerator / divisor;
        long remainder = numerator % divisor;
        if (remainder * 2L >= divisor) {
            ++result;
        }
        return (long)negative * result;
    }

    public static int pow_new(int base, int exponent) throws ArithmeticException {
        if (base == 2) {
            return SmallIntegerMathUtilities.powb2_s32(exponent);
        }
        if (exponent == 0 && base == 0) {
            throw new ArithmeticException("0^0 is undefined");
        }
        if (exponent < 0) {
            if (base == 0) {
                throw new ArithmeticException("Division by zero!  (x^(-p) = 1/(x^p); 0^(-p) = 1/(0^p) = 1/0");
            }
            if (base == 1) {
                return 1;
            }
            if (base == -1) {
                return exponent % 2 == 0 ? 1 : -1;
            }
            throw new TruncationException("x^(-P) is not an integer");
        }
        long v = 1L;
        while (exponent > 0) {
            if ((v *= (long)base) > Integer.MAX_VALUE || v < Integer.MIN_VALUE) {
                throw new OverflowException();
            }
            --exponent;
        }
        return (int)v;
    }

    public static long pow_new(long base, long exponent) throws ArithmeticException {
        if (base == 2L) {
            return SmallIntegerMathUtilities.powb2_s64(exponent);
        }
        if (exponent == 0L && base == 0L) {
            throw new ArithmeticException("0^0 is undefined");
        }
        if (exponent < 0L) {
            if (base == 0L) {
                throw new ArithmeticException("Division by zero!  (x^(-p) = 1/(x^p); 0^(-p) = 1/(0^p) = 1/0");
            }
            if (base == 1L) {
                return 1L;
            }
            if (base == -1L) {
                return exponent % 2L == 0L ? 1 : -1;
            }
            throw new TruncationException("x^(-P) is not an integer");
        }
        if (base == 0L) {
            return 0L;
        }
        long pv = 0L;
        long v = 1L;
        while (exponent > 0L) {
            if ((v *= base) / base != (pv = v)) {
                throw new OverflowException();
            }
            --exponent;
        }
        return v;
    }

    public static int powb2_s32(int exponent) {
        if (exponent < 0) {
            throw new TruncationException("2^(-P) is not an integer");
        }
        if (exponent >= 31) {
            throw new OverflowException();
        }
        return 1 << exponent;
    }

    public static long powb2_s64(long exponent) {
        if (exponent < 0L) {
            throw new TruncationException("2^(-P) is not an integer");
        }
        if (exponent >= 31L) {
            throw new OverflowException();
        }
        return 1 << (int)exponent;
    }

    public static int pyr(int l) {
        return (l * l + l) / 2;
    }

    public static long[] reduceRat(long n, long d) {
        long gcd = SmallIntegerMathUtilities.gcd(n, d);
        assert (n % gcd == 0L);
        assert (d % gcd == 0L);
        return new long[]{n / gcd, d / gcd};
    }

    public static long[] reduceRat(long[] r) {
        assert (r.length == 2);
        return SmallIntegerMathUtilities.reduceRat(r[0], r[1]);
    }

    public static long[] addRatRaw(long aN, long aD, long bN, long bD) {
        long newDen = SmallIntegerMathUtilities.safe_mul_s64(aD, bD);
        return new long[]{SmallIntegerMathUtilities.safe_add_s64(SmallIntegerMathUtilities.safe_mul_s64(aN, bD), SmallIntegerMathUtilities.safe_mul_s64(bN, aD)), newDen};
    }

    public static long[] mulRatRaw(long aN, long aD, long bN, long bD) {
        return new long[]{SmallIntegerMathUtilities.safe_mul_s64(aN, bN), SmallIntegerMathUtilities.safe_mul_s64(aD, bD)};
    }

    public static long[] subRatRaw(long aN, long aD, long bN, long bD) {
        return SmallIntegerMathUtilities.addRatRaw(aN, aD, -bN, bD);
    }

    public static long[] divRatRaw(long aN, long aD, long bN, long bD) {
        return SmallIntegerMathUtilities.mulRatRaw(aN, aD, bD, bN);
    }

    public static long[] addRatReducing(long aN, long aD, long bN, long bD) {
        throw new NotYetImplementedException();
    }

    public static long[] mulRatReducing(long aN, long aD, long bN, long bD) {
        return SmallIntegerMathUtilities.reduceRat(SmallIntegerMathUtilities.mulRatRaw(aN, aD, bN, bD));
    }

    public static long[] subRatReducing(long aN, long aD, long bN, long bD) {
        return SmallIntegerMathUtilities.addRatReducing(aN, aD, -bN, bD);
    }

    public static long[] divRatReducing(long aN, long aD, long bN, long bD) {
        return SmallIntegerMathUtilities.mulRatReducing(aN, aD, bD, bN);
    }

    public static int losslessLogBase2(int value) throws TruncationException {
        if (value == 0) {
            throw new OutOfDomainArithmeticException("log(0)");
        }
        if (value < 0) {
            throw new OutOfDomainArithmeticException.ComplexNumberArithmeticException();
        }
        int exponent = BitUtilities.dcd32(value);
        if (SmallIntegerMathUtilities.powb2_s32(exponent) != value) {
            throw new TruncationException("result was not integer");
        }
        return exponent;
    }

    public static int floorLogBase2(int value) {
        if (value == 0) {
            throw new OutOfDomainArithmeticException("log(0)");
        }
        if (value < 0) {
            throw new OutOfDomainArithmeticException.ComplexNumberArithmeticException();
        }
        return BitUtilities.dcd32(BitUtilities.getHighestOneBit(value));
    }

    public static int ceilLogBase2(int value) {
        if (value == 0) {
            throw new OutOfDomainArithmeticException("log(0)");
        }
        if (value < 0) {
            throw new OutOfDomainArithmeticException.ComplexNumberArithmeticException();
        }
        int h = BitUtilities.getHighestOneBit(value);
        return BitUtilities.dcd32(h) + (value != h ? 1 : 0);
    }

    public static int losslessLogBase2(long value) throws TruncationException {
        if (value == 0L) {
            throw new OutOfDomainArithmeticException("log(0)");
        }
        if (value < 0L) {
            throw new OutOfDomainArithmeticException.ComplexNumberArithmeticException();
        }
        int exponent = BitUtilities.dcd64(value);
        if (SmallIntegerMathUtilities.powb2_s64(exponent) != value) {
            throw new TruncationException("result was not integer");
        }
        return exponent;
    }

    public static int floorLogBase2(long value) {
        if (value == 0L) {
            throw new OutOfDomainArithmeticException("log(0)");
        }
        if (value < 0L) {
            throw new OutOfDomainArithmeticException.ComplexNumberArithmeticException();
        }
        return BitUtilities.dcd64(BitUtilities.getHighestOneBit(value));
    }

    public static int ceilLogBase2(long value) {
        if (value == 0L) {
            throw new OutOfDomainArithmeticException("log(0)");
        }
        if (value < 0L) {
            throw new OutOfDomainArithmeticException.ComplexNumberArithmeticException();
        }
        long h = BitUtilities.getHighestOneBit(value);
        return BitUtilities.dcd64(h) + (value != h ? 1 : 0);
    }

    public static boolean commutativePairEq(int a, int b, int x, int y) {
        return a == x && b == y || a == y && b == x;
    }

    public static int log2(long value) {
        if (value == 0L) {
            throw new OutOfDomainArithmeticException("log(0)");
        }
        if (value < 0L) {
            throw new OutOfDomainArithmeticException.ComplexNumberArithmeticException();
        }
        int exponent = BitUtilities.dcd64(value);
        if ((long)SmallIntegerMathUtilities.powb2_s32(exponent) != value) {
            throw new TruncationException("result was not integer");
        }
        return exponent;
    }

    public static boolean doesIntegerIntervalOverflowByteWithIntSize(byte start, @Nonnegative int size) {
        return start + size < 128;
    }

    public static boolean doesIntegerIntervalOverflowShortWithIntSize(short start, @Nonnegative int size) {
        return start + size < 32768;
    }

    public static boolean doesIntegerIntervalOverflowCharWithIntSize(char start, @Nonnegative int size) {
        return start + size < 65536;
    }

    public static boolean doesIntegerIntervalOverflowIntWithIntSize(int start, @Nonnegative int size) {
        return SmallIntegerMathUtilities.isOverflow_add_s32(start, size);
    }

    public static boolean doesIntegerIntervalOverflowLongWithIntSize(long start, @Nonnegative int size) {
        return SmallIntegerMathUtilities.isOverflow_add_s64(start, size);
    }

    public static void simplifyFraction(@WritableValue @Nonnull int[] halves) {
        int n = halves[0];
        int d = halves[1];
        if (d == 0) {
            return;
        }
        boolean negative = n < 0 ^ d < 0;
        n = SmallIntegerMathUtilities.safe_abs_s32(n);
        d = SmallIntegerMathUtilities.safe_abs_s32(d);
        int gcd = SmallIntegerMathUtilities.gcd(n, d);
        n /= gcd;
        d /= gcd;
        if (negative) {
            n = -n;
        }
        halves[0] = n;
        halves[1] = d;
    }

    @ThrowAwayValue
    public static int[] simplifyFraction(int n, int d) {
        int[] halves = new int[]{n, d};
        SmallIntegerMathUtilities.simplifyFraction(halves);
        return halves;
    }

    public static byte requireNonNegative(@Nonnegative byte i) {
        if (i < 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static byte requirePositive(@Positive byte i) {
        if (i <= 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static byte requireNonPositive(@Nonpositive byte i) {
        if (i > 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static byte requireNegative(@Negative byte i) {
        if (i >= 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static byte requireNonZero(@Negative byte i) {
        if (i == 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static char requireNonNegative(@Nonnegative char i) {
        if (i < '\u0000') {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static char requirePositive(@Positive char i) {
        if (i <= '\u0000') {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static char requireNonPositive(@Nonpositive char i) {
        if (i > '\u0000') {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static char requireNegative(@Negative char i) {
        if (i >= '\u0000') {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static char requireNonZero(@Negative char i) {
        if (i == '\u0000') {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static short requireNonNegative(@Nonnegative short i) {
        if (i < 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static short requirePositive(@Positive short i) {
        if (i <= 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static short requireNonPositive(@Nonpositive short i) {
        if (i > 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static short requireNegative(@Negative short i) {
        if (i >= 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static short requireNonZero(@Negative short i) {
        if (i == 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static float requireNonNegative(@Nonnegative float i) {
        if (i < 0.0f) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static float requirePositive(@Positive float i) {
        if (i <= 0.0f) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static float requireNonPositive(@Nonpositive float i) {
        if (i > 0.0f) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static float requireNegative(@Negative float i) {
        if (i >= 0.0f) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static float requireNonZero(@Negative float i) {
        if (i == 0.0f) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static int requireNonNegative(@Nonnegative int i) {
        if (i < 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static int requirePositive(@Positive int i) {
        if (i <= 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static int requireNonPositive(@Nonpositive int i) {
        if (i > 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static int requireNegative(@Negative int i) {
        if (i >= 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static int requireNonZero(@Negative int i) {
        if (i == 0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static double requireNonNegative(@Nonnegative double i) {
        if (i < 0.0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static double requirePositive(@Positive double i) {
        if (i <= 0.0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static double requireNonPositive(@Nonpositive double i) {
        if (i > 0.0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static double requireNegative(@Negative double i) {
        if (i >= 0.0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static double requireNonZero(@Negative double i) {
        if (i == 0.0) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static long requireNonNegative(@Nonnegative long i) {
        if (i < 0L) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static long requirePositive(@Positive long i) {
        if (i <= 0L) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static long requireNonPositive(@Nonpositive long i) {
        if (i > 0L) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static long requireNegative(@Negative long i) {
        if (i >= 0L) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static long requireNonZero(@Negative long i) {
        if (i == 0L) {
            throw new IllegalArgumentException(String.valueOf(i));
        }
        return i;
    }

    public static int upmod(int n, int d) {
        int r = n % d;
        return r == 0 ? (n == 0 ? 0 : d) : r;
    }

    public static long upmod(long n, long d) {
        long r = n % d;
        return r == 0L ? (n == 0L ? 0L : d) : r;
    }

    public static int truncatingShift32(int value, @ActuallyUnsigned int bits) {
        boolean overflows = (bits & 0x1F) != bits;
        return overflows ? 0 : value << bits;
    }

    public static long truncatingShift64(long value, @ActuallyUnsigned long bits) {
        boolean overflows = (bits & 0x3FL) != bits;
        return overflows ? 0L : value << (int)bits;
    }

    @Nonnegative
    public static int floorSqrtS32(@Nonnegative int v) {
        return (int)SmallIntegerMathUtilities.floorSqrtS64(v);
    }

    @Nonnegative
    public static int ceilSqrtS32(@Nonnegative int v) {
        return (int)SmallIntegerMathUtilities.ceilSqrtS64(v);
    }

    @Nonnegative
    public static int floorSqrtU32(@ActuallyUnsigned int v) {
        return (int)SmallIntegerMathUtilities.floorSqrtS64(Unsigned.upcast(v));
    }

    @Nonnegative
    public static int ceilSqrtU32(@ActuallyUnsigned int v) {
        return (int)SmallIntegerMathUtilities.ceilSqrtS64(Unsigned.upcast(v));
    }

    @Nonnegative
    public static long floorSqrtS64(@Nonnegative long v) {
        return SmallFloatMathUtilities.roundFloorS64(Math.sqrt(v));
    }

    @Nonnegative
    public static long ceilSqrtS64(@Nonnegative long v) {
        return SmallFloatMathUtilities.roundCeilS64(Math.sqrt(v));
    }

    @Nonnegative
    public static long floorSqrtU64(@ActuallyUnsigned long v) {
        return SmallFloatMathUtilities.roundFloorS64(Math.sqrt(Unsigned.safeCastU64toF64(v)));
    }

    @Nonnegative
    public static long ceilSqrtU64(@ActuallyUnsigned long v) {
        return SmallFloatMathUtilities.roundCeilS64(Math.sqrt(Unsigned.safeCastU64toF64(v)));
    }

    public static int reverseNegativesComparison(int a, int b) {
        if (a < 0) {
            if (b < 0) {
                return SmallIntegerMathUtilities.cmp(a, b);
            }
            return 1;
        }
        if (b < 0) {
            return -1;
        }
        return SmallIntegerMathUtilities.cmp(a, b);
    }
}

