/*
 * Decompiled with CFR 0.152.
 */
package rebound.math;

import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import rebound.GlobalCodeMetastuffContext;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.bits.BitfieldSafeCasts;
import rebound.exceptions.DivisionByZeroException;
import rebound.exceptions.InfinityException;
import rebound.exceptions.NotANumberException;
import rebound.exceptions.OutOfDomainArithmeticException;
import rebound.exceptions.OverflowException;
import rebound.exceptions.TruncationException;
import rebound.math.SmallIntegerMathUtilities;
import rebound.util.CodeHinting;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.functional.FunctionInterfaces;

public class SmallFloatMathUtilities {
    public static final double SQRT2 = Math.sqrt(2.0);
    public static final double SQRT3 = Math.sqrt(3.0);
    public static final double PI2 = Math.PI * 2;
    public static final double PI3o2 = 4.71238898038469;
    public static final double PI1o2 = 1.5707963267948966;
    public static final float SQRT2f = (float)SQRT2;
    public static final float SQRT3f = (float)SQRT3;
    public static final float PI2f = (float)Math.PI * 2;
    public static final float PI3o2f = 4.712389f;
    public static final float PI1o2f = 1.5707964f;
    public static final double TAU = Math.PI * 2;
    public static final double TAU3o4 = 4.71238898038469;
    public static final double TAU1o2 = Math.PI;
    public static final double TAU1o4 = 1.5707963267948966;
    public static Comparator<Float> FloatComparison = (a, b) -> SmallFloatMathUtilities.cmp(a.floatValue(), b.floatValue());
    public static Comparator<Double> DoubleComparison = (a, b) -> SmallFloatMathUtilities.cmp(a, b);
    public static final int SizeOfSignificandInIEEE754Single = 23;
    public static final int SizeOfSignificandInIEEE754Double = 52;
    public static final int SizeOfCharacteristicInIEEE754Single = 8;
    public static final int SizeOfCharacteristicInIEEE754Double = 11;
    public static final int CharacteristicBiasInIEEE754Single = 127;
    public static final int CharacteristicBiasInIEEE754Double = 1023;
    public static final int SubnormalActualCharacteristicInIEEE754Single = -126;
    public static final int SubnormalActualCharacteristicInIEEE754Double = -1022;
    public static final int SubnormalPreCharacteristicInIEEE754 = 0;
    public static final int SubnormalPostCharacteristicInIEEE754Single = -127;
    public static final int SubnormalPostCharacteristicInIEEE754Double = -1023;
    public static final int NonfinitePostCharacteristicInIEEE754Single = 128;
    public static final int NonfinitePostCharacteristicInIEEE754Double = 1024;
    public static final int HighestPreSignificandBitInIEEE754Single = 0x400000;
    public static final long HighestPreSignificandBitInIEEE754Double = 0x8000000000000L;
    public static final double Ln2 = Math.log(2.0);

    public static boolean isNaN(float x) {
        return x != x;
    }

    public static boolean isNaN(double x) {
        return x != x;
    }

    public static boolean isNaN(Float x) {
        return x == null ? false : SmallFloatMathUtilities.isNaN(x.floatValue());
    }

    public static boolean isNaN(Double x) {
        return x == null ? false : SmallFloatMathUtilities.isNaN((double)x);
    }

    public static void checkNotNaN(float x) {
        if (SmallFloatMathUtilities.isNaN(x)) {
            throw new NotANumberException();
        }
    }

    public static void checkNotNaN(float a, float b) {
        if (SmallFloatMathUtilities.isNaN(a) || SmallFloatMathUtilities.isNaN(b)) {
            throw new NotANumberException();
        }
    }

    public static void checkNotNaN(float ... vs) {
        float[] fArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            if (SmallFloatMathUtilities.isNaN(v)) {
                throw new NotANumberException();
            }
            ++n2;
        }
    }

    public static void checkNotNaN(double x) {
        if (SmallFloatMathUtilities.isNaN(x)) {
            throw new NotANumberException();
        }
    }

    public static void checkNotNaN(double a, double b) {
        if (SmallFloatMathUtilities.isNaN(a) || SmallFloatMathUtilities.isNaN(b)) {
            throw new NotANumberException();
        }
    }

    public static void checkNotNaN(double ... vs) {
        double[] dArray = vs;
        int n = vs.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (SmallFloatMathUtilities.isNaN(v)) {
                throw new NotANumberException();
            }
            ++n2;
        }
    }

    public static void checkNotNaN(Float x) {
        if (SmallFloatMathUtilities.isNaN(x)) {
            throw new NotANumberException();
        }
    }

    public static void checkNotNaN(Double x) {
        if (SmallFloatMathUtilities.isNaN(x)) {
            throw new NotANumberException();
        }
    }

    public static boolean isFinite(float x) {
        return !Float.isInfinite(x) && !SmallFloatMathUtilities.isNaN(x);
    }

    public static boolean isFinite(double x) {
        return !Double.isInfinite(x) && !SmallFloatMathUtilities.isNaN(x);
    }

    public static float requireFinite(float x) throws NotANumberException, InfinityException {
        if (Float.isNaN(x)) {
            throw new NotANumberException();
        }
        if (Float.isInfinite(x)) {
            throw new InfinityException();
        }
        return x;
    }

    public static double requireFinite(double x) throws NotANumberException, InfinityException {
        if (Double.isNaN(x)) {
            throw new NotANumberException();
        }
        if (Double.isInfinite(x)) {
            throw new InfinityException();
        }
        return x;
    }

    public static float requireNotNaN(float x) throws NotANumberException {
        SmallFloatMathUtilities.checkNotNaN(x);
        return x;
    }

    public static double requireNotNaN(double x) throws NotANumberException {
        SmallFloatMathUtilities.checkNotNaN(x);
        return x;
    }

    public static float checkNotZeroForDivide(float x) {
        if (x == 0.0f) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static Float checkNotZeroForDivide(Float x) {
        if (x.floatValue() == 0.0f) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static double checkNotZeroForDivide(double x) {
        if (x == 0.0) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static Double checkNotZeroForDivide(Double x) {
        if (x == 0.0) {
            throw new DivisionByZeroException();
        }
        return x;
    }

    public static boolean equalWithinTolerances(double a, double b, double absoluteTolerance, double relativeTolerance) {
        if (a == b) {
            return true;
        }
        if (SmallFloatMathUtilities.isNaN(a)) {
            return SmallFloatMathUtilities.isNaN(b);
        }
        if (SmallFloatMathUtilities.isNaN(b)) {
            return false;
        }
        if (Double.isInfinite(a)) {
            return false;
        }
        if (Double.isInfinite(b)) {
            return false;
        }
        double d = Math.abs(a - b);
        return d <= absoluteTolerance || d / Math.abs((a + b) / 2.0) <= relativeTolerance;
    }

    public static boolean equalWithinRelativeTolerance(double a, double b, double tolerance) {
        if (a == b) {
            return true;
        }
        if (SmallFloatMathUtilities.isNaN(a)) {
            return SmallFloatMathUtilities.isNaN(b);
        }
        if (SmallFloatMathUtilities.isNaN(b)) {
            return false;
        }
        if (Double.isInfinite(a)) {
            return false;
        }
        if (Double.isInfinite(b)) {
            return false;
        }
        return Math.abs(a - b) / Math.abs((a + b) / 2.0) <= tolerance;
    }

    public static boolean equalWithinTolerance(double a, double b, double tolerance) {
        if (a == b) {
            return true;
        }
        if (SmallFloatMathUtilities.isNaN(a)) {
            return SmallFloatMathUtilities.isNaN(b);
        }
        if (SmallFloatMathUtilities.isNaN(b)) {
            return false;
        }
        if (Double.isInfinite(a)) {
            return false;
        }
        if (Double.isInfinite(b)) {
            return false;
        }
        return Math.abs(a - b) <= tolerance;
    }

    public static boolean equalWithinToleranceF32(float a, float b, float tolerance) {
        if (a == b) {
            return true;
        }
        if (SmallFloatMathUtilities.isNaN(a)) {
            return SmallFloatMathUtilities.isNaN(b);
        }
        if (SmallFloatMathUtilities.isNaN(b)) {
            return false;
        }
        if (Float.isInfinite(a)) {
            return false;
        }
        if (Float.isInfinite(b)) {
            return false;
        }
        return Math.abs(a - b) <= tolerance;
    }

    public static int signumToInt(float x) {
        return x > 0.0f ? 1 : (x < 0.0f ? -1 : 0);
    }

    public static int signumToInt(double x) {
        return x > 0.0 ? 1 : (x < 0.0 ? -1 : 0);
    }

    public static boolean lessThanOrFlipped(float smallerCandidate, float largerCandidate, boolean flipped) {
        return flipped ? largerCandidate < smallerCandidate : smallerCandidate < largerCandidate;
    }

    public static boolean lessThanEqualToOrFlipped(float smallerCandidate, float largerCandidate, boolean flipped) {
        return flipped ? largerCandidate <= smallerCandidate : smallerCandidate <= largerCandidate;
    }

    public static boolean lessThanOrFlipped(double smallerCandidate, double largerCandidate, boolean flipped) {
        return flipped ? largerCandidate < smallerCandidate : smallerCandidate < largerCandidate;
    }

    public static boolean lessThanEqualToOrFlipped(double smallerCandidate, double largerCandidate, boolean flipped) {
        return flipped ? largerCandidate <= smallerCandidate : smallerCandidate <= largerCandidate;
    }

    public static double arcpyr(int n) {
        return (-1.0 + Math.sqrt(1.0 + 8.0 * (double)n)) / 2.0;
    }

    public static int ceilarcpyr(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("n > 0");
        }
        int o = (int)Math.ceil(SmallFloatMathUtilities.arcpyr(n));
        if (SmallIntegerMathUtilities.pyr(o) != n) {
            throw new TruncationException();
        }
        return o;
    }

    public static int ceilarcpyrmodulus(int n) {
        return n - SmallIntegerMathUtilities.pyr(SmallFloatMathUtilities.ceilarcpyr(n));
    }

    public static int cmp(float a, float b) {
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmp(double a, double b) {
        SmallFloatMathUtilities.checkNotNaN(a);
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmpChainable(int prev, float a, float b) {
        return prev != 0 ? prev : SmallFloatMathUtilities.cmp(a, b);
    }

    public static int cmpChainable(int prev, double a, double b) {
        return prev != 0 ? prev : SmallFloatMathUtilities.cmp(a, b);
    }

    public static int cmpNullAsNinf(@Nullable Float a, @Nullable Float b) {
        SmallFloatMathUtilities.checkNotNaN(a);
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a.floatValue() < b.floatValue()) {
            return -1;
        }
        if (a.floatValue() > b.floatValue()) {
            return 1;
        }
        return 0;
    }

    public static int cmpNullAsNinf(@Nullable Double a, @Nullable Double b) {
        SmallFloatMathUtilities.checkNotNaN(a);
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        if (a < b) {
            return -1;
        }
        if (a > b) {
            return 1;
        }
        return 0;
    }

    public static int cmpChainableNullAsNinf(int prev, @Nullable Float a, @Nullable Float b) {
        return prev != 0 ? prev : SmallFloatMathUtilities.cmpNullAsNinf(a, b);
    }

    public static int cmpChainableNullAsNinf(int prev, @Nullable Double a, @Nullable Double b) {
        return prev != 0 ? prev : SmallFloatMathUtilities.cmpNullAsNinf(a, b);
    }

    public static double progmod(double n, double d) {
        if (d == 0.0) {
            return 0.0;
        }
        if (n >= 0.0) {
            return n % d;
        }
        return (n - Math.floor(n / d) * d) % d;
    }

    public static float progmod(float n, float d) {
        if (d == 0.0f) {
            return 0.0f;
        }
        if (n >= 0.0f) {
            return n % d;
        }
        return (n - (float)Math.floor(n / d) * d) % d;
    }

    public static double truncate(double x, double min, double max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static float truncate(float x, float min, float max) {
        if (x < min) {
            return min;
        }
        if (x > max) {
            return max;
        }
        return x;
    }

    public static double least(double[] values, int offset, int length) {
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        double e = values[offset + 0];
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < length) {
            SmallFloatMathUtilities.checkNotNaN(values[offset + i]);
            if (values[offset + i] < e) {
                e = values[offset + i];
            }
            ++i;
        }
        return e;
    }

    public static float least(float ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        float e = values[0];
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < values.length) {
            SmallFloatMathUtilities.checkNotNaN(values[i]);
            if (values[i] < e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static float greatest(float ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        float e = values[0];
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < values.length) {
            SmallFloatMathUtilities.checkNotNaN(values[i]);
            if (values[i] > e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static double least(double ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        double e = values[0];
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < values.length) {
            SmallFloatMathUtilities.checkNotNaN(values[i]);
            if (values[i] < e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static double greatest(double ... values) {
        if (values.length == 0) {
            throw new IllegalArgumentException();
        }
        double e = values[0];
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < values.length) {
            SmallFloatMathUtilities.checkNotNaN(values[i]);
            if (values[i] > e) {
                e = values[i];
            }
            ++i;
        }
        return e;
    }

    public static double least(PrimitiveCollections.DoubleList values, int offset, int length) {
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        double e = values.getDouble(offset + 0);
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < length) {
            SmallFloatMathUtilities.checkNotNaN(values.getDouble(offset + i));
            if (values.getDouble(offset + i) < e) {
                e = values.getDouble(offset + i);
            }
            ++i;
        }
        return e;
    }

    public static float least(PrimitiveCollections.FloatList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        float e = values.get(0).floatValue();
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < values.size()) {
            SmallFloatMathUtilities.checkNotNaN(values.getFloat(i));
            if (values.getFloat(i) < e) {
                e = values.getFloat(i);
            }
            ++i;
        }
        return e;
    }

    public static float greatest(PrimitiveCollections.FloatList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        float e = values.get(0).floatValue();
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < values.size()) {
            SmallFloatMathUtilities.checkNotNaN(values.getFloat(i));
            if (values.getFloat(i) > e) {
                e = values.getFloat(i);
            }
            ++i;
        }
        return e;
    }

    public static double least(PrimitiveCollections.DoubleList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        double e = values.get(0);
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < values.size()) {
            SmallFloatMathUtilities.checkNotNaN(values.getDouble(i));
            if (values.getDouble(i) < e) {
                e = values.getDouble(i);
            }
            ++i;
        }
        return e;
    }

    public static double greatest(PrimitiveCollections.DoubleList values) {
        if (values.size() == 0) {
            throw new IllegalArgumentException();
        }
        double e = values.get(0);
        SmallFloatMathUtilities.checkNotNaN(e);
        int i = 1;
        while (i < values.size()) {
            SmallFloatMathUtilities.checkNotNaN(values.getDouble(i));
            if (values.getDouble(i) > e) {
                e = values.getDouble(i);
            }
            ++i;
        }
        return e;
    }

    public static int leastIndex(double[] values, int offset, int length) {
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        double leastSoFar = values[offset + 0];
        int indexOfLeastSoFar = 0;
        SmallFloatMathUtilities.checkNotNaN(leastSoFar);
        int i = 1;
        while (i < length) {
            int o = offset + i;
            double v = values[o];
            SmallFloatMathUtilities.checkNotNaN(v);
            if (v < leastSoFar) {
                leastSoFar = v;
                indexOfLeastSoFar = o;
            }
            ++i;
        }
        return indexOfLeastSoFar;
    }

    public static int greatestIndexDouble(double[] values, int offset, int length) {
        return SmallFloatMathUtilities.greatestIndexDouble((int i) -> values[i], offset, length);
    }

    public static int greatestIndexDouble(PrimitiveCollections.DoubleList values, int offset, int length) {
        return SmallFloatMathUtilities.greatestIndexDouble((int i) -> values.getDouble(i), offset, length);
    }

    public static int greatestIndexDouble(FunctionInterfaces.UnaryFunctionIntToDouble values, int offset, int length) {
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        double leastSoFar = values.f(offset + 0);
        int indexOfLeastSoFar = 0;
        SmallFloatMathUtilities.checkNotNaN(leastSoFar);
        int i = 1;
        while (i < length) {
            int o = offset + i;
            double v = values.f(o);
            SmallFloatMathUtilities.checkNotNaN(v);
            if (v > leastSoFar) {
                leastSoFar = v;
                indexOfLeastSoFar = o;
            }
            ++i;
        }
        return indexOfLeastSoFar;
    }

    public static int greatestIndexFloat(float[] values, int offset, int length) {
        return SmallFloatMathUtilities.greatestIndexFloat((int i) -> values[i], offset, length);
    }

    public static int greatestIndexFloat(PrimitiveCollections.FloatList values, int offset, int length) {
        return SmallFloatMathUtilities.greatestIndexFloat((int i) -> values.getFloat(i), offset, length);
    }

    public static int greatestIndexFloat(FunctionInterfaces.UnaryFunctionIntToFloat values, int offset, int length) {
        if (length == 0) {
            throw new IllegalArgumentException();
        }
        float leastSoFar = values.f(offset + 0);
        int indexOfLeastSoFar = 0;
        SmallFloatMathUtilities.checkNotNaN(leastSoFar);
        int i = 1;
        while (i < length) {
            int o = offset + i;
            float v = values.f(o);
            SmallFloatMathUtilities.checkNotNaN(v);
            if (v > leastSoFar) {
                leastSoFar = v;
                indexOfLeastSoFar = o;
            }
            ++i;
        }
        return indexOfLeastSoFar;
    }

    public static float least(float a, float b) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        return b <= a ? b : a;
    }

    public static float greatest(float a, float b) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        return b >= a ? b : a;
    }

    public static float least(float a, float b, float c) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        SmallFloatMathUtilities.checkNotNaN(c);
        if (c >= a && c >= b) {
            return SmallFloatMathUtilities.least(a, b);
        }
        if (b >= a && b >= c) {
            return SmallFloatMathUtilities.least(a, c);
        }
        if (a >= b && a >= c) {
            return SmallFloatMathUtilities.least(b, c);
        }
        throw new AssertionError();
    }

    public static float greatest(float a, float b, float c) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        SmallFloatMathUtilities.checkNotNaN(c);
        if (c <= a && c <= b) {
            return SmallFloatMathUtilities.greatest(a, b);
        }
        if (b <= a && b <= c) {
            return SmallFloatMathUtilities.greatest(a, c);
        }
        if (a <= b && a <= c) {
            return SmallFloatMathUtilities.greatest(b, c);
        }
        throw new AssertionError();
    }

    public static float least(float a, float b, float c, float d) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        SmallFloatMathUtilities.checkNotNaN(c);
        SmallFloatMathUtilities.checkNotNaN(d);
        if (d >= a && d >= b && d >= c) {
            return SmallFloatMathUtilities.least(a, b, c);
        }
        if (c >= a && c >= b && c >= d) {
            return SmallFloatMathUtilities.least(a, b, d);
        }
        if (b >= a && b >= c && b >= d) {
            return SmallFloatMathUtilities.least(a, c, d);
        }
        if (a >= b && a >= c && a >= d) {
            return SmallFloatMathUtilities.least(b, c, d);
        }
        throw new AssertionError();
    }

    public static float greatest(float a, float b, float c, float d) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        SmallFloatMathUtilities.checkNotNaN(c);
        SmallFloatMathUtilities.checkNotNaN(d);
        if (d <= a && d <= b && d <= c) {
            return SmallFloatMathUtilities.greatest(a, b, c);
        }
        if (c <= a && c <= b && c <= d) {
            return SmallFloatMathUtilities.greatest(a, b, d);
        }
        if (b <= a && b <= c && b <= d) {
            return SmallFloatMathUtilities.greatest(a, c, d);
        }
        if (a <= b && a <= c && a <= d) {
            return SmallFloatMathUtilities.greatest(b, c, d);
        }
        throw new AssertionError();
    }

    public static double least(double a, double b) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        return b <= a ? b : a;
    }

    public static double greatest(double a, double b) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        return b >= a ? b : a;
    }

    public static double least(double a, double b, double c) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        SmallFloatMathUtilities.checkNotNaN(c);
        if (c >= a && c >= b) {
            return SmallFloatMathUtilities.least(a, b);
        }
        if (b >= a && b >= c) {
            return SmallFloatMathUtilities.least(a, c);
        }
        if (a >= b && a >= c) {
            return SmallFloatMathUtilities.least(b, c);
        }
        throw new AssertionError();
    }

    public static double greatest(double a, double b, double c) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        SmallFloatMathUtilities.checkNotNaN(c);
        if (c <= a && c <= b) {
            return SmallFloatMathUtilities.greatest(a, b);
        }
        if (b <= a && b <= c) {
            return SmallFloatMathUtilities.greatest(a, c);
        }
        if (a <= b && a <= c) {
            return SmallFloatMathUtilities.greatest(b, c);
        }
        throw new AssertionError();
    }

    public static double least(double a, double b, double c, double d) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        SmallFloatMathUtilities.checkNotNaN(c);
        SmallFloatMathUtilities.checkNotNaN(d);
        if (d >= a && d >= b && d >= c) {
            return SmallFloatMathUtilities.least(a, b, c);
        }
        if (c >= a && c >= b && c >= d) {
            return SmallFloatMathUtilities.least(a, b, d);
        }
        if (b >= a && b >= c && b >= d) {
            return SmallFloatMathUtilities.least(a, c, d);
        }
        if (a >= b && a >= c && a >= d) {
            return SmallFloatMathUtilities.least(b, c, d);
        }
        throw new AssertionError();
    }

    public static double greatest(double a, double b, double c, double d) {
        SmallFloatMathUtilities.checkNotNaN(a);
        SmallFloatMathUtilities.checkNotNaN(b);
        SmallFloatMathUtilities.checkNotNaN(c);
        SmallFloatMathUtilities.checkNotNaN(d);
        if (d <= a && d <= b && d <= c) {
            return SmallFloatMathUtilities.greatest(a, b, c);
        }
        if (c <= a && c <= b && c <= d) {
            return SmallFloatMathUtilities.greatest(a, b, d);
        }
        if (b <= a && b <= c && b <= d) {
            return SmallFloatMathUtilities.greatest(a, c, d);
        }
        if (a <= b && a <= c && a <= d) {
            return SmallFloatMathUtilities.greatest(b, c, d);
        }
        throw new AssertionError();
    }

    public static int safeCeilingToInt(double x) {
        if ((x = Math.ceil(x)) > 2.147483647E9) {
            throw new OverflowException();
        }
        if (x < -2.147483648E9) {
            throw new OverflowException();
        }
        return (int)x;
    }

    public static long safeCeilingToLong(double x) {
        if ((x = Math.ceil(x)) > 9.223372036854776E18) {
            throw new OverflowException();
        }
        if (x < -9.223372036854776E18) {
            throw new OverflowException();
        }
        return (long)x;
    }

    public static int safeFloorToInt(double x) {
        if ((x = Math.floor(x)) > 2.147483647E9) {
            throw new OverflowException();
        }
        if (x < -2.147483648E9) {
            throw new OverflowException();
        }
        return (int)x;
    }

    public static long safeFloorToLong(double x) {
        if ((x = Math.floor(x)) > 9.223372036854776E18) {
            throw new OverflowException();
        }
        if (x < -9.223372036854776E18) {
            throw new OverflowException();
        }
        return (long)x;
    }

    public static double kahanSum(double ... inputs) {
        double sum = 0.0;
        double c = 0.0;
        double y = 0.0;
        double t = 0.0;
        double[] dArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            y = x - c;
            t = sum + y;
            c = t - sum - y;
            sum = t;
            ++n2;
        }
        return sum;
    }

    public static double kahanSum(FunctionInterfaces.UnaryFunctionIntToDouble list, int count) {
        double sum = 0.0;
        double c = 0.0;
        double x = 0.0;
        double y = 0.0;
        double t = 0.0;
        int i = 0;
        while (i < count) {
            x = list.f(i);
            y = x - c;
            t = sum + y;
            c = t - sum - y;
            sum = t;
            ++i;
        }
        return sum;
    }

    public static double kahanSum(Iterable<Double> iterableOfDoubles) {
        double sum = 0.0;
        double c = 0.0;
        double y = 0.0;
        double t = 0.0;
        for (Double x : iterableOfDoubles) {
            y = x - c;
            t = sum + y;
            c = t - sum - y;
            sum = t;
        }
        return sum;
    }

    public static double recursiveSum(FunctionInterfaces.UnaryFunctionIntToDouble list, int start, int count) {
        if (count == 1) {
            return list.f(start);
        }
        return SmallFloatMathUtilities.recursiveSum(list, start, count / 2) + SmallFloatMathUtilities.recursiveSum(list, start + count / 2, count - count / 2);
    }

    public static double recursiveSum(int start, int count, double ... inputs) {
        if (count == 1) {
            return inputs[start];
        }
        return SmallFloatMathUtilities.recursiveSum(start, count / 2, inputs) + SmallFloatMathUtilities.recursiveSum(start + count / 2, count - count / 2, inputs);
    }

    public static double recursiveSum(List<Double> listOfDoubles, int start, int count) {
        if (count == 1) {
            return listOfDoubles.get(start);
        }
        return SmallFloatMathUtilities.recursiveSum(listOfDoubles, start, count / 2) + SmallFloatMathUtilities.recursiveSum(listOfDoubles, start + count / 2, count - count / 2);
    }

    public static double recursiveSum(FunctionInterfaces.UnaryFunctionIntToDouble list, int count) {
        return SmallFloatMathUtilities.recursiveSum(list, 0, count);
    }

    public static double recursiveSum(double ... inputs) {
        return SmallFloatMathUtilities.recursiveSum(0, inputs.length, inputs);
    }

    public static double recursiveSum(List<Double> listOfDoubles) {
        return SmallFloatMathUtilities.recursiveSum(listOfDoubles, 0, listOfDoubles.size());
    }

    public static double naiveSum(FunctionInterfaces.UnaryFunctionIntToDouble list, int count) {
        double s = 0.0;
        int i = 0;
        while (i < count) {
            s += list.f(i);
            ++i;
        }
        return s;
    }

    public static double naiveSum(double ... inputs) {
        double s = 0.0;
        double[] dArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            double x = dArray[n2];
            s += x;
            ++n2;
        }
        return s;
    }

    public static double naiveSum(Iterable<Double> iterableOfDoubles) {
        double s = 0.0;
        for (Double x : iterableOfDoubles) {
            s += x.doubleValue();
        }
        return s;
    }

    public static double modularAverageNormalized(double a, double b) {
        return Math.abs(a - b) <= Math.abs(a + 1.0 - b) ? (a + b) / 2.0 : (a + 1.0 + b) / 2.0 % 1.0;
    }

    public static double sq(double x) {
        return x * x;
    }

    public static double cube(double x) {
        return x * x * x;
    }

    public static double literalPower(double base, int exponent) {
        if (exponent < 0) {
            throw new IllegalArgumentException();
        }
        double exponentiation = 1.0;
        int i = 0;
        while (i < exponent) {
            exponentiation *= base;
            ++i;
        }
        return exponentiation;
    }

    public static double deg2rad(double x) {
        return x * Math.PI / 180.0;
    }

    public static double rev2rad(double x) {
        return x * (Math.PI * 2);
    }

    public static double rev2deg(double x) {
        return x * 360.0;
    }

    public static double deg2rev(double x) {
        return x / 360.0;
    }

    public static double cosr(double \u03b8rev) {
        if ((\u03b8rev = SmallFloatMathUtilities.progmod(\u03b8rev, 1.0)) == 0.0) {
            return 1.0;
        }
        if (\u03b8rev == 0.25) {
            return 0.0;
        }
        if (\u03b8rev == 0.5) {
            return -1.0;
        }
        if (\u03b8rev == 0.75) {
            return 0.0;
        }
        return Math.cos(SmallFloatMathUtilities.rev2rad(\u03b8rev));
    }

    public static double sinr(double \u03b8rev) {
        if ((\u03b8rev = SmallFloatMathUtilities.progmod(\u03b8rev, 1.0)) == 0.0) {
            return 0.0;
        }
        if (\u03b8rev == 0.25) {
            return 1.0;
        }
        if (\u03b8rev == 0.5) {
            return 0.0;
        }
        if (\u03b8rev == 0.75) {
            return -1.0;
        }
        return Math.sin(SmallFloatMathUtilities.rev2rad(\u03b8rev));
    }

    public static double tanr(double \u03b8rev) {
        if ((\u03b8rev = SmallFloatMathUtilities.progmod(\u03b8rev, 1.0)) == 0.0) {
            return 0.0;
        }
        if (\u03b8rev == 0.125) {
            return 1.0;
        }
        if (\u03b8rev == 0.25) {
            return Double.POSITIVE_INFINITY;
        }
        if (\u03b8rev == 0.375) {
            return -1.0;
        }
        if (\u03b8rev == 0.5) {
            return 0.0;
        }
        if (\u03b8rev == 0.625) {
            return 1.0;
        }
        if (\u03b8rev == 0.75) {
            return Double.NEGATIVE_INFINITY;
        }
        if (\u03b8rev == 0.875) {
            return -1.0;
        }
        return SmallFloatMathUtilities.sinr(\u03b8rev) / SmallFloatMathUtilities.cosr(\u03b8rev);
    }

    public static double cotr(double \u03b8rev) {
        if ((\u03b8rev = SmallFloatMathUtilities.progmod(\u03b8rev, 1.0)) == 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (\u03b8rev == 0.125) {
            return 1.0;
        }
        if (\u03b8rev == 0.25) {
            return 0.0;
        }
        if (\u03b8rev == 0.375) {
            return -1.0;
        }
        if (\u03b8rev == 0.5) {
            return Double.NEGATIVE_INFINITY;
        }
        if (\u03b8rev == 0.625) {
            return 1.0;
        }
        if (\u03b8rev == 0.75) {
            return 0.0;
        }
        if (\u03b8rev == 0.875) {
            return -1.0;
        }
        return SmallFloatMathUtilities.cosr(\u03b8rev) / SmallFloatMathUtilities.sinr(\u03b8rev);
    }

    public static double atanr(double yoverx) {
        if (yoverx == 0.0) {
            return 0.0;
        }
        if (yoverx == 1.0) {
            return 0.125;
        }
        if (Double.isInfinite(yoverx)) {
            return 0.25;
        }
        if (yoverx == -1.0) {
            return 0.375;
        }
        return SmallFloatMathUtilities.rad2rev(Math.atan(yoverx));
    }

    public static double acotr(double yoverx) {
        if (yoverx == 0.0) {
            return 0.25;
        }
        if (yoverx == 1.0) {
            return 0.125;
        }
        if (Double.isInfinite(yoverx)) {
            return 0.0;
        }
        if (yoverx == -1.0) {
            return 0.375;
        }
        return SmallFloatMathUtilities.rad2rev(Math.atan(1.0 / yoverx));
    }

    public static double atanr2(double y, double x) {
        if (x == 0.0) {
            return y >= 0.0 ? 0.25 : 0.75;
        }
        if (y == 0.0) {
            return x >= 0.0 ? 0.0 : 0.5;
        }
        if (x == y) {
            return CodeHinting.arbitrary(x, y) >= 0.0 ? 0.125 : 0.625;
        }
        if (-x == y) {
            return CodeHinting.arbitrary(-x, y) >= 0.0 ? 0.375 : 0.875;
        }
        return SmallFloatMathUtilities.rad2rev(Math.atan2(y, x));
    }

    public static double acotr2(double y, double x) {
        return SmallFloatMathUtilities.atanr2(x, y);
    }

    public static int denormalize(double t, int lowest, int highest, boolean strict) {
        if (SmallFloatMathUtilities.isNaN(t)) {
            GlobalCodeMetastuffContext.logBug();
            return lowest;
        }
        if (t == 0.0) {
            return lowest;
        }
        if (t == 1.0) {
            return highest;
        }
        if (t < 0.0) {
            if (strict) {
                GlobalCodeMetastuffContext.logBug();
            }
            return lowest;
        }
        if (t > 1.0) {
            if (strict) {
                GlobalCodeMetastuffContext.logBug();
            }
            return highest;
        }
        int v = (int)Math.round(t * (double)(highest - lowest) + (double)lowest);
        if (v > highest) {
            return highest;
        }
        if (v < lowest) {
            return lowest;
        }
        return v;
    }

    public static int denormalize(double t, int lowest, int highest) {
        return SmallFloatMathUtilities.denormalize(t, lowest, highest, false);
    }

    public static double calcStddev(final List<Double> input, final FunctionInterfaces.UnaryFunctionIntToLong expectedValue) {
        int inputCount = input.size();
        return Math.sqrt(SmallFloatMathUtilities.recursiveSum(new FunctionInterfaces.UnaryFunctionIntToDouble(){

            @Override
            public double f(int index) {
                double d = expectedValue.f(index) - SmallFloatMathUtilities.safeCastDoubleToS64((Double)input.get(index));
                return d * d;
            }
        }, inputCount) / (double)inputCount);
    }

    public static double calcStddev(final FunctionInterfaces.UnaryFunctionIntToLong input, final FunctionInterfaces.UnaryFunctionIntToLong expectedValue, int inputCount) {
        return Math.sqrt(SmallFloatMathUtilities.recursiveSum(new FunctionInterfaces.UnaryFunctionIntToDouble(){

            @Override
            public double f(int index) {
                double d = expectedValue.f(index) - input.f(index);
                return d * d;
            }
        }, inputCount) / (double)inputCount);
    }

    public static double calcStddev(final List<Double> input, final FunctionInterfaces.UnaryFunctionIntToDouble expectedValue) {
        int inputCount = input.size();
        return Math.sqrt(SmallFloatMathUtilities.recursiveSum(new FunctionInterfaces.UnaryFunctionIntToDouble(){

            @Override
            public double f(int index) {
                double d = expectedValue.f(index) - (double)SmallFloatMathUtilities.safeCastDoubleToS64((Double)input.get(index));
                return d * d;
            }
        }, inputCount) / (double)inputCount);
    }

    public static double calcStddev(final FunctionInterfaces.UnaryFunctionIntToDouble input, final FunctionInterfaces.UnaryFunctionIntToDouble expectedValue, int inputCount) {
        return Math.sqrt(SmallFloatMathUtilities.recursiveSum(new FunctionInterfaces.UnaryFunctionIntToDouble(){

            @Override
            public double f(int index) {
                double d = expectedValue.f(index) - input.f(index);
                return d * d;
            }
        }, inputCount) / (double)inputCount);
    }

    @ImplementationTransparency
    public static int powS32_float(int base, int exponent) throws ArithmeticException {
        if (exponent == 0) {
            if (base == 0) {
                throw new ArithmeticException("0^0 is undefined");
            }
            return 1;
        }
        if (exponent < 0) {
            if (base == 0) {
                throw new OutOfDomainArithmeticException("Division by zero!  (x^(-p) = 1/(x^p); 0^(-p) = 1/(0^p) = 1/0");
            }
            if (base == 1) {
                return 1;
            }
            if (base == -1) {
                return exponent % 2 == 0 ? 1 : -1;
            }
            throw new TruncationException("x^(-P) is not an integer");
        }
        if (base == 0) {
            return 0;
        }
        if (base == 1) {
            return 1;
        }
        if (base < 0) {
            if (base == -2 && exponent == 31) {
                return Integer.MIN_VALUE;
            }
            return exponent % 2 == 0 ? SmallIntegerMathUtilities.pow(-base, exponent) : -SmallIntegerMathUtilities.pow(-base, exponent);
        }
        double v = Math.pow(base, exponent);
        if (v <= 0.0) {
            throw new AssertionError();
        }
        if (v > 2.147483647E9) {
            throw new OverflowException();
        }
        return (int)v;
    }

    @ImplementationTransparency
    public static long powS64_float(long base, long exponent) throws ArithmeticException {
        if (exponent == 0L) {
            if (base == 0L) {
                throw new ArithmeticException("0^0 is undefined");
            }
            return 1L;
        }
        if (exponent < 0L) {
            if (base == 0L) {
                throw new ArithmeticException("Division by zero!  (x^(-p) = 1/(x^p); 0^(-p) = 1/(0^p) = 1/0");
            }
            if (base == 1L) {
                return 1L;
            }
            if (base == -1L) {
                return exponent % 2L == 0L ? 1 : -1;
            }
            throw new TruncationException("x^(-P) is not an integer");
        }
        if (base == 0L) {
            return 0L;
        }
        if (base == 1L) {
            return 1L;
        }
        if (base < 0L) {
            if (base == -2L && exponent == 31L) {
                return Integer.MIN_VALUE;
            }
            return exponent % 2L == 0L ? SmallIntegerMathUtilities.pow(-base, exponent) : -SmallIntegerMathUtilities.pow(-base, exponent);
        }
        double v = Math.pow(base, exponent);
        if (v <= 0.0) {
            throw new AssertionError();
        }
        if (v > 9.223372036854776E18) {
            throw new OverflowException();
        }
        return (long)v;
    }

    public static byte safeCastSingleToS8(float input) {
        if (input > 127.0f || input < -128.0f) {
            throw new OverflowException(String.valueOf(input) + " -> S8");
        }
        return (byte)input;
    }

    public static short safeCastSingleToS16(float input) {
        if (input > 32767.0f || input < -32768.0f) {
            throw new OverflowException(String.valueOf(input) + " -> S16");
        }
        return (short)input;
    }

    public static char safeCastSingleToU16(float input) {
        if (input > 65535.0f || input < 0.0f) {
            throw new OverflowException(String.valueOf(input) + " -> S16");
        }
        return (char)input;
    }

    public static int safeCastSingleToS32(float input) {
        if (input > 2.1474836E9f || input < -2.1474836E9f) {
            throw new OverflowException(String.valueOf(input) + " -> S32");
        }
        return (int)input;
    }

    public static long safeCastSingleToS64(float input) {
        if (input > 9.223372E18f || input < -9.223372E18f) {
            throw new OverflowException(String.valueOf(input) + " -> S64");
        }
        return (long)input;
    }

    public static byte safeCastDoubleToS8(double input) {
        if (input > 127.0 || input < -128.0) {
            throw new OverflowException(String.valueOf(input) + " -> S8");
        }
        return (byte)input;
    }

    public static short safeCastDoubleToS16(double input) {
        if (input > 32767.0 || input < -32768.0) {
            throw new OverflowException(String.valueOf(input) + " -> S16");
        }
        return (short)input;
    }

    public static char safeCastDoubleToU16(double input) {
        if (input > 65535.0 || input < 0.0) {
            throw new OverflowException(String.valueOf(input) + " -> S16");
        }
        return (char)input;
    }

    public static int safeCastDoubleToS32(double input) {
        if (input > 2.147483647E9 || input < -2.147483648E9) {
            throw new OverflowException(String.valueOf(input) + " -> S32");
        }
        return (int)input;
    }

    public static long safeCastDoubleToS64(double input) {
        if (input > 9.223372036854776E18 || input < -9.223372036854776E18) {
            throw new OverflowException(String.valueOf(input) + " -> S64");
        }
        return (long)input;
    }

    public static int safeCastIntegerValuedFloatingPointF32toS32(float x) throws OverflowException, TruncationException {
        if (SmallFloatMathUtilities.isFloatingPointOutOfS32Bounds(x)) {
            throw new OverflowException();
        }
        if (!SmallFloatMathUtilities.isFloatingPointAnInteger(x)) {
            throw new TruncationException();
        }
        return (int)x;
    }

    public static long safeCastIntegerValuedFloatingPointF32toS64(float x) throws OverflowException, TruncationException {
        if (SmallFloatMathUtilities.isFloatingPointOutOfS64Bounds(x)) {
            throw new OverflowException();
        }
        if (!SmallFloatMathUtilities.isFloatingPointAnInteger(x)) {
            throw new TruncationException();
        }
        return (long)x;
    }

    public static int safeCastIntegerValuedFloatingPointF64toS32(double x) throws OverflowException, TruncationException {
        if (SmallFloatMathUtilities.isFloatingOutOfS32Bounds(x)) {
            throw new OverflowException();
        }
        if (!SmallFloatMathUtilities.isFloatingPointAnInteger(x)) {
            throw new TruncationException();
        }
        return (int)x;
    }

    public static long safeCastIntegerValuedFloatingPointF64toS64(double x) throws OverflowException, TruncationException {
        if (SmallFloatMathUtilities.isFloatingOutOfS64Bounds(x)) {
            throw new OverflowException();
        }
        if (!SmallFloatMathUtilities.isFloatingPointAnInteger(x)) {
            throw new TruncationException();
        }
        return (long)x;
    }

    public static boolean isFloatingPointOutOfS32Bounds(float x) {
        return x < -2.1474836E9f || x > 2.1474836E9f;
    }

    public static boolean isFloatingPointOutOfS64Bounds(float x) {
        return x < -9.223372E18f || x > 9.223372E18f;
    }

    public static boolean isFloatingOutOfS32Bounds(double x) {
        return x < -2.147483648E9 || x > 2.147483647E9;
    }

    public static boolean isFloatingOutOfS64Bounds(double x) {
        return x < -9.223372036854776E18 || x > 9.223372036854776E18;
    }

    public static boolean isFloatingPointAnInteger(float x) {
        return SmallFloatMathUtilities.isFloatingPointPrimitive(x);
    }

    public static boolean isFloatingPointAnInteger(double x) {
        return Math.floor(x) == x;
    }

    public static double rad2deg(double x) {
        return x * 180.0 / Math.PI;
    }

    public static double rad2rev(double x) {
        return x / (Math.PI * 2);
    }

    public static boolean isFloatingPointPrimitive(Object x) {
        return x instanceof Float || x instanceof Double;
    }

    public static int[] rawparseIEEE754SinglePrecision(float f) {
        int bits = Float.floatToRawIntBits(f);
        int presignificand = bits & 0x7FFFFF;
        int precharacteristic = (bits & 0x7F800000) >>> 23;
        int postcharacteristic = precharacteristic - 127;
        boolean negative = (bits & Integer.MIN_VALUE) != 0;
        return new int[]{negative ? -1 : 1, presignificand, postcharacteristic};
    }

    public static long[] rawparseIEEE754DoublePrecision(double f) {
        long bits = Double.doubleToRawLongBits(f);
        long presignificand = bits & 0xFFFFFFFFFFFFFL;
        long precharacteristic = (bits & 0x7FF0000000000000L) >>> 52;
        long postcharacteristic = precharacteristic - 1023L;
        boolean negative = (bits & Long.MIN_VALUE) != 0L;
        return new long[]{negative ? -1 : 1, presignificand, postcharacteristic};
    }

    public static boolean isSubnormalFloatingPoint(float f) {
        int[] p = SmallFloatMathUtilities.rawparseIEEE754SinglePrecision(f);
        int postcharacteristic = p[2];
        return postcharacteristic == -127;
    }

    public static boolean _isFinite(float f) {
        int[] p = SmallFloatMathUtilities.rawparseIEEE754SinglePrecision(f);
        int postcharacteristic = p[2];
        return postcharacteristic != 128;
    }

    public static boolean _isPositiveInfinity(float f) {
        int[] p = SmallFloatMathUtilities.rawparseIEEE754SinglePrecision(f);
        int sign = p[0];
        int presignificand = p[1];
        int postcharacteristic = p[2];
        return postcharacteristic == 128 && presignificand == 0 && sign == 1;
    }

    public static boolean _isNegativeInfinity(float f) {
        int[] p = SmallFloatMathUtilities.rawparseIEEE754SinglePrecision(f);
        int sign = p[0];
        int presignificand = p[1];
        int postcharacteristic = p[2];
        return postcharacteristic == 128 && presignificand == 0 && sign == -1;
    }

    public static boolean _isInfinity(float f) {
        int[] p = SmallFloatMathUtilities.rawparseIEEE754SinglePrecision(f);
        int presignificand = p[1];
        int postcharacteristic = p[2];
        return postcharacteristic == 128 && presignificand == 0;
    }

    public static boolean _isNaN(float f) {
        int[] p = SmallFloatMathUtilities.rawparseIEEE754SinglePrecision(f);
        int presignificand = p[1];
        int postcharacteristic = p[2];
        return postcharacteristic == 128 && presignificand != 0;
    }

    public static boolean isQuietNaN(float f) {
        boolean highestPresignificandBit;
        int[] p = SmallFloatMathUtilities.rawparseIEEE754SinglePrecision(f);
        int presignificand = p[1];
        int postcharacteristic = p[2];
        boolean bl = highestPresignificandBit = (presignificand & 0x400000) != 0;
        return postcharacteristic == 128 && highestPresignificandBit;
    }

    public static boolean isSignallingNaN(float f) {
        boolean highestPresignificandBit;
        int[] p = SmallFloatMathUtilities.rawparseIEEE754SinglePrecision(f);
        int presignificand = p[1];
        int postcharacteristic = p[2];
        boolean bl = highestPresignificandBit = (presignificand & 0x400000) != 0;
        return postcharacteristic == 128 && presignificand != 0 && !highestPresignificandBit;
    }

    public static boolean isSubnormalFloatingPoint(double f) {
        long[] p = SmallFloatMathUtilities.rawparseIEEE754DoublePrecision(f);
        long postcharacteristic = p[2];
        return postcharacteristic == -1023L;
    }

    public static boolean _isFinite(double f) {
        long[] p = SmallFloatMathUtilities.rawparseIEEE754DoublePrecision(f);
        long postcharacteristic = p[2];
        return postcharacteristic != 1024L;
    }

    public static boolean _isPositiveInfinity(double f) {
        long[] p = SmallFloatMathUtilities.rawparseIEEE754DoublePrecision(f);
        long sign = p[0];
        long presignificand = p[1];
        long postcharacteristic = p[2];
        return postcharacteristic == 1024L && presignificand == 0L && sign == 1L;
    }

    public static boolean _isNegativeInfinity(double f) {
        long[] p = SmallFloatMathUtilities.rawparseIEEE754DoublePrecision(f);
        long sign = p[0];
        long presignificand = p[1];
        long postcharacteristic = p[2];
        return postcharacteristic == 1024L && presignificand == 0L && sign == -1L;
    }

    public static boolean _isInfinity(double f) {
        long[] p = SmallFloatMathUtilities.rawparseIEEE754DoublePrecision(f);
        long presignificand = p[1];
        long postcharacteristic = p[2];
        return postcharacteristic == 1024L && presignificand == 0L;
    }

    public static boolean _isNaN(double f) {
        long[] p = SmallFloatMathUtilities.rawparseIEEE754DoublePrecision(f);
        long presignificand = p[1];
        long postcharacteristic = p[2];
        return postcharacteristic == 1024L && presignificand != 0L;
    }

    public static boolean isQuietNaN(double f) {
        boolean highestPresignificandBit;
        long[] p = SmallFloatMathUtilities.rawparseIEEE754DoublePrecision(f);
        long presignificand = p[1];
        long postcharacteristic = p[2];
        boolean bl = highestPresignificandBit = (presignificand & 0x8000000000000L) != 0L;
        return postcharacteristic == 1024L && highestPresignificandBit;
    }

    public static boolean isSignallingNaN(double f) {
        boolean highestPresignificandBit;
        long[] p = SmallFloatMathUtilities.rawparseIEEE754DoublePrecision(f);
        long presignificand = p[1];
        long postcharacteristic = p[2];
        boolean bl = highestPresignificandBit = (presignificand & 0x8000000000000L) != 0L;
        return postcharacteristic == 1024L && presignificand != 0L && !highestPresignificandBit;
    }

    public static double relativeDifference(double a, double b) {
        if (SmallFloatMathUtilities.isNaN(a) || SmallFloatMathUtilities.isNaN(b)) {
            return Double.NaN;
        }
        double d = (Math.abs(a) + Math.abs(b)) / 2.0;
        if (d == 0.0) {
            if (a == 0.0 && b == 0.0) {
                return 0.0;
            }
            throw new AssertionError();
        }
        return (a - b) / d;
    }

    public static float relativeDifference(float a, float b) {
        if (SmallFloatMathUtilities.isNaN(a) || SmallFloatMathUtilities.isNaN(b)) {
            return Float.NaN;
        }
        float d = (Math.abs(a) + Math.abs(b)) / 2.0f;
        if (d == 0.0f) {
            if (a == 0.0f && b == 0.0f) {
                return 0.0f;
            }
            throw new AssertionError();
        }
        return (a - b) / d;
    }

    public static double relativeDifferenceAbs(double a, double b) {
        return Math.abs(SmallFloatMathUtilities.relativeDifference(a, b));
    }

    public static float relativeDifferenceAbs(float a, float b) {
        return Math.abs(SmallFloatMathUtilities.relativeDifference(a, b));
    }

    public static float avg(float a, float b) {
        return (a + b) / 2.0f;
    }

    public static float avg(float a, float b, float c) {
        return (a + b + c) / 3.0f;
    }

    public static float avg(float a, float b, float c, float d) {
        return (a + b + c + d) / 4.0f;
    }

    public static float avg(float a, float b, float c, float d, float e) {
        return (a + b + c + d + e) / 5.0f;
    }

    public static float avg(float ... input) {
        float sum = 0.0f;
        float[] fArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            float d = fArray[n2];
            sum += d;
            ++n2;
        }
        return sum / (float)input.length;
    }

    public static double avg(double a, double b) {
        return (a + b) / 2.0;
    }

    public static double avg(double a, double b, double c) {
        return (a + b + c) / 3.0;
    }

    public static double avg(double a, double b, double c, double d) {
        return (a + b + c + d) / 4.0;
    }

    public static double avg(double a, double b, double c, double d, double e) {
        return (a + b + c + d + e) / 5.0;
    }

    public static double avg(double ... input) {
        double sum = 0.0;
        double[] dArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += d;
            ++n2;
        }
        return sum / (double)input.length;
    }

    public static double absdev(double avg, double ... input) {
        double sum = 0.0;
        double[] dArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            sum += Math.abs(d - avg);
            ++n2;
        }
        return sum / (double)input.length;
    }

    public static double vardev(double avg, double ... input) {
        double sum = 0.0;
        double[] dArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            double diff = d - avg;
            sum += diff * diff;
            ++n2;
        }
        return sum / (double)input.length;
    }

    public static double stddev(double avg, double ... input) {
        return Math.sqrt(SmallFloatMathUtilities.vardev(avg, input));
    }

    public static int roundNearzeroS32(float x) {
        return (int)x;
    }

    public static int roundNearzeroS32(double x) {
        return (int)x;
    }

    public static long roundNearzeroS64(float x) {
        return (long)x;
    }

    public static long roundNearzeroS64(double x) {
        return (long)x;
    }

    public static int roundFloorS32(float x) {
        return (int)Math.floor(x);
    }

    public static int roundFloorS32(double x) {
        return (int)Math.floor(x);
    }

    public static long roundFloorS64(float x) {
        return (long)Math.floor(x);
    }

    public static long roundFloorS64(double x) {
        return (long)Math.floor(x);
    }

    public static int roundCeilS32(float x) {
        return (int)Math.ceil(x);
    }

    public static int roundCeilS32(double x) {
        return (int)Math.ceil(x);
    }

    public static long roundCeilS64(float x) {
        return (long)Math.ceil(x);
    }

    public static long roundCeilS64(double x) {
        return (long)Math.ceil(x);
    }

    public static int roundClosestArbtiesS32(float x) {
        return Math.round(x);
    }

    public static int roundClosestArbtiesS32(double x) {
        return BitfieldSafeCasts.safeCastS64toS32(Math.round(x));
    }

    public static long roundClosestArbtiesS64(float x) {
        return Math.round((double)x);
    }

    public static long roundClosestArbtiesS64(double x) {
        return Math.round(x);
    }

    public static long roundTruncatingClosestArbtiesS64(double x) {
        SmallFloatMathUtilities.requireNotNaN(x);
        return Math.round(x);
    }

    public static int roundTruncatingClosestArbtiesS32(double x) {
        SmallFloatMathUtilities.requireNotNaN(x);
        long i = Math.round(x);
        i = SmallIntegerMathUtilities.greatest(Integer.MIN_VALUE, i);
        i = SmallIntegerMathUtilities.least(Integer.MAX_VALUE, i);
        return BitfieldSafeCasts.safeCastS64toS32(i);
    }

    public static int roundTruncatingClosestArbtiesS32(float x) {
        SmallFloatMathUtilities.requireNotNaN(x);
        return Math.round(x);
    }

    public static double log2(double x) {
        return Math.log(x) / Ln2;
    }

    public static double pow2(double x) {
        return Math.pow(2.0, x);
    }

    public static double log(double x, double base) {
        return Math.log(x) / Math.log(base);
    }
}

