/*
 * Decompiled with CFR 0.152.
 */
package rebound.math;

import java.io.Serializable;
import rebound.GlobalCodeMetastuffContext;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.semantic.simpledata.MayNormalizePrimitives;
import rebound.exceptions.DivisionByZeroException;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.TruncationException;
import rebound.math.MathUtilities;
import rebound.math.Rational;
import rebound.math.SmallFloatMathUtilities;
import rebound.util.ValueType;

public class ImmutableRational
extends Number
implements Rational,
Serializable,
ValueType {
    private static final long serialVersionUID = 1L;
    protected final Object numerator;
    protected final Object denominator;

    @ImplementationTransparency
    @MayNormalizePrimitives
    public ImmutableRational(Object numerator, Object denominator) {
        numerator = MathUtilities.normalizeNumberToRationalOrInteger(numerator);
        denominator = MathUtilities.normalizeNumberToRationalOrInteger(denominator);
        if (!MathUtilities.isInteger(numerator)) {
            throw new IllegalArgumentException("Numerator not an integer!!: " + numerator);
        }
        if (!MathUtilities.isInteger(denominator)) {
            throw new IllegalArgumentException("Denominator not an integer!!: " + numerator);
        }
        int denominatorSignum = MathUtilities.signum(denominator);
        if (denominatorSignum < 0) {
            numerator = MathUtilities.negate(numerator);
        } else if (denominatorSignum == 0) {
            throw new DivisionByZeroException();
        }
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public Object getNumerator() {
        return this.numerator;
    }

    public Object getDenominator() {
        return this.denominator;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.denominator == null ? 0 : this.denominator.hashCode());
        result = 31 * result + (this.numerator == null ? 0 : this.numerator.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof ImmutableRational) {
            ImmutableRational other = (ImmutableRational)obj;
            if (this.denominator == null ? other.denominator != null : !this.denominator.equals(other.denominator)) {
                return false;
            }
            return !(this.numerator == null ? other.numerator != null : !this.numerator.equals(other.numerator));
        }
        if (obj instanceof Rational) {
            return this.equals(MathUtilities.reduce(obj));
        }
        return false;
    }

    @Override
    public byte byteValue() {
        return SmallFloatMathUtilities.safeCastSingleToS8(this.longValue());
    }

    @Override
    public short shortValue() {
        return SmallFloatMathUtilities.safeCastSingleToS16(this.longValue());
    }

    @Override
    public int intValue() {
        return SmallFloatMathUtilities.safeCastSingleToS32(this.longValue());
    }

    @Override
    public long longValue() {
        if (!MathUtilities.matheq(this.getDenominator(), 1)) {
            throw new TruncationException("Casting noninteger to integer!! \\o/");
        }
        return MathUtilities.safeCastIntegerToS64(this.getNumerator());
    }

    @Override
    public float floatValue() {
        return (float)this.doubleValue();
    }

    @Override
    public double doubleValue() {
        return ((Number)this.getNumerator()).doubleValue() / ((Number)this.getDenominator()).doubleValue();
    }

    @Override
    public double toDoubleEstimate() {
        return this.doubleValue();
    }

    @Override
    public String toFractionString() {
        return String.valueOf(this.getNumerator().toString()) + "/" + this.getDenominator().toString();
    }

    @Override
    public String toPossiblyRepeatingDecimalString() {
        GlobalCodeMetastuffContext.logBug(new NotYetImplementedException());
        return this.toFractionString();
    }

    public String toString() {
        return this.toFractionString();
    }
}

