/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.edos.sedpane;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Vector;
import rebound.jagent.ui.gui.edos.sedpane.MutableImageStorage;

public class MemoryImageStorage
implements MutableImageStorage {
    protected Vector<BufferedImage> images = new Vector();
    protected Vector<Image> thumbnails = new Vector();
    protected int thumbnailWidth = 48;
    protected int thumbnailHeight = 48;

    protected int getValidIndex(int index) {
        if (index < 0) {
            index = 0;
        } else if (index >= this.getCount()) {
            index = this.getCount() - 1;
        }
        return index;
    }

    protected int getValidInsertionIndex(int index) {
        if (index < 0) {
            index = 0;
        } else if (index > this.getCount()) {
            index = this.getCount();
        }
        return index;
    }

    @Override
    public int getCount() {
        return this.images.size();
    }

    @Override
    public BufferedImage load(int index) {
        return this.images.get(this.getValidIndex(index));
    }

    @Override
    public int getHeight(int index) {
        return this.images.get(this.getValidIndex(index)).getHeight();
    }

    @Override
    public int getWidth(int index) {
        return this.images.get(this.getValidIndex(index)).getWidth();
    }

    @Override
    public BufferedImage[] loadAll() {
        return this.images.toArray(new BufferedImage[this.images.size()]);
    }

    @Override
    public void add(BufferedImage img, int index) {
        index = this.getValidInsertionIndex(index);
        this.images.add(index, img);
        this.thumbnails.add(index, null);
    }

    @Override
    public void clear() {
        this.images.clear();
        this.thumbnails.clear();
    }

    @Override
    public void delete(int index) {
        index = this.getValidIndex(index);
        this.images.remove(index);
        this.thumbnails.remove(index);
    }

    @Override
    public void reorder(int old, int fresh) {
        old = this.getValidIndex(old);
        if ((fresh = this.getValidInsertionIndex(fresh)) != old && fresh != old + 1) {
            this.images.add(fresh < old ? fresh : fresh - 1, this.images.remove(old));
            this.thumbnails.add(fresh < old ? fresh : fresh - 1, this.thumbnails.remove(old));
        }
    }

    protected void ensureThumbnail(int index) {
        if (this.thumbnails.size() <= index) {
            this.thumbnails.setSize(index + 1);
        }
        if (this.thumbnails.get(index) == null) {
            BufferedImage source = this.load(index);
            int thumbwidth = 0;
            int thumbheight = 0;
            int width = source.getWidth();
            int height = source.getHeight();
            thumbwidth = this.getThumbnailWidth();
            thumbheight = (int)((float)thumbwidth * ((float)height / (float)width));
            if (thumbheight > this.getThumbnailHeight()) {
                thumbheight = this.getThumbnailHeight();
                thumbwidth = (int)((float)thumbheight * ((float)width / (float)height));
            }
            if (thumbwidth <= 0) {
                thumbwidth = 1;
            }
            if (thumbheight <= 0) {
                thumbheight = 1;
            }
            Image thumbnail = source.getScaledInstance(thumbwidth, thumbheight, 16);
            this.thumbnails.set(index, thumbnail);
        }
    }

    @Override
    public Image getThumbnail(int index) {
        index = this.getValidIndex(index);
        this.ensureThumbnail(index);
        return this.thumbnails.get(index);
    }

    @Override
    public int getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    @Override
    public int getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    @Override
    public void setThumbnailSizes(int width, int height) {
        if (width <= 0) {
            width = 1;
        }
        if (height <= 0) {
            height = 1;
        }
        if (this.thumbnailWidth != width || this.thumbnailHeight != height) {
            this.thumbnails.clear();
            this.thumbnailWidth = width;
            this.thumbnailHeight = height;
            int i = this.getCount() - 1;
            while (i >= 0) {
                this.ensureThumbnail(i);
                --i;
            }
        }
    }
}

