/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.edos;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JOptionPane;
import rebound.jagent.ui.gui.DropData;
import rebound.jagent.ui.gui.edos.EdosWindow;
import rebound.jagent.ui.gui.edos.sedpane.DnDiplomat;
import rebound.util.Compass;

public class EdosDiplomat
implements DnDiplomat {
    public static final DataFlavor BIMAGEFLAVOR = new DataFlavor("image/x-java-image; class=java.awt.image.BufferedImage", null);
    public static final DataFlavor[] SUPPORTED_DROPFLAVORS = new DataFlavor[]{BIMAGEFLAVOR, DataFlavor.javaFileListFlavor, DropData.URILIST_FLAVOR};
    public static final DataFlavor[] SUPPORTED_DRAGFLAVORS = new DataFlavor[]{BIMAGEFLAVOR, DataFlavor.imageFlavor, DataFlavor.javaFileListFlavor, DropData.URILIST_FLAVOR};
    protected static final String[] TEMP_DRAGIMAGE_STORAGE_PATHS = new String[]{"temp", "tmp", "/tmp", "C:\\Windows\\Temp", "."};
    protected EdosWindow edos;
    protected String dragExt = ".png";
    protected String dragMIME = "image/png";

    public EdosDiplomat(EdosWindow e) {
        this.edos = e;
    }

    @Override
    public DataFlavor[] getSupportedDropFlavors() {
        return SUPPORTED_DROPFLAVORS;
    }

    @Override
    public void drop(Object data, DataFlavor flav, int dcursor) {
        if (flav == DataFlavor.javaFileListFlavor || flav == DropData.URILIST_FLAVOR) {
            List<File> l = null;
            l = flav == DropData.URILIST_FLAVOR ? DropData.parseURIList((String)data) : (List<File>)data;
            try {
                for (File f : l) {
                    this.handleDropFile(f, dcursor);
                }
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(null, "Some images didn't get loaded, here's the first error message: " + exc.getMessage(), "Import image error", 0);
            }
        } else if (flav == BIMAGEFLAVOR) {
            this.edos.importImage((BufferedImage)data, dcursor);
        }
    }

    protected void handleDropFile(File f, int i) throws IOException {
        String lname = (f = f.getAbsoluteFile()).getName().toLowerCase();
        if (lname.endsWith(".c16") || lname.endsWith(".s16") || lname.endsWith(".blk")) {
            this.edos.open(f);
        } else {
            this.edos.importImage(f, i);
        }
    }

    @Override
    public DataFlavor[] getSupportedDragFlavors() {
        return SUPPORTED_DRAGFLAVORS;
    }

    @Override
    public boolean isDragDataCachingAllowed() {
        return true;
    }

    @Override
    public Object getDragData(DataFlavor flav, int index, BufferedImage img) throws UnsupportedFlavorException, IOException {
        if (BIMAGEFLAVOR.equals(flav)) {
            return img;
        }
        if (DataFlavor.imageFlavor.equals(flav)) {
            return img;
        }
        if (DataFlavor.javaFileListFlavor.equals(flav) || DropData.URILIST_FLAVOR.equals(flav)) {
            File created = null;
            try {
                created = this.createTempDragFile(img, index);
            }
            catch (IOException exc) {
                System.err.println("DnD Failed: Could not create temporary housing for image #" + index + ":");
                System.err.println(exc.getMessage());
                System.err.println();
                throw new IOException("Could not create temporary housing for image.");
            }
            if (created == null) {
                System.err.println("DnD Failed: Could not create temporary housing for image #" + index + ".");
                throw new IOException("Could not create temporary housing for image.");
            }
            this.setOffPendingDelete(created);
            if (DataFlavor.javaFileListFlavor.equals(flav)) {
                return Collections.singletonList(created);
            }
            return created.toURI().toString();
        }
        throw new UnsupportedFlavorException(flav);
    }

    protected File createTempDragFile(BufferedImage img, int index) throws IOException {
        File f = null;
        String name = "Frame_" + index + this.getDragExt();
        String[] stringArray = TEMP_DRAGIMAGE_STORAGE_PATHS;
        int n = TEMP_DRAGIMAGE_STORAGE_PATHS.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            f = new File(path);
            if (f.exists() && !(f = new File(path, name)).exists()) {
                try {
                    f.deleteOnExit();
                    this.writeImage(img, f);
                    return f;
                }
                catch (IOException exc) {
                    System.err.println("Tried writing temp drag file to " + f.getAbsolutePath() + " but got this: \"" + exc.getMessage() + "\", sigh, trying another.");
                }
            }
            ++n2;
        }
        File home = Compass.getLocalHabitat(this.getClass());
        String[] stringArray2 = TEMP_DRAGIMAGE_STORAGE_PATHS;
        int n3 = TEMP_DRAGIMAGE_STORAGE_PATHS.length;
        n = 0;
        while (n < n3) {
            String path = stringArray2[n];
            f = new File(home, path);
            if (f.exists() && !(f = new File(f, name)).exists()) {
                try {
                    f.deleteOnExit();
                    this.writeImage(img, f);
                    return f;
                }
                catch (IOException exc) {
                    System.err.println("Tried writing temp drag file to " + f.getAbsolutePath() + " but got this: \"" + exc.getMessage() + "\", sigh, trying another.");
                }
            }
            ++n;
        }
        home = new File(System.getProperty("user.home"));
        stringArray2 = TEMP_DRAGIMAGE_STORAGE_PATHS;
        n3 = TEMP_DRAGIMAGE_STORAGE_PATHS.length;
        n = 0;
        while (n < n3) {
            String path = stringArray2[n];
            f = new File(home, path);
            if (f.exists() && !(f = new File(f, name)).exists()) {
                try {
                    f.deleteOnExit();
                    this.writeImage(img, f);
                    return f;
                }
                catch (IOException exc) {
                    System.err.println("Tried writing temp drag file to " + f.getAbsolutePath() + " but got this: \"" + exc.getMessage() + "\", sigh, trying another.");
                }
            }
            ++n;
        }
        File sampleTemp = File.createTempFile("EdosProbe", null);
        File tempDir = sampleTemp.getParentFile();
        if (tempDir.isDirectory() && !(f = new File(tempDir, name)).exists()) {
            f.deleteOnExit();
            this.writeImage(img, f);
            return f;
        }
        File tmp = File.createTempFile("Frame_" + index + " %", this.getDragExt());
        this.writeImage(img, tmp);
        return tmp;
    }

    protected void writeImage(BufferedImage img, File dest) throws IOException {
        ImageWriter writer = null;
        Iterator<ImageWriterSpi> spis = IIORegistry.getDefaultInstance().getServiceProviders(ImageWriterSpi.class, true);
        block0: while (spis.hasNext()) {
            ImageWriterSpi spi = spis.next();
            String[] stringArray = spi.getMIMETypes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String mimeType = stringArray[n2];
                if (mimeType.startsWith(this.getDragMIME())) {
                    writer = spi.createWriterInstance();
                    break block0;
                }
                ++n2;
            }
        }
        if (writer == null) {
            throw new IOException("This system's Java ImageIO does not have any plugins which support the mime type " + this.dragMIME);
        }
        FileImageOutputStream out = new FileImageOutputStream(dest);
        writer.setOutput(out);
        writer.write(img);
        out.close();
        writer.dispose();
    }

    @Override
    public void freeDragResources() {
    }

    public void setOffPendingDelete(final File f) {
        new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                f.delete();
            }
        }.start();
    }

    public String getDragExt() {
        return this.dragExt;
    }

    public String getDragMIME() {
        return this.dragMIME;
    }

    public void setDragExt(String dragExt) {
        this.dragExt = dragExt;
    }

    public void setDragMIME(String dragMIME) {
        this.dragMIME = dragMIME;
    }
}

