/*
 * Decompiled with CFR 0.152.
 */
package rebound.hci.graphics2d;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.URL;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import rebound.bits.Endianness;
import rebound.bits.Unsigned;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.UnsupportedFormatException;
import rebound.exceptions.UnsupportedOptionException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.file.FSUtilities;
import rebound.math.SmallIntegerMathUtilities;
import rebound.text.StringUtilities;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.PolymorphicCollectionUtilities;
import rebound.util.objectutil.JavaNamespace;

public class ImageUtilities
implements JavaNamespace {
    protected static final int[] BITMASKS_565 = new int[]{63488, 2016, 31};
    protected static final int[] BITMASKS_555 = new int[]{31744, 992, 31};

    public static int getWidthImmediately(Image image) throws UnsupportedOptionException {
        int v = image.getWidth(null);
        if (v == -1) {
            throw new UnsupportedOptionException("We need the image to be able to provide its width instantly!");
        }
        if (v < 0) {
            throw new ImpossibleException("Image width illegally was: " + v);
        }
        return v;
    }

    public static int getHeightImmediately(Image image) throws UnsupportedOptionException {
        int v = image.getHeight(null);
        if (v == -1) {
            throw new UnsupportedOptionException("We need the image to be able to provide its height instantly!");
        }
        if (v < 0) {
            throw new ImpossibleException("Image height illegally was: " + v);
        }
        return v;
    }

    public static BufferedImage createCompatibleImage(BufferedImage original, int width, int height, Map<String, Object> properties) {
        Hashtable<String, Object> htproperties = null;
        htproperties = properties == null ? null : (properties instanceof Hashtable ? (Hashtable<String, Object>)properties : new Hashtable<String, Object>(properties));
        WritableRaster raster = null;
        SampleModel newmodel = original.getRaster().getSampleModel().createCompatibleSampleModel(width, height);
        DataBuffer buffer = newmodel.createDataBuffer();
        raster = Raster.createWritableRaster(newmodel, buffer, new Point(0, 0));
        return new BufferedImage(original.getColorModel(), raster, original.isAlphaPremultiplied(), htproperties);
    }

    public static BufferedImage createCompatibleImage(BufferedImage original, int width, int height) {
        return ImageUtilities.createCompatibleImage(original, width, height, ImageUtilities.getBufferedImageProperties(original));
    }

    public static BufferedImage createCompatibleImage(BufferedImage original) {
        return ImageUtilities.createCompatibleImage(original, original.getWidth(), original.getHeight());
    }

    public static Map<String, Object> getBufferedImageProperties(BufferedImage img, Map<String, Object> map) {
        if (img.getPropertyNames() != null) {
            String[] stringArray = img.getPropertyNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                map.put(name, img.getProperty(name));
                ++n2;
            }
        }
        return map;
    }

    public static Map<String, Object> getBufferedImageProperties(BufferedImage img) {
        return ImageUtilities.getBufferedImageProperties(img, new Hashtable<String, Object>());
    }

    public static BufferedImage createNewTransparentBufferedImage(int width, int height) {
        return new BufferedImage(width, height, 2);
    }

    public static BufferedImage createNewTransparentOnePixelBufferedImage() {
        return ImageUtilities.createNewTransparentBufferedImage(1, 1);
    }

    public static BufferedImage wrapRawImageData_5X5_bytes(int width, int height, byte[] data, int offset, int length, boolean is565, Endianness endianness) {
        short[] shortedData = endianness == Endianness.Big ? ArrayUtilities.mergeElements8to16BE(data, offset, length) : ArrayUtilities.mergeElements8to16LE(data, offset, length);
        return ImageUtilities.wrapRawImageData_5X5_shorts(width, height, shortedData, length / 2, is565);
    }

    public static BufferedImage wrapRawImageData_5X5_shorts(int width, int height, short[] data, int length, boolean is565) {
        int[] bitmasks = is565 ? BITMASKS_565 : BITMASKS_555;
        int bits = is565 ? 16 : 15;
        DirectColorModel cm = new DirectColorModel(bits, bitmasks[0], bitmasks[1], bitmasks[2]);
        SinglePixelPackedSampleModel sm = new SinglePixelPackedSampleModel(1, width, height, bitmasks);
        DataBufferUShort db = new DataBufferUShort(data, length);
        WritableRaster raster = Raster.createWritableRaster(sm, db, null);
        BufferedImage img = new BufferedImage(cm, raster, false, null);
        return img;
    }

    public static byte[] extractRawImageData_5X5_bytes(BufferedImage img, boolean is565, Endianness endianness) {
        short[] shorts = ImageUtilities.extractRawImageData_5X5_shorts(img, is565);
        byte[] bytes = endianness == Endianness.Big ? ArrayUtilities.splitElements16to8BE(shorts, 0, shorts.length) : ArrayUtilities.splitElements16to8LE(shorts, 0, shorts.length);
        return bytes;
    }

    public static short[] extractRawImageData_5X5_shorts(BufferedImage img, boolean is565) {
        BufferedImage rgb = null;
        if (img.getColorModel().getColorSpace().getType() != 5) {
            ColorConvertOp converter = new ColorConvertOp(ColorSpace.getInstance(1000), null);
            BufferedImage dest = null;
            BufferedImage src = img;
            dest = new BufferedImage(src.getWidth(), src.getHeight(), is565 ? 8 : 9);
            converter.filter(src, dest);
            rgb = dest;
        } else {
            rgb = img;
        }
        WritableRaster raster = rgb.getRaster();
        SampleModel sm = raster.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        if (sm instanceof SinglePixelPackedSampleModel && (sm.getDataType() == 1 || sm.getDataType() == 2) && db.getNumBanks() == 1) {
            short[] data = null;
            int offset = 0;
            if (db instanceof DataBufferUShort) {
                DataBufferUShort dbus = (DataBufferUShort)db;
                data = dbus.getData();
                offset = dbus.getOffset();
            } else if (db instanceof DataBufferShort) {
                DataBufferShort dbss = (DataBufferShort)db;
                data = dbss.getData();
                dbss.getOffset();
            }
            if (data != null) {
                if (offset == 0) {
                    return data;
                }
                short[] translated = new short[db.getSize()];
                System.arraycopy(data, offset, translated, 0, translated.length);
                return translated;
            }
        }
        int[] expandedSamples = raster.getPixels(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight(), (int[])null);
        int len = expandedSamples.length;
        short[] data = new short[len];
        if (is565) {
            int i = 0;
            while (i < len) {
                int expanded = expandedSamples[i];
                data[i] = (short)((expanded & 0x1F0000) >>> 5 | (expanded & 0x3F00) >>> 3 | expanded & 0x1F);
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                int expanded = expandedSamples[i];
                data[i] = (short)((expanded & 0x1F0000) >>> 6 | (expanded & 0x1F00) >>> 3 | expanded & 0x1F);
                ++i;
            }
        }
        return data;
    }

    public static byte[] extractRawImageData_ARGB32_bytes(BufferedImage img, Endianness endianness) {
        int[] shorts = ImageUtilities.extractRawImageData_ARGB32_ints(img);
        byte[] bytes = endianness == Endianness.Big ? ArrayUtilities.splitElements32to8BE(shorts, 0, shorts.length) : ArrayUtilities.splitElements32to8LE(shorts, 0, shorts.length);
        return bytes;
    }

    public static int[] extractRawImageData_ARGB32_ints(BufferedImage img) {
        BufferedImage rgb = null;
        if (img.getColorModel().getColorSpace().getType() != 5) {
            ColorConvertOp converter = new ColorConvertOp(ColorSpace.getInstance(1000), null);
            BufferedImage dest = null;
            BufferedImage src = img;
            dest = new BufferedImage(src.getWidth(), src.getHeight(), 2);
            converter.filter(src, dest);
            rgb = dest;
        } else {
            rgb = img;
        }
        WritableRaster raster = rgb.getRaster();
        SampleModel sm = raster.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        if (sm instanceof SinglePixelPackedSampleModel && sm.getDataType() == 3 && db.getNumBanks() == 1) {
            int[] data = null;
            int offset = 0;
            if (db instanceof DataBufferInt) {
                DataBufferInt dbus = (DataBufferInt)db;
                data = dbus.getData();
                offset = dbus.getOffset();
            }
            if (data != null) {
                if (offset == 0) {
                    return data;
                }
                int[] translated = new int[db.getSize()];
                System.arraycopy(data, offset, translated, 0, translated.length);
                return translated;
            }
        }
        throw new NotYetImplementedException();
    }

    public static byte[] getAlpha(BufferedImage image) {
        if (!image.getColorModel().hasAlpha()) {
            return null;
        }
        int width = image.getWidth();
        int height = image.getHeight();
        WritableRaster raster = image.getRaster();
        ColorModel cm = image.getColorModel();
        SampleModel sm = raster.getSampleModel();
        DataBuffer db = raster.getDataBuffer();
        byte[] alphaMap = new byte[width * height];
        WritableRaster alphaRaster = image.getAlphaRaster();
        if (alphaRaster != null) {
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    alphaMap[y * width + x] = (byte)raster.getSample(x, y, 3);
                    ++x;
                }
                ++y;
            }
        } else {
            Object sampleArray = Array.newInstance(ImageUtilities.getComponentTypeForDataBufferType(raster.getSampleModel().getTransferType()), raster.getSampleModel().getNumDataElements());
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    sm.getDataElements(x, y, sampleArray, db);
                    alphaMap[y * width + x] = (byte)cm.getAlpha(sampleArray);
                    ++x;
                }
                ++y;
            }
        }
        return alphaMap;
    }

    public static BufferedImage colorToAlpha(BufferedImage image, int color) {
        color &= 0xFFFFFF;
        BufferedImage dest = null;
        if (image.getAlphaRaster() != null) {
            dest = image;
        } else {
            dest = new BufferedImage(image.getWidth(), image.getHeight(), 2);
            Graphics2D g = dest.createGraphics();
            g.drawImage((Image)image, 0, 0, null);
            g.dispose();
        }
        int w = image.getWidth();
        int h = image.getHeight();
        int y = 0;
        while (y < h) {
            int x = 0;
            while (x < w) {
                int v = image.getRGB(x, y);
                if ((v & 0xFFFFFF) == color) {
                    dest.setRGB(x, y, v & 0xFFFFFF);
                }
                ++x;
            }
            ++y;
        }
        return dest;
    }

    public static Class getComponentTypeForDataBufferType(int dataType) {
        switch (dataType) {
            case 0: {
                return Byte.TYPE;
            }
            case 1: {
                return Short.TYPE;
            }
            case 2: {
                return Short.TYPE;
            }
            case 3: {
                return Integer.TYPE;
            }
            case 4: {
                return Float.TYPE;
            }
            case 5: {
                return Double.TYPE;
            }
        }
        throw new IllegalArgumentException("Invalid DataBuffer.TYPE_xxx value: " + dataType);
    }

    public static void setAllPixels(int[] imageBuffer, int value) {
        int len = imageBuffer.length;
        int i = 0;
        while (i < len) {
            imageBuffer[i] = value;
            ++i;
        }
    }

    public static int setAlpha(int originalColor, double alpha) {
        return ImageUtilities.setAlpha(originalColor, (int)(alpha * 255.0));
    }

    public static int setAlpha(int originalColor, int alpha) {
        if (alpha < 0) {
            alpha = 0;
        } else if (alpha > 255) {
            alpha = 255;
        }
        return originalColor & 0xFFFFFF | alpha << 24;
    }

    public static long isAllSameAlphaColor_INTARGB(int[] image, int width) {
        if (image.length % width != 0) {
            throw new IllegalArgumentException("Image buffer size not multiple of width.");
        }
        if (image.length == 0) {
            return -2L;
        }
        int firstColor = image[0];
        int i = 1;
        while (i < image.length) {
            if (image[i] != firstColor) {
                return -1L;
            }
            ++i;
        }
        return Unsigned.upcast(firstColor);
    }

    public static long isAllSameNonalphaColor_INTARGB(int[] image, int width) {
        if (image.length % width != 0) {
            throw new IllegalArgumentException("Image buffer size not multiple of width.");
        }
        if (image.length == 0) {
            return -2L;
        }
        int firstColor = image[0] & 0xFFFFFF;
        int i = 1;
        while (i < image.length) {
            if ((image[i] & 0xFFFFFF) != firstColor) {
                return -1L;
            }
            ++i;
        }
        return Unsigned.upcast(firstColor);
    }

    public static BufferedImage combineImages(BufferedImage dest, int destX, int destY, int stride, BufferedImage ... images) {
        int y;
        int x;
        int firstDim;
        if (stride < 1) {
            throw new IllegalArgumentException("Invalid stride (width in tiles): " + stride);
        }
        if (images == null) {
            throw new NullPointerException();
        }
        if (images.length % stride != 0) {
            throw new IllegalArgumentException("Invalid number of tiles, " + images.length + " is not a multiple of stride (" + stride + ")");
        }
        int y2 = 0;
        while (y2 < images.length / stride) {
            firstDim = -1;
            x = 0;
            while (x < stride) {
                if (images[y2 * stride + x] != null) {
                    if (firstDim == -1) {
                        firstDim = images[y2 * stride + x].getHeight();
                        if (firstDim < 0) {
                            throw new ImpossibleException("Buffered image height < 0: " + firstDim);
                        }
                    } else if (images[y2 * stride + x].getHeight() != firstDim) {
                        throw new IllegalArgumentException("Not all image tiles in row y=" + y2 + " are the same height.");
                    }
                }
                ++x;
            }
            ++y2;
        }
        int x2 = 0;
        while (x2 < stride) {
            firstDim = -1;
            y = 0;
            while (y < images.length / stride) {
                if (images[y * stride + x2] != null) {
                    if (firstDim == -1) {
                        firstDim = images[y * stride + x2].getWidth();
                        if (firstDim < 0) {
                            throw new ImpossibleException("Buffered image width < 0: " + firstDim);
                        }
                    } else if (images[y * stride + x2].getWidth() != firstDim) {
                        throw new IllegalArgumentException("Not all image tiles in column x=" + x2 + " are the same width.");
                    }
                }
                ++y;
            }
            ++x2;
        }
        int width = 0;
        int height = 0;
        y = 0;
        while (y < images.length / stride) {
            int x3 = 0;
            while (x3 < stride) {
                if (images[y * stride + x3] != null) {
                    height += images[y * stride + x3].getHeight();
                    break;
                }
                ++x3;
            }
            ++y;
        }
        x = 0;
        while (x < stride) {
            int y3 = 0;
            while (y3 < images.length / stride) {
                if (images[y3 * stride + x] != null) {
                    width += images[y3 * stride + x].getWidth();
                    break;
                }
                ++y3;
            }
            ++x;
        }
        if (dest == null) {
            boolean hasAlpha = false;
            int i = 0;
            while (i < images.length) {
                if (images[i].getColorModel().hasAlpha()) {
                    hasAlpha = true;
                    break;
                }
                ++i;
            }
            dest = new BufferedImage(width + destX, height + destY, hasAlpha ? 2 : 1);
        } else if (dest.getWidth() < width + destX || dest.getHeight() < height + destY) {
            throw new IllegalArgumentException("Dest image is too small for tiling size + offset");
        }
        Graphics2D g = dest.createGraphics();
        int x4 = 0;
        y = 0;
        int tileY = 0;
        while (tileY < images.length / stride) {
            int tileX = 0;
            while (tileX < stride) {
                int columnWidth = 0;
                if (images[tileY * stride + tileX] != null) {
                    columnWidth = images[tileY * stride + tileX].getWidth();
                } else {
                    int tileY2 = 0;
                    while (tileY2 < images.length / stride) {
                        if (images[tileY2 * stride + tileX] != null) {
                            columnWidth = images[tileY2 * stride + tileX].getWidth();
                            break;
                        }
                        ++tileY2;
                    }
                }
                if (images[tileY * stride + tileX] != null) {
                    g.drawImage((Image)images[tileY * stride + tileX], x4, y, null);
                }
                x4 += columnWidth;
                ++tileX;
            }
            int rowHeight = 0;
            int tileX2 = 0;
            while (tileX2 < stride) {
                if (images[tileY * stride + tileX2] != null) {
                    rowHeight = images[tileY * stride + tileX2].getHeight();
                    break;
                }
                ++tileX2;
            }
            x4 = 0;
            y += rowHeight;
            ++tileY;
        }
        g.dispose();
        return dest;
    }

    public static BufferedImage combineImages(int stride, BufferedImage ... images) {
        return ImageUtilities.combineImages(null, 0, 0, stride, images);
    }

    public static BufferedImage rotateRightAngles(BufferedImage source, int quadrantRotations) {
        if ((quadrantRotations = SmallIntegerMathUtilities.progmod(quadrantRotations, 4)) == 0) {
            return source;
        }
        AffineTransform xform = new AffineTransform();
        if (quadrantRotations == 1) {
            xform.translate(source.getHeight(), 0.0);
        } else if (quadrantRotations == 2) {
            xform.translate(source.getWidth(), source.getHeight());
        } else if (quadrantRotations == 3) {
            xform.translate(0.0, source.getWidth());
        }
        xform.quadrantRotate(SmallIntegerMathUtilities.progmod(quadrantRotations, 4));
        return new AffineTransformOp(xform, 1).filter(source, null);
    }

    public static BufferedImage flipHorizontal(BufferedImage source) {
        AffineTransform xform = new AffineTransform();
        xform.translate(source.getWidth(), 0.0);
        xform.scale(-1.0, 1.0);
        try {
            xform.invert();
        }
        catch (NoninvertibleTransformException exc) {
            throw new ImpossibleException();
        }
        return new AffineTransformOp(xform, 1).filter(source, null);
    }

    public static BufferedImage flipVertical(BufferedImage source) {
        AffineTransform xform = new AffineTransform();
        xform.translate(0.0, source.getHeight());
        xform.scale(1.0, -1.0);
        try {
            xform.invert();
        }
        catch (NoninvertibleTransformException exc) {
            throw new ImpossibleException();
        }
        return new AffineTransformOp(xform, 1).filter(source, null);
    }

    public static void debugDumpImageToFile(BufferedImage image, File file) {
        try {
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    @Nonnull
    public static BufferedImage read(@Nonnull File file, @Nonnull ImageReader reader) throws FileNotFoundException, IOException {
        Objects.requireNonNull(file);
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream in = new FileInputStream(file);){
            return ImageUtilities.read(in, reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nonnull
    public static BufferedImage read(@Nonnull URL url, @Nonnull ImageReader reader) throws IOException {
        Objects.requireNonNull(url);
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = url.openStream();){
            return ImageUtilities.read(in, reader);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nonnull
    public static BufferedImage read(@Nonnull byte[] data, @Nonnull ImageReader reader) throws IOException {
        Objects.requireNonNull(data);
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        return ImageUtilities.read(in, reader);
    }

    @Nonnull
    public static BufferedImage read(@Nonnull InputStream in, @Nonnull ImageReader reader) throws IOException {
        Objects.requireNonNull(in);
        Objects.requireNonNull(reader);
        ImageInputStream iout = ImageIO.createImageInputStream(in);
        reader.setInput(iout, true);
        BufferedImage image = reader.read(0);
        Objects.requireNonNull(image);
        return image;
    }

    public static void write(@Nonnull BufferedImage image, @Nonnull OutputStream out, @Nonnull ImageWriter writer) throws IOException {
        Objects.requireNonNull(image);
        Objects.requireNonNull(out);
        Objects.requireNonNull(writer);
        ImageOutputStream iout = ImageIO.createImageOutputStream(out);
        writer.setOutput(iout);
        writer.write(image);
        iout.flush();
    }

    public static void write(@Nonnull BufferedImage image, @Nonnull File file, @Nonnull ImageWriter writer) throws FileNotFoundException, IOException {
        Objects.requireNonNull(file);
        Throwable throwable = null;
        Object var4_5 = null;
        try (FileOutputStream out = new FileOutputStream(file);){
            ImageUtilities.write(image, out, writer);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Nonnull
    public static byte[] write(@Nonnull BufferedImage image, @Nonnull ImageWriter writer) throws IOException {
        ByteArrayOutputStream buff = new ByteArrayOutputStream();
        ImageUtilities.write(image, buff, writer);
        byte[] a = buff.toByteArray();
        Objects.requireNonNull(a);
        return a;
    }

    public static ImageReadingAndFormatDetectionResults readImageDetectingFormat(File file, boolean requireCorrespondingWriter) throws FileNotFoundException, IOException {
        BufferedImage image;
        String ext = FSUtilities.getFilenameExtension(file);
        if (ext == null) {
            throw new UnsupportedFormatException("File has no extension to tell the image format from!! X'DD   " + StringUtilities.repr(file));
        }
        Iterator<ImageReader> readersI = ImageIO.getImageReadersBySuffix(ext);
        Collection readers = PolymorphicCollectionUtilities.anyToCollection(readersI);
        if (readers.isEmpty()) {
            throw new UnsupportedFormatException(String.valueOf(ImageIO.class.getName()) + " gives no ImageReaders for the extension " + StringUtilities.repr(ext) + " so we cans not decode the image file..sorry!");
        }
        ImageReader reader = (ImageReader)CollectionUtilities.getArbitraryElementThrowing(readers);
        if (reader == null) {
            throw new ImpossibleException();
        }
        ImageWriter writer = ImageIO.getImageWriter(reader);
        if (writer == null) {
            Iterator<ImageWriter> writersI = ImageIO.getImageWritersBySuffix(ext);
            Collection writers = PolymorphicCollectionUtilities.anyToCollection(writersI);
            if (writers.isEmpty()) {
                if (requireCorrespondingWriter) {
                    throw new UnsupportedFormatException(String.valueOf(ImageIO.class.getName()) + " gives no ImageWriters for the extension " + StringUtilities.repr(ext) + "  (and the reader it gave has no corresponding writer!! \\o/)");
                }
                writer = null;
            } else {
                writer = (ImageWriter)CollectionUtilities.getArbitraryElementThrowing(writers);
                if (writer == null) {
                    throw new ImpossibleException();
                }
            }
        }
        if ((image = ImageUtilities.read(file, reader)) == null) {
            throw new ImpossibleException();
        }
        return new ImageReadingAndFormatDetectionResults(image, reader, writer);
    }

    public static ImageReadingAndFormatDetectionResults readImageDetectingFormat(File file) throws FileNotFoundException, IOException {
        return ImageUtilities.readImageDetectingFormat(file, false);
    }

    public static class ImageReadingAndFormatDetectionResults {
        public BufferedImage image;
        public ImageReader formatReader;
        public ImageWriter formatWriter;

        public ImageReadingAndFormatDetectionResults(BufferedImage image, ImageReader formatReader, ImageWriter formatWriter) {
            this.image = image;
            this.formatReader = formatReader;
            this.formatWriter = formatWriter;
        }
    }
}

