/*
 * Decompiled with CFR 0.152.
 */
package rebound.exceptions;

import rebound.exceptions.SyntaxCheckedException;
import rebound.exceptions.TextSyntaxException;
import rebound.text.parsing.apis.tokenstream.SimpleTokenWithLineAndColumnNumbers;
import rebound.text.parsing.apis.tokenstream.WherefulToken;

public class TextSyntaxCheckedException
extends SyntaxCheckedException {
    private static final long serialVersionUID = 1L;

    protected TextSyntaxCheckedException(String message, Throwable cause) {
        super(message, cause);
    }

    public static TextSyntaxCheckedException inst() {
        return new TextSyntaxCheckedException(null, null);
    }

    public static TextSyntaxCheckedException inst(String message) {
        return new TextSyntaxCheckedException(message, null);
    }

    public static TextSyntaxCheckedException inst(Throwable cause) {
        return new TextSyntaxCheckedException(null, cause);
    }

    public static TextSyntaxCheckedException inst(String message, Throwable cause) {
        return new TextSyntaxCheckedException(message, cause);
    }

    public static TextSyntaxCheckedException instCharPos(String message, int characterIndex, Throwable cause) {
        if (characterIndex == -1) {
            return TextSyntaxCheckedException.inst(message);
        }
        return new TextSyntaxCheckedException(String.valueOf(message) + "    At character: [" + characterIndex + "]", cause);
    }

    public static TextSyntaxCheckedException instLineNumber(String message, int lineNumber, Throwable cause) {
        if (lineNumber == -1) {
            return TextSyntaxCheckedException.inst(message);
        }
        return new TextSyntaxCheckedException(String.valueOf(message) + "    At line: " + lineNumber, cause);
    }

    public static TextSyntaxCheckedException instLineAndColumnNumber(String message, int lineNumber, int columnNumber, Throwable cause) {
        if (columnNumber == -1) {
            return TextSyntaxCheckedException.instLineNumber(message, lineNumber, cause);
        }
        return new TextSyntaxCheckedException(String.valueOf(message) + "    At line " + lineNumber + ", column " + columnNumber, cause);
    }

    public static TextSyntaxCheckedException instCharPosAndLineAndColumnNumber(String message, int characterIndex, int lineNumber, int columnNumber, Throwable cause) {
        if (message == null) {
            message = "Syntax Error!";
        }
        if (characterIndex == -1) {
            return TextSyntaxCheckedException.instLineAndColumnNumber(message, lineNumber, columnNumber, cause);
        }
        if (lineNumber == -1) {
            return TextSyntaxCheckedException.instCharPos(message, characterIndex, cause);
        }
        if (columnNumber == -1) {
            return new TextSyntaxCheckedException(String.valueOf(message) + "    At character [" + characterIndex + "], (line " + lineNumber + ")", cause);
        }
        return new TextSyntaxCheckedException(String.valueOf(message) + "    At character [" + characterIndex + "], (line " + lineNumber + ", column " + columnNumber + ")", cause);
    }

    public static TextSyntaxCheckedException instCharPos(String message, int characterIndex) {
        return TextSyntaxCheckedException.instCharPos(message, characterIndex, null);
    }

    public static TextSyntaxCheckedException instLineNumber(String message, int lineNumber) {
        return TextSyntaxCheckedException.instLineNumber(message, lineNumber, null);
    }

    public static TextSyntaxCheckedException instLineAndColumnNumber(String message, int lineNumber, int columnNumber) {
        return TextSyntaxCheckedException.instLineAndColumnNumber(message, lineNumber, columnNumber, null);
    }

    public static TextSyntaxCheckedException instCharPosAndLineAndColumnNumber(String message, int characterIndex, int lineNumber, int columnNumber) {
        return TextSyntaxCheckedException.instCharPosAndLineAndColumnNumber(message, characterIndex, lineNumber, columnNumber, null);
    }

    public static TextSyntaxCheckedException instPos(String message, WherefulToken token, Throwable cause) {
        return TextSyntaxCheckedException.instCharPosAndLineAndColumnNumber(message, token.getStartingCharacterIndexInSource(), SimpleTokenWithLineAndColumnNumbers.getStartingLineNumberInSource1Based(token), SimpleTokenWithLineAndColumnNumbers.getStartingColumnNumberInSource1Based(token), cause);
    }

    public static TextSyntaxCheckedException instPos(String message, WherefulToken token) {
        return TextSyntaxCheckedException.instPos(message, token, null);
    }

    public static TextSyntaxCheckedException instPos(WherefulToken token) {
        return TextSyntaxCheckedException.instPos(null, token, null);
    }

    @Override
    public TextSyntaxException toSyntaxRuntimeException() {
        return TextSyntaxException.inst(this.getMessage(), this);
    }
}

