/*
 * Decompiled with CFR 0.152.
 */
package rebound;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.GlobalCodeMetastuffContextImpl;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.exceptions.NotYetImplementedException;
import rebound.text.StringUtilities;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.objectutil.ObjectUtilities;

public class GlobalCodeMetastuffContext
implements JavaNamespace {
    public static final String ImplClassnameSystemProperty = "rebound.GlobalCodeMetastuffContextImpl";
    protected static volatile GlobalCodeMetastuffContextImpl Impl = null;

    @ImplementationTransparency
    @Nonnull
    public static void setImpl(GlobalCodeMetastuffContextImpl impl) {
        Impl = impl;
    }

    @ImplementationTransparency
    @Nonnull
    public static GlobalCodeMetastuffContextImpl getImpl() {
        GlobalCodeMetastuffContextImpl i = Impl;
        if (i != null) {
            return i;
        }
        i = GlobalCodeMetastuffContext.makeImpl();
        if (i != null) {
            Impl = i;
            return i;
        }
        return GlobalCodeMetastuffContextImpl.NoopingGlobalCodeMetastuffContextImpl.I;
    }

    @Nullable
    protected static GlobalCodeMetastuffContextImpl makeImpl() {
        Object i;
        Class<?> c;
        String p = System.getProperty(ImplClassnameSystemProperty);
        if (p != null) {
            p = p.trim();
        }
        if (p == null || p.isEmpty()) {
            return GlobalCodeMetastuffContext.makeDefaultImpl();
        }
        try {
            c = Class.forName(p);
        }
        catch (ClassNotFoundException exc) {
            System.err.println("Error loading implementation of " + GlobalCodeMetastuffContextImpl.class.getName() + ": " + p);
            exc.printStackTrace();
            return null;
        }
        if (!GlobalCodeMetastuffContextImpl.class.isAssignableFrom(c)) {
            System.err.println("Error loading implementation of " + GlobalCodeMetastuffContextImpl.class.getName() + ": " + c.getName());
            System.err.println(c + " class does not implement " + GlobalCodeMetastuffContextImpl.class.getName());
            return null;
        }
        try {
            i = c.newInstance();
        }
        catch (InstantiationException exc) {
            System.err.println("Error loading implementation of " + GlobalCodeMetastuffContextImpl.class.getName() + ": " + c.getName());
            exc.printStackTrace();
            return null;
        }
        catch (IllegalAccessException exc) {
            System.err.println("Error loading implementation of " + GlobalCodeMetastuffContextImpl.class.getName() + ": " + c.getName());
            exc.printStackTrace();
            return null;
        }
        catch (SecurityException exc) {
            System.err.println("Error loading implementation of " + GlobalCodeMetastuffContextImpl.class.getName() + ": " + c.getName());
            exc.printStackTrace();
            return null;
        }
        if (!(i instanceof GlobalCodeMetastuffContextImpl)) {
            System.err.println("Error loading implementation of " + GlobalCodeMetastuffContextImpl.class.getName() + ": " + c.getName());
            System.err.println(c + " instance does not implement " + GlobalCodeMetastuffContextImpl.class.getName() + "  (but we checked this against the Class object earlier using reflection!! o,O)");
            return null;
        }
        return (GlobalCodeMetastuffContextImpl)i;
    }

    @Nullable
    protected static GlobalCodeMetastuffContextImpl makeDefaultImpl() {
        return new GlobalCodeMetastuffContextImpl(){

            @Override
            public void logStaticResourceAccessIntegrityFailure(File resourceFile, Exception exc) {
                this.logBug("logStaticResourceAccessIntegrityFailure(" + StringUtilities.repr(resourceFile.getAbsolutePath()) + ", (Exception...)) called!!", exc);
            }

            @Override
            public void logStaticResourceAccessIOFailure(File resourceFile, IOException exc) {
                this.logBug("logStaticResourceAccessIOFailure(" + StringUtilities.repr(resourceFile.getAbsolutePath()) + ", (IOException...)) called!!", exc);
            }

            @Override
            public void logBug() {
                System.err.println("BUG!!");
                new Throwable("dummy throwable for formatting :P").printStackTrace();
                System.err.println("\n\n\n");
            }

            @Override
            public void logBug(String message) {
                System.err.println("BUG!!:\n" + message);
                new Throwable("dummy throwable for formatting :P").printStackTrace();
                System.err.println("\n\n\n");
            }

            @Override
            public void logBug(Throwable exc) {
                System.err.println("BUG!!");
                System.err.println("== Actual given throwable! ==");
                exc.printStackTrace();
                System.err.println("== Logging stacktrace ^^ ==");
                new Throwable("dummy throwable for formatting :P").printStackTrace();
                System.err.println("\n\n\n");
            }

            @Override
            public void logBug(String message, Throwable exc) {
                System.err.println("BUG!!:\n" + message);
                System.err.println("== Actual given throwable! ==");
                exc.printStackTrace();
                System.err.println("== Logging stacktrace ^^ ==");
                new Throwable("dummy throwable for formatting :P").printStackTrace();
                System.err.println("\n\n\n");
            }
        };
    }

    public static void logBug() {
        GlobalCodeMetastuffContext.getImpl().logBug();
    }

    public static void logBugMsg(@Nullable Object message) {
        GlobalCodeMetastuffContext.logBug(ObjectUtilities.toStringNT(message));
    }

    public static void logBug(@Nullable String message) {
        GlobalCodeMetastuffContext.getImpl().logBug(ObjectUtilities.toStringNT(message));
    }

    public static <T extends Throwable> T logBug(T exc) {
        GlobalCodeMetastuffContext.getImpl().logBug(exc);
        return exc;
    }

    public static <T extends Throwable> T logBug(String message, T exc) {
        GlobalCodeMetastuffContext.getImpl().logBug(message, exc);
        return exc;
    }

    public static <T extends IOException> T logStaticResourceAccessIOFailure(@Nullable File resourceFile, @Nullable T exc) {
        GlobalCodeMetastuffContext.getImpl().logStaticResourceAccessIOFailure(resourceFile, exc);
        return exc;
    }

    public static <T extends Exception> T logStaticResourceAccessIntegrityFailure(@Nullable File resourceFile, @Nullable T exc) {
        GlobalCodeMetastuffContext.getImpl().logStaticResourceAccessIntegrityFailure(resourceFile, exc);
        return exc;
    }

    public static NotYetImplementedException logNYI() {
        NotYetImplementedException e = new NotYetImplementedException();
        GlobalCodeMetastuffContext.logBug(e);
        return e;
    }

    public static NotYetImplementedException logNYI(String message) {
        NotYetImplementedException e = new NotYetImplementedException(message);
        GlobalCodeMetastuffContext.logBug(e);
        return e;
    }

    public static void expectNonnull(Object x) {
        if (x == null) {
            GlobalCodeMetastuffContext.logBug();
        }
    }

    public static <E> E expectNonnull(E x, E dummyValue) {
        if (x == null) {
            GlobalCodeMetastuffContext.logBug();
            return dummyValue;
        }
        return x;
    }

    private GlobalCodeMetastuffContext() {
    }
}

