/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.growth;

import javax.annotation.Nonnegative;
import rebound.annotations.hints.IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.annotations.semantic.SignalType;
import rebound.annotations.semantic.temporal.monotonicity.MonotonicValueIntegerSequence;

public interface Grower {
    @Nonnegative
    @MonotonicValueIntegerSequence
    public int getNewSize(@Nonnegative int var1, @Nonnegative int var2);

    public static int defaultGetMonotonicNewSizeHeuristicallyClampingOverflow(@Nonnegative int oldsize, int newsize) {
        if (oldsize < 0) {
            throw new IllegalArgumentException();
        }
        if (newsize < oldsize) {
            if (oldsize < 0xCCCCCCC) {
                throw new IllegalArgumentException("Refusing to grow the size by a huge jump from (" + oldsize + " to " + Integer.MAX_VALUE + ")!!  It's more likely that the grower is simply not monotonic and shrunk than that it overflowed!");
            }
            return Integer.MAX_VALUE;
        }
        return newsize;
    }

    @SignalType
    public static interface GrowerComputationallyReduced
    extends Grower {
        public int getNewSizeReduced(@Nonnegative int var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int getNewSize(int iteration, int oldsize) {
            return this.getNewSizeReduced(iteration);
        }
    }

    @SignalType
    public static interface GrowerComputationallyUnreducedPurelyRecursive
    extends Grower {
        public int getNewSizeRecursive(@Nonnegative int var1);

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int getNewSize(int iteration, int oldsize) {
            return this.getNewSizeRecursive(oldsize);
        }
    }
}

