/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.PossiblySnapshotPossiblyLiveValue;
import rebound.annotations.semantic.reachability.SnapshotValue;
import rebound.exceptions.NonrectangularException;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.SimpleTable;
import rebound.util.objectutil.PubliclyCloneable;

public class NestedListsSimpleTable<E>
implements SimpleTable<E>,
PubliclyCloneable<NestedListsSimpleTable<E>> {
    protected List<List<E>> rows;

    public NestedListsSimpleTable(int numberOfInitialColumns, int numberOfInitialRows) {
        this.clearAndRedim(numberOfInitialColumns, numberOfInitialRows);
    }

    public NestedListsSimpleTable() {
        this(0, 0);
    }

    public NestedListsSimpleTable(@SnapshotValue @ReadonlyValue SimpleTable<E> otherTable) {
        this();
        this.setFrom(otherTable);
    }

    public NestedListsSimpleTable(@WritableValue @LiveValue List<List<E>> rows) throws NonrectangularException {
        if (rows.size() > 1) {
            int w0 = rows.get(0).size();
            Iterator<List<List<E>>> i = rows.iterator();
            i.next();
            while (i.hasNext()) {
                List<List<E>> row = i.next();
                if (row.size() == w0) continue;
                throw new NonrectangularException();
            }
        }
        this.rows = rows;
    }

    @Override
    public boolean isReadableTable() {
        return true;
    }

    @Override
    public boolean isWritableTable() {
        return true;
    }

    public void appendRowLIVE(List<E> row) {
        if (!this.isEmpty() && row.size() != this.getNumberOfColumns()) {
            throw new NonrectangularException();
        }
        this.rows.add(row);
    }

    @Override
    public void redimToZeroByZeroErasingAllContents() {
        this.rows.clear();
    }

    @Override
    public void redimPossiblyWithoutClearing(int numberOfColumns, int numberOfRows) {
        this.rows = NestedListsSimpleTable.newFilledWithNulls(numberOfRows);
        int r = 0;
        while (r < numberOfRows) {
            this.rows.set(r, NestedListsSimpleTable.newFilledWithNulls(numberOfColumns));
            ++r;
        }
    }

    @Override
    public void clearAndRedim(int numberOfColumns, int numberOfRows) {
        this.rows = NestedListsSimpleTable.newFilledWithNulls(numberOfRows);
        int r = 0;
        while (r < numberOfRows) {
            this.rows.set(r, NestedListsSimpleTable.newFilledWithNulls(numberOfColumns));
            ++r;
        }
    }

    @Override
    public NestedListsSimpleTable<E> clone() {
        return new NestedListsSimpleTable<E>(this);
    }

    @Override
    public int getNumberOfColumns() {
        return this.rows.isEmpty() ? 0 : this.rows.get(0).size();
    }

    @Override
    public int getNumberOfRows() {
        return this.rows.size();
    }

    @Override
    public E getCellContents(int columnIndex, int rowIndex) {
        return this.rows.get(rowIndex).get(columnIndex);
    }

    @Override
    public void setCellContents(int columnIndex, int rowIndex, E newValue) {
        this.rows.get(rowIndex).set(columnIndex, newValue);
    }

    @Override
    public void deleteRow(int rowIndex) {
        this.rows.remove(rowIndex);
    }

    @Override
    public void insertEmptyRow(int insertionRowIndex) {
        if (this.isEmpty()) {
            throw new IllegalStateException("You have to redim a table fully when it's empty, because 0xH or Wx0 are degenerate invalid dimensions--they're different from 0x0 but still have 0 cells!! \\o/");
        }
        this.rows.add(insertionRowIndex, NestedListsSimpleTable.newFilledWithNulls(this.getNumberOfColumns()));
    }

    @Override
    public void deleteColumn(int columnIndex) {
        int r = 0;
        while (r < this.getNumberOfRows()) {
            this.rows.get(r).remove(columnIndex);
            ++r;
        }
    }

    @Override
    public void insertEmptyColumn(int insertionColumnIndex) {
        if (this.isEmpty()) {
            throw new IllegalStateException("You have to redim a table fully when it's empty, because 0xH or Wx0 are degenerate invalid dimensions--they're different from 0x0 but still have 0 cells!! \\o/");
        }
        int r = 0;
        while (r < this.getNumberOfRows()) {
            this.rows.get(r).add(insertionColumnIndex, null);
            ++r;
        }
    }

    @Override
    @PossiblySnapshotPossiblyLiveValue
    public List<List<E>> toListOfRowsPossiblyLive() {
        return this.rows;
    }

    @Override
    @PossiblySnapshotPossiblyLiveValue
    public List<E> rowToListPossiblyLive(int index) {
        return this.rows.get(index);
    }

    public boolean equals(Object obj) {
        return obj instanceof SimpleTable && CollectionUtilities.eqv(this, (SimpleTable)obj);
    }

    public int hashCode() {
        return SimpleTable.defaultHashcodeOfContents(this);
    }

    protected static <D> List<D> newFilledWithNulls(int size) {
        ArrayList<Object> list = new ArrayList<Object>(size);
        int i = 0;
        while (i < size) {
            list.add(null);
            ++i;
        }
        return list;
    }
}

