/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Properties;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Signed;
import rebound.GlobalCodeMetastuffContext;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.operationspecification.CollectionValue;
import rebound.annotations.semantic.operationspecification.HashableValue;
import rebound.annotations.semantic.reachability.LiveValue;
import rebound.annotations.semantic.reachability.PossiblySnapshotPossiblyLiveValue;
import rebound.annotations.semantic.reachability.SnapshotValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.annotations.semantic.simpledata.Nonempty;
import rebound.annotations.semantic.simpledata.NonnullElements;
import rebound.annotations.semantic.simpledata.NonnullKeys;
import rebound.annotations.semantic.simpledata.NonnullValues;
import rebound.annotations.semantic.simpledata.NullableElements;
import rebound.exceptions.AlreadyExistsException;
import rebound.exceptions.DuplicatesException;
import rebound.exceptions.EmptyInputReturnPath;
import rebound.exceptions.GenericDataStructuresFormatException;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.NoSuchElementReturnPath;
import rebound.exceptions.NoSuchMappingReturnPath;
import rebound.exceptions.NonForwardInjectiveMapException;
import rebound.exceptions.NonReverseInjectiveMapException;
import rebound.exceptions.NonSurjectiveMapException;
import rebound.exceptions.NotFoundException;
import rebound.exceptions.NotSingletonException;
import rebound.exceptions.NotSupportedReturnPath;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.OverflowException;
import rebound.exceptions.ReadonlyUnsupportedOperationException;
import rebound.exceptions.StopIterationReturnPath;
import rebound.exceptions.StructuredClassCastException;
import rebound.math.Direction1D;
import rebound.math.MathUtilities;
import rebound.math.SmallIntegerMathUtilities;
import rebound.testing.WidespreadTestingUtilities;
import rebound.text.StringUtilities;
import rebound.util.BasicExceptionUtilities;
import rebound.util.CodeHinting;
import rebound.util.IdentityCardinality;
import rebound.util.Maybe;
import rebound.util.Primitives;
import rebound.util.classhacking.jre.BetterJREGlassbox;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.AssertedSet;
import rebound.util.collections.BasicCollectionUtilities;
import rebound.util.collections.Bracelet;
import rebound.util.collections.CollectionWithBoundEqualityComparator;
import rebound.util.collections.CollectionWithCopyIntoArray;
import rebound.util.collections.CollectionWithDefaultElement;
import rebound.util.collections.CollectionWithGetArbitraryElement;
import rebound.util.collections.CollectionWithGetExtantInstanceNatural;
import rebound.util.collections.CollectionWithGetExtantInstanceSpecified;
import rebound.util.collections.CollectionWithInvocationProvideableEqualityComparators;
import rebound.util.collections.CollectionWithPopArbitraryElement;
import rebound.util.collections.ConcatenatingIterable;
import rebound.util.collections.ConcatenatingIterator;
import rebound.util.collections.EmptyBracelet;
import rebound.util.collections.EmptyNecklace;
import rebound.util.collections.FastRandomAccess;
import rebound.util.collections.FilterAwayReturnPath;
import rebound.util.collections.IndexAndElementProvidingRemove;
import rebound.util.collections.Interval;
import rebound.util.collections.ListBackedSet;
import rebound.util.collections.ListSet;
import rebound.util.collections.ListWithFill;
import rebound.util.collections.ListWithRemoveRange;
import rebound.util.collections.ListWithReorder;
import rebound.util.collections.ListWithSetAll;
import rebound.util.collections.ListWithSetSize;
import rebound.util.collections.ListWithSwapCapability;
import rebound.util.collections.MapEntryPredicate;
import rebound.util.collections.MapWithGetRP;
import rebound.util.collections.Mapper;
import rebound.util.collections.Necklace;
import rebound.util.collections.NestedListsSimpleTable;
import rebound.util.collections.PairCommutative;
import rebound.util.collections.PairOrdered;
import rebound.util.collections.PolymorphicCollectionUtilities;
import rebound.util.collections.PrecanonicalizedBracelet;
import rebound.util.collections.PrecanonicalizedNecklace;
import rebound.util.collections.RuntimeReadabilityMap;
import rebound.util.collections.RuntimeWriteabilityMap;
import rebound.util.collections.ShiftableList;
import rebound.util.collections.SimpleIterator;
import rebound.util.collections.SimpleTable;
import rebound.util.collections.SingletonBracelet;
import rebound.util.collections.SingletonNecklace;
import rebound.util.collections.SmallFinite;
import rebound.util.collections.StandardEnumSetConvertibleToIntFlags;
import rebound.util.collections.Sublist;
import rebound.util.collections.TripleOrdered;
import rebound.util.collections.WeakCollection;
import rebound.util.collections.maps.EquivalenceMap;
import rebound.util.collections.maps.IdentityMap;
import rebound.util.collections.maps.MapWithBoundKeyEqualityComparator;
import rebound.util.collections.maps.MapWithBoundValueEqualityComparator;
import rebound.util.collections.maps.WeakKeyedMap;
import rebound.util.collections.maps.WeakValuedMap;
import rebound.util.collections.prim.PrimitiveCollection;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.container.SimpleContainers;
import rebound.util.functional.CollectionFunctionalIterable;
import rebound.util.functional.ContinueSignal;
import rebound.util.functional.EqualityComparator;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.functional.MapFunctionalIterable;
import rebound.util.functional.SuccessfulIterationStopType;
import rebound.util.functional.functions.DefaultEqualityComparator;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.Equivalenceable;
import rebound.util.objectutil.ObjectUtilities;
import rebound.util.objectutil.PubliclyCloneable;

public class CollectionUtilities {
    protected static final String Converters_ClassCastException_Message_Prefix = "Only arrays, " + Collection.class.getName() + "'s, " + Iterable.class.getName() + "'s, " + SimpleIterator.SimpleIterable.class.getName() + "'s, " + Iterator.class.getName() + "'s, " + Enumeration.class.getName() + "'s, " + SimpleIterator.class.getName() + "'s, and " + Map.class.getName() + "'s(values) are supported,  not ";
    protected static final Iterator Empty_Iterator = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }
    };
    protected static final Iterable Empty_Iterable = () -> Empty_Iterator;
    public static final Comparator<Map.Entry<?, ?>> EntryComparator = (a, b) -> BasicObjectUtilities.cmp2chainable(BasicObjectUtilities.cmp2(a.getKey(), b.getKey()), a.getValue(), b.getValue());
    protected static final ListSet emptyListSet = new ListBackedSet(Collections.emptyList());

    public static <E> void validateRowsAllSameSize(List<List<E>> rows) throws IllegalArgumentException {
        if (!CollectionUtilities.areRowsAllTheSameSize(rows)) {
            throw new IllegalArgumentException("Rows are not all the same number of cells/columns!! \\o/");
        }
    }

    public static <E> boolean areRowsAllTheSameSize(List<List<E>> rows) {
        boolean has = false;
        int size = 0;
        for (List<E> row : rows) {
            if (!has) {
                size = row.size();
                has = true;
                continue;
            }
            if (row.size() == size) continue;
            return false;
        }
        return true;
    }

    public static <K, V> V getrp(Map<K, V> map, K key) throws NoSuchMappingReturnPath {
        if (map instanceof MapWithGetRP) {
            return ((MapWithGetRP)((Object)map)).getrp(key);
        }
        V v = map.get(key);
        if (v != null) {
            return v;
        }
        if (map.containsKey(key)) {
            return null;
        }
        throw NoSuchMappingReturnPath.I;
    }

    public static <K, V> PairOrdered<V, Boolean> getp(Map<K, V> map, K key) {
        try {
            return BasicCollectionUtilities.pair(CollectionUtilities.getrp(map, key), true);
        }
        catch (NoSuchMappingReturnPath exc) {
            return BasicCollectionUtilities.pair(null, false);
        }
    }

    public static <K, V> V getMandatory(Map<K, V> map, K key) throws NoSuchMappingReturnPath.NoSuchMappingException {
        try {
            return CollectionUtilities.getrp(map, key);
        }
        catch (NoSuchMappingReturnPath exc) {
            throw new NoSuchMappingReturnPath.NoSuchMappingException("Element " + StringUtilities.repr(key) + " not found in " + StringUtilities.repr(map));
        }
    }

    public static <K, V> V removerp(Map<K, V> map, K key) throws NoSuchMappingReturnPath {
        if (map.containsKey(key)) {
            return map.remove(key);
        }
        throw NoSuchMappingReturnPath.I;
    }

    public static <K, V> V removeMandatory(Map<K, V> map, K key) throws NoSuchMappingReturnPath.NoSuchMappingException {
        try {
            return CollectionUtilities.removerp(map, key);
        }
        catch (NoSuchMappingReturnPath exc) {
            throw new NoSuchMappingReturnPath.NoSuchMappingException("Element " + StringUtilities.repr(key) + " not found in " + StringUtilities.repr(map));
        }
    }

    public static <K, V> void removeExactMandatory(Map<K, V> map, K key, V value) throws NoSuchMappingReturnPath.NoSuchMappingException {
        V v;
        try {
            v = CollectionUtilities.getrp(map, key);
        }
        catch (NoSuchMappingReturnPath exc) {
            throw new NoSuchMappingReturnPath.NoSuchMappingException("Element " + StringUtilities.repr(key) + " not found in " + StringUtilities.repr(map));
        }
        if (!BasicObjectUtilities.eq(v, value)) {
            throw new NoSuchMappingReturnPath.NoSuchMappingException("Element " + StringUtilities.repr(key) + " was not mapped to " + StringUtilities.repr(value) + " in " + StringUtilities.repr(map));
        }
        try {
            CollectionUtilities.removerp(map, key);
        }
        catch (NoSuchMappingReturnPath exc) {
            throw new ImpossibleException("We already checked it was present in the map with getrp()!");
        }
    }

    public static <E> void addNewMandatory(Collection<E> collection, E element) throws AlreadyExistsException {
        if (!collection.add(element)) {
            throw new AlreadyExistsException("Duplicate element attempted to be added: " + StringUtilities.repr(element));
        }
    }

    public static <E> void addAllNewMandatory(Collection<E> dest, Iterable<E> source) throws AlreadyExistsException {
        for (E e : source) {
            CollectionUtilities.addNewMandatory(dest, e);
        }
    }

    public static <K, V> void putNewMandatory(Map<K, V> map, K key, V value) throws AlreadyExistsException {
        if (map.containsKey(key)) {
            throw new AlreadyExistsException("Conflict between keys: " + StringUtilities.repr(key) + "   The current value is: " + StringUtilities.repr(map.get(key)) + " and the new conflicting value is: " + StringUtilities.repr(value));
        }
        map.put(key, value);
    }

    public static <K, V> void putAllNewMandatory(Map<K, V> dest, Map<K, V> source) throws AlreadyExistsException {
        for (Map.Entry<K, V> e : source.entrySet()) {
            CollectionUtilities.putNewMandatory(dest, e.getKey(), e.getValue());
        }
    }

    public static <K, V> void putNewUniqueMandatory(Map<K, V> map, K key, V newValue) throws AlreadyExistsException {
        V currentValue = map.get(key);
        if ((currentValue != null || map.containsKey(key)) && !BasicObjectUtilities.eq(currentValue, newValue)) {
            throw new AlreadyExistsException("Conflict between keys: " + StringUtilities.repr(key) + "   The current value is: " + StringUtilities.repr(currentValue) + " and the new conflicting value is: " + StringUtilities.repr(newValue));
        }
        map.put(key, newValue);
    }

    public static <K, V> void putAllNewUniqueMandatory(Map<K, V> dest, Map<K, V> source) throws AlreadyExistsException {
        for (Map.Entry<K, V> e : source.entrySet()) {
            CollectionUtilities.putNewUniqueMandatory(dest, e.getKey(), e.getValue());
        }
    }

    public static void nullify(Map map) {
        for (Object key : map.keySet()) {
            map.put(key, null);
        }
    }

    public static Boolean isIdentityMap(Map map) {
        if (map instanceof IdentityMap) {
            return true;
        }
        if (map instanceof IdentityHashMap) {
            return true;
        }
        if (map instanceof EnumMap) {
            return true;
        }
        return null;
    }

    public static boolean isIdentityMapConventionalDefault(Map map) {
        return Primitives.unboxNT(CollectionUtilities.isIdentityMap(map), false);
    }

    public static Boolean isEquivalenceMap(Map map) {
        if (map instanceof EquivalenceMap) {
            return false;
        }
        if (map instanceof IdentityHashMap) {
            return false;
        }
        if (map instanceof EnumMap) {
            return true;
        }
        return null;
    }

    public static boolean isEquivalenceMapConventionalDefault(Map map) {
        return Primitives.unboxNT(CollectionUtilities.isEquivalenceMap(map), true);
    }

    @Nullable
    public static <V> V getTypeCheckingNullable(Map map, Object key, Class<V> type) throws NotFoundException, StructuredClassCastException {
        Object v;
        if (type.isPrimitive()) {
            type = Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(type);
        }
        if ((v = map.get(key)) == null) {
            if (map.containsKey(key)) {
                return null;
            }
            throw new NotFoundException(String.valueOf(StringUtilities.repr(key)) + " was not found in " + StringUtilities.repr(map));
        }
        if (type.isInstance(v)) {
            return v;
        }
        throw new StructuredClassCastException(String.valueOf(v.getClass().getName()) + " encountered, not " + type.getClass().getName(), v.getClass(), type);
    }

    @Nonnull
    public static <V> V getTypeCheckingNonnull(Map map, Object key, Class<V> type) throws NotFoundException, StructuredClassCastException, NullPointerException {
        Object v;
        if (type.isPrimitive()) {
            type = Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(type);
        }
        if ((v = map.get(key)) == null) {
            if (map.containsKey(key)) {
                throw new NullPointerException();
            }
            throw new NotFoundException(String.valueOf(StringUtilities.repr(key)) + " was not found in " + StringUtilities.repr(map));
        }
        if (type.isInstance(v)) {
            return v;
        }
        throw new StructuredClassCastException(String.valueOf(v.getClass().getName()) + " encountered, not " + type.getClass().getName(), v.getClass(), type);
    }

    @Nullable
    public static <V> V getTypeCheckingNullableDefaulting(Map map, Object key, Class<V> type, V defaultValue) throws NotFoundException, StructuredClassCastException, NullPointerException {
        Object v;
        if (type.isPrimitive()) {
            type = Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(type);
        }
        if ((v = map.get(key)) == null) {
            if (map.containsKey(key)) {
                return null;
            }
            return defaultValue;
        }
        if (type.isInstance(v)) {
            return v;
        }
        throw new StructuredClassCastException(String.valueOf(v.getClass().getName()) + " encountered, not " + type.getClass().getName(), v.getClass(), type);
    }

    @Nonnull
    public static <V> V getTypeCheckingNonnullDefaulting(Map map, Object key, Class<V> type, V defaultValue) throws NotFoundException, StructuredClassCastException, NullPointerException {
        if (type.isPrimitive()) {
            type = Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(type);
        }
        Objects.requireNonNull(defaultValue);
        Object v = map.get(key);
        if (v == null) {
            if (map.containsKey(key)) {
                throw new NullPointerException();
            }
            return defaultValue;
        }
        if (type.isInstance(v)) {
            return v;
        }
        throw new StructuredClassCastException(String.valueOf(v.getClass().getName()) + " encountered, not " + type.getName(), v.getClass(), type);
    }

    @Nullable
    public static <V> V getTypeCheckingNullOnlyOnAbsent(Map map, Object key, Class<V> type) throws NotFoundException, StructuredClassCastException, NullPointerException {
        Object v;
        if (type.isPrimitive()) {
            type = Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(type);
        }
        if ((v = map.get(key)) == null) {
            if (map.containsKey(key)) {
                throw new NullPointerException();
            }
            return null;
        }
        if (type.isInstance(v)) {
            return v;
        }
        throw new StructuredClassCastException(String.valueOf(v.getClass().getName()) + " encountered, not " + type.getClass().getName(), v.getClass(), type);
    }

    public static <K, V> EqualityComparator<K> getBoundKeyEqualityComparator(Map<K, V> map) {
        if (map instanceof MapWithBoundKeyEqualityComparator) {
            return ((MapWithBoundKeyEqualityComparator)((Object)map)).getKeyEqualityComparator();
        }
        return BasicObjectUtilities.getNaturalEqualityComparator();
    }

    public static <K, V> EqualityComparator<V> getBoundValueEqualityComparator(Map<K, V> map) {
        if (map instanceof MapWithBoundValueEqualityComparator) {
            return ((MapWithBoundValueEqualityComparator)((Object)map)).getValueEqualityComparator();
        }
        return BasicObjectUtilities.getNaturalEqualityComparator();
    }

    @LiveValue
    public static Map unmodifiableMap(Map map) {
        if (Primitives.isFalseAndNotNull(CollectionUtilities.isMapWritable(map))) {
            return map;
        }
        return Collections.unmodifiableMap(map);
    }

    @Nullable
    public static Boolean isMapReadable(@Nonnull Map map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (map instanceof RuntimeReadabilityMap) {
            return ((RuntimeReadabilityMap)((Object)map)).isReadableMap();
        }
        if (map.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableMap) {
            return true;
        }
        if (map.getClass() == HashMap.class) {
            return true;
        }
        if (map.getClass() == TreeMap.class) {
            return true;
        }
        if (map.getClass() == IdentityHashMap.class) {
            return true;
        }
        if (map.getClass() == WeakHashMap.class) {
            return true;
        }
        if (map.getClass() == EnumMap.class) {
            return true;
        }
        if (Primitives.isTrueAndNotNull(PolymorphicCollectionUtilities.isReadableCollection(map.entrySet()))) {
            return true;
        }
        if (Primitives.isTrueAndNotNull(PolymorphicCollectionUtilities.isReadableCollection(map.keySet()))) {
            return true;
        }
        if (Primitives.isTrueAndNotNull(PolymorphicCollectionUtilities.isReadableCollection(map.values()))) {
            return true;
        }
        return null;
    }

    @Nullable
    public static Boolean isMapWritable(@Nonnull Map map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (map instanceof RuntimeWriteabilityMap) {
            return ((RuntimeWriteabilityMap)((Object)map)).isWritableMap();
        }
        if (map.getClass() == BetterJREGlassbox.Type_Collections_unmodifiableMap) {
            return true;
        }
        if (map.getClass() == HashMap.class) {
            return true;
        }
        if (map.getClass() == TreeMap.class) {
            return true;
        }
        if (map.getClass() == IdentityHashMap.class) {
            return true;
        }
        if (map.getClass() == WeakHashMap.class) {
            return true;
        }
        if (map.getClass() == EnumMap.class) {
            return true;
        }
        if (Primitives.isTrueAndNotNull(PolymorphicCollectionUtilities.isReadableCollection(map.entrySet()))) {
            return true;
        }
        if (Primitives.isTrueAndNotNull(PolymorphicCollectionUtilities.isReadableCollection(map.keySet()))) {
            return true;
        }
        if (Primitives.isTrueAndNotNull(PolymorphicCollectionUtilities.isReadableCollection(map.values()))) {
            return true;
        }
        return null;
    }

    public static <M extends Map<?, ?>> M keysnotnull(M map) throws NullPointerException {
        CollectionUtilities.allnotnull(map.keySet());
        return map;
    }

    public static <M extends Map<?, ?>> M valuesnotnull(M map) throws NullPointerException {
        CollectionUtilities.allnotnull(map.values());
        return map;
    }

    public static <M extends Map<?, ?>> M entriesnotnull(M map) throws NullPointerException {
        CollectionUtilities.allnotnull(map.entrySet());
        return map;
    }

    public static <M extends Map<?, ?>> M allnotnull(M map) throws NullPointerException {
        CollectionUtilities.keysnotnull(map);
        CollectionUtilities.valuesnotnull(map);
        return map;
    }

    @Nonnull
    public static <E> List<E> emptyListIfNull(@Nullable List<E> o) {
        return o == null ? Collections.emptyList() : o;
    }

    @Nonnull
    public static <E> Set<E> emptySetIfNull(@Nullable Set<E> o) {
        return o == null ? Collections.emptySet() : o;
    }

    @Nonnull
    public static <E> Collection<E> emptyCollectionIfNull(@Nullable Collection<E> o) {
        return o == null ? CollectionUtilities.emptyCollection() : o;
    }

    @Nonnull
    public static <E> Iterable<E> emptyIterableIfNull(@Nullable Iterable<E> o) {
        return o == null ? CollectionUtilities.emptyIterable() : o;
    }

    @Nonnull
    public static <K, V> Map<K, V> emptyMapIfNull(@Nullable Map<K, V> o) {
        return o == null ? Collections.emptyMap() : o;
    }

    public static <E> Collection<E> emptyCollection() {
        return Collections.emptySet();
    }

    public static <E> Set<E> singletonSet(E e) {
        return Collections.singleton(e);
    }

    public static <K, V> void defaultPutAll(Map<K, V> self, Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            self.put(e.getKey(), e.getValue());
        }
    }

    public static <K, V> void defaultReplaceAll(Map<K, V> self, BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        for (Map.Entry<K, V> entry : self.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
            v = function.apply(k, v);
            try {
                entry.setValue(v);
            }
            catch (IllegalStateException ise) {
                throw new ConcurrentModificationException(ise);
            }
        }
    }

    public static <E> void defaultReplaceAll(List<E> self, UnaryOperator<E> operator) {
        Objects.requireNonNull(operator);
        ListIterator li = self.listIterator();
        while (li.hasNext()) {
            li.set(operator.apply(li.next()));
        }
    }

    public static <K, V> int defaultClear(Map<K, V> self) {
        Set<Map.Entry<K, V>> s = self.entrySet();
        int sizeBeforeClearing = s.size();
        for (Map.Entry<K, V> e : s) {
            self.remove(e.getKey());
        }
        return sizeBeforeClearing;
    }

    public static <K, V> void removeAllEntriesForValue(Map<K, V> map, Predicate<V> valueTest) {
        Object[] objectArray = map.entrySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            Map.Entry entry = (Map.Entry)e;
            if (valueTest.test(entry.getValue())) {
                map.remove(entry.getKey());
            }
            ++n2;
        }
    }

    public static <E> Predicate<E> createContainsTestWrapper(E[] array) {
        return o -> {
            if (o == null) {
                Object[] objectArray2 = array;
                int n = array.length;
                int n2 = 0;
                while (n2 < n) {
                    Object e = objectArray2[n2];
                    if (e == null) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
            Object[] objectArray3 = array;
            int n = array.length;
            int n3 = 0;
            while (n3 < n) {
                Object e = objectArray3[n3];
                if (o.equals(e)) {
                    return true;
                }
                ++n3;
            }
            return false;
        };
    }

    public static <E> Predicate<E> createContainsTestWrapper(Collection<E> set) {
        return o -> set.contains(o);
    }

    @ThrowAwayValue
    public static <E> List<E> concatenateListsOP(@ReadonlyValue Iterable<E> a, @ReadonlyValue Iterable<E> b) {
        List rv;
        if ((a instanceof PrimitiveCollection || b instanceof PrimitiveCollection) && (rv = PrimitiveCollections.concatenateManyPrimitiveListsOP(CollectionUtilities.listof(a, b))) != null) {
            return rv;
        }
        ArrayList l = a instanceof Collection && b instanceof Collection ? new ArrayList(((Collection)a).size() + ((Collection)a).size()) : new ArrayList();
        CollectionUtilities.addAll(l, a);
        CollectionUtilities.addAll(l, b);
        return l;
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static <E> List<E> concatenateListsOPC(@ReadonlyValue Iterable<E> a, @ReadonlyValue Iterable<E> b) {
        if (a instanceof List && b instanceof Collection && ((Collection)b).isEmpty()) {
            return (List)a;
        }
        if (b instanceof List && a instanceof Collection && ((Collection)a).isEmpty()) {
            return (List)b;
        }
        return CollectionUtilities.concatenateListsOP(a, b);
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static <E> List<E> concatenateManyListsOPC_V(Iterable<E> ... lists) {
        return CollectionUtilities.concatenateManyListsOPC(CollectionUtilities.asList(lists));
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static <E> List<E> concatenateManyListsOPC(@ReadonlyValue Collection<? extends Iterable<E>> lists) {
        List rv;
        int n = lists.size();
        if (n == 0) {
            return Collections.emptyList();
        }
        if (n == 1) {
            return CollectionUtilities.toList(BasicCollectionUtilities.getSingleElement(lists));
        }
        if (n == 2) {
            Iterator<Iterable<E>> i = lists.iterator();
            if (!i.hasNext()) {
                throw new ImpossibleException("Collection iterator mismatched with collection size!");
            }
            Iterable<E> a = i.next();
            if (!i.hasNext()) {
                throw new ImpossibleException("Collection iterator mismatched with collection size!");
            }
            Iterable<E> b = i.next();
            if (i.hasNext()) {
                throw new ImpossibleException("Collection iterator mismatched with collection size!");
            }
            return CollectionUtilities.concatenateListsOPC(a, b);
        }
        if (CollectionUtilities.forAny(l -> l instanceof PrimitiveCollection, lists) && (rv = PrimitiveCollections.concatenateManyPrimitiveListsOP(lists)) != null) {
            return rv;
        }
        boolean hasInfo = true;
        int totalSize = 0;
        boolean hasMultipleNonEmpties = false;
        Iterable<E> nonEmpty = null;
        for (Iterable<E> input : lists) {
            if (input instanceof Collection) {
                Collection in = (Collection)input;
                int size = in.size();
                if (size == 0) continue;
                totalSize += size;
                if (nonEmpty == null) {
                    nonEmpty = input;
                    continue;
                }
                if (hasMultipleNonEmpties) continue;
                hasMultipleNonEmpties = true;
                continue;
            }
            hasInfo = false;
            break;
        }
        if (hasInfo) {
            if (nonEmpty == null) {
                if (totalSize != 0) {
                    throw new AssertionError();
                }
                return Collections.emptyList();
            }
            if (!hasMultipleNonEmpties) {
                return CollectionUtilities.toList(nonEmpty);
            }
        }
        ArrayList l2 = hasInfo ? new ArrayList(totalSize) : new ArrayList();
        for (Iterable<E> in : lists) {
            CollectionUtilities.addAll(l2, in);
        }
        return l2;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> toList(Iterable<E> i) {
        if (i instanceof List) {
            return (List)i;
        }
        return CollectionUtilities.toNewList(i);
    }

    @SnapshotValue
    public static <E> List<E> toNewList(Iterable<E> i) {
        if (i instanceof Collection) {
            return new ArrayList((Collection)i);
        }
        ArrayList<E> l = new ArrayList<E>();
        for (E e : i) {
            l.add(e);
        }
        return l;
    }

    public static <E> Iterable<E> concatenateIterablesOP(Iterable<E> ... iterables) {
        return new ConcatenatingIterable<E>(CollectionUtilities.asList(iterables));
    }

    public static <E> Iterator<E> concatenateIteratorsOP(Iterator<E> ... iterators) {
        return new ConcatenatingIterator<E>(CollectionUtilities.asList(iterators).iterator());
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> Iterable<E> concatenateIterablesOPC(Iterable<E> ... iterables) {
        if (iterables.length == 0) {
            return CollectionUtilities.emptyIterable();
        }
        if (iterables.length == 1) {
            return iterables[0];
        }
        return new ConcatenatingIterable<E>(CollectionUtilities.asList(iterables));
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> Iterator<E> concatenateIteratorsOPC(Iterator<E> ... iterators) {
        if (iterators.length == 0) {
            return CollectionUtilities.emptyIterator();
        }
        if (iterators.length == 1) {
            return iterators[0];
        }
        return new ConcatenatingIterator<E>(CollectionUtilities.asList(iterators).iterator());
    }

    public static <E> E getArbitraryElementThrowing(Iterable<E> c) throws NoSuchElementException {
        try {
            return CollectionUtilities.getArbitraryElementRP(c);
        }
        catch (NoSuchElementReturnPath exc) {
            throw exc.toException();
        }
    }

    public static <E> E getArbitraryElementDefaulting(Collection<E> c) {
        try {
            return CollectionUtilities.getArbitraryElementRP(c);
        }
        catch (NoSuchElementReturnPath exc) {
            return null;
        }
    }

    public static <E> E getArbitraryElementRP(Iterable<E> c) throws NoSuchElementReturnPath {
        if (c instanceof List) {
            List l = (List)c;
            if (l.isEmpty()) {
                throw NoSuchElementReturnPath.I;
            }
            return l.get(0);
        }
        if (c instanceof CollectionWithGetArbitraryElement) {
            return ((CollectionWithGetArbitraryElement)((Object)c)).getArbitraryElement();
        }
        if (c instanceof Collection && ((Collection)c).isEmpty()) {
            throw NoSuchElementReturnPath.I;
        }
        Iterator<E> iterator = c.iterator();
        if (iterator.hasNext()) {
            E e = iterator.next();
            return e;
        }
        throw NoSuchElementReturnPath.I;
    }

    public static <E> E popArbitraryElementThrowing(Iterable<E> c) throws NoSuchElementException {
        try {
            return CollectionUtilities.popArbitraryElementRP(c);
        }
        catch (NoSuchElementReturnPath exc) {
            throw exc.toException();
        }
    }

    public static <E> E popArbitraryElementDefaulting(Collection<E> c) {
        try {
            return CollectionUtilities.popArbitraryElementRP(c);
        }
        catch (NoSuchElementReturnPath exc) {
            return null;
        }
    }

    public static <E> E popArbitraryElementRP(Iterable<E> c) throws NoSuchElementReturnPath {
        if (c instanceof CollectionWithPopArbitraryElement) {
            return ((CollectionWithPopArbitraryElement)((Object)c)).popArbitraryElement();
        }
        if (c instanceof List) {
            return ((List)c).remove(0);
        }
        Iterator<E> i = c.iterator();
        if (i.hasNext()) {
            E e = i.next();
            i.remove();
            return e;
        }
        return null;
    }

    public static <E> E getArbitraryMatchingElement(Predicate<? super E> predicate, Collection<E> c) {
        if (c == null) {
            return null;
        }
        for (E e : c) {
            if (!predicate.test(e)) continue;
            return e;
        }
        return null;
    }

    public static <E> E popArbitraryMatchingElement(Predicate<? super E> predicate, Collection<E> c) {
        if (c == null) {
            return null;
        }
        Iterator<E> i = c.iterator();
        while (i.hasNext()) {
            E e = i.next();
            if (!predicate.test(e)) continue;
            i.remove();
            return e;
        }
        return null;
    }

    public static <E> E getAndRemoveIfPresentOrReturnDefaultValue(Iterable<E> thingWithIteratorsSupportingRemoving, Predicate<E> predicate, @Nullable E defaultValue) {
        Iterator<E> i = thingWithIteratorsSupportingRemoving.iterator();
        while (i.hasNext()) {
            E e = i.next();
            if (!predicate.test(e)) continue;
            i.remove();
            return e;
        }
        return defaultValue;
    }

    public static <E> E getIfPresentOrReturnDefaultValue(Iterable<E> thingWithIterators, Predicate<E> predicate, @Nullable E defaultValue) {
        for (E e : thingWithIterators) {
            if (!predicate.test(e)) continue;
            return e;
        }
        return defaultValue;
    }

    public static <E> void swapElements(List<E> list, int indexA, int indexB) {
        if (indexA == indexB) {
            return;
        }
        if (list instanceof ListWithSwapCapability) {
            ((ListWithSwapCapability)((Object)list)).swap(indexA, indexB);
        } else {
            E tmp = list.get(indexA);
            list.set(indexA, list.get(indexB));
            list.set(indexB, tmp);
        }
    }

    public static <E> int reorderRelative(List<E> list, int source, int amountToMove) {
        int n = list.size();
        if (source < 0 || source >= n) {
            throw new IndexOutOfBoundsException();
        }
        int dest = SmallIntegerMathUtilities.progmod(source + amountToMove, n);
        if (dest == source) {
            return source;
        }
        E e = list.remove(source);
        list.add(dest, e);
        return dest;
    }

    public static <E> void reorderAbsolute(List<E> list, int source, int destInPreRemoveCoordinates) throws IndexOutOfBoundsException {
        if (source == destInPreRemoveCoordinates) {
            return;
        }
        if (list instanceof ListWithReorder) {
            ((ListWithReorder)((Object)list)).reorder(source, destInPreRemoveCoordinates);
        } else {
            int oldSize = list.size();
            if (source < 0 || source >= oldSize) {
                throw new IndexOutOfBoundsException();
            }
            int destInPostRemoveCoordinates = source < destInPreRemoveCoordinates ? destInPreRemoveCoordinates - 1 : destInPreRemoveCoordinates;
            int newSize = oldSize - 1;
            if (destInPostRemoveCoordinates < 0 || destInPostRemoveCoordinates > newSize) {
                throw new IndexOutOfBoundsException();
            }
            E e = list.remove(source);
            list.add(destInPostRemoveCoordinates, e);
        }
    }

    public static int copyIntoArray(Collection source, Object[] dest, int destOffset) {
        if (source instanceof CollectionWithCopyIntoArray) {
            return ((CollectionWithCopyIntoArray)((Object)source)).copyIntoArray(dest, destOffset);
        }
        if (source.size() < 128) {
            Object[] c = source.toArray();
            System.arraycopy(c, 0, dest, destOffset, c.length);
            return c.length;
        }
        int i = destOffset;
        for (Object e : source) {
            dest[i] = e;
            ++i;
        }
        return i;
    }

    public static <E> void setListSize(List<E> list, int newSize) {
        CollectionUtilities.setListSize(list, newSize, CollectionWithDefaultElement.getDefaultElement(list));
    }

    public static <E> void setListSize(List<E> list, int newSize, E elementToAddIfGrowing) {
        if (list instanceof ListWithSetSize) {
            ((ListWithSetSize)list).setSize(newSize, elementToAddIfGrowing);
        } else if (list instanceof Vector && elementToAddIfGrowing == null) {
            ((Vector)list).setSize(newSize);
        } else {
            CollectionUtilities.defaultSetListSize(list, newSize, elementToAddIfGrowing);
        }
    }

    public static <E> void defaultSetListSize(List<E> list, int newSize, E elementToAddIfGrowing) {
        block3: {
            int oldSize;
            block2: {
                oldSize = list.size();
                if (newSize <= oldSize) break block2;
                int amountToAdd = newSize - oldSize;
                int i = 0;
                while (i < amountToAdd) {
                    list.add(elementToAddIfGrowing);
                    ++i;
                }
                break block3;
            }
            if (newSize >= oldSize) break block3;
            int i = oldSize - 1;
            while (i >= newSize) {
                list.remove(i);
                --i;
            }
        }
    }

    public static <E> void setListSizeShrinking(List<E> list, int newSize) throws IllegalArgumentException {
        if (newSize > list.size()) {
            throw new IllegalArgumentException();
        }
        CollectionUtilities.setListSize(list, newSize, CollectionWithDefaultElement.getDefaultElement(list));
    }

    public static <E> void setListSizeGrowing(List<E> list, int newSize, E elementToAddIfGrowing) throws IllegalArgumentException {
        if (newSize < list.size()) {
            throw new IllegalArgumentException();
        }
        CollectionUtilities.setListSize(list, newSize, elementToAddIfGrowing);
    }

    public static void removeRange(List list, int start, int pastEnd) {
        CollectionUtilities.rangeCheckFor_removeRange(list, start, pastEnd);
        if (list instanceof ListWithRemoveRange) {
            ((ListWithRemoveRange)((Object)list)).removeRange(start, pastEnd);
        } else {
            CollectionUtilities.defaultRemoveRange(list, start, pastEnd);
        }
    }

    public static void removeRangeByLength(List list, int start, int length) {
        CollectionUtilities.removeRange(list, start, start + length);
    }

    public static void defaultRemoveRange(List list, int start, int pastEnd) {
        CollectionUtilities.shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(list, pastEnd, -(pastEnd - start));
    }

    public static <E> int indexOf(Predicate<E> predicate, @CollectionValue E[] list) {
        int length = list.length;
        int i = 0;
        while (i < length) {
            if (predicate.test(list[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E> int indexOf(Predicate<E> predicate, @CollectionValue List<E> list) {
        if (CollectionUtilities.isRandomAccessFast(list)) {
            int length = list.size();
            int i = 0;
            while (i < length) {
                if (predicate.test(list.get(i))) {
                    return i;
                }
                ++i;
            }
            return -1;
        }
        int i = 0;
        for (E element : list) {
            if (predicate.test(element)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E> int indexOfSingle(Predicate<E> predicate, @CollectionValue List<E> list) throws NotSingletonException {
        if (CollectionUtilities.isRandomAccessFast(list)) {
            int rv = -1;
            int length = list.size();
            int i = 0;
            while (i < length) {
                if (predicate.test(list.get(i))) {
                    if (rv == -1) {
                        rv = i;
                    } else {
                        throw new NotSingletonException();
                    }
                }
                ++i;
            }
            return rv;
        }
        int rv = -1;
        int i = 0;
        for (E element : list) {
            if (predicate.test(element)) {
                if (rv == -1) {
                    rv = i;
                } else {
                    throw new NotSingletonException();
                }
            }
            ++i;
        }
        return -1;
    }

    public static <E> boolean contains(Predicate<E> predicate, @CollectionValue E[] list) {
        return CollectionUtilities.indexOf(predicate, list) != -1;
    }

    public static <E> boolean contains(Predicate<E> predicate, @CollectionValue List<E> list) {
        return CollectionUtilities.indexOf(predicate, list) != -1;
    }

    public static <E> boolean contains(Predicate<E> predicate, @CollectionValue Iterable<E> collection) {
        for (E e : collection) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> E findFirstRP(Predicate<E> predicate, @CollectionValue E[] list) throws NoSuchElementReturnPath {
        int length = list.length;
        E element = null;
        int i = 0;
        while (i < length) {
            element = list[i];
            if (predicate.test(element)) {
                return element;
            }
            ++i;
        }
        throw NoSuchElementReturnPath.I;
    }

    public static <E> E findFirstRP(Predicate<E> predicate, @CollectionValue List<E> list) throws NoSuchElementReturnPath {
        if (CollectionUtilities.isRandomAccessFast(list)) {
            int length = list.size();
            E element = null;
            int i = 0;
            while (i < length) {
                element = list.get(i);
                if (predicate.test(element)) {
                    return element;
                }
                ++i;
            }
            throw NoSuchElementReturnPath.I;
        }
        for (E element : list) {
            if (!predicate.test(element)) continue;
            return element;
        }
        throw NoSuchElementReturnPath.I;
    }

    public static Object findFirst(Predicate predicate, @CollectionValue Object list) {
        try {
            return PolymorphicCollectionUtilities.findFirstRP(predicate, list);
        }
        catch (NoSuchElementReturnPath exc) {
            return null;
        }
    }

    public static <E> E findFirst(Predicate<E> predicate, @CollectionValue E[] list) {
        try {
            return CollectionUtilities.findFirstRP(predicate, list);
        }
        catch (NoSuchElementReturnPath exc) {
            return null;
        }
    }

    public static <E> E findFirst(Predicate<E> predicate, @CollectionValue List<E> list) {
        try {
            return CollectionUtilities.findFirstRP(predicate, list);
        }
        catch (NoSuchElementReturnPath exc) {
            return null;
        }
    }

    public static <E> int findFirstIndex(Predicate<E> predicate, @CollectionValue List<E> list) {
        return CollectionUtilities.findFirstIntegerInIntervalOrNegativeOne(i -> predicate.test(list.get((int)i)), 0, list.size());
    }

    public static <E> int findLastIndex(Predicate<E> predicate, @CollectionValue List<E> list) {
        return CollectionUtilities.findLastIntegerInIntervalOrNegativeOne(i -> predicate.test(list.get((int)i)), 0, list.size());
    }

    public static <E> int findFirstIndex(Predicate<E> predicate, @CollectionValue List<E> list, int start) {
        return CollectionUtilities.findFirstIntegerInIntervalOrNegativeOne(i -> predicate.test(list.get((int)i)), start, list.size());
    }

    public static <E> int findLastIndex(Predicate<E> predicate, @CollectionValue List<E> list, int start) {
        return CollectionUtilities.findLastIntegerInIntervalOrNegativeOne(i -> predicate.test(list.get((int)i)), 0, start + 1);
    }

    public static int findFirstIndex(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, @CollectionValue CharSequence list) {
        return CollectionUtilities.findFirstIntegerInIntervalOrNegativeOne(i -> predicate.f(list.charAt((int)i)), 0, list.length());
    }

    public static int findLastIndex(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, @CollectionValue CharSequence list) {
        return CollectionUtilities.findLastIntegerInIntervalOrNegativeOne(i -> predicate.f(list.charAt((int)i)), 0, list.length());
    }

    public static int findFirstIndex(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, @CollectionValue CharSequence list, int start) {
        return CollectionUtilities.findFirstIntegerInIntervalOrNegativeOne(i -> predicate.f(list.charAt((int)i)), start, list.length());
    }

    public static int findLastIndex(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, @CollectionValue CharSequence list, int start) {
        return CollectionUtilities.findLastIntegerInIntervalOrNegativeOne(i -> predicate.f(list.charAt((int)i)), 0, start + 1);
    }

    @Nullable
    public static Integer findFirstIntegerInInterval(Predicate<Integer> predicate, int inclusiveLowerBound, int exclusiveUpperBound) {
        int i = inclusiveLowerBound;
        while (i < exclusiveUpperBound) {
            if (predicate.test(i)) {
                return i;
            }
            ++i;
        }
        return null;
    }

    @Nullable
    public static Integer findLastIntegerInInterval(Predicate<Integer> predicate, int inclusiveLowerBound, int exclusiveUpperBound) {
        int i = exclusiveUpperBound - 1;
        while (i >= inclusiveLowerBound) {
            if (predicate.test(i)) {
                return i;
            }
            --i;
        }
        return null;
    }

    public static int findFirstIntegerInIntervalOrNegativeOne(Predicate<Integer> predicate, int inclusiveLowerBound, int exclusiveUpperBound) {
        int i = inclusiveLowerBound;
        while (i < exclusiveUpperBound) {
            if (predicate.test(i)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int findLastIntegerInIntervalOrNegativeOne(Predicate<Integer> predicate, int inclusiveLowerBound, int exclusiveUpperBound) {
        int i = exclusiveUpperBound - 1;
        while (i >= inclusiveLowerBound) {
            if (predicate.test(i)) {
                return i;
            }
            --i;
        }
        return -1;
    }

    public static byte[] intervalBytesArray(byte first, int count) {
        byte[] a = new byte[count];
        int i = 0;
        while (i < count) {
            a[i] = (byte)(first + i);
            ++i;
        }
        return a;
    }

    public static PrimitiveCollections.ImmutableByteIntervalList intervalBytesList(byte first, int count) {
        return new PrimitiveCollections.ImmutableByteIntervalList(first, count);
    }

    public static PrimitiveCollections.ImmutableByteIntervalSet intervalBytesSet(byte first, int count) {
        return new PrimitiveCollections.ImmutableByteIntervalSet(first, count);
    }

    public static char[] intervalCharactersArray(char first, int count) {
        char[] a = new char[count];
        int i = 0;
        while (i < count) {
            a[i] = (char)(first + i);
            ++i;
        }
        return a;
    }

    public static PrimitiveCollections.ImmutableCharacterIntervalList intervalCharactersList(char first, int count) {
        return new PrimitiveCollections.ImmutableCharacterIntervalList(first, count);
    }

    public static PrimitiveCollections.ImmutableCharacterIntervalSet intervalCharactersSet(char first, int count) {
        return new PrimitiveCollections.ImmutableCharacterIntervalSet(first, count);
    }

    public static short[] intervalShortsArray(short first, int count) {
        short[] a = new short[count];
        int i = 0;
        while (i < count) {
            a[i] = (short)(first + i);
            ++i;
        }
        return a;
    }

    public static PrimitiveCollections.ImmutableShortIntervalList intervalShortsList(short first, int count) {
        return new PrimitiveCollections.ImmutableShortIntervalList(first, count);
    }

    public static PrimitiveCollections.ImmutableShortIntervalSet intervalShortsSet(short first, int count) {
        return new PrimitiveCollections.ImmutableShortIntervalSet(first, count);
    }

    public static int[] intervalIntegersArray(int first, int count) {
        int[] a = new int[count];
        int i = 0;
        while (i < count) {
            a[i] = first + i;
            ++i;
        }
        return a;
    }

    public static PrimitiveCollections.ImmutableIntegerIntervalList intervalIntegersList(int first, int count) {
        return new PrimitiveCollections.ImmutableIntegerIntervalList(first, count);
    }

    public static PrimitiveCollections.ImmutableIntegerIntervalSet intervalIntegersSet(int first, int count) {
        return new PrimitiveCollections.ImmutableIntegerIntervalSet(first, count);
    }

    public static long[] intervalLongsArray(long first, int count) {
        long[] a = new long[count];
        int i = 0;
        while (i < count) {
            a[i] = first + (long)i;
            ++i;
        }
        return a;
    }

    public static PrimitiveCollections.ImmutableLongIntervalList intervalLongsList(long first, int count) {
        return new PrimitiveCollections.ImmutableLongIntervalList(first, count);
    }

    public static PrimitiveCollections.ImmutableLongIntervalSet intervalLongsSet(long first, int count) {
        return new PrimitiveCollections.ImmutableLongIntervalSet(first, count);
    }

    public static <E> int countEq(E candidate, @CollectionValue E[] list) {
        return CollectionUtilities.count((E x) -> BasicObjectUtilities.eq(candidate, x), list);
    }

    public static <E> int countEq(E candidate, @CollectionValue Iterable list) {
        return CollectionUtilities.count((E x) -> BasicObjectUtilities.eq(candidate, x), list);
    }

    public static <E> int count(Predicate<E> predicate, @CollectionValue E[] list) {
        int length = list.length;
        int count = 0;
        int i = 0;
        while (i < length) {
            if (predicate.test(list[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static <E> int count(Predicate<E> predicate, @CollectionValue Iterable<E> collection) {
        if (collection instanceof List) {
            List list = (List)collection;
            if (CollectionUtilities.isRandomAccessFast(list)) {
                int length = list.size();
                int count = 0;
                int i = 0;
                while (i < length) {
                    if (predicate.test(list.get(i))) {
                        ++count;
                    }
                    ++i;
                }
                return count;
            }
            int count = 0;
            for (Object element : list) {
                if (!predicate.test(element)) continue;
                ++count;
            }
            return count;
        }
        int count = 0;
        for (E element : collection) {
            if (!predicate.test(element)) continue;
            ++count;
        }
        return count;
    }

    protected static ClassCastException newComponentTypeMismatchException(Class source, Class dest) {
        return new ClassCastException("Source elements are " + source.getCanonicalName() + " but dest elements are " + dest.getCanonicalName() + "; source is not 'instanceof' dest!  D:");
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> asList(Iterable<E> iterable) {
        return iterable instanceof List ? (List<E>)iterable : CollectionUtilities.toNewMutableVariablelengthList(iterable);
    }

    @LiveValue
    @WritableValue
    public static <E> List<E> asList(E[] array) {
        return Arrays.asList(array);
    }

    @LiveValue
    @WritableValue
    public static <E> List<E> asListV(E ... array) {
        return CollectionUtilities.asList(array);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> Set<E> asSetUniqueifying(Iterable<E> iterable) {
        return iterable instanceof Set ? (Set<E>)iterable : CollectionUtilities.toNewMutableSetUniqueifying(iterable);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> Set<E> asSetUniqueifying(E[] array) {
        return CollectionUtilities.asSetUniqueifying(CollectionUtilities.asList(array));
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> Set<E> asSetUniqueifyingV(E ... array) {
        return CollectionUtilities.asSetUniqueifying(array);
    }

    @ThrowAwayValue
    public static <E> List<E> toNewMutableVariablelengthList(Iterable<E> iterable) {
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        ArrayList<E> list = new ArrayList<E>();
        for (E e : iterable) {
            list.add(e);
        }
        return list;
    }

    @ThrowAwayValue
    public static <E> List<E> toNewMutableVariablelengthList(E[] array) {
        return CollectionUtilities.toNewMutableVariablelengthList(CollectionUtilities.asList(array));
    }

    @ThrowAwayValue
    public static <E> List<E> toNewMutableVariablelengthListV(E ... array) {
        return CollectionUtilities.toNewMutableVariablelengthList(array);
    }

    @ThrowAwayValue
    public static <E> Set<E> toNewMutableSetUniqueifying(Iterable<E> iterable) {
        if (iterable instanceof Collection) {
            return new HashSet((Collection)iterable);
        }
        HashSet<E> set = new HashSet<E>();
        for (E e : iterable) {
            set.add(e);
        }
        return set;
    }

    @ThrowAwayValue
    public static <E> Set<E> toNewMutableSetUniqueifying(E[] array) {
        return CollectionUtilities.toNewMutableSetUniqueifying(CollectionUtilities.asList(array));
    }

    @ThrowAwayValue
    public static <E> Set<E> toNewMutableSetUniqueifyingV(E ... array) {
        return CollectionUtilities.toNewMutableSetUniqueifying(array);
    }

    @LiveValue
    public static <E> Iterable<E> singleUseIterable(Iterator<E> x) {
        return () -> x;
    }

    @LiveValue
    public static <E> Iterable<E> singleUseIterable(SimpleIterator<E> x) {
        return CollectionUtilities.singleUseIterable(x.toIterator());
    }

    @LiveValue
    public static <E> Iterable<E> singleUseIterable(Enumeration<E> x) {
        return CollectionUtilities.singleUseIterable(PolymorphicCollectionUtilities.anyToIterator(x));
    }

    @LiveValue
    @WritableValue
    public static <E> Iterator<E> getRemoveCallbackIteratorDecorator(final Iterator<E> readonlyIterator, final Collection<E> backingCollection) {
        return new Iterator<E>(){
            E current = null;

            @Override
            public boolean hasNext() {
                return readonlyIterator.hasNext();
            }

            @Override
            public E next() {
                this.current = readonlyIterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                backingCollection.remove(this.current);
            }
        };
    }

    @LiveValue
    @WritableValue
    public static <E> Iterator<E> getRemoveCallbackIteratorDecorator(final Iterator<E> readonlyIterator, final FunctionInterfaces.UnaryProcedure<E> removeHook) {
        return new Iterator<E>(){
            E current = null;

            @Override
            public boolean hasNext() {
                return readonlyIterator.hasNext();
            }

            @Override
            public E next() {
                this.current = readonlyIterator.next();
                return this.current;
            }

            @Override
            public void remove() {
                removeHook.f(this.current);
            }
        };
    }

    @LiveValue
    @WritableValue
    public static <E> Iterator<E> getRandomAccessRemoveCallbackIteratorDecorator(Iterator<E> readonlyIterator, List<E> backingList) {
        return CollectionUtilities.getIndexBasedRemoveCallbackIteratorDecorator(readonlyIterator, backingList::remove);
    }

    @LiveValue
    @WritableValue
    public static <E> Iterator<E> getIndexBasedRemoveCallbackIteratorDecorator(final Iterator<E> readonlyIterator, final FunctionInterfaces.UnaryProcedureInt remove) {
        return new Iterator<E>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return readonlyIterator.hasNext();
            }

            @Override
            public E next() {
                Object r = readonlyIterator.next();
                ++this.i;
                return r;
            }

            @Override
            public void remove() {
                remove.f(this.i);
            }
        };
    }

    @LiveValue
    @WritableValue
    public static <E> Iterator<E> newFullRandomAccessIterator(int initialSize, final FunctionInterfaces.UnaryFunction<Integer, E> getByIndex, final FunctionInterfaces.UnaryProcedureInt removeByIndex) {
        return new Iterator<E>(initialSize){
            int nextIndex = 0;
            int size;
            boolean alreadyRemoved;
            {
                this.size = n;
                this.alreadyRemoved = false;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex < this.size;
            }

            @Override
            public E next() {
                if (this.nextIndex >= this.size) {
                    throw new NoSuchElementException();
                }
                Object r = getByIndex.f(this.nextIndex);
                if (this.alreadyRemoved) {
                    this.alreadyRemoved = false;
                }
                ++this.nextIndex;
                return r;
            }

            @Override
            public void remove() throws IllegalStateException {
                if (this.nextIndex == 0) {
                    throw new IllegalStateException();
                }
                if (this.alreadyRemoved) {
                    throw new IllegalStateException();
                }
                this.alreadyRemoved = true;
                --this.size;
                --this.nextIndex;
                removeByIndex.f(this.nextIndex);
            }
        };
    }

    public static <E> Iterator<E> emptyIterator() {
        return Empty_Iterator;
    }

    public static <E> Iterable<E> emptyIterable() {
        return Empty_Iterable;
    }

    public static <E> SimpleIterator<E> singletonSimpleIterator(final E singleElement) {
        return new SimpleIterator<E>(){
            boolean atEnd = false;

            @Override
            public E nextrp() throws StopIterationReturnPath {
                if (!this.atEnd) {
                    this.atEnd = true;
                    return singleElement;
                }
                throw StopIterationReturnPath.I;
            }
        };
    }

    public static <E> SimpleIterator.SimpleIterable<E> singletonSimpleIterable(E singleElement) {
        return () -> CollectionUtilities.singletonSimpleIterator(singleElement);
    }

    public static <E> Iterator<E> singletonIterator(final E singleElement) {
        return new Iterator<E>(){
            boolean atEnd = false;

            @Override
            public boolean hasNext() {
                return !this.atEnd;
            }

            @Override
            public E next() {
                if (this.atEnd) {
                    throw new NoSuchElementException();
                }
                this.atEnd = true;
                return singleElement;
            }

            @Override
            public void remove() {
                throw new ReadonlyUnsupportedOperationException();
            }
        };
    }

    public static <E> Iterable<E> singletonIterable(E singleElement) {
        return () -> CollectionUtilities.singletonIterator(singleElement);
    }

    public static <E> Iterator<E> iteratorWithDifferentRemove(final Iterator<E> underlying, final Runnable remove) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return underlying.hasNext();
            }

            @Override
            public E next() {
                return underlying.next();
            }

            @Override
            public void remove() {
                remove.run();
            }
        };
    }

    public static <E> Iterator<E> iteratorWithDifferentRemoveProvidedContext(final Iterator<E> underlying, final IndexAndElementProvidingRemove<E> remove) {
        return new Iterator<E>(){
            int indexOfLastReturnedElement = -1;
            E lastReturnedElement = null;

            @Override
            public boolean hasNext() {
                return underlying.hasNext();
            }

            @Override
            public E next() {
                Object e = underlying.next();
                ++this.indexOfLastReturnedElement;
                this.lastReturnedElement = e;
                return e;
            }

            @Override
            public void remove() {
                if (this.indexOfLastReturnedElement < 0) {
                    throw new IllegalStateException();
                }
                remove.remove(this.lastReturnedElement, this.indexOfLastReturnedElement);
            }
        };
    }

    public static <E> Iterator<E> reversedIterator(final ListIterator<E> listIterator) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return listIterator.hasPrevious();
            }

            @Override
            public E next() {
                return listIterator.previous();
            }

            @Override
            public void remove() {
                listIterator.remove();
            }
        };
    }

    public static <E> Iterator<E> reversedIterator(List<E> list) {
        return CollectionUtilities.reversedIterator(list.listIterator(list.size()));
    }

    public static <E> Iterator<E> reversedIterator(final E[] list) {
        return new Iterator<E>(){
            int i;
            {
                this.i = objectArray.length;
            }

            @Override
            public boolean hasNext() {
                return this.i > 0;
            }

            @Override
            public E next() {
                try {
                    return list[--this.i];
                }
                catch (ArrayIndexOutOfBoundsException exc) {
                    throw new NoSuchElementException();
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static void reverseListInPlace(@WritableValue List list) {
        int n = list.size();
        int h = n / 2;
        int a = 0;
        while (a < h) {
            int b = n - a - 1;
            CollectionUtilities.swapElements(list, a, b);
            ++a;
        }
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> reversed(@ReadonlyValue List<E> list) {
        if (list.size() <= 1) {
            return list;
        }
        ArrayList<E> copylist = new ArrayList<E>(list);
        CollectionUtilities.reverseListInPlace(copylist);
        return copylist;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> shuffled(@ReadonlyValue List<E> list) {
        if (list.size() <= 1) {
            return list;
        }
        ArrayList<E> copylist = new ArrayList<E>(list);
        Collections.shuffle(copylist);
        return copylist;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> shuffled(@ReadonlyValue List<E> list, Random r) {
        if (list.size() <= 1) {
            return list;
        }
        ArrayList<E> copylist = new ArrayList<E>(list);
        Collections.shuffle(copylist, r);
        return copylist;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> rotated(@ReadonlyValue List<E> list, int amount) {
        if (list.size() <= 1 || amount == 0) {
            return list;
        }
        ArrayList<E> copylist = new ArrayList<E>(list);
        Collections.rotate(copylist, amount);
        return copylist;
    }

    public static <E> void push(List<E> self, E x) {
        self.add(x);
    }

    public static <E> E pop(List<E> self, E def) {
        if (self.isEmpty()) {
            return def;
        }
        return self.remove(self.size() - 1);
    }

    public static <E> E pop(List<E> self) {
        return CollectionUtilities.pop(self, null);
    }

    public static <E> E poprp(List<E> self) throws NoSuchElementReturnPath {
        if (self.isEmpty()) {
            throw NoSuchElementReturnPath.I;
        }
        return self.remove(self.size() - 1);
    }

    @WritableValue
    @ThrowAwayValue
    public static <E> List<E> makelist(FunctionInterfaces.UnaryFunctionIntToObject<E> generator, int inclusiveLowBound, int exclusiveHighBound) {
        ArrayList<E> newlist = new ArrayList<E>(exclusiveHighBound - inclusiveLowBound);
        int index = inclusiveLowBound;
        while (index < exclusiveHighBound) {
            newlist.add(generator.f(index));
            ++index;
        }
        return newlist;
    }

    public static <I> boolean forAllOrSome(Mapper<? super I, Boolean> mapper, Iterable<I> inputs) {
        for (I i : inputs) {
            try {
                if (mapper.f(i).booleanValue()) continue;
                return false;
            }
            catch (FilterAwayReturnPath filterAwayReturnPath) {
                // empty catch block
            }
        }
        return true;
    }

    public static <I> boolean forAnyOrSome(Mapper<? super I, Boolean> mapper, Iterable<I> inputs) {
        for (I i : inputs) {
            try {
                if (!mapper.f(i).booleanValue()) continue;
                return true;
            }
            catch (FilterAwayReturnPath filterAwayReturnPath) {
                // empty catch block
            }
        }
        return false;
    }

    public static <I> boolean forAllOrSome(Mapper<? super I, Boolean> mapper, I[] inputs) {
        I[] IArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            I i = IArray[n2];
            try {
                if (!mapper.f(i).booleanValue()) {
                    return false;
                }
            }
            catch (FilterAwayReturnPath filterAwayReturnPath) {
                // empty catch block
            }
            ++n2;
        }
        return true;
    }

    public static <I> boolean forAnyOrSome(Mapper<? super I, Boolean> mapper, I[] inputs) {
        I[] IArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            I i = IArray[n2];
            try {
                if (mapper.f(i).booleanValue()) {
                    return true;
                }
            }
            catch (FilterAwayReturnPath filterAwayReturnPath) {
                // empty catch block
            }
            ++n2;
        }
        return false;
    }

    public static <I> boolean forAll(Predicate<? super I> predicate, Iterable<I> inputs) {
        for (I i : inputs) {
            if (predicate.test(i)) continue;
            return false;
        }
        return true;
    }

    public static <I> boolean forAny(Predicate<? super I> predicate, Iterable<I> inputs) {
        for (I i : inputs) {
            if (!predicate.test(i)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean checkWhitelist(Iterable<E> collection, E ... whitelist) {
        throw new NotYetImplementedException();
    }

    public static <E> boolean checkWhitelist(Iterable<E> collection, Iterable<E> whitelist) {
        throw new NotYetImplementedException();
    }

    public static <E> boolean checkBlacklist(Iterable<E> collection, E ... blacklist) {
        throw new NotYetImplementedException();
    }

    public static <E> boolean checkBlacklist(Iterable<E> collection, Iterable<E> blacklist) {
        throw new NotYetImplementedException();
    }

    public static <E> boolean checkMinimumlist(Iterable<E> collection, E ... minlist) {
        throw new NotYetImplementedException();
    }

    public static <E> boolean checkMinimumlist(Iterable<E> collection, Iterable<E> minlist) {
        throw new NotYetImplementedException();
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static <E> E[] uniqueifyArray(E[] x) {
        return (Object[])PolymorphicCollectionUtilities.anyToArray(PolymorphicCollectionUtilities.anyToSet(x), x.getClass().getComponentType());
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static List uniqueifyListOrderPreservingOPC(@ReadonlyValue Iterable x) {
        if (x == null) {
            throw new NullPointerException();
        }
        Set s = PolymorphicCollectionUtilities.anyToSet(x);
        ArrayList l = new ArrayList();
        for (Object e : x) {
            if (!s.contains(e)) continue;
            l.add(e);
        }
        return l;
    }

    @PossiblySnapshotPossiblyLiveValue
    @ReadonlyValue
    public static <E> E[] uniqueifyArrayOrderPreservingOPC(@ReadonlyValue E[] x) {
        if (x == null) {
            throw new NullPointerException();
        }
        Set s = PolymorphicCollectionUtilities.anyToSet(x);
        Object[] a = (Object[])Array.newInstance(x.getClass().getComponentType(), x.length);
        int i = 0;
        E[] EArray = x;
        int n = x.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (s.contains(e)) {
                a[i++] = e;
            }
            ++n2;
        }
        int size = i;
        if (size < a.length) {
            Object[] n3 = (Object[])Array.newInstance(x.getClass().getComponentType(), size);
            System.arraycopy(a, 0, n3, 0, size);
            a = n3;
        }
        return a;
    }

    public static <E> void uniqueifyPresortedIP(@WritableValue Iterable<E> input, EqualityComparator<? super E> equalityComparator) {
        Iterator<E> i = input.iterator();
        Object last = null;
        boolean hasLast = false;
        while (i.hasNext()) {
            E e = i.next();
            if (!hasLast) {
                last = e;
                hasLast = true;
                continue;
            }
            if (equalityComparator.equals(e, last)) {
                i.remove();
                continue;
            }
            last = e;
        }
    }

    public static <E> void uniqueifyPresortedIP(@WritableValue Iterable<E> input) {
        CollectionUtilities.uniqueifyPresortedIP(input, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> List<E> uniqueifyPresortedOPC(Iterable<E> input) {
        ArrayList<E> l = new ArrayList<E>(CollectionUtilities.toList(input));
        CollectionUtilities.uniqueifyPresortedIP(l);
        return l;
    }

    public static <E> void addAll(Collection<E> self, Iterable<? extends E> source) {
        if (source instanceof Collection) {
            self.addAll((Collection)source);
        } else {
            for (E e : source) {
                self.add(e);
            }
        }
    }

    public static <E> void addAll(Collection<E> self, E[] source, int sourceOffset, int count) {
        int i = 0;
        while (i < count) {
            self.add(source[sourceOffset + i]);
            ++i;
        }
    }

    public static <E> void addAll(Collection<E> self, E[] source) {
        CollectionUtilities.addAll(self, source, 0, source.length);
    }

    public static <E> void addAll(Collection<E> self, List<? extends E> source, int sourceOffset, int count) {
        int i = 0;
        while (i < count) {
            self.add(source.get(sourceOffset + i));
            ++i;
        }
    }

    public static <E> E getExtantInstance(Collection<E> collection, E possiblyEquivalentButDifferentInstance) {
        if (possiblyEquivalentButDifferentInstance == null) {
            return null;
        }
        if (collection instanceof CollectionWithGetExtantInstanceNatural) {
            return ((CollectionWithGetExtantInstanceNatural)((Object)collection)).getExtantInstance(possiblyEquivalentButDifferentInstance);
        }
        for (E e : collection) {
            if (!BasicObjectUtilities.eq(possiblyEquivalentButDifferentInstance, e)) continue;
            return e;
        }
        return null;
    }

    public static <E> E getExtantInstance(Collection<E> collection, E possiblyEquivalentButDifferentInstance, EqualityComparator<E> equalityComparator) {
        if (possiblyEquivalentButDifferentInstance == null) {
            return null;
        }
        if (collection instanceof CollectionWithGetExtantInstanceSpecified) {
            return ((CollectionWithGetExtantInstanceSpecified)((Object)collection)).getExtantInstance(possiblyEquivalentButDifferentInstance, equalityComparator);
        }
        for (E e : collection) {
            if (!equalityComparator.equals(possiblyEquivalentButDifferentInstance, e)) continue;
            return e;
        }
        return null;
    }

    public static boolean isSubset(Set sub, Set sup) {
        for (Object e : sub) {
            if (sup.contains(e)) continue;
            return false;
        }
        return true;
    }

    public static <E> Set<E> intersection(Set<E> ... sets) {
        if (sets.length == 0) {
            return new HashSet();
        }
        if (sets.length == 1) {
            return new HashSet<E>(sets[0]);
        }
        HashSet<E> output = new HashSet<E>();
        for (E e : sets[0]) {
            boolean all = true;
            int setIndex = 1;
            while (all && setIndex < sets.length) {
                all &= sets[setIndex].contains(e);
                ++setIndex;
            }
            if (!all) continue;
            output.add(e);
        }
        return output;
    }

    public static <E> E intersectionSingletonOrNull(@NonnullElements Set<E> a, @NonnullElements Set<E> b) throws NotSingletonException {
        if (b.size() < a.size()) {
            Set<E> c = b;
            b = a;
            a = c;
        }
        E i = null;
        for (E e : a) {
            if (!b.contains(e)) continue;
            if (i != null) {
                throw new NotSingletonException();
            }
            i = e;
        }
        return i;
    }

    public static <E> Maybe<E> intersectionSingletonOrNothing(@NullableElements Set<E> a, @NullableElements Set<E> b) throws NotSingletonException {
        if (b.size() < a.size()) {
            Set<E> c = b;
            b = a;
            a = c;
        }
        boolean has = false;
        Object i = null;
        for (E e : a) {
            if (!b.contains(e)) continue;
            if (has) {
                throw new NotSingletonException();
            }
            i = e;
            has = true;
        }
        return has ? BasicCollectionUtilities.just(i) : BasicCollectionUtilities.nothing();
    }

    public static <E> Set<E> anysection(Set<E> ... sets) {
        if (sets.length == 0) {
            return Collections.emptySet();
        }
        if (sets.length == 1) {
            return Collections.emptySet();
        }
        HashSet<E> output = new HashSet<E>();
        for (E e : CollectionUtilities.unionV(sets)) {
            int n = 0;
            int setIndex = 0;
            while (n < 2 && setIndex < sets.length) {
                n += sets[setIndex].contains(e) ? 1 : 0;
                ++setIndex;
            }
            if (n < 2) continue;
            output.add(e);
        }
        return output;
    }

    public static <E> Set<E> symdiff(Set<E> a, Set<E> b) {
        HashSet<E> output = new HashSet<E>();
        for (E e : a) {
            if (b.contains(e)) continue;
            output.add(e);
        }
        for (E e : b) {
            if (a.contains(e)) continue;
            output.add(e);
        }
        return output;
    }

    @ReadonlyValue
    public static <K, V> Map<K, V> unionManyMaps(@ReadonlyValue Iterable<Map<K, V>> maps) throws AlreadyExistsException {
        return CollectionUtilities.unionManyMapsFiltering(maps, (k, v) -> true);
    }

    @ReadonlyValue
    public static <K, V> Map<K, V> unionManyMapsFiltering(@ReadonlyValue Iterable<Map<K, V>> maps, MapEntryPredicate<K, V> filter) throws AlreadyExistsException {
        int maxSize = 0;
        for (Map<K, V> m : maps) {
            maxSize += m.size();
        }
        HashMap r = new HashMap(maxSize);
        for (Map<K, V> m : maps) {
            for (Map.Entry<K, V> e : m.entrySet()) {
                if (!filter.test(e.getKey(), e.getValue())) continue;
                CollectionUtilities.putNewUniqueMandatory(r, e.getKey(), e.getValue());
            }
        }
        return r;
    }

    @ReadonlyValue
    public static <K, V> Map<K, V> unionMaps(@ReadonlyValue Map<K, V> a, @ReadonlyValue Map<K, V> b) throws AlreadyExistsException {
        if (a.isEmpty()) {
            return b;
        }
        return CollectionUtilities.unionMapsFilteringSecond(a, b, (k, v) -> true);
    }

    @ReadonlyValue
    public static <K, V> Map<K, V> unionMapsFilteringSecond(@ReadonlyValue Map<K, V> a, @ReadonlyValue Map<K, V> b, MapEntryPredicate<K, V> filter) throws AlreadyExistsException {
        if (b.isEmpty()) {
            return a;
        }
        HashMap<K, V> r = new HashMap<K, V>(a.size() + b.size());
        r.putAll(a);
        for (Map.Entry<K, V> e : b.entrySet()) {
            if (!filter.test(e.getKey(), e.getValue())) continue;
            CollectionUtilities.putNewUniqueMandatory(r, e.getKey(), e.getValue());
        }
        return r;
    }

    @ReadonlyValue
    public static <K, V> Map<K, Set<V>> unionGeneralMaps(@ReadonlyValue Map<K, ? extends Iterable<V>> a, @ReadonlyValue Map<K, ? extends Iterable<V>> b) {
        HashMap r = new HashMap(a.size() + b.size());
        CollectionUtilities.putAllGeneralMaps(r, a);
        CollectionUtilities.putAllGeneralMaps(r, b);
        return r;
    }

    public static <K, V> void putAllGeneralMaps(@ReadonlyValue Map<K, Set<V>> acceptor, @ReadonlyValue Map<K, ? extends Iterable<V>> donor) {
        for (Map.Entry<K, Iterable<V>> e : donor.entrySet()) {
            CollectionUtilities.addAll((Collection)CollectionUtilities.getOrCreate(acceptor, e.getKey(), () -> new HashSet()), e.getValue());
        }
    }

    public static <E> Set<E> union(Iterable<E> a, Iterable<E> b) {
        return CollectionUtilities.unionV(a, b);
    }

    public static <E> Set<E> unionV(Iterable<E> ... sets) {
        HashSet output = new HashSet();
        Iterable<E>[] iterableArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            Iterable<E> c = iterableArray[n2];
            CollectionUtilities.addAll(output, c);
            ++n2;
        }
        return output;
    }

    public static <E> Set<E> unionMany(Iterable<? extends Iterable<E>> sets) {
        HashSet output = new HashSet();
        for (Iterable<E> c : sets) {
            CollectionUtilities.addAll(output, c);
        }
        return output;
    }

    public static <I, O> Set<O> unionManyMapping(Mapper<I, Iterable<O>> mapper, Iterable<I> input) {
        HashSet output = new HashSet();
        for (I i : input) {
            Iterable<O> o;
            try {
                o = mapper.f(i);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            CollectionUtilities.addAll(output, o);
        }
        return output;
    }

    public static <E> Set<E> setdiff(Iterable<E> minuend, Collection<E> subtrahendToTakeAway) {
        HashSet<E> output = new HashSet<E>();
        for (E e : minuend) {
            if (subtrahendToTakeAway.contains(e)) continue;
            output.add(e);
        }
        return output;
    }

    public static <A, B, O> Set<O> cartesianProductMapped(Iterable<A> aSet, Iterable<B> bSet, FunctionInterfaces.BinaryFunction<A, B, O> mapper) {
        HashSet<O> oSet = new HashSet<O>();
        for (A a : aSet) {
            for (B b : bSet) {
                O o = mapper.f(a, b);
                oSet.add(o);
            }
        }
        return oSet;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <K, V> Map<K, V> unionDisjointMapsOPC(Map<K, V> a, Map<K, V> b) {
        if (a.isEmpty()) {
            return b;
        }
        if (b.isEmpty()) {
            return a;
        }
        return CollectionUtilities.unionDisjointMapsOP(a, b);
    }

    @ThrowAwayValue
    public static <K, V> Map<K, V> unionDisjointMapsOP(Map<K, V> a, Map<K, V> b) {
        HashMap<K, V> o = new HashMap<K, V>(a);
        for (Map.Entry<K, V> e : b.entrySet()) {
            CollectionUtilities.putNewMandatory(o, e.getKey(), e.getValue());
        }
        return o;
    }

    public static <E> Collection<E> unionMultisets(Iterable<E> a, Iterable<E> b) {
        return CollectionUtilities.unionV(a, b);
    }

    public static <E> Collection<E> unionMultisetsV(Iterable<E> ... sets) {
        ArrayList output = new ArrayList();
        Iterable<E>[] iterableArray = sets;
        int n = sets.length;
        int n2 = 0;
        while (n2 < n) {
            Iterable<E> c = iterableArray[n2];
            CollectionUtilities.addAll(output, c);
            ++n2;
        }
        return output;
    }

    public static <E> Collection<E> unionMultisetsMany(Iterable<? extends Iterable<E>> sets) {
        ArrayList output = new ArrayList();
        for (Iterable<E> c : sets) {
            CollectionUtilities.addAll(output, c);
        }
        return output;
    }

    public static <E> EqualityComparator<E> getBoundCollectionEqualityComparator(Collection<E> collection) {
        if (collection instanceof CollectionWithBoundEqualityComparator) {
            return ((CollectionWithBoundEqualityComparator)((Object)collection)).getEqualityComparator();
        }
        return BasicObjectUtilities.getNaturalEqualityComparator();
    }

    public static <E> boolean removeEqC(Collection<E> collection, E element, EqualityComparator<E> equalityComparator) {
        if (collection instanceof CollectionWithInvocationProvideableEqualityComparators) {
            return ((CollectionWithInvocationProvideableEqualityComparators)collection).remove(element, equalityComparator);
        }
        return CollectionUtilities.removeMatching(e -> equalityComparator.equals(element), collection);
    }

    public static <E> boolean containsEqC(Collection<E> collection, E element, EqualityComparator<E> equalityComparator) {
        if (collection instanceof CollectionWithInvocationProvideableEqualityComparators) {
            return ((CollectionWithInvocationProvideableEqualityComparators)collection).remove(element, equalityComparator);
        }
        Iterator<E> i = collection.iterator();
        Object e = null;
        while (i.hasNext()) {
            e = i.next();
            if (!equalityComparator.equals(e, element)) continue;
            return true;
        }
        return false;
    }

    public static <E> List<List<E>> splitlist(List<E> list, Predicate<E> delimiter, int limit, StringUtilities.WhatToDoWithEmpties whatToDoWithEmpties) {
        if (whatToDoWithEmpties == null) {
            throw new NullPointerException();
        }
        boolean leaveInEmpties = whatToDoWithEmpties == StringUtilities.WhatToDoWithEmpties.LeaveInEmpties;
        ArrayList<List<ArrayList<E>>> chunks = new ArrayList<List<ArrayList<E>>>();
        int chunkStart = 0;
        int i = 0;
        while (i < list.size() && (limit == -1 || chunks.size() < limit)) {
            if (delimiter.test(list.get(i))) {
                if (leaveInEmpties || i - chunkStart != 0) {
                    chunks.add(new ArrayList<E>(list.subList(chunkStart, i)));
                }
                chunkStart = i + 1;
            }
            ++i;
        }
        chunks.add(new ArrayList<E>(list.subList(chunkStart, list.size())));
        return chunks;
    }

    public static <E> List<List<E>> splitlist(List<E> list, Predicate<E> delimiter, int limit) {
        return CollectionUtilities.splitlist(list, delimiter, limit, StringUtilities.WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static <E> List<List<E>> splitlist(List<E> list, Predicate<E> delimiter) {
        return CollectionUtilities.splitlist(list, delimiter, -1);
    }

    public static <O, D extends O> List<O> joinlists(Iterable<? extends Iterable<? extends O>> lists, D delimiter) {
        ArrayList<D> r = new ArrayList<D>();
        boolean first = true;
        for (Iterable<O> iterable : lists) {
            if (first) {
                first = false;
            } else {
                r.add(delimiter);
            }
            CollectionUtilities.addAll(r, iterable);
        }
        return r;
    }

    public static <O, D extends O> List<O> joinSingletonLists(Iterable<? extends O> list, D delimiter) {
        ArrayList<O> r = new ArrayList<O>();
        boolean first = true;
        for (O e : list) {
            if (first) {
                first = false;
            } else {
                r.add(delimiter);
            }
            r.add(e);
        }
        return r;
    }

    public static <E> Iterator<E> unmodifiableIterator(final Iterator<E> underlying) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return underlying.hasNext();
            }

            @Override
            public E next() {
                return underlying.next();
            }

            @Override
            public void remove() {
                throw new ReadonlyUnsupportedOperationException();
            }
        };
    }

    public static <E> ListIterator<E> unmodifiableListIterator(final ListIterator<E> underlying) {
        return new ListIterator<E>(){

            @Override
            public boolean hasNext() {
                return underlying.hasNext();
            }

            @Override
            public E next() {
                return underlying.next();
            }

            @Override
            public boolean hasPrevious() {
                return underlying.hasPrevious();
            }

            @Override
            public E previous() {
                return underlying.previous();
            }

            @Override
            public int nextIndex() {
                return underlying.nextIndex();
            }

            @Override
            public int previousIndex() {
                return underlying.previousIndex();
            }

            @Override
            public void remove() {
                throw new ReadonlyUnsupportedOperationException();
            }

            @Override
            public void set(E e) {
                throw new ReadonlyUnsupportedOperationException();
            }

            @Override
            public void add(E e) {
                throw new ReadonlyUnsupportedOperationException();
            }
        };
    }

    public static boolean defaultContainsAll(Collection self, Collection param) {
        boolean all = true;
        for (Object e : param) {
            all &= self.contains(e);
        }
        return all;
    }

    public static <E> boolean defaultAddAll(Collection<E> self, Collection<? extends E> param) {
        boolean any = false;
        for (E e : param) {
            any |= self.add(e);
        }
        return any;
    }

    public static <E> boolean defaultRemoveAll(Collection<E> self, Collection param) {
        if (param == self) {
            boolean any;
            boolean bl = any = !self.isEmpty();
            if (any) {
                self.clear();
            }
            return any;
        }
        boolean any = false;
        for (Object e : param) {
            any |= self.remove(e);
        }
        return any;
    }

    public static <E> boolean defaultRetainAll(Collection<E> self, Collection param) {
        boolean any = false;
        for (E e : self) {
            if (param.contains(e)) continue;
            any |= self.remove(e);
        }
        return any;
    }

    public static <E> boolean defaultRemoveIf(@Nonnull Collection<E> self, @Nonnull Predicate<? super E> filter) {
        Objects.requireNonNull(self);
        Objects.requireNonNull(filter);
        boolean removedAtLeastOne = false;
        Iterator<E> i = self.iterator();
        while (i.hasNext()) {
            E e = i.next();
            if (!filter.test(e)) continue;
            i.remove();
            removedAtLeastOne = true;
        }
        return removedAtLeastOne;
    }

    public static <E> boolean defaultClear(Collection<E> self) {
        boolean any = false;
        Iterator<E> i = self.iterator();
        while (i.hasNext()) {
            i.next();
            i.remove();
        }
        return any;
    }

    public static <E> boolean defaultSizelessListsEquivalent(@Nullable Iterable<? extends E> a, @Nullable Iterable<? extends E> b, EqualityComparator<E> equalityComparator) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        Iterator<? extends E> ia = a.iterator();
        Iterator<? extends E> ib = b.iterator();
        return CollectionUtilities.defaultRemaindersOfIteratorsEquivalent(ia, ib, equalityComparator);
    }

    public static <E> boolean defaultRemaindersOfIteratorsEquivalent(@Nonnull Iterator<? extends E> ia, @Nonnull Iterator<? extends E> ib, EqualityComparator<E> equalityComparator) {
        block3: {
            E bn;
            E an;
            Objects.requireNonNull(ia);
            Objects.requireNonNull(ib);
            do {
                boolean bhn;
                boolean ahn;
                if ((ahn = ia.hasNext()) != (bhn = ib.hasNext())) {
                    return false;
                }
                if (!ahn) break block3;
                assert (bhn);
            } while (equalityComparator.equals(an = ia.next(), bn = ib.next()));
            return false;
        }
        return true;
    }

    public static <E> boolean defaultSizelessListsEquivalent(Iterable<E> a, Iterable<E> b) {
        return CollectionUtilities.defaultSizelessListsEquivalent(a, b, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> boolean defaultListsEquivalentDeep(List<? extends E> a, List<? extends E> b) {
        return CollectionUtilities.defaultListsEquivalent(a, b, (x, y) -> x instanceof List && y instanceof List ? CollectionUtilities.defaultListsEquivalentDeep((List)x, (List)y) : BasicObjectUtilities.eq(x, y));
    }

    public static <E> boolean defaultListsEquivalent(List<? extends E> a, List<? extends E> b, EqualityComparator<E> equalityComparator) {
        block7: {
            E bn;
            E an;
            int bs;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            Iterator<E> ia = a.iterator();
            Iterator<E> ib = b.iterator();
            do {
                boolean bhn;
                boolean ahn;
                if ((ahn = ia.hasNext()) != (bhn = ib.hasNext())) {
                    throw new ConcurrentModificationException("sizes were checked to be equal, but iterators produce unequal numbers of elements; either something is modifying the list un-thread-safely!, or it's just a really big bug in the list code XD''");
                }
                if (!ahn) break block7;
                assert (bhn);
            } while (equalityComparator.equals(an = ia.next(), bn = ib.next()));
            return false;
        }
        return true;
    }

    public static <E> boolean defaultListsEquivalent(List<? extends E> a, List<? extends E> b) {
        return CollectionUtilities.defaultListsEquivalent(a, b, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> boolean defaultSetsEquivalent(Set<? extends E> a, Set<? extends E> b) {
        int bs;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int as = a.size();
        if (as != (bs = b.size())) {
            return false;
        }
        if (CodeHinting.arbitrary(as, bs) == 0) {
            return true;
        }
        for (E an : a) {
            if (b.contains(an)) continue;
            return false;
        }
        return true;
    }

    public static <E> boolean extraCheckingSetsEquivalent(Set<? extends E> a, Set<? extends E> b) {
        block7: {
            E bn;
            int bs;
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            int as = a.size();
            if (as != (bs = b.size())) {
                return false;
            }
            if (CodeHinting.arbitrary(as, bs) == 0) {
                return true;
            }
            Iterator<E> ia = a.iterator();
            Iterator<E> ib = b.iterator();
            do {
                boolean bhn;
                boolean ahn;
                if ((ahn = ia.hasNext()) != (bhn = ib.hasNext())) {
                    throw new ConcurrentModificationException("sizes were checked to be equal, but iterators produce unequal numbers of elements; either something is modifying the set un-thread-safely!, or it's just a really big bug in the set code XD''");
                }
                if (!ahn) break block7;
                assert (bhn);
                E an = ia.next();
                bn = ib.next();
                if (b.contains(an)) continue;
                return false;
            } while (a.contains(bn));
            return false;
        }
        return true;
    }

    public static <E> boolean defaultSetsEquivalent(Collection<? extends E> a, Collection<? extends E> b, EqualityComparator<E> eq) {
        int bs;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int as = a.size();
        if (as != (bs = b.size())) {
            return false;
        }
        if (as == 0) {
            assert (bs == 0);
            return true;
        }
        for (Object e : a) {
            if (!CollectionUtilities.contains((E ee) -> eq.equals(e, ee), b)) {
                return false;
            }
            assert (CollectionUtilities.count((E x) -> eq.equals(x, e), a) == 1);
            assert (CollectionUtilities.count((E x) -> eq.equals(x, e), b) == 1);
        }
        return true;
    }

    public static <E> boolean defaultMultiSetsEquivalent_SmallNaive(Collection<? extends E> a, Collection<? extends E> b, EqualityComparator<E> eq) {
        int bs;
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        int as = a.size();
        if (as != (bs = b.size())) {
            return false;
        }
        if (as == 0) {
            assert (bs == 0);
            return true;
        }
        for (Object e : a) {
            int cb;
            int ca = CollectionUtilities.count((E x) -> eq.equals(x, e), a);
            if (ca == (cb = CollectionUtilities.count((E x) -> eq.equals(x, e), b))) continue;
            return false;
        }
        return true;
    }

    public static <K, V> boolean defaultMapsEquivalent(Map<? extends K, ? extends V> a, Map<? extends K, ? extends V> b, EqualityComparator<V> valuesEqualityComparator) {
        if (!CollectionUtilities.eqvSets(a.keySet(), b.keySet())) {
            return false;
        }
        Set<K> tokenKeys = a.keySet();
        for (K key : tokenKeys) {
            V valueB;
            V valueA = a.get(key);
            if (valuesEqualityComparator.equals(valueA, valueB = b.get(key))) continue;
            return false;
        }
        return true;
    }

    public static <K, V> boolean defaultMapsEquivalent(Map<? extends K, ? extends V> a, Map<? extends K, ? extends V> b) {
        return CollectionUtilities.defaultMapsEquivalent(a, b, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <K, V> boolean defaultMapsEquivalent(Map<? extends K, ? extends V> a, Map<? extends K, ? extends V> b, EqualityComparator<K> keysEqualityComparator, EqualityComparator<V> valuesEqualityComparator) {
        if (!CollectionUtilities.defaultSetsEquivalent(a.keySet(), b.keySet(), keysEqualityComparator)) {
            return false;
        }
        Set<K> aks = a.keySet();
        Set<? extends K> bks = b.keySet();
        for (K keyA : aks) {
            V valueB;
            K keyB = CollectionUtilities.lookupThrowingIfAbsentOrMultiple(keyA, bks, keysEqualityComparator);
            assert (keysEqualityComparator.equals(keyA, keyB));
            V valueA = a.get(keyA);
            if (valuesEqualityComparator.equals(valueA, valueB = b.get(keyB))) continue;
            return false;
        }
        return true;
    }

    public static <E> E lookupThrowingIfAbsentOrMultiple(E token, Collection<? extends E> c, EqualityComparator<? super E> eq) {
        E r = null;
        boolean has = false;
        for (E e : c) {
            if (!eq.equals(e, token)) continue;
            if (has) {
                throw new NotSingletonException("more than one element! o_o");
            }
            r = e;
            has = true;
        }
        if (!has) {
            throw new NotSingletonException("no elements! ><");
        }
        return r;
    }

    public static <E> int defaultListHashCode(Iterable<E> list) {
        int hashCode = 1;
        for (E e : list) {
            hashCode = 31 * hashCode + (e == null ? 0 : e.hashCode());
        }
        return hashCode;
    }

    public static <E> int defaultMultiSetHashCode(Iterable<E> collection) {
        int hashCode = 0;
        for (E e : collection) {
            hashCode += e == null ? 0 : e.hashCode();
        }
        return hashCode;
    }

    public static <E> int defaultSetHashCode(Set<E> set) {
        return CollectionUtilities.defaultMultiSetHashCode(set);
    }

    public static <K, V> int defaultMapHashCode(Map<K, V> map) {
        int hashCode = 0;
        for (Map.Entry<K, V> e : map.entrySet()) {
            hashCode += e.hashCode();
        }
        return hashCode;
    }

    public static <E> boolean defaultContains(Iterable<E> list, Object item, EqualityComparator<E> equalityComparator) {
        for (E e : list) {
            if (!equalityComparator.equals(item, e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean defaultContains(Iterable<E> list, Object item) {
        return CollectionUtilities.defaultContains(list, item, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> int defaultListIndexOf(Iterable<E> list, Object item, EqualityComparator<E> equalityComparator) {
        int i = 0;
        for (E e : list) {
            if (equalityComparator.equals(item, e)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E> int defaultListIndexOf(Iterable<E> list, Object item) {
        return CollectionUtilities.defaultListIndexOf(list, item, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> int defaultListLastIndexOf(List<E> list, Object item, EqualityComparator<E> equalityComparator) {
        int len = list.size();
        ListIterator<E> li = list.listIterator(len);
        int i = len;
        Object e = null;
        while (li.hasPrevious()) {
            --i;
            e = li.previous();
            if (!equalityComparator.equals(item, e)) continue;
            return i;
        }
        return -1;
    }

    public static <E> int defaultListLastIndexOf(List<E> list, Object item) {
        return CollectionUtilities.defaultListIndexOf(list, item, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> boolean defaultListAddAll(List<E> list, int startingIndex, Collection<? extends E> source) {
        boolean changed = false;
        int i = startingIndex;
        for (E e : source) {
            list.add(i, e);
            changed = true;
            ++i;
        }
        return changed;
    }

    public static <E> boolean defaultRemoveBySearch(Iterable<E> list, Object item, EqualityComparator<E> equalityComparator) {
        Iterator<E> i = list.iterator();
        Object e = null;
        while (i.hasNext()) {
            e = i.next();
            if (!equalityComparator.equals(item, e)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public static <E> boolean defaultRemoveBySearch(Iterable<E> list, Object item) {
        return CollectionUtilities.defaultRemoveBySearch(list, item, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static Object[] defaultToArray(Collection<?> self) {
        int len = self.size();
        Object[] array = new Object[len];
        int i = 0;
        for (Object e : self) {
            array[i] = e;
            ++i;
        }
        if (i != len) {
            throw new ImpossibleException("Sizes didn't match up!!!");
        }
        return array;
    }

    public static <E, T> T[] defaultToArray(Collection<E> self, T[] array) {
        int len = self.size();
        if (array.length < len) {
            array = (Object[])Array.newInstance(array.getClass().getComponentType(), len);
        }
        int i = 0;
        for (E e : self) {
            array[i] = e;
            ++i;
        }
        if (i != len) {
            throw new ImpossibleException("Sizes didn't match up!!!");
        }
        return array;
    }

    public static <C extends Collection<?>> C allnotnull(C collection) throws NullPointerException {
        for (Object o : collection) {
            if (o != null) continue;
            throw new NullPointerException();
        }
        return collection;
    }

    @ThrowAwayValue
    public static <E> E[] sorted(@ReadonlyValue E[] input) {
        Object[] sorted = (Object[])input.clone();
        Arrays.sort(sorted);
        return sorted;
    }

    @ThrowAwayValue
    public static <E> E[] sorted(@ReadonlyValue E[] input, Comparator<? super E> comparator) {
        Object[] sorted = (Object[])input.clone();
        Arrays.sort(sorted, comparator);
        return sorted;
    }

    @ThrowAwayValue
    public static <E> List<E> sorted(@ReadonlyValue Collection<E> input) {
        Object[] array = input.toArray();
        Arrays.sort(array);
        return Arrays.asList(array);
    }

    @ThrowAwayValue
    public static <E> List<E> sorted(@ReadonlyValue Collection<E> input, Comparator<? super E> comparator) {
        Object[] array = input.toArray();
        Arrays.sort(array, comparator);
        return Arrays.asList(array);
    }

    public static List getMultidimensionalListWrapper(Object[] arrayOfR, int depth) {
        if (depth < 1) {
            throw new IllegalArgumentException("Depth < 1");
        }
        if (depth == 1) {
            return Arrays.asList(arrayOfR);
        }
        List[] arrayOfLists = new List[arrayOfR.length];
        int i = 0;
        while (i < arrayOfLists.length) {
            arrayOfLists[i] = CollectionUtilities.getMultidimensionalListWrapper((Object[])arrayOfR[i], depth - 1);
            ++i;
        }
        return Arrays.asList(arrayOfLists);
    }

    public static <E> List<E> getOneDimensionalListWrapper(E[] array) {
        return CollectionUtilities.getMultidimensionalListWrapper(array, 1);
    }

    public static <E> List<List<E>> getTwoDimensionalListWrapper(E[][] arrayOfArrays) {
        return CollectionUtilities.getMultidimensionalListWrapper(arrayOfArrays, 2);
    }

    public static <E> List<List<List<E>>> getThreeDimensionalListWrapper(E[][][] arrayOfArraysOfArrays) {
        return CollectionUtilities.getMultidimensionalListWrapper(arrayOfArraysOfArrays, 3);
    }

    public static List getMultidimensionalListShallowCopy(List sourceList, int depth, Class<? extends List> listClass) {
        try {
            if (depth < 1) {
                throw new IllegalArgumentException("Depth < 1");
            }
            if (depth == 1) {
                List destList = listClass.newInstance();
                for (Object e : sourceList) {
                    destList.add(e);
                }
                return destList;
            }
            List destList = listClass.newInstance();
            for (List e : sourceList) {
                destList.add(CollectionUtilities.getMultidimensionalListShallowCopy(e, depth - 1, listClass));
            }
            return destList;
        }
        catch (InstantiationException exc) {
            throw new RuntimeException();
        }
        catch (IllegalAccessException exc) {
            throw new RuntimeException();
        }
    }

    public static List getMultidimensionalListShallowCopy(List sourceList, int depth) {
        return CollectionUtilities.getMultidimensionalListShallowCopy(sourceList, depth, ArrayList.class);
    }

    public static <E> List<E> getOneDimensionalListShallowCopy(List<E> sourceList) {
        return CollectionUtilities.getMultidimensionalListShallowCopy(sourceList, 1);
    }

    public static <E> List<List<E>> getTwoDimensionalListShallowCopy(List<List<E>> sourceList) {
        return CollectionUtilities.getMultidimensionalListShallowCopy(sourceList, 2);
    }

    public static <E> List<List<List<E>>> getThreeDimensionalListShallowCopy(List<List<List<E>>> sourceList) {
        return CollectionUtilities.getMultidimensionalListShallowCopy(sourceList, 3);
    }

    public static <A, B> List convertMultidimensional(List list, int depth, FunctionInterfaces.UnaryFunction<A, B> converter) {
        if (depth < 0) {
            throw new IllegalArgumentException("Depth < 0");
        }
        if (depth == 0) {
            return list;
        }
        if (depth == 1) {
            int i = 0;
            while (i < list.size()) {
                Object source = list.get(i);
                B dest = converter.f(source);
                list.set(i, dest);
                ++i;
            }
        } else {
            int i = 0;
            while (i < list.size()) {
                CollectionUtilities.convertMultidimensional((List)list.get(i), depth - 1, converter);
                ++i;
            }
        }
        return list;
    }

    public static <A, B, E> List<E> convertOneDimensional(List<E> list, FunctionInterfaces.UnaryFunction<A, B> converter) {
        return CollectionUtilities.convertMultidimensional(list, 1, converter);
    }

    public static <A, B, E> List<List<E>> convertTwoDimensional(List<List<E>> listOfLists, FunctionInterfaces.UnaryFunction<A, B> converter) {
        return CollectionUtilities.convertMultidimensional(listOfLists, 2, converter);
    }

    public static <A, B, E> List<List<List<E>>> convertThreeDimensional(List<List<List<E>>> listOfListOfLists, FunctionInterfaces.UnaryFunction<A, B> converter) {
        return CollectionUtilities.convertMultidimensional(listOfListOfLists, 3, converter);
    }

    @ReadonlyValue
    public static <E> List<List<E>> partition(@LiveValue @ReadonlyValue List<E> elements, int partitionSize) {
        int nElements = elements.size();
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        List[] partitions = new List[nPartitions];
        int i = 0;
        while (i < nPartitions) {
            int start = i * partitionSize;
            partitions[i] = elements.subList(start, SmallIntegerMathUtilities.least(start + partitionSize, nElements));
            ++i;
        }
        return CollectionUtilities.asList(partitions);
    }

    public static <K, V> Map<K, V> keysToMap(FunctionInterfaces.UnaryFunction<K, V> valuemaker, Set<K> keys) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (K key : keys) {
            map.put(key, valuemaker.f(key));
        }
        return map;
    }

    public static <K, V> Map<K, V> valuesToMapSilent(FunctionInterfaces.UnaryFunction<V, K> keymaker, Collection<V> values) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (V value : values) {
            map.put(keymaker.f(value), value);
        }
        return map;
    }

    public static <K, V> Map<K, V> valuesToMapErring(FunctionInterfaces.UnaryFunction<V, K> keymaker, Collection<V> values) throws AlreadyExistsException {
        HashMap<K, V> map = new HashMap<K, V>();
        for (V value : values) {
            K key = keymaker.f(value);
            if (map.containsKey(key)) {
                throw new AlreadyExistsException("Key: " + ObjectUtilities.toStringNT(key));
            }
            map.put(key, value);
        }
        return map;
    }

    public static <Ki, Vi, Ko, Vo> Map<Ko, Vo> mapdict(Mapper<Map.Entry<Ki, Vi>, Map.Entry<Ko, Vo>> function, Map<Ki, Vi> input) throws NonReverseInjectiveMapException {
        return CollectionUtilities.maptodict(function, input.entrySet());
    }

    public static <I, Ko, Vo> Map<Ko, Vo> maptodict(Mapper<I, Map.Entry<Ko, Vo>> function, Iterable<I> input) throws NonReverseInjectiveMapException {
        HashMap<Ko, Vo> output = new HashMap<Ko, Vo>();
        for (I in : input) {
            Map.Entry<Ko, Vo> eOut;
            try {
                eOut = function.f(in);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            if (eOut == null) continue;
            Ko key = eOut.getKey();
            if (output.containsKey(key)) {
                throw new NonReverseInjectiveMapException("Conflict!  Multiple entries mapping to the key: " + StringUtilities.repr(key));
            }
            output.put(key, eOut.getValue());
        }
        return output;
    }

    public static <K, V> Map<K, V> maptodictSameKeys(Mapper<K, V> function, Iterable<K> input) throws NonReverseInjectiveMapException {
        return CollectionUtilities.maptodict(k -> new AbstractMap.SimpleEntry(k, function.f(k)), input);
    }

    public static <K, V> Map<K, V> maptodictSameValues(Mapper<V, K> function, Iterable<V> input) throws NonReverseInjectiveMapException {
        return CollectionUtilities.maptodict(v -> new AbstractMap.SimpleEntry(function.f(v), v), input);
    }

    public static <K, Vi, Vo> Map<K, Vo> mapdictvalues(Mapper<Vi, Vo> function, Map<K, Vi> input) {
        HashMap<K, Vo> output = new HashMap<K, Vo>();
        for (Map.Entry<K, Vi> eIn : input.entrySet()) {
            Vo vOut;
            try {
                vOut = function.f(eIn.getValue());
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            K key = eIn.getKey();
            if (output.containsKey(key)) {
                throw new NonReverseInjectiveMapException("This means the *original* map already existed in corrupt non-reverse-injective state!");
            }
            output.put(key, vOut);
        }
        return output;
    }

    public static <Ki, Ko, V> Map<Ko, V> mapdictkeys(Mapper<Ki, Ko> function, Map<Ki, V> input) throws NonReverseInjectiveMapException {
        return CollectionUtilities.mapdict(e -> new AbstractMap.SimpleEntry(function.f(e.getKey()), e.getValue()), input);
    }

    public static <I, Ko, Vo> Map<Ko, Set<Vo>> maptogendict(Mapper<I, Map.Entry<Ko, Vo>> function, Iterable<I> input) throws NonReverseInjectiveMapException {
        HashMap output = new HashMap();
        for (I in : input) {
            Map.Entry<Ko, Vo> eOut;
            try {
                eOut = function.f(in);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            if (eOut == null) continue;
            Ko key = eOut.getKey();
            Set set = CollectionUtilities.getOrCreate(output, key, HashSet::new);
            set.add(eOut.getValue());
        }
        return output;
    }

    public static <K, V> Map<K, V> filterdict(MapEntryPredicate<K, V> predicate, Map<K, V> input) {
        HashMap<K, V> output = new HashMap<K, V>();
        for (Map.Entry<K, V> e : input.entrySet()) {
            if (!predicate.test(e.getKey(), e.getValue())) continue;
            output.put(e.getKey(), e.getValue());
        }
        return output;
    }

    public static <K, V> Map<K, V> filterdictByValues(Predicate<V> predicate, Map<K, V> input) {
        return CollectionUtilities.filterdict((k, v) -> predicate.test(v), input);
    }

    public static <K, V> Map<K, V> filterdictByKeys(Predicate<K> predicate, Map<K, V> input) {
        return CollectionUtilities.filterdict((k, v) -> predicate.test(k), input);
    }

    public static <K, V extends Collection<?>> Map<K, V> maptodictSameKeysFilteringAwayEmptyValues(Mapper<K, V> function, Iterable<K> input) throws NonReverseInjectiveMapException {
        return CollectionUtilities.maptodict(k -> {
            Collection v = (Collection)function.f(k);
            if (v.isEmpty()) {
                throw FilterAwayReturnPath.I;
            }
            return new AbstractMap.SimpleEntry<Object, Collection>(k, v);
        }, input);
    }

    public static <K, V> void mapdictvaluesIP(Mapper<V, V> function, @WritableValue Map<K, V> map) {
        for (Map.Entry<K, V> eIn : map.entrySet()) {
            V vOut;
            K key = eIn.getKey();
            try {
                vOut = function.f(eIn.getValue());
            }
            catch (FilterAwayReturnPath exc) {
                map.remove(key);
                continue;
            }
            map.put(key, vOut);
        }
    }

    @ReadonlyValue
    @HashableValue
    public static Map mapof() {
        return Collections.emptyMap();
    }

    @ReadonlyValue
    @HashableValue
    public static Map mapof(Object key, Object value) {
        return Collections.singletonMap(key, value);
    }

    @ReadonlyValue
    @HashableValue
    public static Map mapof(Object ... keysAndValues) {
        return CollectionUtilities.mapofArray(keysAndValues);
    }

    @ReadonlyValue
    @HashableValue
    public static Map mapofInverted(Object ... valuesAndKeys) {
        return CollectionUtilities.mapofInvertedArray(valuesAndKeys);
    }

    @ThrowAwayValue
    public static Map newMap(Object ... keysAndValues) {
        return CollectionUtilities.newMapArray(keysAndValues);
    }

    @ThrowAwayValue
    public static Map newMapInverted(Object ... valuesAndKeys) {
        return CollectionUtilities.newMapInvertedArray(valuesAndKeys);
    }

    @ReadonlyValue
    @HashableValue
    public static Map mapofSome(Object ... keysAndValues) {
        if (keysAndValues.length == 0) {
            return Collections.emptyMap();
        }
        if (keysAndValues.length == 2) {
            return keysAndValues[1] == null ? Collections.emptyMap() : Collections.singletonMap(keysAndValues[0], ((Maybe)keysAndValues[1]).getJust());
        }
        return CollectionUtilities.newMapMaybeArray(keysAndValues);
    }

    @ReadonlyValue
    @HashableValue
    public static Map mapofArray(Object[] keysAndValues) {
        if (keysAndValues.length == 0) {
            return Collections.emptyMap();
        }
        if (keysAndValues.length == 2) {
            return Collections.singletonMap(keysAndValues[0], keysAndValues[1]);
        }
        return CollectionUtilities.newMap(keysAndValues);
    }

    @ReadonlyValue
    @HashableValue
    public static Map mapofInvertedArray(Object[] valuesAndKeys) {
        if (valuesAndKeys.length == 0) {
            return Collections.emptyMap();
        }
        if (valuesAndKeys.length == 2) {
            return Collections.singletonMap(valuesAndKeys[1], valuesAndKeys[0]);
        }
        return CollectionUtilities.newMapInvertedArray(valuesAndKeys);
    }

    @ThrowAwayValue
    public static Map newMapMaybeArray(Object[] keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap m = new HashMap();
        int i = 0;
        while (i < keysAndValues.length) {
            Object key = keysAndValues[i];
            if (m.containsKey(key)) {
                throw new AlreadyExistsException();
            }
            Maybe valuem = (Maybe)keysAndValues[i + 1];
            if (valuem != null) {
                Object value = valuem.getJust();
                m.put(key, value);
            }
            i += 2;
        }
        return m;
    }

    @ThrowAwayValue
    public static Map newMapArray(Object[] keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        int i = 0;
        while (i < keysAndValues.length) {
            Object key = keysAndValues[i];
            if (m.containsKey(key)) {
                throw new AlreadyExistsException();
            }
            m.put(key, keysAndValues[i + 1]);
            i += 2;
        }
        return m;
    }

    @ThrowAwayValue
    public static Map newMapInvertedArray(Object[] valuesAndKeys) {
        if (valuesAndKeys.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        HashMap<Object, Object> m = new HashMap<Object, Object>();
        int i = 0;
        while (i < valuesAndKeys.length) {
            Object key = valuesAndKeys[i + 1];
            if (m.containsKey(key)) {
                throw new AlreadyExistsException();
            }
            m.put(key, valuesAndKeys[i]);
            i += 2;
        }
        return m;
    }

    @ReadonlyValue
    @HashableValue
    public static <E> Set<E> setof(E member) {
        return CollectionUtilities.singletonSet(member);
    }

    @ReadonlyValue
    @HashableValue
    public static <E> Set<E> setof() {
        return Collections.emptySet();
    }

    @ReadonlyValue
    @HashableValue
    public static <E> Set<E> setof(E ... members) {
        return CollectionUtilities.setofArray(members);
    }

    @ThrowAwayValue
    public static <E> Set<E> newSet(E ... members) {
        return CollectionUtilities.newSetArray(members);
    }

    @ReadonlyValue
    @HashableValue
    public static <E> Set<E> setofArray(E[] members) {
        if (members.length == 0) {
            return Collections.emptySet();
        }
        if (members.length == 1) {
            return CollectionUtilities.singletonSet(members[0]);
        }
        return CollectionUtilities.newSet(members);
    }

    @ThrowAwayValue
    public static <E> Set<E> newSetArray(E[] members) {
        return new HashSet<E>(CollectionUtilities.asList(members));
    }

    @ReadonlyValue
    @HashableValue
    public static <E> Set<E> setofSome(Maybe<E> ... members) {
        if (members.length == 0) {
            return Collections.emptySet();
        }
        if (members.length == 1) {
            return members[0] == null ? Collections.emptySet() : CollectionUtilities.singletonSet(members[0].getJust());
        }
        return CollectionUtilities.mapToSet((I m) -> {
            if (m == null) {
                throw FilterAwayReturnPath.I;
            }
            return m.getJust();
        }, members);
    }

    @ReadonlyValue
    @HashableValue
    public static <E> List<E> listof() {
        return Collections.emptyList();
    }

    @ReadonlyValue
    @HashableValue
    public static <E> List<E> listof(E member) {
        return Collections.singletonList(member);
    }

    @ReadonlyValue
    @HashableValue
    public static <E> List<E> listof(E ... members) {
        return CollectionUtilities.listofArray(members);
    }

    @ThrowAwayValue
    public static <E> List<E> newList(E ... members) {
        return CollectionUtilities.newListArray(members);
    }

    @ThrowAwayValue
    @Deprecated
    public static <E> List<E> newlistofUnspecifiedWritability(E ... members) {
        return CollectionUtilities.newListArray(members);
    }

    @ReadonlyValue
    @HashableValue
    public static <E> List<E> listofSome(Maybe<E> ... members) {
        if (members.length == 0) {
            return Collections.emptyList();
        }
        if (members.length == 1) {
            return members[0] == null ? Collections.emptyList() : Collections.singletonList(members[0].getJust());
        }
        return CollectionUtilities.mapToList((I m) -> {
            if (m == null) {
                throw FilterAwayReturnPath.I;
            }
            return m.getJust();
        }, members);
    }

    @ReadonlyValue
    @HashableValue
    public static <E> List<E> listofArray(E[] members) {
        if (members.length == 0) {
            return Collections.emptyList();
        }
        if (members.length == 1) {
            return Collections.singletonList(members[0]);
        }
        return CollectionUtilities.asList(members);
    }

    @ThrowAwayValue
    public static <E> List<E> newListArray(E[] members) {
        return new ArrayList<E>(CollectionUtilities.listofArray(members));
    }

    @ThrowAwayValue
    @WritableValue
    public static <E> List<E> newListNullfilled(int size) {
        ArrayList l = new ArrayList(size);
        CollectionUtilities.fillByAdding(l, null, size);
        return l;
    }

    @ReadonlyValue
    @HashableValue
    public static <E> SimpleTable<E> tableof(int width, E ... contents) {
        return CollectionUtilities.tableofArray(width, contents);
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> newTable(int width, E ... contents) {
        return CollectionUtilities.newTableArray(width, contents);
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> newTableFromOneRow(List<E> contents) {
        return CollectionUtilities.newTableList(contents.size(), contents);
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> newTableFromOther(@ReadonlyValue @SnapshotValue SimpleTable<E> contents) {
        SimpleTable<E> t = CollectionUtilities.newTable();
        t.setFrom(contents);
        return t;
    }

    @PossiblySnapshotPossiblyLiveValue
    @WritableValue
    public static <E> SimpleTable<E> writableTable(@PossiblySnapshotPossiblyLiveValue SimpleTable<E> contents) {
        return contents.isWritableTable() ? contents : CollectionUtilities.newTableFromOther(contents);
    }

    @ReadonlyValue
    public static <E> SimpleTable<E> tableofArray(int width, E[] contents) {
        if (width == 0 || contents.length == 0) {
            return CollectionUtilities.emptyTable();
        }
        return CollectionUtilities.newTableArray(width, contents);
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> newTableArray(int width, E[] contents) {
        if (contents.length % width != 0) {
            throw new IllegalArgumentException();
        }
        int height = contents.length / width;
        SimpleTable<E> t = CollectionUtilities.newTableNullfilled(width, height);
        int r = 0;
        while (r < height) {
            int c = 0;
            while (c < width) {
                int i = r * width + c;
                t.setCellContents(c, r, contents[i]);
                ++c;
            }
            ++r;
        }
        return t;
    }

    @ReadonlyValue
    public static <E> SimpleTable<E> tableofList(int width, List<E> contents) {
        if (width == 0 || contents.size() == 0) {
            return CollectionUtilities.emptyTable();
        }
        return CollectionUtilities.newTableList(width, contents);
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> newTableList(int width, List<E> contents) {
        if (contents.size() % width != 0) {
            throw new IllegalArgumentException();
        }
        int height = contents.size() / width;
        SimpleTable<E> t = CollectionUtilities.newTableNullfilled(width, height);
        int r = 0;
        while (r < height) {
            int c = 0;
            while (c < width) {
                int i = r * width + c;
                t.setCellContents(c, r, contents.get(i));
                ++c;
            }
            ++r;
        }
        return t;
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> newTable() {
        return CollectionUtilities.newTableNullfilled(0, 0);
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> newTableNullfilled(int width, int height) {
        return new NestedListsSimpleTable(width, height);
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> newTableGivenfilled(int width, int height, E initialValue) {
        SimpleTable<E> t = CollectionUtilities.newTableNullfilled(width, height);
        t.setAllToSameValue(initialValue);
        return t;
    }

    @ReadonlyValue
    public static <E> SimpleTable<E> emptyTable() {
        return CollectionUtilities.newTable();
    }

    public static <K, I, O> O getAndDoOrDefault(Map<K, I> map, K key, FunctionInterfaces.UnaryFunction<I, O> function, O defaultValue) {
        I input = map.get(key);
        if (input == null && !map.containsKey(key)) {
            return defaultValue;
        }
        return function.f(input);
    }

    public static <K, I, O> O getremoveAndDoOrDefault(Map<K, I> map, K key, FunctionInterfaces.UnaryFunction<I, O> function, O defaultValue) {
        if (map.containsKey(key)) {
            return function.f(map.remove(key));
        }
        return defaultValue;
    }

    public static <K, V> V getOrCreate(Map<K, V> map, K key, FunctionInterfaces.NullaryFunction<V> creator) {
        V v = map.get(key);
        if (v == null && !map.containsKey(key)) {
            v = creator.f();
            map.put(key, v);
        }
        return v;
    }

    public static <E> boolean testSetRelation(Set<E> actual, Set<E> expected, SetRelationRequirement relation) {
        if (relation == SetRelationRequirement.ExactEquality) {
            return actual.equals(expected);
        }
        if (relation == SetRelationRequirement.ActualCanBeSubsetOfExpected) {
            return expected.containsAll(actual);
        }
        if (relation == SetRelationRequirement.ActualCanBeSupersetOfExpected) {
            return actual.containsAll(expected);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)relation);
    }

    public static <E extends Enum<E>> EnumSet<E> convertFromBitfieldToEnumSet(long bitfield, Class<E> enumType, SetRelationRequirement setRelation) {
        EnumSet<Enum> set = EnumSet.noneOf(enumType);
        long validationCheck = 0L;
        Enum[] enumArray = (Enum[])enumType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum member = enumArray[n2];
            long bv = ((StandardEnumSetConvertibleToIntFlags)((Object)member)).getBitfieldValue();
            if ((validationCheck & bv) != 0L) {
                throw new ImpossibleException("Two or more members of " + enumType.getName() + " overlap in the 1's of their binary values!!");
            }
            validationCheck |= bv;
            if ((bitfield & bv) != 0L) {
                set.add(member);
                bitfield &= bv ^ 0xFFFFFFFFFFFFFFFFL;
            }
            ++n2;
        }
        if (setRelation == SetRelationRequirement.ExactEquality && bitfield != 0L) {
            throw new IllegalArgumentException("The bitfield contained extra unre");
        }
        return set;
    }

    public static <E extends Enum<E>> long convertFromEnumSetToBitfield(EnumSet<E> set, Class<E> enumType) {
        long bitfield = 0L;
        long validationCheck = 0L;
        Enum[] enumArray = (Enum[])enumType.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum member = enumArray[n2];
            long bv = ((StandardEnumSetConvertibleToIntFlags)((Object)member)).getBitfieldValue();
            if ((validationCheck & bv) != 0L) {
                throw new ImpossibleException("Two or more members of " + enumType.getName() + " overlap in the 1's of their binary values!!");
            }
            validationCheck |= bv;
            if (set.contains(member)) {
                bitfield |= bv;
            }
            ++n2;
        }
        return bitfield;
    }

    public static <I, O> SimpleIterator<O> map(Mapper<I, O> mapper, SimpleIterator<I> underlying) {
        return () -> {
            while (true) {
                Object i = underlying.nextrp();
                try {
                    return mapper.f(i);
                }
                catch (FilterAwayReturnPath filterAwayReturnPath) {
                    continue;
                }
                break;
            }
        };
    }

    public static <E> SimpleIterator<E> filter(Predicate<E> predicate, SimpleIterator<E> underlying) {
        return () -> {
            Object e;
            while (!predicate.test(e = underlying.nextrp())) {
            }
            return e;
        };
    }

    public static <I, O> SimpleIterator<O> map(Mapper<I, O> mapper, Iterator<I> underlying) {
        return CollectionUtilities.map(mapper, SimpleIterator.simpleIterator(underlying));
    }

    public static <E> SimpleIterator<E> filter(Predicate<E> predicate, Iterator<E> underlying) {
        return CollectionUtilities.filter(predicate, SimpleIterator.simpleIterator(underlying));
    }

    public static <I, O> SimpleIterator.SimpleIterable<O> mapped(Mapper<I, O> mapper, SimpleIterator.SimpleIterable<I> underlying) {
        return () -> CollectionUtilities.map(mapper, underlying.simpleIterator());
    }

    public static <E> SimpleIterator.SimpleIterable<E> filtered(Predicate<E> predicate, SimpleIterator.SimpleIterable<E> underlying) {
        return () -> CollectionUtilities.filter(predicate, underlying.simpleIterator());
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> SimpleIterator.SimpleIterable<E> filteredOPC(Predicate<E> predicate, SimpleIterator.SimpleIterable<E> underlying) {
        if (CollectionUtilities.forAll(predicate, underlying)) {
            return underlying;
        }
        return () -> CollectionUtilities.filter(predicate, underlying.simpleIterator());
    }

    public static <I, O> SimpleIterator.SimpleIterable<O> mapped(Mapper<I, O> mapper, Iterable<I> underlying) {
        return () -> CollectionUtilities.map(mapper, underlying.iterator());
    }

    public static <E> SimpleIterator.SimpleIterable<E> filtered(Predicate<E> predicate, Iterable<E> underlying) {
        return () -> CollectionUtilities.filter(predicate, underlying.iterator());
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> SimpleIterator.SimpleIterable<E> filteredOPC(Predicate<E> predicate, Iterable<E> underlying) {
        if (CollectionUtilities.forAll(predicate, underlying)) {
            return SimpleIterator.SimpleIterable.simpleIterable(underlying);
        }
        return () -> CollectionUtilities.filter(predicate, underlying.iterator());
    }

    @ThrowAwayValue
    public static <I, O> Collection<O> mapToNewCollection(Mapper<I, O> mapper, Iterable<? extends I> input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Set) {
            return CollectionUtilities.mapToNewSet(mapper, (Set)input);
        }
        if (input instanceof List) {
            return CollectionUtilities.mapToNewList(mapper, (List)input);
        }
        return CollectionUtilities.mapToNewList(mapper, PolymorphicCollectionUtilities.anyToList(input));
    }

    @ThrowAwayValue
    public static <I, O> List<O> mapToNewList(Mapper<I, O> mapper, Iterable<? extends I> input) {
        return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(CollectionUtilities.mapped(mapper, input));
    }

    @ThrowAwayValue
    public static <I, O> Set<O> mapToNewSet(Mapper<I, O> mapper, Iterable<? extends I> input) {
        return PolymorphicCollectionUtilities.anyToNewMutableSet(CollectionUtilities.mapped(mapper, input));
    }

    @ThrowAwayValue
    public static <I, O, A extends I> O[] mapToNewArray(Mapper<I, O> mapper, Class<? super O> outputComponentType, A[] input) {
        return (Object[])PolymorphicCollectionUtilities.anyToNewArray(CollectionUtilities.mapped(mapper, Arrays.asList(input)), outputComponentType);
    }

    @ThrowAwayValue
    public static <I, O> O[] mapToNewArray(Mapper<I, O> mapper, Class<? super O> outputComponentType, Iterable<I> input) {
        return (Object[])PolymorphicCollectionUtilities.anyToNewArray(CollectionUtilities.mapped(mapper, input), outputComponentType);
    }

    @ThrowAwayValue
    public static <I, O, A extends I> Object[] mapToNewObjectArray(Mapper<I, O> mapper, A[] input) {
        return CollectionUtilities.mapToNewArray(mapper, Object.class, input);
    }

    @ThrowAwayValue
    public static <I, O, A extends I> Object[] mapToNewObjectArrayV(Mapper<I, O> mapper, A ... input) {
        return CollectionUtilities.mapToNewArray(mapper, Object.class, input);
    }

    @ThrowAwayValue
    public static <E> Collection<E> filterToNewCollection(Predicate<? super E> filter, Iterable<E> input) {
        if (input == null) {
            return null;
        }
        AbstractCollection newlist = input instanceof Set ? new HashSet() : new ArrayList(input instanceof Collection ? ((Collection)input).size() : 0);
        for (E e : input) {
            if (!filter.test(e)) continue;
            newlist.add(e);
        }
        if (newlist instanceof ArrayList) {
            ((ArrayList)newlist).trimToSize();
        }
        return newlist;
    }

    @ThrowAwayValue
    public static <E> List<E> filterToNewList(Predicate<? super E> filter, Iterable<E> input) {
        return (List)CollectionUtilities.filterToNewCollection(filter, input);
    }

    @ThrowAwayValue
    public static <E> Set<E> filterToNewSet(Predicate<? super E> filter, Set<E> input) {
        return (Set)CollectionUtilities.filterToNewCollection(filter, input);
    }

    @ThrowAwayValue
    public static <E, O> O[] filterToNewArray(Predicate<? super E> filter, Class<O> outputComponentType, E[] input) {
        if (input == null) {
            return null;
        }
        Object[] newarray = (Object[])Array.newInstance(outputComponentType, input.length);
        int i2 = 0;
        E[] EArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (filter.test(e)) {
                newarray[i2++] = e;
            }
            ++n2;
        }
        int newsize = i2;
        Object[] trimmedNewArray = null;
        trimmedNewArray = (Object[])Array.newInstance(outputComponentType, newsize);
        System.arraycopy(newarray, 0, trimmedNewArray, 0, trimmedNewArray.length);
        return trimmedNewArray;
    }

    @ThrowAwayValue
    public static <E> E[] filterToNewArray(Predicate<? super E> filter, E[] input) {
        if (input == null) {
            return null;
        }
        return CollectionUtilities.filterToNewArray(filter, input.getClass().getComponentType(), input);
    }

    @ThrowAwayValue
    public static <E> E[] filterToNewArrayV(Predicate<? super E> filter, E ... input) {
        return CollectionUtilities.filterToNewArray(filter, input);
    }

    @ThrowAwayValue
    public static <I, O> Collection<O> filterToNewCollectionSubtyped(Class<O> c, Iterable<I> input) {
        return CollectionUtilities.filterToNewCollection(e -> c.isInstance(e), input);
    }

    @ThrowAwayValue
    public static <I, O> List<O> filterToNewListSubtyped(Class<O> c, Iterable<I> input) {
        return CollectionUtilities.filterToNewList(e -> c.isInstance(e), input);
    }

    @ThrowAwayValue
    public static <I, O> Set<O> filterToNewSetSubtyped(Class<O> c, Set<I> input) {
        return CollectionUtilities.filterToNewSet(e -> c.isInstance(e), input);
    }

    @ReadonlyValue
    public static <I, O> Collection<O> mapToCollection(Mapper<I, O> mapper, Iterable<? extends I> input) {
        if (input == null) {
            return null;
        }
        if (input instanceof Set) {
            return CollectionUtilities.mapToSet(mapper, (Set)input);
        }
        if (input instanceof List) {
            return CollectionUtilities.mapToList(mapper, (List)input);
        }
        return CollectionUtilities.mapToList(mapper, PolymorphicCollectionUtilities.anyToList(input));
    }

    @ReadonlyValue
    public static <I, O> List<O> mapToList(Mapper<I, O> mapper, Iterable<? extends I> input) {
        return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(CollectionUtilities.mapped(mapper, input));
    }

    @ReadonlyValue
    public static <I, O> List<O> mapToList(Mapper<I, O> mapper, Enumeration<? extends I> input) {
        return PolymorphicCollectionUtilities.anyToNewMutableVariablelengthList(CollectionUtilities.map(mapper, CollectionUtilities.enumerationToIterator(input)));
    }

    @ReadonlyValue
    public static <I, O> List<O> mapToList(Mapper<I, O> mapper, I[] input) {
        return CollectionUtilities.mapToList(mapper, CollectionUtilities.asList(input));
    }

    @ReadonlyValue
    public static <I, O> Set<O> mapToSet(Mapper<I, O> mapper, Iterable<? extends I> input) {
        return PolymorphicCollectionUtilities.anyToNewMutableSet(CollectionUtilities.mapped(mapper, input));
    }

    @ReadonlyValue
    public static <I, O> Set<O> mapToSet(Mapper<I, O> mapper, I[] input) {
        return CollectionUtilities.mapToSet(mapper, CollectionUtilities.asList(input));
    }

    @ReadonlyValue
    public static <I, O, A extends I> O[] mapToArray(Mapper<I, O> mapper, Class<? super O> outputComponentType, A[] input) {
        return (Object[])PolymorphicCollectionUtilities.anyToNewArray(CollectionUtilities.mapped(mapper, Arrays.asList(input)), outputComponentType);
    }

    @ReadonlyValue
    public static <I, O, A extends I> Object[] mapToObjectArray(Mapper<I, O> mapper, A[] input) {
        return CollectionUtilities.mapToArray(mapper, Object.class, input);
    }

    @ReadonlyValue
    public static <I, O, A extends I> Object[] mapToObjectArrayV(Mapper<I, O> mapper, A ... input) {
        return CollectionUtilities.mapToArray(mapper, Object.class, input);
    }

    @ReadonlyValue
    public static <I, O> Set<O> mapToSetThrowingOnDuplicates(Mapper<I, O> mapper, Iterable<? extends I> input) {
        return PolymorphicCollectionUtilities.anyToNewMutableSet(CollectionUtilities.mapped(mapper, input), true);
    }

    @ReadonlyValue
    public static <I, O> Set<O> mapToSetThrowingOnDuplicates(Mapper<I, O> mapper, I[] input) {
        return CollectionUtilities.mapToSetThrowingOnDuplicates(mapper, CollectionUtilities.asList(input));
    }

    @ReadonlyValue
    public static <I, O> List<O> mapToListConcatenating(Mapper<I, List<O>> mapper, Iterable<? extends I> input) {
        ArrayList<O> output = new ArrayList<O>();
        for (I i : input) {
            List<O> l;
            try {
                l = mapper.f(i);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            output.addAll(l);
        }
        return output;
    }

    @ReadonlyValue
    protected static <E> Collection<E> filterToCollection(Predicate<? super E> filter, Iterable<E> input, boolean setOutput) {
        if (input == null) {
            return null;
        }
        Set newlist = null;
        for (E e : input) {
            if (!filter.test(e)) continue;
            if (newlist == null) {
                newlist = setOutput ? new HashSet() : new ArrayList(input instanceof Collection ? ((Collection)input).size() : 0);
            }
            newlist.add(e);
        }
        return newlist == null ? (setOutput ? Collections.emptySet() : Collections.emptyList()) : newlist;
    }

    @ThrowAwayValue
    protected static <E> Collection<E> filterToMutableCollection(Predicate<? super E> filter, Iterable<E> input, boolean setOutput) {
        if (input == null) {
            return null;
        }
        AbstractCollection newlist = setOutput ? new HashSet() : new ArrayList(input instanceof Collection ? ((Collection)input).size() : 0);
        for (E e : input) {
            if (!filter.test(e)) continue;
            newlist.add(e);
        }
        return newlist;
    }

    @ReadonlyValue
    public static <E> Collection<E> filterToCollection(Predicate<? super E> filter, Iterable<E> input) {
        return CollectionUtilities.filterToCollection(filter, input, false);
    }

    @ReadonlyValue
    public static <E> List<E> filterToList(Predicate<? super E> filter, Iterable<E> input) {
        return (List)CollectionUtilities.filterToCollection(filter, input, false);
    }

    @ReadonlyValue
    public static <E> Set<E> filterToSet(Predicate<? super E> filter, Iterable<E> input) {
        return (Set)CollectionUtilities.filterToCollection(filter, input, true);
    }

    @ReadonlyValue
    public static <E> List<E> filterToList(Predicate<? super E> filter, E[] input) {
        return CollectionUtilities.filterToList(filter, CollectionUtilities.asList(input));
    }

    @ReadonlyValue
    public static <E> Set<E> filterToSet(Predicate<? super E> filter, E[] input) {
        return CollectionUtilities.filterToSet(filter, CollectionUtilities.asList(input));
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> filterToListOPC(Predicate<? super E> filter, List<E> input) {
        if (CollectionUtilities.forAll(filter, input)) {
            return input;
        }
        return (List)CollectionUtilities.filterToCollection(filter, input, false);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> Set<E> filterToSetOPC(Predicate<? super E> filter, Set<E> input) {
        if (CollectionUtilities.forAll(filter, input)) {
            return input;
        }
        return (Set)CollectionUtilities.filterToCollection(filter, input, true);
    }

    @ThrowAwayValue
    public static <E> List<E> filterToMutableList(Predicate<? super E> filter, List<E> input) {
        return (List)CollectionUtilities.filterToMutableCollection(filter, input, false);
    }

    @ThrowAwayValue
    public static <E> Set<E> filterToMutableSet(Predicate<? super E> filter, Set<E> input) {
        return (Set)CollectionUtilities.filterToMutableCollection(filter, input, true);
    }

    @ReadonlyValue
    public static <E, O> O[] filterToArray(Predicate<? super E> filter, Class<O> outputComponentType, Collection<E> input) {
        if (input == null) {
            return null;
        }
        Object[] newarray = (Object[])Array.newInstance(outputComponentType, input.size());
        int i2 = 0;
        for (E e : input) {
            if (!filter.test(e)) continue;
            newarray[i2++] = e;
        }
        int newsize = i2;
        Object[] trimmedNewArray = null;
        trimmedNewArray = (Object[])Array.newInstance(outputComponentType, newsize);
        System.arraycopy(newarray, 0, trimmedNewArray, 0, trimmedNewArray.length);
        return trimmedNewArray;
    }

    @ReadonlyValue
    public static <E, O> O[] filterToArray(Predicate<? super E> filter, Class<O> outputComponentType, E[] input) {
        if (input == null) {
            return null;
        }
        Object[] newarray = (Object[])Array.newInstance(outputComponentType, input.length);
        int i2 = 0;
        E[] EArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (filter.test(e)) {
                newarray[i2++] = e;
            }
            ++n2;
        }
        int newsize = i2;
        Object[] trimmedNewArray = null;
        trimmedNewArray = (Object[])Array.newInstance(outputComponentType, newsize);
        System.arraycopy(newarray, 0, trimmedNewArray, 0, trimmedNewArray.length);
        return trimmedNewArray;
    }

    @ReadonlyValue
    public static <E> E[] filterToArray(Predicate<? super E> filter, E[] input) {
        if (input == null) {
            return null;
        }
        return CollectionUtilities.filterToArray(filter, input.getClass().getComponentType(), input);
    }

    @ReadonlyValue
    public static <E> E[] filterToArrayV(Predicate<? super E> filter, E ... input) {
        return CollectionUtilities.filterToArray(filter, input);
    }

    @ReadonlyValue
    public static <I, O> Collection<O> filterToCollectionSubtyped(Class<O> c, Iterable<I> input) {
        return CollectionUtilities.filterToCollection(e -> c.isInstance(e), input);
    }

    @ReadonlyValue
    public static <I, O> List<O> filterToListSubtyped(Class<O> c, Iterable<I> input) {
        return CollectionUtilities.filterToList((? super E e) -> c.isInstance(e), input);
    }

    @ReadonlyValue
    public static <I, O> Set<O> filterToSetSubtyped(Class<O> c, Iterable<I> input) {
        return CollectionUtilities.filterToSet((? super E e) -> c.isInstance(e), input);
    }

    @ReadonlyValue
    public static <E> List<E> filterMiddleToList(Predicate<? super E> filter, List<E> input) {
        Interval i = CollectionUtilities.filterMiddleToInterval(filter, input);
        return input.subList(i.getOffset(), i.getOffset() + i.getLength());
    }

    @ReadonlyValue
    public static <E> Interval filterMiddleToInterval(Predicate<? super E> filter, List<E> input) {
        int n = input.size();
        int i = 0;
        while (i < n) {
            if (filter.test(input.get(i))) break;
            ++i;
        }
        int start = i;
        if (start == n) {
            return new Interval(0, n);
        }
        int i2 = n - 1;
        while (i2 >= 0) {
            if (filter.test(input.get(i2))) break;
            --i2;
        }
        int end = i2 + 1;
        return new Interval(start, end - start);
    }

    public static <E> boolean mapListInPlace(Mapper<E, E> mapper, List<E> list) {
        boolean didAnything = false;
        if (CollectionUtilities.isRandomAccessFast(list)) {
            int n = list.size();
            int i = n - 1;
            while (i >= 0) {
                E in = list.get(i);
                try {
                    E out = mapper.f(in);
                    if (out != in) {
                        list.set(i, out);
                        didAnything = true;
                    }
                }
                catch (FilterAwayReturnPath exc) {
                    list.remove(i);
                    didAnything = true;
                }
                --i;
            }
        } else {
            ListIterator<E> li = list.listIterator(list.size());
            while (li.hasPrevious()) {
                E in = li.previous();
                try {
                    E out = mapper.f(in);
                    if (out == in) continue;
                    li.set(out);
                    didAnything = true;
                }
                catch (FilterAwayReturnPath exc) {
                    li.remove();
                    didAnything = true;
                }
            }
        }
        return didAnything;
    }

    public static <E> boolean filterInPlace(Predicate<E> predicate, Iterable<E> iterable) {
        if (iterable instanceof List) {
            return CollectionUtilities.mapListInPlace(e -> {
                if (predicate.test(e)) {
                    return e;
                }
                throw FilterAwayReturnPath.I;
            }, (List)iterable);
        }
        Iterator<E> i = iterable.iterator();
        Object e2 = null;
        while (i.hasNext()) {
            e2 = i.next();
            if (predicate.test(e2)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public static <E> boolean removeMatching(Predicate<E> predicate, Iterable<E> iterable) {
        return CollectionUtilities.filterInPlace(predicate.negate(), iterable);
    }

    public static <K, V> boolean filterDictInPlace(MapEntryPredicate<K, V> predicate, @WritableValue Map<K, V> dict) {
        boolean didAnything = false;
        Object[] objectArray = dict.keySet().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object k = objectArray[n2];
            Object key = k;
            if (!predicate.test(key, dict.get(key))) {
                dict.remove(key);
                didAnything = true;
            }
            ++n2;
        }
        return didAnything;
    }

    public static <E> void doOn(FunctionInterfaces.UnaryProcedure<? super E> procedure, Iterator<E> input) {
        while (input.hasNext()) {
            procedure.f(input.next());
        }
    }

    public static <E> void doOn(FunctionInterfaces.UnaryProcedure<? super E> procedure, SimpleIterator<E> input) {
        while (true) {
            E e;
            try {
                e = input.nextrp();
            }
            catch (StopIterationReturnPath exc) {
                break;
            }
            procedure.f(e);
        }
    }

    public static <E> void doOn(FunctionInterfaces.UnaryProcedure<? super E> procedure, SimpleIterator.SimpleIterable<E> input) {
        CollectionUtilities.doOn(procedure, input.simpleIterator());
    }

    public static <E> void doOn(FunctionInterfaces.UnaryProcedure<? super E> procedure, Iterable<E> input) {
        for (E e : input) {
            procedure.f(e);
        }
    }

    public static <E> void doOn(FunctionInterfaces.UnaryProcedure<? super E> procedure, E[] input) {
        E[] EArray = input;
        int n = input.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            procedure.f(e);
            ++n2;
        }
    }

    public static <E> void doOnV(FunctionInterfaces.UnaryProcedure<? super E> procedure, E ... input) {
        CollectionUtilities.doOn(procedure, input);
    }

    public static <E> int doOnAndRemoveSome(Predicate<? super E> procedure, Iterable<E> input) {
        Iterator<E> i = input.iterator();
        int numberRemoved = 0;
        while (i.hasNext()) {
            boolean remove = procedure.test(i.next());
            if (!remove) continue;
            i.remove();
            ++numberRemoved;
        }
        return numberRemoved;
    }

    public static <E> boolean any(Predicate<E> predicate, @CollectionValue E[] list) {
        E[] EArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (predicate.test(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <E> boolean all(Predicate<E> predicate, @CollectionValue E[] list) {
        E[] EArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            E e = EArray[n2];
            if (!predicate.test(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <E> boolean any(Predicate<E> predicate, @CollectionValue Iterable<E> list) {
        for (E e : list) {
            if (!predicate.test(e)) continue;
            return true;
        }
        return false;
    }

    public static <E> boolean all(Predicate<E> predicate, @CollectionValue Iterable<E> list) {
        for (E e : list) {
            if (predicate.test(e)) continue;
            return false;
        }
        return true;
    }

    public static boolean any(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, @CollectionValue boolean[] list) {
        boolean[] blArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            boolean e = blArray[n2];
            if (predicate.f(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean all(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, @CollectionValue boolean[] list) {
        boolean[] blArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            boolean e = blArray[n2];
            if (!predicate.f(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean any(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, @CollectionValue byte[] list) {
        byte[] byArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            byte e = byArray[n2];
            if (predicate.f(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean all(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, @CollectionValue byte[] list) {
        byte[] byArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            byte e = byArray[n2];
            if (!predicate.f(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean any(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, @CollectionValue char[] list) {
        char[] cArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            char e = cArray[n2];
            if (predicate.f(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean all(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, @CollectionValue char[] list) {
        char[] cArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            char e = cArray[n2];
            if (!predicate.f(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean any(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, @CollectionValue short[] list) {
        short[] sArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            short e = sArray[n2];
            if (predicate.f(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean all(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, @CollectionValue short[] list) {
        short[] sArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            short e = sArray[n2];
            if (!predicate.f(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean any(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, @CollectionValue float[] list) {
        float[] fArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            float e = fArray[n2];
            if (predicate.f(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean all(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, @CollectionValue float[] list) {
        float[] fArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            float e = fArray[n2];
            if (!predicate.f(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean any(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, @CollectionValue int[] list) {
        int[] nArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (predicate.f(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean all(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, @CollectionValue int[] list) {
        int[] nArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (!predicate.f(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean any(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, @CollectionValue double[] list) {
        double[] dArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            double e = dArray[n2];
            if (predicate.f(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean all(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, @CollectionValue double[] list) {
        double[] dArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            double e = dArray[n2];
            if (!predicate.f(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean any(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, @CollectionValue long[] list) {
        long[] lArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            long e = lArray[n2];
            if (predicate.f(e)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean all(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, @CollectionValue long[] list) {
        long[] lArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            long e = lArray[n2];
            if (!predicate.f(e)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <E> void check(FunctionInterfaces.UnaryFunction<E, ? extends RuntimeException> thrower, E[] list) {
        E[] EArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            RuntimeException exc = thrower.f(element);
            if (exc != null) {
                throw exc;
            }
            ++n2;
        }
    }

    public static <E> void check(FunctionInterfaces.UnaryFunction<E, ? extends RuntimeException> thrower, Iterable<E> list) {
        for (E element : list) {
            RuntimeException exc = thrower.f(element);
            if (exc == null) continue;
            throw exc;
        }
    }

    public static <I, O> SimpleIterator<O> compositionPermuter(final SimpleIterator<I> inputs, final FunctionInterfaces.UnaryFunction<I, SimpleIterator<O>> secondPermuter) {
        return new SimpleIterator<O>(){
            SimpleIterator<O> currentSecondPermuter = null;

            @Override
            public O nextrp() throws StopIterationReturnPath {
                if (this.currentSecondPermuter == null) {
                    Object nextInput = inputs.nextrp();
                    this.currentSecondPermuter = (SimpleIterator)secondPermuter.f(nextInput);
                    Objects.requireNonNull(this.currentSecondPermuter);
                }
                return this.currentSecondPermuter.nextrp();
            }
        };
    }

    public static <E> Map<E, Integer> getCounts(Collection<E> collection) {
        HashMap<E, Integer> counts = new HashMap<E, Integer>();
        for (E e : collection) {
            counts.put(e, Collections.frequency(collection, e));
        }
        return counts;
    }

    public static void putSomeV(Map source, Map dest, Object ... keys) {
        Object[] objectArray = keys;
        int n = keys.length;
        int n2 = 0;
        while (n2 < n) {
            Object key = objectArray[n2];
            Object v = source.get(key);
            if (v != null || source.containsKey(key)) {
                dest.put(key, v);
            }
            ++n2;
        }
    }

    public static void putAllIfNotNull(Map dest, Map source) {
        if (source != null && dest != null) {
            dest.putAll(source);
        }
    }

    public static int readInto(Iterator source, Object[] dest, int offset, int maxLength) {
        int m = offset + maxLength;
        int i = offset;
        while (i < m) {
            if (!source.hasNext()) {
                if (i == offset) {
                    return -1;
                }
                return i - offset;
            }
            dest[i] = source.next();
            ++i;
        }
        return maxLength;
    }

    public static boolean eqv(Object a, Object b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return a == null;
        }
        if (a instanceof Equivalenceable) {
            try {
                return ((Equivalenceable)a).equivalent(b);
            }
            catch (NotSupportedReturnPath notSupportedReturnPath) {
                // empty catch block
            }
        }
        if (b instanceof Equivalenceable) {
            try {
                return ((Equivalenceable)b).equivalent(a);
            }
            catch (NotSupportedReturnPath notSupportedReturnPath) {
                // empty catch block
            }
        }
        if (Primitives.isTrueAndNotNull(ObjectUtilities.isThreadUnsafelyImmutable(a)) && Primitives.isTrueAndNotNull(ObjectUtilities.isThreadUnsafelyImmutable(b))) {
            return BasicObjectUtilities.eq(a, b);
        }
        if (a instanceof Enum || b instanceof Enum) {
            return a == b;
        }
        if (a instanceof List && b instanceof List) {
            return CollectionUtilities.defaultListsEquivalent((List)a, (List)b, (aa, bb) -> CollectionUtilities.eqv(aa, bb));
        }
        if (a instanceof Set && b instanceof Set) {
            return CollectionUtilities.defaultSetsEquivalent((Set)a, (Set)b, (aa, bb) -> CollectionUtilities.eqv(aa, bb));
        }
        if (a instanceof Collection && b instanceof Collection) {
            return CollectionUtilities.defaultMultiSetsEquivalent_SmallNaive((Collection)a, (Collection)b, (aa, bb) -> CollectionUtilities.eqv(aa, bb));
        }
        if (a instanceof Map && b instanceof Map) {
            return CollectionUtilities.defaultMapsEquivalent((Map)a, (Map)b, (aa, bb) -> CollectionUtilities.eqv(aa, bb));
        }
        throw new UnsupportedOperationException("eqv(a " + a.getClass().getName() + ", a " + b.getClass().getName() + ")");
    }

    public static boolean eqvMany(Iterable<Object> xs) {
        return CollectionUtilities.transitiveReduce(xs, (I a, I b) -> CollectionUtilities.eqv(a, b));
    }

    public static boolean eqvManyV(Object ... xs) {
        return CollectionUtilities.transitiveReduceV((a, b) -> CollectionUtilities.eqv(a, b), xs);
    }

    public static <E> boolean eqvSets(Set<? extends E> a, Set<? extends E> b) {
        return CollectionUtilities.eqv(a, b);
    }

    public static <E> boolean eqvMultiSets(Collection<? extends E> a, Collection<? extends E> b) {
        return CollectionUtilities.eqvMultiSets(a, b, DefaultEqualityComparator.I);
    }

    public static <E> boolean eqvLists(List<? extends E> a, List<? extends E> b) {
        return CollectionUtilities.eqv(a, b);
    }

    public static <K, V> boolean eqvMaps(Map<? extends K, ? extends V> a, Map<? extends K, ? extends V> b) {
        return CollectionUtilities.eqv(a, b);
    }

    public static <E> boolean eqvMultiSets(Collection<? extends E> a, Collection<? extends E> b, EqualityComparator<E> equalityComparator) {
        return CollectionUtilities.defaultMultiSetsEquivalent_SmallNaive(a, b, equalityComparator);
    }

    public static <E> boolean eqvLists(List<? extends E> a, List<? extends E> b, EqualityComparator<E> equalityComparator) {
        return CollectionUtilities.defaultListsEquivalent(a, b, equalityComparator);
    }

    public static <K, V> boolean eqvMaps(Map<? extends K, ? extends V> a, Map<? extends K, ? extends V> b, EqualityComparator<V> valuesEqualityComparator) {
        return CollectionUtilities.defaultMapsEquivalent(a, b, valuesEqualityComparator);
    }

    public static int hashCodeOfContents(Object a) {
        if (a == null) {
            return 0;
        }
        if (a instanceof Equivalenceable) {
            return ((Equivalenceable)a).hashCodeOfContents();
        }
        if (Primitives.isTrueAndNotNull(ObjectUtilities.isThreadUnsafelyImmutable(a))) {
            return a.hashCode();
        }
        try {
            return CollectionUtilities.hashCodeOfContentsGrandfathering(a);
        }
        catch (NotSupportedReturnPath exc) {
            throw new UnsupportedOperationException();
        }
    }

    public static int hashCodeOfContentsGrandfathering(Object a) throws NotSupportedReturnPath {
        if (a instanceof List) {
            return CollectionUtilities.defaultListHashCode((List)a);
        }
        if (a instanceof Set) {
            return CollectionUtilities.defaultSetHashCode((Set)a);
        }
        if (a instanceof Collection) {
            return CollectionUtilities.defaultMultiSetHashCode((Set)a);
        }
        if (a instanceof Map) {
            return CollectionUtilities.defaultMapHashCode((Map)a);
        }
        throw NotSupportedReturnPath.I;
    }

    public static <E> boolean acyclicDeepEqvSets(Set<? extends E> a, Set<? extends E> b) {
        throw new NotYetImplementedException();
    }

    public static <E> boolean acyclicDeepEqvCollections(Collection<? extends E> a, Collection<? extends E> b) {
        return CollectionUtilities.eqvMultiSets(a, b, PolymorphicCollectionUtilities.acyclicDeepEqv);
    }

    public static <E> boolean acyclicDeepEqvLists(List<? extends E> a, List<? extends E> b) {
        return CollectionUtilities.eqvLists(a, b, PolymorphicCollectionUtilities.acyclicDeepEqv);
    }

    public static <K, V> boolean acyclicDeepEqvMaps(Map<? extends K, ? extends V> a, Map<? extends K, ? extends V> b) {
        return CollectionUtilities.eqvMaps(a, b, PolymorphicCollectionUtilities.acyclicDeepEqv);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <K, V> Map<V, K> inverseMapOPC(@ReadonlyValue Map<K, V> map) throws NonForwardInjectiveMapException {
        return CollectionUtilities.inverseMapOP(map);
    }

    @ThrowAwayValue
    public static <K, V> Map<V, K> inverseMapOP(@ReadonlyValue Map<K, V> map) throws NonForwardInjectiveMapException {
        return CollectionUtilities.inverseMapOP(map.keySet(), map::get);
    }

    public static <K, V> Map<V, K> inverseMapOP(Set<K> keys, Mapper<K, V> mapper) throws NonForwardInjectiveMapException {
        HashMap<V, K> inverse = new HashMap<V, K>();
        for (K key : keys) {
            V value;
            try {
                value = mapper.f(key);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            if (inverse.containsKey(value)) {
                throw new NonForwardInjectiveMapException("Duplicates of value-in-input / key-in-output " + StringUtilities.repr(value));
            }
            inverse.put(value, key);
        }
        return inverse;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <V> Map<V, Integer> inverseListmapOPC(@ReadonlyValue List<V> map) throws NonForwardInjectiveMapException {
        return CollectionUtilities.inverseListmapOP(map);
    }

    @ThrowAwayValue
    public static <V> Map<V, Integer> inverseListmapOP(@ReadonlyValue List<V> map) throws NonForwardInjectiveMapException {
        return CollectionUtilities.inverseListmapOP(map.size(), map::get);
    }

    public static <V> Map<V, Integer> inverseListmapOP(int size, Mapper<Integer, V> mapper) throws NonForwardInjectiveMapException {
        HashMap<V, Integer> inverse = new HashMap<V, Integer>();
        int key = 0;
        while (key < size) {
            block4: {
                V value;
                try {
                    value = mapper.f(key);
                }
                catch (FilterAwayReturnPath exc) {
                    break block4;
                }
                if (inverse.containsKey(value)) {
                    throw new NonForwardInjectiveMapException("Duplicates of value-in-input / key-in-output " + StringUtilities.repr(value));
                }
                inverse.put(value, key);
            }
            ++key;
        }
        return inverse;
    }

    @ThrowAwayValue
    public static <V, K> Map<V, Set<K>> inverseMapGeneralOP(Map<K, V> inputMap) {
        return CollectionUtilities.inverseMapGeneralOP(inputMap.keySet(), inputMap::get);
    }

    @ThrowAwayValue
    public static <V, K> Map<V, Set<K>> inverseMapGeneralOP(Iterable<K> keys, Mapper<K, V> mapper) {
        HashMap inverse = new HashMap();
        for (K key : keys) {
            try {
                CollectionUtilities.getOrCreate(inverse, mapper.f(key), HashSet::new).add(key);
            }
            catch (FilterAwayReturnPath filterAwayReturnPath) {
                // empty catch block
            }
        }
        return inverse;
    }

    @ThrowAwayValue
    public static <V, K> Map<V, Set<K>> inverseGeneralMapGeneralOP(Map<K, Set<V>> inputMap) {
        return CollectionUtilities.inverseGeneralMapGeneralOP(inputMap.keySet(), inputMap::get);
    }

    @ThrowAwayValue
    public static <V, K> Map<V, Set<K>> inverseGeneralMapGeneralOP(Iterable<K> keys, Mapper<K, Set<V>> mapper) {
        HashMap inverse = new HashMap();
        for (K key : keys) {
            Set<V> values;
            try {
                values = mapper.f(key);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            for (V value : values) {
                CollectionUtilities.getOrCreate(inverse, value, HashSet::new).add(key);
            }
        }
        return inverse;
    }

    public static <E> boolean hasDuplicates(Iterable<E> input) {
        HashSet<E> seen = new HashSet<E>();
        for (E e : input) {
            if (seen.contains(e)) {
                return true;
            }
            seen.add(e);
        }
        return false;
    }

    public static <E> Set<E> findDuplicates(Iterable<E> input) {
        HashSet<E> seen = new HashSet<E>();
        HashSet<E> duplicates = new HashSet<E>();
        for (E e : input) {
            if (seen.contains(e)) {
                duplicates.add(e);
                continue;
            }
            seen.add(e);
        }
        return duplicates;
    }

    public static <E> Iterable<E> requireNoDuplicates(Iterable<E> input) throws DuplicatesException {
        Set<E> duplicates = CollectionUtilities.findDuplicates(input);
        if (!duplicates.isEmpty()) {
            throw new DuplicatesException("Duplicate elements!: {" + StringUtilities.reprListContentsSingleLine(duplicates) + "}    (the number of times each duplicate appears is not represented here)");
        }
        return input;
    }

    public static <E> void requireNoIntersection(Set<E> a, Set<E> b) throws AlreadyExistsException {
        Set<E> conflicts = CollectionUtilities.intersection(a, b);
        if (!conflicts.isEmpty()) {
            throw new AlreadyExistsException("Conflicts detected!: {" + StringUtilities.reprListContentsSingleLine(conflicts) + "}");
        }
    }

    @ThrowAwayValue
    public static <I, O> Map<O, Integer> getColumnHeadersToIndexesMap(SimpleTable<I> table, int headerRowIndex, Mapper<I, O> columnHeaderMapperAndFilter) throws NonForwardInjectiveMapException {
        return CollectionUtilities.getColumnHeadersToIndexesMap(table.rowToList(headerRowIndex), columnHeaderMapperAndFilter);
    }

    @ThrowAwayValue
    public static <I, O> Map<O, Integer> getColumnHeadersToIndexesMap(List<I> tableHeaders, Mapper<I, O> columnHeaderMapperAndFilter) throws NonForwardInjectiveMapException {
        HashMap<I, Integer> headersToIndexes = new HashMap<I, Integer>();
        int columnIndex = 0;
        for (I header : tableHeaders) {
            try {
                I mappedHeader;
                Object object = mappedHeader = columnHeaderMapperAndFilter == null ? header : columnHeaderMapperAndFilter.f(header);
                if (headersToIndexes.containsKey(mappedHeader)) {
                    throw new NonForwardInjectiveMapException("Conflict on header value: " + StringUtilities.repr(header) + "  (mapped to " + StringUtilities.repr(mappedHeader) + ")");
                }
                headersToIndexes.put(mappedHeader, columnIndex);
            }
            catch (FilterAwayReturnPath filterAwayReturnPath) {
                // empty catch block
            }
            ++columnIndex;
        }
        return headersToIndexes;
    }

    @ThrowAwayValue
    public static Map<String, Integer> getColumnHeadersToIndexesMapStringsDefaultLowercasing(List<String> tableHeaders) throws NonForwardInjectiveMapException {
        return CollectionUtilities.getColumnHeadersToIndexesMap(tableHeaders, h -> {
            if ((h = h.trim()).isEmpty()) {
                throw FilterAwayReturnPath.I;
            }
            return h.toLowerCase();
        });
    }

    @ThrowAwayValue
    public static Map<String, Integer> getColumnHeadersToIndexesMapStringsDefaultLowercasingValidatingExactCaseInsensitively(List<String> tableHeaders, String ... expectedHeaders) throws NonForwardInjectiveMapException {
        return CollectionUtilities.getColumnHeadersToIndexesMapStringsDefaultLowercasingValidatingExactCaseInsensitively(tableHeaders, PolymorphicCollectionUtilities.anyToSet(expectedHeaders));
    }

    @ThrowAwayValue
    public static Map<String, Integer> getColumnHeadersToIndexesMapStringsDefaultLowercasingValidatingExactCaseInsensitively(List<String> tableHeaders, Set<String> expectedHeaders) throws NonForwardInjectiveMapException {
        Set<String> actualHeadersLowercased;
        Map<String, Integer> h = CollectionUtilities.getColumnHeadersToIndexesMapStringsDefaultLowercasing(tableHeaders);
        Set<String> expectedHeadersLowercased = CollectionUtilities.mapToNewSet(String::toLowerCase, expectedHeaders);
        if (!expectedHeadersLowercased.equals(actualHeadersLowercased = h.keySet())) {
            throw new GenericDataStructuresFormatException("Headers didn't match up--even case insensitively!!: (Actual=" + StringUtilities.reprSingleLine(actualHeadersLowercased) + ", Expected=" + StringUtilities.reprSingleLine(expectedHeadersLowercased) + ")");
        }
        return h;
    }

    public static <K, V> MapFunctionalIterable<K, V> asFunctionalIterable(Map<K, V> map) {
        return iteree -> {
            for (Map.Entry entry : map.entrySet()) {
                ContinueSignal r = iteree.observe(entry.getKey(), entry.getValue());
                if (r == null) {
                    GlobalCodeMetastuffContext.logBug();
                    r = ContinueSignal.Continue;
                }
                if (r != ContinueSignal.Stop) continue;
                return SuccessfulIterationStopType.StoppedPrematurely;
            }
            return SuccessfulIterationStopType.CompletedNaturally;
        };
    }

    public static <E> CollectionFunctionalIterable<E> asFunctionalIterable(Iterable<E> collection) {
        return iteree -> {
            for (Object element : collection) {
                ContinueSignal r = iteree.observe(element);
                if (r == null) {
                    GlobalCodeMetastuffContext.logBug();
                    r = ContinueSignal.Continue;
                }
                if (r != ContinueSignal.Stop) continue;
                return SuccessfulIterationStopType.StoppedPrematurely;
            }
            return SuccessfulIterationStopType.CompletedNaturally;
        };
    }

    @LiveValue
    public static Set<Integer> bitSetAsIndexSetInOrder(final @LiveValue BitSet bitSet) {
        return new AbstractSet<Integer>(){

            @Override
            public boolean isEmpty() {
                return bitSet.isEmpty();
            }

            @Override
            public int size() {
                return bitSet.cardinality();
            }

            @Override
            public Iterator<Integer> iterator() {
                return CollectionUtilities.iteratorOverOneBitsInBitSetInOrder(bitSet);
            }

            @Override
            public boolean contains(Object o) {
                if (MathUtilities.isInteger(o)) {
                    int index;
                    try {
                        index = MathUtilities.safeCastIntegerToS32(o);
                    }
                    catch (OverflowException exc) {
                        return false;
                    }
                    return bitSet.get(index);
                }
                return false;
            }

            @Override
            public boolean remove(Object o) {
                if (MathUtilities.isInteger(o)) {
                    int index;
                    try {
                        index = MathUtilities.safeCastIntegerToS32(o);
                    }
                    catch (OverflowException exc) {
                        return false;
                    }
                    boolean wasSet = bitSet.get(index);
                    bitSet.clear(index);
                    return wasSet;
                }
                return false;
            }

            @Override
            public boolean add(Integer e) {
                int index = e;
                boolean wasSet = bitSet.get(index);
                bitSet.set(index);
                return !wasSet;
            }

            @Override
            public void clear() {
                bitSet.clear();
            }
        };
    }

    public static Iterable<Integer> bitSetAsBooleanIterableInOrder(BitSet bitSet) {
        return () -> CollectionUtilities.iteratorOverOneBitsInBitSetInOrder(bitSet);
    }

    public static Iterator<Integer> iteratorOverOneBitsInBitSetInOrder(final BitSet bitSet) {
        return new Iterator<Integer>(){
            int nextIndex;
            {
                this.nextIndex = bitSet2.nextSetBit(0);
            }

            @Override
            public Integer next() {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                int currentIndex = this.nextIndex;
                if (currentIndex == Integer.MAX_VALUE) {
                    throw new OverflowException();
                }
                this.nextIndex = bitSet.nextSetBit(currentIndex + 1);
                return currentIndex;
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex >= 0;
            }
        };
    }

    public static <E> boolean startsWithLists(@Nonnull List<E> longer, @Nonnull List<E> shorter) {
        block5: {
            int sn;
            int ln = longer.size();
            if (ln < (sn = shorter.size())) {
                return false;
            }
            if (ln == sn) {
                return longer.equals(shorter);
            }
            Iterator<E> il = longer.iterator();
            Iterator<E> is = shorter.iterator();
            boolean lHasElement = false;
            boolean sHasElement = false;
            Object lElement = null;
            Object sElement = null;
            do {
                lHasElement = il.hasNext();
                sHasElement = is.hasNext();
                if (!lHasElement && sHasElement) {
                    throw new ConcurrentModificationException("sizes were checked to be equal, but iterators produce unequal numbers of elements; either something is modifying the list un-thread-safely!, or it's just a really big bug in the list code XD''");
                }
                if (lHasElement && !sHasElement || !lHasElement || !sHasElement) break block5;
                assert (sHasElement);
            } while (BasicObjectUtilities.eq(lElement = il.next(), sElement = is.next()));
            return false;
        }
        return true;
    }

    public static <E> boolean endsWithLists(@Nonnull List<E> longer, @Nonnull List<E> shorter) {
        block5: {
            int sn;
            int ln = longer.size();
            if (ln < (sn = shorter.size())) {
                return false;
            }
            if (ln == sn) {
                return longer.equals(shorter);
            }
            ListIterator<E> il = longer.listIterator(ln);
            ListIterator<E> is = shorter.listIterator(sn);
            boolean lHasElement = false;
            boolean sHasElement = false;
            Object lElement = null;
            Object sElement = null;
            do {
                lHasElement = il.hasPrevious();
                sHasElement = is.hasPrevious();
                if (!lHasElement && sHasElement) {
                    throw new ConcurrentModificationException("sizes were checked to be equal, but iterators produce unequal numbers of elements; either something is modifying the list un-thread-safely!, or it's just a really big bug in the list code XD''");
                }
                if (lHasElement && !sHasElement || !lHasElement || !sHasElement) break block5;
                assert (sHasElement);
            } while (BasicObjectUtilities.eq(lElement = il.previous(), sElement = is.previous()));
            return false;
        }
        return true;
    }

    @ThrowAwayValue
    public static <K, V> Map<K, V> toMap(Collection<Map.Entry<K, V>> entries) throws NonReverseInjectiveMapException {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map.Entry<K, V> e : entries) {
            K k = e.getKey();
            if (map.containsKey(k)) {
                throw new NonReverseInjectiveMapException("Duplicate keys!: " + StringUtilities.repr(k));
            }
            map.put(k, e.getValue());
        }
        return map;
    }

    public static <K, V> List<Map.Entry<K, V>> newkvlist(Object ... keysAndValues) {
        if (keysAndValues.length % 2 != 0) {
            throw new IllegalArgumentException();
        }
        ArrayList<Map.Entry<K, V>> emap = new ArrayList<Map.Entry<K, V>>();
        int i = 0;
        while (i < keysAndValues.length) {
            emap.add(new AbstractMap.SimpleEntry<Object, Object>(keysAndValues[i], keysAndValues[i + 1]));
            i += 2;
        }
        return emap;
    }

    public static <K, V> Collection<Map.Entry<K, V>> newemap(Object ... keysAndValues) {
        return CollectionUtilities.newkvlist(keysAndValues);
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> expandListOfRowsToSmallestWidth(List<List<E>> rows, E filler) {
        int h = rows.size();
        if (h == 0) {
            return CollectionUtilities.newTable();
        }
        int largestRowSize = MathUtilities.greatestMap(List::size, rows);
        if (largestRowSize == 0) {
            return CollectionUtilities.newTable();
        }
        int w = largestRowSize;
        SimpleTable<E> table = CollectionUtilities.newTableNullfilled(w, h);
        int r = 0;
        while (r < h) {
            List<E> row = rows.get(r);
            int filled = SmallIntegerMathUtilities.least(w, row.size());
            int c = 0;
            while (c < filled) {
                table.setCellContents(c, r, row.get(c));
                ++c;
            }
            int fillered = w - filled;
            int c2 = 0;
            while (c2 < fillered) {
                table.setCellContents(filled + c2, r, filler);
                ++c2;
            }
            ++r;
        }
        return table;
    }

    public static <E> void fillBySetting(List<? super E> list, E e) {
        CollectionUtilities.fillBySetting(list, 0, list.size(), e);
    }

    public static <E> void fillBySetting(List<? super E> list, int start, int count, E value) {
        if (count != 0) {
            CollectionUtilities.rangeCheckInterval(list.size(), start, start + count);
            if (list instanceof ListWithFill) {
                ((ListWithFill)list).fillBySetting(start, count, value);
            } else if (start == 0 && count == list.size()) {
                Collections.fill(list, value);
            } else {
                Collections.fill(list.subList(start, start + count), value);
            }
        }
    }

    public static <E> void fillByAdding(Collection<? super E> collection, E fill, int number) {
        if (collection instanceof Vector && fill == null) {
            ((Vector)collection).setSize(collection.size() + number);
        } else {
            int i = 0;
            while (i < number) {
                collection.add(fill);
                ++i;
            }
        }
    }

    public static <T> int compareWithListOrdering(List<T> ordering, T a, T b) {
        int ia = ordering.indexOf(a);
        int ib = ordering.indexOf(b);
        return ia == -1 ? (ib == -1 ? 0 : 1) : (ib == -1 ? -1 : SmallIntegerMathUtilities.cmp(ia, ib));
    }

    public static <T> int compareWithListOrderingChainable(int prev, List<T> ordering, T a, T b) {
        return prev != 0 ? prev : CollectionUtilities.compareWithListOrdering(ordering, a, b);
    }

    public static <E> SimpleTable<E> transposeOP(SimpleTable<E> input) {
        int wi = input.getNumberOfColumns();
        int hi = input.getNumberOfRows();
        SimpleTable<E> output = CollectionUtilities.newTableNullfilled(hi, wi);
        int yi = 0;
        while (yi < hi) {
            int xi = 0;
            while (xi < wi) {
                int xo = yi;
                int yo = xi;
                output.setCellContents(xo, yo, input.getCellContents(xi, yi));
                ++xi;
            }
            ++yi;
        }
        return output;
    }

    public static <E> SimpleTable<E> mergeColumnsOP(SimpleTable<E> input, FunctionInterfaces.BinaryFunction<E, E, E> merger) {
        int wi = input.getNumberOfColumns();
        int h = input.getNumberOfRows();
        if (wi == 0 || h == 0) {
            return CollectionUtilities.newTable();
        }
        SimpleTable<E> output = CollectionUtilities.newTableNullfilled(1, h);
        int y = 0;
        while (y < h) {
            E e = input.getCellContents(0, y);
            int xi = 1;
            while (xi < wi) {
                E ee = input.getCellContents(xi, y);
                e = merger.f(e, ee);
                ++xi;
            }
            output.setCellContents(0, y, e);
            ++y;
        }
        return output;
    }

    public static <E> SimpleTable<E> mergeRowsOP(SimpleTable<E> input, FunctionInterfaces.BinaryFunction<E, E, E> merger) {
        int w = input.getNumberOfColumns();
        int hi = input.getNumberOfRows();
        if (w == 0 || hi == 0) {
            return CollectionUtilities.newTable();
        }
        SimpleTable<E> output = CollectionUtilities.newTableNullfilled(w, 1);
        int x = 0;
        while (x < w) {
            E e = input.getCellContents(x, 0);
            int yi = 1;
            while (yi < hi) {
                E ee = input.getCellContents(x, yi);
                e = merger.f(e, ee);
                ++yi;
            }
            output.setCellContents(x, 0, e);
            ++x;
        }
        return output;
    }

    public static <E> SimpleTable<E> listifyOP(int numberOfRepeatedColumnsAtStart, int numberOfRepeatedRowsAtStart, SimpleTable<E> input) {
        int wd = input.getNumberOfColumns();
        int hd = input.getNumberOfRows();
        if (wd <= numberOfRepeatedColumnsAtStart) {
            throw new IllegalArgumentException();
        }
        wd -= numberOfRepeatedColumnsAtStart;
        if (hd <= numberOfRepeatedRowsAtStart) {
            throw new IllegalArgumentException();
        }
        SimpleTable<E> output = CollectionUtilities.newTableNullfilled(numberOfRepeatedColumnsAtStart + numberOfRepeatedRowsAtStart + 1, wd * (hd -= numberOfRepeatedRowsAtStart));
        int i = 0;
        int yd = 0;
        while (yd < hd) {
            int xd = 0;
            while (xd < wd) {
                int X = numberOfRepeatedColumnsAtStart + xd;
                int Y = numberOfRepeatedRowsAtStart + yd;
                int e = 0;
                while (e < numberOfRepeatedColumnsAtStart) {
                    output.setCellContents(e, i, input.getCellContents(e, Y));
                    ++e;
                }
                e = 0;
                while (e < numberOfRepeatedRowsAtStart) {
                    output.setCellContents(numberOfRepeatedColumnsAtStart + e, i, input.getCellContents(X, e));
                    ++e;
                }
                E datum = input.getCellContents(X, Y);
                output.setCellContents(numberOfRepeatedColumnsAtStart + numberOfRepeatedRowsAtStart, i, datum);
                ++i;
                ++xd;
            }
            ++yd;
        }
        return output;
    }

    public static <E> List<E> newfillList(int size, E value) {
        return CollectionUtilities.asList(ArrayUtilities.newfillArray(size, value, Object.class));
    }

    public static void rangeCheckMember(int collectionSize, int index) {
        if (collectionSize < 0) {
            throw new ImpossibleException("negative contextualizing collection length!!:  " + collectionSize);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index!!  " + index);
        }
        if (index >= collectionSize) {
            throw new IndexOutOfBoundsException("index " + index + " >= size " + collectionSize);
        }
    }

    public static void rangeCheckCursorPoint(int collectionSize, int index) {
        if (collectionSize < 0) {
            throw new ImpossibleException("negative contextualizing collection length!!:  " + collectionSize);
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("negative index!!  " + index);
        }
        if (index > collectionSize) {
            throw new IndexOutOfBoundsException("index " + index + " > size " + collectionSize);
        }
    }

    public static void rangeCheckInterval(int collectionSize, int start, int endExcl) {
        if (collectionSize < 0) {
            throw new ImpossibleException("negative contextualizing collection length!!:  " + collectionSize);
        }
        if (start < 0) {
            throw new IndexOutOfBoundsException("negative index!!  " + start);
        }
        if (endExcl < 0) {
            throw new IndexOutOfBoundsException("negative index!!  " + endExcl);
        }
        if (start > collectionSize) {
            throw new IndexOutOfBoundsException("index " + start + " > size " + collectionSize);
        }
        if (endExcl > collectionSize) {
            throw new IndexOutOfBoundsException("index bound " + endExcl + " > size " + collectionSize);
        }
        if (endExcl < start) {
            throw new IndexOutOfBoundsException("index bounds reversed!  (" + start + " to " + endExcl + ")");
        }
    }

    public static void rangeCheckIntervalByLength(int collectionSize, int fromIndex, int length) {
        if (collectionSize < 0) {
            throw new ImpossibleException("negative contextualizing collection length!!:  " + collectionSize);
        }
        if (length < 0) {
            throw new IndexOutOfBoundsException("negative length!!  " + length);
        }
        CollectionUtilities.rangeCheckInterval(collectionSize, fromIndex, fromIndex + length);
    }

    public static void rangeCheckFor_shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(List list, int start, int amount) {
        CollectionUtilities.rangeCheckCursorPoint(list.size(), start);
    }

    public static void rangeCheckFor_removeRange(List list, int start, int pastEnd) {
        CollectionUtilities.rangeCheckInterval(list.size(), start, pastEnd);
    }

    public static void rangeCheckMemberS64(long collectionSize, long index) {
        if (collectionSize < 0L) {
            throw new ImpossibleException("negative contextualizing collection length!!:  " + collectionSize);
        }
        if (index < 0L) {
            throw new IndexOutOfBoundsException("negative index!!  " + index);
        }
        if (index >= collectionSize) {
            throw new IndexOutOfBoundsException("index " + index + " >= size " + collectionSize);
        }
    }

    public static void rangeCheckCursorPointS64(long collectionSize, long index) {
        if (collectionSize < 0L) {
            throw new ImpossibleException("negative contextualizing collection length!!:  " + collectionSize);
        }
        if (index < 0L) {
            throw new IndexOutOfBoundsException("negative index!!  " + index);
        }
        if (index > collectionSize) {
            throw new IndexOutOfBoundsException("index " + index + " > size " + collectionSize);
        }
    }

    public static void rangeCheckIntervalS64(long collectionSize, long start, long endExcl) {
        if (collectionSize < 0L) {
            throw new ImpossibleException("negative contextualizing collection length!!:  " + collectionSize);
        }
        if (start < 0L) {
            throw new IndexOutOfBoundsException("negative index!!  " + start);
        }
        if (endExcl < 0L) {
            throw new IndexOutOfBoundsException("negative index!!  " + endExcl);
        }
        if (start > collectionSize) {
            throw new IndexOutOfBoundsException("index " + start + " > size " + collectionSize);
        }
        if (endExcl > collectionSize) {
            throw new IndexOutOfBoundsException("index bound " + endExcl + " > size " + collectionSize);
        }
        if (endExcl < start) {
            throw new IndexOutOfBoundsException("index bounds reversed!  (" + start + " to " + endExcl + ")");
        }
    }

    public static void rangeCheckIntervalByLengthS64(long collectionSize, long fromIndex, long length) {
        if (collectionSize < 0L) {
            throw new ImpossibleException("negative contextualizing collection length!!:  " + collectionSize);
        }
        if (length < 0L) {
            throw new IndexOutOfBoundsException("negative length!!  " + length);
        }
        CollectionUtilities.rangeCheckIntervalS64(collectionSize, fromIndex, fromIndex + length);
    }

    public static void shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(List list, int start, @Signed int amount) {
        CollectionUtilities.rangeCheckFor_shiftRegionStretchingFromIndexToEndByAmountChangingSizeGrandfathering(list, start, amount);
        if (amount == 0) {
            return;
        }
        if (list instanceof ShiftableList) {
            ((ShiftableList)((Object)list)).shiftRegionStretchingFromIndexToEndByAmountChangingSize(start, amount);
        } else if (list instanceof ListWithSetSize) {
            CollectionUtilities.defaultShiftRegionStretchingFromIndexToEndByAmountChangingSizeOfListWithSetSize((ListWithSetSize)list, start, amount);
        } else if (list instanceof ListWithRemoveRange && amount < 0) {
            ((ListWithRemoveRange)((Object)list)).removeRange(start + amount, start);
        } else {
            CollectionUtilities.defaultShiftRegionStretchingFromIndexToEndByAmountChangingSizeOfListWithoutSetSize(list, start, amount);
        }
    }

    public static void defaultShiftRegionStretchingFromIndexToEndByAmountChangingSizeOfListWithSetSize(ListWithSetSize list, int start, @Signed int amount) {
        int originalSize = list.size();
        if (amount > 0) {
            list.setSize(originalSize + amount);
            CollectionUtilities.listcopy(list, start, list, start + amount, originalSize - start);
        } else if (amount < 0) {
            CollectionUtilities.listcopy(list, start, list, start + amount, originalSize - start);
            list.setSize(originalSize + amount);
        }
    }

    public static void defaultShiftRegionStretchingFromIndexToEndByAmountChangingSizeOfListWithoutSetSize(List list, int start, @Signed int amount) {
        block6: {
            block5: {
                if (amount <= 0) break block5;
                int pastEndToAdd = start + amount;
                int i = 0;
                while (i < pastEndToAdd) {
                    list.add(null);
                    ++i;
                }
                break block6;
            }
            if (amount >= 0) break block6;
            int startOfIntervalToRemove = start + amount;
            int pastEndToRemove = start;
            if (CollectionUtilities.isRandomAccessFast(list)) {
                int i = pastEndToRemove - 1;
                while (i >= startOfIntervalToRemove) {
                    list.remove(i);
                    --i;
                }
            } else {
                ListIterator li = list.listIterator(pastEndToRemove);
                int length = -amount;
                int i = 0;
                while (i < length) {
                    li.previous();
                    li.remove();
                    ++i;
                }
            }
        }
    }

    public static void listcopy(List source, List dest) {
        int size = source.size();
        if (size != dest.size()) {
            throw new IllegalArgumentException("Lists to copy into each other aren't the same size!   (Source is " + source.size() + " elements and Dest is " + dest.size() + " elements!)");
        }
        CollectionUtilities.listcopy(source, 0, dest, 0, size);
    }

    public static void listcopy(List source, int sourceOffset, List dest, int destOffset, @Nonnegative int amount) {
        CollectionUtilities.rangeCheckIntervalByLength(source.size(), sourceOffset, amount);
        CollectionUtilities.rangeCheckIntervalByLength(dest.size(), destOffset, amount);
        while (source instanceof Sublist) {
            Sublist ss = (Sublist)source;
            sourceOffset += ss.getSublistStartingIndex();
            source = (List)Objects.requireNonNull(ss.getUnderlying());
        }
        while (dest instanceof Sublist) {
            Sublist ds = (Sublist)dest;
            destOffset += ds.getSublistStartingIndex();
            dest = (List)Objects.requireNonNull(ds.getUnderlying());
        }
        if (dest instanceof ListWithSetAll) {
            ((ListWithSetAll)((Object)dest)).setAll(destOffset, source, sourceOffset, amount);
        } else {
            CollectionUtilities.defaultListcopy(source, sourceOffset, dest, destOffset, amount);
        }
    }

    public static void defaultListcopy(List source, int sourceOffset, List dest, int destOffset, @Nonnegative int amount) {
        int sS = source.size();
        int dS = dest.size();
        if (dS < sS) {
            throw new IndexOutOfBoundsException();
        }
        if (sS == 0) {
            return;
        }
        if (destOffset < sourceOffset) {
            ListIterator s = source.listIterator(sourceOffset);
            ListIterator d = dest.listIterator(destOffset);
            int i = 0;
            while (i < amount) {
                d.next();
                d.set(s.next());
                ++i;
            }
        } else {
            ListIterator s = source.listIterator(sourceOffset + amount);
            ListIterator d = dest.listIterator(destOffset + amount);
            int i = 0;
            while (i < amount) {
                d.previous();
                d.set(s.previous());
                ++i;
            }
        }
    }

    public static <E> void defaultRandomAccessListcopy(List<? extends E> source, int sourceOffset, List<E> dest, int destOffset, int amount) {
        int sourceSize = source.size();
        int destSize = dest.size();
        if (destSize < sourceSize) {
            throw new IndexOutOfBoundsException();
        }
        if (sourceSize == 0) {
            return;
        }
        CollectionUtilities.rangeCheckIntervalByLength(sourceSize, sourceOffset, amount);
        CollectionUtilities.rangeCheckIntervalByLength(destSize, destOffset, amount);
        if (destOffset < sourceOffset) {
            int i = 0;
            while (i < amount) {
                dest.set(destOffset + i, source.get(sourceOffset + i));
                ++i;
            }
        } else {
            int i = amount - 1;
            while (i >= 0) {
                dest.set(destOffset + i, source.get(sourceOffset + i));
                --i;
            }
        }
    }

    public static int findNextNullOrListSize(List<?> l) {
        int i = l.indexOf(null);
        return i == -1 ? l.size() : i;
    }

    public static <E> int storeInNextNullOrAppendToList(List<E> l, E e) {
        int i = l.indexOf(null);
        if (i == -1) {
            int s = l.size();
            l.add(e);
            return s;
        }
        l.set(i, e);
        return i;
    }

    public static <E> List<E> immutableCopyList(List<E> list) {
        if (Primitives.isTrueAndNotNull(ObjectUtilities.isThreadUnsafelyImmutable(list))) {
            return list;
        }
        if (list instanceof PrimitiveCollections.BooleanList) {
            return PrimitiveCollections.ImmutableBooleanArrayList.newCopying(list);
        }
        if (list instanceof PrimitiveCollections.ByteList) {
            return PrimitiveCollections.ImmutableByteArrayList.newCopying(list);
        }
        if (list instanceof PrimitiveCollections.CharacterList) {
            return PrimitiveCollections.ImmutableCharacterArrayList.newCopying(list);
        }
        if (list instanceof PrimitiveCollections.ShortList) {
            return PrimitiveCollections.ImmutableShortArrayList.newCopying(list);
        }
        if (list instanceof PrimitiveCollections.FloatList) {
            return PrimitiveCollections.ImmutableFloatArrayList.newCopying(list);
        }
        if (list instanceof PrimitiveCollections.IntegerList) {
            return PrimitiveCollections.ImmutableIntegerArrayList.newCopying(list);
        }
        if (list instanceof PrimitiveCollections.DoubleList) {
            return PrimitiveCollections.ImmutableDoubleArrayList.newCopying(list);
        }
        if (list instanceof PrimitiveCollections.LongList) {
            return PrimitiveCollections.ImmutableLongArrayList.newCopying(list);
        }
        return Collections.unmodifiableList(new ArrayList<Boolean>(list));
    }

    public static <E> Set<E> immutableCopySet(Set<E> set) {
        if (Primitives.isTrueAndNotNull(ObjectUtilities.isThreadUnsafelyImmutable(set))) {
            return set;
        }
        if (set instanceof PrimitiveCollections.ByteCollection) {
            return new PrimitiveCollections.SortedByteSetBackedByList(PrimitiveCollections.ImmutableByteArrayList.newCopying(PrimitiveCollections.SortedByteSetBackedByList.sorted(set).getUnderlying()));
        }
        if (set instanceof PrimitiveCollections.CharacterCollection) {
            return new PrimitiveCollections.SortedCharacterSetBackedByList(PrimitiveCollections.ImmutableCharacterArrayList.newCopying(PrimitiveCollections.SortedCharacterSetBackedByList.sorted(set).getUnderlying()));
        }
        if (set instanceof PrimitiveCollections.ShortCollection) {
            return new PrimitiveCollections.SortedShortSetBackedByList(PrimitiveCollections.ImmutableShortArrayList.newCopying(PrimitiveCollections.SortedShortSetBackedByList.sorted(set).getUnderlying()));
        }
        if (set instanceof PrimitiveCollections.FloatCollection) {
            return new PrimitiveCollections.SortedFloatSetBackedByList(PrimitiveCollections.ImmutableFloatArrayList.newCopying(PrimitiveCollections.SortedFloatSetBackedByList.sorted(set).getUnderlying()));
        }
        if (set instanceof PrimitiveCollections.IntegerCollection) {
            return new PrimitiveCollections.SortedIntegerSetBackedByList(PrimitiveCollections.ImmutableIntegerArrayList.newCopying(PrimitiveCollections.SortedIntegerSetBackedByList.sorted(set).getUnderlying()));
        }
        if (set instanceof PrimitiveCollections.DoubleCollection) {
            return new PrimitiveCollections.SortedDoubleSetBackedByList(PrimitiveCollections.ImmutableDoubleArrayList.newCopying(PrimitiveCollections.SortedDoubleSetBackedByList.sorted(set).getUnderlying()));
        }
        if (set instanceof PrimitiveCollections.LongCollection) {
            return new PrimitiveCollections.SortedLongSetBackedByList(PrimitiveCollections.ImmutableLongArrayList.newCopying(PrimitiveCollections.SortedLongSetBackedByList.sorted(set).getUnderlying()));
        }
        return Collections.unmodifiableSet(new HashSet<Byte>(set));
    }

    public static <K, V> Map<K, V> immutableCopyMap(Map<K, V> map) {
        if (Primitives.isTrueAndNotNull(ObjectUtilities.isThreadUnsafelyImmutable(map))) {
            return map;
        }
        return Collections.unmodifiableMap(new HashMap<K, V>(map));
    }

    public static <E> boolean isRandomAccessFast(List<E> list) {
        if (list instanceof RandomAccess) {
            return true;
        }
        return FastRandomAccess.is(list);
    }

    public static <E, L extends List<E>> L subListToEnd(L list, int start) {
        WidespreadTestingUtilities.asrt(start >= 0);
        return (L)list.subList(start, list.size());
    }

    public static <E, L extends List<E>> L subListFromBeginning(L list, int pastEndAkaSize) {
        WidespreadTestingUtilities.asrt(pastEndAkaSize >= 0);
        return (L)list.subList(0, pastEndAkaSize);
    }

    public static <E, L extends List<E>> L subListBySize(L list, int start, int subListSize) {
        WidespreadTestingUtilities.asrt(start >= 0);
        WidespreadTestingUtilities.asrt(subListSize >= 0);
        return (L)list.subList(start, start + subListSize);
    }

    public static <I> boolean reduceBoolean(FunctionInterfaces.BinaryFunction<I, I, Boolean> f, Iterable<I> inputs, boolean and) {
        return CollectionUtilities.reduceBoolean(f, SimpleIterator.SimpleIterable.simpleIterable(inputs), and);
    }

    public static <I> boolean reduceBoolean(FunctionInterfaces.BinaryFunction<I, I, Boolean> f, SimpleIterator.SimpleIterable<I> inputs, boolean and) {
        return CollectionUtilities.reduceBoolean(f, inputs.simpleIterator(), and);
    }

    public static <I> boolean reduceBoolean(FunctionInterfaces.BinaryFunction<I, I, Boolean> f, SimpleIterator<I> inputs, boolean and) {
        block5: {
            I next;
            I first;
            try {
                first = inputs.nextrp();
            }
            catch (StopIterationReturnPath exc1) {
                return and;
            }
            do {
                try {
                    next = inputs.nextrp();
                }
                catch (StopIterationReturnPath exc) {
                    break block5;
                }
            } while (f.f(first, next).booleanValue());
            return !and;
        }
        return and;
    }

    public static <I> boolean reduceAnding(FunctionInterfaces.BinaryFunction<I, I, Boolean> f, Iterable<I> inputs) {
        return CollectionUtilities.reduceBoolean(f, inputs, true);
    }

    public static <I> boolean reduceAnding(FunctionInterfaces.BinaryFunction<I, I, Boolean> f, SimpleIterator.SimpleIterable<I> inputs) {
        return CollectionUtilities.reduceBoolean(f, inputs, true);
    }

    public static <I> boolean reduceAnding(FunctionInterfaces.BinaryFunction<I, I, Boolean> f, SimpleIterator<I> inputs) {
        return CollectionUtilities.reduceBoolean(f, inputs, true);
    }

    public static <I> boolean reduceOrring(FunctionInterfaces.BinaryFunction<I, I, Boolean> f, Iterable<I> inputs) {
        return CollectionUtilities.reduceBoolean(f, inputs, false);
    }

    public static <I> boolean reduceOrring(FunctionInterfaces.BinaryFunction<I, I, Boolean> f, SimpleIterator.SimpleIterable<I> inputs) {
        return CollectionUtilities.reduceBoolean(f, inputs, false);
    }

    public static <I> boolean reduceOrring(FunctionInterfaces.BinaryFunction<I, I, Boolean> f, SimpleIterator<I> inputs) {
        return CollectionUtilities.reduceBoolean(f, inputs, false);
    }

    public static <E> Set<E> getAllWithObserver(FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryProcedure<E>> observerUsingFunction) {
        HashSet set = new HashSet();
        observerUsingFunction.f(set::add);
        return set;
    }

    public static <E> Collection<E> getAllMultiSetWithObserver(FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryProcedure<E>> observerUsingFunction) {
        ArrayList set = new ArrayList();
        observerUsingFunction.f(set::add);
        return set;
    }

    public static <E> boolean hasAnyWithObserver(FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryProcedure<E>> observerUsingFunction) {
        SimpleContainers.SimpleBooleanContainer hasAny_C = new SimpleContainers.SimpleBooleanContainer(false);
        observerUsingFunction.f(e -> hasAny_C.set(true));
        return hasAny_C.get();
    }

    public static boolean hasAnyWithRunnable(FunctionInterfaces.UnaryProcedure<Runnable> observerUsingFunction) {
        SimpleContainers.SimpleBooleanContainer hasAny_C = new SimpleContainers.SimpleBooleanContainer(false);
        observerUsingFunction.f(() -> hasAny_C.set(true));
        return hasAny_C.get();
    }

    public static boolean hasAnyWithPredicate(FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryProcedureBoolean> observerUsingFunction) {
        SimpleContainers.SimpleBooleanContainer hasAny_C = new SimpleContainers.SimpleBooleanContainer(false);
        observerUsingFunction.f(v -> {
            if (v) {
                hasAny_C.set(true);
            }
        });
        return hasAny_C.get();
    }

    public static <E> boolean hasAtLeastOneMatchingWithObserver(FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryProcedure<E>> observerUsingFunction, Predicate<E> predicate) {
        SimpleContainers.SimpleBooleanContainer hasMatching_C = new SimpleContainers.SimpleBooleanContainer(false);
        observerUsingFunction.f(e -> {
            if (predicate.test(e)) {
                hasMatching_C.set(true);
            }
        });
        return hasMatching_C.get();
    }

    public static <E> E getArbitraryOrNullIfNoneWithObserver(FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryFunction<E, ContinueSignal>> observerUsingFunction) {
        SimpleContainers.SimpleObjectContainer<Object> c = new SimpleContainers.SimpleObjectContainer<Object>(null);
        observerUsingFunction.f(v -> {
            Objects.requireNonNull(v);
            c.set(v);
            return ContinueSignal.Stop;
        });
        return (E)c.get();
    }

    public static <E> void setInListGrowingWithNullsIfNecessary(List<E> list, int index, E element) {
        if (index >= list.size()) {
            CollectionUtilities.setListSizeGrowing(list, index + 1, null);
        }
        list.set(index, element);
    }

    public static <E> void setInListGrowingIfNecessary(List<E> list, int index, E element, E elementToAddIfGrowing) {
        if (index >= list.size()) {
            CollectionUtilities.setListSizeGrowing(list, index + 1, elementToAddIfGrowing);
        }
        list.set(index, element);
    }

    public static <T extends Iterable<?>> T requireNonNullElements(@NonnullElements T collection) {
        if (CollectionUtilities.isAnyNull(collection)) {
            throw new NullPointerException();
        }
        return collection;
    }

    public static <T extends Map<?, ?>> T requireNonNullKeys(@NonnullKeys T map) {
        if (CollectionUtilities.isAnyNull(map.keySet())) {
            throw new NullPointerException();
        }
        return map;
    }

    public static <T extends Map<?, ?>> T requireNonNullValues(@NonnullValues T map) {
        if (CollectionUtilities.isAnyNull(map.values())) {
            throw new NullPointerException();
        }
        return map;
    }

    public static <T extends Map<?, ?>> T requireNonNullKeysAndValues(@NonnullKeys T map) {
        CollectionUtilities.requireNonNullKeys(map);
        CollectionUtilities.requireNonNullValues(map);
        return map;
    }

    public static <T extends SimpleTable<?>> T requireNonNullCells(@NonnullElements T table) {
        table.apply(v -> {
            Object object = Objects.requireNonNull(v);
        });
        return table;
    }

    public static <T extends Iterable<?>> T requireNonEmpty(@Nonempty T c) {
        if (BasicCollectionUtilities.isEmptyIterable(c)) {
            throw new IllegalArgumentException();
        }
        return c;
    }

    public static <T extends Map<?, ?>> T requireNonEmpty(@Nonempty T map) {
        if (map.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return map;
    }

    public static <T extends SimpleTable<?>> T requireNonEmpty(@Nonempty T table) {
        if (table.isEmpty()) {
            throw new IllegalArgumentException();
        }
        return table;
    }

    public static <T extends Iterable<?>> T requireInstanceOfElements(@NonnullElements T collection, Class c) {
        for (Object t : collection) {
            CollectionUtilities.requireInstanceOf(t, c);
        }
        return collection;
    }

    public static <T extends Map<?, ?>> T requireInstanceOfKeys(@NonnullKeys T map, Class c) {
        for (Object t : map.keySet()) {
            CollectionUtilities.requireInstanceOf(t, c);
        }
        return map;
    }

    public static <T extends Map<?, ?>> T requireInstanceOfValues(@NonnullValues T map, Class c) {
        for (Object t : map.values()) {
            CollectionUtilities.requireInstanceOf(t, c);
        }
        return map;
    }

    public static <T extends Map<?, ?>> T requireInstanceOfKeysAndValues(@NonnullKeys T map, Class c) {
        CollectionUtilities.requireInstanceOfKeys(map, c);
        CollectionUtilities.requireInstanceOfValues(map, c);
        return map;
    }

    public static <T extends SimpleTable<?>> T requireInstanceOfCells(@NonnullElements T table, Class c) {
        table.apply(v -> {
            Object object = CollectionUtilities.requireInstanceOf(v, c);
        });
        return table;
    }

    public static <T> T requireInstanceOf(@Nonnull T obj, Class c) {
        if (!c.isInstance(obj)) {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(obj, c);
        }
        return obj;
    }

    public static <E> Iterable<E> cloneIterable(Iterable<E> iterable) {
        if (iterable instanceof PubliclyCloneable) {
            return (Iterable)((PubliclyCloneable)((Object)iterable)).clone();
        }
        if (iterable instanceof Collection) {
            return new ArrayList((Collection)iterable);
        }
        ArrayList l = new ArrayList();
        CollectionUtilities.addAll(l, iterable);
        return l;
    }

    public static <E> Collection<E> cloneCollection(Collection<E> Collection2) {
        if (Collection2 instanceof PubliclyCloneable) {
            return (Collection)((PubliclyCloneable)((Object)Collection2)).clone();
        }
        return new ArrayList<E>(Collection2);
    }

    public static <E> List<E> cloneList(List<E> list) {
        if (list instanceof PubliclyCloneable) {
            return (List)((PubliclyCloneable)((Object)list)).clone();
        }
        return new ArrayList<E>(list);
    }

    public static <E> Set<E> cloneSet(Set<E> Set2) {
        if (Set2 instanceof PubliclyCloneable) {
            return (Set)((PubliclyCloneable)((Object)Set2)).clone();
        }
        return new HashSet<E>(Set2);
    }

    public static <K, V> Map<K, V> cloneMap(Map<K, V> Map2) {
        if (Map2 instanceof PubliclyCloneable) {
            return (Map)((PubliclyCloneable)((Object)Map2)).clone();
        }
        return new HashMap<K, V>(Map2);
    }

    public static IdentityCardinality identityCardinalityFromCardinality(int size) {
        if (size == 0) {
            return IdentityCardinality.Zero;
        }
        if (size == 1) {
            return IdentityCardinality.One;
        }
        return IdentityCardinality.Multiple;
    }

    public static IdentityCardinality identityCardinalityOf(Collection<?> collection) {
        return CollectionUtilities.identityCardinalityFromCardinality(collection.size());
    }

    public static IdentityCardinality identityCardinalityOf(Map<?, ?> map) {
        return CollectionUtilities.identityCardinalityFromCardinality(map.size());
    }

    public static IdentityCardinality identityCardinalityOf(Iterable<?> iterable) {
        if (iterable instanceof Collection) {
            return CollectionUtilities.identityCardinalityOf((Collection)iterable);
        }
        Iterator<?> i = iterable.iterator();
        if (i.hasNext()) {
            i.next();
            if (i.hasNext()) {
                return IdentityCardinality.Multiple;
            }
            return IdentityCardinality.One;
        }
        return IdentityCardinality.Zero;
    }

    public static IdentityCardinality identityCardinalityOfGeneralMap(Map<?, ? extends Iterable<?>> gmap) {
        IdentityCardinality ic = CollectionUtilities.identityCardinalityOf(gmap);
        if (ic == IdentityCardinality.One) {
            Iterable<?> v = BasicCollectionUtilities.getSingleElement(gmap.values());
            return CollectionUtilities.identityCardinalityOf(v);
        }
        return ic;
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, SimpleIterator<I> inputs, EqualityComparator<O> eq) {
        boolean has;
        block7: {
            has = false;
            Object arbitrary = null;
            while (true) {
                O o;
                I i;
                try {
                    i = inputs.nextrp();
                }
                catch (StopIterationReturnPath exc) {
                    break block7;
                }
                try {
                    o = mapper.f(i);
                }
                catch (FilterAwayReturnPath exc) {
                    continue;
                }
                if (!has) {
                    arbitrary = o;
                    has = true;
                    continue;
                }
                if (!eq.equals(o, arbitrary)) break;
            }
            return false;
        }
        if (!has) {
            throw new IllegalArgumentException("No inputs!");
        }
        return true;
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, SimpleIterator.SimpleIterable<I> inputs, EqualityComparator<O> eq) {
        return CollectionUtilities.eqMapping(mapper, inputs.simpleIterator(), eq);
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, Iterator<I> inputs, EqualityComparator<O> eq) {
        return CollectionUtilities.eqMapping(mapper, SimpleIterator.simpleIterator(inputs), eq);
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, Iterable<I> inputs, EqualityComparator<O> eq) {
        return CollectionUtilities.eqMapping(mapper, SimpleIterator.SimpleIterable.simpleIterable(inputs), eq);
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, I[] inputs, EqualityComparator<O> eq) {
        return CollectionUtilities.eqMapping(mapper, SimpleIterator.simpleIterator(inputs), eq);
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, SimpleIterator<I> inputs) {
        return CollectionUtilities.eqMapping(mapper, inputs, DefaultEqualityComparator.I);
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, Iterator<I> inputs) {
        return CollectionUtilities.eqMapping(mapper, inputs, DefaultEqualityComparator.I);
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, Iterable<I> inputs) {
        return CollectionUtilities.eqMapping(mapper, inputs, DefaultEqualityComparator.I);
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, SimpleIterator.SimpleIterable<I> inputs) {
        return CollectionUtilities.eqMapping(mapper, inputs, DefaultEqualityComparator.I);
    }

    public static <I, O> boolean eqMapping(Mapper<I, O> mapper, I[] inputs) {
        return CollectionUtilities.eqMapping(mapper, inputs, DefaultEqualityComparator.I);
    }

    public static <I, O> boolean eqMappingV(Mapper<I, O> mapper, I ... inputs) {
        return CollectionUtilities.eqMapping(mapper, inputs, DefaultEqualityComparator.I);
    }

    public static <I> boolean transitiveReduce(SimpleIterator<I> inputs, FunctionInterfaces.BinaryFunctionToBoolean<I, I> f) {
        return CollectionUtilities.eqMapping((I x) -> x, inputs, (O a, O b) -> f.f(a, b));
    }

    public static <I> boolean transitiveReduce(Iterator<I> inputs, FunctionInterfaces.BinaryFunctionToBoolean<I, I> f) {
        return CollectionUtilities.eqMapping((I x) -> x, inputs, (O a, O b) -> f.f(a, b));
    }

    public static <I> boolean transitiveReduce(Iterable<I> inputs, FunctionInterfaces.BinaryFunctionToBoolean<I, I> f) {
        return CollectionUtilities.eqMapping((I x) -> x, inputs, (O a, O b) -> f.f(a, b));
    }

    public static <I> boolean transitiveReduce(SimpleIterator.SimpleIterable<I> inputs, FunctionInterfaces.BinaryFunctionToBoolean<I, I> f) {
        return CollectionUtilities.eqMapping((I x) -> x, inputs, (O a, O b) -> f.f(a, b));
    }

    public static <I> boolean transitiveReduce(I[] inputs, FunctionInterfaces.BinaryFunctionToBoolean<I, I> f) {
        return CollectionUtilities.eqMapping((I x) -> x, inputs, (O a, O b) -> f.f(a, b));
    }

    public static <I> boolean transitiveReduceV(FunctionInterfaces.BinaryFunctionToBoolean<I, I> f, I ... inputs) {
        return CollectionUtilities.eqMapping((I x) -> x, inputs, (O a, O b) -> f.f(a, b));
    }

    @Nullable
    public static <E> Integer binarySearchList(FunctionInterfaces.UnaryFunction<? super E, Direction1D> predicate, List<E> list) {
        return MathUtilities.binarySearchS32(i -> (Direction1D)((Object)((Object)predicate.f((Object)list.get(i)))), 0, list.size());
    }

    public static boolean isAllNull(Iterable<?> i) {
        if (i instanceof PrimitiveCollection) {
            return false;
        }
        return CollectionUtilities.forAll(e -> e == null, i);
    }

    public static boolean isAnyNull(Iterable<?> i) {
        if (i instanceof PrimitiveCollection) {
            return false;
        }
        return CollectionUtilities.forAny(e -> e == null, i);
    }

    @ReadonlyValue
    @SnapshotValue
    public static <E> List<List<E>> simpleMergeOPC(FunctionInterfaces.BinaryFunctionToBoolean<List<E>, List<E>> shouldMerge, List<List<E>> input) {
        return CollectionUtilities.mergeOPC(shouldMerge, l -> Collections.singletonList(CollectionUtilities.concatenateManyListsOPC(l)), input);
    }

    @ReadonlyValue
    @SnapshotValue
    public static <E> List<E> mergeOP(FunctionInterfaces.BinaryFunctionToBoolean<E, E> shouldMerge, FunctionInterfaces.UnaryFunction<List<E>, List<E>> merger, List<E> input) {
        return CollectionUtilities.mergeOPx(shouldMerge, merger, input, false);
    }

    @ReadonlyValue
    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> mergeOPC(FunctionInterfaces.BinaryFunctionToBoolean<E, E> shouldMerge, FunctionInterfaces.UnaryFunction<List<E>, List<E>> merger, List<E> input) {
        return CollectionUtilities.mergeOPx(shouldMerge, merger, input, true);
    }

    @ReadonlyValue
    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> mergeOPx(FunctionInterfaces.BinaryFunctionToBoolean<E, E> shouldMerge, FunctionInterfaces.UnaryFunction<List<E>, List<E>> merger, List<E> input, boolean conserve) {
        return CollectionUtilities.mergeOPx(shouldMerge, merger, input, initialCapacity -> new ArrayList(initialCapacity), conserve);
    }

    @ReadonlyValue
    @PossiblySnapshotPossiblyLiveValue
    public static <E> List<E> mergeOPx(FunctionInterfaces.BinaryFunctionToBoolean<E, E> shouldMerge, FunctionInterfaces.UnaryFunction<List<E>, List<E>> merger, List<E> input, FunctionInterfaces.UnaryFunctionIntToObject<List<E>> outputInstantiator, boolean conserve) {
        if (input.isEmpty()) {
            return conserve ? input : outputInstantiator.f(0);
        }
        List<E> merged = conserve ? null : outputInstantiator.f(input.size());
        int mergeRunStart = 0;
        Object prev = null;
        int i = 0;
        for (E e : input) {
            if (i > 0 && !shouldMerge.f(prev, e)) {
                int runLength = i - mergeRunStart;
                WidespreadTestingUtilities.asrt(runLength > 0);
                if (runLength == 1) {
                    if (merged != null) {
                        merged.add(prev);
                    }
                } else {
                    if (merged == null) {
                        merged = outputInstantiator.f(input.size());
                        merged.addAll(input.subList(0, mergeRunStart));
                    }
                    merged.addAll(merger.f(input.subList(mergeRunStart, i)));
                }
                mergeRunStart = i;
            }
            ++i;
            prev = e;
        }
        int n = i;
        int runLength = n - mergeRunStart;
        WidespreadTestingUtilities.asrt(runLength > 0);
        if (runLength == 1) {
            if (merged != null) {
                merged.add(prev);
            }
        } else {
            if (merged == null) {
                merged = outputInstantiator.f(input.size());
                merged.addAll(input.subList(0, mergeRunStart));
            }
            merged.addAll(merger.f(input.subList(mergeRunStart, n)));
        }
        if (merged == null) {
            WidespreadTestingUtilities.asrt(conserve);
            return input;
        }
        return merged;
    }

    @ThrowAwayValue
    public static <I, O> List<O> mapNullaryToList(Mapper<I, O> mapper, FunctionInterfaces.NullaryFunction<I> generator, int amount) {
        ArrayList<O> rv = new ArrayList<O>();
        int i = 0;
        while (i < amount) {
            block3: {
                O o;
                try {
                    o = mapper.f(generator.f());
                }
                catch (FilterAwayReturnPath exc) {
                    break block3;
                }
                rv.add(o);
            }
            ++i;
        }
        return rv;
    }

    @ThrowAwayValue
    public static <I, O> Set<O> mapNullaryToSet(Mapper<I, O> mapper, FunctionInterfaces.NullaryFunction<I> generator, int amount) {
        HashSet<O> rv = new HashSet<O>();
        int i = 0;
        while (i < amount) {
            block3: {
                O o;
                try {
                    o = mapper.f(generator.f());
                }
                catch (FilterAwayReturnPath exc) {
                    break block3;
                }
                rv.add(o);
            }
            ++i;
        }
        return rv;
    }

    @ThrowAwayValue
    public static <E> List<E> nullaryToList(FunctionInterfaces.NullaryFunction<E> generator, int amount) {
        return CollectionUtilities.mapNullaryToList(x -> x, generator, amount);
    }

    public static <E> Set<E> nullaryToSet(FunctionInterfaces.NullaryFunction<E> generator, int amount) {
        return CollectionUtilities.mapNullaryToSet(x -> x, generator, amount);
    }

    public static <E> Iterator<E> enumerationToIterator(final Enumeration<E> e) {
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return e.hasMoreElements();
            }

            @Override
            public E next() {
                return e.nextElement();
            }
        };
    }

    public static <E> void redimTablePreservingContentsIP(@WritableValue SimpleTable<E> table, int newWidth, int newHeight, E elementToAddIfExpanding) {
        block10: {
            int current;
            block9: {
                current = table.getNumberOfColumns();
                if (newWidth < current) {
                    while (current != newWidth) {
                        table.deleteColumn(--current);
                    }
                } else if (newWidth > current) {
                    int h = table.getNumberOfRows();
                    while (current != newWidth) {
                        table.insertEmptyColumn(current);
                        int y = 0;
                        while (y < h) {
                            table.setCellContents(current, y, elementToAddIfExpanding);
                            ++y;
                        }
                        ++current;
                    }
                }
                current = table.getNumberOfRows();
                if (newHeight >= current) break block9;
                while (current != newHeight) {
                    table.deleteRow(--current);
                }
                break block10;
            }
            if (newHeight <= current) break block10;
            int w = table.getNumberOfColumns();
            while (current != newHeight) {
                table.insertEmptyRow(current);
                int x = 0;
                while (x < w) {
                    table.setCellContents(x, current, elementToAddIfExpanding);
                    ++x;
                }
                ++current;
            }
        }
    }

    public static <E> void appendRowExpandingIP(@WritableValue SimpleTable<E> table, @ReadonlyValue List<E> row, E elementToAddIfExpanding) {
        int tableWidth = table.getNumberOfColumns();
        int rowWidth = row.size();
        int h = table.getNumberOfRows();
        if (rowWidth > tableWidth) {
            CollectionUtilities.redimTablePreservingContentsIP(table, rowWidth, h, elementToAddIfExpanding);
        }
        int y = h;
        table.appendEmptyRow();
        int x = 0;
        while (x < rowWidth) {
            table.setCellContents(x, y, row.get(x));
            ++x;
        }
        while (x < tableWidth) {
            table.setCellContents(x, y, elementToAddIfExpanding);
            ++x;
        }
    }

    @ThrowAwayValue
    public static <E> SimpleTable<E> nonrectangularRowsToNewTable(List<List<E>> rows, E elementToAddIfExpanding) {
        if (rows.isEmpty()) {
            return CollectionUtilities.newTable();
        }
        SimpleTable<E> table = CollectionUtilities.newTableFromOneRow(rows.get(0));
        for (List<E> row : rows.subList(1, rows.size())) {
            CollectionUtilities.appendRowExpandingIP(table, row, elementToAddIfExpanding);
        }
        return table;
    }

    public static <E> List<E> removeAllOPC(List<E> l, E e) {
        int i = l.indexOf(e);
        if (i == -1) {
            return l;
        }
        ArrayList<E> ll = new ArrayList<E>(l);
        do {
            ll.remove(i);
        } while ((i = ll.indexOf(e)) != -1);
        return ll;
    }

    public static <E> List<E> replaceAllOPC(List<E> l, E old, E neu) {
        int i = l.indexOf(old);
        if (i == -1) {
            return l;
        }
        ArrayList<E> ll = new ArrayList<E>(l);
        do {
            ll.set(i, neu);
        } while ((i = ll.indexOf(old)) != -1);
        return ll;
    }

    public static <E> Map<E, Set<E>> produceAliasMap(FunctionInterfaces.UnaryProcedure<AliasObserver<E>> observeAllIds) {
        final HashMap map = new HashMap();
        observeAllIds.f(new AliasObserver<E>(){

            @Override
            public void observeAlias(E startingId, E redirectTargetId) {
                if (redirectTargetId != null) {
                    Set startingAliases = (Set)map.get(startingId);
                    Set redirectTargetAliases = (Set)map.get(redirectTargetId);
                    if (startingAliases == null) {
                        if (redirectTargetAliases == null) {
                            Set<Object> s = CollectionUtilities.newSet(startingId, redirectTargetId);
                            map.put(redirectTargetId, s);
                            map.put(startingId, s);
                        } else {
                            redirectTargetAliases.add(startingId);
                            map.put(startingId, redirectTargetAliases);
                        }
                    } else if (redirectTargetAliases == null) {
                        startingAliases.add(redirectTargetId);
                        map.put(redirectTargetId, startingAliases);
                    } else {
                        redirectTargetAliases.addAll(startingAliases);
                        map.put(startingId, redirectTargetAliases);
                    }
                }
            }

            @Override
            public void observeEntryNotSayingIfAlias(E startingId) {
                CollectionUtilities.getOrCreate(map, startingId, HashSet::new).add(startingId);
            }
        });
        return map;
    }

    public static <E> Queue<E> newArrayQueue(int capacity) {
        return new ArrayBlockingQueue(capacity, true);
    }

    public static <E> E firstOrNull(Iterable<E> c) {
        Iterator<E> i = c.iterator();
        return i.hasNext() ? (E)i.next() : null;
    }

    public static <E> E firstOrNull(Collection<E> c) {
        if (c instanceof List) {
            return CollectionUtilities.firstOrNull((List)c);
        }
        if (c.isEmpty()) {
            return null;
        }
        return CollectionUtilities.firstOrNull(c);
    }

    public static <E> E firstOrNull(List<E> c) {
        return c.isEmpty() ? null : (E)c.get(0);
    }

    public static <E> E reduceWithIdentity(FunctionInterfaces.BinaryFunction<E, E, E> function, E identity, Iterable<E> inputs) {
        E current = identity;
        for (E e : inputs) {
            current = function.f(current, e);
        }
        return current;
    }

    public static <E> E reduce(FunctionInterfaces.BinaryFunction<E, E, E> function, E identityIfListIsEmpty, Iterable<E> inputs) {
        try {
            return CollectionUtilities.reduceRP(function, inputs);
        }
        catch (EmptyInputReturnPath rp) {
            return identityIfListIsEmpty;
        }
    }

    public static <E> E reduceNonempty(FunctionInterfaces.BinaryFunction<E, E, E> function, Iterable<E> inputs) throws EmptyInputReturnPath.EmptyInputException {
        try {
            return CollectionUtilities.reduceRP(function, inputs);
        }
        catch (EmptyInputReturnPath rp) {
            throw rp.toException();
        }
    }

    public static <E> E reduceRP(FunctionInterfaces.BinaryFunction<E, E, E> function, Iterable<E> inputs) throws EmptyInputReturnPath {
        boolean has = false;
        Object current = null;
        for (E e : inputs) {
            if (has) {
                current = function.f(current, e);
                continue;
            }
            current = e;
            has = true;
        }
        if (!has) {
            throw EmptyInputReturnPath.I;
        }
        return (E)current;
    }

    public static <I, O> O reduceByOperation(FunctionInterfaces.UnaryProcedure<FunctionInterfaces.UnaryProcedure<I>> theThingThatVisitsButWontReturnAnything, O mutableOutputStartingWithIdentity, InPlaceReducer<I, O> reducer) {
        theThingThatVisitsButWontReturnAnything.f(i -> reducer.f(i, mutableOutputStartingWithIdentity));
        return mutableOutputStartingWithIdentity;
    }

    public static Boolean isWeakKeyedMap(Object o) {
        if (o instanceof WeakKeyedMap) {
            return ((WeakKeyedMap)o).isWeakKeyedMap();
        }
        if (o instanceof WeakHashMap) {
            return true;
        }
        if (o.getClass() == HashMap.class) {
            return false;
        }
        if (o.getClass() == Hashtable.class) {
            return false;
        }
        if (o.getClass() == Properties.class) {
            return false;
        }
        if (o.getClass() == TreeMap.class) {
            return false;
        }
        return null;
    }

    public static Boolean isWeakValuedMap(Object o) {
        if (o instanceof WeakValuedMap) {
            return ((WeakValuedMap)o).isWeakValuedMap();
        }
        if (o instanceof WeakHashMap) {
            return false;
        }
        if (o.getClass() == HashMap.class) {
            return false;
        }
        if (o.getClass() == Hashtable.class) {
            return false;
        }
        if (o.getClass() == Properties.class) {
            return false;
        }
        if (o.getClass() == TreeMap.class) {
            return false;
        }
        return null;
    }

    public static Boolean isWeakMap(Object o) {
        Boolean a = CollectionUtilities.isWeakKeyedMap(o);
        Boolean b = CollectionUtilities.isWeakValuedMap(o);
        if (Primitives.isTrueAndNotNull(a) || Primitives.isTrueAndNotNull(b)) {
            return true;
        }
        if (a == null) {
            return b;
        }
        return a;
    }

    public static Boolean isWeakCollection(Object o) {
        if (o instanceof WeakCollection) {
            return ((WeakCollection)o).isWeakCollection();
        }
        if (o.getClass() == ArrayList.class) {
            return false;
        }
        if (o.getClass() == Vector.class) {
            return false;
        }
        if (o.getClass() == HashSet.class) {
            return false;
        }
        return null;
    }

    public static <E> boolean clearReturningIfChanged(Collection<E> c) {
        if (c.isEmpty()) {
            return false;
        }
        c.clear();
        return true;
    }

    public static <K, V> boolean clearReturningIfChanged(Map<K, V> m) {
        if (m.isEmpty()) {
            return false;
        }
        m.clear();
        return true;
    }

    public static <E> PairOrdered<E, Boolean> setReturningIfChanged(List<E> list, int index, E element) {
        E v = list.get(index);
        if (BasicObjectUtilities.eq(v, element)) {
            return BasicCollectionUtilities.pair(v, false);
        }
        list.set(index, element);
        return BasicCollectionUtilities.pair(v, true);
    }

    public static <E> boolean replaceAllReturningIfChanged(List<E> list, UnaryOperator<E> operator) {
        boolean changed = false;
        ListIterator li = list.listIterator();
        while (li.hasNext()) {
            E oldValue = li.next();
            Object newValue = operator.apply(oldValue);
            if (BasicObjectUtilities.eq(newValue, oldValue)) continue;
            li.set(newValue);
            changed = true;
        }
        return changed;
    }

    public static <K, V> PairOrdered<V, Boolean> mergeReturningIfChanged(Map<K, V> map, K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        PairOrdered<V, Boolean> r = CollectionUtilities.getp(map, key);
        V oldValue = r.getA();
        V newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        boolean present = r.getB();
        if (newValue == null) {
            if (present) {
                map.remove(key);
            }
            return BasicCollectionUtilities.pair(newValue, present);
        }
        if (present) {
            if (BasicObjectUtilities.eq(oldValue, value)) {
                return BasicCollectionUtilities.pair(newValue, false);
            }
            map.put(key, value);
            return BasicCollectionUtilities.pair(newValue, true);
        }
        map.put(key, value);
        return BasicCollectionUtilities.pair(newValue, true);
    }

    public static <K, V> PairOrdered<V, Boolean> putReturningIfChanged(Map<K, V> map, K key, V value) {
        PairOrdered<V, Boolean> p = CollectionUtilities.getp(map, key);
        boolean present = p.getB();
        if (present) {
            V v = p.getA();
            if (BasicObjectUtilities.eq(v, value)) {
                return BasicCollectionUtilities.pair(v, false);
            }
            map.put(key, value);
            return BasicCollectionUtilities.pair(v, true);
        }
        map.put(key, value);
        return BasicCollectionUtilities.pair(null, true);
    }

    public static <K, V> PairOrdered<V, Boolean> removeReturningIfChanged(Map<K, V> map, Object key) {
        PairOrdered<V, Boolean> p = CollectionUtilities.getp(map, key);
        boolean present = p.getB();
        if (present) {
            V n = map.remove(key);
            if (!BasicObjectUtilities.eq(p.getA(), n)) {
                GlobalCodeMetastuffContext.logBug();
            }
        }
        return p;
    }

    public static <K, V> boolean putAllReturningIfChanged(Map<K, V> map, Map<? extends K, ? extends V> source) {
        boolean changed = false;
        for (Map.Entry<K, V> e : source.entrySet()) {
            V v;
            try {
                v = CollectionUtilities.getrp(map, e.getKey());
            }
            catch (NoSuchMappingReturnPath rp) {
                map.put(e.getKey(), e.getValue());
                changed = true;
                continue;
            }
            if (BasicObjectUtilities.eq(v, e.getValue())) continue;
            map.put(e.getKey(), e.getValue());
            changed = true;
        }
        return changed;
    }

    public static <K, V> PairOrdered<V, Boolean> putIfAbsentReturningIfChanged(Map<K, V> map, K key, V value) {
        PairOrdered<V, Boolean> p = CollectionUtilities.getp(map, key);
        boolean present = p.getB();
        if (!present) {
            map.put(key, value);
            return BasicCollectionUtilities.pair(p.getA(), true);
        }
        if (p.getA() != null) {
            GlobalCodeMetastuffContext.logBug(StringUtilities.repr(p.getA()));
        }
        return BasicCollectionUtilities.pair(null, false);
    }

    public static <K, V> boolean replaceAllReturningIfChanged(Map<K, V> map, BiFunction<? super K, ? super V, ? extends V> function) {
        Objects.requireNonNull(function);
        boolean changed = false;
        HashMap<K, V> copy = new HashMap<K, V>(map);
        for (Map.Entry<K, V> entry : map.entrySet()) {
            V v;
            K k;
            try {
                k = entry.getKey();
                v = entry.getValue();
            }
            catch (IllegalStateException exc) {
                map.clear();
                map.putAll(copy);
                throw new ConcurrentModificationException(exc);
            }
            V newValue = function.apply(k, v);
            if (BasicObjectUtilities.eq(newValue, v)) continue;
            try {
                entry.setValue(newValue);
            }
            catch (IllegalStateException exc) {
                map.clear();
                map.putAll(copy);
                throw new ConcurrentModificationException(exc);
            }
            changed = true;
        }
        return changed;
    }

    public static <K, V> PairOrdered<V, Boolean> replaceReturningIfChanged(Map<K, V> map, K key, V value) {
        PairOrdered<V, Boolean> p = CollectionUtilities.getp(map, key);
        boolean present = p.getB();
        if (present) {
            V v = p.getA();
            if (BasicObjectUtilities.eq(v, value)) {
                return BasicCollectionUtilities.pair(v, false);
            }
            map.put(key, value);
            return BasicCollectionUtilities.pair(v, true);
        }
        return BasicCollectionUtilities.pair(null, false);
    }

    public static <K, V> PairOrdered<V, Boolean> computeIfAbsentReturningIfChanged(Map<K, V> map, K key, Function<? super K, ? extends V> mappingFunction) {
        Objects.requireNonNull(mappingFunction);
        V v = map.get(key);
        if (v == null) {
            V newValue = mappingFunction.apply(key);
            if (newValue != null) {
                map.put(key, newValue);
                return BasicCollectionUtilities.pair(newValue, true);
            }
            return BasicCollectionUtilities.pair(null, false);
        }
        return BasicCollectionUtilities.pair(v, false);
    }

    public static <K, V> PairOrdered<V, Boolean> computeIfPresentReturningIfChanged(Map<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        V oldValue = map.get(key);
        if (oldValue != null) {
            V newValue = remappingFunction.apply(key, oldValue);
            if (newValue != null) {
                if (BasicObjectUtilities.eq(oldValue, newValue)) {
                    map.put(key, newValue);
                    return BasicCollectionUtilities.pair(newValue, true);
                }
                return BasicCollectionUtilities.pair(newValue, false);
            }
            map.remove(key);
            return BasicCollectionUtilities.pair(null, true);
        }
        return BasicCollectionUtilities.pair(null, false);
    }

    public static <K, V> PairOrdered<V, Boolean> computeReturningIfChanged(Map<K, V> map, K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        PairOrdered<V, Boolean> p = CollectionUtilities.getp(map, key);
        V oldValue = p.getA();
        V newValue = remappingFunction.apply(key, oldValue);
        if (newValue == null) {
            if (p.getB().booleanValue()) {
                map.remove(key);
                return BasicCollectionUtilities.pair(null, true);
            }
            return BasicCollectionUtilities.pair(null, false);
        }
        boolean present = p.getB();
        if (present) {
            V v = p.getA();
            if (BasicObjectUtilities.eq(v, newValue)) {
                return BasicCollectionUtilities.pair(v, false);
            }
            map.put(key, newValue);
            return BasicCollectionUtilities.pair(v, true);
        }
        map.put(key, newValue);
        return BasicCollectionUtilities.pair(null, true);
    }

    public static <E> void setCollectionFrom(Collection<E> dest, Collection<E> source) {
        CollectionUtilities.setCollectionFromReturningIfChanged(dest, source);
    }

    public static <K, V> void setMapFrom(Map<K, V> dest, Map<K, V> source) {
        CollectionUtilities.setMapFromReturningIfChanged(dest, source);
    }

    public static <E> boolean setCollectionFromReturningIfChanged(Collection<E> dest, Collection<E> source) {
        if (CollectionUtilities.eqv(dest, source)) {
            return false;
        }
        dest.clear();
        dest.addAll(source);
        return true;
    }

    public static <K, V> boolean setMapFromReturningIfChanged(Map<K, V> dest, Map<K, V> source) {
        if (CollectionUtilities.eqv(dest, source)) {
            return false;
        }
        dest.clear();
        dest.putAll(source);
        return true;
    }

    @ReadonlyValue
    public static <E> List<E> dict2list(Map<Integer, E> map) throws NonSurjectiveMapException {
        int n = map.size();
        List<Object> list = CollectionUtilities.asList(new Object[n]);
        boolean[] has = new boolean[n];
        for (Map.Entry<Integer, E> e : map.entrySet()) {
            int index = e.getKey();
            WidespreadTestingUtilities.asrt(!has[index]);
            list.set(index, e.getValue());
            has[index] = true;
        }
        int index = 0;
        while (index < n) {
            if (!has[index]) {
                throw new NonSurjectiveMapException("Computed indexes are not surjective!!  No entries were assigned to this index!!:  " + index);
            }
            ++index;
        }
        return list;
    }

    public static <I, Vo> List<Vo> mapToDictlist(Mapper<I, Map.Entry<Integer, Vo>> function, Iterable<I> input) throws NonReverseInjectiveMapException, NonSurjectiveMapException {
        Map<Integer, Vo> dict = CollectionUtilities.maptodict(function, input);
        return CollectionUtilities.dict2list(dict);
    }

    public static <E> ListSet<E> emptyListSet() {
        return emptyListSet;
    }

    public static <E> ListSet<E> singletonListSet(E member) {
        return new ListBackedSet<E>(Collections.singletonList(member));
    }

    public static int[] necklaceCopyIndexesII(int startInclusive, int endInclusive, int necklaceSize) {
        WidespreadTestingUtilities.asrt(startInclusive >= 0);
        WidespreadTestingUtilities.asrt(endInclusive >= 0);
        WidespreadTestingUtilities.asrt(startInclusive < necklaceSize);
        WidespreadTestingUtilities.asrt(endInclusive < necklaceSize);
        if (endInclusive < startInclusive) {
            int[] nArray = new int[4];
            nArray[0] = startInclusive;
            nArray[1] = necklaceSize;
            nArray[3] = endInclusive + 1;
            return nArray;
        }
        int[] nArray = new int[4];
        nArray[0] = startInclusive;
        nArray[1] = endInclusive + 1;
        return nArray;
    }

    public static int[] necklaceCopyIndexesIE(int startInclusive, int endExclusive, int necklaceSize) {
        WidespreadTestingUtilities.asrt(startInclusive >= 0);
        WidespreadTestingUtilities.asrt(endExclusive >= 0);
        WidespreadTestingUtilities.asrt(startInclusive < necklaceSize);
        WidespreadTestingUtilities.asrt(endExclusive <= necklaceSize);
        if (startInclusive == endExclusive) {
            return new int[4];
        }
        return CollectionUtilities.necklaceCopyIndexesII(startInclusive, endExclusive == 0 ? necklaceSize - 1 : endExclusive - 1, necklaceSize);
    }

    public static boolean isSmallFiniteSet(Set set) {
        if (set instanceof SmallFinite) {
            return ((SmallFinite)((Object)set)).isSmallFinite();
        }
        if (set instanceof ListBackedSet) {
            return CollectionUtilities.isSmallFiniteList((List)((ListBackedSet)set).getBacking());
        }
        if (set instanceof AssertedSet) {
            return CollectionUtilities.isSmallFiniteCollection(((AssertedSet)set).getUnderlying());
        }
        return set == Collections.EMPTY_SET || set instanceof HashSet || set instanceof TreeSet || set.getClass() == CollectionUtilities.singletonSet(null).getClass();
    }

    public static boolean isSmallFiniteList(List list) {
        if (list instanceof SmallFinite) {
            return ((SmallFinite)((Object)list)).isSmallFinite();
        }
        return list == Collections.EMPTY_LIST || list instanceof ArrayList || list instanceof Vector || list instanceof LinkedList || list.getClass() == CollectionUtilities.singletonSet(null).getClass() || list.getClass() == Arrays.asList(new Object[0]).getClass();
    }

    public static boolean isSmallFiniteCollection(Collection c) {
        if (c instanceof Set) {
            return CollectionUtilities.isSmallFiniteSet((Set)c);
        }
        if (c instanceof List) {
            return CollectionUtilities.isSmallFiniteList((List)c);
        }
        return SmallFinite.is(c);
    }

    public static Necklace<?> emptyNecklace() {
        return EmptyNecklace.I;
    }

    public static <E> Necklace<E> singletonNecklace(E e) {
        return new SingletonNecklace<E>(e);
    }

    public static <E> Necklace<E> precanonicalizedNecklace(List<E> canonicalRotation) {
        return new PrecanonicalizedNecklace<E>(canonicalRotation);
    }

    public static <E> Necklace<E> necklaceCanonicalizedBySmallestMember(List<E> arbitraryRotation, Comparator<E> comparison) {
        int indexOfSmallestMember = (Integer)((Object)MathUtilities.least(CollectionUtilities.intervalIntegersList(0, arbitraryRotation.size()), (a, b) -> comparison.compare(arbitraryRotation.get((int)a), arbitraryRotation.get((int)b))));
        return CollectionUtilities.precanonicalizedNecklace(CollectionUtilities.rotated(arbitraryRotation, -indexOfSmallestMember));
    }

    public static Bracelet<?> emptyBracelet() {
        return EmptyBracelet.I;
    }

    public static <E> Bracelet<E> singletonBracelet(E e) {
        return new SingletonBracelet<E>(e);
    }

    public static <E> Bracelet<E> precanonicalizedBracelet(List<E> canonicalRotationAndReflection) {
        return new PrecanonicalizedBracelet<E>(canonicalRotationAndReflection);
    }

    public static <E> Bracelet<E> braceletCanonicalizedBySmallestMemberAndSmallestAscendingReflection(List<E> arbitraryRotation, Comparator<E> comparison) {
        int indexOfSmallestMember = (Integer)((Object)MathUtilities.least(CollectionUtilities.intervalIntegersList(0, arbitraryRotation.size()), (a, b) -> comparison.compare(arbitraryRotation.get((int)a), arbitraryRotation.get((int)b))));
        List<E> l = CollectionUtilities.rotated(arbitraryRotation, -indexOfSmallestMember);
        int n = l.size();
        if (n > 2) {
            E elementBeforeFirst = l.get(n - 1);
            int i = 1;
            while (i < n - 1) {
                E elementAfterFirst = l.get(i);
                int r = comparison.compare(elementBeforeFirst, elementAfterFirst);
                if (r < 0) break;
                if (r > 0) {
                    l = CollectionUtilities.reversed(l);
                    l = CollectionUtilities.rotated(l, 1);
                    break;
                }
                ++i;
            }
        }
        return CollectionUtilities.precanonicalizedBracelet(l);
    }

    public static <E extends Comparable> int defaultListsCompare(@Nullable List<? extends E> listA, @Nullable List<? extends E> listB) {
        return CollectionUtilities.defaultListsCompare(listA, listB, Comparator.naturalOrder());
    }

    public static <E> int defaultListsCompare(@Nullable List<? extends E> listA, @Nullable List<? extends E> listB, @Nonnull Comparator<E> comparison) {
        return CollectionUtilities.defaultListsCompare(listA, listB, comparison, true);
    }

    public static <E> int defaultListsCompare(@Nullable List<? extends E> listA, @Nullable List<? extends E> listB, @Nonnull Comparator<E> comparison, boolean lengthsFirst) {
        E b;
        E a;
        int r;
        int r2;
        if (listA == null) {
            return listB == null ? 0 : -1;
        }
        if (listB == null) {
            return 1;
        }
        if (lengthsFirst && (r2 = SmallIntegerMathUtilities.cmp(listA.size(), listB.size())) != 0) {
            return r2;
        }
        Iterator<E> ia = listA.iterator();
        Iterator<E> ib = listB.iterator();
        do {
            boolean ibn;
            boolean chesterton;
            if ((chesterton = ia.hasNext()) != (ibn = ib.hasNext())) {
                return chesterton ? 1 : -1;
            }
            if (CodeHinting.arbitrary(chesterton, ibn)) continue;
            return 0;
        } while ((r = comparison.compare(a = ia.next(), b = ib.next())) == 0);
        return r;
    }

    public static <E> int defaultListsCompare(@Nullable List<? extends E> listA, @Nullable List<? extends E> listB, @Nonnull Comparator<E> comparison, boolean lengthsFirst, boolean invertElementComparison, boolean shorterIsLarger) {
        boolean invertIn = invertElementComparison ^ shorterIsLarger;
        boolean invertOut = shorterIsLarger;
        int r = CollectionUtilities.defaultListsCompare(listA, listB, invertIn ? comparison.reversed() : comparison, lengthsFirst);
        return invertOut ? -r : r;
    }

    public static <E> int defaultSetsCompare(@Nullable Set<? extends E> setA, @Nullable Set<? extends E> setB, Comparator<E> comparison) {
        return CollectionUtilities.defaultSetsCompareFullRV(setA, setB, comparison).comparisonResult;
    }

    public static <E> defaultSetsCompareRV<? extends E> defaultSetsCompareFullRV(@Nullable Set<? extends E> setA, @Nullable Set<? extends E> setB, Comparator<E> comparison) {
        int r = SmallIntegerMathUtilities.cmp(setA.size(), setB.size());
        if (r != 0) {
            return new defaultSetsCompareRV(r, null, null);
        }
        List<? extends E> orderingOnA = CollectionUtilities.sorted(setA, comparison);
        List<? extends E> orderingOnB = CollectionUtilities.sorted(setB, comparison);
        return new defaultSetsCompareRV<E>(CollectionUtilities.defaultListsCompare(orderingOnA, orderingOnB, comparison), orderingOnA, orderingOnB);
    }

    public static <E> int defaultDoubletonsCompare(@Nullable PairCommutative<? extends E> setA, @Nullable PairCommutative<? extends E> setB, Comparator<E> comparison) {
        E b1;
        E b0;
        E a1;
        E a0;
        E aB;
        E aA = setA.getA();
        if (comparison.compare(aA, aB = setA.getB()) <= 0) {
            a0 = aA;
            a1 = aB;
        } else {
            a0 = aB;
            a1 = aA;
        }
        E bA = setB.getA();
        E bB = setB.getB();
        if (comparison.compare(bA, bB) <= 0) {
            b0 = bA;
            b1 = bB;
        } else {
            b0 = bB;
            b1 = bA;
        }
        int r = comparison.compare(a0, b0);
        if (r != 0) {
            return r;
        }
        return comparison.compare(a1, b1);
    }

    public static <A, B> int comparePairNormal(PairOrdered<? extends A, ? extends B> pairA, PairOrdered<? extends A, ? extends B> pairB, Comparator<A> comparisonA, Comparator<B> comparisonB) {
        int r = comparisonA.compare(pairA.getA(), pairB.getA());
        if (r != 0) {
            return r;
        }
        return comparisonB.compare(pairA.getB(), pairB.getB());
    }

    public static <A, B> int comparePairReversed(PairOrdered<? extends A, ? extends B> pairA, PairOrdered<? extends A, ? extends B> pairB, Comparator<A> comparisonA, Comparator<B> comparisonB) {
        int r = comparisonB.compare(pairA.getB(), pairB.getB());
        if (r != 0) {
            return r;
        }
        return comparisonA.compare(pairA.getA(), pairB.getA());
    }

    public static <K, V> int defaultMapsCompare(@Nullable Map<? extends K, ? extends V> mapA, @Nullable Map<? extends K, ? extends V> mapB, Comparator<K> keyComparison, Comparator<V> valueComparison) {
        defaultSetsCompareRV<? extends K> r = CollectionUtilities.defaultSetsCompareFullRV(mapA.keySet(), mapB.keySet(), keyComparison);
        int rc = r.comparisonResult;
        if (rc != 0) {
            return rc;
        }
        List keysInOrder = CodeHinting.arbitrary(Objects.requireNonNull(r.orderingOnA), Objects.requireNonNull(r.orderingOnB));
        List<Object> valuesInOrderA = CollectionUtilities.mapToList((I k) -> CollectionUtilities.getMandatory(mapA, k), keysInOrder);
        List<Object> valuesInOrderB = CollectionUtilities.mapToList((I k) -> CollectionUtilities.getMandatory(mapB, k), keysInOrder);
        return CollectionUtilities.defaultListsCompare(valuesInOrderA, valuesInOrderB, valueComparison);
    }

    @ReadonlyValue
    @Nullable
    public static <E> TripleOrdered<List<E>, List<E>, List<E>> extractCommonFirsts(@ReadonlyValue List<E> a, @ReadonlyValue List<E> b, EqualityComparator<E> eq) {
        int firstDifferent;
        int an = a.size();
        int bn = b.size();
        int n = SmallIntegerMathUtilities.least(an, bn);
        for (firstDifferent = 0; firstDifferent != n && eq.equals(a.get(firstDifferent), b.get(firstDifferent)); ++firstDifferent) {
        }
        if (firstDifferent == 0) {
            return null;
        }
        List<E> common = CodeHinting.arbitrary(a, b).subList(0, firstDifferent);
        List<E> newA = a.subList(firstDifferent, an);
        List<E> newB = b.subList(firstDifferent, bn);
        return BasicCollectionUtilities.triple(common, newA, newB);
    }

    @ReadonlyValue
    @Nullable
    public static <E> TripleOrdered<List<E>, List<E>, List<E>> extractCommonLasts(@ReadonlyValue List<E> a, @ReadonlyValue List<E> b, EqualityComparator<E> eq) {
        int firstDifferentReverseIndex;
        int an = a.size();
        int bn = b.size();
        int n = SmallIntegerMathUtilities.least(an, bn);
        for (firstDifferentReverseIndex = 0; firstDifferentReverseIndex != n && eq.equals(a.get(an - firstDifferentReverseIndex - 1), b.get(bn - firstDifferentReverseIndex - 1)); ++firstDifferentReverseIndex) {
        }
        if (firstDifferentReverseIndex == 0) {
            return null;
        }
        List<E> common = CodeHinting.arbitraryBoolean() ? a.subList(an - firstDifferentReverseIndex, an) : b.subList(bn - firstDifferentReverseIndex, bn);
        List<E> newA = a.subList(0, an - firstDifferentReverseIndex);
        List<E> newB = b.subList(0, bn - firstDifferentReverseIndex);
        return BasicCollectionUtilities.triple(newA, newB, common);
    }

    @ReadonlyValue
    @Nullable
    public static <E> PairOrdered<List<E>, List<List<E>>> extractManyCommonFirsts(@ReadonlyValue List<List<E>> inputs, EqualityComparator<E> eq) {
        int i;
        int nl = inputs.size();
        if (nl == 0) {
            return BasicCollectionUtilities.pair(Collections.emptyList(), Collections.emptyList());
        }
        int n = MathUtilities.leastMap(List::size, inputs);
        for (i = 0; i != n; ++i) {
            boolean allEqual = true;
            E f = inputs.get(0).get(i);
            int listIndex = 1;
            while (listIndex < nl) {
                if (!eq.equals(f, inputs.get(listIndex).get(i))) {
                    allEqual = false;
                    break;
                }
                ++listIndex;
            }
            if (!allEqual) break;
        }
        int firstDifferent = i;
        if (firstDifferent == 0) {
            return null;
        }
        List<E> cl = inputs.get(CodeHinting.arbitraryIntNonnegative() % nl);
        List<E> common = cl.subList(0, firstDifferent);
        List<List> newLists = CollectionUtilities.mapToList((I l) -> l.subList(firstDifferent, l.size()), inputs);
        return BasicCollectionUtilities.pair(common, newLists);
    }

    @ReadonlyValue
    @Nullable
    public static <E> PairOrdered<List<List<E>>, List<E>> extractManyCommonLasts(@ReadonlyValue List<List<E>> inputs, EqualityComparator<E> eq) {
        int i;
        int nl = inputs.size();
        if (nl == 0) {
            return BasicCollectionUtilities.pair(Collections.emptyList(), Collections.emptyList());
        }
        int n = MathUtilities.leastMap(List::size, inputs);
        for (i = 0; i != n; ++i) {
            boolean allEqual = true;
            E f = inputs.get(0).get(i);
            int listIndex = 1;
            while (listIndex < nl) {
                if (!eq.equals(f, inputs.get(listIndex).get(i))) {
                    allEqual = false;
                    break;
                }
                ++listIndex;
            }
            if (!allEqual) break;
        }
        int firstDifferentReverseIndex = i;
        if (firstDifferentReverseIndex == 0) {
            return null;
        }
        List<E> cl = inputs.get(CodeHinting.arbitraryIntNonnegative() % nl);
        int cln = cl.size();
        List<E> common = cl.subList(cln - firstDifferentReverseIndex, cln);
        List<List> newLists = CollectionUtilities.mapToList((I l) -> l.subList(0, l.size() - firstDifferentReverseIndex), inputs);
        return BasicCollectionUtilities.pair(newLists, common);
    }

    public static interface AliasObserver<E> {
        public void observeAlias(E var1, E var2);

        public void observeEntryNotSayingIfAlias(E var1);
    }

    public static interface InPlaceReducer<I, O> {
        public void f(@ReadonlyValue I var1, @WritableValue O var2);
    }

    public static enum SetRelationRequirement {
        ExactEquality,
        ActualCanBeSubsetOfExpected,
        ActualCanBeSupersetOfExpected;

    }

    public static class defaultSetsCompareRV<E> {
        public final int comparisonResult;
        @Nullable
        public final List<E> orderingOnA;
        @Nullable
        public final List<E> orderingOnB;

        public defaultSetsCompareRV(int comparisonResult, List<E> orderingOnA, List<E> orderingOnB) {
            this.comparisonResult = comparisonResult;
            if (comparisonResult == 0) {
                Objects.requireNonNull(orderingOnA);
                Objects.requireNonNull(orderingOnB);
            }
            this.orderingOnA = orderingOnA;
            this.orderingOnB = orderingOnB;
        }
    }
}

