/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.lang.reflect.Array;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.annotations.semantic.allowedoperations.ReadonlyValue;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.reachability.PossiblySnapshotPossiblyLiveValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.bits.BitUtilities;
import rebound.bits.BitfieldSafeCasts;
import rebound.bits.Bytes;
import rebound.exceptions.NotYetImplementedException;
import rebound.math.SmallFloatMathUtilities;
import rebound.math.SmallIntegerMathUtilities;
import rebound.util.BasicExceptionUtilities;
import rebound.util.CodeHinting;
import rebound.util.Primitives;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.container.ContainerInterfaces;
import rebound.util.functional.EqualityComparator;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.objectutil.PubliclyCloneable;

public class ArrayUtilities
implements JavaNamespace {
    public static final boolean[] EmptyBooleanArray = new boolean[0];
    public static final char[] EmptyCharArray = new char[0];
    public static final byte[] EmptyByteArray = new byte[0];
    public static final short[] EmptyShortArray = new short[0];
    public static final int[] EmptyIntArray = new int[0];
    public static final long[] EmptyLongArray = new long[0];
    public static final float[] EmptyFloatArray = new float[0];
    public static final double[] EmptyDoubleArray = new double[0];
    public static final Object[] EmptyObjectArray = new Object[0];
    public static final Slice<boolean[]> EmptyBooleanSlice = new Slice<boolean[]>(EmptyBooleanArray, 0, 0);
    public static final Slice<char[]> EmptyCharSlice = new Slice<char[]>(EmptyCharArray, 0, 0);
    public static final Slice<byte[]> EmptyByteSlice = new Slice<byte[]>(EmptyByteArray, 0, 0);
    public static final Slice<short[]> EmptyShortSlice = new Slice<short[]>(EmptyShortArray, 0, 0);
    public static final Slice<int[]> EmptyIntSlice = new Slice<int[]>(EmptyIntArray, 0, 0);
    public static final Slice<long[]> EmptyLongSlice = new Slice<long[]>(EmptyLongArray, 0, 0);
    public static final Slice<float[]> EmptyFloatSlice = new Slice<float[]>(EmptyFloatArray, 0, 0);
    public static final Slice<double[]> EmptyDoubleSlice = new Slice<double[]>(EmptyDoubleArray, 0, 0);
    public static final Slice<Object[]> EmptyObjectSlice = new Slice<Object[]>(EmptyObjectArray, 0, 0);
    protected static final EqualityComparator<boolean[]> BooleanArrayEqualityComparator = new EqualityComparator<boolean[]>(){

        @Override
        public boolean equals(boolean[] a, boolean[] b) {
            return Arrays.equals(a, b);
        }
    };
    protected static final EqualityComparator<byte[]> ByteArrayEqualityComparator = new EqualityComparator<byte[]>(){

        @Override
        public boolean equals(byte[] a, byte[] b) {
            return Arrays.equals(a, b);
        }
    };
    protected static final EqualityComparator<short[]> ShortArrayEqualityComparator = new EqualityComparator<short[]>(){

        @Override
        public boolean equals(short[] a, short[] b) {
            return Arrays.equals(a, b);
        }
    };
    protected static final EqualityComparator<char[]> CharArrayEqualityComparator = new EqualityComparator<char[]>(){

        @Override
        public boolean equals(char[] a, char[] b) {
            return Arrays.equals(a, b);
        }
    };
    protected static final EqualityComparator<int[]> IntArrayEqualityComparator = new EqualityComparator<int[]>(){

        @Override
        public boolean equals(int[] a, int[] b) {
            return Arrays.equals(a, b);
        }
    };
    protected static final EqualityComparator<float[]> FloatArrayEqualityComparator = new EqualityComparator<float[]>(){

        @Override
        public boolean equals(float[] a, float[] b) {
            return Arrays.equals(a, b);
        }
    };
    protected static final EqualityComparator<long[]> LongArrayEqualityComparator = new EqualityComparator<long[]>(){

        @Override
        public boolean equals(long[] a, long[] b) {
            return Arrays.equals(a, b);
        }
    };
    protected static final EqualityComparator<double[]> DoubleArrayEqualityComparator = new EqualityComparator<double[]>(){

        @Override
        public boolean equals(double[] a, double[] b) {
            return Arrays.equals(a, b);
        }
    };
    protected static final EqualityComparator<Object[]> ObjectArrayShallowEqualityComparator = new EqualityComparator<Object[]>(){

        @Override
        public boolean equals(Object[] a, Object[] b) {
            return Arrays.equals(a, b);
        }
    };
    protected static final EqualityComparator<Object[]> ObjectArrayDeepEqualityComparator = new EqualityComparator<Object[]>(){

        @Override
        public boolean equals(Object[] a, Object[] b) {
            return Arrays.deepEquals(a, b);
        }
    };
    protected static final EqualityComparator DynamicArrayShallowEqualityComparator = new EqualityComparator<Object>(){

        @Override
        public boolean equals(Object a, Object b) {
            return ArrayUtilities.arrayEqualsPolymorphic(a, b);
        }
    };
    protected static final EqualityComparator DynamicArrayDeepEqualityComparator = new EqualityComparator<Object>(){

        @Override
        public boolean equals(Object a, Object b) {
            return ArrayUtilities.arrayDeepEquals(a, b);
        }
    };

    public static Object emptyArrayByArrayType(Class arrayType) {
        if (arrayType == Object[].class) {
            return EmptyObjectArray;
        }
        if (arrayType == boolean[].class) {
            return EmptyBooleanArray;
        }
        if (arrayType == byte[].class) {
            return EmptyByteArray;
        }
        if (arrayType == char[].class) {
            return EmptyCharArray;
        }
        if (arrayType == short[].class) {
            return EmptyShortArray;
        }
        if (arrayType == float[].class) {
            return EmptyFloatArray;
        }
        if (arrayType == int[].class) {
            return EmptyIntArray;
        }
        if (arrayType == double[].class) {
            return EmptyDoubleArray;
        }
        if (arrayType == long[].class) {
            return EmptyLongArray;
        }
        if (arrayType.isArray()) {
            throw new AssertionError((Object)String.valueOf(arrayType));
        }
        throw new IllegalArgumentException("Not an array type: " + arrayType);
    }

    public static Object emptyArrayByComponentType(Class componentType) {
        if (componentType == Boolean.TYPE) {
            return EmptyBooleanArray;
        }
        if (componentType == Byte.TYPE) {
            return EmptyByteArray;
        }
        if (componentType == Character.TYPE) {
            return EmptyCharArray;
        }
        if (componentType == Short.TYPE) {
            return EmptyShortArray;
        }
        if (componentType == Float.TYPE) {
            return EmptyFloatArray;
        }
        if (componentType == Integer.TYPE) {
            return EmptyIntArray;
        }
        if (componentType == Double.TYPE) {
            return EmptyDoubleArray;
        }
        if (componentType == Long.TYPE) {
            return EmptyLongArray;
        }
        if (componentType == Void.TYPE) {
            throw new IllegalArgumentException("void.class was given");
        }
        return EmptyObjectArray;
    }

    public static Slice emptyArraySliceByArrayType(Class arrayType) {
        if (arrayType == Object[].class) {
            return EmptyObjectSlice;
        }
        if (arrayType == boolean[].class) {
            return EmptyBooleanSlice;
        }
        if (arrayType == byte[].class) {
            return EmptyByteSlice;
        }
        if (arrayType == char[].class) {
            return EmptyCharSlice;
        }
        if (arrayType == short[].class) {
            return EmptyShortSlice;
        }
        if (arrayType == float[].class) {
            return EmptyFloatSlice;
        }
        if (arrayType == int[].class) {
            return EmptyIntSlice;
        }
        if (arrayType == double[].class) {
            return EmptyDoubleSlice;
        }
        if (arrayType == long[].class) {
            return EmptyLongSlice;
        }
        if (arrayType.isArray()) {
            throw new AssertionError((Object)String.valueOf(arrayType));
        }
        throw new IllegalArgumentException("Not an array type: " + arrayType);
    }

    public static Slice emptyArraySliceByComponentType(Class componentType) {
        if (componentType == Boolean.TYPE) {
            return EmptyBooleanSlice;
        }
        if (componentType == Byte.TYPE) {
            return EmptyByteSlice;
        }
        if (componentType == Character.TYPE) {
            return EmptyCharSlice;
        }
        if (componentType == Short.TYPE) {
            return EmptyShortSlice;
        }
        if (componentType == Float.TYPE) {
            return EmptyFloatSlice;
        }
        if (componentType == Integer.TYPE) {
            return EmptyIntSlice;
        }
        if (componentType == Double.TYPE) {
            return EmptyDoubleSlice;
        }
        if (componentType == Long.TYPE) {
            return EmptyLongSlice;
        }
        if (componentType == Void.TYPE) {
            throw new IllegalArgumentException("void.class was given");
        }
        return EmptyObjectSlice;
    }

    public static boolean eqa(Object a, Object b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        if (a instanceof Object[]) {
            return b instanceof Object[] && ArrayUtilities.arrayDeepEquals(a, b);
        }
        if (a instanceof boolean[]) {
            return b instanceof boolean[] && ArrayUtilities.arrayEquals((boolean[])a, (boolean[])b);
        }
        if (a instanceof byte[]) {
            return b instanceof byte[] && ArrayUtilities.arrayEquals((byte[])a, (byte[])b);
        }
        if (a instanceof char[]) {
            return b instanceof char[] && ArrayUtilities.arrayEquals((char[])a, (char[])b);
        }
        if (a instanceof short[]) {
            return b instanceof short[] && ArrayUtilities.arrayEquals((short[])a, (short[])b);
        }
        if (a instanceof float[]) {
            return b instanceof float[] && ArrayUtilities.arrayEquals((float[])a, (float[])b);
        }
        if (a instanceof int[]) {
            return b instanceof int[] && ArrayUtilities.arrayEquals((int[])a, (int[])b);
        }
        if (a instanceof double[]) {
            return b instanceof double[] && ArrayUtilities.arrayEquals((double[])a, (double[])b);
        }
        if (a instanceof long[]) {
            return b instanceof long[] && ArrayUtilities.arrayEquals((long[])a, (long[])b);
        }
        return false;
    }

    public static void slicecopy(Slice source, int offsetSource, Slice dest, int offsetDest, int length) {
        System.arraycopy(source.getUnderlying(), source.getOffset() + offsetSource, dest.getUnderlying(), dest.getOffset() + offsetDest, length);
    }

    public static void slicecopy(Slice source, Slice dest, int length) {
        ArrayUtilities.slicecopy(source, 0, dest, 0, length);
    }

    public static void slicecopy(Slice source, Slice dest) {
        int n = source.getLength();
        if (n != dest.getLength()) {
            throw new IllegalArgumentException("Lengths don't match!  " + source.getLength() + " != " + dest.getLength());
        }
        ArrayUtilities.slicecopy(source, dest, n);
    }

    public static boolean arrayShallowEquals(Object[] a, int aOffset, Object[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayShallowEquals(Object[] a, Object[] b) {
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        return ArrayUtilities.arrayShallowEquals(a, 0, b, 0, length);
    }

    public static boolean arrayEquals(boolean[] a, int aOffset, boolean[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayEquals(boolean[] a, boolean[] b) {
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a, 0, b, 0, length);
    }

    public static boolean arrayEqualsBoolean(Slice<boolean[]> a, Slice<boolean[]> b) {
        int length = a.getLength();
        if (b.getLength() != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static boolean arrayEquals(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayEquals(byte[] a, byte[] b) {
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a, 0, b, 0, length);
    }

    public static boolean arrayEqualsByte(Slice<byte[]> a, Slice<byte[]> b) {
        int length = a.getLength();
        if (b.getLength() != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static boolean arrayEquals(char[] a, int aOffset, char[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayEquals(char[] a, char[] b) {
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a, 0, b, 0, length);
    }

    public static boolean arrayEqualsChar(Slice<char[]> a, Slice<char[]> b) {
        int length = a.getLength();
        if (b.getLength() != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static boolean arrayEquals(short[] a, int aOffset, short[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayEquals(short[] a, short[] b) {
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a, 0, b, 0, length);
    }

    public static boolean arrayEqualsShort(Slice<short[]> a, Slice<short[]> b) {
        int length = a.getLength();
        if (b.getLength() != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static boolean arrayEquals(float[] a, int aOffset, float[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayEquals(float[] a, float[] b) {
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a, 0, b, 0, length);
    }

    public static boolean arrayEqualsFloat(Slice<float[]> a, Slice<float[]> b) {
        int length = a.getLength();
        if (b.getLength() != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static boolean arrayEquals(int[] a, int aOffset, int[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayEquals(int[] a, int[] b) {
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a, 0, b, 0, length);
    }

    public static boolean arrayEqualsInt(Slice<int[]> a, Slice<int[]> b) {
        int length = a.getLength();
        if (b.getLength() != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static boolean arrayEquals(double[] a, int aOffset, double[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayEquals(double[] a, double[] b) {
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a, 0, b, 0, length);
    }

    public static boolean arrayEqualsDouble(Slice<double[]> a, Slice<double[]> b) {
        int length = a.getLength();
        if (b.getLength() != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static boolean arrayEquals(long[] a, int aOffset, long[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayEquals(long[] a, long[] b) {
        int length = a.length;
        if (b.length != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a, 0, b, 0, length);
    }

    public static boolean arrayEqualsLong(Slice<long[]> a, Slice<long[]> b) {
        int length = a.getLength();
        if (b.getLength() != length) {
            return false;
        }
        return ArrayUtilities.arrayEquals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static boolean arrayEqualsPolymorphic(Object arrayA, Object arrayB) {
        if (arrayA == arrayB) {
            return true;
        }
        if (arrayA == null || arrayB == null) {
            return false;
        }
        if (arrayA.getClass() != arrayB.getClass()) {
            return false;
        }
        Object tokenArray = arrayA;
        if (tokenArray instanceof boolean[]) {
            return Arrays.equals((boolean[])arrayA, (boolean[])arrayB);
        }
        if (tokenArray instanceof byte[]) {
            return Arrays.equals((byte[])arrayA, (byte[])arrayB);
        }
        if (tokenArray instanceof short[]) {
            return Arrays.equals((short[])arrayA, (short[])arrayB);
        }
        if (tokenArray instanceof char[]) {
            return Arrays.equals((char[])arrayA, (char[])arrayB);
        }
        if (tokenArray instanceof int[]) {
            return Arrays.equals((int[])arrayA, (int[])arrayB);
        }
        if (tokenArray instanceof float[]) {
            return Arrays.equals((float[])arrayA, (float[])arrayB);
        }
        if (tokenArray instanceof long[]) {
            return Arrays.equals((long[])arrayA, (long[])arrayB);
        }
        if (tokenArray instanceof double[]) {
            return Arrays.equals((double[])arrayA, (double[])arrayB);
        }
        if (tokenArray instanceof Object[]) {
            return Arrays.equals((Object[])arrayA, (Object[])arrayB);
        }
        throw new IllegalArgumentException("Provided objects are not arrays!");
    }

    public static boolean arrayDeepEquals(Object arrayA, Object arrayB) {
        if (arrayA == arrayB) {
            return true;
        }
        if (arrayA == null || arrayB == null) {
            return false;
        }
        if (arrayA.getClass() != arrayB.getClass()) {
            return false;
        }
        Object tokenArray = arrayA;
        if (tokenArray instanceof boolean[]) {
            return Arrays.equals((boolean[])arrayA, (boolean[])arrayB);
        }
        if (tokenArray instanceof byte[]) {
            return Arrays.equals((byte[])arrayA, (byte[])arrayB);
        }
        if (tokenArray instanceof short[]) {
            return Arrays.equals((short[])arrayA, (short[])arrayB);
        }
        if (tokenArray instanceof char[]) {
            return Arrays.equals((char[])arrayA, (char[])arrayB);
        }
        if (tokenArray instanceof int[]) {
            return Arrays.equals((int[])arrayA, (int[])arrayB);
        }
        if (tokenArray instanceof float[]) {
            return Arrays.equals((float[])arrayA, (float[])arrayB);
        }
        if (tokenArray instanceof long[]) {
            return Arrays.equals((long[])arrayA, (long[])arrayB);
        }
        if (tokenArray instanceof double[]) {
            return Arrays.equals((double[])arrayA, (double[])arrayB);
        }
        if (tokenArray instanceof Object[]) {
            return Arrays.deepEquals((Object[])arrayA, (Object[])arrayB);
        }
        throw new IllegalArgumentException("Provided objects are not arrays!");
    }

    public static int arrayHashCode(Object[] array, int offset, int length) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < offset + length) {
            result = 31 * result + (array[i] == null ? 0 : array[i].hashCode());
            ++i;
        }
        return result;
    }

    public static int arrayHashCode(Object[] array) {
        return ArrayUtilities.arrayHashCode(array, 0, array.length);
    }

    public static int arrayHashCode(boolean[] array, int offset, int length) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < offset + length) {
            result = 31 * result + Primitives.hashprim(array[i]);
            ++i;
        }
        return result;
    }

    public static int arrayHashCode(boolean[] array) {
        return ArrayUtilities.arrayHashCode(array, 0, array.length);
    }

    public static int arrayHashCode(byte[] array, int offset, int length) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < offset + length) {
            result = 31 * result + Primitives.hashprim(array[i]);
            ++i;
        }
        return result;
    }

    public static int arrayHashCode(byte[] array) {
        return ArrayUtilities.arrayHashCode(array, 0, array.length);
    }

    public static int arrayHashCode(char[] array, int offset, int length) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < offset + length) {
            result = 31 * result + Primitives.hashprim(array[i]);
            ++i;
        }
        return result;
    }

    public static int arrayHashCode(char[] array) {
        return ArrayUtilities.arrayHashCode(array, 0, array.length);
    }

    public static int arrayHashCode(short[] array, int offset, int length) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < offset + length) {
            result = 31 * result + Primitives.hashprim(array[i]);
            ++i;
        }
        return result;
    }

    public static int arrayHashCode(short[] array) {
        return ArrayUtilities.arrayHashCode(array, 0, array.length);
    }

    public static int arrayHashCode(float[] array, int offset, int length) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < offset + length) {
            result = 31 * result + Primitives.hashprim(array[i]);
            ++i;
        }
        return result;
    }

    public static int arrayHashCode(float[] array) {
        return ArrayUtilities.arrayHashCode(array, 0, array.length);
    }

    public static int arrayHashCode(int[] array, int offset, int length) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < offset + length) {
            result = 31 * result + Primitives.hashprim(array[i]);
            ++i;
        }
        return result;
    }

    public static int arrayHashCode(int[] array) {
        return ArrayUtilities.arrayHashCode(array, 0, array.length);
    }

    public static int arrayHashCode(double[] array, int offset, int length) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < offset + length) {
            result = 31 * result + Primitives.hashprim(array[i]);
            ++i;
        }
        return result;
    }

    public static int arrayHashCode(double[] array) {
        return ArrayUtilities.arrayHashCode(array, 0, array.length);
    }

    public static int arrayHashCode(long[] array, int offset, int length) {
        if (array == null) {
            return 0;
        }
        int result = 1;
        int i = 0;
        while (i < offset + length) {
            result = 31 * result + Primitives.hashprim(array[i]);
            ++i;
        }
        return result;
    }

    public static int arrayHashCode(long[] array) {
        return ArrayUtilities.arrayHashCode(array, 0, array.length);
    }

    public static boolean arrayAllIs(Object[] array, int offset, int length, Object value) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (array[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayAllIs(boolean[] array, int offset, int length, boolean value) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (array[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayAllIs(byte[] array, int offset, int length, byte value) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (array[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayAllIs(char[] array, int offset, int length, char value) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (array[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayAllIs(short[] array, int offset, int length, short value) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (array[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayAllIs(float[] array, int offset, int length, float value) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (array[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayAllIs(int[] array, int offset, int length, int value) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (array[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayAllIs(double[] array, int offset, int length, double value) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (array[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayAllIs(long[] array, int offset, int length, long value) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (array[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <E> boolean arrayAllIs(E[] array, int offset, int length, E value, EqualityComparator<E> comparator) {
        int pastEnd = offset + length;
        int i = offset;
        while (i < pastEnd) {
            if (comparator.equals(array[i], value)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayAllIs(Object[] array, Object value) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value);
    }

    public static boolean arrayAllIs(boolean[] array, boolean value) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value);
    }

    public static boolean arrayAllIs(byte[] array, byte value) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value);
    }

    public static boolean arrayAllIs(char[] array, char value) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value);
    }

    public static boolean arrayAllIs(short[] array, short value) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value);
    }

    public static boolean arrayAllIs(float[] array, float value) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value);
    }

    public static boolean arrayAllIs(int[] array, int value) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value);
    }

    public static boolean arrayAllIs(double[] array, double value) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value);
    }

    public static boolean arrayAllIs(long[] array, long value) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value);
    }

    public static <E> boolean arrayAllIs(E[] array, E value, EqualityComparator<E> comparator) {
        return ArrayUtilities.arrayAllIs(array, 0, array.length, value, comparator);
    }

    public static boolean arrayContains(Object[] array, Object value) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (Objects.equals(e, value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayContains(Object[] array, Object value, EqualityComparator comparator) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (comparator.equals(e, value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayContains(float[] array, float value) {
        float[] fArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            float e = fArray[n2];
            if (Primitives.eqSane(e, value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayContains(double[] array, double value) {
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double e = dArray[n2];
            if (Primitives.eqSane(e, value)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayContains(boolean[] array, boolean value) {
        boolean[] blArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            boolean e = blArray[n2];
            if (e == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayContains(byte[] array, byte value) {
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte e = byArray[n2];
            if (e == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayContains(char[] array, char value) {
        char[] cArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            char e = cArray[n2];
            if (e == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayContains(short[] array, short value) {
        short[] sArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            short e = sArray[n2];
            if (e == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayContains(int[] array, int value) {
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int e = nArray[n2];
            if (e == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayContains(long[] array, long value) {
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long e = lArray[n2];
            if (e == value) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean arrayMatchesSilent(Object[] a, int aOffset, Object[] b, int bOffset, int length, EqualityComparator comparator) {
        int amtInB;
        int amtInA;
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if ((amtInA = Math.min(a.length, aOffset + length)) != (amtInB = Math.min(b.length, bOffset + length))) {
            return false;
        }
        length = amtInA;
        int i = 0;
        while (i < length) {
            if (!comparator.equals(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatchesSilent(boolean[] a, int aOffset, boolean[] b, int bOffset, int length) {
        int amtInB;
        int amtInA;
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if ((amtInA = Math.min(a.length, aOffset + length)) != (amtInB = Math.min(b.length, bOffset + length))) {
            return false;
        }
        length = amtInA;
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatchesSilent(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        int amtInB;
        int amtInA;
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if ((amtInA = Math.min(a.length, aOffset + length)) != (amtInB = Math.min(b.length, bOffset + length))) {
            return false;
        }
        length = amtInA;
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatchesSilent(char[] a, int aOffset, char[] b, int bOffset, int length) {
        int amtInB;
        int amtInA;
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if ((amtInA = Math.min(a.length, aOffset + length)) != (amtInB = Math.min(b.length, bOffset + length))) {
            return false;
        }
        length = amtInA;
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatchesSilent(short[] a, int aOffset, short[] b, int bOffset, int length) {
        int amtInB;
        int amtInA;
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if ((amtInA = Math.min(a.length, aOffset + length)) != (amtInB = Math.min(b.length, bOffset + length))) {
            return false;
        }
        length = amtInA;
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatchesSilent(float[] a, int aOffset, float[] b, int bOffset, int length) {
        int amtInB;
        int amtInA;
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if ((amtInA = Math.min(a.length, aOffset + length)) != (amtInB = Math.min(b.length, bOffset + length))) {
            return false;
        }
        length = amtInA;
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatchesSilent(int[] a, int aOffset, int[] b, int bOffset, int length) {
        int amtInB;
        int amtInA;
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if ((amtInA = Math.min(a.length, aOffset + length)) != (amtInB = Math.min(b.length, bOffset + length))) {
            return false;
        }
        length = amtInA;
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatchesSilent(double[] a, int aOffset, double[] b, int bOffset, int length) {
        int amtInB;
        int amtInA;
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if ((amtInA = Math.min(a.length, aOffset + length)) != (amtInB = Math.min(b.length, bOffset + length))) {
            return false;
        }
        length = amtInA;
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatchesSilent(long[] a, int aOffset, long[] b, int bOffset, int length) {
        int amtInB;
        int amtInA;
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if ((amtInA = Math.min(a.length, aOffset + length)) != (amtInB = Math.min(b.length, bOffset + length))) {
            return false;
        }
        length = amtInA;
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatches(Object[] a, int aOffset, Object[] b, int bOffset, int length, EqualityComparator comparator) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (!comparator.equals(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatches(boolean[] a, int aOffset, boolean[] b, int bOffset, int length) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatches(byte[] a, int aOffset, byte[] b, int bOffset, int length) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatches(char[] a, int aOffset, char[] b, int bOffset, int length) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatches(short[] a, int aOffset, short[] b, int bOffset, int length) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatches(float[] a, int aOffset, float[] b, int bOffset, int length) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatches(int[] a, int aOffset, int[] b, int bOffset, int length) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatches(double[] a, int aOffset, double[] b, int bOffset, int length) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean arrayMatches(long[] a, int aOffset, long[] b, int bOffset, int length) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static byte[] splitElements16to8LE(short[] source, int offset, int length) {
        byte[] dest = new byte[length * 2];
        int i = 0;
        while (i < length) {
            Bytes.putLittleShort(dest, i * 2, source[offset + i]);
            ++i;
        }
        return dest;
    }

    public static byte[] splitElements16to8BE(short[] source, int offset, int length) {
        byte[] dest = new byte[length * 2];
        int i = 0;
        while (i < length) {
            Bytes.putBigShort(dest, i * 2, source[offset + i]);
            ++i;
        }
        return dest;
    }

    public static byte[] splitElements32to8LE(int[] source, int offset, int length) {
        byte[] dest = new byte[length * 4];
        int i = 0;
        while (i < length) {
            Bytes.putLittleInt(dest, i * 4, source[offset + i]);
            ++i;
        }
        return dest;
    }

    public static byte[] splitElements32to8BE(int[] source, int offset, int length) {
        byte[] dest = new byte[length * 4];
        int i = 0;
        while (i < length) {
            Bytes.putBigInt(dest, i * 4, source[offset + i]);
            ++i;
        }
        return dest;
    }

    public static short[] mergeElements8to16LE(byte[] source, int offset, int length) {
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Only multiples of 2 bytes (8 bits) can be merged into ints (16 bits)!");
        }
        int nout = length / 2;
        short[] dest = new short[nout];
        int i = 0;
        while (i < nout) {
            dest[i] = Bytes.getLittleShort(source, offset + i * 2);
            ++i;
        }
        return dest;
    }

    public static short[] mergeElements8to16BE(byte[] source, int offset, int length) {
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Only multiples of 2 bytes (8 bits) can be merged into ints (16 bits)!");
        }
        int nout = length / 2;
        short[] dest = new short[nout];
        int i = 0;
        while (i < nout) {
            dest[i] = Bytes.getBigShort(source, offset + i * 2);
            ++i;
        }
        return dest;
    }

    public static int[] mergeElements8to32LE(byte[] source, int offset, int length) {
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Only multiples of 4 bytes (8 bits) can be merged into ints (32 bits)!");
        }
        int nout = length / 4;
        int[] dest = new int[nout];
        int i = 0;
        while (i < nout) {
            dest[i] = Bytes.getLittleInt(source, offset + i * 4);
            ++i;
        }
        return dest;
    }

    public static int[] mergeElements8to32BE(byte[] source, int offset, int length) {
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Only multiples of 4 bytes (8 bits) can be merged into ints (32 bits)!");
        }
        int nout = length / 4;
        int[] dest = new int[nout];
        int i = 0;
        while (i < nout) {
            dest[i] = Bytes.getBigInt(source, offset + i * 4);
            ++i;
        }
        return dest;
    }

    public static int[] mergeElements16to32LE(short[] source, int offset, int length) {
        if (length % 2 != 0) {
            throw new IllegalArgumentException("Only multiples of 4 bytes (8 bits) can be merged into ints (32 bits)!");
        }
        int nout = length / 2;
        int[] dest = new int[nout];
        int i = 0;
        while (i < nout) {
            int v = 0;
            int o = offset + (i << 1);
            v |= source[o] & 0xFFFF;
            dest[i] = v |= source[++o] << 16;
            ++i;
        }
        return dest;
    }

    public static byte[] splitElements16to8LE(short[] source) {
        return ArrayUtilities.splitElements16to8LE(source, 0, source.length);
    }

    public static byte[] splitElements16to8BE(short[] source) {
        return ArrayUtilities.splitElements16to8BE(source, 0, source.length);
    }

    public static byte[] splitElements32to8LE(int[] source) {
        return ArrayUtilities.splitElements32to8LE(source, 0, source.length);
    }

    public static byte[] splitElements32to8BE(int[] source) {
        return ArrayUtilities.splitElements32to8BE(source, 0, source.length);
    }

    public static short[] mergeElements8to16LE(byte[] source) {
        return ArrayUtilities.mergeElements8to16LE(source, 0, source.length);
    }

    public static short[] mergeElements8to16BE(byte[] source) {
        return ArrayUtilities.mergeElements8to16BE(source, 0, source.length);
    }

    public static int[] mergeElements8to32LE(byte[] source) {
        return ArrayUtilities.mergeElements8to32LE(source, 0, source.length);
    }

    public static int[] mergeElements8to32BE(byte[] source) {
        return ArrayUtilities.mergeElements8to32BE(source, 0, source.length);
    }

    public static int[] mergeElements16to32LE(short[] source) {
        return ArrayUtilities.mergeElements16to32LE(source, 0, source.length);
    }

    public static byte[] splitElements16to8LE(Slice<short[]> source) {
        return ArrayUtilities.splitElements16to8LE(source.getUnderlying(), source.getOffset(), source.getLength());
    }

    public static byte[] splitElements16to8BE(Slice<short[]> source) {
        return ArrayUtilities.splitElements16to8BE(source.getUnderlying(), source.getOffset(), source.getLength());
    }

    public static byte[] splitElements32to8LE(Slice<int[]> source) {
        return ArrayUtilities.splitElements32to8LE(source.getUnderlying(), source.getOffset(), source.getLength());
    }

    public static byte[] splitElements32to8BE(Slice<int[]> source) {
        return ArrayUtilities.splitElements32to8BE(source.getUnderlying(), source.getOffset(), source.getLength());
    }

    public static short[] mergeElements8to16LE(Slice<byte[]> source) {
        return ArrayUtilities.mergeElements8to16LE(source.getUnderlying(), source.getOffset(), source.getLength());
    }

    public static short[] mergeElements8to16BE(Slice<byte[]> source) {
        return ArrayUtilities.mergeElements8to16BE(source.getUnderlying(), source.getOffset(), source.getLength());
    }

    public static int[] mergeElements8to32LE(Slice<byte[]> source) {
        return ArrayUtilities.mergeElements8to32LE(source.getUnderlying(), source.getOffset(), source.getLength());
    }

    public static int[] mergeElements8to32BE(Slice<byte[]> source) {
        return ArrayUtilities.mergeElements8to32BE(source.getUnderlying(), source.getOffset(), source.getLength());
    }

    public static int[] mergeElements16to32LE(Slice<short[]> source) {
        return ArrayUtilities.mergeElements16to32LE(source.getUnderlying(), source.getOffset(), source.getLength());
    }

    public static int[] mergeElementsBytesToIntsLE(ByteBuffer source, int offset, int length) {
        if (length % 4 != 0) {
            throw new IllegalArgumentException("Only multiples of 4 bytes (8 bits) can be merged into ints (32 bits)!");
        }
        int nout = length / 4;
        int[] dest = new int[nout];
        int i = 0;
        while (i < nout) {
            dest[i] = Bytes.getLittleInt(source, offset + (i << 2));
            ++i;
        }
        return dest;
    }

    public static int[] mergeElementsBytesToIntsLE(ByteBuffer source) {
        return ArrayUtilities.mergeElementsBytesToIntsLE(source, 0, source.capacity());
    }

    public static <E> int indexOf(E[] array, E value, EqualityComparator<E> equalityComparator) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (equalityComparator.equals(value, array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E> int indexOf(E[] array, int subArrayStart, E value, EqualityComparator<E> equalityComparator) {
        if (array == null) {
            return -1;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (equalityComparator.equals(value, array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E> int indexOf(E[] array, int subArrayStart, int subArrayLength, E value, EqualityComparator<E> equalityComparator) {
        if (array == null) {
            return -1;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (equalityComparator.equals(value, array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <E> int indexOf(E[] array, E value) {
        return ArrayUtilities.indexOf(array, value, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> int indexOf(E[] array, int subArrayStart, E value) {
        return ArrayUtilities.indexOf(array, subArrayStart, value, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> int indexOf(E[] array, int subArrayStart, int subArrayLength, E value) {
        return ArrayUtilities.indexOf(array, subArrayStart, subArrayLength, value, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> boolean contains(E[] array, E value, EqualityComparator<E> equalityComparator) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (equalityComparator.equals(value, array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <E> boolean contains(E[] array, int subArrayStart, E value, EqualityComparator<E> equalityComparator) {
        if (array == null) {
            return false;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (equalityComparator.equals(value, array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <E> boolean contains(E[] array, int subArrayStart, int subArrayLength, E value, EqualityComparator<E> equalityComparator) {
        if (array == null) {
            return false;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (equalityComparator.equals(value, array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <E> boolean contains(E[] array, E value) {
        return ArrayUtilities.contains(array, value, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> boolean contains(E[] array, int subArrayStart, E value) {
        return ArrayUtilities.contains(array, subArrayStart, value, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static <E> boolean contains(E[] array, int subArrayStart, int subArrayLength, E value) {
        return ArrayUtilities.contains(array, subArrayStart, subArrayLength, value, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static int indexOf(boolean[] array, boolean value) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(boolean[] array, int subArrayStart, boolean value) {
        if (array == null) {
            return -1;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(boolean[] array, int subArrayStart, int subArrayLength, boolean value) {
        if (array == null) {
            return -1;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(boolean[] array, boolean value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(boolean[] array, int subArrayStart, boolean value) {
        if (array == null) {
            return false;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(boolean[] array, int subArrayStart, int subArrayLength, boolean value) {
        if (array == null) {
            return false;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int count(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, boolean[] array) {
        return ArrayUtilities.count(predicate, array, 0, array.length);
    }

    public static int count(boolean value, boolean[] array) {
        return ArrayUtilities.count(value, array, 0, array.length);
    }

    public static int count(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, boolean[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (predicate.f(array[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(boolean value, boolean[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (array[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int indexOf(byte[] array, byte value) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, int subArrayStart, byte value) {
        if (array == null) {
            return -1;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(byte[] array, int subArrayStart, int subArrayLength, byte value) {
        if (array == null) {
            return -1;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(byte[] array, byte value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(byte[] array, int subArrayStart, byte value) {
        if (array == null) {
            return false;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(byte[] array, int subArrayStart, int subArrayLength, byte value) {
        if (array == null) {
            return false;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int count(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, byte[] array) {
        return ArrayUtilities.count(predicate, array, 0, array.length);
    }

    public static int count(byte value, byte[] array) {
        return ArrayUtilities.count(value, array, 0, array.length);
    }

    public static int count(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, byte[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (predicate.f(array[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(byte value, byte[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (array[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int indexOf(char[] array, char value) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char[] array, int subArrayStart, char value) {
        if (array == null) {
            return -1;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(char[] array, int subArrayStart, int subArrayLength, char value) {
        if (array == null) {
            return -1;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(char[] array, char value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(char[] array, int subArrayStart, char value) {
        if (array == null) {
            return false;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(char[] array, int subArrayStart, int subArrayLength, char value) {
        if (array == null) {
            return false;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int count(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, char[] array) {
        return ArrayUtilities.count(predicate, array, 0, array.length);
    }

    public static int count(char value, char[] array) {
        return ArrayUtilities.count(value, array, 0, array.length);
    }

    public static int count(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, char[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (predicate.f(array[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(char value, char[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (array[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int indexOf(short[] array, short value) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(short[] array, int subArrayStart, short value) {
        if (array == null) {
            return -1;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(short[] array, int subArrayStart, int subArrayLength, short value) {
        if (array == null) {
            return -1;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(short[] array, short value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(short[] array, int subArrayStart, short value) {
        if (array == null) {
            return false;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(short[] array, int subArrayStart, int subArrayLength, short value) {
        if (array == null) {
            return false;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int count(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, short[] array) {
        return ArrayUtilities.count(predicate, array, 0, array.length);
    }

    public static int count(short value, short[] array) {
        return ArrayUtilities.count(value, array, 0, array.length);
    }

    public static int count(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, short[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (predicate.f(array[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(short value, short[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (array[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int indexOf(float[] array, float value) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(float[] array, int subArrayStart, float value) {
        if (array == null) {
            return -1;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(float[] array, int subArrayStart, int subArrayLength, float value) {
        if (array == null) {
            return -1;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(float[] array, float value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(float[] array, int subArrayStart, float value) {
        if (array == null) {
            return false;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(float[] array, int subArrayStart, int subArrayLength, float value) {
        if (array == null) {
            return false;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int count(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, float[] array) {
        return ArrayUtilities.count(predicate, array, 0, array.length);
    }

    public static int count(float value, float[] array) {
        return ArrayUtilities.count(value, array, 0, array.length);
    }

    public static int count(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, float[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (predicate.f(array[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(float value, float[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (array[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int indexOf(int[] array, int value) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int subArrayStart, int value) {
        if (array == null) {
            return -1;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] array, int subArrayStart, int subArrayLength, int value) {
        if (array == null) {
            return -1;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(int[] array, int value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(int[] array, int subArrayStart, int value) {
        if (array == null) {
            return false;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(int[] array, int subArrayStart, int subArrayLength, int value) {
        if (array == null) {
            return false;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int count(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, int[] array) {
        return ArrayUtilities.count(predicate, array, 0, array.length);
    }

    public static int count(int value, int[] array) {
        return ArrayUtilities.count(value, array, 0, array.length);
    }

    public static int count(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, int[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (predicate.f(array[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(int value, int[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (array[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int indexOf(double[] array, double value) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(double[] array, int subArrayStart, double value) {
        if (array == null) {
            return -1;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(double[] array, int subArrayStart, int subArrayLength, double value) {
        if (array == null) {
            return -1;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(double[] array, double value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(double[] array, int subArrayStart, double value) {
        if (array == null) {
            return false;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(double[] array, int subArrayStart, int subArrayLength, double value) {
        if (array == null) {
            return false;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int count(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, double[] array) {
        return ArrayUtilities.count(predicate, array, 0, array.length);
    }

    public static int count(double value, double[] array) {
        return ArrayUtilities.count(value, array, 0, array.length);
    }

    public static int count(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, double[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (predicate.f(array[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(double value, double[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (array[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int indexOf(long[] array, long value) {
        if (array == null) {
            return -1;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(long[] array, int subArrayStart, long value) {
        if (array == null) {
            return -1;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(long[] array, int subArrayStart, int subArrayLength, long value) {
        if (array == null) {
            return -1;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static boolean contains(long[] array, long value) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(long[] array, int subArrayStart, long value) {
        if (array == null) {
            return false;
        }
        int i = subArrayStart;
        while (i < array.length) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean contains(long[] array, int subArrayStart, int subArrayLength, long value) {
        if (array == null) {
            return false;
        }
        if (subArrayLength < 0) {
            throw new IndexOutOfBoundsException("negative length! D:");
        }
        int subArrayEnd = subArrayStart + subArrayLength;
        int i = subArrayStart;
        while (i < subArrayEnd) {
            if (array[i] == value) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int count(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, long[] array) {
        return ArrayUtilities.count(predicate, array, 0, array.length);
    }

    public static int count(long value, long[] array) {
        return ArrayUtilities.count(value, array, 0, array.length);
    }

    public static int count(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, long[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (predicate.f(array[i])) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(long value, long[] array, int offset, int length) {
        int e = length + offset;
        int count = 0;
        int i = offset;
        while (i < e) {
            if (array[i] == value) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static <E> E[] pop(E[] array, int deletionIndex) {
        if (array.length == 0) {
            throw new IllegalArgumentException();
        }
        try {
            Object[] excluser = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length - 1);
            if (deletionIndex > 0) {
                System.arraycopy(array, 0, excluser, 0, deletionIndex);
            }
            if (deletionIndex < array.length - 1) {
                System.arraycopy(array, deletionIndex + 1, excluser, deletionIndex, array.length - deletionIndex - 1);
            }
            return excluser;
        }
        catch (NegativeArraySizeException exc) {
            throw new AssertionError();
        }
    }

    public static <E> E[] deepClone(PubliclyCloneable[] cloneableArray, E[] newArray) {
        int i = 0;
        while (i < cloneableArray.length) {
            newArray[i] = cloneableArray[i].clone();
            ++i;
        }
        return newArray;
    }

    public static void reverse(Object[] array, int offset, int length) {
        Object swap = null;
        int offing = 0;
        while (offing < length / 2) {
            swap = array[offset + offing];
            array[offset + offing] = array[offset + length - 1 - offing];
            array[offset + length - 1 - offing] = swap;
            ++offing;
        }
    }

    public static void reverse(Object[] array) {
        ArrayUtilities.reverse(array, 0, array.length);
    }

    public static void reverse(boolean[] array, int offset, int length) {
        boolean swap = false;
        int offing = 0;
        while (offing < length / 2) {
            swap = array[offset + offing];
            array[offset + offing] = array[offset + length - 1 - offing];
            array[offset + length - 1 - offing] = swap;
            ++offing;
        }
    }

    public static void reverse(boolean[] array) {
        ArrayUtilities.reverse(array, 0, array.length);
    }

    public static boolean[] reversed(boolean[] input, int offset, int length) {
        boolean[] output = new boolean[input.length];
        int offing = 0;
        while (offing < length / 2) {
            output[offset + offing] = input[offset + length - 1 - offing];
            output[offset + length - 1 - offing] = input[offset + offing];
            ++offing;
        }
        return output;
    }

    public static boolean[] reversed(boolean[] array) {
        return ArrayUtilities.reversed(array, 0, array.length);
    }

    public static void reverse(byte[] array, int offset, int length) {
        byte swap = 0;
        int offing = 0;
        while (offing < length / 2) {
            swap = array[offset + offing];
            array[offset + offing] = array[offset + length - 1 - offing];
            array[offset + length - 1 - offing] = swap;
            ++offing;
        }
    }

    public static void reverse(byte[] array) {
        ArrayUtilities.reverse(array, 0, array.length);
    }

    public static byte[] reversed(byte[] input, int offset, int length) {
        byte[] output = new byte[input.length];
        int offing = 0;
        while (offing < length / 2) {
            output[offset + offing] = input[offset + length - 1 - offing];
            output[offset + length - 1 - offing] = input[offset + offing];
            ++offing;
        }
        return output;
    }

    public static byte[] reversed(byte[] array) {
        return ArrayUtilities.reversed(array, 0, array.length);
    }

    public static void reverse(char[] array, int offset, int length) {
        char swap = '\u0000';
        int offing = 0;
        while (offing < length / 2) {
            swap = array[offset + offing];
            array[offset + offing] = array[offset + length - 1 - offing];
            array[offset + length - 1 - offing] = swap;
            ++offing;
        }
    }

    public static void reverse(char[] array) {
        ArrayUtilities.reverse(array, 0, array.length);
    }

    public static char[] reversed(char[] input, int offset, int length) {
        char[] output = new char[input.length];
        int offing = 0;
        while (offing < length / 2) {
            output[offset + offing] = input[offset + length - 1 - offing];
            output[offset + length - 1 - offing] = input[offset + offing];
            ++offing;
        }
        return output;
    }

    public static char[] reversed(char[] array) {
        return ArrayUtilities.reversed(array, 0, array.length);
    }

    public static void reverse(short[] array, int offset, int length) {
        short swap = 0;
        int offing = 0;
        while (offing < length / 2) {
            swap = array[offset + offing];
            array[offset + offing] = array[offset + length - 1 - offing];
            array[offset + length - 1 - offing] = swap;
            ++offing;
        }
    }

    public static void reverse(short[] array) {
        ArrayUtilities.reverse(array, 0, array.length);
    }

    public static short[] reversed(short[] input, int offset, int length) {
        short[] output = new short[input.length];
        int offing = 0;
        while (offing < length / 2) {
            output[offset + offing] = input[offset + length - 1 - offing];
            output[offset + length - 1 - offing] = input[offset + offing];
            ++offing;
        }
        return output;
    }

    public static short[] reversed(short[] array) {
        return ArrayUtilities.reversed(array, 0, array.length);
    }

    public static void reverse(float[] array, int offset, int length) {
        float swap = 0.0f;
        int offing = 0;
        while (offing < length / 2) {
            swap = array[offset + offing];
            array[offset + offing] = array[offset + length - 1 - offing];
            array[offset + length - 1 - offing] = swap;
            ++offing;
        }
    }

    public static void reverse(float[] array) {
        ArrayUtilities.reverse(array, 0, array.length);
    }

    public static float[] reversed(float[] input, int offset, int length) {
        float[] output = new float[input.length];
        int offing = 0;
        while (offing < length / 2) {
            output[offset + offing] = input[offset + length - 1 - offing];
            output[offset + length - 1 - offing] = input[offset + offing];
            ++offing;
        }
        return output;
    }

    public static float[] reversed(float[] array) {
        return ArrayUtilities.reversed(array, 0, array.length);
    }

    public static void reverse(int[] array, int offset, int length) {
        int swap = 0;
        int offing = 0;
        while (offing < length / 2) {
            swap = array[offset + offing];
            array[offset + offing] = array[offset + length - 1 - offing];
            array[offset + length - 1 - offing] = swap;
            ++offing;
        }
    }

    public static void reverse(int[] array) {
        ArrayUtilities.reverse(array, 0, array.length);
    }

    public static int[] reversed(int[] input, int offset, int length) {
        int[] output = new int[input.length];
        int offing = 0;
        while (offing < length / 2) {
            output[offset + offing] = input[offset + length - 1 - offing];
            output[offset + length - 1 - offing] = input[offset + offing];
            ++offing;
        }
        return output;
    }

    public static int[] reversed(int[] array) {
        return ArrayUtilities.reversed(array, 0, array.length);
    }

    public static void reverse(double[] array, int offset, int length) {
        double swap = 0.0;
        int offing = 0;
        while (offing < length / 2) {
            swap = array[offset + offing];
            array[offset + offing] = array[offset + length - 1 - offing];
            array[offset + length - 1 - offing] = swap;
            ++offing;
        }
    }

    public static void reverse(double[] array) {
        ArrayUtilities.reverse(array, 0, array.length);
    }

    public static double[] reversed(double[] input, int offset, int length) {
        double[] output = new double[input.length];
        int offing = 0;
        while (offing < length / 2) {
            output[offset + offing] = input[offset + length - 1 - offing];
            output[offset + length - 1 - offing] = input[offset + offing];
            ++offing;
        }
        return output;
    }

    public static double[] reversed(double[] array) {
        return ArrayUtilities.reversed(array, 0, array.length);
    }

    public static void reverse(long[] array, int offset, int length) {
        long swap = 0L;
        int offing = 0;
        while (offing < length / 2) {
            swap = array[offset + offing];
            array[offset + offing] = array[offset + length - 1 - offing];
            array[offset + length - 1 - offing] = swap;
            ++offing;
        }
    }

    public static void reverse(long[] array) {
        ArrayUtilities.reverse(array, 0, array.length);
    }

    public static long[] reversed(long[] input, int offset, int length) {
        long[] output = new long[input.length];
        int offing = 0;
        while (offing < length / 2) {
            output[offset + offing] = input[offset + length - 1 - offing];
            output[offset + length - 1 - offing] = input[offset + offing];
            ++offing;
        }
        return output;
    }

    public static long[] reversed(long[] array) {
        return ArrayUtilities.reversed(array, 0, array.length);
    }

    public static boolean[] getPrepopulatedArrayBoolean(int size, boolean value) {
        boolean[] a = new boolean[size];
        if (value) {
            Arrays.fill(a, value);
        }
        return a;
    }

    public static long[] getPrepopulatedArrayLong(int size, long value) {
        long[] a = new long[size];
        if (value != 0L) {
            Arrays.fill(a, value);
        }
        return a;
    }

    public static <E> E[][] deinterleaveToObjectArrays(E[] array, int interleavedBanks) {
        if (array.length % interleavedBanks != 0) {
            throw new NotYetImplementedException("interleaved array (which was length " + array.length + ") must be a multiple of number of interleaved banks! (which was " + interleavedBanks + ")  :[");
        }
        Object[][] deinterleaved = (Object[][])Array.newInstance(array.getClass().getComponentType(), interleavedBanks, array.length / interleavedBanks);
        int currentInterleave = 0;
        int i = 0;
        while (i < array.length) {
            deinterleaved[currentInterleave][i / interleavedBanks] = array[i];
            currentInterleave = (currentInterleave + 1) % interleavedBanks;
            ++i;
        }
        return deinterleaved;
    }

    public static boolean[][] deinterleave(boolean[] array, int interleavedBanks) {
        if (array.length % interleavedBanks != 0) {
            throw new NotYetImplementedException("interleaved array (which was length " + array.length + ") must be a multiple of number of interleaved banks! (which was " + interleavedBanks + ")  :[");
        }
        boolean[][] deinterleaved = new boolean[interleavedBanks][array.length / interleavedBanks];
        int currentInterleave = 0;
        int i = 0;
        while (i < array.length) {
            deinterleaved[currentInterleave][i / interleavedBanks] = array[i];
            currentInterleave = (currentInterleave + 1) % interleavedBanks;
            ++i;
        }
        return deinterleaved;
    }

    public static byte[][] deinterleave(byte[] array, int interleavedBanks) {
        if (array.length % interleavedBanks != 0) {
            throw new NotYetImplementedException("interleaved array (which was length " + array.length + ") must be a multiple of number of interleaved banks! (which was " + interleavedBanks + ")  :[");
        }
        byte[][] deinterleaved = new byte[interleavedBanks][array.length / interleavedBanks];
        int currentInterleave = 0;
        int i = 0;
        while (i < array.length) {
            deinterleaved[currentInterleave][i / interleavedBanks] = array[i];
            currentInterleave = (currentInterleave + 1) % interleavedBanks;
            ++i;
        }
        return deinterleaved;
    }

    public static char[][] deinterleave(char[] array, int interleavedBanks) {
        if (array.length % interleavedBanks != 0) {
            throw new NotYetImplementedException("interleaved array (which was length " + array.length + ") must be a multiple of number of interleaved banks! (which was " + interleavedBanks + ")  :[");
        }
        char[][] deinterleaved = new char[interleavedBanks][array.length / interleavedBanks];
        int currentInterleave = 0;
        int i = 0;
        while (i < array.length) {
            deinterleaved[currentInterleave][i / interleavedBanks] = array[i];
            currentInterleave = (currentInterleave + 1) % interleavedBanks;
            ++i;
        }
        return deinterleaved;
    }

    public static short[][] deinterleave(short[] array, int interleavedBanks) {
        if (array.length % interleavedBanks != 0) {
            throw new NotYetImplementedException("interleaved array (which was length " + array.length + ") must be a multiple of number of interleaved banks! (which was " + interleavedBanks + ")  :[");
        }
        short[][] deinterleaved = new short[interleavedBanks][array.length / interleavedBanks];
        int currentInterleave = 0;
        int i = 0;
        while (i < array.length) {
            deinterleaved[currentInterleave][i / interleavedBanks] = array[i];
            currentInterleave = (currentInterleave + 1) % interleavedBanks;
            ++i;
        }
        return deinterleaved;
    }

    public static float[][] deinterleave(float[] array, int interleavedBanks) {
        if (array.length % interleavedBanks != 0) {
            throw new NotYetImplementedException("interleaved array (which was length " + array.length + ") must be a multiple of number of interleaved banks! (which was " + interleavedBanks + ")  :[");
        }
        float[][] deinterleaved = new float[interleavedBanks][array.length / interleavedBanks];
        int currentInterleave = 0;
        int i = 0;
        while (i < array.length) {
            deinterleaved[currentInterleave][i / interleavedBanks] = array[i];
            currentInterleave = (currentInterleave + 1) % interleavedBanks;
            ++i;
        }
        return deinterleaved;
    }

    public static int[][] deinterleave(int[] array, int interleavedBanks) {
        if (array.length % interleavedBanks != 0) {
            throw new NotYetImplementedException("interleaved array (which was length " + array.length + ") must be a multiple of number of interleaved banks! (which was " + interleavedBanks + ")  :[");
        }
        int[][] deinterleaved = new int[interleavedBanks][array.length / interleavedBanks];
        int currentInterleave = 0;
        int i = 0;
        while (i < array.length) {
            deinterleaved[currentInterleave][i / interleavedBanks] = array[i];
            currentInterleave = (currentInterleave + 1) % interleavedBanks;
            ++i;
        }
        return deinterleaved;
    }

    public static double[][] deinterleave(double[] array, int interleavedBanks) {
        if (array.length % interleavedBanks != 0) {
            throw new NotYetImplementedException("interleaved array (which was length " + array.length + ") must be a multiple of number of interleaved banks! (which was " + interleavedBanks + ")  :[");
        }
        double[][] deinterleaved = new double[interleavedBanks][array.length / interleavedBanks];
        int currentInterleave = 0;
        int i = 0;
        while (i < array.length) {
            deinterleaved[currentInterleave][i / interleavedBanks] = array[i];
            currentInterleave = (currentInterleave + 1) % interleavedBanks;
            ++i;
        }
        return deinterleaved;
    }

    public static long[][] deinterleave(long[] array, int interleavedBanks) {
        if (array.length % interleavedBanks != 0) {
            throw new NotYetImplementedException("interleaved array (which was length " + array.length + ") must be a multiple of number of interleaved banks! (which was " + interleavedBanks + ")  :[");
        }
        long[][] deinterleaved = new long[interleavedBanks][array.length / interleavedBanks];
        int currentInterleave = 0;
        int i = 0;
        while (i < array.length) {
            deinterleaved[currentInterleave][i / interleavedBanks] = array[i];
            currentInterleave = (currentInterleave + 1) % interleavedBanks;
            ++i;
        }
        return deinterleaved;
    }

    public static boolean[] interleaveGeneral(boolean[][] banks, int[] fieldSizes) {
        int nFields = banks.length;
        if (fieldSizes.length != nFields) {
            throw new IllegalArgumentException();
        }
        if (nFields == 0) {
            return EmptyBooleanArray;
        }
        int nStructs = 0;
        int structSize = 0;
        int fieldIndex = 0;
        while (fieldIndex < nFields) {
            boolean[] bank = banks[fieldIndex];
            int bL = bank.length;
            int fieldSize = fieldSizes[fieldIndex];
            if (fieldIndex == 0) {
                if (bL % fieldSize != 0) {
                    throw new IllegalArgumentException();
                }
                nStructs = bL / fieldSize;
            } else if (fieldSize * nStructs != bL) {
                throw new IllegalArgumentException();
            }
            structSize += fieldSize;
            ++fieldIndex;
        }
        boolean[] interleaved = new boolean[nStructs * structSize];
        int fieldOffset = 0;
        int fieldIndex2 = 0;
        while (fieldIndex2 < nFields) {
            boolean[] bank = banks[fieldIndex2];
            int fieldSize = fieldSizes[fieldIndex2];
            int structIndex = 0;
            while (structIndex < nStructs) {
                System.arraycopy(bank, structIndex * fieldSize, interleaved, structIndex * structSize + fieldOffset, fieldSize);
                ++structIndex;
            }
            fieldOffset += fieldSize;
            ++fieldIndex2;
        }
        return interleaved;
    }

    public static byte[] interleaveGeneral(byte[][] banks, int[] fieldSizes) {
        int nFields = banks.length;
        if (fieldSizes.length != nFields) {
            throw new IllegalArgumentException();
        }
        if (nFields == 0) {
            return EmptyByteArray;
        }
        int nStructs = 0;
        int structSize = 0;
        int fieldIndex = 0;
        while (fieldIndex < nFields) {
            byte[] bank = banks[fieldIndex];
            int bL = bank.length;
            int fieldSize = fieldSizes[fieldIndex];
            if (fieldIndex == 0) {
                if (bL % fieldSize != 0) {
                    throw new IllegalArgumentException();
                }
                nStructs = bL / fieldSize;
            } else if (fieldSize * nStructs != bL) {
                throw new IllegalArgumentException();
            }
            structSize += fieldSize;
            ++fieldIndex;
        }
        byte[] interleaved = new byte[nStructs * structSize];
        int fieldOffset = 0;
        int fieldIndex2 = 0;
        while (fieldIndex2 < nFields) {
            byte[] bank = banks[fieldIndex2];
            int fieldSize = fieldSizes[fieldIndex2];
            int structIndex = 0;
            while (structIndex < nStructs) {
                System.arraycopy(bank, structIndex * fieldSize, interleaved, structIndex * structSize + fieldOffset, fieldSize);
                ++structIndex;
            }
            fieldOffset += fieldSize;
            ++fieldIndex2;
        }
        return interleaved;
    }

    public static char[] interleaveGeneral(char[][] banks, int[] fieldSizes) {
        int nFields = banks.length;
        if (fieldSizes.length != nFields) {
            throw new IllegalArgumentException();
        }
        if (nFields == 0) {
            return EmptyCharArray;
        }
        int nStructs = 0;
        int structSize = 0;
        int fieldIndex = 0;
        while (fieldIndex < nFields) {
            char[] bank = banks[fieldIndex];
            int bL = bank.length;
            int fieldSize = fieldSizes[fieldIndex];
            if (fieldIndex == 0) {
                if (bL % fieldSize != 0) {
                    throw new IllegalArgumentException();
                }
                nStructs = bL / fieldSize;
            } else if (fieldSize * nStructs != bL) {
                throw new IllegalArgumentException();
            }
            structSize += fieldSize;
            ++fieldIndex;
        }
        char[] interleaved = new char[nStructs * structSize];
        int fieldOffset = 0;
        int fieldIndex2 = 0;
        while (fieldIndex2 < nFields) {
            char[] bank = banks[fieldIndex2];
            int fieldSize = fieldSizes[fieldIndex2];
            int structIndex = 0;
            while (structIndex < nStructs) {
                System.arraycopy(bank, structIndex * fieldSize, interleaved, structIndex * structSize + fieldOffset, fieldSize);
                ++structIndex;
            }
            fieldOffset += fieldSize;
            ++fieldIndex2;
        }
        return interleaved;
    }

    public static short[] interleaveGeneral(short[][] banks, int[] fieldSizes) {
        int nFields = banks.length;
        if (fieldSizes.length != nFields) {
            throw new IllegalArgumentException();
        }
        if (nFields == 0) {
            return EmptyShortArray;
        }
        int nStructs = 0;
        int structSize = 0;
        int fieldIndex = 0;
        while (fieldIndex < nFields) {
            short[] bank = banks[fieldIndex];
            int bL = bank.length;
            int fieldSize = fieldSizes[fieldIndex];
            if (fieldIndex == 0) {
                if (bL % fieldSize != 0) {
                    throw new IllegalArgumentException();
                }
                nStructs = bL / fieldSize;
            } else if (fieldSize * nStructs != bL) {
                throw new IllegalArgumentException();
            }
            structSize += fieldSize;
            ++fieldIndex;
        }
        short[] interleaved = new short[nStructs * structSize];
        int fieldOffset = 0;
        int fieldIndex2 = 0;
        while (fieldIndex2 < nFields) {
            short[] bank = banks[fieldIndex2];
            int fieldSize = fieldSizes[fieldIndex2];
            int structIndex = 0;
            while (structIndex < nStructs) {
                System.arraycopy(bank, structIndex * fieldSize, interleaved, structIndex * structSize + fieldOffset, fieldSize);
                ++structIndex;
            }
            fieldOffset += fieldSize;
            ++fieldIndex2;
        }
        return interleaved;
    }

    public static float[] interleaveGeneral(float[][] banks, int[] fieldSizes) {
        int nFields = banks.length;
        if (fieldSizes.length != nFields) {
            throw new IllegalArgumentException();
        }
        if (nFields == 0) {
            return EmptyFloatArray;
        }
        int nStructs = 0;
        int structSize = 0;
        int fieldIndex = 0;
        while (fieldIndex < nFields) {
            float[] bank = banks[fieldIndex];
            int bL = bank.length;
            int fieldSize = fieldSizes[fieldIndex];
            if (fieldIndex == 0) {
                if (bL % fieldSize != 0) {
                    throw new IllegalArgumentException();
                }
                nStructs = bL / fieldSize;
            } else if (fieldSize * nStructs != bL) {
                throw new IllegalArgumentException();
            }
            structSize += fieldSize;
            ++fieldIndex;
        }
        float[] interleaved = new float[nStructs * structSize];
        int fieldOffset = 0;
        int fieldIndex2 = 0;
        while (fieldIndex2 < nFields) {
            float[] bank = banks[fieldIndex2];
            int fieldSize = fieldSizes[fieldIndex2];
            int structIndex = 0;
            while (structIndex < nStructs) {
                System.arraycopy(bank, structIndex * fieldSize, interleaved, structIndex * structSize + fieldOffset, fieldSize);
                ++structIndex;
            }
            fieldOffset += fieldSize;
            ++fieldIndex2;
        }
        return interleaved;
    }

    public static int[] interleaveGeneral(int[][] banks, int[] fieldSizes) {
        int nFields = banks.length;
        if (fieldSizes.length != nFields) {
            throw new IllegalArgumentException();
        }
        if (nFields == 0) {
            return EmptyIntArray;
        }
        int nStructs = 0;
        int structSize = 0;
        int fieldIndex = 0;
        while (fieldIndex < nFields) {
            int[] bank = banks[fieldIndex];
            int bL = bank.length;
            int fieldSize = fieldSizes[fieldIndex];
            if (fieldIndex == 0) {
                if (bL % fieldSize != 0) {
                    throw new IllegalArgumentException();
                }
                nStructs = bL / fieldSize;
            } else if (fieldSize * nStructs != bL) {
                throw new IllegalArgumentException();
            }
            structSize += fieldSize;
            ++fieldIndex;
        }
        int[] interleaved = new int[nStructs * structSize];
        int fieldOffset = 0;
        int fieldIndex2 = 0;
        while (fieldIndex2 < nFields) {
            int[] bank = banks[fieldIndex2];
            int fieldSize = fieldSizes[fieldIndex2];
            int structIndex = 0;
            while (structIndex < nStructs) {
                System.arraycopy(bank, structIndex * fieldSize, interleaved, structIndex * structSize + fieldOffset, fieldSize);
                ++structIndex;
            }
            fieldOffset += fieldSize;
            ++fieldIndex2;
        }
        return interleaved;
    }

    public static double[] interleaveGeneral(double[][] banks, int[] fieldSizes) {
        int nFields = banks.length;
        if (fieldSizes.length != nFields) {
            throw new IllegalArgumentException();
        }
        if (nFields == 0) {
            return EmptyDoubleArray;
        }
        int nStructs = 0;
        int structSize = 0;
        int fieldIndex = 0;
        while (fieldIndex < nFields) {
            double[] bank = banks[fieldIndex];
            int bL = bank.length;
            int fieldSize = fieldSizes[fieldIndex];
            if (fieldIndex == 0) {
                if (bL % fieldSize != 0) {
                    throw new IllegalArgumentException();
                }
                nStructs = bL / fieldSize;
            } else if (fieldSize * nStructs != bL) {
                throw new IllegalArgumentException();
            }
            structSize += fieldSize;
            ++fieldIndex;
        }
        double[] interleaved = new double[nStructs * structSize];
        int fieldOffset = 0;
        int fieldIndex2 = 0;
        while (fieldIndex2 < nFields) {
            double[] bank = banks[fieldIndex2];
            int fieldSize = fieldSizes[fieldIndex2];
            int structIndex = 0;
            while (structIndex < nStructs) {
                System.arraycopy(bank, structIndex * fieldSize, interleaved, structIndex * structSize + fieldOffset, fieldSize);
                ++structIndex;
            }
            fieldOffset += fieldSize;
            ++fieldIndex2;
        }
        return interleaved;
    }

    public static long[] interleaveGeneral(long[][] banks, int[] fieldSizes) {
        int nFields = banks.length;
        if (fieldSizes.length != nFields) {
            throw new IllegalArgumentException();
        }
        if (nFields == 0) {
            return EmptyLongArray;
        }
        int nStructs = 0;
        int structSize = 0;
        int fieldIndex = 0;
        while (fieldIndex < nFields) {
            long[] bank = banks[fieldIndex];
            int bL = bank.length;
            int fieldSize = fieldSizes[fieldIndex];
            if (fieldIndex == 0) {
                if (bL % fieldSize != 0) {
                    throw new IllegalArgumentException();
                }
                nStructs = bL / fieldSize;
            } else if (fieldSize * nStructs != bL) {
                throw new IllegalArgumentException();
            }
            structSize += fieldSize;
            ++fieldIndex;
        }
        long[] interleaved = new long[nStructs * structSize];
        int fieldOffset = 0;
        int fieldIndex2 = 0;
        while (fieldIndex2 < nFields) {
            long[] bank = banks[fieldIndex2];
            int fieldSize = fieldSizes[fieldIndex2];
            int structIndex = 0;
            while (structIndex < nStructs) {
                System.arraycopy(bank, structIndex * fieldSize, interleaved, structIndex * structSize + fieldOffset, fieldSize);
                ++structIndex;
            }
            fieldOffset += fieldSize;
            ++fieldIndex2;
        }
        return interleaved;
    }

    public static boolean[][] splitPartitions(boolean[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, true);
    }

    public static boolean[][] splitPartitionsLenient(boolean[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, false);
    }

    public static Slice<boolean[]>[] splitPartitionsLiveSlicesBoolean(Slice<boolean[]> concattedFlatArraySlice, int partitionSize) {
        return ArrayUtilities.splitPartitionsLiveSlicesBoolean(concattedFlatArraySlice, partitionSize, true);
    }

    public static boolean[][] splitPartitions(boolean[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsBoolean(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static Slice<boolean[]>[] splitPartitionsLiveSlicesBoolean(boolean[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesBoolean(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static boolean[][] splitPartitionsBoolean(Slice<boolean[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsBoolean(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static Slice<boolean[]>[] splitPartitionsLiveSlicesBoolean(Slice<boolean[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesBoolean(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static boolean[][] splitPartitionsBoolean(boolean[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        boolean[][] partitions = new boolean[nPartitions][];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            boolean[] partition = new boolean[partitionSizeThisIteration];
            System.arraycopy(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partition, 0, partitionSizeThisIteration);
            partitions[partitionIndex] = partition;
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static Slice<boolean[]>[] splitPartitionsLiveSlicesBoolean(boolean[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        Slice[] partitions = new Slice[nPartitions];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            Slice<boolean[]> partition;
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            partitions[partitionIndex] = partition = new Slice<boolean[]>(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partitionSizeThisIteration);
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static boolean[] concatArrays(boolean[] ... arrays) {
        int resultingLength = 0;
        boolean[][] blArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            boolean[] a = blArray[n2];
            resultingLength += a != null ? a.length : 0;
            ++n2;
        }
        boolean[] newArray = new boolean[resultingLength];
        int cursor = 0;
        boolean[][] blArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            boolean[] a = blArray2[n4];
            if (a != null && (l = a.length) != 0) {
                System.arraycopy(a, 0, newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static boolean[] concatArraySlicesBoolean(Slice<boolean[]> ... arraySlices) {
        int resultingLength = 0;
        Slice<boolean[]>[] sliceArray = arraySlices;
        int n = arraySlices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice<boolean[]> a = sliceArray[n2];
            resultingLength += a != null ? a.getLength() : 0;
            ++n2;
        }
        boolean[] newArray = new boolean[resultingLength];
        int cursor = 0;
        Slice<boolean[]>[] sliceArray2 = arraySlices;
        int n3 = arraySlices.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            Slice<boolean[]> a = sliceArray2[n4];
            if (a != null && (l = a.getLength()) != 0) {
                System.arraycopy(a.getUnderlying(), a.getOffset(), newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static byte[][] splitPartitions(byte[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, true);
    }

    public static byte[][] splitPartitionsLenient(byte[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, false);
    }

    public static Slice<byte[]>[] splitPartitionsLiveSlicesByte(Slice<byte[]> concattedFlatArraySlice, int partitionSize) {
        return ArrayUtilities.splitPartitionsLiveSlicesByte(concattedFlatArraySlice, partitionSize, true);
    }

    public static byte[][] splitPartitions(byte[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsByte(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static Slice<byte[]>[] splitPartitionsLiveSlicesByte(byte[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesByte(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static byte[][] splitPartitionsByte(Slice<byte[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsByte(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static Slice<byte[]>[] splitPartitionsLiveSlicesByte(Slice<byte[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesByte(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static byte[][] splitPartitionsByte(byte[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        byte[][] partitions = new byte[nPartitions][];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            byte[] partition = new byte[partitionSizeThisIteration];
            System.arraycopy(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partition, 0, partitionSizeThisIteration);
            partitions[partitionIndex] = partition;
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static Slice<byte[]>[] splitPartitionsLiveSlicesByte(byte[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        Slice[] partitions = new Slice[nPartitions];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            Slice<byte[]> partition;
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            partitions[partitionIndex] = partition = new Slice<byte[]>(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partitionSizeThisIteration);
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static byte[] concatArrays(byte[] ... arrays) {
        int resultingLength = 0;
        byte[][] byArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] a = byArray[n2];
            resultingLength += a != null ? a.length : 0;
            ++n2;
        }
        byte[] newArray = new byte[resultingLength];
        int cursor = 0;
        byte[][] byArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            byte[] a = byArray2[n4];
            if (a != null && (l = a.length) != 0) {
                System.arraycopy(a, 0, newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static byte[] concatArraySlicesByte(Slice<byte[]> ... arraySlices) {
        int resultingLength = 0;
        Slice<byte[]>[] sliceArray = arraySlices;
        int n = arraySlices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice<byte[]> a = sliceArray[n2];
            resultingLength += a != null ? a.getLength() : 0;
            ++n2;
        }
        byte[] newArray = new byte[resultingLength];
        int cursor = 0;
        Slice<byte[]>[] sliceArray2 = arraySlices;
        int n3 = arraySlices.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            Slice<byte[]> a = sliceArray2[n4];
            if (a != null && (l = a.getLength()) != 0) {
                System.arraycopy(a.getUnderlying(), a.getOffset(), newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static char[][] splitPartitions(char[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, true);
    }

    public static char[][] splitPartitionsLenient(char[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, false);
    }

    public static Slice<char[]>[] splitPartitionsLiveSlicesChar(Slice<char[]> concattedFlatArraySlice, int partitionSize) {
        return ArrayUtilities.splitPartitionsLiveSlicesChar(concattedFlatArraySlice, partitionSize, true);
    }

    public static char[][] splitPartitions(char[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsChar(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static Slice<char[]>[] splitPartitionsLiveSlicesChar(char[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesChar(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static char[][] splitPartitionsChar(Slice<char[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsChar(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static Slice<char[]>[] splitPartitionsLiveSlicesChar(Slice<char[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesChar(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static char[][] splitPartitionsChar(char[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        char[][] partitions = new char[nPartitions][];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            char[] partition = new char[partitionSizeThisIteration];
            System.arraycopy(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partition, 0, partitionSizeThisIteration);
            partitions[partitionIndex] = partition;
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static Slice<char[]>[] splitPartitionsLiveSlicesChar(char[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        Slice[] partitions = new Slice[nPartitions];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            Slice<char[]> partition;
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            partitions[partitionIndex] = partition = new Slice<char[]>(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partitionSizeThisIteration);
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static char[] concatArrays(char[] ... arrays) {
        int resultingLength = 0;
        char[][] cArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            char[] a = cArray[n2];
            resultingLength += a != null ? a.length : 0;
            ++n2;
        }
        char[] newArray = new char[resultingLength];
        int cursor = 0;
        char[][] cArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            char[] a = cArray2[n4];
            if (a != null && (l = a.length) != 0) {
                System.arraycopy(a, 0, newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static char[] concatArraySlicesChar(Slice<char[]> ... arraySlices) {
        int resultingLength = 0;
        Slice<char[]>[] sliceArray = arraySlices;
        int n = arraySlices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice<char[]> a = sliceArray[n2];
            resultingLength += a != null ? a.getLength() : 0;
            ++n2;
        }
        char[] newArray = new char[resultingLength];
        int cursor = 0;
        Slice<char[]>[] sliceArray2 = arraySlices;
        int n3 = arraySlices.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            Slice<char[]> a = sliceArray2[n4];
            if (a != null && (l = a.getLength()) != 0) {
                System.arraycopy(a.getUnderlying(), a.getOffset(), newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static short[][] splitPartitions(short[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, true);
    }

    public static short[][] splitPartitionsLenient(short[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, false);
    }

    public static Slice<short[]>[] splitPartitionsLiveSlicesShort(Slice<short[]> concattedFlatArraySlice, int partitionSize) {
        return ArrayUtilities.splitPartitionsLiveSlicesShort(concattedFlatArraySlice, partitionSize, true);
    }

    public static short[][] splitPartitions(short[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsShort(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static Slice<short[]>[] splitPartitionsLiveSlicesShort(short[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesShort(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static short[][] splitPartitionsShort(Slice<short[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsShort(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static Slice<short[]>[] splitPartitionsLiveSlicesShort(Slice<short[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesShort(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static short[][] splitPartitionsShort(short[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        short[][] partitions = new short[nPartitions][];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            short[] partition = new short[partitionSizeThisIteration];
            System.arraycopy(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partition, 0, partitionSizeThisIteration);
            partitions[partitionIndex] = partition;
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static Slice<short[]>[] splitPartitionsLiveSlicesShort(short[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        Slice[] partitions = new Slice[nPartitions];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            Slice<short[]> partition;
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            partitions[partitionIndex] = partition = new Slice<short[]>(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partitionSizeThisIteration);
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static short[] concatArrays(short[] ... arrays) {
        int resultingLength = 0;
        short[][] sArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            short[] a = sArray[n2];
            resultingLength += a != null ? a.length : 0;
            ++n2;
        }
        short[] newArray = new short[resultingLength];
        int cursor = 0;
        short[][] sArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            short[] a = sArray2[n4];
            if (a != null && (l = a.length) != 0) {
                System.arraycopy(a, 0, newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static short[] concatArraySlicesShort(Slice<short[]> ... arraySlices) {
        int resultingLength = 0;
        Slice<short[]>[] sliceArray = arraySlices;
        int n = arraySlices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice<short[]> a = sliceArray[n2];
            resultingLength += a != null ? a.getLength() : 0;
            ++n2;
        }
        short[] newArray = new short[resultingLength];
        int cursor = 0;
        Slice<short[]>[] sliceArray2 = arraySlices;
        int n3 = arraySlices.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            Slice<short[]> a = sliceArray2[n4];
            if (a != null && (l = a.getLength()) != 0) {
                System.arraycopy(a.getUnderlying(), a.getOffset(), newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static float[][] splitPartitions(float[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, true);
    }

    public static float[][] splitPartitionsLenient(float[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, false);
    }

    public static Slice<float[]>[] splitPartitionsLiveSlicesFloat(Slice<float[]> concattedFlatArraySlice, int partitionSize) {
        return ArrayUtilities.splitPartitionsLiveSlicesFloat(concattedFlatArraySlice, partitionSize, true);
    }

    public static float[][] splitPartitions(float[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsFloat(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static Slice<float[]>[] splitPartitionsLiveSlicesFloat(float[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesFloat(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static float[][] splitPartitionsFloat(Slice<float[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsFloat(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static Slice<float[]>[] splitPartitionsLiveSlicesFloat(Slice<float[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesFloat(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static float[][] splitPartitionsFloat(float[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        float[][] partitions = new float[nPartitions][];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            float[] partition = new float[partitionSizeThisIteration];
            System.arraycopy(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partition, 0, partitionSizeThisIteration);
            partitions[partitionIndex] = partition;
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static Slice<float[]>[] splitPartitionsLiveSlicesFloat(float[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        Slice[] partitions = new Slice[nPartitions];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            Slice<float[]> partition;
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            partitions[partitionIndex] = partition = new Slice<float[]>(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partitionSizeThisIteration);
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static float[] concatArrays(float[] ... arrays) {
        int resultingLength = 0;
        float[][] fArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            float[] a = fArray[n2];
            resultingLength += a != null ? a.length : 0;
            ++n2;
        }
        float[] newArray = new float[resultingLength];
        int cursor = 0;
        float[][] fArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            float[] a = fArray2[n4];
            if (a != null && (l = a.length) != 0) {
                System.arraycopy(a, 0, newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static float[] concatArraySlicesFloat(Slice<float[]> ... arraySlices) {
        int resultingLength = 0;
        Slice<float[]>[] sliceArray = arraySlices;
        int n = arraySlices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice<float[]> a = sliceArray[n2];
            resultingLength += a != null ? a.getLength() : 0;
            ++n2;
        }
        float[] newArray = new float[resultingLength];
        int cursor = 0;
        Slice<float[]>[] sliceArray2 = arraySlices;
        int n3 = arraySlices.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            Slice<float[]> a = sliceArray2[n4];
            if (a != null && (l = a.getLength()) != 0) {
                System.arraycopy(a.getUnderlying(), a.getOffset(), newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static int[][] splitPartitions(int[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, true);
    }

    public static int[][] splitPartitionsLenient(int[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, false);
    }

    public static Slice<int[]>[] splitPartitionsLiveSlicesInt(Slice<int[]> concattedFlatArraySlice, int partitionSize) {
        return ArrayUtilities.splitPartitionsLiveSlicesInt(concattedFlatArraySlice, partitionSize, true);
    }

    public static int[][] splitPartitions(int[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsInt(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static Slice<int[]>[] splitPartitionsLiveSlicesInt(int[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesInt(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static int[][] splitPartitionsInt(Slice<int[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsInt(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static Slice<int[]>[] splitPartitionsLiveSlicesInt(Slice<int[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesInt(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static int[][] splitPartitionsInt(int[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        int[][] partitions = new int[nPartitions][];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            int[] partition = new int[partitionSizeThisIteration];
            System.arraycopy(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partition, 0, partitionSizeThisIteration);
            partitions[partitionIndex] = partition;
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static Slice<int[]>[] splitPartitionsLiveSlicesInt(int[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        Slice[] partitions = new Slice[nPartitions];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            Slice<int[]> partition;
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            partitions[partitionIndex] = partition = new Slice<int[]>(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partitionSizeThisIteration);
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static int[] concatArrays(int[] ... arrays) {
        int resultingLength = 0;
        int[][] nArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            int[] a = nArray[n2];
            resultingLength += a != null ? a.length : 0;
            ++n2;
        }
        int[] newArray = new int[resultingLength];
        int cursor = 0;
        int[][] nArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            int[] a = nArray2[n4];
            if (a != null && (l = a.length) != 0) {
                System.arraycopy(a, 0, newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static int[] concatArraySlicesInt(Slice<int[]> ... arraySlices) {
        int resultingLength = 0;
        Slice<int[]>[] sliceArray = arraySlices;
        int n = arraySlices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice<int[]> a = sliceArray[n2];
            resultingLength += a != null ? a.getLength() : 0;
            ++n2;
        }
        int[] newArray = new int[resultingLength];
        int cursor = 0;
        Slice<int[]>[] sliceArray2 = arraySlices;
        int n3 = arraySlices.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            Slice<int[]> a = sliceArray2[n4];
            if (a != null && (l = a.getLength()) != 0) {
                System.arraycopy(a.getUnderlying(), a.getOffset(), newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static double[][] splitPartitions(double[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, true);
    }

    public static double[][] splitPartitionsLenient(double[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, false);
    }

    public static Slice<double[]>[] splitPartitionsLiveSlicesDouble(Slice<double[]> concattedFlatArraySlice, int partitionSize) {
        return ArrayUtilities.splitPartitionsLiveSlicesDouble(concattedFlatArraySlice, partitionSize, true);
    }

    public static double[][] splitPartitions(double[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsDouble(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static Slice<double[]>[] splitPartitionsLiveSlicesDouble(double[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesDouble(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static double[][] splitPartitionsDouble(Slice<double[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsDouble(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static Slice<double[]>[] splitPartitionsLiveSlicesDouble(Slice<double[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesDouble(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static double[][] splitPartitionsDouble(double[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        double[][] partitions = new double[nPartitions][];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            double[] partition = new double[partitionSizeThisIteration];
            System.arraycopy(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partition, 0, partitionSizeThisIteration);
            partitions[partitionIndex] = partition;
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static Slice<double[]>[] splitPartitionsLiveSlicesDouble(double[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        Slice[] partitions = new Slice[nPartitions];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            Slice<double[]> partition;
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            partitions[partitionIndex] = partition = new Slice<double[]>(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partitionSizeThisIteration);
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static double[] concatArrays(double[] ... arrays) {
        int resultingLength = 0;
        double[][] dArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            double[] a = dArray[n2];
            resultingLength += a != null ? a.length : 0;
            ++n2;
        }
        double[] newArray = new double[resultingLength];
        int cursor = 0;
        double[][] dArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            double[] a = dArray2[n4];
            if (a != null && (l = a.length) != 0) {
                System.arraycopy(a, 0, newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static double[] concatArraySlicesDouble(Slice<double[]> ... arraySlices) {
        int resultingLength = 0;
        Slice<double[]>[] sliceArray = arraySlices;
        int n = arraySlices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice<double[]> a = sliceArray[n2];
            resultingLength += a != null ? a.getLength() : 0;
            ++n2;
        }
        double[] newArray = new double[resultingLength];
        int cursor = 0;
        Slice<double[]>[] sliceArray2 = arraySlices;
        int n3 = arraySlices.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            Slice<double[]> a = sliceArray2[n4];
            if (a != null && (l = a.getLength()) != 0) {
                System.arraycopy(a.getUnderlying(), a.getOffset(), newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static long[][] splitPartitions(long[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, true);
    }

    public static long[][] splitPartitionsLenient(long[] concattedFlatArray, int partitionSize) {
        return ArrayUtilities.splitPartitions(concattedFlatArray, partitionSize, false);
    }

    public static Slice<long[]>[] splitPartitionsLiveSlicesLong(Slice<long[]> concattedFlatArraySlice, int partitionSize) {
        return ArrayUtilities.splitPartitionsLiveSlicesLong(concattedFlatArraySlice, partitionSize, true);
    }

    public static long[][] splitPartitions(long[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLong(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static Slice<long[]>[] splitPartitionsLiveSlicesLong(long[] concattedFlatArray, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesLong(concattedFlatArray, 0, concattedFlatArray.length, partitionSize, requireExact);
    }

    public static long[][] splitPartitionsLong(Slice<long[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLong(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static Slice<long[]>[] splitPartitionsLiveSlicesLong(Slice<long[]> concattedFlatArraySlice, int partitionSize, boolean requireExact) {
        return ArrayUtilities.splitPartitionsLiveSlicesLong(concattedFlatArraySlice.getUnderlying(), concattedFlatArraySlice.getOffset(), concattedFlatArraySlice.getLength(), partitionSize, requireExact);
    }

    public static long[][] splitPartitionsLong(long[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        long[][] partitions = new long[nPartitions][];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            long[] partition = new long[partitionSizeThisIteration];
            System.arraycopy(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partition, 0, partitionSizeThisIteration);
            partitions[partitionIndex] = partition;
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static Slice<long[]>[] splitPartitionsLiveSlicesLong(long[] concattedFlatArray, int concattedFlatArrayOffset, int concattedFlatArrayLength, int partitionSize, boolean requireExact) {
        if (partitionSize < 1) {
            throw new IllegalArgumentException();
        }
        int nElements = concattedFlatArrayLength;
        if (requireExact && nElements % partitionSize != 0) {
            throw new IllegalArgumentException("Tried to split an array " + nElements + " elements long into equal partitions each " + partitionSize + " elements long!!");
        }
        int nPartitions = SmallIntegerMathUtilities.ceilingDivision(nElements, partitionSize);
        Slice[] partitions = new Slice[nPartitions];
        int baseInFlatArray = 0;
        int partitionIndex = 0;
        while (partitionIndex < nPartitions) {
            Slice<long[]> partition;
            int partitionSizeThisIteration = SmallIntegerMathUtilities.least(partitionSize, nElements - baseInFlatArray);
            partitions[partitionIndex] = partition = new Slice<long[]>(concattedFlatArray, concattedFlatArrayOffset + baseInFlatArray, partitionSizeThisIteration);
            baseInFlatArray += partitionSize;
            ++partitionIndex;
        }
        return partitions;
    }

    public static long[] concatArrays(long[] ... arrays) {
        int resultingLength = 0;
        long[][] lArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            long[] a = lArray[n2];
            resultingLength += a != null ? a.length : 0;
            ++n2;
        }
        long[] newArray = new long[resultingLength];
        int cursor = 0;
        long[][] lArray2 = arrays;
        int n3 = arrays.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            long[] a = lArray2[n4];
            if (a != null && (l = a.length) != 0) {
                System.arraycopy(a, 0, newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static long[] concatArraySlicesLong(Slice<long[]> ... arraySlices) {
        int resultingLength = 0;
        Slice<long[]>[] sliceArray = arraySlices;
        int n = arraySlices.length;
        int n2 = 0;
        while (n2 < n) {
            Slice<long[]> a = sliceArray[n2];
            resultingLength += a != null ? a.getLength() : 0;
            ++n2;
        }
        long[] newArray = new long[resultingLength];
        int cursor = 0;
        Slice<long[]>[] sliceArray2 = arraySlices;
        int n3 = arraySlices.length;
        int n4 = 0;
        while (n4 < n3) {
            int l;
            Slice<long[]> a = sliceArray2[n4];
            if (a != null && (l = a.getLength()) != 0) {
                System.arraycopy(a.getUnderlying(), a.getOffset(), newArray, cursor, l);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return newArray;
    }

    public static int[] sortAndUniqueify(int[] raw) {
        int[] sorted = null;
        sorted = new int[raw.length];
        System.arraycopy(raw, 0, sorted, 0, sorted.length);
        Arrays.sort(sorted);
        int[] uniques = new int[sorted.length];
        int uniqueCount = 0;
        boolean hasLast = false;
        int last = 0;
        int[] nArray = sorted;
        int n = sorted.length;
        int n2 = 0;
        while (n2 < n) {
            int currentValue = nArray[n2];
            if (!hasLast || last != currentValue) {
                uniques[uniqueCount] = currentValue;
                ++uniqueCount;
            }
            hasLast = true;
            last = currentValue;
            ++n2;
        }
        int[] trimmed = new int[uniqueCount];
        System.arraycopy(uniques, 0, trimmed, 0, uniqueCount);
        return trimmed;
    }

    public static double[] sortAndUniqueify(double[] raw) {
        double[] sorted = null;
        sorted = new double[raw.length];
        System.arraycopy(raw, 0, sorted, 0, sorted.length);
        Arrays.sort(sorted);
        double[] uniques = new double[sorted.length];
        int uniqueCount = 0;
        boolean hasLast = false;
        double last = 0.0;
        double[] dArray = sorted;
        int n = sorted.length;
        int n2 = 0;
        while (n2 < n) {
            double currentValue = dArray[n2];
            if (!hasLast || last != currentValue) {
                uniques[uniqueCount] = currentValue;
                ++uniqueCount;
            }
            hasLast = true;
            last = currentValue;
            ++n2;
        }
        double[] trimmed = new double[uniqueCount];
        System.arraycopy(uniques, 0, trimmed, 0, uniqueCount);
        return trimmed;
    }

    public static <E> E[] sortedArray(E[] array) {
        Object[] newArray = (Object[])array.clone();
        Arrays.sort(newArray);
        return newArray;
    }

    public static <E> E[] sortedArray(E[] array, Comparator<? super E> comparator) {
        Object[] newArray = (Object[])array.clone();
        Arrays.sort(newArray, comparator);
        return newArray;
    }

    public static void sort(boolean[] array) {
        int i;
        int srclen = array.length;
        int trueCount = 0;
        boolean[] blArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            boolean e = blArray[n2];
            if (e) {
                ++trueCount;
            }
            ++n2;
        }
        if (srclen - trueCount > 0) {
            i = 0;
            while (i < srclen - trueCount) {
                array[i] = false;
                ++i;
            }
        }
        if (trueCount > 0) {
            i = trueCount;
            while (i < srclen) {
                array[i] = true;
                ++i;
            }
        }
    }

    public static boolean[] sorted(boolean[] src) {
        int srclen = src.length;
        int trueCount = 0;
        boolean[] blArray = src;
        int n = src.length;
        int n2 = 0;
        while (n2 < n) {
            boolean e = blArray[n2];
            if (e) {
                ++trueCount;
            }
            ++n2;
        }
        boolean[] newArray = new boolean[srclen];
        if (trueCount > 0) {
            int i = trueCount;
            while (i < srclen) {
                newArray[i] = true;
                ++i;
            }
        }
        return newArray;
    }

    public static byte[] sorted(byte[] src) {
        byte[] newArray = new byte[src.length];
        System.arraycopy(src, 0, newArray, 0, src.length);
        Arrays.sort(newArray);
        return newArray;
    }

    public static char[] sorted(char[] src) {
        char[] newArray = new char[src.length];
        System.arraycopy(src, 0, newArray, 0, src.length);
        Arrays.sort(newArray);
        return newArray;
    }

    public static short[] sorted(short[] src) {
        short[] newArray = new short[src.length];
        System.arraycopy(src, 0, newArray, 0, src.length);
        Arrays.sort(newArray);
        return newArray;
    }

    public static float[] sorted(float[] src) {
        float[] newArray = new float[src.length];
        System.arraycopy(src, 0, newArray, 0, src.length);
        Arrays.sort(newArray);
        return newArray;
    }

    public static int[] sorted(int[] src) {
        int[] newArray = new int[src.length];
        System.arraycopy(src, 0, newArray, 0, src.length);
        Arrays.sort(newArray);
        return newArray;
    }

    public static double[] sorted(double[] src) {
        double[] newArray = new double[src.length];
        System.arraycopy(src, 0, newArray, 0, src.length);
        Arrays.sort(newArray);
        return newArray;
    }

    public static long[] sorted(long[] src) {
        long[] newArray = new long[src.length];
        System.arraycopy(src, 0, newArray, 0, src.length);
        Arrays.sort(newArray);
        return newArray;
    }

    public static <E> E[] uniqed(E[] input, EqualityComparator<E> equalityComparator) {
        if (input == null) {
            return null;
        }
        Object[] outputUntrimmed = (Object[])Array.newInstance(input.getClass().getComponentType(), input.length);
        int outputSize = 0;
        Object last = null;
        boolean hasLast = false;
        int i = 0;
        while (i < input.length) {
            if (!hasLast) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
                hasLast = true;
            } else if (!equalityComparator.equals(input[i], last)) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
            }
            ++i;
        }
        Object[] outputTrimmed = outputSize == outputUntrimmed.length ? outputUntrimmed : Arrays.copyOf(outputUntrimmed, outputSize);
        return outputTrimmed;
    }

    public static <E> E[] uniqed(E[] input) {
        return ArrayUtilities.uniqed(input, BasicObjectUtilities.getNaturalEqualityComparator());
    }

    public static boolean[] uniqed(boolean[] input) {
        if (input == null) {
            return null;
        }
        boolean[] outputUntrimmed = new boolean[input.length];
        int outputSize = 0;
        boolean last = false;
        boolean hasLast = false;
        int i = 0;
        while (i < input.length) {
            if (!hasLast) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
                hasLast = true;
            } else if (input[i] != last) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
            }
            ++i;
        }
        boolean[] outputTrimmed = outputSize == outputUntrimmed.length ? outputUntrimmed : Arrays.copyOf(outputUntrimmed, outputSize);
        return outputTrimmed;
    }

    public static byte[] uniqed(byte[] input) {
        if (input == null) {
            return null;
        }
        byte[] outputUntrimmed = new byte[input.length];
        int outputSize = 0;
        byte last = 0;
        boolean hasLast = false;
        int i = 0;
        while (i < input.length) {
            if (!hasLast) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
                hasLast = true;
            } else if (input[i] != last) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
            }
            ++i;
        }
        byte[] outputTrimmed = outputSize == outputUntrimmed.length ? outputUntrimmed : Arrays.copyOf(outputUntrimmed, outputSize);
        return outputTrimmed;
    }

    public static char[] uniqed(char[] input) {
        if (input == null) {
            return null;
        }
        char[] outputUntrimmed = new char[input.length];
        int outputSize = 0;
        char last = '\u0000';
        boolean hasLast = false;
        int i = 0;
        while (i < input.length) {
            if (!hasLast) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
                hasLast = true;
            } else if (input[i] != last) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
            }
            ++i;
        }
        char[] outputTrimmed = outputSize == outputUntrimmed.length ? outputUntrimmed : Arrays.copyOf(outputUntrimmed, outputSize);
        return outputTrimmed;
    }

    public static short[] uniqed(short[] input) {
        if (input == null) {
            return null;
        }
        short[] outputUntrimmed = new short[input.length];
        int outputSize = 0;
        short last = 0;
        boolean hasLast = false;
        int i = 0;
        while (i < input.length) {
            if (!hasLast) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
                hasLast = true;
            } else if (input[i] != last) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
            }
            ++i;
        }
        short[] outputTrimmed = outputSize == outputUntrimmed.length ? outputUntrimmed : Arrays.copyOf(outputUntrimmed, outputSize);
        return outputTrimmed;
    }

    public static float[] uniqed(float[] input) {
        if (input == null) {
            return null;
        }
        float[] outputUntrimmed = new float[input.length];
        int outputSize = 0;
        float last = 0.0f;
        boolean hasLast = false;
        int i = 0;
        while (i < input.length) {
            if (!hasLast) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
                hasLast = true;
            } else if (input[i] != last) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
            }
            ++i;
        }
        float[] outputTrimmed = outputSize == outputUntrimmed.length ? outputUntrimmed : Arrays.copyOf(outputUntrimmed, outputSize);
        return outputTrimmed;
    }

    public static int[] uniqed(int[] input) {
        if (input == null) {
            return null;
        }
        int[] outputUntrimmed = new int[input.length];
        int outputSize = 0;
        int last = 0;
        boolean hasLast = false;
        int i = 0;
        while (i < input.length) {
            if (!hasLast) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
                hasLast = true;
            } else if (input[i] != last) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
            }
            ++i;
        }
        int[] outputTrimmed = outputSize == outputUntrimmed.length ? outputUntrimmed : Arrays.copyOf(outputUntrimmed, outputSize);
        return outputTrimmed;
    }

    public static double[] uniqed(double[] input) {
        if (input == null) {
            return null;
        }
        double[] outputUntrimmed = new double[input.length];
        int outputSize = 0;
        double last = 0.0;
        boolean hasLast = false;
        int i = 0;
        while (i < input.length) {
            if (!hasLast) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
                hasLast = true;
            } else if (input[i] != last) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
            }
            ++i;
        }
        double[] outputTrimmed = outputSize == outputUntrimmed.length ? outputUntrimmed : Arrays.copyOf(outputUntrimmed, outputSize);
        return outputTrimmed;
    }

    public static long[] uniqed(long[] input) {
        if (input == null) {
            return null;
        }
        long[] outputUntrimmed = new long[input.length];
        int outputSize = 0;
        long last = 0L;
        boolean hasLast = false;
        int i = 0;
        while (i < input.length) {
            if (!hasLast) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
                hasLast = true;
            } else if (input[i] != last) {
                outputUntrimmed[outputSize] = input[i];
                ++outputSize;
                last = input[i];
            }
            ++i;
        }
        long[] outputTrimmed = outputSize == outputUntrimmed.length ? outputUntrimmed : Arrays.copyOf(outputUntrimmed, outputSize);
        return outputTrimmed;
    }

    public static <E> void fillArrayReference(E[] array, int offset, int length, E value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            array[i] = value;
            ++i;
        }
    }

    public static <E> void fillArrayReference(E[] array, E value) {
        ArrayUtilities.fillArrayReference(array, 0, array.length, value);
    }

    public static Object[] newfillArrayObject(int length, Object value) {
        Object[] array = new Object[length];
        if (value != null) {
            ArrayUtilities.fillArrayReference(array, value);
        }
        return array;
    }

    public static <T> T[] newfillArray(int length, T value, Class<T> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, length);
        int i = 0;
        while (i < length) {
            Array.set(array, i, value);
            ++i;
        }
        return array;
    }

    public static void fillArrayBoolean(boolean[] array, int offset, int length, boolean value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            array[i] = value;
            ++i;
        }
    }

    public static void fillArrayBoolean(boolean[] array, boolean value) {
        ArrayUtilities.fillArrayBoolean(array, 0, array.length, value);
    }

    public static boolean[] newfillArrayBoolean(int length, boolean value) {
        boolean[] array = new boolean[length];
        if (value) {
            ArrayUtilities.fillArrayBoolean(array, 0, length, value);
        }
        return array;
    }

    public static void fillArraySliceBoolean(@Nonnull Slice<boolean[]> arraySlice, boolean value) {
        ArrayUtilities.fillArrayBoolean(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength(), value);
    }

    @Nonnull
    public static Slice<boolean[]> newfillArraySliceBoolean(int length, boolean value) {
        return ArrayUtilities.wholeArraySliceBoolean(ArrayUtilities.newfillArrayBoolean(length, value));
    }

    public static void fillArrayByte(byte[] array, int offset, int length, byte value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            array[i] = value;
            ++i;
        }
    }

    public static void fillArrayByte(byte[] array, byte value) {
        ArrayUtilities.fillArrayByte(array, 0, array.length, value);
    }

    public static byte[] newfillArrayByte(int length, byte value) {
        byte[] array = new byte[length];
        if (value != 0) {
            ArrayUtilities.fillArrayByte(array, 0, length, value);
        }
        return array;
    }

    public static void fillArraySliceByte(@Nonnull Slice<byte[]> arraySlice, byte value) {
        ArrayUtilities.fillArrayByte(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength(), value);
    }

    @Nonnull
    public static Slice<byte[]> newfillArraySliceByte(int length, byte value) {
        return ArrayUtilities.wholeArraySliceByte(ArrayUtilities.newfillArrayByte(length, value));
    }

    public static void fillArrayChar(char[] array, int offset, int length, char value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            array[i] = value;
            ++i;
        }
    }

    public static void fillArrayChar(char[] array, char value) {
        ArrayUtilities.fillArrayChar(array, 0, array.length, value);
    }

    public static char[] newfillArrayChar(int length, char value) {
        char[] array = new char[length];
        if (value != '\u0000') {
            ArrayUtilities.fillArrayChar(array, 0, length, value);
        }
        return array;
    }

    public static void fillArraySliceChar(@Nonnull Slice<char[]> arraySlice, char value) {
        ArrayUtilities.fillArrayChar(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength(), value);
    }

    @Nonnull
    public static Slice<char[]> newfillArraySliceChar(int length, char value) {
        return ArrayUtilities.wholeArraySliceChar(ArrayUtilities.newfillArrayChar(length, value));
    }

    public static void fillArrayShort(short[] array, int offset, int length, short value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            array[i] = value;
            ++i;
        }
    }

    public static void fillArrayShort(short[] array, short value) {
        ArrayUtilities.fillArrayShort(array, 0, array.length, value);
    }

    public static short[] newfillArrayShort(int length, short value) {
        short[] array = new short[length];
        if (value != 0) {
            ArrayUtilities.fillArrayShort(array, 0, length, value);
        }
        return array;
    }

    public static void fillArraySliceShort(@Nonnull Slice<short[]> arraySlice, short value) {
        ArrayUtilities.fillArrayShort(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength(), value);
    }

    @Nonnull
    public static Slice<short[]> newfillArraySliceShort(int length, short value) {
        return ArrayUtilities.wholeArraySliceShort(ArrayUtilities.newfillArrayShort(length, value));
    }

    public static void fillArrayFloat(float[] array, int offset, int length, float value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            array[i] = value;
            ++i;
        }
    }

    public static void fillArrayFloat(float[] array, float value) {
        ArrayUtilities.fillArrayFloat(array, 0, array.length, value);
    }

    public static float[] newfillArrayFloat(int length, float value) {
        float[] array = new float[length];
        if (value != 0.0f) {
            ArrayUtilities.fillArrayFloat(array, 0, length, value);
        }
        return array;
    }

    public static void fillArraySliceFloat(@Nonnull Slice<float[]> arraySlice, float value) {
        ArrayUtilities.fillArrayFloat(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength(), value);
    }

    @Nonnull
    public static Slice<float[]> newfillArraySliceFloat(int length, float value) {
        return ArrayUtilities.wholeArraySliceFloat(ArrayUtilities.newfillArrayFloat(length, value));
    }

    public static void fillArrayInt(int[] array, int offset, int length, int value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            array[i] = value;
            ++i;
        }
    }

    public static void fillArrayInt(int[] array, int value) {
        ArrayUtilities.fillArrayInt(array, 0, array.length, value);
    }

    public static int[] newfillArrayInt(int length, int value) {
        int[] array = new int[length];
        if (value != 0) {
            ArrayUtilities.fillArrayInt(array, 0, length, value);
        }
        return array;
    }

    public static void fillArraySliceInt(@Nonnull Slice<int[]> arraySlice, int value) {
        ArrayUtilities.fillArrayInt(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength(), value);
    }

    @Nonnull
    public static Slice<int[]> newfillArraySliceInt(int length, int value) {
        return ArrayUtilities.wholeArraySliceInt(ArrayUtilities.newfillArrayInt(length, value));
    }

    public static void fillArrayDouble(double[] array, int offset, int length, double value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            array[i] = value;
            ++i;
        }
    }

    public static void fillArrayDouble(double[] array, double value) {
        ArrayUtilities.fillArrayDouble(array, 0, array.length, value);
    }

    public static double[] newfillArrayDouble(int length, double value) {
        double[] array = new double[length];
        if (value != 0.0) {
            ArrayUtilities.fillArrayDouble(array, 0, length, value);
        }
        return array;
    }

    public static void fillArraySliceDouble(@Nonnull Slice<double[]> arraySlice, double value) {
        ArrayUtilities.fillArrayDouble(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength(), value);
    }

    @Nonnull
    public static Slice<double[]> newfillArraySliceDouble(int length, double value) {
        return ArrayUtilities.wholeArraySliceDouble(ArrayUtilities.newfillArrayDouble(length, value));
    }

    public static void fillArrayLong(long[] array, int offset, int length, long value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            array[i] = value;
            ++i;
        }
    }

    public static void fillArrayLong(long[] array, long value) {
        ArrayUtilities.fillArrayLong(array, 0, array.length, value);
    }

    public static long[] newfillArrayLong(int length, long value) {
        long[] array = new long[length];
        if (value != 0L) {
            ArrayUtilities.fillArrayLong(array, 0, length, value);
        }
        return array;
    }

    public static void fillArraySliceLong(@Nonnull Slice<long[]> arraySlice, long value) {
        ArrayUtilities.fillArrayLong(arraySlice.getUnderlying(), arraySlice.getOffset(), arraySlice.getLength(), value);
    }

    @Nonnull
    public static Slice<long[]> newfillArraySliceLong(int length, long value) {
        return ArrayUtilities.wholeArraySliceLong(ArrayUtilities.newfillArrayLong(length, value));
    }

    public static EqualityComparator<boolean[]> getBooleanArrayEqualityComparator() {
        return BooleanArrayEqualityComparator;
    }

    public static EqualityComparator<byte[]> getByteArrayEqualityComparator() {
        return ByteArrayEqualityComparator;
    }

    public static EqualityComparator<short[]> getShortArrayEqualityComparator() {
        return ShortArrayEqualityComparator;
    }

    public static EqualityComparator<char[]> getCharArrayEqualityComparator() {
        return CharArrayEqualityComparator;
    }

    public static EqualityComparator<int[]> getIntArrayEqualityComparator() {
        return IntArrayEqualityComparator;
    }

    public static EqualityComparator<float[]> getFloatArrayEqualityComparator() {
        return FloatArrayEqualityComparator;
    }

    public static EqualityComparator<long[]> getLongArrayEqualityComparator() {
        return LongArrayEqualityComparator;
    }

    public static EqualityComparator<double[]> getDoubleArrayEqualityComparator() {
        return DoubleArrayEqualityComparator;
    }

    public static EqualityComparator<Object[]> getObjectArrayShallowEqualityComparator() {
        return ObjectArrayShallowEqualityComparator;
    }

    public static EqualityComparator<Object[]> getObjectArrayDeepEqualityComparator() {
        return ObjectArrayDeepEqualityComparator;
    }

    public static EqualityComparator getDynamicArrayShallowEqualityComparator() {
        return DynamicArrayShallowEqualityComparator;
    }

    public static EqualityComparator getDynamicArrayDeepEqualityComparator() {
        return DynamicArrayShallowEqualityComparator;
    }

    public static EqualityComparator getPrimitiveOrShallowEqualityComparator(Class componentType) {
        if (componentType == null) {
            throw new NullPointerException();
        }
        if (componentType == Void.class) {
            throw new IllegalArgumentException();
        }
        if (componentType == Boolean.TYPE) {
            return ArrayUtilities.getBooleanArrayEqualityComparator();
        }
        if (componentType == Byte.TYPE) {
            return ArrayUtilities.getByteArrayEqualityComparator();
        }
        if (componentType == Short.TYPE) {
            return ArrayUtilities.getShortArrayEqualityComparator();
        }
        if (componentType == Character.TYPE) {
            return ArrayUtilities.getCharArrayEqualityComparator();
        }
        if (componentType == Integer.TYPE) {
            return ArrayUtilities.getIntArrayEqualityComparator();
        }
        if (componentType == Float.TYPE) {
            return ArrayUtilities.getFloatArrayEqualityComparator();
        }
        if (componentType == Long.TYPE) {
            return ArrayUtilities.getLongArrayEqualityComparator();
        }
        if (componentType == Double.TYPE) {
            return ArrayUtilities.getDoubleArrayEqualityComparator();
        }
        return ArrayUtilities.getObjectArrayShallowEqualityComparator();
    }

    public static EqualityComparator getPrimitiveOrDeepEqualityComparator(Class componentType) {
        if (componentType == null) {
            throw new NullPointerException();
        }
        if (componentType == Void.class) {
            throw new IllegalArgumentException();
        }
        if (componentType == Boolean.TYPE) {
            return ArrayUtilities.getBooleanArrayEqualityComparator();
        }
        if (componentType == Byte.TYPE) {
            return ArrayUtilities.getByteArrayEqualityComparator();
        }
        if (componentType == Short.TYPE) {
            return ArrayUtilities.getShortArrayEqualityComparator();
        }
        if (componentType == Character.TYPE) {
            return ArrayUtilities.getCharArrayEqualityComparator();
        }
        if (componentType == Integer.TYPE) {
            return ArrayUtilities.getIntArrayEqualityComparator();
        }
        if (componentType == Float.TYPE) {
            return ArrayUtilities.getFloatArrayEqualityComparator();
        }
        if (componentType == Long.TYPE) {
            return ArrayUtilities.getLongArrayEqualityComparator();
        }
        if (componentType == Double.TYPE) {
            return ArrayUtilities.getDoubleArrayEqualityComparator();
        }
        return ArrayUtilities.getObjectArrayDeepEqualityComparator();
    }

    @Nonnull
    @PossiblySnapshotPossiblyLiveValue
    public static Object[] concatArraysToObjectArray(Object[] ... arrays) {
        if (arrays == null || arrays.length == 0) {
            return EmptyObjectArray;
        }
        int totalSize = 0;
        int indexOfFirstNonempty = -1;
        int indexOfLastNonempty = -1;
        int i = 0;
        while (i < arrays.length) {
            Object[] a = arrays[i];
            if (a != null && a.length != 0) {
                if (indexOfFirstNonempty == -1) {
                    indexOfFirstNonempty = i;
                }
                indexOfLastNonempty = i;
                totalSize += a.length;
            }
            ++i;
        }
        if (totalSize == 0) {
            return EmptyObjectArray;
        }
        assert (indexOfFirstNonempty != -1 && indexOfLastNonempty != -1);
        assert (arrays[indexOfFirstNonempty].length <= totalSize);
        if (arrays[indexOfFirstNonempty].length == totalSize) {
            return arrays[indexOfFirstNonempty];
        }
        Object[] mergedArray = new Object[totalSize];
        int position = 0;
        int i2 = indexOfFirstNonempty;
        while (i2 <= indexOfLastNonempty) {
            Object[] a = arrays[i2];
            System.arraycopy(a, 0, mergedArray, position, a.length);
            position += a.length;
            ++i2;
        }
        return mergedArray;
    }

    public static <E> E concatGeneralArrays(E ... arrays) {
        Class<?> componentType = null;
        E[] EArray = arrays;
        int n = arrays.length;
        int n2 = 0;
        while (n2 < n) {
            E a = EArray[n2];
            if (a != null) {
                if (!a.getClass().isArray()) {
                    throw new IllegalArgumentException();
                }
                componentType = a.getClass().getComponentType();
                break;
            }
            ++n2;
        }
        if (componentType == null) {
            return null;
        }
        return ArrayUtilities.concatGeneralArraysExplicitReturnComponentType(componentType, arrays);
    }

    public static <E> E concatGeneralArraysExplicitReturnComponentType(Class componentType, E ... arrays) {
        if (componentType == Boolean.TYPE) {
            return (E)ArrayUtilities.concatArrays((boolean[][])arrays);
        }
        if (componentType == Byte.TYPE) {
            return (E)ArrayUtilities.concatArrays((byte[][])arrays);
        }
        if (componentType == Character.TYPE) {
            return (E)ArrayUtilities.concatArrays((char[][])arrays);
        }
        if (componentType == Short.TYPE) {
            return (E)ArrayUtilities.concatArrays((short[][])arrays);
        }
        if (componentType == Float.TYPE) {
            return (E)ArrayUtilities.concatArrays((float[][])arrays);
        }
        if (componentType == Integer.TYPE) {
            return (E)ArrayUtilities.concatArrays((int[][])arrays);
        }
        if (componentType == Double.TYPE) {
            return (E)ArrayUtilities.concatArrays((double[][])arrays);
        }
        if (componentType == Long.TYPE) {
            return (E)ArrayUtilities.concatArrays((long[][])arrays);
        }
        int resultingLength = 0;
        Object[][] objectArray = (Object[][])arrays;
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] a = objectArray[n2];
            resultingLength += a != null ? a.length : 0;
            ++n2;
        }
        Object[] newArray = (Object[])Array.newInstance(componentType, resultingLength);
        int cursor = 0;
        Object[][] objectArray2 = (Object[][])arrays;
        int n3 = objectArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            Object[] a = objectArray2[n4];
            if (a != null && a.length != 0) {
                System.arraycopy(a, 0, newArray, cursor, a.length);
            }
            cursor += a != null ? a.length : 0;
            ++n4;
        }
        return (E)newArray;
    }

    public static <E> E[] concatArrays(E[] ... arrays) {
        return (Object[])ArrayUtilities.concatGeneralArrays(arrays);
    }

    public static <E> E[] concatArraysExplicitReturnComponentType(Class componentType, E[] ... arrays) {
        return (Object[])ArrayUtilities.concatGeneralArraysExplicitReturnComponentType(componentType, arrays);
    }

    public static <E> E[] concatArrayWith1(E[] array, E singleton) {
        E[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = singleton;
        return newArray;
    }

    public static boolean[] concatArrayWith1(boolean[] array, boolean singleton) {
        boolean[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = singleton;
        return newArray;
    }

    public static byte[] concatArrayWith1(byte[] array, byte singleton) {
        byte[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = singleton;
        return newArray;
    }

    public static char[] concatArrayWith1(char[] array, char singleton) {
        char[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = singleton;
        return newArray;
    }

    public static short[] concatArrayWith1(short[] array, short singleton) {
        short[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = singleton;
        return newArray;
    }

    public static float[] concatArrayWith1(float[] array, float singleton) {
        float[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = singleton;
        return newArray;
    }

    public static int[] concatArrayWith1(int[] array, int singleton) {
        int[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = singleton;
        return newArray;
    }

    public static double[] concatArrayWith1(double[] array, double singleton) {
        double[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = singleton;
        return newArray;
    }

    public static long[] concatArrayWith1(long[] array, long singleton) {
        long[] newArray = Arrays.copyOf(array, array.length + 1);
        newArray[array.length] = singleton;
        return newArray;
    }

    public static <E> E[] concat1WithArray(E singleton, E[] array) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 1);
        newArray[0] = singleton;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static boolean[] concat1WithArray(boolean singleton, boolean[] array) {
        boolean[] newArray = new boolean[array.length + 1];
        newArray[0] = singleton;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static byte[] concat1WithArray(byte singleton, byte[] array) {
        byte[] newArray = new byte[array.length + 1];
        newArray[0] = singleton;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static short[] concat1WithArray(short singleton, short[] array) {
        short[] newArray = new short[array.length + 1];
        newArray[0] = singleton;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static char[] concat1WithArray(char singleton, char[] array) {
        char[] newArray = new char[array.length + 1];
        newArray[0] = singleton;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static int[] concat1WithArray(int singleton, int[] array) {
        int[] newArray = new int[array.length + 1];
        newArray[0] = singleton;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static float[] concat1WithArray(float singleton, float[] array) {
        float[] newArray = new float[array.length + 1];
        newArray[0] = singleton;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static long[] concat1WithArray(long singleton, long[] array) {
        long[] newArray = new long[array.length + 1];
        newArray[0] = singleton;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static double[] concat1WithArray(double singleton, double[] array) {
        double[] newArray = new double[array.length + 1];
        newArray[0] = singleton;
        System.arraycopy(array, 0, newArray, 1, array.length);
        return newArray;
    }

    public static <E> E[] concatArrayWith2(E[] array, E singletonNp0, E singletonNp1) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 2);
        System.arraycopy(array, 0, newArray, 0, array.length);
        newArray[array.length + 0] = singletonNp0;
        newArray[array.length + 1] = singletonNp1;
        return newArray;
    }

    public static <E> E[] concat2WithArray(E singleton0, E singleton1, E[] array) {
        Object[] newArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + 2);
        newArray[0] = singleton0;
        newArray[1] = singleton1;
        System.arraycopy(array, 0, newArray, 2, array.length);
        return newArray;
    }

    public static <E> E[] uniqueifyArray(E[] array) {
        if (array == null) {
            return null;
        }
        HashSet<E> set = new HashSet<E>(Arrays.asList(array));
        Object[] newArray = set.toArray((Object[])Array.newInstance(array.getClass().getComponentType(), set.size()));
        Arrays.sort(newArray);
        return newArray;
    }

    public static void swapPairs(Object[] array, int start, int lengthInIndividualElements) {
        if (lengthInIndividualElements % 2 != 0) {
            throw new IllegalArgumentException("length is not a multiple of cycle size (2, since it's pairs!) ><    length=" + lengthInIndividualElements);
        }
        if (lengthInIndividualElements < 0) {
            throw new IndexOutOfBoundsException("negative length! ><   " + lengthInIndividualElements);
        }
        if (start < 0) {
            throw new ArrayIndexOutOfBoundsException("negative index! ><   " + start);
        }
        if (start + lengthInIndividualElements > array.length) {
            throw new ArrayIndexOutOfBoundsException("excessive ending index! ><   " + (start + lengthInIndividualElements) + " > " + array.length);
        }
        int numberOfCycles = lengthInIndividualElements / 2;
        Object t = null;
        int i = 0;
        while (i < numberOfCycles) {
            t = array[start + i * 2 + 0];
            array[start + i * 2 + 0] = array[start + i * 2 + 1];
            array[start + i * 2 + 1] = t;
            ++i;
        }
    }

    public static void swapPairs(Object[] array) {
        ArrayUtilities.swapPairs(array, 0, array.length);
    }

    public static <E> void swapArrayReferences(E[] array, int a, int b) {
        E s = array[a];
        array[a] = array[b];
        array[b] = s;
    }

    public static void swapArrayBooleans(boolean[] array, int a, int b) {
        boolean s = array[a];
        array[a] = array[b];
        array[b] = s;
    }

    public static void swapArrayBytes(byte[] array, int a, int b) {
        byte s = array[a];
        array[a] = array[b];
        array[b] = s;
    }

    public static void swapArrayChars(char[] array, int a, int b) {
        char s = array[a];
        array[a] = array[b];
        array[b] = s;
    }

    public static void swapArrayShorts(short[] array, int a, int b) {
        short s = array[a];
        array[a] = array[b];
        array[b] = s;
    }

    public static void swapArrayFloats(float[] array, int a, int b) {
        float s = array[a];
        array[a] = array[b];
        array[b] = s;
    }

    public static void swapArrayInts(int[] array, int a, int b) {
        int s = array[a];
        array[a] = array[b];
        array[b] = s;
    }

    public static void swapArrayDoubles(double[] array, int a, int b) {
        double s = array[a];
        array[a] = array[b];
        array[b] = s;
    }

    public static void swapArrayLongs(long[] array, int a, int b) {
        long s = array[a];
        array[a] = array[b];
        array[b] = s;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> E[] sliceR(E[] array, int inclusiveLowBound, int exclusiveHighBound) {
        int len = array.length;
        if (inclusiveLowBound == 0 && exclusiveHighBound == len) {
            return array;
        }
        if (inclusiveLowBound != len) {
            inclusiveLowBound = SmallIntegerMathUtilities.progmod(inclusiveLowBound, len);
        }
        if (exclusiveHighBound != len) {
            exclusiveHighBound = SmallIntegerMathUtilities.progmod(exclusiveHighBound, len);
        }
        if (exclusiveHighBound < inclusiveLowBound) {
            int t = exclusiveHighBound;
            exclusiveHighBound = inclusiveLowBound;
            inclusiveLowBound = t;
        }
        assert (inclusiveLowBound >= 0);
        assert (inclusiveLowBound <= len);
        assert (exclusiveHighBound >= 0);
        assert (exclusiveHighBound <= len);
        Object[] slice = (Object[])Array.newInstance(array.getClass().getComponentType(), exclusiveHighBound - inclusiveLowBound);
        System.arraycopy(array, inclusiveLowBound, slice, 0, slice.length);
        return slice;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <E> E[] sliceR(E[] array, int inclusiveLowBound) {
        return ArrayUtilities.sliceR(array, inclusiveLowBound, array.length);
    }

    @ThrowAwayValue
    public static <E> E[] slice(E[] array, int inclusiveLowBound, int exclusiveHighBound) {
        if (inclusiveLowBound == 0 && exclusiveHighBound == array.length) {
            return (Object[])array.clone();
        }
        return ArrayUtilities.sliceR(array, inclusiveLowBound, exclusiveHighBound);
    }

    @ThrowAwayValue
    public static <E> E[] slice(E[] array, int inclusiveLowBound) {
        return ArrayUtilities.slice(array, inclusiveLowBound, array.length);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static boolean[] sliceR(boolean[] array, int inclusiveLowBound, int exclusiveHighBound) {
        int len = array.length;
        if (inclusiveLowBound == 0 && exclusiveHighBound == len) {
            return array;
        }
        if (inclusiveLowBound != len) {
            inclusiveLowBound = SmallIntegerMathUtilities.progmod(inclusiveLowBound, len);
        }
        if (exclusiveHighBound != len) {
            exclusiveHighBound = SmallIntegerMathUtilities.progmod(exclusiveHighBound, len);
        }
        if (exclusiveHighBound < inclusiveLowBound) {
            int t = exclusiveHighBound;
            exclusiveHighBound = inclusiveLowBound;
            inclusiveLowBound = t;
        }
        assert (inclusiveLowBound >= 0);
        assert (inclusiveLowBound <= len);
        assert (exclusiveHighBound >= 0);
        assert (exclusiveHighBound <= len);
        boolean[] slice = new boolean[exclusiveHighBound - inclusiveLowBound];
        System.arraycopy(array, inclusiveLowBound, slice, 0, slice.length);
        return slice;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static boolean[] sliceR(boolean[] array, int inclusiveLowBound) {
        return ArrayUtilities.sliceR(array, inclusiveLowBound, array.length);
    }

    @ThrowAwayValue
    public static boolean[] slice(boolean[] array, int inclusiveLowBound, int exclusiveHighBound) {
        if (inclusiveLowBound == 0 && exclusiveHighBound == array.length) {
            return (boolean[])array.clone();
        }
        return ArrayUtilities.sliceR(array, inclusiveLowBound, exclusiveHighBound);
    }

    @ThrowAwayValue
    public static boolean[] slice(boolean[] array, int inclusiveLowBound) {
        return ArrayUtilities.slice(array, inclusiveLowBound, array.length);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static byte[] sliceR(byte[] array, int inclusiveLowBound, int exclusiveHighBound) {
        int len = array.length;
        if (inclusiveLowBound == 0 && exclusiveHighBound == len) {
            return array;
        }
        if (inclusiveLowBound != len) {
            inclusiveLowBound = SmallIntegerMathUtilities.progmod(inclusiveLowBound, len);
        }
        if (exclusiveHighBound != len) {
            exclusiveHighBound = SmallIntegerMathUtilities.progmod(exclusiveHighBound, len);
        }
        if (exclusiveHighBound < inclusiveLowBound) {
            int t = exclusiveHighBound;
            exclusiveHighBound = inclusiveLowBound;
            inclusiveLowBound = t;
        }
        assert (inclusiveLowBound >= 0);
        assert (inclusiveLowBound <= len);
        assert (exclusiveHighBound >= 0);
        assert (exclusiveHighBound <= len);
        byte[] slice = new byte[exclusiveHighBound - inclusiveLowBound];
        System.arraycopy(array, inclusiveLowBound, slice, 0, slice.length);
        return slice;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static byte[] sliceR(byte[] array, int inclusiveLowBound) {
        return ArrayUtilities.sliceR(array, inclusiveLowBound, array.length);
    }

    @ThrowAwayValue
    public static byte[] slice(byte[] array, int inclusiveLowBound, int exclusiveHighBound) {
        if (inclusiveLowBound == 0 && exclusiveHighBound == array.length) {
            return (byte[])array.clone();
        }
        return ArrayUtilities.sliceR(array, inclusiveLowBound, exclusiveHighBound);
    }

    @ThrowAwayValue
    public static byte[] slice(byte[] array, int inclusiveLowBound) {
        return ArrayUtilities.slice(array, inclusiveLowBound, array.length);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static char[] sliceR(char[] array, int inclusiveLowBound, int exclusiveHighBound) {
        int len = array.length;
        if (inclusiveLowBound == 0 && exclusiveHighBound == len) {
            return array;
        }
        if (inclusiveLowBound != len) {
            inclusiveLowBound = SmallIntegerMathUtilities.progmod(inclusiveLowBound, len);
        }
        if (exclusiveHighBound != len) {
            exclusiveHighBound = SmallIntegerMathUtilities.progmod(exclusiveHighBound, len);
        }
        if (exclusiveHighBound < inclusiveLowBound) {
            int t = exclusiveHighBound;
            exclusiveHighBound = inclusiveLowBound;
            inclusiveLowBound = t;
        }
        assert (inclusiveLowBound >= 0);
        assert (inclusiveLowBound <= len);
        assert (exclusiveHighBound >= 0);
        assert (exclusiveHighBound <= len);
        char[] slice = new char[exclusiveHighBound - inclusiveLowBound];
        System.arraycopy(array, inclusiveLowBound, slice, 0, slice.length);
        return slice;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static char[] sliceR(char[] array, int inclusiveLowBound) {
        return ArrayUtilities.sliceR(array, inclusiveLowBound, array.length);
    }

    @ThrowAwayValue
    public static char[] slice(char[] array, int inclusiveLowBound, int exclusiveHighBound) {
        if (inclusiveLowBound == 0 && exclusiveHighBound == array.length) {
            return (char[])array.clone();
        }
        return ArrayUtilities.sliceR(array, inclusiveLowBound, exclusiveHighBound);
    }

    @ThrowAwayValue
    public static char[] slice(char[] array, int inclusiveLowBound) {
        return ArrayUtilities.slice(array, inclusiveLowBound, array.length);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static short[] sliceR(short[] array, int inclusiveLowBound, int exclusiveHighBound) {
        int len = array.length;
        if (inclusiveLowBound == 0 && exclusiveHighBound == len) {
            return array;
        }
        if (inclusiveLowBound != len) {
            inclusiveLowBound = SmallIntegerMathUtilities.progmod(inclusiveLowBound, len);
        }
        if (exclusiveHighBound != len) {
            exclusiveHighBound = SmallIntegerMathUtilities.progmod(exclusiveHighBound, len);
        }
        if (exclusiveHighBound < inclusiveLowBound) {
            int t = exclusiveHighBound;
            exclusiveHighBound = inclusiveLowBound;
            inclusiveLowBound = t;
        }
        assert (inclusiveLowBound >= 0);
        assert (inclusiveLowBound <= len);
        assert (exclusiveHighBound >= 0);
        assert (exclusiveHighBound <= len);
        short[] slice = new short[exclusiveHighBound - inclusiveLowBound];
        System.arraycopy(array, inclusiveLowBound, slice, 0, slice.length);
        return slice;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static short[] sliceR(short[] array, int inclusiveLowBound) {
        return ArrayUtilities.sliceR(array, inclusiveLowBound, array.length);
    }

    @ThrowAwayValue
    public static short[] slice(short[] array, int inclusiveLowBound, int exclusiveHighBound) {
        if (inclusiveLowBound == 0 && exclusiveHighBound == array.length) {
            return (short[])array.clone();
        }
        return ArrayUtilities.sliceR(array, inclusiveLowBound, exclusiveHighBound);
    }

    @ThrowAwayValue
    public static short[] slice(short[] array, int inclusiveLowBound) {
        return ArrayUtilities.slice(array, inclusiveLowBound, array.length);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static float[] sliceR(float[] array, int inclusiveLowBound, int exclusiveHighBound) {
        int len = array.length;
        if (inclusiveLowBound == 0 && exclusiveHighBound == len) {
            return array;
        }
        if (inclusiveLowBound != len) {
            inclusiveLowBound = SmallIntegerMathUtilities.progmod(inclusiveLowBound, len);
        }
        if (exclusiveHighBound != len) {
            exclusiveHighBound = SmallIntegerMathUtilities.progmod(exclusiveHighBound, len);
        }
        if (exclusiveHighBound < inclusiveLowBound) {
            int t = exclusiveHighBound;
            exclusiveHighBound = inclusiveLowBound;
            inclusiveLowBound = t;
        }
        assert (inclusiveLowBound >= 0);
        assert (inclusiveLowBound <= len);
        assert (exclusiveHighBound >= 0);
        assert (exclusiveHighBound <= len);
        float[] slice = new float[exclusiveHighBound - inclusiveLowBound];
        System.arraycopy(array, inclusiveLowBound, slice, 0, slice.length);
        return slice;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static float[] sliceR(float[] array, int inclusiveLowBound) {
        return ArrayUtilities.sliceR(array, inclusiveLowBound, array.length);
    }

    @ThrowAwayValue
    public static float[] slice(float[] array, int inclusiveLowBound, int exclusiveHighBound) {
        if (inclusiveLowBound == 0 && exclusiveHighBound == array.length) {
            return (float[])array.clone();
        }
        return ArrayUtilities.sliceR(array, inclusiveLowBound, exclusiveHighBound);
    }

    @ThrowAwayValue
    public static float[] slice(float[] array, int inclusiveLowBound) {
        return ArrayUtilities.slice(array, inclusiveLowBound, array.length);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static int[] sliceR(int[] array, int inclusiveLowBound, int exclusiveHighBound) {
        int len = array.length;
        if (inclusiveLowBound == 0 && exclusiveHighBound == len) {
            return array;
        }
        if (inclusiveLowBound != len) {
            inclusiveLowBound = SmallIntegerMathUtilities.progmod(inclusiveLowBound, len);
        }
        if (exclusiveHighBound != len) {
            exclusiveHighBound = SmallIntegerMathUtilities.progmod(exclusiveHighBound, len);
        }
        if (exclusiveHighBound < inclusiveLowBound) {
            int t = exclusiveHighBound;
            exclusiveHighBound = inclusiveLowBound;
            inclusiveLowBound = t;
        }
        assert (inclusiveLowBound >= 0);
        assert (inclusiveLowBound <= len);
        assert (exclusiveHighBound >= 0);
        assert (exclusiveHighBound <= len);
        int[] slice = new int[exclusiveHighBound - inclusiveLowBound];
        System.arraycopy(array, inclusiveLowBound, slice, 0, slice.length);
        return slice;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static int[] sliceR(int[] array, int inclusiveLowBound) {
        return ArrayUtilities.sliceR(array, inclusiveLowBound, array.length);
    }

    @ThrowAwayValue
    public static int[] slice(int[] array, int inclusiveLowBound, int exclusiveHighBound) {
        if (inclusiveLowBound == 0 && exclusiveHighBound == array.length) {
            return (int[])array.clone();
        }
        return ArrayUtilities.sliceR(array, inclusiveLowBound, exclusiveHighBound);
    }

    @ThrowAwayValue
    public static int[] slice(int[] array, int inclusiveLowBound) {
        return ArrayUtilities.slice(array, inclusiveLowBound, array.length);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static double[] sliceR(double[] array, int inclusiveLowBound, int exclusiveHighBound) {
        int len = array.length;
        if (inclusiveLowBound == 0 && exclusiveHighBound == len) {
            return array;
        }
        if (inclusiveLowBound != len) {
            inclusiveLowBound = SmallIntegerMathUtilities.progmod(inclusiveLowBound, len);
        }
        if (exclusiveHighBound != len) {
            exclusiveHighBound = SmallIntegerMathUtilities.progmod(exclusiveHighBound, len);
        }
        if (exclusiveHighBound < inclusiveLowBound) {
            int t = exclusiveHighBound;
            exclusiveHighBound = inclusiveLowBound;
            inclusiveLowBound = t;
        }
        assert (inclusiveLowBound >= 0);
        assert (inclusiveLowBound <= len);
        assert (exclusiveHighBound >= 0);
        assert (exclusiveHighBound <= len);
        double[] slice = new double[exclusiveHighBound - inclusiveLowBound];
        System.arraycopy(array, inclusiveLowBound, slice, 0, slice.length);
        return slice;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static double[] sliceR(double[] array, int inclusiveLowBound) {
        return ArrayUtilities.sliceR(array, inclusiveLowBound, array.length);
    }

    @ThrowAwayValue
    public static double[] slice(double[] array, int inclusiveLowBound, int exclusiveHighBound) {
        if (inclusiveLowBound == 0 && exclusiveHighBound == array.length) {
            return (double[])array.clone();
        }
        return ArrayUtilities.sliceR(array, inclusiveLowBound, exclusiveHighBound);
    }

    @ThrowAwayValue
    public static double[] slice(double[] array, int inclusiveLowBound) {
        return ArrayUtilities.slice(array, inclusiveLowBound, array.length);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static long[] sliceR(long[] array, int inclusiveLowBound, int exclusiveHighBound) {
        int len = array.length;
        if (inclusiveLowBound == 0 && exclusiveHighBound == len) {
            return array;
        }
        if (inclusiveLowBound != len) {
            inclusiveLowBound = SmallIntegerMathUtilities.progmod(inclusiveLowBound, len);
        }
        if (exclusiveHighBound != len) {
            exclusiveHighBound = SmallIntegerMathUtilities.progmod(exclusiveHighBound, len);
        }
        if (exclusiveHighBound < inclusiveLowBound) {
            int t = exclusiveHighBound;
            exclusiveHighBound = inclusiveLowBound;
            inclusiveLowBound = t;
        }
        assert (inclusiveLowBound >= 0);
        assert (inclusiveLowBound <= len);
        assert (exclusiveHighBound >= 0);
        assert (exclusiveHighBound <= len);
        long[] slice = new long[exclusiveHighBound - inclusiveLowBound];
        System.arraycopy(array, inclusiveLowBound, slice, 0, slice.length);
        return slice;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static long[] sliceR(long[] array, int inclusiveLowBound) {
        return ArrayUtilities.sliceR(array, inclusiveLowBound, array.length);
    }

    @ThrowAwayValue
    public static long[] slice(long[] array, int inclusiveLowBound, int exclusiveHighBound) {
        if (inclusiveLowBound == 0 && exclusiveHighBound == array.length) {
            return (long[])array.clone();
        }
        return ArrayUtilities.sliceR(array, inclusiveLowBound, exclusiveHighBound);
    }

    @ThrowAwayValue
    public static long[] slice(long[] array, int inclusiveLowBound) {
        return ArrayUtilities.slice(array, inclusiveLowBound, array.length);
    }

    public static <T> T cloneArray(T array) {
        if (array == null) {
            return null;
        }
        if (array instanceof Object[]) {
            return (T)((Object[])array).clone();
        }
        if (array instanceof boolean[]) {
            return (T)((boolean[])array).clone();
        }
        if (array instanceof byte[]) {
            return (T)((byte[])array).clone();
        }
        if (array instanceof char[]) {
            return (T)((char[])array).clone();
        }
        if (array instanceof short[]) {
            return (T)((short[])array).clone();
        }
        if (array instanceof float[]) {
            return (T)((float[])array).clone();
        }
        if (array instanceof int[]) {
            return (T)((int[])array).clone();
        }
        if (array instanceof double[]) {
            return (T)((double[])array).clone();
        }
        if (array instanceof long[]) {
            return (T)((long[])array).clone();
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(array);
    }

    public static int getAndValidateAllSameLength(Object[] arrayOfArrays) {
        if (arrayOfArrays == null) {
            throw new NullPointerException();
        }
        if (arrayOfArrays.length == 0) {
            throw new IllegalArgumentException("No sub-arrays to extract second dimension's length from ;_;");
        }
        int first = Array.getLength(arrayOfArrays[0]);
        int i = 1;
        while (i < arrayOfArrays.length) {
            if (Array.getLength(arrayOfArrays[i]) != first) {
                throw new IllegalArgumentException("Second dimensions' lengths are not all equal! D:");
            }
            ++i;
        }
        return first;
    }

    public static int getAndValidateAllSameLengthSkippingNonarrays(Object[] arrayOfArrays) {
        if (arrayOfArrays == null) {
            throw new NullPointerException();
        }
        if (arrayOfArrays.length == 0) {
            throw new IllegalArgumentException("No sub-arrays to extract second dimension's length from ;_;");
        }
        int firstIndex = -1;
        int i = 0;
        while (i < arrayOfArrays.length) {
            if (arrayOfArrays[i] != null && arrayOfArrays[i].getClass().isArray()) {
                firstIndex = i;
                break;
            }
            ++i;
        }
        if (firstIndex == -1) {
            return -1;
        }
        int first = Array.getLength(arrayOfArrays[firstIndex]);
        int i2 = firstIndex + 1;
        while (i2 < arrayOfArrays.length) {
            if (arrayOfArrays[i2] != null && arrayOfArrays[i2].getClass().isArray() && Array.getLength(arrayOfArrays[i2]) != first) {
                throw new IllegalArgumentException("Second dimensions' lengths are not all equal! D:");
            }
            ++i2;
        }
        return first;
    }

    public static void copyBitfields(boolean[] source, boolean[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(boolean[] source, int sourceOffset, int sourceLength, boolean[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        System.arraycopy(source, sourceOffset, dest, destOffset, length);
    }

    public static void copyBitfields(boolean[] source, byte[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(boolean[] source, int sourceOffset, int sourceLength, byte[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 1, 8);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 8, 1);
        } else {
            long sourceLengthInBits = sourceLength * 1;
            long destLengthInBits = destLength * 8;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
        }
        int destLengthFloor = sourceLength * 1 / 8;
        int i = 0;
        while (i < destLengthFloor) {
            byte d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 8) {
                boolean s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 1;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToByte(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(boolean[] source, char[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(boolean[] source, int sourceOffset, int sourceLength, char[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 1, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 1);
        } else {
            long sourceLengthInBits = sourceLength * 1;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int destLengthFloor = sourceLength * 1 / 16;
        int i = 0;
        while (i < destLengthFloor) {
            char d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 16) {
                boolean s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 1;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToChar(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(boolean[] source, short[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(boolean[] source, int sourceOffset, int sourceLength, short[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 1, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 1);
        } else {
            long sourceLengthInBits = sourceLength * 1;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int destLengthFloor = sourceLength * 1 / 16;
        int i = 0;
        while (i < destLengthFloor) {
            short d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 16) {
                boolean s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 1;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToShort(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(boolean[] source, float[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(boolean[] source, int sourceOffset, int sourceLength, float[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 1, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 1);
        } else {
            long sourceLengthInBits = sourceLength * 1;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int destLengthFloor = sourceLength * 1 / 32;
        int i = 0;
        while (i < destLengthFloor) {
            float d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 32) {
                boolean s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 1;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToFloat(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(boolean[] source, int[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(boolean[] source, int sourceOffset, int sourceLength, int[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 1, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 1);
        } else {
            long sourceLengthInBits = sourceLength * 1;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int destLengthFloor = sourceLength * 1 / 32;
        int i = 0;
        while (i < destLengthFloor) {
            int d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 32) {
                boolean s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 1;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToInt(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(boolean[] source, double[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(boolean[] source, int sourceOffset, int sourceLength, double[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 1, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 1);
        } else {
            long sourceLengthInBits = sourceLength * 1;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 1 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            double d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 64) {
                boolean s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 1;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToDouble(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(boolean[] source, long[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(boolean[] source, int sourceOffset, int sourceLength, long[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 1, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 1);
        } else {
            long sourceLengthInBits = sourceLength * 1;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 1 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            long d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 64) {
                boolean s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 1;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToLong(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(byte[] source, boolean[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(byte[] source, int sourceOffset, int sourceLength, boolean[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 8, 1);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 1, 8);
        } else {
            long sourceLengthInBits = sourceLength * 8;
            long destLengthInBits = destLength * 1;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
        }
        int sourceLengthFloor = destLength * 1 / 8;
        int i = 0;
        while (i < sourceLengthFloor) {
            byte s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 8) {
                boolean d;
                long shiftedAndMasked = sbits >>> e * 1 & 1L;
                dest[i * 8 + e + destOffset] = d = Primitives.bitcastFromLongToBoolean(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(byte[] source, byte[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(byte[] source, int sourceOffset, int sourceLength, byte[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        System.arraycopy(source, sourceOffset, dest, destOffset, length);
    }

    public static void copyBitfields(byte[] source, char[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(byte[] source, int sourceOffset, int sourceLength, char[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 8, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 8);
        } else {
            long sourceLengthInBits = sourceLength * 8;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int destLengthFloor = sourceLength * 8 / 16;
        int i = 0;
        while (i < destLengthFloor) {
            char d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                byte s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 8;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToChar(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(byte[] source, short[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(byte[] source, int sourceOffset, int sourceLength, short[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 8, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 8);
        } else {
            long sourceLengthInBits = sourceLength * 8;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int destLengthFloor = sourceLength * 8 / 16;
        int i = 0;
        while (i < destLengthFloor) {
            short d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                byte s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 8;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToShort(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(byte[] source, float[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(byte[] source, int sourceOffset, int sourceLength, float[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 8, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 8);
        } else {
            long sourceLengthInBits = sourceLength * 8;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int destLengthFloor = sourceLength * 8 / 32;
        int i = 0;
        while (i < destLengthFloor) {
            float d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 4) {
                byte s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 8;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToFloat(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(byte[] source, int[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(byte[] source, int sourceOffset, int sourceLength, int[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 8, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 8);
        } else {
            long sourceLengthInBits = sourceLength * 8;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int destLengthFloor = sourceLength * 8 / 32;
        int i = 0;
        while (i < destLengthFloor) {
            int d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 4) {
                byte s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 8;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToInt(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(byte[] source, double[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(byte[] source, int sourceOffset, int sourceLength, double[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 8, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 8);
        } else {
            long sourceLengthInBits = sourceLength * 8;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 8 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            double d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 8) {
                byte s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 8;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToDouble(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(byte[] source, long[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(byte[] source, int sourceOffset, int sourceLength, long[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 8, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 8);
        } else {
            long sourceLengthInBits = sourceLength * 8;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 8 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            long d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 8) {
                byte s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 8;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToLong(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(char[] source, boolean[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(char[] source, int sourceOffset, int sourceLength, boolean[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 1);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 1, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 1;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
        }
        int sourceLengthFloor = destLength * 1 / 16;
        int i = 0;
        while (i < sourceLengthFloor) {
            char s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 16) {
                boolean d;
                long shiftedAndMasked = sbits >>> e * 1 & 1L;
                dest[i * 16 + e + destOffset] = d = Primitives.bitcastFromLongToBoolean(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(char[] source, byte[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(char[] source, int sourceOffset, int sourceLength, byte[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 8);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 8, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 8;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
        }
        int sourceLengthFloor = destLength * 8 / 16;
        int i = 0;
        while (i < sourceLengthFloor) {
            char s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                byte d;
                long shiftedAndMasked = sbits >>> e * 8 & 0xFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToByte(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(char[] source, char[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(char[] source, int sourceOffset, int sourceLength, char[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        System.arraycopy(source, sourceOffset, dest, destOffset, length);
    }

    public static void copyBitfields(char[] source, short[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(char[] source, int sourceOffset, int sourceLength, short[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        int i = 0;
        while (i < length) {
            short d;
            char s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            dest[i + destOffset] = d = Primitives.bitcastFromLongToShort(sbits);
            ++i;
        }
    }

    public static void copyBitfields(char[] source, float[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(char[] source, int sourceOffset, int sourceLength, float[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int destLengthFloor = sourceLength * 16 / 32;
        int i = 0;
        while (i < destLengthFloor) {
            float d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                char s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 16;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToFloat(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(char[] source, int[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(char[] source, int sourceOffset, int sourceLength, int[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int destLengthFloor = sourceLength * 16 / 32;
        int i = 0;
        while (i < destLengthFloor) {
            int d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                char s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 16;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToInt(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(char[] source, double[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(char[] source, int sourceOffset, int sourceLength, double[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 16 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            double d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 4) {
                char s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 16;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToDouble(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(char[] source, long[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(char[] source, int sourceOffset, int sourceLength, long[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 16 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            long d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 4) {
                char s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 16;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToLong(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(short[] source, boolean[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(short[] source, int sourceOffset, int sourceLength, boolean[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 1);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 1, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 1;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
        }
        int sourceLengthFloor = destLength * 1 / 16;
        int i = 0;
        while (i < sourceLengthFloor) {
            short s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 16) {
                boolean d;
                long shiftedAndMasked = sbits >>> e * 1 & 1L;
                dest[i * 16 + e + destOffset] = d = Primitives.bitcastFromLongToBoolean(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(short[] source, byte[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(short[] source, int sourceOffset, int sourceLength, byte[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 8);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 8, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 8;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
        }
        int sourceLengthFloor = destLength * 8 / 16;
        int i = 0;
        while (i < sourceLengthFloor) {
            short s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                byte d;
                long shiftedAndMasked = sbits >>> e * 8 & 0xFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToByte(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(short[] source, char[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(short[] source, int sourceOffset, int sourceLength, char[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        int i = 0;
        while (i < length) {
            char d;
            short s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            dest[i + destOffset] = d = Primitives.bitcastFromLongToChar(sbits);
            ++i;
        }
    }

    public static void copyBitfields(short[] source, short[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(short[] source, int sourceOffset, int sourceLength, short[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        System.arraycopy(source, sourceOffset, dest, destOffset, length);
    }

    public static void copyBitfields(short[] source, float[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(short[] source, int sourceOffset, int sourceLength, float[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int destLengthFloor = sourceLength * 16 / 32;
        int i = 0;
        while (i < destLengthFloor) {
            float d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                short s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 16;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToFloat(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(short[] source, int[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(short[] source, int sourceOffset, int sourceLength, int[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int destLengthFloor = sourceLength * 16 / 32;
        int i = 0;
        while (i < destLengthFloor) {
            int d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                short s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 16;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToInt(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(short[] source, double[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(short[] source, int sourceOffset, int sourceLength, double[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 16 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            double d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 4) {
                short s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 16;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToDouble(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(short[] source, long[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(short[] source, int sourceOffset, int sourceLength, long[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 16, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 16);
        } else {
            long sourceLengthInBits = sourceLength * 16;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 16 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            long d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 4) {
                short s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 16;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToLong(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(float[] source, boolean[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(float[] source, int sourceOffset, int sourceLength, boolean[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 1);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 1, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 1;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
        }
        int sourceLengthFloor = destLength * 1 / 32;
        int i = 0;
        while (i < sourceLengthFloor) {
            float s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 32) {
                boolean d;
                long shiftedAndMasked = sbits >>> e * 1 & 1L;
                dest[i * 32 + e + destOffset] = d = Primitives.bitcastFromLongToBoolean(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(float[] source, byte[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(float[] source, int sourceOffset, int sourceLength, byte[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 8);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 8, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 8;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
        }
        int sourceLengthFloor = destLength * 8 / 32;
        int i = 0;
        while (i < sourceLengthFloor) {
            float s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 4) {
                byte d;
                long shiftedAndMasked = sbits >>> e * 8 & 0xFFL;
                dest[i * 4 + e + destOffset] = d = Primitives.bitcastFromLongToByte(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(float[] source, char[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(float[] source, int sourceOffset, int sourceLength, char[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int sourceLengthFloor = destLength * 16 / 32;
        int i = 0;
        while (i < sourceLengthFloor) {
            float s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                char d;
                long shiftedAndMasked = sbits >>> e * 16 & 0xFFFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToChar(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(float[] source, short[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(float[] source, int sourceOffset, int sourceLength, short[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int sourceLengthFloor = destLength * 16 / 32;
        int i = 0;
        while (i < sourceLengthFloor) {
            float s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                short d;
                long shiftedAndMasked = sbits >>> e * 16 & 0xFFFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToShort(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(float[] source, float[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(float[] source, int sourceOffset, int sourceLength, float[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        System.arraycopy(source, sourceOffset, dest, destOffset, length);
    }

    public static void copyBitfields(float[] source, int[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(float[] source, int sourceOffset, int sourceLength, int[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        int i = 0;
        while (i < length) {
            int d;
            float s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            dest[i + destOffset] = d = Primitives.bitcastFromLongToInt(sbits);
            ++i;
        }
    }

    public static void copyBitfields(float[] source, double[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(float[] source, int sourceOffset, int sourceLength, double[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 32 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            double d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                float s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 32;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToDouble(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(float[] source, long[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(float[] source, int sourceOffset, int sourceLength, long[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 32 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            long d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                float s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 32;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToLong(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(int[] source, boolean[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(int[] source, int sourceOffset, int sourceLength, boolean[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 1);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 1, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 1;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
        }
        int sourceLengthFloor = destLength * 1 / 32;
        int i = 0;
        while (i < sourceLengthFloor) {
            int s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 32) {
                boolean d;
                long shiftedAndMasked = sbits >>> e * 1 & 1L;
                dest[i * 32 + e + destOffset] = d = Primitives.bitcastFromLongToBoolean(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(int[] source, byte[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(int[] source, int sourceOffset, int sourceLength, byte[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 8);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 8, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 8;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
        }
        int sourceLengthFloor = destLength * 8 / 32;
        int i = 0;
        while (i < sourceLengthFloor) {
            int s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 4) {
                byte d;
                long shiftedAndMasked = sbits >>> e * 8 & 0xFFL;
                dest[i * 4 + e + destOffset] = d = Primitives.bitcastFromLongToByte(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(int[] source, char[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(int[] source, int sourceOffset, int sourceLength, char[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int sourceLengthFloor = destLength * 16 / 32;
        int i = 0;
        while (i < sourceLengthFloor) {
            int s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                char d;
                long shiftedAndMasked = sbits >>> e * 16 & 0xFFFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToChar(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(int[] source, short[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(int[] source, int sourceOffset, int sourceLength, short[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int sourceLengthFloor = destLength * 16 / 32;
        int i = 0;
        while (i < sourceLengthFloor) {
            int s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                short d;
                long shiftedAndMasked = sbits >>> e * 16 & 0xFFFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToShort(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(int[] source, float[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(int[] source, int sourceOffset, int sourceLength, float[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        int i = 0;
        while (i < length) {
            float d;
            int s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            dest[i + destOffset] = d = Primitives.bitcastFromLongToFloat(sbits);
            ++i;
        }
    }

    public static void copyBitfields(int[] source, int[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(int[] source, int sourceOffset, int sourceLength, int[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        System.arraycopy(source, sourceOffset, dest, destOffset, length);
    }

    public static void copyBitfields(int[] source, double[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(int[] source, int sourceOffset, int sourceLength, double[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 32 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            double d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                int s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 32;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToDouble(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(int[] source, long[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(int[] source, int sourceOffset, int sourceLength, long[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 32, 64);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 64, 32);
        } else {
            long sourceLengthInBits = sourceLength * 32;
            long destLengthInBits = destLength * 64;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
        }
        int destLengthFloor = sourceLength * 32 / 64;
        int i = 0;
        while (i < destLengthFloor) {
            long d;
            long shiftedAndMasked = 0L;
            int e = 0;
            while (e < 2) {
                int s = source[i + sourceOffset];
                long sbits = Primitives.bitcastToLongUnsigned(s);
                shiftedAndMasked |= sbits;
                shiftedAndMasked <<= 32;
                ++e;
            }
            dest[i + destOffset] = d = Primitives.bitcastFromLongToLong(shiftedAndMasked);
            ++i;
        }
    }

    public static void copyBitfields(double[] source, boolean[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(double[] source, int sourceOffset, int sourceLength, boolean[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 1);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 1, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 1;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
        }
        int sourceLengthFloor = destLength * 1 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            double s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 64) {
                boolean d;
                long shiftedAndMasked = sbits >>> e * 1 & 1L;
                dest[i * 64 + e + destOffset] = d = Primitives.bitcastFromLongToBoolean(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(double[] source, byte[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(double[] source, int sourceOffset, int sourceLength, byte[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 8);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 8, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 8;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
        }
        int sourceLengthFloor = destLength * 8 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            double s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 8) {
                byte d;
                long shiftedAndMasked = sbits >>> e * 8 & 0xFFL;
                dest[i * 8 + e + destOffset] = d = Primitives.bitcastFromLongToByte(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(double[] source, char[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(double[] source, int sourceOffset, int sourceLength, char[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int sourceLengthFloor = destLength * 16 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            double s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 4) {
                char d;
                long shiftedAndMasked = sbits >>> e * 16 & 0xFFFFL;
                dest[i * 4 + e + destOffset] = d = Primitives.bitcastFromLongToChar(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(double[] source, short[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(double[] source, int sourceOffset, int sourceLength, short[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int sourceLengthFloor = destLength * 16 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            double s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 4) {
                short d;
                long shiftedAndMasked = sbits >>> e * 16 & 0xFFFFL;
                dest[i * 4 + e + destOffset] = d = Primitives.bitcastFromLongToShort(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(double[] source, float[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(double[] source, int sourceOffset, int sourceLength, float[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int sourceLengthFloor = destLength * 32 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            double s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                float d;
                long shiftedAndMasked = sbits >>> e * 32 & 0xFFFFFFFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToFloat(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(double[] source, int[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(double[] source, int sourceOffset, int sourceLength, int[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int sourceLengthFloor = destLength * 32 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            double s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                int d;
                long shiftedAndMasked = sbits >>> e * 32 & 0xFFFFFFFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToInt(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(double[] source, double[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(double[] source, int sourceOffset, int sourceLength, double[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        System.arraycopy(source, sourceOffset, dest, destOffset, length);
    }

    public static void copyBitfields(double[] source, long[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(double[] source, int sourceOffset, int sourceLength, long[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        int i = 0;
        while (i < length) {
            long d;
            double s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            dest[i + destOffset] = d = Primitives.bitcastFromLongToLong(sbits);
            ++i;
        }
    }

    public static void copyBitfields(long[] source, boolean[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(long[] source, int sourceOffset, int sourceLength, boolean[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 1);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 1, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 1;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 1L));
        }
        int sourceLengthFloor = destLength * 1 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            long s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 64) {
                boolean d;
                long shiftedAndMasked = sbits >>> e * 1 & 1L;
                dest[i * 64 + e + destOffset] = d = Primitives.bitcastFromLongToBoolean(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(long[] source, byte[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(long[] source, int sourceOffset, int sourceLength, byte[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 8);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 8, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 8;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 8L));
        }
        int sourceLengthFloor = destLength * 8 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            long s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 8) {
                byte d;
                long shiftedAndMasked = sbits >>> e * 8 & 0xFFL;
                dest[i * 8 + e + destOffset] = d = Primitives.bitcastFromLongToByte(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(long[] source, char[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(long[] source, int sourceOffset, int sourceLength, char[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int sourceLengthFloor = destLength * 16 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            long s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 4) {
                char d;
                long shiftedAndMasked = sbits >>> e * 16 & 0xFFFFL;
                dest[i * 4 + e + destOffset] = d = Primitives.bitcastFromLongToChar(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(long[] source, short[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(long[] source, int sourceOffset, int sourceLength, short[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 16);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 16, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 16;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 16L));
        }
        int sourceLengthFloor = destLength * 16 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            long s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 4) {
                short d;
                long shiftedAndMasked = sbits >>> e * 16 & 0xFFFFL;
                dest[i * 4 + e + destOffset] = d = Primitives.bitcastFromLongToShort(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(long[] source, float[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(long[] source, int sourceOffset, int sourceLength, float[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int sourceLengthFloor = destLength * 32 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            long s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                float d;
                long shiftedAndMasked = sbits >>> e * 32 & 0xFFFFFFFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToFloat(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(long[] source, int[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(long[] source, int sourceOffset, int sourceLength, int[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            destLength = SmallIntegerMathUtilities.ceilingDivision(sourceLength * 64, 32);
        } else if (destLength == -1) {
            sourceLength = SmallIntegerMathUtilities.ceilingDivision(destLength * 32, 64);
        } else {
            long sourceLengthInBits = sourceLength * 64;
            long destLengthInBits = destLength * 32;
            long minLengthInBits = SmallIntegerMathUtilities.least(sourceLengthInBits, destLengthInBits);
            sourceLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 64L));
            destLength = BitfieldSafeCasts.safeCastS64toS32(SmallIntegerMathUtilities.ceilingDivision(minLengthInBits, 32L));
        }
        int sourceLengthFloor = destLength * 32 / 64;
        int i = 0;
        while (i < sourceLengthFloor) {
            long s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            int e = 0;
            while (e < 2) {
                int d;
                long shiftedAndMasked = sbits >>> e * 32 & 0xFFFFFFFFL;
                dest[i * 2 + e + destOffset] = d = Primitives.bitcastFromLongToInt(shiftedAndMasked);
                ++e;
            }
            ++i;
        }
    }

    public static void copyBitfields(long[] source, double[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(long[] source, int sourceOffset, int sourceLength, double[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        int i = 0;
        while (i < length) {
            double d;
            long s = source[i + sourceOffset];
            long sbits = Primitives.bitcastToLongUnsigned(s);
            dest[i + destOffset] = d = Primitives.bitcastFromLongToDouble(sbits);
            ++i;
        }
    }

    public static void copyBitfields(long[] source, long[] dest) {
        ArrayUtilities.copyBitfields(source, 0, source.length, dest, 0, dest.length);
    }

    public static void copyBitfields(long[] source, int sourceOffset, int sourceLength, long[] dest, int destOffset, int destLength) {
        if (sourceOffset < 0) {
            throw new IndexOutOfBoundsException("negative source offset!");
        }
        if (sourceLength < 0) {
            throw new IndexOutOfBoundsException("negative source length!");
        }
        if (destOffset < 0) {
            throw new IndexOutOfBoundsException("negative destination offset!");
        }
        if (destLength < 0) {
            throw new IndexOutOfBoundsException("negative destination length!");
        }
        if (sourceOffset + sourceLength > source.length) {
            throw new IndexOutOfBoundsException("overflowing source range! :o");
        }
        if (destOffset + destLength > dest.length) {
            throw new IndexOutOfBoundsException("overflowing destination range! :o");
        }
        int length = 0;
        if (sourceLength == -1 && destLength == -1) {
            throw new IllegalArgumentException("Both lengths can't be 'determine-from-other-length'! :o");
        }
        if (sourceLength == -1) {
            length = destLength = sourceLength;
        } else if (destLength == -1) {
            length = sourceLength = destLength;
        } else {
            sourceLength = destLength = SmallIntegerMathUtilities.least(sourceLength, destLength);
            length = destLength;
        }
        System.arraycopy(source, sourceOffset, dest, destOffset, length);
    }

    public static <E> Object[] loseComponentType(E[] typedArray) {
        Object[] untypedArray = new Object[typedArray.length];
        System.arraycopy(typedArray, 0, untypedArray, 0, typedArray.length);
        return untypedArray;
    }

    public static <Pre, Post> Post[] changeComponentType(Pre[] originalTypedArray, Class<Post> newComponentType) {
        Object[] newTypedArray = (Object[])Array.newInstance(newComponentType, originalTypedArray.length);
        System.arraycopy(originalTypedArray, 0, newTypedArray, 0, originalTypedArray.length);
        return newTypedArray;
    }

    public static <E> E[] makeArray(FunctionInterfaces.UnaryFunctionIntToObject<? extends E> filler, int length, Class<E> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, length);
        int i = 0;
        while (i < length) {
            array[i] = filler.f(i);
            ++i;
        }
        return array;
    }

    public static <E> E[] makeArrayIndexless(FunctionInterfaces.NullaryFunction<? extends E> filler, int length, Class<E> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, length);
        int i = 0;
        while (i < length) {
            array[i] = filler.f();
            ++i;
        }
        return array;
    }

    public static Object[] makeObjectArray(FunctionInterfaces.UnaryFunctionIntToObject<?> filler, int length) {
        Object[] array = new Object[length];
        int i = 0;
        while (i < length) {
            array[i] = filler.f(i);
            ++i;
        }
        return array;
    }

    public static Object[] makeObjectArrayIndexless(FunctionInterfaces.NullaryFunction<?> filler, int length) {
        Object[] array = new Object[length];
        int i = 0;
        while (i < length) {
            array[i] = filler.f();
            ++i;
        }
        return array;
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(byte[] array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(byte[] array, byte valueBase) {
        BitSet has = new BitSet();
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte value = byArray[n2];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + (long)value);
            }
            has.set(zValue);
            ++n2;
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(byte[] arrayA, byte[] arrayB, byte valueBase) {
        if (arrayA.length != arrayB.length) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        byte[] byArray = arrayA;
        int n = arrayA.length;
        int n2 = 0;
        while (n2 < n) {
            byte value = byArray[n2];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + value);
            }
            hasA.set(zValue);
            ++n2;
        }
        BitSet hasB = new BitSet();
        byte[] byArray2 = arrayB;
        int n3 = arrayB.length;
        n = 0;
        while (n < n3) {
            byte value = byArray2[n];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + value);
            }
            hasB.set(zValue);
            ++n;
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.ByteList array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.ByteList array, byte valueBase) {
        BitSet has = new BitSet();
        for (byte value : array) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + (long)value);
            }
            has.set(zValue);
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(PrimitiveCollections.ByteList arrayA, PrimitiveCollections.ByteList arrayB, byte valueBase) {
        if (arrayA.size() != arrayB.size()) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        for (byte value : arrayA) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + value);
            }
            hasA.set(zValue);
        }
        BitSet hasB = new BitSet();
        for (byte value : arrayB) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + value);
            }
            hasB.set(zValue);
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(char[] array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(char[] array, char valueBase) {
        BitSet has = new BitSet();
        char[] cArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            char value = cArray[n2];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + (long)value);
            }
            has.set(zValue);
            ++n2;
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(char[] arrayA, char[] arrayB, char valueBase) {
        if (arrayA.length != arrayB.length) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        char[] cArray = arrayA;
        int n = arrayA.length;
        int n2 = 0;
        while (n2 < n) {
            char value = cArray[n2];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + value);
            }
            hasA.set(zValue);
            ++n2;
        }
        BitSet hasB = new BitSet();
        char[] cArray2 = arrayB;
        int n3 = arrayB.length;
        n = 0;
        while (n < n3) {
            char value = cArray2[n];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + value);
            }
            hasB.set(zValue);
            ++n;
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.CharacterList array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.CharacterList array, char valueBase) {
        BitSet has = new BitSet();
        for (char value : array) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + (long)value);
            }
            has.set(zValue);
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(PrimitiveCollections.CharacterList arrayA, PrimitiveCollections.CharacterList arrayB, char valueBase) {
        if (arrayA.size() != arrayB.size()) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        for (char value : arrayA) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + value);
            }
            hasA.set(zValue);
        }
        BitSet hasB = new BitSet();
        for (char value : arrayB) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + value);
            }
            hasB.set(zValue);
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(short[] array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(short[] array, short valueBase) {
        BitSet has = new BitSet();
        short[] sArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            short value = sArray[n2];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + (long)value);
            }
            has.set(zValue);
            ++n2;
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(short[] arrayA, short[] arrayB, short valueBase) {
        if (arrayA.length != arrayB.length) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        short[] sArray = arrayA;
        int n = arrayA.length;
        int n2 = 0;
        while (n2 < n) {
            short value = sArray[n2];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + value);
            }
            hasA.set(zValue);
            ++n2;
        }
        BitSet hasB = new BitSet();
        short[] sArray2 = arrayB;
        int n3 = arrayB.length;
        n = 0;
        while (n < n3) {
            short value = sArray2[n];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + value);
            }
            hasB.set(zValue);
            ++n;
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.ShortList array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.ShortList array, short valueBase) {
        BitSet has = new BitSet();
        for (short value : array) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + (long)value);
            }
            has.set(zValue);
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(PrimitiveCollections.ShortList arrayA, PrimitiveCollections.ShortList arrayB, short valueBase) {
        if (arrayA.size() != arrayB.size()) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        for (short value : arrayA) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + value);
            }
            hasA.set(zValue);
        }
        BitSet hasB = new BitSet();
        for (short value : arrayB) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + value);
            }
            hasB.set(zValue);
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(int[] array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(int[] array, int valueBase) {
        BitSet has = new BitSet();
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + (long)value);
            }
            has.set(zValue);
            ++n2;
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(int[] arrayA, int[] arrayB, int valueBase) {
        if (arrayA.length != arrayB.length) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        int[] nArray = arrayA;
        int n = arrayA.length;
        int n2 = 0;
        while (n2 < n) {
            int value = nArray[n2];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + (long)value);
            }
            hasA.set(zValue);
            ++n2;
        }
        BitSet hasB = new BitSet();
        int[] nArray2 = arrayB;
        int n3 = arrayB.length;
        n = 0;
        while (n < n3) {
            int value = nArray2[n];
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + (long)value);
            }
            hasB.set(zValue);
            ++n;
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.IntegerList array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.IntegerList array, int valueBase) {
        BitSet has = new BitSet();
        for (int value : array) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + (long)value);
            }
            has.set(zValue);
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(PrimitiveCollections.IntegerList arrayA, PrimitiveCollections.IntegerList arrayB, int valueBase) {
        if (arrayA.size() != arrayB.size()) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        for (int value : arrayA) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + (long)value);
            }
            hasA.set(zValue);
        }
        BitSet hasB = new BitSet();
        for (int value : arrayB) {
            int zValue = value - valueBase;
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + (long)value);
            }
            hasB.set(zValue);
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(long[] array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(long[] array, long valueBase) {
        BitSet has = new BitSet();
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            int zValue = BitfieldSafeCasts.safeCastS64toS32(value - valueBase);
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + value);
            }
            has.set(zValue);
            ++n2;
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(long[] arrayA, long[] arrayB, long valueBase) {
        if (arrayA.length != arrayB.length) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        long[] lArray = arrayA;
        int n = arrayA.length;
        int n2 = 0;
        while (n2 < n) {
            long value = lArray[n2];
            int zValue = BitfieldSafeCasts.safeCastS64toS32(value - valueBase);
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + value);
            }
            hasA.set(zValue);
            ++n2;
        }
        BitSet hasB = new BitSet();
        long[] lArray2 = arrayB;
        int n3 = arrayB.length;
        n = 0;
        while (n < n3) {
            long value = lArray2[n];
            int zValue = BitfieldSafeCasts.safeCastS64toS32(value - valueBase);
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + value);
            }
            hasB.set(zValue);
            ++n;
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.LongList array) {
        ArrayUtilities.checkSmallRangeValuedArrayIsDuplicateless(array, SmallIntegerMathUtilities.least(array));
    }

    public static void checkSmallRangeValuedArrayIsDuplicateless(PrimitiveCollections.LongList array, long valueBase) {
        BitSet has = new BitSet();
        for (long value : array) {
            int zValue = BitfieldSafeCasts.safeCastS64toS32(value - valueBase);
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (has.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array!:  Multiple occurrences of " + value);
            }
            has.set(zValue);
        }
    }

    public static void checkSmallRangeValuedArraysAreDuplicatelessAndCoverSameValuesInPossiblyDifferentOrders(PrimitiveCollections.LongList arrayA, PrimitiveCollections.LongList arrayB, long valueBase) {
        if (arrayA.size() != arrayB.size()) {
            throw new IllegalArgumentException("They differ even in length as well!! \\o/");
        }
        BitSet hasA = new BitSet();
        for (long value : arrayA) {
            int zValue = BitfieldSafeCasts.safeCastS64toS32(value - valueBase);
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasA.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array A!:  Multiple occurrences of " + value);
            }
            hasA.set(zValue);
        }
        BitSet hasB = new BitSet();
        for (long value : arrayB) {
            int zValue = BitfieldSafeCasts.safeCastS64toS32(value - valueBase);
            if (zValue < 0) {
                throw new IllegalArgumentException();
            }
            if (hasB.get(zValue)) {
                throw new IllegalArgumentException("Duplicates detected in array B!:  Multiple occurrences of " + value);
            }
            hasB.set(zValue);
        }
        if (!hasA.equals(hasB)) {
            throw new IllegalArgumentException("They differ even as sets in which values they contain, not just in the order of them!!");
        }
    }

    public static void rotateInPlaceBy1(boolean[] array, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        boolean last = array[length - 1 + offset];
        int i = length - 1;
        while (i >= 1) {
            int prev = i == 0 ? length - 1 : i;
            array[i + offset] = array[prev + offset];
            --i;
        }
        array[offset] = last;
    }

    public static void rotateInPlaceBy1(boolean[] array) {
        ArrayUtilities.rotateInPlaceBy1(array, 0, array.length);
    }

    public static void rotateIntoBy1(boolean[] source, int sourceOffset, int length, @WritableValue boolean[] dest, int destOffset) {
        if (source == dest) {
            if (sourceOffset == destOffset) {
                ArrayUtilities.rotateInPlaceBy1(source, sourceOffset, length);
            } else {
                throw new NotYetImplementedException();
            }
        }
        if (length < 0 || sourceOffset < 0 || sourceOffset + length > source.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int prev = i == 0 ? length - 1 : i;
            source[i + sourceOffset] = source[prev + sourceOffset];
            --i;
        }
    }

    @ThrowAwayValue
    public static boolean[] rotateOutOfPlaceBy1(boolean[] array, int offset, int length) {
        boolean[] output = new boolean[length];
        ArrayUtilities.rotateIntoBy1(array, offset, length, output, 0);
        return output;
    }

    @ThrowAwayValue
    public static boolean[] rotateOutOfPlaceBy1(boolean[] array) {
        return ArrayUtilities.rotateOutOfPlaceBy1(array, 0, array.length);
    }

    public static void rotateInPlaceBy1(byte[] array, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        byte last = array[length - 1 + offset];
        int i = length - 1;
        while (i >= 1) {
            int prev = i == 0 ? length - 1 : i;
            array[i + offset] = array[prev + offset];
            --i;
        }
        array[offset] = last;
    }

    public static void rotateInPlaceBy1(byte[] array) {
        ArrayUtilities.rotateInPlaceBy1(array, 0, array.length);
    }

    public static void rotateIntoBy1(byte[] source, int sourceOffset, int length, @WritableValue byte[] dest, int destOffset) {
        if (source == dest) {
            if (sourceOffset == destOffset) {
                ArrayUtilities.rotateInPlaceBy1(source, sourceOffset, length);
            } else {
                throw new NotYetImplementedException();
            }
        }
        if (length < 0 || sourceOffset < 0 || sourceOffset + length > source.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int prev = i == 0 ? length - 1 : i;
            source[i + sourceOffset] = source[prev + sourceOffset];
            --i;
        }
    }

    @ThrowAwayValue
    public static byte[] rotateOutOfPlaceBy1(byte[] array, int offset, int length) {
        byte[] output = new byte[length];
        ArrayUtilities.rotateIntoBy1(array, offset, length, output, 0);
        return output;
    }

    @ThrowAwayValue
    public static byte[] rotateOutOfPlaceBy1(byte[] array) {
        return ArrayUtilities.rotateOutOfPlaceBy1(array, 0, array.length);
    }

    public static void rotateInPlaceBy1(char[] array, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        char last = array[length - 1 + offset];
        int i = length - 1;
        while (i >= 1) {
            int prev = i == 0 ? length - 1 : i;
            array[i + offset] = array[prev + offset];
            --i;
        }
        array[offset] = last;
    }

    public static void rotateInPlaceBy1(char[] array) {
        ArrayUtilities.rotateInPlaceBy1(array, 0, array.length);
    }

    public static void rotateIntoBy1(char[] source, int sourceOffset, int length, @WritableValue char[] dest, int destOffset) {
        if (source == dest) {
            if (sourceOffset == destOffset) {
                ArrayUtilities.rotateInPlaceBy1(source, sourceOffset, length);
            } else {
                throw new NotYetImplementedException();
            }
        }
        if (length < 0 || sourceOffset < 0 || sourceOffset + length > source.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int prev = i == 0 ? length - 1 : i;
            source[i + sourceOffset] = source[prev + sourceOffset];
            --i;
        }
    }

    @ThrowAwayValue
    public static char[] rotateOutOfPlaceBy1(char[] array, int offset, int length) {
        char[] output = new char[length];
        ArrayUtilities.rotateIntoBy1(array, offset, length, output, 0);
        return output;
    }

    @ThrowAwayValue
    public static char[] rotateOutOfPlaceBy1(char[] array) {
        return ArrayUtilities.rotateOutOfPlaceBy1(array, 0, array.length);
    }

    public static void rotateInPlaceBy1(short[] array, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        short last = array[length - 1 + offset];
        int i = length - 1;
        while (i >= 1) {
            int prev = i == 0 ? length - 1 : i;
            array[i + offset] = array[prev + offset];
            --i;
        }
        array[offset] = last;
    }

    public static void rotateInPlaceBy1(short[] array) {
        ArrayUtilities.rotateInPlaceBy1(array, 0, array.length);
    }

    public static void rotateIntoBy1(short[] source, int sourceOffset, int length, @WritableValue short[] dest, int destOffset) {
        if (source == dest) {
            if (sourceOffset == destOffset) {
                ArrayUtilities.rotateInPlaceBy1(source, sourceOffset, length);
            } else {
                throw new NotYetImplementedException();
            }
        }
        if (length < 0 || sourceOffset < 0 || sourceOffset + length > source.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int prev = i == 0 ? length - 1 : i;
            source[i + sourceOffset] = source[prev + sourceOffset];
            --i;
        }
    }

    @ThrowAwayValue
    public static short[] rotateOutOfPlaceBy1(short[] array, int offset, int length) {
        short[] output = new short[length];
        ArrayUtilities.rotateIntoBy1(array, offset, length, output, 0);
        return output;
    }

    @ThrowAwayValue
    public static short[] rotateOutOfPlaceBy1(short[] array) {
        return ArrayUtilities.rotateOutOfPlaceBy1(array, 0, array.length);
    }

    public static void rotateInPlaceBy1(float[] array, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        float last = array[length - 1 + offset];
        int i = length - 1;
        while (i >= 1) {
            int prev = i == 0 ? length - 1 : i;
            array[i + offset] = array[prev + offset];
            --i;
        }
        array[offset] = last;
    }

    public static void rotateInPlaceBy1(float[] array) {
        ArrayUtilities.rotateInPlaceBy1(array, 0, array.length);
    }

    public static void rotateIntoBy1(float[] source, int sourceOffset, int length, @WritableValue float[] dest, int destOffset) {
        if (source == dest) {
            if (sourceOffset == destOffset) {
                ArrayUtilities.rotateInPlaceBy1(source, sourceOffset, length);
            } else {
                throw new NotYetImplementedException();
            }
        }
        if (length < 0 || sourceOffset < 0 || sourceOffset + length > source.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int prev = i == 0 ? length - 1 : i;
            source[i + sourceOffset] = source[prev + sourceOffset];
            --i;
        }
    }

    @ThrowAwayValue
    public static float[] rotateOutOfPlaceBy1(float[] array, int offset, int length) {
        float[] output = new float[length];
        ArrayUtilities.rotateIntoBy1(array, offset, length, output, 0);
        return output;
    }

    @ThrowAwayValue
    public static float[] rotateOutOfPlaceBy1(float[] array) {
        return ArrayUtilities.rotateOutOfPlaceBy1(array, 0, array.length);
    }

    public static void rotateInPlaceBy1(int[] array, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int last = array[length - 1 + offset];
        int i = length - 1;
        while (i >= 1) {
            int prev = i == 0 ? length - 1 : i;
            array[i + offset] = array[prev + offset];
            --i;
        }
        array[offset] = last;
    }

    public static void rotateInPlaceBy1(int[] array) {
        ArrayUtilities.rotateInPlaceBy1(array, 0, array.length);
    }

    public static void rotateIntoBy1(int[] source, int sourceOffset, int length, @WritableValue int[] dest, int destOffset) {
        if (source == dest) {
            if (sourceOffset == destOffset) {
                ArrayUtilities.rotateInPlaceBy1(source, sourceOffset, length);
            } else {
                throw new NotYetImplementedException();
            }
        }
        if (length < 0 || sourceOffset < 0 || sourceOffset + length > source.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int prev = i == 0 ? length - 1 : i;
            source[i + sourceOffset] = source[prev + sourceOffset];
            --i;
        }
    }

    @ThrowAwayValue
    public static int[] rotateOutOfPlaceBy1(int[] array, int offset, int length) {
        int[] output = new int[length];
        ArrayUtilities.rotateIntoBy1(array, offset, length, output, 0);
        return output;
    }

    @ThrowAwayValue
    public static int[] rotateOutOfPlaceBy1(int[] array) {
        return ArrayUtilities.rotateOutOfPlaceBy1(array, 0, array.length);
    }

    public static void rotateInPlaceBy1(double[] array, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        double last = array[length - 1 + offset];
        int i = length - 1;
        while (i >= 1) {
            int prev = i == 0 ? length - 1 : i;
            array[i + offset] = array[prev + offset];
            --i;
        }
        array[offset] = last;
    }

    public static void rotateInPlaceBy1(double[] array) {
        ArrayUtilities.rotateInPlaceBy1(array, 0, array.length);
    }

    public static void rotateIntoBy1(double[] source, int sourceOffset, int length, @WritableValue double[] dest, int destOffset) {
        if (source == dest) {
            if (sourceOffset == destOffset) {
                ArrayUtilities.rotateInPlaceBy1(source, sourceOffset, length);
            } else {
                throw new NotYetImplementedException();
            }
        }
        if (length < 0 || sourceOffset < 0 || sourceOffset + length > source.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int prev = i == 0 ? length - 1 : i;
            source[i + sourceOffset] = source[prev + sourceOffset];
            --i;
        }
    }

    @ThrowAwayValue
    public static double[] rotateOutOfPlaceBy1(double[] array, int offset, int length) {
        double[] output = new double[length];
        ArrayUtilities.rotateIntoBy1(array, offset, length, output, 0);
        return output;
    }

    @ThrowAwayValue
    public static double[] rotateOutOfPlaceBy1(double[] array) {
        return ArrayUtilities.rotateOutOfPlaceBy1(array, 0, array.length);
    }

    public static void rotateInPlaceBy1(long[] array, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        long last = array[length - 1 + offset];
        int i = length - 1;
        while (i >= 1) {
            int prev = i == 0 ? length - 1 : i;
            array[i + offset] = array[prev + offset];
            --i;
        }
        array[offset] = last;
    }

    public static void rotateInPlaceBy1(long[] array) {
        ArrayUtilities.rotateInPlaceBy1(array, 0, array.length);
    }

    public static void rotateIntoBy1(long[] source, int sourceOffset, int length, @WritableValue long[] dest, int destOffset) {
        if (source == dest) {
            if (sourceOffset == destOffset) {
                ArrayUtilities.rotateInPlaceBy1(source, sourceOffset, length);
            } else {
                throw new NotYetImplementedException();
            }
        }
        if (length < 0 || sourceOffset < 0 || sourceOffset + length > source.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int prev = i == 0 ? length - 1 : i;
            source[i + sourceOffset] = source[prev + sourceOffset];
            --i;
        }
    }

    @ThrowAwayValue
    public static long[] rotateOutOfPlaceBy1(long[] array, int offset, int length) {
        long[] output = new long[length];
        ArrayUtilities.rotateIntoBy1(array, offset, length, output, 0);
        return output;
    }

    @ThrowAwayValue
    public static long[] rotateOutOfPlaceBy1(long[] array) {
        return ArrayUtilities.rotateOutOfPlaceBy1(array, 0, array.length);
    }

    public static void rotateInPlaceBy1(Object[] array, int offset, int length) {
        if (length < 0 || offset < 0 || offset + length > array.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        Object last = array[length - 1 + offset];
        int i = length - 1;
        while (i >= 1) {
            int prev = i == 0 ? length - 1 : i;
            array[i + offset] = array[prev + offset];
            --i;
        }
        array[offset] = last;
    }

    public static void rotateInPlaceBy1(Object[] array) {
        ArrayUtilities.rotateInPlaceBy1(array, 0, array.length);
    }

    public static void rotateIntoBy1(Object[] source, int sourceOffset, int length, @WritableValue Object[] dest, int destOffset) {
        if (source == dest) {
            if (sourceOffset == destOffset) {
                ArrayUtilities.rotateInPlaceBy1(source, sourceOffset, length);
            } else {
                throw new NotYetImplementedException();
            }
        }
        if (length < 0 || sourceOffset < 0 || sourceOffset + length > source.length) {
            throw new IndexOutOfBoundsException();
        }
        if (length == 0) {
            return;
        }
        int i = length - 1;
        while (i >= 0) {
            int prev = i == 0 ? length - 1 : i;
            source[i + sourceOffset] = source[prev + sourceOffset];
            --i;
        }
    }

    @ThrowAwayValue
    public static Object[] rotateOutOfPlaceBy1(Object[] array, int offset, int length) {
        Object[] output = new Object[length];
        ArrayUtilities.rotateIntoBy1(array, offset, length, output, 0);
        return output;
    }

    @ThrowAwayValue
    public static Object[] rotateOutOfPlaceBy1(Object[] array) {
        return ArrayUtilities.rotateOutOfPlaceBy1(array, 0, array.length);
    }

    public static void fillRangeByLength(@WritableValue byte[] array, int offset, byte inclusiveStart, int length, byte step) {
        int i = 0;
        while (i < length) {
            array[offset + i] = (byte)(inclusiveStart + step * i);
            ++i;
        }
    }

    public static void fillRangeByLength(@WritableValue byte[] array, int offset, byte inclusiveStart, int length) {
        ArrayUtilities.fillRangeByLength(array, offset, inclusiveStart, length, (byte)1);
    }

    @ThrowAwayValue
    public static byte[] rangeByLength(byte inclusiveStart, int length, byte step) {
        byte[] array = new byte[length];
        ArrayUtilities.fillRangeByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    public static byte[] rangeByLength(byte inclusiveStart, int length) {
        return ArrayUtilities.rangeByLength(inclusiveStart, length, (byte)1);
    }

    public static byte[] range(byte inclusiveStart, byte exclusiveEnd) {
        int length = exclusiveEnd - inclusiveStart;
        return ArrayUtilities.rangeByLength(inclusiveStart, length);
    }

    public static byte[] range(byte exclusiveEnd) {
        return ArrayUtilities.range((byte)0, exclusiveEnd);
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.ByteList array, int offset, byte inclusiveStart, int length, byte step) {
        int i = 0;
        while (i < length) {
            array.setByte(offset + i, (byte)(inclusiveStart + step * i));
            ++i;
        }
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.ByteList array, int offset, byte inclusiveStart, int length) {
        ArrayUtilities.fillRangeListByLength(array, offset, inclusiveStart, length, (byte)1);
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.ByteList rangeListByLength(byte inclusiveStart, int length, byte step) {
        PrimitiveCollections.ByteList array = PrimitiveCollections.newByteListZerofilled(length);
        ArrayUtilities.fillRangeListByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.ByteList rangeListByLength(byte inclusiveStart, int length) {
        return ArrayUtilities.rangeListByLength(inclusiveStart, length, (byte)1);
    }

    @WritableValue
    public static PrimitiveCollections.ByteList rangeList(byte inclusiveStart, byte exclusiveEnd) {
        int length = exclusiveEnd - inclusiveStart;
        return ArrayUtilities.rangeListByLength(inclusiveStart, length);
    }

    @WritableValue
    public static PrimitiveCollections.ByteList rangeList(byte exclusiveEnd) {
        return ArrayUtilities.rangeList((byte)0, exclusiveEnd);
    }

    public static void fillRangeByLength(@WritableValue char[] array, int offset, char inclusiveStart, int length, char step) {
        int i = 0;
        while (i < length) {
            array[offset + i] = (char)(inclusiveStart + step * i);
            ++i;
        }
    }

    public static void fillRangeByLength(@WritableValue char[] array, int offset, char inclusiveStart, int length) {
        ArrayUtilities.fillRangeByLength(array, offset, inclusiveStart, length, '\u0001');
    }

    @ThrowAwayValue
    public static char[] rangeByLength(char inclusiveStart, int length, char step) {
        char[] array = new char[length];
        ArrayUtilities.fillRangeByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    public static char[] rangeByLength(char inclusiveStart, int length) {
        return ArrayUtilities.rangeByLength(inclusiveStart, length, '\u0001');
    }

    public static char[] range(char inclusiveStart, char exclusiveEnd) {
        int length = exclusiveEnd - inclusiveStart;
        return ArrayUtilities.rangeByLength(inclusiveStart, length);
    }

    public static char[] range(char exclusiveEnd) {
        return ArrayUtilities.range('\u0000', exclusiveEnd);
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.CharacterList array, int offset, char inclusiveStart, int length, char step) {
        int i = 0;
        while (i < length) {
            array.setChar(offset + i, (char)(inclusiveStart + step * i));
            ++i;
        }
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.CharacterList array, int offset, char inclusiveStart, int length) {
        ArrayUtilities.fillRangeListByLength(array, offset, inclusiveStart, length, '\u0001');
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.CharacterList rangeListByLength(char inclusiveStart, int length, char step) {
        PrimitiveCollections.CharacterList array = PrimitiveCollections.newCharacterListZerofilled(length);
        ArrayUtilities.fillRangeListByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.CharacterList rangeListByLength(char inclusiveStart, int length) {
        return ArrayUtilities.rangeListByLength(inclusiveStart, length, '\u0001');
    }

    @WritableValue
    public static PrimitiveCollections.CharacterList rangeList(char inclusiveStart, char exclusiveEnd) {
        int length = exclusiveEnd - inclusiveStart;
        return ArrayUtilities.rangeListByLength(inclusiveStart, length);
    }

    @WritableValue
    public static PrimitiveCollections.CharacterList rangeList(char exclusiveEnd) {
        return ArrayUtilities.rangeList('\u0000', exclusiveEnd);
    }

    public static void fillRangeByLength(@WritableValue short[] array, int offset, short inclusiveStart, int length, short step) {
        int i = 0;
        while (i < length) {
            array[offset + i] = (short)(inclusiveStart + step * i);
            ++i;
        }
    }

    public static void fillRangeByLength(@WritableValue short[] array, int offset, short inclusiveStart, int length) {
        ArrayUtilities.fillRangeByLength(array, offset, inclusiveStart, length, (short)1);
    }

    @ThrowAwayValue
    public static short[] rangeByLength(short inclusiveStart, int length, short step) {
        short[] array = new short[length];
        ArrayUtilities.fillRangeByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    public static short[] rangeByLength(short inclusiveStart, int length) {
        return ArrayUtilities.rangeByLength(inclusiveStart, length, (short)1);
    }

    public static short[] range(short inclusiveStart, short exclusiveEnd) {
        int length = exclusiveEnd - inclusiveStart;
        return ArrayUtilities.rangeByLength(inclusiveStart, length);
    }

    public static short[] range(short exclusiveEnd) {
        return ArrayUtilities.range((short)0, exclusiveEnd);
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.ShortList array, int offset, short inclusiveStart, int length, short step) {
        int i = 0;
        while (i < length) {
            array.setShort(offset + i, (short)(inclusiveStart + step * i));
            ++i;
        }
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.ShortList array, int offset, short inclusiveStart, int length) {
        ArrayUtilities.fillRangeListByLength(array, offset, inclusiveStart, length, (short)1);
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.ShortList rangeListByLength(short inclusiveStart, int length, short step) {
        PrimitiveCollections.ShortList array = PrimitiveCollections.newShortListZerofilled(length);
        ArrayUtilities.fillRangeListByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.ShortList rangeListByLength(short inclusiveStart, int length) {
        return ArrayUtilities.rangeListByLength(inclusiveStart, length, (short)1);
    }

    @WritableValue
    public static PrimitiveCollections.ShortList rangeList(short inclusiveStart, short exclusiveEnd) {
        int length = exclusiveEnd - inclusiveStart;
        return ArrayUtilities.rangeListByLength(inclusiveStart, length);
    }

    @WritableValue
    public static PrimitiveCollections.ShortList rangeList(short exclusiveEnd) {
        return ArrayUtilities.rangeList((short)0, exclusiveEnd);
    }

    public static void fillRangeByLength(@WritableValue int[] array, int offset, int inclusiveStart, int length, int step) {
        int i = 0;
        while (i < length) {
            array[offset + i] = inclusiveStart + step * i;
            ++i;
        }
    }

    public static void fillRangeByLength(@WritableValue int[] array, int offset, int inclusiveStart, int length) {
        ArrayUtilities.fillRangeByLength(array, offset, inclusiveStart, length, 1);
    }

    @ThrowAwayValue
    public static int[] rangeByLength(int inclusiveStart, int length, int step) {
        int[] array = new int[length];
        ArrayUtilities.fillRangeByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    public static int[] rangeByLength(int inclusiveStart, int length) {
        return ArrayUtilities.rangeByLength(inclusiveStart, length, 1);
    }

    public static int[] range(int inclusiveStart, int exclusiveEnd) {
        int length = exclusiveEnd - inclusiveStart;
        return ArrayUtilities.rangeByLength(inclusiveStart, length);
    }

    public static int[] range(int exclusiveEnd) {
        return ArrayUtilities.range(0, exclusiveEnd);
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.IntegerList array, int offset, int inclusiveStart, int length, int step) {
        int i = 0;
        while (i < length) {
            array.setInt(offset + i, inclusiveStart + step * i);
            ++i;
        }
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.IntegerList array, int offset, int inclusiveStart, int length) {
        ArrayUtilities.fillRangeListByLength(array, offset, inclusiveStart, length, 1);
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.IntegerList rangeListByLength(int inclusiveStart, int length, int step) {
        PrimitiveCollections.IntegerList array = PrimitiveCollections.newIntegerListZerofilled(length);
        ArrayUtilities.fillRangeListByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.IntegerList rangeListByLength(int inclusiveStart, int length) {
        return ArrayUtilities.rangeListByLength(inclusiveStart, length, 1);
    }

    @WritableValue
    public static PrimitiveCollections.IntegerList rangeList(int inclusiveStart, int exclusiveEnd) {
        int length = exclusiveEnd - inclusiveStart;
        return ArrayUtilities.rangeListByLength(inclusiveStart, length);
    }

    @WritableValue
    public static PrimitiveCollections.IntegerList rangeList(int exclusiveEnd) {
        return ArrayUtilities.rangeList(0, exclusiveEnd);
    }

    public static void fillRangeByLength(@WritableValue float[] array, int offset, float inclusiveStart, int length, float step) {
        int i = 0;
        while (i < length) {
            array[offset + i] = inclusiveStart + step * (float)i;
            ++i;
        }
    }

    public static void fillRangeByLength(@WritableValue float[] array, int offset, float inclusiveStart, int length) {
        ArrayUtilities.fillRangeByLength(array, offset, inclusiveStart, length, 1.0f);
    }

    @ThrowAwayValue
    public static float[] rangeByLength(float inclusiveStart, int length, float step) {
        float[] array = new float[length];
        ArrayUtilities.fillRangeByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    public static float[] rangeByLength(float inclusiveStart, int length) {
        return ArrayUtilities.rangeByLength(inclusiveStart, length, 1.0f);
    }

    public static float[] range(float inclusiveStart, float exclusiveEnd) {
        int length = SmallFloatMathUtilities.safeCastIntegerValuedFloatingPointF32toS32(exclusiveEnd - inclusiveStart);
        return ArrayUtilities.rangeByLength(inclusiveStart, length);
    }

    public static float[] range(float exclusiveEnd) {
        return ArrayUtilities.range(0.0f, exclusiveEnd);
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.FloatList array, int offset, float inclusiveStart, int length, float step) {
        int i = 0;
        while (i < length) {
            array.setFloat(offset + i, inclusiveStart + step * (float)i);
            ++i;
        }
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.FloatList array, int offset, float inclusiveStart, int length) {
        ArrayUtilities.fillRangeListByLength(array, offset, inclusiveStart, length, 1.0f);
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.FloatList rangeListByLength(float inclusiveStart, int length, float step) {
        PrimitiveCollections.FloatList array = PrimitiveCollections.newFloatListZerofilled(length);
        ArrayUtilities.fillRangeListByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.FloatList rangeListByLength(float inclusiveStart, int length) {
        return ArrayUtilities.rangeListByLength(inclusiveStart, length, 1.0f);
    }

    @WritableValue
    public static PrimitiveCollections.FloatList rangeList(float inclusiveStart, float exclusiveEnd) {
        int length = SmallFloatMathUtilities.safeCastIntegerValuedFloatingPointF32toS32(exclusiveEnd - inclusiveStart);
        return ArrayUtilities.rangeListByLength(inclusiveStart, length);
    }

    @WritableValue
    public static PrimitiveCollections.FloatList rangeList(float exclusiveEnd) {
        return ArrayUtilities.rangeList(0.0f, exclusiveEnd);
    }

    public static void fillRangeByLength(@WritableValue double[] array, int offset, double inclusiveStart, int length, double step) {
        int i = 0;
        while (i < length) {
            array[offset + i] = inclusiveStart + step * (double)i;
            ++i;
        }
    }

    public static void fillRangeByLength(@WritableValue double[] array, int offset, double inclusiveStart, int length) {
        ArrayUtilities.fillRangeByLength(array, offset, inclusiveStart, length, 1.0);
    }

    @ThrowAwayValue
    public static double[] rangeByLength(double inclusiveStart, int length, double step) {
        double[] array = new double[length];
        ArrayUtilities.fillRangeByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    public static double[] rangeByLength(double inclusiveStart, int length) {
        return ArrayUtilities.rangeByLength(inclusiveStart, length, 1.0);
    }

    public static double[] range(double inclusiveStart, double exclusiveEnd) {
        int length = SmallFloatMathUtilities.safeCastIntegerValuedFloatingPointF64toS32(exclusiveEnd - inclusiveStart);
        return ArrayUtilities.rangeByLength(inclusiveStart, length);
    }

    public static double[] range(double exclusiveEnd) {
        return ArrayUtilities.range(0.0, exclusiveEnd);
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.DoubleList array, int offset, double inclusiveStart, int length, double step) {
        int i = 0;
        while (i < length) {
            array.setDouble(offset + i, inclusiveStart + step * (double)i);
            ++i;
        }
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.DoubleList array, int offset, double inclusiveStart, int length) {
        ArrayUtilities.fillRangeListByLength(array, offset, inclusiveStart, length, 1.0);
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.DoubleList rangeListByLength(double inclusiveStart, int length, double step) {
        PrimitiveCollections.DoubleList array = PrimitiveCollections.newDoubleListZerofilled(length);
        ArrayUtilities.fillRangeListByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.DoubleList rangeListByLength(double inclusiveStart, int length) {
        return ArrayUtilities.rangeListByLength(inclusiveStart, length, 1.0);
    }

    @WritableValue
    public static PrimitiveCollections.DoubleList rangeList(double inclusiveStart, double exclusiveEnd) {
        int length = SmallFloatMathUtilities.safeCastIntegerValuedFloatingPointF64toS32(exclusiveEnd - inclusiveStart);
        return ArrayUtilities.rangeListByLength(inclusiveStart, length);
    }

    @WritableValue
    public static PrimitiveCollections.DoubleList rangeList(double exclusiveEnd) {
        return ArrayUtilities.rangeList(0.0, exclusiveEnd);
    }

    public static void fillRangeByLength(@WritableValue long[] array, int offset, long inclusiveStart, int length, long step) {
        int i = 0;
        while (i < length) {
            array[offset + i] = inclusiveStart + step * (long)i;
            ++i;
        }
    }

    public static void fillRangeByLength(@WritableValue long[] array, int offset, long inclusiveStart, int length) {
        ArrayUtilities.fillRangeByLength(array, offset, inclusiveStart, length, 1L);
    }

    @ThrowAwayValue
    public static long[] rangeByLength(long inclusiveStart, int length, long step) {
        long[] array = new long[length];
        ArrayUtilities.fillRangeByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    public static long[] rangeByLength(long inclusiveStart, int length) {
        return ArrayUtilities.rangeByLength(inclusiveStart, length, 1L);
    }

    public static long[] range(long inclusiveStart, long exclusiveEnd) {
        int length = BitfieldSafeCasts.safeCastS64toS32(exclusiveEnd - inclusiveStart);
        return ArrayUtilities.rangeByLength(inclusiveStart, length);
    }

    public static long[] range(long exclusiveEnd) {
        return ArrayUtilities.range(0L, exclusiveEnd);
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.LongList array, int offset, long inclusiveStart, int length, long step) {
        int i = 0;
        while (i < length) {
            array.setLong(offset + i, inclusiveStart + step * (long)i);
            ++i;
        }
    }

    public static void fillRangeListByLength(@WritableValue PrimitiveCollections.LongList array, int offset, long inclusiveStart, int length) {
        ArrayUtilities.fillRangeListByLength(array, offset, inclusiveStart, length, 1L);
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.LongList rangeListByLength(long inclusiveStart, int length, long step) {
        PrimitiveCollections.LongList array = PrimitiveCollections.newLongListZerofilled(length);
        ArrayUtilities.fillRangeListByLength(array, 0, inclusiveStart, length, step);
        return array;
    }

    @ThrowAwayValue
    @WritableValue
    public static PrimitiveCollections.LongList rangeListByLength(long inclusiveStart, int length) {
        return ArrayUtilities.rangeListByLength(inclusiveStart, length, 1L);
    }

    @WritableValue
    public static PrimitiveCollections.LongList rangeList(long inclusiveStart, long exclusiveEnd) {
        int length = BitfieldSafeCasts.safeCastS64toS32(exclusiveEnd - inclusiveStart);
        return ArrayUtilities.rangeListByLength(inclusiveStart, length);
    }

    @WritableValue
    public static PrimitiveCollections.LongList rangeList(long exclusiveEnd) {
        return ArrayUtilities.rangeList(0L, exclusiveEnd);
    }

    @ThrowAwayValue
    public static boolean[] join(boolean delimiter, boolean[] ... strings) {
        if (strings.length == 0) {
            return EmptyBooleanArray;
        }
        int nStrings = strings.length;
        int totalLengthOfStrings = 0;
        boolean[][] blArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            boolean[] string = blArray[n2];
            totalLengthOfStrings += string.length;
            ++n2;
        }
        boolean delimiterLength = true;
        int totalLength = totalLengthOfStrings + 1 * (nStrings - 1);
        boolean[] joined = new boolean[totalLength];
        int pos = 0;
        int stringIndex = 0;
        while (stringIndex < nStrings) {
            boolean last = stringIndex == nStrings - 1;
            boolean[] s = strings[stringIndex];
            int sl = s.length;
            System.arraycopy(s, 0, joined, pos, sl);
            pos += sl;
            if (!last) {
                joined[pos] = delimiter;
                ++pos;
            }
            ++stringIndex;
        }
        return joined;
    }

    @ThrowAwayValue
    public static byte[] join(byte delimiter, byte[] ... strings) {
        if (strings.length == 0) {
            return EmptyByteArray;
        }
        int nStrings = strings.length;
        int totalLengthOfStrings = 0;
        byte[][] byArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            byte[] string = byArray[n2];
            totalLengthOfStrings += string.length;
            ++n2;
        }
        boolean delimiterLength = true;
        int totalLength = totalLengthOfStrings + 1 * (nStrings - 1);
        byte[] joined = new byte[totalLength];
        int pos = 0;
        int stringIndex = 0;
        while (stringIndex < nStrings) {
            boolean last = stringIndex == nStrings - 1;
            byte[] s = strings[stringIndex];
            int sl = s.length;
            System.arraycopy(s, 0, joined, pos, sl);
            pos += sl;
            if (!last) {
                joined[pos] = delimiter;
                ++pos;
            }
            ++stringIndex;
        }
        return joined;
    }

    @ThrowAwayValue
    public static char[] join(char delimiter, char[] ... strings) {
        if (strings.length == 0) {
            return EmptyCharArray;
        }
        int nStrings = strings.length;
        int totalLengthOfStrings = 0;
        char[][] cArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            char[] string = cArray[n2];
            totalLengthOfStrings += string.length;
            ++n2;
        }
        boolean delimiterLength = true;
        int totalLength = totalLengthOfStrings + 1 * (nStrings - 1);
        char[] joined = new char[totalLength];
        int pos = 0;
        int stringIndex = 0;
        while (stringIndex < nStrings) {
            boolean last = stringIndex == nStrings - 1;
            char[] s = strings[stringIndex];
            int sl = s.length;
            System.arraycopy(s, 0, joined, pos, sl);
            pos += sl;
            if (!last) {
                joined[pos] = delimiter;
                ++pos;
            }
            ++stringIndex;
        }
        return joined;
    }

    @ThrowAwayValue
    public static short[] join(short delimiter, short[] ... strings) {
        if (strings.length == 0) {
            return EmptyShortArray;
        }
        int nStrings = strings.length;
        int totalLengthOfStrings = 0;
        short[][] sArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            short[] string = sArray[n2];
            totalLengthOfStrings += string.length;
            ++n2;
        }
        boolean delimiterLength = true;
        int totalLength = totalLengthOfStrings + 1 * (nStrings - 1);
        short[] joined = new short[totalLength];
        int pos = 0;
        int stringIndex = 0;
        while (stringIndex < nStrings) {
            boolean last = stringIndex == nStrings - 1;
            short[] s = strings[stringIndex];
            int sl = s.length;
            System.arraycopy(s, 0, joined, pos, sl);
            pos += sl;
            if (!last) {
                joined[pos] = delimiter;
                ++pos;
            }
            ++stringIndex;
        }
        return joined;
    }

    @ThrowAwayValue
    public static float[] join(float delimiter, float[] ... strings) {
        if (strings.length == 0) {
            return EmptyFloatArray;
        }
        int nStrings = strings.length;
        int totalLengthOfStrings = 0;
        float[][] fArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            float[] string = fArray[n2];
            totalLengthOfStrings += string.length;
            ++n2;
        }
        boolean delimiterLength = true;
        int totalLength = totalLengthOfStrings + 1 * (nStrings - 1);
        float[] joined = new float[totalLength];
        int pos = 0;
        int stringIndex = 0;
        while (stringIndex < nStrings) {
            boolean last = stringIndex == nStrings - 1;
            float[] s = strings[stringIndex];
            int sl = s.length;
            System.arraycopy(s, 0, joined, pos, sl);
            pos += sl;
            if (!last) {
                joined[pos] = delimiter;
                ++pos;
            }
            ++stringIndex;
        }
        return joined;
    }

    @ThrowAwayValue
    public static int[] join(int delimiter, int[] ... strings) {
        if (strings.length == 0) {
            return EmptyIntArray;
        }
        int nStrings = strings.length;
        int totalLengthOfStrings = 0;
        int[][] nArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            int[] string = nArray[n2];
            totalLengthOfStrings += string.length;
            ++n2;
        }
        boolean delimiterLength = true;
        int totalLength = totalLengthOfStrings + 1 * (nStrings - 1);
        int[] joined = new int[totalLength];
        int pos = 0;
        int stringIndex = 0;
        while (stringIndex < nStrings) {
            boolean last = stringIndex == nStrings - 1;
            int[] s = strings[stringIndex];
            int sl = s.length;
            System.arraycopy(s, 0, joined, pos, sl);
            pos += sl;
            if (!last) {
                joined[pos] = delimiter;
                ++pos;
            }
            ++stringIndex;
        }
        return joined;
    }

    @ThrowAwayValue
    public static double[] join(double delimiter, double[] ... strings) {
        if (strings.length == 0) {
            return EmptyDoubleArray;
        }
        int nStrings = strings.length;
        int totalLengthOfStrings = 0;
        double[][] dArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            double[] string = dArray[n2];
            totalLengthOfStrings += string.length;
            ++n2;
        }
        boolean delimiterLength = true;
        int totalLength = totalLengthOfStrings + 1 * (nStrings - 1);
        double[] joined = new double[totalLength];
        int pos = 0;
        int stringIndex = 0;
        while (stringIndex < nStrings) {
            boolean last = stringIndex == nStrings - 1;
            double[] s = strings[stringIndex];
            int sl = s.length;
            System.arraycopy(s, 0, joined, pos, sl);
            pos += sl;
            if (!last) {
                joined[pos] = delimiter;
                ++pos;
            }
            ++stringIndex;
        }
        return joined;
    }

    @ThrowAwayValue
    public static long[] join(long delimiter, long[] ... strings) {
        if (strings.length == 0) {
            return EmptyLongArray;
        }
        int nStrings = strings.length;
        int totalLengthOfStrings = 0;
        long[][] lArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            long[] string = lArray[n2];
            totalLengthOfStrings += string.length;
            ++n2;
        }
        boolean delimiterLength = true;
        int totalLength = totalLengthOfStrings + 1 * (nStrings - 1);
        long[] joined = new long[totalLength];
        int pos = 0;
        int stringIndex = 0;
        while (stringIndex < nStrings) {
            boolean last = stringIndex == nStrings - 1;
            long[] s = strings[stringIndex];
            int sl = s.length;
            System.arraycopy(s, 0, joined, pos, sl);
            pos += sl;
            if (!last) {
                joined[pos] = delimiter;
                ++pos;
            }
            ++stringIndex;
        }
        return joined;
    }

    public static void replaceByPatternInPlace(@WritableValue boolean[] array, FunctionInterfaces.UnaryFunctionBooleanToBoolean pattern, boolean replacement) {
        ArrayUtilities.replaceByPattern(array, array, pattern, replacement);
    }

    @ThrowAwayValue
    public static boolean[] replaceByPatternToNew(@ReadonlyValue boolean[] sourceArray, FunctionInterfaces.UnaryFunctionBooleanToBoolean pattern, boolean replacement) {
        boolean[] newArray = new boolean[sourceArray.length];
        ArrayUtilities.replaceByPattern(sourceArray, newArray, pattern, replacement);
        return newArray;
    }

    public static void replaceByPattern(@ReadonlyValue boolean[] sourceArray, @WritableValue boolean[] destArray, FunctionInterfaces.UnaryFunctionBooleanToBoolean pattern, boolean replacement) {
        if (sourceArray.length != destArray.length) {
            throw new IllegalArgumentException();
        }
        ArrayUtilities.replaceByPattern(sourceArray, 0, destArray, 0, sourceArray.length, pattern, replacement);
    }

    public static void replaceByPattern(@ReadonlyValue boolean[] sourceArray, int sourceOffset, @WritableValue boolean[] destArray, int destOffset, int length, FunctionInterfaces.UnaryFunctionBooleanToBoolean pattern, boolean replacement) {
        int i = 0;
        while (i < length) {
            boolean s = sourceArray[sourceOffset + i];
            destArray[destOffset + i] = pattern.f(s) ? replacement : s;
            ++i;
        }
    }

    public static void replaceByPatternInPlace(@WritableValue byte[] array, FunctionInterfaces.UnaryFunctionByteToBoolean pattern, byte replacement) {
        ArrayUtilities.replaceByPattern(array, array, pattern, replacement);
    }

    @ThrowAwayValue
    public static byte[] replaceByPatternToNew(@ReadonlyValue byte[] sourceArray, FunctionInterfaces.UnaryFunctionByteToBoolean pattern, byte replacement) {
        byte[] newArray = new byte[sourceArray.length];
        ArrayUtilities.replaceByPattern(sourceArray, newArray, pattern, replacement);
        return newArray;
    }

    public static void replaceByPattern(@ReadonlyValue byte[] sourceArray, @WritableValue byte[] destArray, FunctionInterfaces.UnaryFunctionByteToBoolean pattern, byte replacement) {
        if (sourceArray.length != destArray.length) {
            throw new IllegalArgumentException();
        }
        ArrayUtilities.replaceByPattern(sourceArray, 0, destArray, 0, sourceArray.length, pattern, replacement);
    }

    public static void replaceByPattern(@ReadonlyValue byte[] sourceArray, int sourceOffset, @WritableValue byte[] destArray, int destOffset, int length, FunctionInterfaces.UnaryFunctionByteToBoolean pattern, byte replacement) {
        int i = 0;
        while (i < length) {
            byte s = sourceArray[sourceOffset + i];
            destArray[destOffset + i] = pattern.f(s) ? replacement : s;
            ++i;
        }
    }

    public static void replaceByPatternInPlace(@WritableValue char[] array, FunctionInterfaces.UnaryFunctionCharToBoolean pattern, char replacement) {
        ArrayUtilities.replaceByPattern(array, array, pattern, replacement);
    }

    @ThrowAwayValue
    public static char[] replaceByPatternToNew(@ReadonlyValue char[] sourceArray, FunctionInterfaces.UnaryFunctionCharToBoolean pattern, char replacement) {
        char[] newArray = new char[sourceArray.length];
        ArrayUtilities.replaceByPattern(sourceArray, newArray, pattern, replacement);
        return newArray;
    }

    public static void replaceByPattern(@ReadonlyValue char[] sourceArray, @WritableValue char[] destArray, FunctionInterfaces.UnaryFunctionCharToBoolean pattern, char replacement) {
        if (sourceArray.length != destArray.length) {
            throw new IllegalArgumentException();
        }
        ArrayUtilities.replaceByPattern(sourceArray, 0, destArray, 0, sourceArray.length, pattern, replacement);
    }

    public static void replaceByPattern(@ReadonlyValue char[] sourceArray, int sourceOffset, @WritableValue char[] destArray, int destOffset, int length, FunctionInterfaces.UnaryFunctionCharToBoolean pattern, char replacement) {
        int i = 0;
        while (i < length) {
            char s = sourceArray[sourceOffset + i];
            destArray[destOffset + i] = pattern.f(s) ? replacement : s;
            ++i;
        }
    }

    public static void replaceByPatternInPlace(@WritableValue short[] array, FunctionInterfaces.UnaryFunctionShortToBoolean pattern, short replacement) {
        ArrayUtilities.replaceByPattern(array, array, pattern, replacement);
    }

    @ThrowAwayValue
    public static short[] replaceByPatternToNew(@ReadonlyValue short[] sourceArray, FunctionInterfaces.UnaryFunctionShortToBoolean pattern, short replacement) {
        short[] newArray = new short[sourceArray.length];
        ArrayUtilities.replaceByPattern(sourceArray, newArray, pattern, replacement);
        return newArray;
    }

    public static void replaceByPattern(@ReadonlyValue short[] sourceArray, @WritableValue short[] destArray, FunctionInterfaces.UnaryFunctionShortToBoolean pattern, short replacement) {
        if (sourceArray.length != destArray.length) {
            throw new IllegalArgumentException();
        }
        ArrayUtilities.replaceByPattern(sourceArray, 0, destArray, 0, sourceArray.length, pattern, replacement);
    }

    public static void replaceByPattern(@ReadonlyValue short[] sourceArray, int sourceOffset, @WritableValue short[] destArray, int destOffset, int length, FunctionInterfaces.UnaryFunctionShortToBoolean pattern, short replacement) {
        int i = 0;
        while (i < length) {
            short s = sourceArray[sourceOffset + i];
            destArray[destOffset + i] = pattern.f(s) ? replacement : s;
            ++i;
        }
    }

    public static void replaceByPatternInPlace(@WritableValue float[] array, FunctionInterfaces.UnaryFunctionFloatToBoolean pattern, float replacement) {
        ArrayUtilities.replaceByPattern(array, array, pattern, replacement);
    }

    @ThrowAwayValue
    public static float[] replaceByPatternToNew(@ReadonlyValue float[] sourceArray, FunctionInterfaces.UnaryFunctionFloatToBoolean pattern, float replacement) {
        float[] newArray = new float[sourceArray.length];
        ArrayUtilities.replaceByPattern(sourceArray, newArray, pattern, replacement);
        return newArray;
    }

    public static void replaceByPattern(@ReadonlyValue float[] sourceArray, @WritableValue float[] destArray, FunctionInterfaces.UnaryFunctionFloatToBoolean pattern, float replacement) {
        if (sourceArray.length != destArray.length) {
            throw new IllegalArgumentException();
        }
        ArrayUtilities.replaceByPattern(sourceArray, 0, destArray, 0, sourceArray.length, pattern, replacement);
    }

    public static void replaceByPattern(@ReadonlyValue float[] sourceArray, int sourceOffset, @WritableValue float[] destArray, int destOffset, int length, FunctionInterfaces.UnaryFunctionFloatToBoolean pattern, float replacement) {
        int i = 0;
        while (i < length) {
            float s = sourceArray[sourceOffset + i];
            destArray[destOffset + i] = pattern.f(s) ? replacement : s;
            ++i;
        }
    }

    public static void replaceByPatternInPlace(@WritableValue int[] array, FunctionInterfaces.UnaryFunctionIntToBoolean pattern, int replacement) {
        ArrayUtilities.replaceByPattern(array, array, pattern, replacement);
    }

    @ThrowAwayValue
    public static int[] replaceByPatternToNew(@ReadonlyValue int[] sourceArray, FunctionInterfaces.UnaryFunctionIntToBoolean pattern, int replacement) {
        int[] newArray = new int[sourceArray.length];
        ArrayUtilities.replaceByPattern(sourceArray, newArray, pattern, replacement);
        return newArray;
    }

    public static void replaceByPattern(@ReadonlyValue int[] sourceArray, @WritableValue int[] destArray, FunctionInterfaces.UnaryFunctionIntToBoolean pattern, int replacement) {
        if (sourceArray.length != destArray.length) {
            throw new IllegalArgumentException();
        }
        ArrayUtilities.replaceByPattern(sourceArray, 0, destArray, 0, sourceArray.length, pattern, replacement);
    }

    public static void replaceByPattern(@ReadonlyValue int[] sourceArray, int sourceOffset, @WritableValue int[] destArray, int destOffset, int length, FunctionInterfaces.UnaryFunctionIntToBoolean pattern, int replacement) {
        int i = 0;
        while (i < length) {
            int s = sourceArray[sourceOffset + i];
            destArray[destOffset + i] = pattern.f(s) ? replacement : s;
            ++i;
        }
    }

    public static void replaceByPatternInPlace(@WritableValue double[] array, FunctionInterfaces.UnaryFunctionDoubleToBoolean pattern, double replacement) {
        ArrayUtilities.replaceByPattern(array, array, pattern, replacement);
    }

    @ThrowAwayValue
    public static double[] replaceByPatternToNew(@ReadonlyValue double[] sourceArray, FunctionInterfaces.UnaryFunctionDoubleToBoolean pattern, double replacement) {
        double[] newArray = new double[sourceArray.length];
        ArrayUtilities.replaceByPattern(sourceArray, newArray, pattern, replacement);
        return newArray;
    }

    public static void replaceByPattern(@ReadonlyValue double[] sourceArray, @WritableValue double[] destArray, FunctionInterfaces.UnaryFunctionDoubleToBoolean pattern, double replacement) {
        if (sourceArray.length != destArray.length) {
            throw new IllegalArgumentException();
        }
        ArrayUtilities.replaceByPattern(sourceArray, 0, destArray, 0, sourceArray.length, pattern, replacement);
    }

    public static void replaceByPattern(@ReadonlyValue double[] sourceArray, int sourceOffset, @WritableValue double[] destArray, int destOffset, int length, FunctionInterfaces.UnaryFunctionDoubleToBoolean pattern, double replacement) {
        int i = 0;
        while (i < length) {
            double s = sourceArray[sourceOffset + i];
            destArray[destOffset + i] = pattern.f(s) ? replacement : s;
            ++i;
        }
    }

    public static void replaceByPatternInPlace(@WritableValue long[] array, FunctionInterfaces.UnaryFunctionLongToBoolean pattern, long replacement) {
        ArrayUtilities.replaceByPattern(array, array, pattern, replacement);
    }

    @ThrowAwayValue
    public static long[] replaceByPatternToNew(@ReadonlyValue long[] sourceArray, FunctionInterfaces.UnaryFunctionLongToBoolean pattern, long replacement) {
        long[] newArray = new long[sourceArray.length];
        ArrayUtilities.replaceByPattern(sourceArray, newArray, pattern, replacement);
        return newArray;
    }

    public static void replaceByPattern(@ReadonlyValue long[] sourceArray, @WritableValue long[] destArray, FunctionInterfaces.UnaryFunctionLongToBoolean pattern, long replacement) {
        if (sourceArray.length != destArray.length) {
            throw new IllegalArgumentException();
        }
        ArrayUtilities.replaceByPattern(sourceArray, 0, destArray, 0, sourceArray.length, pattern, replacement);
    }

    public static void replaceByPattern(@ReadonlyValue long[] sourceArray, int sourceOffset, @WritableValue long[] destArray, int destOffset, int length, FunctionInterfaces.UnaryFunctionLongToBoolean pattern, long replacement) {
        int i = 0;
        while (i < length) {
            long s = sourceArray[sourceOffset + i];
            destArray[destOffset + i] = pattern.f(s) ? replacement : s;
            ++i;
        }
    }

    public static boolean[] filterArray(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, boolean[] a) {
        int nIn = a.length;
        boolean[] temp = new boolean[nIn];
        int nOut = 0;
        int i = 0;
        while (i < nIn) {
            boolean c = a[i];
            if (predicate.f(c)) {
                temp[nOut] = c;
                ++nOut;
            }
            ++i;
        }
        return Arrays.copyOf(temp, nOut);
    }

    public static byte[] filterArray(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, byte[] a) {
        int nIn = a.length;
        byte[] temp = new byte[nIn];
        int nOut = 0;
        int i = 0;
        while (i < nIn) {
            byte c = a[i];
            if (predicate.f(c)) {
                temp[nOut] = c;
                ++nOut;
            }
            ++i;
        }
        return Arrays.copyOf(temp, nOut);
    }

    public static char[] filterArray(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, char[] a) {
        int nIn = a.length;
        char[] temp = new char[nIn];
        int nOut = 0;
        int i = 0;
        while (i < nIn) {
            char c = a[i];
            if (predicate.f(c)) {
                temp[nOut] = c;
                ++nOut;
            }
            ++i;
        }
        return Arrays.copyOf(temp, nOut);
    }

    public static short[] filterArray(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, short[] a) {
        int nIn = a.length;
        short[] temp = new short[nIn];
        int nOut = 0;
        int i = 0;
        while (i < nIn) {
            short c = a[i];
            if (predicate.f(c)) {
                temp[nOut] = c;
                ++nOut;
            }
            ++i;
        }
        return Arrays.copyOf(temp, nOut);
    }

    public static float[] filterArray(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, float[] a) {
        int nIn = a.length;
        float[] temp = new float[nIn];
        int nOut = 0;
        int i = 0;
        while (i < nIn) {
            float c = a[i];
            if (predicate.f(c)) {
                temp[nOut] = c;
                ++nOut;
            }
            ++i;
        }
        return Arrays.copyOf(temp, nOut);
    }

    public static int[] filterArray(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, int[] a) {
        int nIn = a.length;
        int[] temp = new int[nIn];
        int nOut = 0;
        int i = 0;
        while (i < nIn) {
            int c = a[i];
            if (predicate.f(c)) {
                temp[nOut] = c;
                ++nOut;
            }
            ++i;
        }
        return Arrays.copyOf(temp, nOut);
    }

    public static double[] filterArray(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, double[] a) {
        int nIn = a.length;
        double[] temp = new double[nIn];
        int nOut = 0;
        int i = 0;
        while (i < nIn) {
            double c = a[i];
            if (predicate.f(c)) {
                temp[nOut] = c;
                ++nOut;
            }
            ++i;
        }
        return Arrays.copyOf(temp, nOut);
    }

    public static long[] filterArray(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, long[] a) {
        int nIn = a.length;
        long[] temp = new long[nIn];
        int nOut = 0;
        int i = 0;
        while (i < nIn) {
            long c = a[i];
            if (predicate.f(c)) {
                temp[nOut] = c;
                ++nOut;
            }
            ++i;
        }
        return Arrays.copyOf(temp, nOut);
    }

    @ThrowAwayValue
    public static <T> T[] castArrayRuntimeTypeToNew(Object[] baseArray, Class<T> newComponentType) {
        if (baseArray == null) {
            return null;
        }
        int n = baseArray.length;
        Object[] newArray = (Object[])Array.newInstance(newComponentType, n);
        System.arraycopy(baseArray, 0, newArray, 0, n);
        return newArray;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static <T> T[] castArrayRuntimeTypeOrPass(Object[] baseArray, Class<T> newComponentType) {
        if (newComponentType.isAssignableFrom(baseArray.getClass().getComponentType())) {
            return baseArray;
        }
        return ArrayUtilities.castArrayRuntimeTypeToNew(baseArray, newComponentType);
    }

    public static byte[] castArrayByteToByte(byte[] input) {
        int n = input.length;
        byte[] output = new byte[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static byte[] castArrayCharToByte(char[] input) {
        int n = input.length;
        byte[] output = new byte[n];
        int i = 0;
        while (i < n) {
            output[i] = (byte)input[i];
            ++i;
        }
        return output;
    }

    public static byte[] castArrayShortToByte(short[] input) {
        int n = input.length;
        byte[] output = new byte[n];
        int i = 0;
        while (i < n) {
            output[i] = (byte)input[i];
            ++i;
        }
        return output;
    }

    public static byte[] castArrayFloatToByte(float[] input) {
        int n = input.length;
        byte[] output = new byte[n];
        int i = 0;
        while (i < n) {
            output[i] = (byte)input[i];
            ++i;
        }
        return output;
    }

    public static byte[] castArrayIntToByte(int[] input) {
        int n = input.length;
        byte[] output = new byte[n];
        int i = 0;
        while (i < n) {
            output[i] = (byte)input[i];
            ++i;
        }
        return output;
    }

    public static byte[] castArrayDoubleToByte(double[] input) {
        int n = input.length;
        byte[] output = new byte[n];
        int i = 0;
        while (i < n) {
            output[i] = (byte)input[i];
            ++i;
        }
        return output;
    }

    public static byte[] castArrayLongToByte(long[] input) {
        int n = input.length;
        byte[] output = new byte[n];
        int i = 0;
        while (i < n) {
            output[i] = (byte)input[i];
            ++i;
        }
        return output;
    }

    public static char[] castArrayByteToChar(byte[] input) {
        int n = input.length;
        char[] output = new char[n];
        int i = 0;
        while (i < n) {
            output[i] = (char)input[i];
            ++i;
        }
        return output;
    }

    public static char[] castArrayCharToChar(char[] input) {
        int n = input.length;
        char[] output = new char[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static char[] castArrayShortToChar(short[] input) {
        int n = input.length;
        char[] output = new char[n];
        int i = 0;
        while (i < n) {
            output[i] = (char)input[i];
            ++i;
        }
        return output;
    }

    public static char[] castArrayFloatToChar(float[] input) {
        int n = input.length;
        char[] output = new char[n];
        int i = 0;
        while (i < n) {
            output[i] = (char)input[i];
            ++i;
        }
        return output;
    }

    public static char[] castArrayIntToChar(int[] input) {
        int n = input.length;
        char[] output = new char[n];
        int i = 0;
        while (i < n) {
            output[i] = (char)input[i];
            ++i;
        }
        return output;
    }

    public static char[] castArrayDoubleToChar(double[] input) {
        int n = input.length;
        char[] output = new char[n];
        int i = 0;
        while (i < n) {
            output[i] = (char)input[i];
            ++i;
        }
        return output;
    }

    public static char[] castArrayLongToChar(long[] input) {
        int n = input.length;
        char[] output = new char[n];
        int i = 0;
        while (i < n) {
            output[i] = (char)input[i];
            ++i;
        }
        return output;
    }

    public static short[] castArrayByteToShort(byte[] input) {
        int n = input.length;
        short[] output = new short[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static short[] castArrayCharToShort(char[] input) {
        int n = input.length;
        short[] output = new short[n];
        int i = 0;
        while (i < n) {
            output[i] = (short)input[i];
            ++i;
        }
        return output;
    }

    public static short[] castArrayShortToShort(short[] input) {
        int n = input.length;
        short[] output = new short[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static short[] castArrayFloatToShort(float[] input) {
        int n = input.length;
        short[] output = new short[n];
        int i = 0;
        while (i < n) {
            output[i] = (short)input[i];
            ++i;
        }
        return output;
    }

    public static short[] castArrayIntToShort(int[] input) {
        int n = input.length;
        short[] output = new short[n];
        int i = 0;
        while (i < n) {
            output[i] = (short)input[i];
            ++i;
        }
        return output;
    }

    public static short[] castArrayDoubleToShort(double[] input) {
        int n = input.length;
        short[] output = new short[n];
        int i = 0;
        while (i < n) {
            output[i] = (short)input[i];
            ++i;
        }
        return output;
    }

    public static short[] castArrayLongToShort(long[] input) {
        int n = input.length;
        short[] output = new short[n];
        int i = 0;
        while (i < n) {
            output[i] = (short)input[i];
            ++i;
        }
        return output;
    }

    public static float[] castArrayByteToFloat(byte[] input) {
        int n = input.length;
        float[] output = new float[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static float[] castArrayCharToFloat(char[] input) {
        int n = input.length;
        float[] output = new float[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static float[] castArrayShortToFloat(short[] input) {
        int n = input.length;
        float[] output = new float[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static float[] castArrayFloatToFloat(float[] input) {
        int n = input.length;
        float[] output = new float[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static float[] castArrayIntToFloat(int[] input) {
        int n = input.length;
        float[] output = new float[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static float[] castArrayDoubleToFloat(double[] input) {
        int n = input.length;
        float[] output = new float[n];
        int i = 0;
        while (i < n) {
            output[i] = (float)input[i];
            ++i;
        }
        return output;
    }

    public static float[] castArrayLongToFloat(long[] input) {
        int n = input.length;
        float[] output = new float[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static int[] castArrayByteToInt(byte[] input) {
        int n = input.length;
        int[] output = new int[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static int[] castArrayCharToInt(char[] input) {
        int n = input.length;
        int[] output = new int[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static int[] castArrayShortToInt(short[] input) {
        int n = input.length;
        int[] output = new int[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static int[] castArrayFloatToInt(float[] input) {
        int n = input.length;
        int[] output = new int[n];
        int i = 0;
        while (i < n) {
            output[i] = (int)input[i];
            ++i;
        }
        return output;
    }

    public static int[] castArrayIntToInt(int[] input) {
        int n = input.length;
        int[] output = new int[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static int[] castArrayDoubleToInt(double[] input) {
        int n = input.length;
        int[] output = new int[n];
        int i = 0;
        while (i < n) {
            output[i] = (int)input[i];
            ++i;
        }
        return output;
    }

    public static int[] castArrayLongToInt(long[] input) {
        int n = input.length;
        int[] output = new int[n];
        int i = 0;
        while (i < n) {
            output[i] = (int)input[i];
            ++i;
        }
        return output;
    }

    public static double[] castArrayByteToDouble(byte[] input) {
        int n = input.length;
        double[] output = new double[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static double[] castArrayCharToDouble(char[] input) {
        int n = input.length;
        double[] output = new double[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static double[] castArrayShortToDouble(short[] input) {
        int n = input.length;
        double[] output = new double[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static double[] castArrayFloatToDouble(float[] input) {
        int n = input.length;
        double[] output = new double[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static double[] castArrayIntToDouble(int[] input) {
        int n = input.length;
        double[] output = new double[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static double[] castArrayDoubleToDouble(double[] input) {
        int n = input.length;
        double[] output = new double[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static double[] castArrayLongToDouble(long[] input) {
        int n = input.length;
        double[] output = new double[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static long[] castArrayByteToLong(byte[] input) {
        int n = input.length;
        long[] output = new long[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static long[] castArrayCharToLong(char[] input) {
        int n = input.length;
        long[] output = new long[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static long[] castArrayShortToLong(short[] input) {
        int n = input.length;
        long[] output = new long[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static long[] castArrayFloatToLong(float[] input) {
        int n = input.length;
        long[] output = new long[n];
        int i = 0;
        while (i < n) {
            output[i] = (long)input[i];
            ++i;
        }
        return output;
    }

    public static long[] castArrayIntToLong(int[] input) {
        int n = input.length;
        long[] output = new long[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static long[] castArrayDoubleToLong(double[] input) {
        int n = input.length;
        long[] output = new long[n];
        int i = 0;
        while (i < n) {
            output[i] = (long)input[i];
            ++i;
        }
        return output;
    }

    public static long[] castArrayLongToLong(long[] input) {
        int n = input.length;
        long[] output = new long[n];
        int i = 0;
        while (i < n) {
            output[i] = input[i];
            ++i;
        }
        return output;
    }

    public static int compareBigEndianLengthsLast(Object[] a, Object[] b, Comparator comparator) {
        return ArrayUtilities.compareBigEndianLengthsLast(a, 0, a.length, b, 0, b.length, comparator);
    }

    public static int compareBigEndianLengthsLast(Object[] arrayA, int offsetA, int lengthA, Object[] arrayB, int offsetB, int lengthB, Comparator comparator) {
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            Object elementA = arrayA[offsetA + i];
            Object elementB = arrayB[offsetB + i];
            int r = comparator.compare(elementA, elementB);
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareBigEndianLengthsFirst(Object[] a, Object[] b, Comparator comparator) {
        return ArrayUtilities.compareBigEndianLengthsFirst(a, 0, a.length, b, 0, b.length, comparator);
    }

    public static int compareBigEndianLengthsFirst(Object[] arrayA, int offsetA, int lengthA, Object[] arrayB, int offsetB, int lengthB, Comparator comparator) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int length = lengthA;
        int i = 0;
        while (i < length) {
            Object elementA = arrayA[offsetA + i];
            Object elementB = arrayB[offsetB + i];
            int r = comparator.compare(elementA, elementB);
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return 0;
    }

    public static int compareLittleEndianLengthsLast(Object[] a, Object[] b, Comparator comparator) {
        return ArrayUtilities.compareLittleEndianLengthsLast(a, 0, a.length, b, 0, b.length, comparator);
    }

    public static int compareLittleEndianLengthsLast(Object[] arrayA, int offsetA, int lengthA, Object[] arrayB, int offsetB, int lengthB, Comparator comparator) {
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            Object elementA = arrayA[kA - i];
            Object elementB = arrayB[kB - i];
            int r = comparator.compare(elementA, elementB);
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareLittleEndianLengthsFirst(Object[] a, Object[] b, Comparator comparator) {
        return ArrayUtilities.compareLittleEndianLengthsFirst(a, 0, a.length, b, 0, b.length, comparator);
    }

    public static int compareLittleEndianLengthsFirst(Object[] arrayA, int offsetA, int lengthA, Object[] arrayB, int offsetB, int lengthB, Comparator comparator) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int length = lengthA;
        int i = 0;
        while (i < length) {
            Object elementA = arrayA[kA - i];
            Object elementB = arrayB[kB - i];
            int r = comparator.compare(elementA, elementB);
            if (r != 0) {
                return r;
            }
            ++i;
        }
        return 0;
    }

    public static int compareBigEndianLengthsLast(boolean[] a, boolean[] b) {
        return ArrayUtilities.compareBigEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsLast(boolean[] arrayA, int offsetA, int lengthA, boolean[] arrayB, int offsetB, int lengthB) {
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            boolean elementA = arrayA[offsetA + i];
            boolean elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return BitUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareBigEndianLengthsFirst(boolean[] a, boolean[] b) {
        return ArrayUtilities.compareBigEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsFirst(boolean[] arrayA, int offsetA, int lengthA, boolean[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int length = lengthA;
        int i = 0;
        while (i < length) {
            boolean elementA = arrayA[offsetA + i];
            boolean elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return BitUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareLittleEndianLengthsLast(boolean[] a, boolean[] b) {
        return ArrayUtilities.compareLittleEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsLast(boolean[] arrayA, int offsetA, int lengthA, boolean[] arrayB, int offsetB, int lengthB) {
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            boolean elementA = arrayA[kA - i];
            boolean elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return BitUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareLittleEndianLengthsFirst(boolean[] a, boolean[] b) {
        return ArrayUtilities.compareLittleEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsFirst(boolean[] arrayA, int offsetA, int lengthA, boolean[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int length = lengthA;
        int i = 0;
        while (i < length) {
            boolean elementA = arrayA[kA - i];
            boolean elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return BitUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareBigEndianLengthsLast(byte[] a, byte[] b) {
        return ArrayUtilities.compareBigEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsLast(byte[] arrayA, int offsetA, int lengthA, byte[] arrayB, int offsetB, int lengthB) {
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            byte elementA = arrayA[offsetA + i];
            byte elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareBigEndianLengthsFirst(byte[] a, byte[] b) {
        return ArrayUtilities.compareBigEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsFirst(byte[] arrayA, int offsetA, int lengthA, byte[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int length = lengthA;
        int i = 0;
        while (i < length) {
            byte elementA = arrayA[offsetA + i];
            byte elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareLittleEndianLengthsLast(byte[] a, byte[] b) {
        return ArrayUtilities.compareLittleEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsLast(byte[] arrayA, int offsetA, int lengthA, byte[] arrayB, int offsetB, int lengthB) {
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            byte elementA = arrayA[kA - i];
            byte elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareLittleEndianLengthsFirst(byte[] a, byte[] b) {
        return ArrayUtilities.compareLittleEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsFirst(byte[] arrayA, int offsetA, int lengthA, byte[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int length = lengthA;
        int i = 0;
        while (i < length) {
            byte elementA = arrayA[kA - i];
            byte elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareBigEndianLengthsLast(char[] a, char[] b) {
        return ArrayUtilities.compareBigEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsLast(char[] arrayA, int offsetA, int lengthA, char[] arrayB, int offsetB, int lengthB) {
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            char elementA = arrayA[offsetA + i];
            char elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareBigEndianLengthsFirst(char[] a, char[] b) {
        return ArrayUtilities.compareBigEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsFirst(char[] arrayA, int offsetA, int lengthA, char[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int length = lengthA;
        int i = 0;
        while (i < length) {
            char elementA = arrayA[offsetA + i];
            char elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareLittleEndianLengthsLast(char[] a, char[] b) {
        return ArrayUtilities.compareLittleEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsLast(char[] arrayA, int offsetA, int lengthA, char[] arrayB, int offsetB, int lengthB) {
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            char elementA = arrayA[kA - i];
            char elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareLittleEndianLengthsFirst(char[] a, char[] b) {
        return ArrayUtilities.compareLittleEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsFirst(char[] arrayA, int offsetA, int lengthA, char[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int length = lengthA;
        int i = 0;
        while (i < length) {
            char elementA = arrayA[kA - i];
            char elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareBigEndianLengthsLast(short[] a, short[] b) {
        return ArrayUtilities.compareBigEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsLast(short[] arrayA, int offsetA, int lengthA, short[] arrayB, int offsetB, int lengthB) {
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            short elementA = arrayA[offsetA + i];
            short elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareBigEndianLengthsFirst(short[] a, short[] b) {
        return ArrayUtilities.compareBigEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsFirst(short[] arrayA, int offsetA, int lengthA, short[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int length = lengthA;
        int i = 0;
        while (i < length) {
            short elementA = arrayA[offsetA + i];
            short elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareLittleEndianLengthsLast(short[] a, short[] b) {
        return ArrayUtilities.compareLittleEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsLast(short[] arrayA, int offsetA, int lengthA, short[] arrayB, int offsetB, int lengthB) {
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            short elementA = arrayA[kA - i];
            short elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareLittleEndianLengthsFirst(short[] a, short[] b) {
        return ArrayUtilities.compareLittleEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsFirst(short[] arrayA, int offsetA, int lengthA, short[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int length = lengthA;
        int i = 0;
        while (i < length) {
            short elementA = arrayA[kA - i];
            short elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareBigEndianLengthsLast(float[] a, float[] b) {
        return ArrayUtilities.compareBigEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsLast(float[] arrayA, int offsetA, int lengthA, float[] arrayB, int offsetB, int lengthB) {
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            float elementA = arrayA[offsetA + i];
            float elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallFloatMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareBigEndianLengthsFirst(float[] a, float[] b) {
        return ArrayUtilities.compareBigEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsFirst(float[] arrayA, int offsetA, int lengthA, float[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int length = lengthA;
        int i = 0;
        while (i < length) {
            float elementA = arrayA[offsetA + i];
            float elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallFloatMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareLittleEndianLengthsLast(float[] a, float[] b) {
        return ArrayUtilities.compareLittleEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsLast(float[] arrayA, int offsetA, int lengthA, float[] arrayB, int offsetB, int lengthB) {
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            float elementA = arrayA[kA - i];
            float elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallFloatMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareLittleEndianLengthsFirst(float[] a, float[] b) {
        return ArrayUtilities.compareLittleEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsFirst(float[] arrayA, int offsetA, int lengthA, float[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int length = lengthA;
        int i = 0;
        while (i < length) {
            float elementA = arrayA[kA - i];
            float elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallFloatMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareBigEndianLengthsLast(int[] a, int[] b) {
        return ArrayUtilities.compareBigEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsLast(int[] arrayA, int offsetA, int lengthA, int[] arrayB, int offsetB, int lengthB) {
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            int elementA = arrayA[offsetA + i];
            int elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareBigEndianLengthsFirst(int[] a, int[] b) {
        return ArrayUtilities.compareBigEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsFirst(int[] arrayA, int offsetA, int lengthA, int[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int length = lengthA;
        int i = 0;
        while (i < length) {
            int elementA = arrayA[offsetA + i];
            int elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareLittleEndianLengthsLast(int[] a, int[] b) {
        return ArrayUtilities.compareLittleEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsLast(int[] arrayA, int offsetA, int lengthA, int[] arrayB, int offsetB, int lengthB) {
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            int elementA = arrayA[kA - i];
            int elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareLittleEndianLengthsFirst(int[] a, int[] b) {
        return ArrayUtilities.compareLittleEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsFirst(int[] arrayA, int offsetA, int lengthA, int[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int length = lengthA;
        int i = 0;
        while (i < length) {
            int elementA = arrayA[kA - i];
            int elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareBigEndianLengthsLast(double[] a, double[] b) {
        return ArrayUtilities.compareBigEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsLast(double[] arrayA, int offsetA, int lengthA, double[] arrayB, int offsetB, int lengthB) {
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            double elementA = arrayA[offsetA + i];
            double elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallFloatMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareBigEndianLengthsFirst(double[] a, double[] b) {
        return ArrayUtilities.compareBigEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsFirst(double[] arrayA, int offsetA, int lengthA, double[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int length = lengthA;
        int i = 0;
        while (i < length) {
            double elementA = arrayA[offsetA + i];
            double elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallFloatMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareLittleEndianLengthsLast(double[] a, double[] b) {
        return ArrayUtilities.compareLittleEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsLast(double[] arrayA, int offsetA, int lengthA, double[] arrayB, int offsetB, int lengthB) {
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            double elementA = arrayA[kA - i];
            double elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallFloatMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareLittleEndianLengthsFirst(double[] a, double[] b) {
        return ArrayUtilities.compareLittleEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsFirst(double[] arrayA, int offsetA, int lengthA, double[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int length = lengthA;
        int i = 0;
        while (i < length) {
            double elementA = arrayA[kA - i];
            double elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallFloatMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareBigEndianLengthsLast(long[] a, long[] b) {
        return ArrayUtilities.compareBigEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsLast(long[] arrayA, int offsetA, int lengthA, long[] arrayB, int offsetB, int lengthB) {
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            long elementA = arrayA[offsetA + i];
            long elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareBigEndianLengthsFirst(long[] a, long[] b) {
        return ArrayUtilities.compareBigEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareBigEndianLengthsFirst(long[] arrayA, int offsetA, int lengthA, long[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int length = lengthA;
        int i = 0;
        while (i < length) {
            long elementA = arrayA[offsetA + i];
            long elementB = arrayB[offsetB + i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static int compareLittleEndianLengthsLast(long[] a, long[] b) {
        return ArrayUtilities.compareLittleEndianLengthsLast(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsLast(long[] arrayA, int offsetA, int lengthA, long[] arrayB, int offsetB, int lengthB) {
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int min = SmallIntegerMathUtilities.least(lengthA, lengthB);
        int i = 0;
        while (i < min) {
            long elementA = arrayA[kA - i];
            long elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
    }

    public static int compareLittleEndianLengthsFirst(long[] a, long[] b) {
        return ArrayUtilities.compareLittleEndianLengthsFirst(a, 0, a.length, b, 0, b.length);
    }

    public static int compareLittleEndianLengthsFirst(long[] arrayA, int offsetA, int lengthA, long[] arrayB, int offsetB, int lengthB) {
        if (lengthA != lengthB) {
            return SmallIntegerMathUtilities.cmp(lengthA, lengthB);
        }
        int kA = offsetA + lengthA - 1;
        int kB = offsetB + lengthB - 1;
        int length = lengthA;
        int i = 0;
        while (i < length) {
            long elementA = arrayA[kA - i];
            long elementB = arrayB[kB - i];
            if (elementA != elementB) {
                return SmallIntegerMathUtilities.cmp(elementA, elementB);
            }
            ++i;
        }
        return 0;
    }

    public static boolean equalsDeep(Object[] a, int aOffset, Object[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!BasicObjectUtilities.eq(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(Object[] a, int aOffset, Object[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (a[aOffset + i] != b[bOffset + i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> boolean equalsSliceReference(Slice<T[]> a, int aOffset, Slice<T[]> b, int bOffset, int length) {
        return ArrayUtilities.equals(a.getUnderlying(), a.getOffset() + aOffset, b.getUnderlying(), b.getOffset() + bOffset, length);
    }

    public static <T> boolean equalsSliceReference(Slice<T[]> a, Slice<T[]> b) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equalsSliceReference(a, 0, b, 0, length);
    }

    public static <T> T getReference(Slice<T[]> source, int index) {
        return source.getUnderlying()[source.getOffset() + index];
    }

    public static <T> void setReference(Slice<T[]> source, int index, T value) {
        source.getUnderlying()[source.getOffset() + index] = value;
    }

    public static <T> boolean isReferenceSliceAllSame(Slice<T[]> source, T value) {
        int n = source.getLength();
        int i = 0;
        while (i < n) {
            if (ArrayUtilities.getReference(source, i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> boolean isReferenceArrayAllSame(T[] source, int offset, int length, T value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (source[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> boolean isReferenceArrayAllSame(T[] source, T value) {
        return ArrayUtilities.isReferenceArrayAllSame(source, 0, source.length, value);
    }

    public static <T> Object[] sliceToNewObjectArrayOP(@ReadonlyValue Slice<T[]> slice) {
        int n = slice.getLength();
        Object[] a = new Object[n];
        System.arraycopy(slice.getUnderlying(), slice.getOffset(), a, 0, n);
        return a;
    }

    public static <T> Object[] sliceToObjectArrayOPC(@ReadonlyValue Slice<T[]> slice) {
        int o = slice.getOffset();
        int n = slice.getLength();
        Object[] u = slice.getUnderlying();
        if (o == 0 && n == u.length) {
            return u;
        }
        Object[] a = new Object[n];
        System.arraycopy(u, o, a, 0, n);
        return a;
    }

    public static <A> Slice<A> wholeArraySlice(A array) {
        return new Slice<A>(array, 0, Array.getLength(array));
    }

    public static <T> Slice<T[]> wholeArraySliceReference(T[] array) {
        return new Slice<T[]>(array, 0, array.length);
    }

    public static Slice<Object[]> newArrayToSliceObject(int length) {
        return new Slice<Object[]>(new Object[length], 0, length);
    }

    public static <T> Slice<T[]> cloneArrayToSliceReference(T[] array) {
        return new Slice<T[]>((Object[])array.clone(), 0, array.length);
    }

    public static Slice<Object[]> cloneSliceObject(Slice<Object[]> array) {
        return ArrayUtilities.wholeArraySliceReference(ArrayUtilities.sliceToNewObjectArrayOP(array));
    }

    public static Slice<Object[]> trimSliceOPCObject(Slice<Object[]> arraySlice) {
        if (ArrayUtilities.isArraySliceFullReference(arraySlice)) {
            return arraySlice;
        }
        return ArrayUtilities.cloneSliceObject(arraySlice);
    }

    public static <T> boolean isArraySliceFullReference(Slice<T[]> arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == arraySlice.getUnderlying().length;
    }

    public static boolean isArraySliceFull(Slice arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == Array.getLength(arraySlice.getUnderlying());
    }

    public static boolean equals(boolean[] a, int aOffset, boolean[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsSliceBoolean(Slice<boolean[]> a, Slice<boolean[]> b) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static boolean getBoolean(Slice<boolean[]> slice, int index) {
        return slice.getUnderlying()[slice.getOffset() + index];
    }

    public static void setBoolean(Slice<boolean[]> slice, int index, boolean value) {
        slice.getUnderlying()[slice.getOffset() + index] = value;
    }

    public static boolean isBooleanSliceAllSame(Slice<boolean[]> source, boolean value) {
        int n = source.getLength();
        int i = 0;
        while (i < n) {
            if (ArrayUtilities.getBoolean(source, i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBooleanArrayAllSame(boolean[] source, int offset, int length, boolean value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (source[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isBooleanArrayAllSame(boolean[] source, boolean value) {
        return ArrayUtilities.isBooleanArrayAllSame(source, 0, source.length, value);
    }

    public static boolean[] sliceToNewBooleanArrayOP(@ReadonlyValue Slice<boolean[]> slice) {
        int n = slice.getLength();
        boolean[] a = new boolean[n];
        System.arraycopy(slice.getUnderlying(), slice.getOffset(), a, 0, n);
        return a;
    }

    public static boolean[] sliceToBooleanArrayOPC(@ReadonlyValue Slice<boolean[]> slice) {
        int o = slice.getOffset();
        int n = slice.getLength();
        boolean[] u = slice.getUnderlying();
        if (o == 0 && n == u.length) {
            return u;
        }
        boolean[] a = new boolean[n];
        System.arraycopy(u, o, a, 0, n);
        return a;
    }

    public static Slice<boolean[]> wholeArraySliceBoolean(boolean[] array) {
        return new Slice<boolean[]>(array, 0, array.length);
    }

    public static Slice<boolean[]> newArraySliceBoolean(boolean ... array) {
        return new Slice<boolean[]>(array, 0, array.length);
    }

    public static Slice<boolean[]> newArrayToSliceBoolean(int length) {
        return new Slice<boolean[]>(new boolean[length], 0, length);
    }

    public static Slice<boolean[]> cloneArrayToSliceBoolean(boolean[] array) {
        return new Slice<boolean[]>((boolean[])array.clone(), 0, array.length);
    }

    public static Slice<boolean[]> cloneSliceBoolean(Slice<boolean[]> slice) {
        return ArrayUtilities.wholeArraySliceBoolean(ArrayUtilities.sliceToNewBooleanArrayOP(slice));
    }

    public static Slice<boolean[]> trimSliceOPCBoolean(Slice<boolean[]> arraySlice) {
        if (ArrayUtilities.isArraySliceFullBoolean(arraySlice)) {
            return arraySlice;
        }
        return ArrayUtilities.cloneSliceBoolean(arraySlice);
    }

    public static boolean isArraySliceFullBoolean(Slice<boolean[]> arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == arraySlice.getUnderlying().length;
    }

    public static void arrayslicecopyBoolean(Slice<boolean[]> arraySliceSource, Slice<boolean[]> arraySliceDest) {
        ArrayUtilities.arrayslicecopyBoolean(arraySliceSource, arraySliceDest, SmallIntegerMathUtilities.least(arraySliceSource.getLength(), arraySliceDest.getLength()));
    }

    public static void arrayslicecopyBoolean(Slice<boolean[]> arraySliceSource, Slice<boolean[]> arraySliceDest, int length) {
        System.arraycopy(arraySliceSource.getUnderlying(), arraySliceSource.getOffset(), arraySliceDest.getUnderlying(), arraySliceDest.getOffset(), length);
    }

    public static boolean equals(byte[] a, int aOffset, byte[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsSliceByte(Slice<byte[]> a, Slice<byte[]> b) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static byte getByte(Slice<byte[]> slice, int index) {
        return slice.getUnderlying()[slice.getOffset() + index];
    }

    public static void setByte(Slice<byte[]> slice, int index, byte value) {
        slice.getUnderlying()[slice.getOffset() + index] = value;
    }

    public static boolean isByteSliceAllSame(Slice<byte[]> source, byte value) {
        int n = source.getLength();
        int i = 0;
        while (i < n) {
            if (ArrayUtilities.getByte(source, i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isByteArrayAllSame(byte[] source, int offset, int length, byte value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (source[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isByteArrayAllSame(byte[] source, byte value) {
        return ArrayUtilities.isByteArrayAllSame(source, 0, source.length, value);
    }

    public static byte[] sliceToNewByteArrayOP(@ReadonlyValue Slice<byte[]> slice) {
        int n = slice.getLength();
        byte[] a = new byte[n];
        System.arraycopy(slice.getUnderlying(), slice.getOffset(), a, 0, n);
        return a;
    }

    public static byte[] sliceToByteArrayOPC(@ReadonlyValue Slice<byte[]> slice) {
        int o = slice.getOffset();
        int n = slice.getLength();
        byte[] u = slice.getUnderlying();
        if (o == 0 && n == u.length) {
            return u;
        }
        byte[] a = new byte[n];
        System.arraycopy(u, o, a, 0, n);
        return a;
    }

    public static Slice<byte[]> wholeArraySliceByte(byte[] array) {
        return new Slice<byte[]>(array, 0, array.length);
    }

    public static Slice<byte[]> newArraySliceByte(byte ... array) {
        return new Slice<byte[]>(array, 0, array.length);
    }

    public static Slice<byte[]> newArrayToSliceByte(int length) {
        return new Slice<byte[]>(new byte[length], 0, length);
    }

    public static Slice<byte[]> cloneArrayToSliceByte(byte[] array) {
        return new Slice<byte[]>((byte[])array.clone(), 0, array.length);
    }

    public static Slice<byte[]> cloneSliceByte(Slice<byte[]> slice) {
        return ArrayUtilities.wholeArraySliceByte(ArrayUtilities.sliceToNewByteArrayOP(slice));
    }

    public static Slice<byte[]> trimSliceOPCByte(Slice<byte[]> arraySlice) {
        if (ArrayUtilities.isArraySliceFullByte(arraySlice)) {
            return arraySlice;
        }
        return ArrayUtilities.cloneSliceByte(arraySlice);
    }

    public static boolean isArraySliceFullByte(Slice<byte[]> arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == arraySlice.getUnderlying().length;
    }

    public static void arrayslicecopyByte(Slice<byte[]> arraySliceSource, Slice<byte[]> arraySliceDest) {
        ArrayUtilities.arrayslicecopyByte(arraySliceSource, arraySliceDest, SmallIntegerMathUtilities.least(arraySliceSource.getLength(), arraySliceDest.getLength()));
    }

    public static void arrayslicecopyByte(Slice<byte[]> arraySliceSource, Slice<byte[]> arraySliceDest, int length) {
        System.arraycopy(arraySliceSource.getUnderlying(), arraySliceSource.getOffset(), arraySliceDest.getUnderlying(), arraySliceDest.getOffset(), length);
    }

    public static boolean equals(char[] a, int aOffset, char[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsSliceChar(Slice<char[]> a, Slice<char[]> b) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static char getChar(Slice<char[]> slice, int index) {
        return slice.getUnderlying()[slice.getOffset() + index];
    }

    public static void setChar(Slice<char[]> slice, int index, char value) {
        slice.getUnderlying()[slice.getOffset() + index] = value;
    }

    public static boolean isCharSliceAllSame(Slice<char[]> source, char value) {
        int n = source.getLength();
        int i = 0;
        while (i < n) {
            if (ArrayUtilities.getChar(source, i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCharArrayAllSame(char[] source, int offset, int length, char value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (source[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCharArrayAllSame(char[] source, char value) {
        return ArrayUtilities.isCharArrayAllSame(source, 0, source.length, value);
    }

    public static char[] sliceToNewCharArrayOP(@ReadonlyValue Slice<char[]> slice) {
        int n = slice.getLength();
        char[] a = new char[n];
        System.arraycopy(slice.getUnderlying(), slice.getOffset(), a, 0, n);
        return a;
    }

    public static char[] sliceToCharArrayOPC(@ReadonlyValue Slice<char[]> slice) {
        int o = slice.getOffset();
        int n = slice.getLength();
        char[] u = slice.getUnderlying();
        if (o == 0 && n == u.length) {
            return u;
        }
        char[] a = new char[n];
        System.arraycopy(u, o, a, 0, n);
        return a;
    }

    public static Slice<char[]> wholeArraySliceChar(char[] array) {
        return new Slice<char[]>(array, 0, array.length);
    }

    public static Slice<char[]> newArraySliceChar(char ... array) {
        return new Slice<char[]>(array, 0, array.length);
    }

    public static Slice<char[]> newArrayToSliceChar(int length) {
        return new Slice<char[]>(new char[length], 0, length);
    }

    public static Slice<char[]> cloneArrayToSliceChar(char[] array) {
        return new Slice<char[]>((char[])array.clone(), 0, array.length);
    }

    public static Slice<char[]> cloneSliceChar(Slice<char[]> slice) {
        return ArrayUtilities.wholeArraySliceChar(ArrayUtilities.sliceToNewCharArrayOP(slice));
    }

    public static Slice<char[]> trimSliceOPCChar(Slice<char[]> arraySlice) {
        if (ArrayUtilities.isArraySliceFullChar(arraySlice)) {
            return arraySlice;
        }
        return ArrayUtilities.cloneSliceChar(arraySlice);
    }

    public static boolean isArraySliceFullChar(Slice<char[]> arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == arraySlice.getUnderlying().length;
    }

    public static void arrayslicecopyChar(Slice<char[]> arraySliceSource, Slice<char[]> arraySliceDest) {
        ArrayUtilities.arrayslicecopyChar(arraySliceSource, arraySliceDest, SmallIntegerMathUtilities.least(arraySliceSource.getLength(), arraySliceDest.getLength()));
    }

    public static void arrayslicecopyChar(Slice<char[]> arraySliceSource, Slice<char[]> arraySliceDest, int length) {
        System.arraycopy(arraySliceSource.getUnderlying(), arraySliceSource.getOffset(), arraySliceDest.getUnderlying(), arraySliceDest.getOffset(), length);
    }

    public static boolean equals(short[] a, int aOffset, short[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsSliceShort(Slice<short[]> a, Slice<short[]> b) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static short getShort(Slice<short[]> slice, int index) {
        return slice.getUnderlying()[slice.getOffset() + index];
    }

    public static void setShort(Slice<short[]> slice, int index, short value) {
        slice.getUnderlying()[slice.getOffset() + index] = value;
    }

    public static boolean isShortSliceAllSame(Slice<short[]> source, short value) {
        int n = source.getLength();
        int i = 0;
        while (i < n) {
            if (ArrayUtilities.getShort(source, i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isShortArrayAllSame(short[] source, int offset, int length, short value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (source[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isShortArrayAllSame(short[] source, short value) {
        return ArrayUtilities.isShortArrayAllSame(source, 0, source.length, value);
    }

    public static short[] sliceToNewShortArrayOP(@ReadonlyValue Slice<short[]> slice) {
        int n = slice.getLength();
        short[] a = new short[n];
        System.arraycopy(slice.getUnderlying(), slice.getOffset(), a, 0, n);
        return a;
    }

    public static short[] sliceToShortArrayOPC(@ReadonlyValue Slice<short[]> slice) {
        int o = slice.getOffset();
        int n = slice.getLength();
        short[] u = slice.getUnderlying();
        if (o == 0 && n == u.length) {
            return u;
        }
        short[] a = new short[n];
        System.arraycopy(u, o, a, 0, n);
        return a;
    }

    public static Slice<short[]> wholeArraySliceShort(short[] array) {
        return new Slice<short[]>(array, 0, array.length);
    }

    public static Slice<short[]> newArraySliceShort(short ... array) {
        return new Slice<short[]>(array, 0, array.length);
    }

    public static Slice<short[]> newArrayToSliceShort(int length) {
        return new Slice<short[]>(new short[length], 0, length);
    }

    public static Slice<short[]> cloneArrayToSliceShort(short[] array) {
        return new Slice<short[]>((short[])array.clone(), 0, array.length);
    }

    public static Slice<short[]> cloneSliceShort(Slice<short[]> slice) {
        return ArrayUtilities.wholeArraySliceShort(ArrayUtilities.sliceToNewShortArrayOP(slice));
    }

    public static Slice<short[]> trimSliceOPCShort(Slice<short[]> arraySlice) {
        if (ArrayUtilities.isArraySliceFullShort(arraySlice)) {
            return arraySlice;
        }
        return ArrayUtilities.cloneSliceShort(arraySlice);
    }

    public static boolean isArraySliceFullShort(Slice<short[]> arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == arraySlice.getUnderlying().length;
    }

    public static void arrayslicecopyShort(Slice<short[]> arraySliceSource, Slice<short[]> arraySliceDest) {
        ArrayUtilities.arrayslicecopyShort(arraySliceSource, arraySliceDest, SmallIntegerMathUtilities.least(arraySliceSource.getLength(), arraySliceDest.getLength()));
    }

    public static void arrayslicecopyShort(Slice<short[]> arraySliceSource, Slice<short[]> arraySliceDest, int length) {
        System.arraycopy(arraySliceSource.getUnderlying(), arraySliceSource.getOffset(), arraySliceDest.getUnderlying(), arraySliceDest.getOffset(), length);
    }

    public static boolean equals(float[] a, int aOffset, float[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsSliceFloat(Slice<float[]> a, Slice<float[]> b) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static float getFloat(Slice<float[]> slice, int index) {
        return slice.getUnderlying()[slice.getOffset() + index];
    }

    public static void setFloat(Slice<float[]> slice, int index, float value) {
        slice.getUnderlying()[slice.getOffset() + index] = value;
    }

    public static boolean isFloatSliceAllSame(Slice<float[]> source, float value) {
        int n = source.getLength();
        int i = 0;
        while (i < n) {
            if (ArrayUtilities.getFloat(source, i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isFloatArrayAllSame(float[] source, int offset, int length, float value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (source[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isFloatArrayAllSame(float[] source, float value) {
        return ArrayUtilities.isFloatArrayAllSame(source, 0, source.length, value);
    }

    public static float[] sliceToNewFloatArrayOP(@ReadonlyValue Slice<float[]> slice) {
        int n = slice.getLength();
        float[] a = new float[n];
        System.arraycopy(slice.getUnderlying(), slice.getOffset(), a, 0, n);
        return a;
    }

    public static float[] sliceToFloatArrayOPC(@ReadonlyValue Slice<float[]> slice) {
        int o = slice.getOffset();
        int n = slice.getLength();
        float[] u = slice.getUnderlying();
        if (o == 0 && n == u.length) {
            return u;
        }
        float[] a = new float[n];
        System.arraycopy(u, o, a, 0, n);
        return a;
    }

    public static Slice<float[]> wholeArraySliceFloat(float[] array) {
        return new Slice<float[]>(array, 0, array.length);
    }

    public static Slice<float[]> newArraySliceFloat(float ... array) {
        return new Slice<float[]>(array, 0, array.length);
    }

    public static Slice<float[]> newArrayToSliceFloat(int length) {
        return new Slice<float[]>(new float[length], 0, length);
    }

    public static Slice<float[]> cloneArrayToSliceFloat(float[] array) {
        return new Slice<float[]>((float[])array.clone(), 0, array.length);
    }

    public static Slice<float[]> cloneSliceFloat(Slice<float[]> slice) {
        return ArrayUtilities.wholeArraySliceFloat(ArrayUtilities.sliceToNewFloatArrayOP(slice));
    }

    public static Slice<float[]> trimSliceOPCFloat(Slice<float[]> arraySlice) {
        if (ArrayUtilities.isArraySliceFullFloat(arraySlice)) {
            return arraySlice;
        }
        return ArrayUtilities.cloneSliceFloat(arraySlice);
    }

    public static boolean isArraySliceFullFloat(Slice<float[]> arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == arraySlice.getUnderlying().length;
    }

    public static void arrayslicecopyFloat(Slice<float[]> arraySliceSource, Slice<float[]> arraySliceDest) {
        ArrayUtilities.arrayslicecopyFloat(arraySliceSource, arraySliceDest, SmallIntegerMathUtilities.least(arraySliceSource.getLength(), arraySliceDest.getLength()));
    }

    public static void arrayslicecopyFloat(Slice<float[]> arraySliceSource, Slice<float[]> arraySliceDest, int length) {
        System.arraycopy(arraySliceSource.getUnderlying(), arraySliceSource.getOffset(), arraySliceDest.getUnderlying(), arraySliceDest.getOffset(), length);
    }

    public static boolean equals(int[] a, int aOffset, int[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsSliceInt(Slice<int[]> a, Slice<int[]> b) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static int getInt(Slice<int[]> slice, int index) {
        return slice.getUnderlying()[slice.getOffset() + index];
    }

    public static void setInt(Slice<int[]> slice, int index, int value) {
        slice.getUnderlying()[slice.getOffset() + index] = value;
    }

    public static boolean isIntSliceAllSame(Slice<int[]> source, int value) {
        int n = source.getLength();
        int i = 0;
        while (i < n) {
            if (ArrayUtilities.getInt(source, i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIntArrayAllSame(int[] source, int offset, int length, int value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (source[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isIntArrayAllSame(int[] source, int value) {
        return ArrayUtilities.isIntArrayAllSame(source, 0, source.length, value);
    }

    public static int[] sliceToNewIntArrayOP(@ReadonlyValue Slice<int[]> slice) {
        int n = slice.getLength();
        int[] a = new int[n];
        System.arraycopy(slice.getUnderlying(), slice.getOffset(), a, 0, n);
        return a;
    }

    public static int[] sliceToIntArrayOPC(@ReadonlyValue Slice<int[]> slice) {
        int o = slice.getOffset();
        int n = slice.getLength();
        int[] u = slice.getUnderlying();
        if (o == 0 && n == u.length) {
            return u;
        }
        int[] a = new int[n];
        System.arraycopy(u, o, a, 0, n);
        return a;
    }

    public static Slice<int[]> wholeArraySliceInt(int[] array) {
        return new Slice<int[]>(array, 0, array.length);
    }

    public static Slice<int[]> newArraySliceInt(int ... array) {
        return new Slice<int[]>(array, 0, array.length);
    }

    public static Slice<int[]> newArrayToSliceInt(int length) {
        return new Slice<int[]>(new int[length], 0, length);
    }

    public static Slice<int[]> cloneArrayToSliceInt(int[] array) {
        return new Slice<int[]>((int[])array.clone(), 0, array.length);
    }

    public static Slice<int[]> cloneSliceInt(Slice<int[]> slice) {
        return ArrayUtilities.wholeArraySliceInt(ArrayUtilities.sliceToNewIntArrayOP(slice));
    }

    public static Slice<int[]> trimSliceOPCInt(Slice<int[]> arraySlice) {
        if (ArrayUtilities.isArraySliceFullInt(arraySlice)) {
            return arraySlice;
        }
        return ArrayUtilities.cloneSliceInt(arraySlice);
    }

    public static boolean isArraySliceFullInt(Slice<int[]> arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == arraySlice.getUnderlying().length;
    }

    public static void arrayslicecopyInt(Slice<int[]> arraySliceSource, Slice<int[]> arraySliceDest) {
        ArrayUtilities.arrayslicecopyInt(arraySliceSource, arraySliceDest, SmallIntegerMathUtilities.least(arraySliceSource.getLength(), arraySliceDest.getLength()));
    }

    public static void arrayslicecopyInt(Slice<int[]> arraySliceSource, Slice<int[]> arraySliceDest, int length) {
        System.arraycopy(arraySliceSource.getUnderlying(), arraySliceSource.getOffset(), arraySliceDest.getUnderlying(), arraySliceDest.getOffset(), length);
    }

    public static boolean equals(double[] a, int aOffset, double[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsSliceDouble(Slice<double[]> a, Slice<double[]> b) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static double getDouble(Slice<double[]> slice, int index) {
        return slice.getUnderlying()[slice.getOffset() + index];
    }

    public static void setDouble(Slice<double[]> slice, int index, double value) {
        slice.getUnderlying()[slice.getOffset() + index] = value;
    }

    public static boolean isDoubleSliceAllSame(Slice<double[]> source, double value) {
        int n = source.getLength();
        int i = 0;
        while (i < n) {
            if (ArrayUtilities.getDouble(source, i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDoubleArrayAllSame(double[] source, int offset, int length, double value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (source[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isDoubleArrayAllSame(double[] source, double value) {
        return ArrayUtilities.isDoubleArrayAllSame(source, 0, source.length, value);
    }

    public static double[] sliceToNewDoubleArrayOP(@ReadonlyValue Slice<double[]> slice) {
        int n = slice.getLength();
        double[] a = new double[n];
        System.arraycopy(slice.getUnderlying(), slice.getOffset(), a, 0, n);
        return a;
    }

    public static double[] sliceToDoubleArrayOPC(@ReadonlyValue Slice<double[]> slice) {
        int o = slice.getOffset();
        int n = slice.getLength();
        double[] u = slice.getUnderlying();
        if (o == 0 && n == u.length) {
            return u;
        }
        double[] a = new double[n];
        System.arraycopy(u, o, a, 0, n);
        return a;
    }

    public static Slice<double[]> wholeArraySliceDouble(double[] array) {
        return new Slice<double[]>(array, 0, array.length);
    }

    public static Slice<double[]> newArraySliceDouble(double ... array) {
        return new Slice<double[]>(array, 0, array.length);
    }

    public static Slice<double[]> newArrayToSliceDouble(int length) {
        return new Slice<double[]>(new double[length], 0, length);
    }

    public static Slice<double[]> cloneArrayToSliceDouble(double[] array) {
        return new Slice<double[]>((double[])array.clone(), 0, array.length);
    }

    public static Slice<double[]> cloneSliceDouble(Slice<double[]> slice) {
        return ArrayUtilities.wholeArraySliceDouble(ArrayUtilities.sliceToNewDoubleArrayOP(slice));
    }

    public static Slice<double[]> trimSliceOPCDouble(Slice<double[]> arraySlice) {
        if (ArrayUtilities.isArraySliceFullDouble(arraySlice)) {
            return arraySlice;
        }
        return ArrayUtilities.cloneSliceDouble(arraySlice);
    }

    public static boolean isArraySliceFullDouble(Slice<double[]> arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == arraySlice.getUnderlying().length;
    }

    public static void arrayslicecopyDouble(Slice<double[]> arraySliceSource, Slice<double[]> arraySliceDest) {
        ArrayUtilities.arrayslicecopyDouble(arraySliceSource, arraySliceDest, SmallIntegerMathUtilities.least(arraySliceSource.getLength(), arraySliceDest.getLength()));
    }

    public static void arrayslicecopyDouble(Slice<double[]> arraySliceSource, Slice<double[]> arraySliceDest, int length) {
        System.arraycopy(arraySliceSource.getUnderlying(), arraySliceSource.getOffset(), arraySliceDest.getUnderlying(), arraySliceDest.getOffset(), length);
    }

    public static boolean equals(long[] a, int aOffset, long[] b, int bOffset, int length) {
        int i = 0;
        while (i < length) {
            if (!Primitives.eqSane(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsSliceLong(Slice<long[]> a, Slice<long[]> b) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equals(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length);
    }

    public static long getLong(Slice<long[]> slice, int index) {
        return slice.getUnderlying()[slice.getOffset() + index];
    }

    public static void setLong(Slice<long[]> slice, int index, long value) {
        slice.getUnderlying()[slice.getOffset() + index] = value;
    }

    public static boolean isLongSliceAllSame(Slice<long[]> source, long value) {
        int n = source.getLength();
        int i = 0;
        while (i < n) {
            if (ArrayUtilities.getLong(source, i) != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLongArrayAllSame(long[] source, int offset, int length, long value) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (source[i] != value) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isLongArrayAllSame(long[] source, long value) {
        return ArrayUtilities.isLongArrayAllSame(source, 0, source.length, value);
    }

    public static long[] sliceToNewLongArrayOP(@ReadonlyValue Slice<long[]> slice) {
        int n = slice.getLength();
        long[] a = new long[n];
        System.arraycopy(slice.getUnderlying(), slice.getOffset(), a, 0, n);
        return a;
    }

    public static long[] sliceToLongArrayOPC(@ReadonlyValue Slice<long[]> slice) {
        int o = slice.getOffset();
        int n = slice.getLength();
        long[] u = slice.getUnderlying();
        if (o == 0 && n == u.length) {
            return u;
        }
        long[] a = new long[n];
        System.arraycopy(u, o, a, 0, n);
        return a;
    }

    public static Slice<long[]> wholeArraySliceLong(long[] array) {
        return new Slice<long[]>(array, 0, array.length);
    }

    public static Slice<long[]> newArraySliceLong(long ... array) {
        return new Slice<long[]>(array, 0, array.length);
    }

    public static Slice<long[]> newArrayToSliceLong(int length) {
        return new Slice<long[]>(new long[length], 0, length);
    }

    public static Slice<long[]> cloneArrayToSliceLong(long[] array) {
        return new Slice<long[]>((long[])array.clone(), 0, array.length);
    }

    public static Slice<long[]> cloneSliceLong(Slice<long[]> slice) {
        return ArrayUtilities.wholeArraySliceLong(ArrayUtilities.sliceToNewLongArrayOP(slice));
    }

    public static Slice<long[]> trimSliceOPCLong(Slice<long[]> arraySlice) {
        if (ArrayUtilities.isArraySliceFullLong(arraySlice)) {
            return arraySlice;
        }
        return ArrayUtilities.cloneSliceLong(arraySlice);
    }

    public static boolean isArraySliceFullLong(Slice<long[]> arraySlice) {
        return arraySlice.getOffset() == 0 && arraySlice.getLength() == arraySlice.getUnderlying().length;
    }

    public static void arrayslicecopyLong(Slice<long[]> arraySliceSource, Slice<long[]> arraySliceDest) {
        ArrayUtilities.arrayslicecopyLong(arraySliceSource, arraySliceDest, SmallIntegerMathUtilities.least(arraySliceSource.getLength(), arraySliceDest.getLength()));
    }

    public static void arrayslicecopyLong(Slice<long[]> arraySliceSource, Slice<long[]> arraySliceDest, int length) {
        System.arraycopy(arraySliceSource.getUnderlying(), arraySliceSource.getOffset(), arraySliceDest.getUnderlying(), arraySliceDest.getOffset(), length);
    }

    public static boolean equalsWithinTolerances(double[] a, double[] b, double absoluteTolerance, double relativeTolerance) {
        if (a.length != b.length) {
            return false;
        }
        int n = a.length;
        return ArrayUtilities.equalsWithinTolerances(a, 0, b, 0, n, absoluteTolerance, relativeTolerance);
    }

    public static boolean equalsWithinTolerances(double[] a, int aOffset, double[] b, int bOffset, int length, double absoluteTolerance, double relativeTolerance) {
        int i = 0;
        while (i < length) {
            if (!SmallFloatMathUtilities.equalWithinTolerances(a[aOffset + i], b[bOffset + i], absoluteTolerance, relativeTolerance)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsWithinTolerancesSliceDouble(Slice<double[]> a, Slice<double[]> b, double absoluteTolerance, double relativeTolerance) {
        int length = a.getLength();
        if (length != b.getLength()) {
            return false;
        }
        return ArrayUtilities.equalsWithinTolerances(a.getUnderlying(), a.getOffset(), b.getUnderlying(), b.getOffset(), length, absoluteTolerance, relativeTolerance);
    }

    public static <I> boolean forAll(Predicate<? super I> predicate, I[] inputs) {
        I[] IArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            I v = IArray[n2];
            if (!predicate.test(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <I> boolean forAny(Predicate<? super I> predicate, I[] inputs) {
        I[] IArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            I v = IArray[n2];
            if (predicate.test(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, boolean[] inputs) {
        boolean[] blArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            boolean v = blArray[n2];
            if (!predicate.f(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, boolean[] inputs) {
        boolean[] blArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            boolean v = blArray[n2];
            if (predicate.f(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, boolean[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            boolean v = inputs[offset + i];
            if (!predicate.f(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, boolean[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            boolean v = inputs[offset + i];
            if (predicate.f(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, Slice<boolean[]> inputs) {
        return ArrayUtilities.forAll(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionBooleanToBoolean predicate, Slice<boolean[]> inputs) {
        return ArrayUtilities.forAny(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, byte[] inputs) {
        byte[] byArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            byte v = byArray[n2];
            if (!predicate.f(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, byte[] inputs) {
        byte[] byArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            byte v = byArray[n2];
            if (predicate.f(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, byte[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            byte v = inputs[offset + i];
            if (!predicate.f(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, byte[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            byte v = inputs[offset + i];
            if (predicate.f(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, Slice<byte[]> inputs) {
        return ArrayUtilities.forAll(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionByteToBoolean predicate, Slice<byte[]> inputs) {
        return ArrayUtilities.forAny(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, char[] inputs) {
        char[] cArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            char v = cArray[n2];
            if (!predicate.f(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, char[] inputs) {
        char[] cArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            char v = cArray[n2];
            if (predicate.f(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, char[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            char v = inputs[offset + i];
            if (!predicate.f(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, char[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            char v = inputs[offset + i];
            if (predicate.f(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, Slice<char[]> inputs) {
        return ArrayUtilities.forAll(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, Slice<char[]> inputs) {
        return ArrayUtilities.forAny(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, short[] inputs) {
        short[] sArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            short v = sArray[n2];
            if (!predicate.f(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, short[] inputs) {
        short[] sArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            short v = sArray[n2];
            if (predicate.f(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, short[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            short v = inputs[offset + i];
            if (!predicate.f(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, short[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            short v = inputs[offset + i];
            if (predicate.f(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, Slice<short[]> inputs) {
        return ArrayUtilities.forAll(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionShortToBoolean predicate, Slice<short[]> inputs) {
        return ArrayUtilities.forAny(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, float[] inputs) {
        float[] fArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            if (!predicate.f(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, float[] inputs) {
        float[] fArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            float v = fArray[n2];
            if (predicate.f(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, float[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            float v = inputs[offset + i];
            if (!predicate.f(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, float[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            float v = inputs[offset + i];
            if (predicate.f(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, Slice<float[]> inputs) {
        return ArrayUtilities.forAll(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionFloatToBoolean predicate, Slice<float[]> inputs) {
        return ArrayUtilities.forAny(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, int[] inputs) {
        int[] nArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (!predicate.f(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, int[] inputs) {
        int[] nArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            int v = nArray[n2];
            if (predicate.f(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, int[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            int v = inputs[offset + i];
            if (!predicate.f(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, int[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            int v = inputs[offset + i];
            if (predicate.f(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, Slice<int[]> inputs) {
        return ArrayUtilities.forAll(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionIntToBoolean predicate, Slice<int[]> inputs) {
        return ArrayUtilities.forAny(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, double[] inputs) {
        double[] dArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (!predicate.f(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, double[] inputs) {
        double[] dArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            double v = dArray[n2];
            if (predicate.f(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, double[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            double v = inputs[offset + i];
            if (!predicate.f(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, double[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            double v = inputs[offset + i];
            if (predicate.f(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, Slice<double[]> inputs) {
        return ArrayUtilities.forAll(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionDoubleToBoolean predicate, Slice<double[]> inputs) {
        return ArrayUtilities.forAny(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, long[] inputs) {
        long[] lArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            if (!predicate.f(v)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, long[] inputs) {
        long[] lArray = inputs;
        int n = inputs.length;
        int n2 = 0;
        while (n2 < n) {
            long v = lArray[n2];
            if (predicate.f(v)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, long[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            long v = inputs[offset + i];
            if (!predicate.f(v)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, long[] inputs, int offset, int length) {
        int i = 0;
        while (i < length) {
            long v = inputs[offset + i];
            if (predicate.f(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, Slice<long[]> inputs) {
        return ArrayUtilities.forAll(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionLongToBoolean predicate, Slice<long[]> inputs) {
        return ArrayUtilities.forAny(predicate, inputs.getUnderlying(), inputs.getOffset(), inputs.getLength());
    }

    public static int compareBigEndianLengthsFirstUnsigned(@Nonnull byte[] a, @Nonnull byte[] b) {
        if (a == b) {
            return 0;
        }
        int al = a.length;
        int bl = b.length;
        if (al < bl) {
            return -1;
        }
        if (al > bl) {
            return 1;
        }
        int len = CodeHinting.arbitrary(al, bl);
        int i = 0;
        while (i < len) {
            int aVal = a[i] & 0xFF;
            int bVal = b[i] & 0xFF;
            if (aVal < bVal) {
                return -1;
            }
            if (aVal > bVal) {
                return 1;
            }
            ++i;
        }
        return 0;
    }

    public static int indexOfSubarrayBoolean(Slice<boolean[]> array, Slice<boolean[]> searchTarget) {
        return ArrayUtilities.indexOfSubarrayBoolean(array, searchTarget, 0);
    }

    public static int indexOfSubarrayBoolean(Slice<boolean[]> array, Slice<boolean[]> searchTarget, int fromIndex) {
        return ArrayUtilities.indexOfSubarrayBoolean(array, searchTarget, fromIndex, (a, b) -> a == b);
    }

    public static int indexOfSubarrayBoolean(Slice<boolean[]> array, Slice<boolean[]> searchTarget, int fromIndex, FunctionInterfaces.BooleanEqualityComparator ceq) {
        int sourceCount = array.getLength();
        int targetCount = searchTarget.getLength();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        boolean first = ArrayUtilities.getBoolean(searchTarget, 0);
        int max = sourceCount - targetCount;
        int i = fromIndex;
        while (i <= max) {
            if (!ceq.booleansEqual(ArrayUtilities.getBoolean(array, i), first)) {
                while (++i <= max && !ceq.booleansEqual(ArrayUtilities.getBoolean(array, i), first)) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && ceq.booleansEqual(ArrayUtilities.getBoolean(array, j), ArrayUtilities.getBoolean(searchTarget, k))) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfSubarrayByte(Slice<byte[]> array, Slice<byte[]> searchTarget) {
        return ArrayUtilities.indexOfSubarrayByte(array, searchTarget, 0);
    }

    public static int indexOfSubarrayByte(Slice<byte[]> array, Slice<byte[]> searchTarget, int fromIndex) {
        return ArrayUtilities.indexOfSubarrayByte(array, searchTarget, fromIndex, (a, b) -> a == b);
    }

    public static int indexOfSubarrayByte(Slice<byte[]> array, Slice<byte[]> searchTarget, int fromIndex, FunctionInterfaces.ByteEqualityComparator ceq) {
        int sourceCount = array.getLength();
        int targetCount = searchTarget.getLength();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        byte first = ArrayUtilities.getByte(searchTarget, 0);
        int max = sourceCount - targetCount;
        int i = fromIndex;
        while (i <= max) {
            if (!ceq.bytesEqual(ArrayUtilities.getByte(array, i), first)) {
                while (++i <= max && !ceq.bytesEqual(ArrayUtilities.getByte(array, i), first)) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && ceq.bytesEqual(ArrayUtilities.getByte(array, j), ArrayUtilities.getByte(searchTarget, k))) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfSubarrayChar(Slice<char[]> array, Slice<char[]> searchTarget) {
        return ArrayUtilities.indexOfSubarrayChar(array, searchTarget, 0);
    }

    public static int indexOfSubarrayChar(Slice<char[]> array, Slice<char[]> searchTarget, int fromIndex) {
        return ArrayUtilities.indexOfSubarrayChar(array, searchTarget, fromIndex, (a, b) -> a == b);
    }

    public static int indexOfSubarrayChar(Slice<char[]> array, Slice<char[]> searchTarget, int fromIndex, FunctionInterfaces.CharEqualityComparator ceq) {
        int sourceCount = array.getLength();
        int targetCount = searchTarget.getLength();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = ArrayUtilities.getChar(searchTarget, 0);
        int max = sourceCount - targetCount;
        int i = fromIndex;
        while (i <= max) {
            if (!ceq.charsEqual(ArrayUtilities.getChar(array, i), first)) {
                while (++i <= max && !ceq.charsEqual(ArrayUtilities.getChar(array, i), first)) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && ceq.charsEqual(ArrayUtilities.getChar(array, j), ArrayUtilities.getChar(searchTarget, k))) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfSubarrayShort(Slice<short[]> array, Slice<short[]> searchTarget) {
        return ArrayUtilities.indexOfSubarrayShort(array, searchTarget, 0);
    }

    public static int indexOfSubarrayShort(Slice<short[]> array, Slice<short[]> searchTarget, int fromIndex) {
        return ArrayUtilities.indexOfSubarrayShort(array, searchTarget, fromIndex, (a, b) -> a == b);
    }

    public static int indexOfSubarrayShort(Slice<short[]> array, Slice<short[]> searchTarget, int fromIndex, FunctionInterfaces.ShortEqualityComparator ceq) {
        int sourceCount = array.getLength();
        int targetCount = searchTarget.getLength();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        short first = ArrayUtilities.getShort(searchTarget, 0);
        int max = sourceCount - targetCount;
        int i = fromIndex;
        while (i <= max) {
            if (!ceq.shortsEqual(ArrayUtilities.getShort(array, i), first)) {
                while (++i <= max && !ceq.shortsEqual(ArrayUtilities.getShort(array, i), first)) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && ceq.shortsEqual(ArrayUtilities.getShort(array, j), ArrayUtilities.getShort(searchTarget, k))) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfSubarrayFloat(Slice<float[]> array, Slice<float[]> searchTarget) {
        return ArrayUtilities.indexOfSubarrayFloat(array, searchTarget, 0);
    }

    public static int indexOfSubarrayFloat(Slice<float[]> array, Slice<float[]> searchTarget, int fromIndex) {
        return ArrayUtilities.indexOfSubarrayFloat(array, searchTarget, fromIndex, (a, b) -> a == b);
    }

    public static int indexOfSubarrayFloat(Slice<float[]> array, Slice<float[]> searchTarget, int fromIndex, FunctionInterfaces.FloatEqualityComparator ceq) {
        int sourceCount = array.getLength();
        int targetCount = searchTarget.getLength();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        float first = ArrayUtilities.getFloat(searchTarget, 0);
        int max = sourceCount - targetCount;
        int i = fromIndex;
        while (i <= max) {
            if (!ceq.floatsEqual(ArrayUtilities.getFloat(array, i), first)) {
                while (++i <= max && !ceq.floatsEqual(ArrayUtilities.getFloat(array, i), first)) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && ceq.floatsEqual(ArrayUtilities.getFloat(array, j), ArrayUtilities.getFloat(searchTarget, k))) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfSubarrayInt(Slice<int[]> array, Slice<int[]> searchTarget) {
        return ArrayUtilities.indexOfSubarrayInt(array, searchTarget, 0);
    }

    public static int indexOfSubarrayInt(Slice<int[]> array, Slice<int[]> searchTarget, int fromIndex) {
        return ArrayUtilities.indexOfSubarrayInt(array, searchTarget, fromIndex, (a, b) -> a == b);
    }

    public static int indexOfSubarrayInt(Slice<int[]> array, Slice<int[]> searchTarget, int fromIndex, FunctionInterfaces.IntEqualityComparator ceq) {
        int sourceCount = array.getLength();
        int targetCount = searchTarget.getLength();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        int first = ArrayUtilities.getInt(searchTarget, 0);
        int max = sourceCount - targetCount;
        int i = fromIndex;
        while (i <= max) {
            if (!ceq.intsEqual(ArrayUtilities.getInt(array, i), first)) {
                while (++i <= max && !ceq.intsEqual(ArrayUtilities.getInt(array, i), first)) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && ceq.intsEqual(ArrayUtilities.getInt(array, j), ArrayUtilities.getInt(searchTarget, k))) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfSubarrayDouble(Slice<double[]> array, Slice<double[]> searchTarget) {
        return ArrayUtilities.indexOfSubarrayDouble(array, searchTarget, 0);
    }

    public static int indexOfSubarrayDouble(Slice<double[]> array, Slice<double[]> searchTarget, int fromIndex) {
        return ArrayUtilities.indexOfSubarrayDouble(array, searchTarget, fromIndex, (a, b) -> a == b);
    }

    public static int indexOfSubarrayDouble(Slice<double[]> array, Slice<double[]> searchTarget, int fromIndex, FunctionInterfaces.DoubleEqualityComparator ceq) {
        int sourceCount = array.getLength();
        int targetCount = searchTarget.getLength();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        double first = ArrayUtilities.getDouble(searchTarget, 0);
        int max = sourceCount - targetCount;
        int i = fromIndex;
        while (i <= max) {
            if (!ceq.doublesEqual(ArrayUtilities.getDouble(array, i), first)) {
                while (++i <= max && !ceq.doublesEqual(ArrayUtilities.getDouble(array, i), first)) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && ceq.doublesEqual(ArrayUtilities.getDouble(array, j), ArrayUtilities.getDouble(searchTarget, k))) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfSubarrayLong(Slice<long[]> array, Slice<long[]> searchTarget) {
        return ArrayUtilities.indexOfSubarrayLong(array, searchTarget, 0);
    }

    public static int indexOfSubarrayLong(Slice<long[]> array, Slice<long[]> searchTarget, int fromIndex) {
        return ArrayUtilities.indexOfSubarrayLong(array, searchTarget, fromIndex, (a, b) -> a == b);
    }

    public static int indexOfSubarrayLong(Slice<long[]> array, Slice<long[]> searchTarget, int fromIndex, FunctionInterfaces.LongEqualityComparator ceq) {
        int sourceCount = array.getLength();
        int targetCount = searchTarget.getLength();
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        long first = ArrayUtilities.getLong(searchTarget, 0);
        int max = sourceCount - targetCount;
        int i = fromIndex;
        while (i <= max) {
            if (!ceq.longsEqual(ArrayUtilities.getLong(array, i), first)) {
                while (++i <= max && !ceq.longsEqual(ArrayUtilities.getLong(array, i), first)) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = 1;
                while (j < end && ceq.longsEqual(ArrayUtilities.getLong(array, j), ArrayUtilities.getLong(searchTarget, k))) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i;
                }
            }
            ++i;
        }
        return -1;
    }

    public static <E> E[] closeSequence(E[] array) {
        if (array.length == 0) {
            throw new IllegalArgumentException();
        }
        int n = array.length;
        E[] newa = Arrays.copyOf(array, n + 1);
        newa[n] = array[0];
        return newa;
    }

    public static byte[] getOrCreateBuffer(@Nullable ContainerInterfaces.ObjectContainer<byte[]> cache, int minSize) {
        if (cache == null) {
            return new byte[minSize];
        }
        byte[] v = cache.get();
        if (v == null || v.length < minSize) {
            v = new byte[minSize];
            cache.set(v);
        }
        return v;
    }

    public static byte[] getOrGrowBuffer(@Nonnull ContainerInterfaces.ObjectContainer<byte[]> holder, int minSize) {
        byte[] v = holder.get();
        if (v == null || v.length < minSize) {
            v = Arrays.copyOf(v, minSize);
            holder.set(v);
        }
        return v;
    }
}

