/*
 * Decompiled with CFR 0.152.
 */
package rebound.text;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.MalformedInputException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.Signed;
import rebound.annotations.semantic.SignalType;
import rebound.annotations.semantic.allowedoperations.WritableValue;
import rebound.annotations.semantic.reachability.PossiblySnapshotPossiblyLiveValue;
import rebound.annotations.semantic.reachability.ThrowAwayValue;
import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.annotations.semantic.simpledata.NonnullKeys;
import rebound.annotations.semantic.simpledata.Positive;
import rebound.bits.BitfieldSafeCasts;
import rebound.bits.DataEncodingUtilities;
import rebound.bits.Endianness;
import rebound.bits.Unsigned;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.NotSingletonException;
import rebound.exceptions.NotYetImplementedException;
import rebound.exceptions.ReturnPath;
import rebound.exceptions.StopIterationReturnPath;
import rebound.exceptions.TextSyntaxCheckedException;
import rebound.exceptions.TextSyntaxException;
import rebound.exceptions.UnreachableCodeException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.io.ucs4.UCS4ReaderFromNormalUTF16Reader;
import rebound.io.ucs4.UCS4Writer;
import rebound.io.ucs4.UTF16EncodingException;
import rebound.io.util.TextIOUtilities;
import rebound.math.Direction1D;
import rebound.math.MathUtilities;
import rebound.math.PlaceValueEncodingAlgorithm;
import rebound.math.SmallIntegerMathUtilities;
import rebound.testing.WidespreadTestingUtilities;
import rebound.text.CharacterPredicates;
import rebound.text.Cursor;
import rebound.util.BasicExceptionUtilities;
import rebound.util.NIOBufferUtilities;
import rebound.util.Primitives;
import rebound.util.ScanDirection;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.BasicCollectionUtilities;
import rebound.util.collections.CollectionUtilities;
import rebound.util.collections.FilterAwayReturnPath;
import rebound.util.collections.IdentityHashSet;
import rebound.util.collections.Interval;
import rebound.util.collections.Mapper;
import rebound.util.collections.PairOrdered;
import rebound.util.collections.PairOrderedImmutable;
import rebound.util.collections.PolymorphicCollectionUtilities;
import rebound.util.collections.SimpleIterator;
import rebound.util.collections.SimpleTable;
import rebound.util.collections.Slice;
import rebound.util.collections.prim.PrimitiveCollections;
import rebound.util.container.SimpleContainers;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.functional.FunctionalUtilities;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.objectutil.ObjectUtilities;

public class StringUtilities
implements JavaNamespace {
    public static final String SYSTEM_EOL = System.getProperty("line.separator");
    public static final int NUMBER_OF_CHARACTERS = 65536;
    public static final char[] ALPHABET_ENGLISH_US_LOWER = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] ALPHABET_ENGLISH_US_UPPER = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};
    public static final char[] ALPHABET_BASE_10_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public static final char[] ALPHABET_ENGLISH_US_UPPER__ENGLISH_US_LOWER = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final char[] ALPHABET_BASE_10_DIGITS__ENGLISH_US_UPPER__ENGLISH_US_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    public static final String[] EmptyStringArray = new String[0];
    protected static final FunctionInterfaces.UnaryFunctionCharToBoolean ThreeQuotesPattern = new FunctionInterfaces.UnaryFunctionCharToBoolean(){

        @Override
        public boolean f(char input) {
            return input == '\"' || input == '\'' || input == '`';
        }
    };
    protected static final FunctionInterfaces.UnaryFunctionCharToBoolean TwoQuotesPattern = new FunctionInterfaces.UnaryFunctionCharToBoolean(){

        @Override
        public boolean f(char input) {
            return input == '\"' || input == '\'';
        }
    };
    protected static final FunctionInterfaces.UnaryFunctionCharToBoolean JustDoubleQuotesPattern = new FunctionalUtilities.SingletonCharEqualityPredicate('\"');
    protected static final FunctionInterfaces.UnaryFunctionCharToBoolean BackslashPattern = new FunctionalUtilities.SingletonCharEqualityPredicate('\\');
    protected static final int SequenceChildmembersReprStringLengthThresholdForMultiline = 20;
    protected static final Comparator<Map.Entry<Object, Object>> ReprMapKeysBestEffortSortingComparator = new Comparator<Map.Entry<Object, Object>>(){

        @Override
        public int compare(Map.Entry<Object, Object> a, Map.Entry<Object, Object> b) {
            Object ak = a.getKey();
            Object bk = b.getKey();
            if (ak instanceof Comparable) {
                if (bk instanceof Comparable) {
                    return BasicObjectUtilities.cmp2(ak, bk);
                }
                return 1;
            }
            if (bk instanceof Comparable) {
                return -1;
            }
            return 0;
        }
    };
    protected static final int ByteArrayMaxTostringLengthInBytes = 128;

    public static String replace(String original, char target, char replacement) {
        StringBuilder buff = new StringBuilder();
        char[] cArray = original.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == target) {
                buff.append(replacement);
            } else {
                buff.append(c);
            }
            ++n2;
        }
        return buff.toString();
    }

    public static String replace(String original, char target, String replacement) {
        StringBuilder buff = new StringBuilder();
        char[] cArray = original.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == target) {
                buff.append(replacement);
            } else {
                buff.append(c);
            }
            ++n2;
        }
        return buff.toString();
    }

    public static String replace(String original, FunctionInterfaces.UnaryFunctionCharToBoolean target, String replacement) {
        StringBuilder buff = new StringBuilder();
        char[] cArray = original.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (target.f(c)) {
                buff.append(replacement);
            } else {
                buff.append(c);
            }
            ++n2;
        }
        return buff.toString();
    }

    public static String applyReplacements(String source, Iterable<StaticReplacement> replacements) {
        StringBuilder buff = new StringBuilder();
        int position = 0;
        int amt = 0;
        String r = null;
        int s = 0;
        int e = 0;
        for (StaticReplacement replacement : replacements) {
            r = replacement.getReplacement();
            s = replacement.getStart();
            e = replacement.getEnd();
            amt = s - position;
            if (amt < 0) {
                throw new IllegalArgumentException("Replacements were overlapping");
            }
            if (amt > 0) {
                buff.append(source.substring(position, s));
            }
            position += amt;
            if (r != null) {
                buff.append(r);
            }
            if (e < s) {
                throw new IllegalArgumentException("The end cannot come before the start.");
            }
            position += e - s;
        }
        buff.append(source.substring(position));
        return buff.toString();
    }

    public static void applyReplacements(Reader source, Writer sink, Iterable<Replacement> replacements) throws IllegalArgumentException, IOException {
        int position = 0;
        int amt = 0;
        int s = 0;
        int e = 0;
        for (Replacement replacement : replacements) {
            s = replacement.getStart();
            e = replacement.getEnd();
            amt = s - position;
            if (amt < 0) {
                throw new IllegalArgumentException("Replacements were overlapping");
            }
            if (amt > 0) {
                TextIOUtilities.pumpFixed(source, sink, (long)amt);
            }
            position += amt;
            replacement.write(sink);
            if (e < s) {
                throw new IllegalArgumentException("The end cannot come before the start.");
            }
            if (e <= s) continue;
            TextIOUtilities.discard(source, e - s);
            position += e - s;
        }
        TextIOUtilities.pump(source, sink);
    }

    public static String applyMultipleCharReplacements(String str, char[] targets, char replacement) {
        char[] oldc = str.toCharArray();
        char[] newc = new char[oldc.length];
        int i = 0;
        int e = 0;
        char c = '\u0000';
        i = 0;
        while (i < newc.length) {
            c = oldc[i];
            e = 0;
            e = 0;
            while (e < targets.length) {
                if (c == targets[e]) {
                    newc[i] = replacement;
                    break;
                }
                ++e;
            }
            if (e == targets.length) {
                newc[i] = c;
            }
            ++i;
        }
        return new String(newc);
    }

    public static String applyMultipleCharReplacements(String str, char[] targets, char[] replacements) {
        char[] oldc = str.toCharArray();
        char[] newc = new char[oldc.length];
        int i = 0;
        int e = 0;
        char c = '\u0000';
        i = 0;
        while (i < newc.length) {
            c = oldc[i];
            e = 0;
            e = 0;
            while (e < targets.length) {
                if (c == targets[e]) {
                    newc[i] = replacements[e];
                    break;
                }
                ++e;
            }
            if (e == targets.length) {
                newc[i] = c;
            }
            ++i;
        }
        return new String(newc);
    }

    public static char[] applyMultiplePositionBasedCharReplacementsCA(Object text, char replacement, int[] positions) {
        char[] ca = StringUtilities.textthingToPossiblyUnclonedCharArray(text);
        int[] nArray = positions;
        int n = positions.length;
        int n2 = 0;
        while (n2 < n) {
            int position = nArray[n2];
            ca[position] = replacement;
            ++n2;
        }
        return ca;
    }

    public static String applyMultiplePositionBasedCharReplacementsS(Object text, char replacement, int[] positions) {
        return new String(StringUtilities.applyMultiplePositionBasedCharReplacementsCA(text, replacement, positions));
    }

    public static String replaceAll(String original, String simpleCaseSensitiveNonregexPattern, ReplacementBoss replacementBoss) {
        int nextStart;
        StringBuilder buff = new StringBuilder();
        int replacementIndex = 0;
        int cursor = 0;
        while (cursor < original.length() && (nextStart = original.indexOf(simpleCaseSensitiveNonregexPattern, cursor)) != -1) {
            int nextEnd = nextStart + simpleCaseSensitiveNonregexPattern.length();
            buff.append(original, cursor, nextStart);
            buff.append(replacementBoss.whatDoBoss(replacementIndex, original.substring(nextStart, nextEnd)));
            ++replacementIndex;
            cursor = nextEnd;
        }
        if (cursor < original.length()) {
            buff.append(original, cursor, original.length());
        }
        return buff.toString();
    }

    public static String[] split(String original, char delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties) {
        if (whatToDoWithEmpties == null) {
            throw new NullPointerException();
        }
        boolean leaveInEmpties = whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties;
        char[] data = original.toCharArray();
        ArrayList<String> tokens = new ArrayList<String>(6);
        int tokenStart = 0;
        int i = 0;
        while (i < data.length && (limitInMaximumNumberOfDelimiterSplits == -1 || tokens.size() < limitInMaximumNumberOfDelimiterSplits)) {
            if (data[i] == delimiter) {
                if (leaveInEmpties || i - tokenStart != 0) {
                    tokens.add(new String(data, tokenStart, i - tokenStart));
                }
                tokenStart = i + 1;
            }
            ++i;
        }
        if (leaveInEmpties || data.length - tokenStart != 0) {
            tokens.add(new String(data, tokenStart, data.length - tokenStart));
        }
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String[] rsplit(String original, char delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties) {
        if (whatToDoWithEmpties == null) {
            throw new NullPointerException();
        }
        boolean leaveInEmpties = whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties;
        char[] data = original.toCharArray();
        ArrayList<String> tokens = new ArrayList<String>(6);
        int tokenEnd = data.length;
        int i = data.length - 1;
        while (i >= 0 && (limitInMaximumNumberOfDelimiterSplits == -1 || tokens.size() < limitInMaximumNumberOfDelimiterSplits)) {
            if (data[i] == delimiter) {
                if (leaveInEmpties || tokenEnd - (i + 1) != 0) {
                    tokens.add(new String(data, i + 1, tokenEnd - (i + 1)));
                }
                tokenEnd = i;
            }
            --i;
        }
        if (leaveInEmpties || tokenEnd != 0) {
            tokens.add(new String(data, 0, tokenEnd));
        }
        String[] reversed = new String[tokens.size()];
        int i2 = 0;
        while (i2 < reversed.length) {
            reversed[i2] = (String)tokens.get(reversed.length - i2 - 1);
            ++i2;
        }
        return reversed;
    }

    public static String[] split(String original, char delimiter, int limit) {
        return StringUtilities.split(original, delimiter, limit, WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static String[] rsplit(String original, char delimiter, int limit) {
        return StringUtilities.rsplit(original, delimiter, limit, WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static String[] split(String original, char delimiter) {
        return StringUtilities.split(original, delimiter, -1);
    }

    public static String[] split(String original, char delimiter, int limitInMaximumNumberOfDelimiterSplits, ScanDirection direction) {
        if (direction == ScanDirection.Forward) {
            return StringUtilities.split(original, delimiter, limitInMaximumNumberOfDelimiterSplits);
        }
        if (direction == ScanDirection.Reverse) {
            return StringUtilities.rsplit(original, delimiter, limitInMaximumNumberOfDelimiterSplits);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)direction);
    }

    public static String[] split(String original, char delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties, ScanDirection direction) {
        if (direction == ScanDirection.Forward) {
            return StringUtilities.split(original, delimiter, limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties);
        }
        if (direction == ScanDirection.Reverse) {
            return StringUtilities.rsplit(original, delimiter, limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)direction);
    }

    public static String[] split(String original, FunctionInterfaces.UnaryFunctionCharToBoolean delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties) {
        if (whatToDoWithEmpties == null) {
            throw new NullPointerException();
        }
        boolean leaveInEmpties = whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties;
        char[] data = original.toCharArray();
        ArrayList<String> tokens = new ArrayList<String>(6);
        int tokenStart = 0;
        int i = 0;
        while (i < data.length && (limitInMaximumNumberOfDelimiterSplits == -1 || tokens.size() < limitInMaximumNumberOfDelimiterSplits)) {
            if (delimiter.f(data[i])) {
                if (leaveInEmpties || i - tokenStart != 0) {
                    tokens.add(new String(data, tokenStart, i - tokenStart));
                }
                tokenStart = i + 1;
            }
            ++i;
        }
        tokens.add(new String(data, tokenStart, data.length - tokenStart));
        return tokens.toArray(new String[tokens.size()]);
    }

    public static String[] rsplit(String original, FunctionInterfaces.UnaryFunctionCharToBoolean delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties) {
        if (whatToDoWithEmpties == null) {
            throw new NullPointerException();
        }
        boolean leaveInEmpties = whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties;
        char[] data = original.toCharArray();
        ArrayList<String> tokens = new ArrayList<String>(6);
        int tokenEnd = data.length;
        int i = data.length - 1;
        while (i >= 0 && (limitInMaximumNumberOfDelimiterSplits == -1 || tokens.size() < limitInMaximumNumberOfDelimiterSplits)) {
            if (delimiter.f(data[i])) {
                if (leaveInEmpties || tokenEnd - (i + 1) != 0) {
                    tokens.add(new String(data, i + 1, tokenEnd - (i + 1)));
                }
                tokenEnd = i;
            }
            --i;
        }
        tokens.add(new String(data, 0, tokenEnd));
        String[] reversed = new String[tokens.size()];
        int i2 = 0;
        while (i2 < reversed.length) {
            reversed[i2] = (String)tokens.get(reversed.length - i2 - 1);
            ++i2;
        }
        return reversed;
    }

    public static String[] split(String original, FunctionInterfaces.UnaryFunctionCharToBoolean delimiter, int limit) {
        return StringUtilities.split(original, delimiter, limit, WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static String[] rsplit(String original, FunctionInterfaces.UnaryFunctionCharToBoolean delimiter, int limit) {
        return StringUtilities.rsplit(original, delimiter, limit, WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static String[] split(String original, FunctionInterfaces.UnaryFunctionCharToBoolean delimiter) {
        return StringUtilities.split(original, delimiter, -1);
    }

    public static String[] split(String original, FunctionInterfaces.UnaryFunctionCharToBoolean delimiter, int limitInMaximumNumberOfDelimiterSplits, ScanDirection direction) {
        if (direction == ScanDirection.Forward) {
            return StringUtilities.split(original, delimiter, limitInMaximumNumberOfDelimiterSplits);
        }
        if (direction == ScanDirection.Reverse) {
            return StringUtilities.rsplit(original, delimiter, limitInMaximumNumberOfDelimiterSplits);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)direction);
    }

    public static String[] split(String original, FunctionInterfaces.UnaryFunctionCharToBoolean delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties, ScanDirection direction) {
        if (direction == ScanDirection.Forward) {
            return StringUtilities.split(original, delimiter, limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties);
        }
        if (direction == ScanDirection.Reverse) {
            return StringUtilities.rsplit(original, delimiter, limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)direction);
    }

    public static StringScanner singleSubstringScanner(String target) {
        int targetLength = target.length();
        return (string2, start) -> {
            int nextMatchNearside = string2.indexOf(target, start);
            if (nextMatchNearside == -1) {
                return null;
            }
            return new Interval(nextMatchNearside, targetLength);
        };
    }

    public static StringScanner singleSubstringScannerReversed(String target) {
        int targetLength = target.length();
        return (string2, start) -> {
            int nextMatchNearside = string2.lastIndexOf(target, start);
            if (nextMatchNearside == -1) {
                return null;
            }
            return new Interval(nextMatchNearside, targetLength);
        };
    }

    public static StringScanner multiSubstringScanner(Iterable<String> targets) {
        return (string, start) -> {
            String bestMatchTarget = null;
            int bestMatchTargetStartingIndex = 0;
            for (String target : targets) {
                int nextMatchNearside = string.indexOf(target, start);
                if (nextMatchNearside == -1 || bestMatchTarget != null && nextMatchNearside >= bestMatchTargetStartingIndex) continue;
                bestMatchTarget = target;
                bestMatchTargetStartingIndex = nextMatchNearside;
            }
            return bestMatchTarget == null ? null : new Interval(bestMatchTargetStartingIndex, bestMatchTarget.length());
        };
    }

    public static StringScanner multiSubstringScannerReversed(Iterable<String> targets) {
        return (string, start) -> {
            String bestMatchTarget = null;
            int bestMatchTargetStartingIndex = 0;
            for (String target : targets) {
                int nextMatchFarside = string.lastIndexOf(target, start);
                if (nextMatchFarside == -1 || bestMatchTarget != null && nextMatchFarside <= bestMatchTargetStartingIndex) continue;
                bestMatchTarget = target;
                bestMatchTargetStartingIndex = nextMatchFarside;
            }
            return bestMatchTarget == null ? null : new Interval(bestMatchTargetStartingIndex, bestMatchTarget.length());
        };
    }

    public static String[] split(@Nonnull String original, @Nonnull StringScanner delimiter, int limitInMaximumNumberOfDelimiterSplits, @Nonnull WhatToDoWithEmpties whatToDoWithEmpties, boolean leaveInDelimiters) {
        Interval nextMatchNearside;
        ArrayList<String> substrings = new ArrayList<String>();
        int currentPos = 0;
        while ((limitInMaximumNumberOfDelimiterSplits == -1 || substrings.size() < limitInMaximumNumberOfDelimiterSplits) && (nextMatchNearside = delimiter.findNextOrNullIfNone(original, currentPos)) != null) {
            if (whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties || currentPos != nextMatchNearside.getOffset()) {
                substrings.add(original.substring(currentPos, nextMatchNearside.getOffset()));
            }
            if (leaveInDelimiters) {
                substrings.add(original.substring(nextMatchNearside.getOffset(), nextMatchNearside.getPastEnd()));
            }
            currentPos = nextMatchNearside.getPastEnd();
        }
        if (whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties || currentPos != original.length()) {
            substrings.add(original.substring(currentPos));
        }
        return substrings.toArray(new String[substrings.size()]);
    }

    public static String[] rsplit(String original, StringScanner delimiterScanningBackwards, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties, boolean leaveInDelimiters) {
        Interval nextMatchFarside;
        ArrayList<String> substrings = new ArrayList<String>();
        int currentPos = original.length();
        int lastMark = original.length();
        while ((limitInMaximumNumberOfDelimiterSplits == -1 || substrings.size() < limitInMaximumNumberOfDelimiterSplits) && (nextMatchFarside = delimiterScanningBackwards.findNextOrNullIfNone(original, currentPos)) != null) {
            if (whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties || currentPos != nextMatchFarside.getOffset()) {
                substrings.add(original.substring(nextMatchFarside.getPastEnd(), lastMark));
            }
            if (leaveInDelimiters) {
                substrings.add(original.substring(nextMatchFarside.getOffset(), nextMatchFarside.getPastEnd()));
            }
            lastMark = nextMatchFarside.getOffset();
            if (nextMatchFarside.getOffset() < nextMatchFarside.getLength()) break;
            currentPos = nextMatchFarside.getOffset() - nextMatchFarside.getLength();
        }
        if (whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties || currentPos != original.length()) {
            substrings.add(original.substring(0, lastMark));
        }
        Object[] a = substrings.toArray(new String[substrings.size()]);
        ArrayUtilities.reverse(a);
        return a;
    }

    public static String[] split(@Nonnull String original, @Nonnull StringScanner delimiter, int limitInMaximumNumberOfDelimiterSplits, @Nonnull WhatToDoWithEmpties whatToDoWithEmpties) {
        return StringUtilities.split(original, delimiter, limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties, false);
    }

    public static String[] rsplit(String original, StringScanner delimiterScanningBackwards, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties) {
        return StringUtilities.rsplit(original, delimiterScanningBackwards, limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties, false);
    }

    public static String[] split(String original, String delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties) {
        if (delimiter.length() == 0) {
            throw new IllegalArgumentException();
        }
        return StringUtilities.split(original, StringUtilities.singleSubstringScanner(delimiter), limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties);
    }

    public static String[] rsplit(String original, String delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties) {
        if (delimiter.length() == 0) {
            throw new IllegalArgumentException();
        }
        return StringUtilities.rsplit(original, StringUtilities.singleSubstringScannerReversed(delimiter), limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties);
    }

    public static String[] split(String original, String delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties, ScanDirection direction) {
        if (direction == ScanDirection.Forward) {
            return StringUtilities.split(original, delimiter, limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties);
        }
        if (direction == ScanDirection.Reverse) {
            return StringUtilities.rsplit(original, delimiter, limitInMaximumNumberOfDelimiterSplits, whatToDoWithEmpties);
        }
        throw BasicExceptionUtilities.newUnexpectedHardcodedEnumValueExceptionOrNullPointerException((Object)direction);
    }

    public static String[] split(String original, String delimiter, int limitInMaximumNumberOfDelimiterSplits, ScanDirection direction) {
        return StringUtilities.split(original, delimiter, limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties.LeaveInEmpties, direction);
    }

    public static String[] split(String original, String delimiter, int limit) {
        return StringUtilities.split(original, delimiter, limit, WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static String[] rsplit(String original, String delimiter, int limit) {
        return StringUtilities.rsplit(original, delimiter, limit, WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static String[] split(String original, String delimiter) {
        return StringUtilities.split(original, delimiter, -1, WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static String[] rsplit(String original, String delimiter) {
        return StringUtilities.rsplit(original, delimiter, -1, WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static String[] splitwhitespace(String original) {
        return StringUtilities.splitwhitespace(original, -1);
    }

    public static String[] splitwhitespace(String original, int limitInMaximumNumberOfDelimiterSplits) {
        return StringUtilities.split(original, CharacterPredicates.WHITESPACE_PATTERN, limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties.LeaveOutEmpties);
    }

    public static String[] rsplitwhitespace(String original, int limitInMaximumNumberOfDelimiterSplits) {
        return StringUtilities.rsplit(original, CharacterPredicates.WHITESPACE_PATTERN, limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties.LeaveOutEmpties);
    }

    public static String[] splitlines(String s, WhatToDoWithEmpties whatToDoWithEmpties) {
        if (s.indexOf(13) != -1) {
            s = StringUtilities.universalNewlines(s);
        }
        return StringUtilities.split(s, '\n', -1, whatToDoWithEmpties);
    }

    public static String[] splitlines(String s) {
        return StringUtilities.splitlines(s, WhatToDoWithEmpties.LeaveInEmpties);
    }

    public static String[] splitlinesLeavingOffEmptyTrailingLine(String s) {
        if (s.isEmpty()) {
            return EmptyStringArray;
        }
        return StringUtilities.splitlines(StringUtilities.removeTrailingLineBreak(s));
    }

    public static String removeTrailingLineBreak(String s) {
        return StringUtilities.rtrimstr(StringUtilities.rtrimstr(StringUtilities.rtrimstr(s, "\r\n"), "\n"), "\r");
    }

    public static int countLines(CharSequence s) {
        return StringUtilities.count(s, '\n') + 1;
    }

    public static String joinlines(String[] lines) {
        return StringUtilities.joinStrings((Object[])lines, '\n');
    }

    public static String joinlines(Iterable<String> lines) {
        return StringUtilities.joinStrings(lines, '\n');
    }

    public static String joinlinesIncludingTrailingNewline(String[] lines) {
        StringBuilder buff = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            buff.append(line);
            buff.append('\n');
            ++n2;
        }
        return buff.toString();
    }

    public static String joinlinesIncludingTrailingNewline(Iterable<String> lines) {
        StringBuilder buff = new StringBuilder();
        for (String line : lines) {
            buff.append(line);
            buff.append('\n');
        }
        return buff.toString();
    }

    public static <E> List<List<E>> split(List<E> original, Predicate<E> delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties) {
        if (whatToDoWithEmpties == null) {
            throw new NullPointerException();
        }
        boolean leaveInEmpties = whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties;
        int length = original.size();
        ArrayList<List<List<E>>> tokens = new ArrayList<List<List<E>>>(6);
        int tokenStart = 0;
        int i = 0;
        while (i < length && (limitInMaximumNumberOfDelimiterSplits == -1 || tokens.size() < limitInMaximumNumberOfDelimiterSplits)) {
            if (delimiter.test(original.get(i))) {
                if (leaveInEmpties || i - tokenStart != 0) {
                    tokens.add(original.subList(tokenStart, i - tokenStart));
                }
                tokenStart = i + 1;
            }
            ++i;
        }
        tokens.add(original.subList(tokenStart, length - tokenStart));
        return tokens;
    }

    public static <E> List<List<E>> rsplit(List<E> original, Predicate<E> delimiter, int limitInMaximumNumberOfDelimiterSplits, WhatToDoWithEmpties whatToDoWithEmpties) {
        if (whatToDoWithEmpties == null) {
            throw new NullPointerException();
        }
        boolean leaveInEmpties = whatToDoWithEmpties == WhatToDoWithEmpties.LeaveInEmpties;
        int length = original.size();
        ArrayList<List<List<E>>> tokens = new ArrayList<List<List<E>>>(6);
        int tokenEnd = length;
        int i = length - 1;
        while (i >= 0 && (limitInMaximumNumberOfDelimiterSplits == -1 || tokens.size() < limitInMaximumNumberOfDelimiterSplits)) {
            if (delimiter.test(original.get(i))) {
                if (leaveInEmpties || tokenEnd - (i + 1) != 0) {
                    tokens.add(original.subList(i + 1, tokenEnd - (i + 1)));
                }
                tokenEnd = i;
            }
            --i;
        }
        tokens.add(original.subList(0, tokenEnd));
        Collections.reverse(tokens);
        return tokens;
    }

    @Nullable
    public static String[] splitonceOrNull(String s, char del) {
        String[] stringArray;
        int i = s.indexOf(del);
        if (i == -1) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = s.substring(0, i);
            stringArray = stringArray2;
            stringArray2[1] = s.substring(i + 1);
        }
        return stringArray;
    }

    @Nonnull
    public static String[] splitonce(String s, char del) {
        String[] stringArray;
        int i = s.indexOf(del);
        if (i == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = s.substring(0, i);
            stringArray = stringArray3;
            stringArray3[1] = s.substring(i + 1);
        }
        return stringArray;
    }

    @Nullable
    public static String[] splitonceOrNull(String s, FunctionInterfaces.UnaryFunctionCharToBoolean del) {
        String[] stringArray;
        int i = StringUtilities.indexOf((CharSequence)s, del);
        if (i == -1) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = s.substring(0, i);
            stringArray = stringArray2;
            stringArray2[1] = s.substring(i + 1);
        }
        return stringArray;
    }

    @Nonnull
    public static String[] splitonce(String s, FunctionInterfaces.UnaryFunctionCharToBoolean del) {
        String[] stringArray;
        int i = StringUtilities.indexOf((CharSequence)s, del);
        if (i == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = s.substring(0, i);
            stringArray = stringArray3;
            stringArray3[1] = s.substring(i + 1);
        }
        return stringArray;
    }

    @Nullable
    public static String[] splitonceOrNull(String s, String del) {
        String[] stringArray;
        int i = s.indexOf(del);
        if (i == -1) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = s.substring(0, i);
            stringArray = stringArray2;
            stringArray2[1] = s.substring(i + 1);
        }
        return stringArray;
    }

    @Nonnull
    public static String[] splitonce(String s, String del) {
        String[] stringArray;
        int i = s.indexOf(del);
        if (i == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = s.substring(0, i);
            stringArray = stringArray3;
            stringArray3[1] = s.substring(i + del.length());
        }
        return stringArray;
    }

    @Nonnull
    public static String splitonceReturnPrecedingOrWhole(String s, char del) {
        int i = s.indexOf(del);
        return i == -1 ? s : s.substring(0, i);
    }

    @Nullable
    public static String splitonceReturnPrecedingOrNull(String s, char del) {
        int i = s.indexOf(del);
        return i == -1 ? null : s.substring(0, i);
    }

    @Nullable
    public static String splitonceReturnSucceedingOrWhole(String s, char del) {
        int i = s.indexOf(del);
        return i == -1 ? s : s.substring(i + 1);
    }

    @Nullable
    public static String splitonceReturnSucceedingOrNull(String s, char del) {
        int i = s.indexOf(del);
        return i == -1 ? null : s.substring(i + 1);
    }

    @Nonnull
    public static String splitonceReturnPrecedingOrWhole(String s, String del) {
        int i = s.indexOf(del);
        return i == -1 ? s : s.substring(0, i);
    }

    @Nullable
    public static String splitonceReturnPrecedingOrNull(String s, String del) {
        int i = s.indexOf(del);
        return i == -1 ? null : s.substring(0, i);
    }

    @Nullable
    public static String splitonceReturnSucceedingOrWhole(String s, String del) {
        int i = s.indexOf(del);
        return i == -1 ? s : s.substring(i + del.length());
    }

    @Nullable
    public static String splitonceReturnSucceedingOrNull(String s, String del) {
        int i = s.indexOf(del);
        return i == -1 ? null : s.substring(i + del.length());
    }

    @Nullable
    public static String[] rsplitonceOrNull(String s, char del) {
        String[] stringArray;
        int i = s.lastIndexOf(del);
        if (i == -1) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = s.substring(0, i);
            stringArray = stringArray2;
            stringArray2[1] = s.substring(i + 1);
        }
        return stringArray;
    }

    @Nonnull
    public static String[] rsplitonce(String s, char del) {
        String[] stringArray;
        int i = s.lastIndexOf(del);
        if (i == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = s.substring(0, i);
            stringArray = stringArray3;
            stringArray3[1] = s.substring(i + 1);
        }
        return stringArray;
    }

    @Nullable
    public static String[] rsplitonceOrNull(String s, String del) {
        String[] stringArray;
        int i = s.lastIndexOf(del);
        if (i == -1) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = s.substring(0, i);
            stringArray = stringArray2;
            stringArray2[1] = s.substring(i + 1);
        }
        return stringArray;
    }

    @Nonnull
    public static String[] rsplitonce(String s, String del) {
        String[] stringArray;
        int i = s.lastIndexOf(del);
        if (i == -1) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = s;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = s.substring(0, i);
            stringArray = stringArray3;
            stringArray3[1] = s.substring(i + del.length());
        }
        return stringArray;
    }

    @Nonnull
    public static String rsplitonceReturnPrecedingOrWhole(String s, char del) {
        int i = s.lastIndexOf(del);
        return i == -1 ? s : s.substring(0, i);
    }

    @Nullable
    public static String rsplitonceReturnPrecedingOrNull(String s, char del) {
        int i = s.lastIndexOf(del);
        return i == -1 ? null : s.substring(0, i);
    }

    @Nullable
    public static String rsplitonceReturnSucceedingOrWhole(String s, char del) {
        int i = s.lastIndexOf(del);
        return i == -1 ? s : s.substring(i + 1);
    }

    @Nullable
    public static String rsplitonceReturnSucceedingOrNull(String s, char del) {
        int i = s.lastIndexOf(del);
        return i == -1 ? null : s.substring(i + 1);
    }

    @Nonnull
    public static String rsplitonceReturnPrecedingOrWhole(String s, String del) {
        int i = s.lastIndexOf(del);
        return i == -1 ? s : s.substring(0, i);
    }

    @Nullable
    public static String rsplitonceReturnPrecedingOrNull(String s, String del) {
        int i = s.lastIndexOf(del);
        return i == -1 ? null : s.substring(0, i);
    }

    @Nullable
    public static String rsplitonceReturnSucceedingOrWhole(String s, String del) {
        int i = s.lastIndexOf(del);
        return i == -1 ? s : s.substring(i + del.length());
    }

    @Nullable
    public static String rsplitonceReturnSucceedingOrNull(String s, String del) {
        int i = s.lastIndexOf(del);
        return i == -1 ? null : s.substring(i + del.length());
    }

    public static String[] splitOnceCamelCaseName(String camelCaseName) {
        int c = StringUtilities.indexOf((CharSequence)camelCaseName, Character::isUpperCase);
        if (c == -1) {
            return new String[]{camelCaseName};
        }
        return new String[]{camelCaseName.substring(0, c), camelCaseName.substring(c, camelCaseName.length())};
    }

    public static String[] explodeString(String string) {
        String[] a = new String[string.length()];
        int i = 0;
        while (i < a.length) {
            a[i] = new String(new char[]{string.charAt(i)});
            ++i;
        }
        return a;
    }

    public static int indexOf(CharSequence string, char v) {
        if (string instanceof String) {
            return ((String)string).indexOf(v);
        }
        if (string instanceof PrimitiveCollections.CharacterList) {
            return ((PrimitiveCollections.CharacterList)string).indexOfChar(v);
        }
        return StringUtilities.indexOf(string, (char c2) -> c2 == v);
    }

    public static int indexOf(CharSequence string, char v, int start) {
        if (start == 0) {
            return StringUtilities.indexOf(string, v);
        }
        if (string instanceof String) {
            return ((String)string).indexOf(v, start);
        }
        if (string instanceof PrimitiveCollections.CharacterList) {
            return ((PrimitiveCollections.CharacterList)string).indexOfChar(v, start);
        }
        return StringUtilities.indexOf(string, (char c2) -> c2 == v, start);
    }

    public static int indexOf(CharSequence string, char v, int start, int length) {
        if (length + start == string.length()) {
            return StringUtilities.indexOf(string, v, start);
        }
        if (string instanceof PrimitiveCollections.CharacterList) {
            return ((PrimitiveCollections.CharacterList)string).subListByLength(start, length).indexOfChar(v);
        }
        return StringUtilities.indexOf(string, (char c2) -> c2 == v, start, length);
    }

    public static int indexOf(CharSequence string, CharSequence v) {
        if (string instanceof String) {
            return ((String)string).indexOf(v.toString());
        }
        return string.toString().indexOf(v.toString());
    }

    public static int indexOf(CharSequence string, CharSequence v, int start) {
        if (start == 0) {
            return StringUtilities.indexOf(string, v);
        }
        if (string instanceof String) {
            return ((String)string).indexOf(v.toString(), start);
        }
        return string.toString().indexOf(v.toString(), start);
    }

    public static int indexOf(CharSequence string, String v, int start, int length) {
        if (length + start == string.length()) {
            return StringUtilities.indexOf(string, v, start);
        }
        return string.toString().substring(start, start + length).indexOf(v.toString());
    }

    public static int lastIndexOf(CharSequence string, char v) {
        if (string instanceof String) {
            return ((String)string).lastIndexOf(v);
        }
        if (string instanceof PrimitiveCollections.CharacterList) {
            return ((PrimitiveCollections.CharacterList)string).lastIndexOfChar(v);
        }
        return StringUtilities.lastIndexOf(string, (char c2) -> c2 == v);
    }

    public static int lastIndexOf(CharSequence string, char v, int start) {
        if (start == 0) {
            return StringUtilities.lastIndexOf(string, v);
        }
        if (string instanceof String) {
            return ((String)string).lastIndexOf(v, start);
        }
        if (string instanceof PrimitiveCollections.CharacterList) {
            return ((PrimitiveCollections.CharacterList)string).lastIndexOfChar(v, start);
        }
        return StringUtilities.lastIndexOf(string, (char c2) -> c2 == v, start);
    }

    public static int lastIndexOf(CharSequence string, CharSequence v) {
        if (string instanceof String) {
            return ((String)string).lastIndexOf(v.toString());
        }
        return string.toString().lastIndexOf(v.toString());
    }

    public static int lastIndexOf(CharSequence string, CharSequence v, int start) {
        if (start == 0) {
            return StringUtilities.lastIndexOf(string, v);
        }
        if (string instanceof String) {
            return ((String)string).lastIndexOf(v.toString(), start);
        }
        return string.toString().lastIndexOf(v.toString(), start);
    }

    public static int indexOf(CharSequence string, FunctionInterfaces.UnaryFunctionCharToBoolean charTarget) {
        return StringUtilities.indexOf(string, charTarget, 0, string.length());
    }

    public static int indexOf(CharSequence string, FunctionInterfaces.UnaryFunctionCharToBoolean charTarget, int start) {
        return StringUtilities.indexOf(string, charTarget, start, string.length() - start);
    }

    public static int indexOf(CharSequence string, FunctionInterfaces.UnaryFunctionCharToBoolean charTarget, int start, int length) {
        int e = start + length;
        int i = start;
        while (i < e) {
            if (charTarget.f(string.charAt(i))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOf(CharSequence string, FunctionInterfaces.UnaryFunctionCharToBoolean charTarget) {
        int n = StringUtilities.getLength(string);
        return StringUtilities.lastIndexOf(string, charTarget, n - 1, n);
    }

    public static int lastIndexOf(CharSequence string, FunctionInterfaces.UnaryFunctionCharToBoolean charTarget, int indexOfFirstCharacterToTest) {
        return StringUtilities.lastIndexOf(string, charTarget, indexOfFirstCharacterToTest, indexOfFirstCharacterToTest + 1);
    }

    public static int lastIndexOf(CharSequence string, FunctionInterfaces.UnaryFunctionCharToBoolean charTarget, int indexOfFirstCharacterToTest, int numberOfCharactersToTest) {
        int e = indexOfFirstCharacterToTest - numberOfCharactersToTest;
        int i = indexOfFirstCharacterToTest;
        while (i > e) {
            if (charTarget.f(string.charAt(i))) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @ThrowAwayValue
    public static PrimitiveCollections.IntegerList indexOfAllL(CharSequence string, char target) {
        PrimitiveCollections.IntegerArrayList indexes = new PrimitiveCollections.IntegerArrayList();
        int len = string.length();
        int i = 0;
        while (i < len) {
            if (string.charAt(i) == target) {
                indexes.addInt(i);
            }
            ++i;
        }
        return indexes;
    }

    @ThrowAwayValue
    public static PrimitiveCollections.IntegerList indexOfAllL(CharSequence string, String target) {
        PrimitiveCollections.IntegerArrayList indexes = new PrimitiveCollections.IntegerArrayList();
        int position = 0;
        while ((position = StringUtilities.indexOf(string, target, position + 1)) != -1) {
            indexes.addInt(position);
        }
        return indexes;
    }

    public static int[] indexOfAllA(CharSequence originalString, char target) {
        return StringUtilities.indexOfAllL(originalString, target).toIntArrayPossiblyLive();
    }

    public static int[] indexOfAllA(String originalString, String target) {
        return StringUtilities.indexOfAllL((CharSequence)originalString, target).toIntArrayPossiblyLive();
    }

    public static String concatList(Iterable<?> tokens) {
        StringBuilder buff = new StringBuilder();
        for (Object e : tokens) {
            if (StringUtilities.isTextthing(e)) {
                StringUtilities.appendTextthing(buff, e);
                continue;
            }
            buff.append(String.valueOf(e));
        }
        return buff.toString();
    }

    public static String concatArray(Object[] tokens) {
        StringBuilder buff = new StringBuilder();
        Object[] objectArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (StringUtilities.isTextthing(e)) {
                StringUtilities.appendTextthing(buff, e);
            } else {
                buff.append(String.valueOf(e));
            }
            ++n2;
        }
        return buff.toString();
    }

    public static String concatVarargs(Object ... tokens) {
        StringBuilder buff = new StringBuilder();
        Object[] objectArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            if (StringUtilities.isTextthing(e)) {
                StringUtilities.appendTextthing(buff, e);
            } else {
                buff.append(String.valueOf(e));
            }
            ++n2;
        }
        return buff.toString();
    }

    public static int concatLength(Iterable<Object> tokens) {
        int total = 0;
        for (Object e : tokens) {
            if (StringUtilities.isTextthing(e)) {
                total += StringUtilities.getLength(e);
                continue;
            }
            total += String.valueOf(e).length();
        }
        return total;
    }

    public static int concatLength(Object ... tokens) {
        int total = 0;
        Object[] objectArray = tokens;
        int n = tokens.length;
        int n2 = 0;
        while (n2 < n) {
            Object e = objectArray[n2];
            total = StringUtilities.isTextthing(e) ? (total += StringUtilities.getLength(e)) : (total += String.valueOf(e).length());
            ++n2;
        }
        return total;
    }

    @Nonnegative
    public static int getLinearIndexFromLineAndColumnIndex(@Nonnegative int line, @Nonnegative int col, String text) throws IndexOutOfBoundsException {
        return StringUtilities.getLinearIndexFromLineAndColumnIndex(line, col, text, '\n');
    }

    @Nonnegative
    public static int getLinearIndexFromLineAndColumnIndex(@Nonnegative int line, @Nonnegative int col, String text, char newline) throws IndexOutOfBoundsException {
        int nextLineStart;
        if (line < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = text.length();
        int lastLineStart = 0;
        int l = 0;
        while (l < line) {
            WidespreadTestingUtilities.asrt(lastLineStart <= n);
            if (lastLineStart == n) {
                throw new IndexOutOfBoundsException();
            }
            int p = text.indexOf(newline, lastLineStart);
            if (p == -1) {
                throw new IndexOutOfBoundsException();
            }
            lastLineStart = p + 1;
            ++l;
        }
        WidespreadTestingUtilities.asrt(lastLineStart >= 0);
        int position = lastLineStart + col;
        if (position > n) {
            throw new IndexOutOfBoundsException();
        }
        int p = text.indexOf(newline, lastLineStart);
        if (p != -1 && position >= (nextLineStart = p + 1)) {
            throw new IndexOutOfBoundsException();
        }
        return position;
    }

    @Nonnegative
    public static int[] getLineAndColumnIndexes(@Nonnegative int position, String text) throws IndexOutOfBoundsException {
        return StringUtilities.getLineAndColumnIndexes(position, text, '\n');
    }

    @Nonnegative
    public static int[] getLineAndColumnIndexes(@Nonnegative int position, String text, char newline) throws IndexOutOfBoundsException {
        int currentLineStart;
        if (position < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (position > text.length()) {
            throw new IndexOutOfBoundsException();
        }
        int line = 0;
        currentLineStart += (currentLineStart = text.indexOf(newline)) != -1 ? 1 : 0;
        int lastLineStart = 0;
        while (currentLineStart != -1) {
            if (currentLineStart < position) {
                lastLineStart = currentLineStart;
                currentLineStart += (currentLineStart = text.indexOf(newline, currentLineStart)) != -1 ? 1 : 0;
                ++line;
                continue;
            }
            if (currentLineStart != position) break;
            lastLineStart = currentLineStart;
            break;
        }
        int col = position - lastLineStart;
        return new int[]{++line, col};
    }

    @Nonnegative
    public static int getLineIndex(@Nonnegative int position, String text) throws IndexOutOfBoundsException {
        return StringUtilities.getLineAndColumnIndexes(position, text)[0];
    }

    @Nonnegative
    public static int getColumnIndex(@Nonnegative int position, String text) throws IndexOutOfBoundsException {
        return StringUtilities.getLineAndColumnIndexes(position, text)[1];
    }

    @Positive
    public static int getLineNumber(@Nonnegative int position, String text) throws IndexOutOfBoundsException {
        return StringUtilities.getLineIndex(position, text) + 1;
    }

    @Positive
    public static int getColumnNumber(@Nonnegative int position, String text) throws IndexOutOfBoundsException {
        return StringUtilities.getColumnIndex(position, text) + 1;
    }

    @Nonnegative
    public static int getLinearIndexFromLineAndColumnIndexUCS4(@Nonnegative int line, @Nonnegative int col, PrimitiveCollections.IntegerList text) throws IndexOutOfBoundsException {
        return StringUtilities.getLinearIndexFromLineAndColumnIndexUCS4(line, col, text, 10);
    }

    @Nonnegative
    public static int getLinearIndexFromLineAndColumnIndexUCS4(@Nonnegative int line, @Nonnegative int col, PrimitiveCollections.IntegerList text, int newline) throws IndexOutOfBoundsException {
        int nextLineStart;
        if (line < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (col < 0) {
            throw new IndexOutOfBoundsException();
        }
        int n = text.size();
        int lastLineStart = 0;
        int l = 0;
        while (l < line) {
            WidespreadTestingUtilities.asrt(lastLineStart <= n);
            if (lastLineStart == n) {
                throw new IndexOutOfBoundsException();
            }
            int p = text.indexOfInt(newline, lastLineStart);
            if (p == -1) {
                throw new IndexOutOfBoundsException();
            }
            lastLineStart = p + 1;
            ++l;
        }
        WidespreadTestingUtilities.asrt(lastLineStart >= 0);
        int position = lastLineStart + col;
        if (position > n) {
            throw new IndexOutOfBoundsException();
        }
        int p = text.indexOfInt(newline, lastLineStart);
        if (p != -1 && position >= (nextLineStart = p + 1)) {
            throw new IndexOutOfBoundsException();
        }
        return position;
    }

    @Nonnegative
    public static int[] getLineAndColumnIndexesUCS4(@Nonnegative int position, PrimitiveCollections.IntegerList text) throws IndexOutOfBoundsException {
        return StringUtilities.getLineAndColumnIndexesUCS4(position, text, 10);
    }

    @Nonnegative
    public static int[] getLineAndColumnIndexesUCS4(@Nonnegative int position, PrimitiveCollections.IntegerList text, int newline) throws IndexOutOfBoundsException {
        int currentLineStart;
        if (position < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (position > text.size()) {
            throw new IndexOutOfBoundsException();
        }
        int line = 0;
        currentLineStart += (currentLineStart = text.indexOfInt(newline)) != -1 ? 1 : 0;
        int lastLineStart = 0;
        while (currentLineStart != -1) {
            if (currentLineStart < position) {
                lastLineStart = currentLineStart;
                currentLineStart += (currentLineStart = text.indexOfInt(newline, currentLineStart)) != -1 ? 1 : 0;
                ++line;
                continue;
            }
            if (currentLineStart != position) break;
            lastLineStart = currentLineStart;
            break;
        }
        int col = position - lastLineStart;
        return new int[]{++line, col};
    }

    @Nonnegative
    public static int getLineIndexUCS4(@Nonnegative int position, PrimitiveCollections.IntegerList text) throws IndexOutOfBoundsException {
        return StringUtilities.getLineAndColumnIndexesUCS4(position, text)[0];
    }

    @Nonnegative
    public static int getColumnIndexUCS4(@Nonnegative int position, PrimitiveCollections.IntegerList text) throws IndexOutOfBoundsException {
        return StringUtilities.getLineAndColumnIndexesUCS4(position, text)[1];
    }

    @Positive
    public static int getLineNumberUCS4(@Nonnegative int position, PrimitiveCollections.IntegerList text) throws IndexOutOfBoundsException {
        return StringUtilities.getLineIndexUCS4(position, text) + 1;
    }

    @Positive
    public static int getColumnNumberUCS4(@Nonnegative int position, PrimitiveCollections.IntegerList text) throws IndexOutOfBoundsException {
        return StringUtilities.getColumnIndexUCS4(position, text) + 1;
    }

    public static int getCharCount(String text, char c) {
        int count = 0;
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int[] getCharCounts(String text) {
        int[] counts = new int[65536];
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            counts[c] = counts[c] + 1;
            ++i;
        }
        return counts;
    }

    public static int getLeadingCharCount(String text, char c) {
        char[] chars = text.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] != c) {
                return i;
            }
            ++i;
        }
        return chars.length;
    }

    public static boolean isUniform(String text) {
        if (text.length() == 0) {
            return true;
        }
        return StringUtilities.isUniform(text, text.charAt(0));
    }

    public static boolean isUniform(String text, char c) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            if (text.charAt(i) != c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUniform(String text, char[] alphabet) {
        int len = text.length();
        char curr = '\u0000';
        int i = 0;
        while (i < len) {
            block3: {
                curr = text.charAt(i);
                int e = 0;
                while (e < alphabet.length) {
                    if (curr != alphabet[e]) {
                        ++e;
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUniform(String text, CharSequence alphabet) {
        int alphabetLength = alphabet.length();
        int len = text.length();
        char curr = '\u0000';
        int i = 0;
        while (i < len) {
            block3: {
                curr = text.charAt(i);
                int e = 0;
                while (e < alphabetLength) {
                    if (curr != alphabet.charAt(e)) {
                        ++e;
                        continue;
                    }
                    break block3;
                }
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUniformWhitespace(String text) {
        int len = text.length();
        int i = 0;
        while (i < len) {
            if (!Character.isWhitespace(text.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isUniform(Object text, FunctionInterfaces.UnaryFunctionCharToBoolean characterPattern) {
        if (text == null) {
            throw new NullPointerException();
        }
        char[] ca = StringUtilities.textthingToPossiblyUnclonedCharArray(text);
        int len = ca.length;
        int i = 0;
        while (i < len) {
            if (!characterPattern.f(ca[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(CharSequence a, CharSequence b) {
        return a == b || a != null && a.equals(b);
    }

    public static boolean equals(CharSequence a, char[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length() != b.length) {
            return false;
        }
        int i = 0;
        while (i < b.length) {
            if (a.charAt(i) != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(char[] a, CharSequence b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length()) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(char[] a, char[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(CharSequence a, CharSequence b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length() != b.length()) {
            return false;
        }
        int i = 0;
        while (i < a.length()) {
            if (Character.toLowerCase(a.charAt(i)) != Character.toLowerCase(b.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(CharSequence a, char[] b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length() != b.length) {
            return false;
        }
        int i = 0;
        while (i < b.length) {
            if (Character.toLowerCase(a.charAt(i)) != Character.toLowerCase(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(char[] a, CharSequence b) {
        if (a == null && b == null) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length()) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (Character.toLowerCase(a[i]) != Character.toLowerCase(b.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equalsIgnoreCase(char[] a, char[] b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (Character.toLowerCase(a[i]) != Character.toLowerCase(b[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isCharactersEqualCaseInsensitively(char a, char b) {
        return a == b || Character.toUpperCase(a) == Character.toUpperCase(b) || Character.toLowerCase(a) == Character.toLowerCase(b);
    }

    public static boolean arrayMatchesCaseInsensitive(char[] a, int aOffset, char[] b, int bOffset, int length) throws IndexOutOfBoundsException {
        if (aOffset < 0 || aOffset > a.length) {
            aOffset = SmallIntegerMathUtilities.progmod(aOffset, a.length);
        }
        if (bOffset < 0 || bOffset > b.length) {
            bOffset = SmallIntegerMathUtilities.progmod(bOffset, b.length);
        }
        if (aOffset + length > a.length) {
            throw new IndexOutOfBoundsException();
        }
        if (bOffset + length > b.length) {
            throw new IndexOutOfBoundsException();
        }
        int i = 0;
        while (i < length) {
            if (!StringUtilities.isCharactersEqualCaseInsensitively(a[aOffset + i], b[bOffset + i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean startsWith(String longer, String shorter) {
        return longer.startsWith(shorter);
    }

    public static boolean endsWith(String longer, String shorter) {
        return longer.endsWith(shorter);
    }

    public static boolean startsWithCaseInsensitively(String longer, String shorter) {
        return StringUtilities.startsWith(longer.toLowerCase(), shorter.toLowerCase());
    }

    public static boolean endsWithCaseInsensitively(String longer, String shorter) {
        return StringUtilities.endsWith(longer.toLowerCase(), shorter.toLowerCase());
    }

    public static boolean eqCaseInsensitively(@Nullable String a, @Nullable String b) {
        return a == null ? b == null : b != null && a.equalsIgnoreCase(b);
    }

    public static boolean contains(String s, FunctionInterfaces.UnaryFunctionCharToBoolean test) {
        return StringUtilities.contains(s.toCharArray(), test);
    }

    public static boolean contains(char[] s, FunctionInterfaces.UnaryFunctionCharToBoolean test) {
        char[] cArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (test.f(c)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean contains(String s, FunctionInterfaces.UnaryFunctionCharToBoolean ... tests) {
        return StringUtilities.contains(s.toCharArray(), tests);
    }

    public static boolean contains(char[] s, FunctionInterfaces.UnaryFunctionCharToBoolean ... tests) {
        char[] cArray = s;
        int n = s.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            FunctionInterfaces.UnaryFunctionCharToBoolean[] unaryFunctionCharToBooleanArray = tests;
            int n3 = tests.length;
            int n4 = 0;
            while (n4 < n3) {
                FunctionInterfaces.UnaryFunctionCharToBoolean test = unaryFunctionCharToBooleanArray[n4];
                if (test.f(c)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public static boolean contains(String s, char c) {
        return s.indexOf(c) != -1;
    }

    public static boolean containsWhitespace(String s) {
        return StringUtilities.contains(s, CharacterPredicates.WHITESPACE_PATTERN);
    }

    public static int count(CharSequence s, FunctionInterfaces.UnaryFunctionCharToBoolean test) {
        int count = 0;
        int n = s.length();
        int i = 0;
        while (i < n) {
            if (test.f(s.charAt(i))) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static int count(CharSequence s, char c) {
        int count = 0;
        int n = s.length();
        int i = 0;
        while (i < n) {
            if (s.charAt(i) == c) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionCharToBoolean test, CharSequence s) {
        return StringUtilities.forAll(test, s, 0, s.length());
    }

    public static boolean forAll(char c, CharSequence s) {
        return StringUtilities.forAll(c, s, 0, s.length());
    }

    public static boolean forAll(FunctionInterfaces.UnaryFunctionCharToBoolean test, CharSequence s, int offset, int length) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (!test.f(s.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAll(char c, CharSequence s, int offset, int length) {
        int e = offset + length;
        int i = offset;
        while (i < e) {
            if (s.charAt(i) != c) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean forAny(FunctionInterfaces.UnaryFunctionCharToBoolean test, CharSequence s) {
        int n = s.length();
        int i = 0;
        while (i < n) {
            if (test.f(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean forAny(char c, CharSequence s) {
        int n = s.length();
        int i = 0;
        while (i < n) {
            if (s.charAt(i) == c) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean isAllWhitespace(CharSequence s) {
        return StringUtilities.forAll(CharacterPredicates.WHITESPACE_PATTERN, s);
    }

    public static boolean startsWithPrefixAndWhitespaceOrEOF(String mainString, String prefix) {
        return StringUtilities.startsWithPrefixAndWhitespace(mainString, prefix, true);
    }

    public static boolean startsWithPrefixAndWhitespaceNoEOF(String mainString, String prefix) {
        return StringUtilities.startsWithPrefixAndWhitespace(mainString, prefix, false);
    }

    public static boolean startsWithPrefixAndWhitespace(String mainString, String prefix, boolean onEof) {
        if (!mainString.startsWith(prefix)) {
            return false;
        }
        int n = prefix.length();
        if (mainString.length() == n) {
            return onEof;
        }
        return Character.isWhitespace(mainString.charAt(n));
    }

    public static String applyCaseMap(Object original, boolean[] caseMap) {
        if (caseMap.length != StringUtilities.getLength(original)) {
            throw new IllegalArgumentException("wrong lengths!");
        }
        char[] s = StringUtilities.textthingToNewCharArray(original);
        StringUtilities.applyCaseMap(s, caseMap);
        return new String(s);
    }

    public static void applyCaseMap(char[] s, boolean[] caseMap) {
        if (caseMap.length != s.length) {
            throw new IllegalArgumentException("wrong lengths!");
        }
        int i = 0;
        while (i < s.length) {
            s[i] = caseMap[i] ? Character.toUpperCase(s[i]) : Character.toLowerCase(s[i]);
            ++i;
        }
    }

    public static String alltrimMultiple(String str, char[] targets) {
        char[] oldc = str.toCharArray();
        char[] newc = new char[oldc.length];
        int newcLen = 0;
        int i = 0;
        int e = 0;
        char c = '\u0000';
        i = 0;
        while (i < oldc.length) {
            c = oldc[i];
            e = 0;
            e = 0;
            while (e < targets.length) {
                if (c == targets[e]) break;
                ++e;
            }
            if (e == targets.length) {
                newc[newcLen] = c;
                ++newcLen;
            }
            ++i;
        }
        return new String(newc, 0, newcLen);
    }

    public static String alltrim(String str, char target) {
        char[] oldc = str.toCharArray();
        char[] newc = new char[oldc.length];
        int newcLen = 0;
        int i = 0;
        char c = '\u0000';
        i = 0;
        while (i < oldc.length) {
            c = oldc[i];
            if (c != target) {
                newc[newcLen] = c;
                ++newcLen;
            }
            ++i;
        }
        return new String(newc, 0, newcLen);
    }

    public static String ltrim(String s, char c) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        int firstKeeper = len;
        int i = 0;
        while (i < len && firstKeeper == len) {
            if (c != s.charAt(i)) {
                firstKeeper = i;
            }
            ++i;
        }
        return s.substring(firstKeeper);
    }

    public static String ltrim(String s, FunctionInterfaces.UnaryFunctionCharToBoolean pattern) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        int firstKeeper = len;
        int i = 0;
        while (i < len && firstKeeper == len) {
            if (!pattern.f(s.charAt(i))) {
                firstKeeper = i;
            }
            ++i;
        }
        return s.substring(firstKeeper);
    }

    public static String rtrim(String s, char c) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        int lastKeeper = -1;
        int i = len - 1;
        while (i >= 0 && lastKeeper == -1) {
            if (c != s.charAt(i)) {
                lastKeeper = i;
            }
            --i;
        }
        return s.substring(0, lastKeeper + 1);
    }

    public static String rtrim(String s, FunctionInterfaces.UnaryFunctionCharToBoolean pattern) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        if (len == 0) {
            return s;
        }
        int lastKeeper = -1;
        int i = len - 1;
        while (i >= 0 && lastKeeper == -1) {
            if (!pattern.f(s.charAt(i))) {
                lastKeeper = i;
            }
            --i;
        }
        return s.substring(0, lastKeeper + 1);
    }

    public static String trim(String s, char c) {
        return StringUtilities.ltrim(StringUtilities.rtrim(s, c), c);
    }

    public static String trim(String s, FunctionInterfaces.UnaryFunctionCharToBoolean pattern) {
        return StringUtilities.ltrim(StringUtilities.rtrim(s, pattern), pattern);
    }

    public static String ltrim(String s) {
        return StringUtilities.ltrim(s, CharacterPredicates.WHITESPACE_PATTERN);
    }

    public static String rtrim(String s) {
        return StringUtilities.rtrim(s, CharacterPredicates.WHITESPACE_PATTERN);
    }

    public static String trim(String s) {
        return StringUtilities.trim(s, CharacterPredicates.WHITESPACE_PATTERN);
    }

    public static String ltrimstr(String str, String trimmand) {
        if (str.startsWith(trimmand)) {
            return str.substring(trimmand.length());
        }
        return str;
    }

    public static String rtrimstr(String str, String trimmand) {
        if (str.endsWith(trimmand)) {
            return str.substring(0, str.length() - trimmand.length());
        }
        return str;
    }

    public static String ltrimstrCaseInsensitive(String str, String trimmand) {
        if (StringUtilities.startsWithCaseInsensitively(str, trimmand)) {
            return str.substring(trimmand.length());
        }
        return str;
    }

    public static String rtrimstrCaseInsensitive(String str, String trimmand) {
        if (StringUtilities.endsWithCaseInsensitively(str, trimmand)) {
            return str.substring(0, str.length() - trimmand.length());
        }
        return str;
    }

    @Nullable
    public static String ltrimstrOrNull(String str, String trimmand) {
        if (str.startsWith(trimmand)) {
            return str.substring(trimmand.length());
        }
        return null;
    }

    @Nullable
    public static String rtrimstrOrNull(String str, String trimmand) {
        if (str.endsWith(trimmand)) {
            return str.substring(0, str.length() - trimmand.length());
        }
        return null;
    }

    @Nullable
    public static String ltrimstrOrNullCaseInsensitive(String str, String trimmand) {
        if (StringUtilities.startsWithCaseInsensitively(str, trimmand)) {
            return str.substring(trimmand.length());
        }
        return null;
    }

    @Nullable
    public static String rtrimstrOrNullCaseInsensitive(String str, String trimmand) {
        if (StringUtilities.endsWithCaseInsensitively(str, trimmand)) {
            return str.substring(0, str.length() - trimmand.length());
        }
        return null;
    }

    @Nullable
    public static String ltrimstrOrThrow(String str, String trimmand) {
        if (str.startsWith(trimmand)) {
            return str.substring(trimmand.length());
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public static String rtrimstrOrThrow(String str, String trimmand) {
        if (str.endsWith(trimmand)) {
            return str.substring(0, str.length() - trimmand.length());
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public static String ltrimstrOrThrowCaseInsensitive(String str, String trimmand) {
        if (StringUtilities.startsWithCaseInsensitively(str, trimmand)) {
            return str.substring(trimmand.length());
        }
        throw new IllegalArgumentException();
    }

    @Nullable
    public static String rtrimstrOrThrowCaseInsensitive(String str, String trimmand) {
        if (StringUtilities.endsWithCaseInsensitively(str, trimmand)) {
            return str.substring(0, str.length() - trimmand.length());
        }
        throw new IllegalArgumentException();
    }

    public static String ltrimstrRP(String str, String trimmand) throws NoStringToRemoveReturnPath {
        if (str.startsWith(trimmand)) {
            return str.substring(trimmand.length());
        }
        throw NoStringToRemoveReturnPath.I;
    }

    public static String rtrimstrRP(String str, String trimmand) throws NoStringToRemoveReturnPath {
        if (str.endsWith(trimmand)) {
            return str.substring(0, str.length() - trimmand.length());
        }
        throw NoStringToRemoveReturnPath.I;
    }

    public static String lmatchingStr(String str, FunctionInterfaces.UnaryFunctionCharToBoolean charPattern) {
        int length;
        int lengthOfMatching = length = str.length();
        int i = 0;
        while (i < length) {
            if (!charPattern.f(str.charAt(i))) {
                lengthOfMatching = i;
                break;
            }
            ++i;
        }
        return str.substring(0, lengthOfMatching);
    }

    public static String rmatchingStr(String str, FunctionInterfaces.UnaryFunctionCharToBoolean charPattern) {
        int length;
        int lengthOfMatching = length = str.length();
        int i = length;
        while (i > 0) {
            if (!charPattern.f(str.charAt(i - 1))) {
                lengthOfMatching = length - i;
                break;
            }
            --i;
        }
        return str.substring(length - lengthOfMatching);
    }

    public static String lmatchingWhitespace(String str) {
        return StringUtilities.lmatchingStr(str, CharacterPredicates.WHITESPACE_PATTERN);
    }

    public static String rmatchingWhitespace(String str) {
        return StringUtilities.rmatchingStr(str, CharacterPredicates.WHITESPACE_PATTERN);
    }

    public static String capitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.length() == 1) {
            return String.valueOf(Character.toUpperCase(s.charAt(0)));
        }
        return String.valueOf(Character.toUpperCase(s.charAt(0))) + s.substring(1);
    }

    public static String decapitalize(String s) {
        if (s == null || s.isEmpty()) {
            return s;
        }
        if (s.length() == 1) {
            return String.valueOf(Character.toLowerCase(s.charAt(0)));
        }
        return String.valueOf(Character.toLowerCase(s.charAt(0))) + s.substring(1);
    }

    public static void appendMultiple(StringBuilder out, char c, int count) {
        int i = 0;
        while (i < count) {
            out.append(c);
            ++i;
        }
    }

    public static String mulneg(char c, @Signed int count) {
        if (count <= 0) {
            return "";
        }
        char[] a = new char[count];
        int i = 0;
        while (i < count) {
            a[i] = c;
            ++i;
        }
        return new String(a);
    }

    public static String mulneg(String s, @Signed int count) {
        if (count <= 0) {
            return "";
        }
        char[] c = s.toCharArray();
        char[] a = new char[c.length * count];
        int i = 0;
        while (i < count) {
            System.arraycopy(c, 0, a, i * c.length, c.length);
            ++i;
        }
        return new String(a);
    }

    public static String mulnn(char c, @Nonnegative int count) {
        if (count < 0) {
            throw new AssertionError((Object)String.valueOf(count));
        }
        if (count == 0) {
            return "";
        }
        char[] a = new char[count];
        int i = 0;
        while (i < count) {
            a[i] = c;
            ++i;
        }
        return new String(a);
    }

    public static String mulnn(String s, @Nonnegative int count) {
        if (count < 0) {
            throw new AssertionError((Object)String.valueOf(count));
        }
        if (count == 0) {
            return "";
        }
        char[] c = s.toCharArray();
        char[] a = new char[c.length * count];
        int i = 0;
        while (i < count) {
            System.arraycopy(c, 0, a, i * c.length, c.length);
            ++i;
        }
        return new String(a);
    }

    public static int getMaxLength(CharSequence ... strings) {
        int m = 0;
        CharSequence[] charSequenceArray = strings;
        int n = strings.length;
        int n2 = 0;
        while (n2 < n) {
            CharSequence x = charSequenceArray[n2];
            if (x.length() > m) {
                m = x.length();
            }
            ++n2;
        }
        return m;
    }

    public static int getMaxLength(Iterable<CharSequence> strings) {
        int m = 0;
        for (CharSequence x : strings) {
            if (x.length() <= m) continue;
            m = x.length();
        }
        return m;
    }

    public static int getMaxEnumNameLength(Class<? extends Enum> enumClass) {
        int m = 0;
        Enum[] enumArray = enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            if (e.name().length() > m) {
                m = e.name().length();
            }
            ++n2;
        }
        return m;
    }

    public static int getMaxEnumTostringLength(Class<? extends Enum> enumClass) {
        int m = 0;
        Enum[] enumArray = enumClass.getEnumConstants();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            Enum e = enumArray[n2];
            if (e.toString().length() > m) {
                m = e.toString().length();
            }
            ++n2;
        }
        return m;
    }

    public static String concatLines(String ... lines) {
        return StringUtilities.joinStrings((Object[])lines, '\n');
    }

    public static String concatLines(Iterable<String> lines) {
        return StringUtilities.joinStrings(lines, '\n');
    }

    @PossiblySnapshotPossiblyLiveValue
    public static char[] universalNewlinesCharArrayOPC(char[] oldc) {
        char c;
        int oldLength = oldc.length;
        boolean clean = true;
        char[] cArray = oldc;
        int n = oldc.length;
        int n2 = 0;
        while (n2 < n) {
            c = cArray[n2];
            if (c == '\r') {
                clean = false;
                break;
            }
            ++n2;
        }
        if (clean) {
            return oldc;
        }
        char[] newc = new char[oldLength];
        c = '\u0000';
        int e = 0;
        int i = 0;
        while (i < oldc.length) {
            c = oldc[i];
            if (c == '\r') {
                if (i < oldc.length - 1 && oldc[i + 1] == '\n') {
                    ++i;
                }
                newc[e] = 10;
                ++e;
            } else {
                newc[e] = c;
                ++e;
            }
            ++i;
        }
        int newLength = e;
        return newLength == oldLength ? newc : ArrayUtilities.slice(newc, 0, newLength);
    }

    @PossiblySnapshotPossiblyLiveValue
    public static String universalNewlines(String original) {
        if (original.indexOf(13) == -1) {
            return original;
        }
        char[] ca0 = original.toCharArray();
        char[] ca1 = StringUtilities.universalNewlinesCharArrayOPC(ca0);
        if (ca1 == ca0) {
            return original;
        }
        return new String(ca1);
    }

    public static boolean isTextthing(Object thing) {
        return thing == null || thing instanceof CharSequence || thing instanceof char[] || thing instanceof Character;
    }

    public static void checkValidTextthing(Object thing) throws ClassCastException {
        if (!StringUtilities.isTextthing(thing)) {
            throw new ClassCastException(ObjectUtilities.getClassNameNT(thing));
        }
    }

    public static Object normalizeTextthing(Object textthing) {
        return textthing;
    }

    public static char[] textthingToCharArray(Object textthing, boolean duplicate) {
        if ((textthing = StringUtilities.normalizeTextthing(textthing)) instanceof String) {
            return ((String)textthing).toCharArray();
        }
        if (textthing instanceof char[]) {
            return duplicate ? (char[])((char[])textthing).clone() : (char[])textthing;
        }
        if (textthing instanceof StringBuilder) {
            char[] dest = new char[((StringBuilder)textthing).length()];
            ((StringBuilder)textthing).getChars(0, ((StringBuilder)textthing).length(), dest, 0);
            return dest;
        }
        if (textthing instanceof StringBuffer) {
            char[] dest = new char[((StringBuffer)textthing).length()];
            ((StringBuffer)textthing).getChars(0, ((StringBuffer)textthing).length(), dest, 0);
            return dest;
        }
        if (textthing instanceof CharArrayableCharSequence) {
            return ((CharArrayableCharSequence)textthing).toCharArray();
        }
        if (textthing instanceof CharSequence) {
            return textthing.toString().toCharArray();
        }
        if (textthing instanceof Character) {
            char[] dest = new char[]{((Character)textthing).charValue()};
            return dest;
        }
        if (textthing == null) {
            return null;
        }
        throw new ClassCastException(ObjectUtilities.getClassNameNT(textthing));
    }

    public static char[] textthingToPossiblyUnclonedCharArray(Object textthing) {
        return StringUtilities.textthingToCharArray(textthing, false);
    }

    public static char[] textthingToNewCharArray(Object textthing) {
        return StringUtilities.textthingToCharArray(textthing, true);
    }

    @Nullable
    public static String textthingToString(@Nullable Object textthing) {
        if ((textthing = StringUtilities.normalizeTextthing(textthing)) == null) {
            return null;
        }
        if (textthing instanceof String) {
            return (String)textthing;
        }
        if (textthing instanceof CharSequence) {
            return textthing.toString();
        }
        if (textthing instanceof Character) {
            return String.valueOf(textthing);
        }
        if (textthing instanceof char[]) {
            return String.valueOf((char[])textthing);
        }
        throw new ClassCastException(ObjectUtilities.getClassNameNT(textthing));
    }

    @Nullable
    public static CharSequence textthingToCharSequence(@Nullable Object textthing) {
        if ((textthing = StringUtilities.normalizeTextthing(textthing)) == null) {
            return null;
        }
        if (textthing instanceof CharSequence) {
            return (CharSequence)textthing;
        }
        if (textthing instanceof Character) {
            return String.valueOf(textthing);
        }
        if (textthing instanceof char[]) {
            return String.valueOf((char[])textthing);
        }
        throw new ClassCastException(ObjectUtilities.getClassNameNT(textthing));
    }

    public static int getLength(@Nonnull Object textthing) {
        if ((textthing = StringUtilities.normalizeTextthing(textthing)) == null) {
            throw new NullPointerException();
        }
        if (textthing instanceof CharSequence) {
            return ((CharSequence)textthing).length();
        }
        if (textthing instanceof char[]) {
            return ((char[])textthing).length;
        }
        if (textthing instanceof Character) {
            return 1;
        }
        throw new ClassCastException(ObjectUtilities.getClassNameNT(textthing));
    }

    public static char getSingleChar(Object textthing) throws IllegalArgumentException {
        if ((textthing = StringUtilities.normalizeTextthing(textthing)) instanceof CharSequence) {
            if (((CharSequence)textthing).length() != 1) {
                throw new IllegalArgumentException("length != 1! 0_0 :   " + StringUtilities.repr(textthing));
            }
            return ((CharSequence)textthing).charAt(0);
        }
        if (textthing instanceof char[]) {
            if (((char[])textthing).length != 1) {
                throw new IllegalArgumentException("length != 1! 0_0 :   " + StringUtilities.repr(textthing));
            }
            return ((char[])textthing)[0];
        }
        if (textthing instanceof Character) {
            return ((Character)textthing).charValue();
        }
        if (textthing == null) {
            throw new NullPointerException();
        }
        throw new ClassCastException(ObjectUtilities.getClassNameNT(textthing));
    }

    public static Character getSingleCharacter(Object textthing) throws IllegalArgumentException {
        if ((textthing = StringUtilities.normalizeTextthing(textthing)) instanceof CharSequence) {
            if (((CharSequence)textthing).length() != 1) {
                return null;
            }
            return Character.valueOf(((CharSequence)textthing).charAt(0));
        }
        if (textthing instanceof char[]) {
            if (((CharSequence)textthing).length() != 1) {
                return null;
            }
            return Character.valueOf(((char[])textthing)[0]);
        }
        if (textthing instanceof Character) {
            return (Character)textthing;
        }
        if (textthing == null) {
            return null;
        }
        throw new ClassCastException(ObjectUtilities.getClassNameNT(textthing));
    }

    public static char charAt(Object textthing, int index) throws IndexOutOfBoundsException {
        if ((textthing = StringUtilities.normalizeTextthing(textthing)) instanceof CharSequence) {
            return ((CharSequence)textthing).charAt(index);
        }
        if (textthing instanceof char[]) {
            return ((char[])textthing)[index];
        }
        if (textthing instanceof Character) {
            if (index < 0) {
                throw new IndexOutOfBoundsException("negative index! :p  (charAt)");
            }
            if (index > 0) {
                throw new IndexOutOfBoundsException("too-large index! :p  (charAt)");
            }
            return ((Character)textthing).charValue();
        }
        if (textthing == null) {
            throw new NullPointerException();
        }
        throw new ClassCastException(ObjectUtilities.getClassNameNT(textthing));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void appendTextthing(Object recipient, Object thingToAppend) {
        recipient = StringUtilities.normalizeTextthing(recipient);
        thingToAppend = StringUtilities.normalizeTextthing(thingToAppend);
        if (recipient == null) {
            throw new NullPointerException();
        }
        if (thingToAppend == null) {
            thingToAppend = "null";
        }
        if (recipient instanceof StringBuilder) {
            if (thingToAppend instanceof CharSequence) {
                ((StringBuilder)recipient).append((CharSequence)thingToAppend);
                return;
            } else if (thingToAppend instanceof char[]) {
                ((StringBuilder)recipient).append((char[])thingToAppend);
                return;
            } else {
                if (!(thingToAppend instanceof Character)) throw new ClassCastException(ObjectUtilities.getClassNameNT(thingToAppend));
                ((StringBuilder)recipient).append(((Character)thingToAppend).charValue());
            }
            return;
        }
        if (recipient instanceof StringBuffer) {
            if (thingToAppend instanceof CharSequence) {
                ((StringBuffer)recipient).append((CharSequence)thingToAppend);
                return;
            } else if (thingToAppend instanceof char[]) {
                ((StringBuffer)recipient).append((char[])thingToAppend);
                return;
            } else {
                if (!(thingToAppend instanceof Character)) throw new ClassCastException(ObjectUtilities.getClassNameNT(thingToAppend));
                ((StringBuffer)recipient).append(((Character)thingToAppend).charValue());
            }
            return;
        }
        if (!(recipient instanceof Appendable)) throw new ClassCastException(ObjectUtilities.getClassNameNT(recipient));
        try {
            if (thingToAppend instanceof CharSequence) {
                ((Appendable)recipient).append((CharSequence)thingToAppend);
                return;
            } else if (thingToAppend instanceof char[]) {
                ((Appendable)recipient).append(new String((char[])thingToAppend));
                return;
            } else {
                if (!(thingToAppend instanceof Character)) throw new ClassCastException(ObjectUtilities.getClassNameNT(thingToAppend));
                ((Appendable)recipient).append(((Character)thingToAppend).charValue());
            }
            return;
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static byte[] textthingEncode(Object textthing, Charset encoding) {
        return StringUtilities.textthingToString(textthing).getBytes(encoding);
    }

    public static byte[] textthingEncode(Object textthing, String encoding) {
        return StringUtilities.textthingEncode(textthing, Charset.forName(encoding));
    }

    public static byte[] textthingEncode(Object textthing) {
        return StringUtilities.textthingEncode(textthing, Charset.defaultCharset());
    }

    @PossiblySnapshotPossiblyLiveValue
    public static Object universalNewlinesTextthings(Object original) {
        return StringUtilities.universalNewlinesCharArrayOPC(StringUtilities.textthingToCharArray(original, false));
    }

    public static ByteBuffer encodeTextToByteBuffer(CharSequence text, Charset encoding, CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput) throws CharacterCodingException {
        CharsetEncoder encoder = encoding.newEncoder();
        encoder.onUnmappableCharacter(onUnmappableCharacter);
        encoder.onMalformedInput(onMalformedInput);
        return encoder.encode(text instanceof CharBuffer ? (CharBuffer)text : CharBuffer.wrap(text));
    }

    public static byte[] encodeTextToByteArray(CharSequence text, Charset encoding, CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput) throws CharacterCodingException {
        return NIOBufferUtilities.getArray(StringUtilities.encodeTextToByteBuffer(text, encoding, onUnmappableCharacter, onMalformedInput));
    }

    public static byte[] encodeTextToByteArrayReporting(CharSequence s, Charset encoding) throws CharacterCodingException {
        return StringUtilities.encodeTextToByteArray(s, encoding, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
    }

    public static byte[] encodeTextToByteArrayReportingUnchecked(CharSequence s, Charset encoding) throws RuntimeException {
        try {
            return StringUtilities.encodeTextToByteArray(s, encoding, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
        }
        catch (CharacterCodingException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static CharSequence decodeTextToCharSequence(byte[] bytes, int offset, int length, Charset encoding, CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput) throws CharacterCodingException {
        CharsetDecoder decoder = encoding.newDecoder();
        decoder.onUnmappableCharacter(onUnmappableCharacter);
        decoder.onMalformedInput(onMalformedInput);
        return decoder.decode(ByteBuffer.wrap(bytes, offset, length));
    }

    public static CharSequence decodeTextToCharSequence(byte[] bytes, Charset encoding, CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput) throws CharacterCodingException {
        return StringUtilities.decodeTextToCharSequence(bytes, 0, bytes.length, encoding, onUnmappableCharacter, onMalformedInput);
    }

    public static CharSequence decodeTextToCharSequenceReporting(byte[] bytes, int offset, int length, Charset encoding) throws CharacterCodingException {
        return StringUtilities.decodeTextToCharSequence(bytes, offset, length, encoding, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
    }

    public static CharSequence decodeTextToCharSequenceReporting(byte[] bytes, Charset encoding) throws CharacterCodingException {
        return StringUtilities.decodeTextToCharSequence(bytes, encoding, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
    }

    public static String decodeTextToString(byte[] bytes, int offset, int length, Charset encoding, CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput) throws CharacterCodingException {
        return StringUtilities.decodeTextToCharSequence(bytes, offset, length, encoding, onUnmappableCharacter, onMalformedInput).toString();
    }

    public static String decodeTextToStringReporting(byte[] bytes, int offset, int length, Charset encoding) throws CharacterCodingException {
        return StringUtilities.decodeTextToString(bytes, offset, length, encoding, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
    }

    public static String decodeTextToStringReplacing(byte[] bytes, int offset, int length, Charset encoding) {
        try {
            return StringUtilities.decodeTextToString(bytes, offset, length, encoding, CodingErrorAction.REPLACE, CodingErrorAction.REPLACE);
        }
        catch (CharacterCodingException exc) {
            throw new ImpossibleException(exc);
        }
    }

    public static String decodeTextToString(byte[] bytes, Charset encoding, CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput) throws CharacterCodingException {
        return StringUtilities.decodeTextToString(bytes, 0, bytes.length, encoding, onUnmappableCharacter, onMalformedInput);
    }

    public static String decodeTextToStringReporting(byte[] bytes, Charset encoding) throws CharacterCodingException {
        return StringUtilities.decodeTextToString(bytes, encoding, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
    }

    public static String decodeTextToStringReportingUnchecked(byte[] bytes, Charset encoding) throws RuntimeException {
        try {
            return StringUtilities.decodeTextToStringReporting(bytes, encoding);
        }
        catch (CharacterCodingException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static String decodeTextToStringReplacing(byte[] bytes, Charset encoding) throws RuntimeException {
        try {
            return StringUtilities.decodeTextToString(bytes, encoding, CodingErrorAction.REPLACE, CodingErrorAction.REPLACE);
        }
        catch (CharacterCodingException exc) {
            throw new ImpossibleException(exc);
        }
    }

    public static String decodeTextToString(Slice<byte[]> bytes, Charset encoding, CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput) throws CharacterCodingException {
        return StringUtilities.decodeTextToString(bytes.getUnderlying(), bytes.getOffset(), bytes.getLength(), encoding, onUnmappableCharacter, onMalformedInput);
    }

    public static String decodeTextToStringReporting(Slice<byte[]> bytes, Charset encoding) throws CharacterCodingException {
        return StringUtilities.decodeTextToString(bytes, encoding, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
    }

    public static String decodeTextToStringReportingUnchecked(Slice<byte[]> bytes, Charset encoding) throws RuntimeException {
        try {
            return StringUtilities.decodeTextToStringReporting(bytes, encoding);
        }
        catch (CharacterCodingException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static String decodeTextToStringReplacing(Slice<byte[]> bytes, Charset encoding) throws RuntimeException {
        try {
            return StringUtilities.decodeTextToString(bytes, encoding, CodingErrorAction.REPLACE, CodingErrorAction.REPLACE);
        }
        catch (CharacterCodingException exc) {
            throw new ImpossibleException(exc);
        }
    }

    public static String decodeTextToString(PrimitiveCollections.ByteList bytes, Charset encoding, CodingErrorAction onUnmappableCharacter, CodingErrorAction onMalformedInput) throws CharacterCodingException {
        return StringUtilities.decodeTextToString(bytes.toByteArray(), encoding, onUnmappableCharacter, onMalformedInput);
    }

    public static String decodeTextToStringReporting(PrimitiveCollections.ByteList bytes, Charset encoding) throws CharacterCodingException {
        return StringUtilities.decodeTextToString(bytes, encoding, CodingErrorAction.REPORT, CodingErrorAction.REPORT);
    }

    public static String decodeTextToStringReportingUnchecked(PrimitiveCollections.ByteList bytes, Charset encoding) throws RuntimeException {
        try {
            return StringUtilities.decodeTextToStringReporting(bytes, encoding);
        }
        catch (CharacterCodingException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static String decodeTextToStringReplacing(PrimitiveCollections.ByteList bytes, Charset encoding) throws RuntimeException {
        try {
            return StringUtilities.decodeTextToString(bytes, encoding, CodingErrorAction.REPLACE, CodingErrorAction.REPLACE);
        }
        catch (CharacterCodingException exc) {
            throw new ImpossibleException(exc);
        }
    }

    public static Writer encodingReporting(OutputStream in, Charset encoding) {
        return new OutputStreamWriter(in, encoding.newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));
    }

    public static Reader decodingReporting(InputStream in, Charset encoding) {
        return new InputStreamReader(in, encoding.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT));
    }

    @ActuallyUnsigned
    public static long parseBasicNumber(char[] data, int offset, int length, Cursor cursor, int radix) {
        long value = 0L;
        int digit = 0;
        int curpos = 0;
        long max = Unsigned.divideU64(-1L, radix);
        while ((curpos = cursor.getCursor()) < length) {
            digit = Character.digit(data[offset + curpos], radix);
            if (digit == -1) {
                return value;
            }
            value = Unsigned.greaterThanU64(value, max) ? -1L : (Unsigned.greaterThanU64(value *= (long)radix, -1L - (long)digit) ? -1L : (value += (long)digit));
            cursor.setCursor(curpos + 1);
        }
        return value;
    }

    @ActuallyUnsigned
    public static long parseBasicNumber(char[] data, int offset, int length, int radix) {
        long value = 0L;
        int digit = 0;
        int curpos = offset;
        long max = Unsigned.divideU64(-1L, radix);
        while (curpos < length + offset) {
            digit = Character.digit(data[curpos], radix);
            if (digit == -1) {
                return value;
            }
            value = Unsigned.greaterThanU64(value, max) ? -1L : (Unsigned.greaterThanU64(value *= (long)radix, -1L - (long)digit) ? -1L : (value += (long)digit));
            ++curpos;
        }
        return value;
    }

    public static double parseBasicDecimalPart(char[] data, int offset, int length, Cursor cursor, int radix) {
        double value = 0.0;
        int digit = 0;
        int curpos = 0;
        int startPos = cursor.getCursor();
        while ((curpos = cursor.getCursor()) < length) {
            digit = Character.digit(data[offset + curpos], radix);
            if (digit == -1) {
                return value;
            }
            value += (double)digit / Math.pow(radix, curpos - startPos + 1);
            cursor.setCursor(curpos + 1);
        }
        return value;
    }

    public static Integer parseIntegerLeniently(String data, int radix, Integer defaultValue) {
        boolean negative;
        if (data == null || data.length() == 0) {
            return defaultValue;
        }
        if (radix < 2) {
            radix = 2;
        } else if (radix > 36) {
            radix = 36;
        }
        boolean bl = negative = data.charAt(0) == '-';
        if (negative && data.length() == 1) {
            return defaultValue;
        }
        int value = 0;
        int digit = 0;
        int i = negative ? 1 : 0;
        while (i < data.length()) {
            digit = Character.digit(data.charAt(i), radix);
            if (digit == -1) {
                if (i != (negative ? 1 : 0)) break;
                return defaultValue;
            }
            if (!negative) {
                if (value > Integer.MAX_VALUE / radix) {
                    return Integer.MAX_VALUE;
                }
                if ((value *= radix) > Integer.MAX_VALUE - digit) {
                    return Integer.MAX_VALUE;
                }
                value += digit;
            } else {
                if (value < Integer.MIN_VALUE / radix) {
                    return Integer.MIN_VALUE;
                }
                if ((value *= radix) < Integer.MIN_VALUE + digit) {
                    return Integer.MIN_VALUE;
                }
                value -= digit;
            }
            ++i;
        }
        return value;
    }

    public static Long parseLongLeniently(String data, int radix, Long defaultValue) {
        boolean negative;
        if (data == null || data.length() == 0) {
            return defaultValue;
        }
        if (radix < 2) {
            radix = 2;
        } else if (radix > 36) {
            radix = 36;
        }
        boolean bl = negative = data.charAt(0) == '-';
        if (negative && data.length() == 1) {
            return defaultValue;
        }
        long value = 0L;
        int digit = 0;
        int i = negative ? 1 : 0;
        while (i < data.length()) {
            digit = Character.digit(data.charAt(i), radix);
            if (digit == -1) {
                if (i != (negative ? 1 : 0)) break;
                return defaultValue;
            }
            if (!negative) {
                if (value > Long.MAX_VALUE / (long)radix) {
                    return Long.MAX_VALUE;
                }
                if ((value *= (long)radix) > Long.MAX_VALUE - (long)digit) {
                    return Long.MAX_VALUE;
                }
                value += (long)digit;
            } else {
                if (value < Long.MIN_VALUE / (long)radix) {
                    return Long.MIN_VALUE;
                }
                if ((value *= (long)radix) < Long.MIN_VALUE + (long)digit) {
                    return Long.MIN_VALUE;
                }
                value -= (long)digit;
            }
            ++i;
        }
        return value;
    }

    public static int parseIntegerLeniently(String data, int radix) {
        return StringUtilities.parseIntegerLeniently(data, radix, 0);
    }

    public static int parseIntegerLeniently(String data) {
        return StringUtilities.parseIntegerLeniently(data, 10, 0);
    }

    public static long parseLongLeniently(String data, int radix) {
        return StringUtilities.parseLongLeniently(data, radix, 0L);
    }

    public static long parseLongLeniently(String data) {
        return StringUtilities.parseLongLeniently(data, 10, 0L);
    }

    public static Boolean parseBooleanLeniently(String data, Boolean def) {
        if (data == null || data.length() == 0) {
            return def;
        }
        if (data.equalsIgnoreCase("true") || data.equalsIgnoreCase("t") || data.equalsIgnoreCase("yes") || data.equalsIgnoreCase("y") || data.equalsIgnoreCase("on") || data.equalsIgnoreCase("1")) {
            return true;
        }
        if (data.equalsIgnoreCase("false") || data.equalsIgnoreCase("f") || data.equalsIgnoreCase("no") || data.equalsIgnoreCase("n") || data.equalsIgnoreCase("off") || data.equalsIgnoreCase("0")) {
            return false;
        }
        return def;
    }

    public static Boolean parseBooleanLeniently(String data) {
        return StringUtilities.parseBooleanLeniently(data, null);
    }

    public static boolean parseBooleanStrictly(String data) throws TextSyntaxException {
        if (data.equals("false")) {
            return false;
        }
        if (data.equals("true")) {
            return true;
        }
        throw TextSyntaxException.inst("Not a 'true' or 'false'!: " + data);
    }

    public static String descape(Object source, char escapeChar, Character unicodeEscapeCode, boolean unmatchedEscapedValidlyMatchEscapeCode, boolean ignoreErrors, Object[] escapeDictionary) throws TextSyntaxException {
        int srclen = StringUtilities.getLength(source);
        if (source == null) {
            return null;
        }
        if (srclen == 0) {
            return "";
        }
        char[] src = StringUtilities.textthingToPossiblyUnclonedCharArray(source);
        assert (src.length == srclen);
        StringBuilder output = new StringBuilder(srclen);
        boolean usingUnicodeEscapes = false;
        char unicodeEscapeCodeChar = '\u0000';
        char[] escapeCodes = null;
        char[] escapeReplacementChars = null;
        char[][] escapeReplacementStrings = null;
        boolean bl = usingUnicodeEscapes = unicodeEscapeCode != null;
        if (usingUnicodeEscapes) {
            unicodeEscapeCodeChar = unicodeEscapeCode.charValue();
        }
        if (escapeDictionary.length % 2 != 0) {
            throw new IllegalArgumentException("dictionary not in pairs! ;_;");
        }
        escapeCodes = new char[escapeDictionary.length / 2];
        escapeReplacementChars = new char[escapeCodes.length];
        escapeReplacementStrings = new char[escapeCodes.length][];
        int i = 0;
        while (i < escapeCodes.length) {
            escapeCodes[i] = StringUtilities.getSingleChar(escapeDictionary[i * 2 + 0]);
            Object v = escapeDictionary[i * 2 + 1];
            int l = StringUtilities.getLength(v);
            if (l == 0) {
                throw new IllegalArgumentException("empty escape replacement for code " + StringUtilities.repr(Character.valueOf(escapeCodes[i])) + " o_O");
            }
            if (l == 1) {
                escapeReplacementStrings[i] = null;
                escapeReplacementChars[i] = StringUtilities.getSingleChar(v);
            } else {
                escapeReplacementStrings[i] = StringUtilities.textthingToPossiblyUnclonedCharArray(v);
            }
            ++i;
        }
        char escapeCode = '\u0000';
        int escapeDictionaryIndex = 0;
        boolean matchedEscapeCode = false;
        int safeSubstringStart = 0;
        int i2 = 0;
        while (i2 < srclen) {
            if (src[i2] == escapeChar) {
                if (i2 + 1 >= srclen) {
                    if (ignoreErrors) {
                        ++i2;
                        continue;
                    }
                    throw TextSyntaxException.inst("dangling escape char at EOF ><");
                }
                escapeCode = src[i2 + 1];
                if (usingUnicodeEscapes && escapeCode == unicodeEscapeCodeChar) {
                    if (i2 + 2 + 4 > srclen) {
                        if (ignoreErrors) {
                            i2 = Math.min(i2 + 2 + 4, srclen);
                            continue;
                        }
                        throw TextSyntaxException.inst("dangling unicode escape at EOF ><");
                    }
                    int v0 = Character.digit(src[i2 + 2 + 0], 16);
                    int v1 = Character.digit(src[i2 + 2 + 1], 16);
                    int v2 = Character.digit(src[i2 + 2 + 2], 16);
                    int v3 = Character.digit(src[i2 + 2 + 3], 16);
                    if (v0 == -1 || v1 == -1 || v2 == -1 || v3 == -1) {
                        if (ignoreErrors) {
                            i2 = Math.min(i2 + 2 + 4, srclen);
                            continue;
                        }
                        throw TextSyntaxException.inst("invalid hexadecimal unicode UTF-16BE (four hex char) escape! @ " + i2 + ": " + new String(src, i2, i2 + 2 + 4));
                    }
                    char c = (char)(v0 << 12 | v1 << 8 | v2 << 4 | v3 << 0);
                    if (safeSubstringStart != i2) {
                        output.append(src, safeSubstringStart, i2 - safeSubstringStart);
                    }
                    output.append(c);
                    safeSubstringStart = i2 += 6;
                    continue;
                }
                matchedEscapeCode = false;
                escapeDictionaryIndex = 0;
                while (escapeDictionaryIndex < escapeCodes.length) {
                    if (escapeCodes[escapeDictionaryIndex] == escapeCode) {
                        matchedEscapeCode = true;
                        if (safeSubstringStart != i2) {
                            output.append(src, safeSubstringStart, i2 - safeSubstringStart);
                        }
                        safeSubstringStart = i2 += 2;
                        if (escapeReplacementStrings[escapeDictionaryIndex] == null) {
                            output.append(escapeReplacementChars[escapeDictionaryIndex]);
                            break;
                        }
                        output.append(escapeReplacementStrings[escapeDictionaryIndex]);
                        break;
                    }
                    ++escapeDictionaryIndex;
                }
                if (matchedEscapeCode) continue;
                if (unmatchedEscapedValidlyMatchEscapeCode) {
                    if (safeSubstringStart != i2) {
                        output.append(src, safeSubstringStart, i2 - safeSubstringStart);
                    }
                    output.append(escapeCode);
                    safeSubstringStart = i2 += 2;
                    continue;
                }
                if (ignoreErrors) {
                    i2 += 2;
                    continue;
                }
                throw TextSyntaxException.inst("Unmatched escape code at " + (i2 + 1) + ": " + StringUtilities.repr(Character.valueOf(escapeCode)));
            }
            ++i2;
        }
        if (safeSubstringStart < srclen) {
            output.append(src, safeSubstringStart, srclen - safeSubstringStart);
        } else if (safeSubstringStart != srclen) {
            if (safeSubstringStart > srclen) {
                throw new ImpossibleException("src.length: " + src.length + ", srclen: " + srclen + ", safeSubstringStart: " + safeSubstringStart + ", escapeDictionary=" + StringUtilities.repr(escapeDictionary) + ", escapeChar=" + StringUtilities.repr(Character.valueOf(escapeChar)) + ", unicodeEscapeCode=" + StringUtilities.repr(unicodeEscapeCode) + ", ignoreErrors=" + ignoreErrors + ", src=" + StringUtilities.repr(new String(src)));
            }
            throw new UnreachableCodeException();
        }
        return output.toString();
    }

    public static String descapev(Object source, char escapeChar, Character unicodeEscapeCode, boolean unmatchedEscapedValidlyMatchEscapeCode, boolean ignoreErrors, Object ... escapeDictionary) throws TextSyntaxException {
        return StringUtilities.descape(source, escapeChar, unicodeEscapeCode, unmatchedEscapedValidlyMatchEscapeCode, ignoreErrors, escapeDictionary);
    }

    public static String descape(Object source, char escapeChar, Character unicodeEscapeCode, boolean unmatchedEscapedValidlyMatchEscapeCode, boolean ignoreErrors, Map escapeDictionary) {
        Object[] asarray = escapeDictionary == null ? new Object[]{} : new Object[escapeDictionary.size() * 2];
        int i = 0;
        for (Object code : escapeDictionary.keySet()) {
            Object replacementB;
            if (code == null || (replacementB = escapeDictionary.get(code)) == null) continue;
            asarray[i * 2 + 0] = code;
            asarray[i * 2 + 1] = replacementB;
        }
        return StringUtilities.descape(source, escapeChar, unicodeEscapeCode, unmatchedEscapedValidlyMatchEscapeCode, ignoreErrors, asarray);
    }

    public static String descapeRPStandard(Object escaped, char escapeChar, char whichSurroundingQuotelikeCharIsUsed) {
        return StringUtilities.descapev(escaped, escapeChar, Character.valueOf('u'), true, true, Character.valueOf('e'), Character.valueOf(escapeChar), Character.valueOf('z'), Character.valueOf(whichSurroundingQuotelikeCharIsUsed), Character.valueOf('q'), Character.valueOf('\''), Character.valueOf('d'), Character.valueOf('\"'), Character.valueOf('b'), Character.valueOf('`'), Character.valueOf('g'), Character.valueOf('\u00ab'), Character.valueOf('G'), Character.valueOf('\u00bb'), Character.valueOf('a'), Character.valueOf('<'), Character.valueOf('A'), Character.valueOf('>'), Character.valueOf('S'), Character.valueOf('*'), Character.valueOf('H'), Character.valueOf('#'), Character.valueOf('n'), Character.valueOf('\n'), Character.valueOf('r'), Character.valueOf('\r'), Character.valueOf('t'), Character.valueOf('\t'), Character.valueOf('s'), Character.valueOf(' '));
    }

    public static String descapeRPStandard(Object escaped) {
        return StringUtilities.descapeRPStandard(escaped, '\\', '\"');
    }

    public static String descapeJavaStandard(Object escaped) {
        return StringUtilities.descapev(escaped, '\\', Character.valueOf('u'), true, true, Character.valueOf('n'), Character.valueOf('\n'), Character.valueOf('r'), Character.valueOf('\r'), Character.valueOf('t'), Character.valueOf('\t'));
    }

    public static String descapeASCIIPercentSignSyntax(String s) throws TextSyntaxException {
        int n = s.length();
        StringBuilder b = new StringBuilder();
        int inEscape = 0;
        char firstEscapeChar = '\u0000';
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (inEscape == 1) {
                firstEscapeChar = c;
                inEscape = 2;
            } else if (inEscape == 2) {
                int v;
                char secondEscapeChar = c;
                if (!(firstEscapeChar >= '0' && firstEscapeChar <= '9' || firstEscapeChar >= 'A' && firstEscapeChar <= 'F' || firstEscapeChar >= 'a' && firstEscapeChar <= 'f')) {
                    throw TextSyntaxException.inst("Illegal hexadecimal: " + firstEscapeChar + secondEscapeChar);
                }
                if (!(secondEscapeChar >= '0' && secondEscapeChar <= '9' || secondEscapeChar >= 'A' && secondEscapeChar <= 'F' || secondEscapeChar >= 'a' && secondEscapeChar <= 'f')) {
                    throw TextSyntaxException.inst("Illegal hexadecimal: " + firstEscapeChar + secondEscapeChar);
                }
                try {
                    v = Integer.parseInt(new String(new char[]{firstEscapeChar, secondEscapeChar}), 16);
                }
                catch (NumberFormatException exc) {
                    throw new ImpossibleException(exc);
                }
                if (v > 127) {
                    throw TextSyntaxException.inst("Illegal character encoded: %" + firstEscapeChar + secondEscapeChar);
                }
                char escapedChar = (char)v;
                b.append(escapedChar);
                inEscape = 0;
            } else if (c == '%') {
                inEscape = 1;
            } else {
                b.append(c);
            }
            ++i;
        }
        if (inEscape == 1) {
            throw TextSyntaxException.inst("Syntax error, EOF in the middle of an escape!");
        }
        if (inEscape == 2) {
            throw TextSyntaxException.inst("Syntax error, EOF in the middle of an escape!");
        }
        return b.toString();
    }

    public static String deEscape(Object escaped, char escapeChar, char ... escapes) {
        Object[] escapeDict = Primitives.box(escapes);
        ArrayUtilities.swapPairs(escapeDict);
        return StringUtilities.descape(escaped, escapeChar, null, false, true, escapeDict);
    }

    public static String unicodeDescape(Object escaped) {
        return StringUtilities.descapev(escaped, '\\', Character.valueOf('u'), false, true, new Object[0]);
    }

    public static int indexOfSkippingSimpleEscapes(Object textthing, FunctionInterfaces.UnaryFunctionCharToBoolean targetChar, FunctionInterfaces.UnaryFunctionCharToBoolean escapeChar) {
        int p = -1;
        int len = StringUtilities.getLength(textthing);
        if (!(textthing instanceof char[]) && len < 24) {
            boolean inEscape = false;
            char c = '\u0000';
            int i = 0;
            while (i < len) {
                c = StringUtilities.charAt(textthing, i);
                if (!inEscape) {
                    if (escapeChar.f(c)) {
                        inEscape = true;
                    } else if (targetChar.f(c)) {
                        p = i;
                        break;
                    }
                } else {
                    inEscape = false;
                }
                ++i;
            }
        } else {
            char[] s = StringUtilities.textthingToPossiblyUnclonedCharArray(textthing);
            boolean inEscape = false;
            char c = '\u0000';
            int i = 0;
            while (i < len) {
                c = s[i];
                if (!inEscape) {
                    if (escapeChar.f(c)) {
                        inEscape = true;
                    } else if (targetChar.f(c)) {
                        p = i;
                        break;
                    }
                } else {
                    inEscape = false;
                }
                ++i;
            }
        }
        return p;
    }

    public static int indexOfSkippingSimpleEscapes(Object textthing, char targetChar, char escapeChar) {
        int p = -1;
        int len = StringUtilities.getLength(textthing);
        if (!(textthing instanceof char[]) && len < 24) {
            boolean inEscape = false;
            char c = '\u0000';
            int i = 0;
            while (i < len) {
                c = StringUtilities.charAt(textthing, i);
                if (!inEscape) {
                    if (escapeChar == c) {
                        inEscape = true;
                    } else if (targetChar == c) {
                        p = i;
                        break;
                    }
                } else {
                    inEscape = false;
                }
                ++i;
            }
        } else {
            char[] s = StringUtilities.textthingToPossiblyUnclonedCharArray(textthing);
            boolean inEscape = false;
            char c = '\u0000';
            int i = 0;
            while (i < len) {
                c = s[i];
                if (!inEscape) {
                    if (escapeChar == c) {
                        inEscape = true;
                    } else if (targetChar == c) {
                        p = i;
                        break;
                    }
                } else {
                    inEscape = false;
                }
                ++i;
            }
        }
        return p;
    }

    public static Object[] parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes(Object source, FunctionInterfaces.UnaryFunctionCharToBoolean quotesPattern, FunctionInterfaces.UnaryFunctionCharToBoolean breakingSpacePattern, FunctionInterfaces.UnaryFunctionCharToBoolean escapeCharacterPattern, boolean skipEscapesInsideUnquoteds, boolean throwSyntaxExceptionOnEoffedQuotedTokens) {
        ArrayList<char[]> tokens = new ArrayList<char[]>();
        char[] sourceCA = StringUtilities.textthingToPossiblyUnclonedCharArray(source);
        int currentTokenStart = 0;
        boolean inQuotes = false;
        char quoteChar = '\u0000';
        char c = '\u0000';
        int i = 0;
        while (i < sourceCA.length) {
            c = sourceCA[i];
            if (inQuotes) {
                if (c == quoteChar) {
                    inQuotes = false;
                    tokens.add(ArrayUtilities.slice(sourceCA, currentTokenStart, i));
                    currentTokenStart = i + 1;
                } else if (escapeCharacterPattern.f(c)) {
                    ++i;
                }
            } else if (breakingSpacePattern.f(c)) {
                if (i - currentTokenStart > 0) {
                    tokens.add(ArrayUtilities.slice(sourceCA, currentTokenStart, i));
                }
                currentTokenStart = i + 1;
            } else if (escapeCharacterPattern.f(c) && skipEscapesInsideUnquoteds) {
                ++i;
            } else if (quotesPattern.f(c)) {
                if (i - currentTokenStart > 0) {
                    tokens.add(ArrayUtilities.slice(sourceCA, currentTokenStart, i));
                }
                currentTokenStart = i + 1;
                inQuotes = true;
                quoteChar = c;
            }
            ++i;
        }
        if (inQuotes) {
            if (throwSyntaxExceptionOnEoffedQuotedTokens) {
                throw TextSyntaxException.inst("(local) EOF inside quoted token! :[");
            }
            tokens.add(ArrayUtilities.slice(sourceCA, currentTokenStart, sourceCA.length));
        } else if (sourceCA.length - currentTokenStart > 0) {
            tokens.add(ArrayUtilities.slice(sourceCA, currentTokenStart, sourceCA.length));
        }
        return tokens.toArray();
    }

    public static Object[] parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes_DoubleSingleAndBacktickQuotes_WhitespaceBreakingSpace_BackslashEscapes(Object source, boolean skipEscapesInsideUnquoteds, boolean throwSyntaxExceptionOnEoffedQuotedTokens) {
        return StringUtilities.parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes(source, ThreeQuotesPattern, CharacterPredicates.WHITESPACE_PATTERN, BackslashPattern, skipEscapesInsideUnquoteds, throwSyntaxExceptionOnEoffedQuotedTokens);
    }

    public static Object[] parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes_DoubleAndSingleQuotes_WhitespaceBreakingSpace_BackslashEscapes(Object source, boolean skipEscapesInsideUnquoteds, boolean throwSyntaxExceptionOnEoffedQuotedTokens) {
        return StringUtilities.parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes(source, TwoQuotesPattern, CharacterPredicates.WHITESPACE_PATTERN, BackslashPattern, skipEscapesInsideUnquoteds, throwSyntaxExceptionOnEoffedQuotedTokens);
    }

    public static Object[] parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes_DoubleQuotes_WhitespaceBreakingSpace_BackslashEscapes(Object source, boolean skipEscapesInsideUnquoteds, boolean throwSyntaxExceptionOnEoffedQuotedTokens) {
        return StringUtilities.parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes(source, JustDoubleQuotesPattern, CharacterPredicates.WHITESPACE_PATTERN, BackslashPattern, skipEscapesInsideUnquoteds, throwSyntaxExceptionOnEoffedQuotedTokens);
    }

    public static Object[] parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes_DoubleSingleAndBacktickQuotes_WhitespaceBreakingSpace_BackslashEscapes(Object source) {
        return StringUtilities.parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes_DoubleSingleAndBacktickQuotes_WhitespaceBreakingSpace_BackslashEscapes(source, true, false);
    }

    public static Object[] parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes_DoubleAndSingleQuotes_WhitespaceBreakingSpace_BackslashEscapes(Object source) {
        return StringUtilities.parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes_DoubleAndSingleQuotes_WhitespaceBreakingSpace_BackslashEscapes(source, true, false);
    }

    public static Object[] parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes_DoubleQuotes_WhitespaceBreakingSpace_BackslashEscapes(Object source) {
        return StringUtilities.parsePossiblyFlatlyQuotedWhitespaceSepararedTokensSkippingSimpleEscapes_DoubleQuotes_WhitespaceBreakingSpace_BackslashEscapes(source, true, false);
    }

    public static void parseBasicInfoDataLine(String sourceLine, Map<String, List<String>> results, boolean ignoreErroneousLines) throws TextSyntaxException {
        if ((sourceLine = sourceLine.trim()).isEmpty()) {
            return;
        }
        String key = null;
        String value = null;
        if (sourceLine.charAt(0) == '\"' || sourceLine.charAt(0) == '\'') {
            char q = sourceLine.charAt(0);
            int n = StringUtilities.indexOfSkippingSimpleEscapes((Object)(sourceLine = sourceLine.substring(1)), q, '\\');
            if (n == -1) {
                if (ignoreErroneousLines) {
                    return;
                }
                throw TextSyntaxException.inst("Opening key quote (" + q + ") but no closing one on same line! ;_;");
            }
            key = sourceLine.substring(0, n);
            key = StringUtilities.descapeRPStandard(key, '\\', q);
            if ((sourceLine = sourceLine.substring(n + 1).trim()).charAt(0) != ':' && sourceLine.charAt(0) != '=') {
                if (ignoreErroneousLines) {
                    return;
                }
                throw TextSyntaxException.inst("Neither a ':' nor a '='! ;_;");
            }
            sourceLine = sourceLine.substring(1).trim();
        } else {
            int n0 = sourceLine.indexOf(58);
            int n1 = sourceLine.indexOf(61);
            int n = 0;
            if (n0 == -1 && n1 == -1) {
                if (ignoreErroneousLines) {
                    return;
                }
                throw TextSyntaxException.inst("neither a ':' nor a '='! ;_;");
            }
            n = n0 == -1 ? n1 : (n1 == -1 ? n0 : Math.min(n0, n1));
            key = sourceLine.substring(0, n).trim();
            sourceLine = sourceLine.substring(1).trim();
        }
        value = sourceLine;
        List<String> values = results.get(key);
        if (values == null) {
            values = new ArrayList<String>(1);
            results.put(key, values);
        }
        values.add(value);
    }

    public static void parseBasicInfoData(String[] sourceLines, Map<String, List<String>> results, boolean ignoreErroneousLines) throws TextSyntaxException {
        String[] stringArray = sourceLines;
        int n = sourceLines.length;
        int n2 = 0;
        while (n2 < n) {
            String sourceLine = stringArray[n2];
            StringUtilities.parseBasicInfoDataLine(sourceLine, results, ignoreErroneousLines);
            ++n2;
        }
    }

    public static void parseBasicInfoData(String source, Map<String, List<String>> results, boolean ignoreErroneousLines) throws TextSyntaxException {
        StringUtilities.parseBasicInfoData(StringUtilities.split(source, '\n'), results, ignoreErroneousLines);
    }

    public static Map<String, List<String>> parseBasicInfoData(String[] sourceLines, boolean ignoreErroneousLines) throws TextSyntaxException {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        StringUtilities.parseBasicInfoData(sourceLines, results, ignoreErroneousLines);
        return results;
    }

    public static Map<String, List<String>> parseBasicInfoData(String source, boolean ignoreErroneousLines) throws TextSyntaxException {
        HashMap<String, List<String>> results = new HashMap<String, List<String>>();
        StringUtilities.parseBasicInfoData(source, results, ignoreErroneousLines);
        return results;
    }

    public static Map<String, String> parseBasicSingletonValuedInfoData(String source, boolean ignoreSyntaxErroneousLines) throws TextSyntaxException, NotSingletonException {
        Map<String, List<String>> results = StringUtilities.parseBasicInfoData(source, ignoreSyntaxErroneousLines);
        ArrayList<String> badKeys = null;
        for (String key : results.keySet()) {
            List<String> values = results.get(key);
            if (values.size() == 0) {
                throw new ImpossibleException();
            }
            if (values.size() == 1) {
                results.put(key, (List<String>)((Object)values.get(0)));
                continue;
            }
            if (badKeys == null) {
                badKeys = new ArrayList<String>();
            }
            badKeys.add(key);
        }
        if (badKeys == null || badKeys.isEmpty()) {
            return results;
        }
        throw new NotSingletonException("Non singleton keys!: " + StringUtilities.joinStrings(CollectionUtilities.mapToNewList(e -> StringUtilities.repr(e), badKeys), (CharSequence)", "));
    }

    public static String[] parseSimpleNonnestedFunctionInvocationExpression(String src) {
        int p = (src = src.trim()).indexOf(40);
        if (p == -1) {
            return null;
        }
        String functionName = src.substring(0, p).trim();
        if ((src = src.substring(p + 1)).endsWith(")")) {
            src = src.substring(0, src.length() - 1);
        }
        String[] args = StringUtilities.split(src, ',');
        int i = 0;
        while (i < args.length) {
            args[i] = args[i].trim();
            ++i;
        }
        if (args.length == 1 && args[0].isEmpty()) {
            args = new String[]{};
        }
        return ArrayUtilities.concat1WithArray(functionName, args);
    }

    public static List<Object> parseStandardPrefixnotationNestedFunctionInvocationExpression(String src) throws TextSyntaxCheckedException {
        try {
            return StringUtilities.parseStandardPrefixnotationNestedFunctionInvocationExpression(new StringReader(src));
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
    }

    public static List<Object> parseStandardPrefixnotationNestedFunctionInvocationExpression(Reader r) throws IOException, TextSyntaxCheckedException {
        return StringUtilities.parsePrefixnotationNestedFunctionInvocationExpression(r, '(', ')', ',', CharacterPredicates.WHITESPACE_PATTERN);
    }

    public static List<Object> parsePrefixnotationNestedFunctionInvocationExpression(Reader r, char opener, char closer, char delimiter, FunctionInterfaces.UnaryFunctionCharToBoolean ignorableCharPredicate) throws IOException, TextSyntaxCheckedException {
        char c;
        ArrayList stack = new ArrayList();
        stack.add(new ArrayList());
        StringBuilder buff = new StringBuilder();
        boolean State_FunctionName = false;
        boolean State_Arguments = true;
        int State_ArgumentsAfterNestedFunction = 2;
        int state = 0;
        while (true) {
            List currentDepthList;
            int e;
            if ((e = r.read()) == -1) {
                if (state == 0) {
                    throw TextSyntaxCheckedException.inst("Premature EOF!  Expected an opening '" + opener + "'");
                }
                throw TextSyntaxCheckedException.inst("Premature EOF!  Expected a closing '" + closer + "'");
            }
            c = (char)e;
            if (state == 0) {
                if (c == opener) {
                    String functionName = StringUtilities.trim(buff.toString(), ignorableCharPredicate);
                    buff.setLength(0);
                    currentDepthList = (List)stack.get(stack.size() - 1);
                    currentDepthList.add(functionName);
                    state = 1;
                    continue;
                }
                if (c == closer) {
                    throw TextSyntaxCheckedException.inst("Got a closing '" + closer + "' in the function name part where we expected an opening '" + opener + "'");
                }
                if (c == delimiter) {
                    throw TextSyntaxCheckedException.inst("Got a '" + delimiter + "' in the function name part where we expected an opening '" + opener + "'");
                }
                buff.append(c);
                continue;
            }
            if (state == 1) {
                if (c == opener) {
                    String functionName = StringUtilities.trim(buff.toString(), ignorableCharPredicate);
                    buff.setLength(0);
                    currentDepthList = (List)stack.get(stack.size() - 1);
                    ArrayList<String> nextDepthList = new ArrayList<String>();
                    nextDepthList.add(functionName);
                    currentDepthList.add(nextDepthList);
                    stack.add(nextDepthList);
                    continue;
                }
                if (c == closer || c == delimiter) {
                    boolean isEmptyArgumentList;
                    String leafArgument = StringUtilities.trim(buff.toString(), ignorableCharPredicate);
                    buff.setLength(0);
                    currentDepthList = (List)stack.get(stack.size() - 1);
                    boolean bl = isEmptyArgumentList = c == closer && currentDepthList.size() == 1 && leafArgument.isEmpty();
                    if (!isEmptyArgumentList) {
                        currentDepthList.add(leafArgument);
                    }
                    if (c != closer) continue;
                    int n = stack.size();
                    if (n <= 0) {
                        throw new AssertionError();
                    }
                    if (n == 1) {
                        return (List)stack.get(0);
                    }
                    stack.remove(n - 1);
                    state = 2;
                    continue;
                }
                buff.append(c);
                continue;
            }
            assert (state == 2);
            if (c == opener) {
                throw TextSyntaxCheckedException.inst("Got a opening '" + opener + "' in an argument after a function expression where we expected an closing '" + closer + "', a delimiting '" + delimiter + "', or ignorable chars (eg, whitespace) and then one of those two.");
            }
            if (c == closer) {
                int n = stack.size();
                if (n <= 0) {
                    throw new AssertionError();
                }
                if (n == 1) {
                    return (List)stack.get(0);
                }
                stack.remove(n - 1);
                state = 2;
                continue;
            }
            if (c == delimiter) {
                state = 1;
                continue;
            }
            if (!ignorableCharPredicate.f(c)) break;
        }
        throw TextSyntaxCheckedException.inst("Got a non-ignorable character '" + c + "' in an argument after a function expression where we expected an closing '" + closer + "', a delimiting '" + delimiter + "', or ignorable chars (eg, whitespace) and then one of those two.");
    }

    public static RPBasicParsedElementElement[] parseRPBasicNaive(RPBasicNaiveParsingSyntaxDescription syntax, Object textthing) {
        throw new NotYetImplementedException();
    }

    public static void appendDelimitedList(Object[] items, Object delimiter, Appendable buff) {
        boolean first = true;
        Object[] objectArray = items;
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item != null) {
                if (first) {
                    first = false;
                } else {
                    StringUtilities.appendTextthing(buff, delimiter);
                }
                StringUtilities.appendTextthing(buff, item);
            }
            ++n2;
        }
    }

    public static void appendDelimitedList(Iterable<?> items, Object delimiter, Appendable buff) {
        boolean first = true;
        for (Object item : items) {
            if (item == null) continue;
            if (first) {
                first = false;
            } else {
                StringUtilities.appendTextthing(buff, delimiter);
            }
            StringUtilities.appendTextthing(buff, item);
        }
    }

    public static void appendDelimitedList(Object[] items, char delimiter, Appendable buff) {
        try {
            boolean first = true;
            Object[] objectArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                Object item = objectArray[n2];
                if (item != null) {
                    if (first) {
                        first = false;
                    } else {
                        buff.append(delimiter);
                    }
                    StringUtilities.appendTextthing(buff, item);
                }
                ++n2;
            }
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static void appendDelimitedList(Iterable<?> items, char delimiter, Appendable buff) {
        try {
            boolean first = true;
            for (Object item : items) {
                if (item == null) continue;
                if (first) {
                    first = false;
                } else {
                    buff.append(delimiter);
                }
                StringUtilities.appendTextthing(buff, item);
            }
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static String joinStrings(Object[] items, CharSequence delimiter) {
        StringBuilder buff = new StringBuilder();
        StringUtilities.appendDelimitedList(items, (Object)delimiter, (Appendable)buff);
        return buff.toString();
    }

    public static String joinStrings(Iterable<?> items, CharSequence delimiter) {
        StringBuilder buff = new StringBuilder();
        StringUtilities.appendDelimitedList(items, (Object)delimiter, (Appendable)buff);
        return buff.toString();
    }

    public static String joinStrings(CharSequence delimiter, CharSequence ... items) {
        StringBuilder buff = new StringBuilder();
        StringUtilities.appendDelimitedList((Object[])items, (Object)delimiter, (Appendable)buff);
        return buff.toString();
    }

    public static String joinStrings(Object[] items, char delimiter) {
        StringBuilder buff = new StringBuilder();
        StringUtilities.appendDelimitedList(items, delimiter, (Appendable)buff);
        return buff.toString();
    }

    public static String joinStrings(Iterable<?> items, char delimiter) {
        StringBuilder buff = new StringBuilder();
        StringUtilities.appendDelimitedList(items, delimiter, (Appendable)buff);
        return buff.toString();
    }

    public static String joinStrings(char delimiter, CharSequence ... items) {
        StringBuilder buff = new StringBuilder();
        StringUtilities.appendDelimitedList((Object[])items, delimiter, (Appendable)buff);
        return buff.toString();
    }

    public static String escape(CharSequence original, char escapeChar, char ... escapes) {
        StringBuilder buffer = new StringBuilder();
        char c = '\u0000';
        int i = 0;
        while (i < original.length()) {
            block3: {
                c = original.charAt(i);
                int e = 0;
                while (e + 1 < escapes.length) {
                    if (c == escapes[e]) {
                        buffer.append(escapeChar);
                        buffer.append(escapes[e + 1]);
                        break block3;
                    }
                    e += 2;
                }
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String unicodeEscape(String original, FunctionInterfaces.UnaryFunctionCharToBoolean escapedChars) {
        StringBuilder buffer = new StringBuilder();
        char c = '\u0000';
        int i = 0;
        while (i < original.length()) {
            c = original.charAt(i);
            if (c == '\\' || escapedChars.f(c)) {
                buffer.append(StringUtilities.unicodeEscapeS(c));
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String unicodeEscape(String original) {
        return StringUtilities.unicodeEscape(original, CharacterPredicates.GENERALLY_PRINTABLE_NONNEWLINE_CHARS_INVERSE);
    }

    public static char[] unicodeEscapeCA(char c) {
        char[] ca = new char[6];
        ca[0] = 92;
        ca[1] = 117;
        StringUtilities.addFourBEHexCharsCA(c, ca, 2);
        return ca;
    }

    public static String unicodeEscapeS(char c) {
        return new String(StringUtilities.unicodeEscapeCA(c));
    }

    public static void addFourBEHexChars(char c, Appendable out) {
        try {
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF000) >> 12));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF00) >> 8));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0) >> 4));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor(c & 0xF));
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static void addFourBEHexCharsCA(char c, char[] ca, int offset) {
        ca[offset + 0] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF000) >> 12);
        ca[offset + 1] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF00) >> 8);
        ca[offset + 2] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0) >> 4);
        ca[offset + 3] = StringUtilities.uppercaseGeneralAsciiDigitFor(c & 0xF);
    }

    public static char[] fourBEHexCharsCA(char c) {
        char[] ca = new char[4];
        StringUtilities.addFourBEHexCharsCA(c, ca, 0);
        return ca;
    }

    public static String fourBEHexCharsS(char c) {
        return new String(StringUtilities.fourBEHexCharsCA(c));
    }

    public static char[] bigUnicodeEscapeCA(int c) {
        char[] ca = new char[10];
        ca[0] = 92;
        ca[1] = 85;
        StringUtilities.addEightBEHexCharsCA(c, ca, 2);
        return ca;
    }

    public static String bigUnicodeEscapeS(int c) {
        return new String(StringUtilities.bigUnicodeEscapeCA(c));
    }

    public static void addEightBEHexChars(int c, Appendable out) {
        try {
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0000000) >> 28));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF000000) >> 24));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF00000) >> 20));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0000) >> 16));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF000) >> 12));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF00) >> 8));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0) >> 4));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor(c & 0xF));
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static void addEightBEHexCharsCA(int c, char[] ca, int offset) {
        ca[offset + 0] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0000000) >> 28);
        ca[offset + 1] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF000000) >> 24);
        ca[offset + 2] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF00000) >> 20);
        ca[offset + 3] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0000) >> 16);
        ca[offset + 4] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF000) >> 12);
        ca[offset + 5] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF00) >> 8);
        ca[offset + 6] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0) >> 4);
        ca[offset + 7] = StringUtilities.uppercaseGeneralAsciiDigitFor(c & 0xF);
    }

    public static char[] eightBEHexCharsCA(int c) {
        char[] ca = new char[4];
        StringUtilities.addEightBEHexCharsCA(c, ca, 0);
        return ca;
    }

    public static String eightBEHexCharsS(int c) {
        return new String(StringUtilities.eightBEHexCharsCA(c));
    }

    public static void addTwoBEHexChars(int c, Appendable out) {
        try {
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0) >> 4));
            out.append(StringUtilities.uppercaseGeneralAsciiDigitFor(c & 0xF));
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static void addTwoBEHexCharsCA(int c, char[] ca, int offset) {
        ca[offset + 2] = StringUtilities.uppercaseGeneralAsciiDigitFor((c & 0xF0) >> 4);
        ca[offset + 3] = StringUtilities.uppercaseGeneralAsciiDigitFor(c & 0xF);
    }

    public static char[] twoBEHexCharsCA(int c) {
        char[] ca = new char[2];
        StringUtilities.addTwoBEHexCharsCA(c, ca, 0);
        return ca;
    }

    public static String twoBEHexCharsS(int c) {
        return new String(StringUtilities.twoBEHexCharsCA(c));
    }

    public static String unicodeHexEscape(int ucs4CharacterCodePoint) {
        if (ucs4CharacterCodePoint > 65535) {
            return StringUtilities.bigUnicodeEscapeS(ucs4CharacterCodePoint);
        }
        return StringUtilities.unicodeEscapeS((char)ucs4CharacterCodePoint);
    }

    public static char numeralAsciiDigitFor(int v) {
        if (v < 0 || v >= 10) {
            throw new IllegalArgumentException(String.valueOf(v));
        }
        return (char)(48 + v);
    }

    public static char uppercaseGeneralAsciiDigitFor(int v) {
        if (v < 0 || v >= 36) {
            throw new IllegalArgumentException(String.valueOf(v));
        }
        if (v < 10) {
            return (char)(48 + v);
        }
        return (char)(65 + (v - 10));
    }

    public static char lowercaseGeneralAsciiDigitFor(int v) {
        if (v < 0 || v >= 36) {
            throw new IllegalArgumentException(String.valueOf(v));
        }
        if (v < 10) {
            return (char)(48 + v);
        }
        return (char)(97 + (v - 10));
    }

    public static boolean is7bitAsciiCharacter(char c) {
        return c <= '\u007f';
    }

    public static String escapeJavaStandard(String original, boolean escapeSingleQuotes, boolean escapeDoubleQuotes, boolean escapeNonAscii) {
        StringBuilder buffer = new StringBuilder();
        char c = '\u0000';
        int i = 0;
        while (i < original.length()) {
            c = original.charAt(i);
            if (c == '\\' || escapeDoubleQuotes && c == '\"' || escapeSingleQuotes && c == '\'' || c == '\t' || CharacterPredicates.GENERALLY_PRINTABLE_NONNEWLINE_CHARS_INVERSE.f(c) || escapeNonAscii && !StringUtilities.is7bitAsciiCharacter(c)) {
                buffer.append(StringUtilities.javaEscape(c));
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String escapeJavaStandard(String original, boolean escapeSingleQuotes, boolean escapeDoubleQuotes) {
        return StringUtilities.escapeJavaStandard(original, escapeSingleQuotes, escapeDoubleQuotes, false);
    }

    public static String escapeJavaStandard(String original) {
        return StringUtilities.escapeJavaStandard(original, false, true);
    }

    public static String javaEscape(char c) {
        if (c == '\\') {
            return "\\\\";
        }
        if (c == '\"') {
            return "\\\"";
        }
        if (c == '\'') {
            return "\\'";
        }
        if (c == '\n') {
            return "\\n";
        }
        if (c == '\r') {
            return "\\r";
        }
        if (c == '\t') {
            return "\\t";
        }
        if (c == '\f') {
            return "\\f";
        }
        if (c == '\b') {
            return "\\b";
        }
        return StringUtilities.unicodeEscapeS(c);
    }

    public static String cescape(String raw) {
        StringBuilder buffer = new StringBuilder();
        char c = '\u0000';
        int i = 0;
        while (i < raw.length()) {
            c = raw.charAt(i);
            String standardEscape = null;
            if (c == '\\') {
                standardEscape = "\\\\";
            } else if (c == '\n') {
                standardEscape = "\\n";
            } else if (c == '\r') {
                standardEscape = "\\r";
            } else if (c == '\t') {
                standardEscape = "\\t";
            } else if (c == '\b') {
                standardEscape = "\\b";
            } else if (c == '\f') {
                standardEscape = "\\f";
            } else if (c == '\"') {
                standardEscape = "\\\"";
            } else if (c == '\'') {
                standardEscape = "\\'";
            }
            if (standardEscape != null) {
                buffer.append(standardEscape);
            } else if (c < ' ') {
                buffer.append("\\x");
                buffer.append(0);
                buffer.append(c & 0xF);
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    public static String repr(CharSequence s) {
        return s == null ? "null" : "\"" + StringUtilities.escapeJavaStandard(s.toString()) + "\"";
    }

    public static String repr(Object o) {
        return StringUtilities.reprr(o, Collections.EMPTY_SET, null);
    }

    public static String repr(Object o, Class ... classesToDeeplyBeanilyInspect) {
        return StringUtilities.reprr(o, Arrays.asList(classesToDeeplyBeanilyInspect), null);
    }

    public static String repr(Object o, Collection<Class> classesToDeeplyBeanilyInspect) {
        return StringUtilities.reprr(o, classesToDeeplyBeanilyInspect, null);
    }

    protected static String reprr(Object o, Collection<Class> classesToDeeplyBeanilyInspect, IdentityHashSet alreadyDoneM) {
        IdentityHashSet alreadyDone;
        boolean scalar;
        if (o == null) {
            return String.valueOf(o);
        }
        if (o instanceof Reprable) {
            return ((Reprable)((Object)o)).reprThis();
        }
        boolean bl = scalar = Primitives.isPrimitiveWrapperClass(o.getClass()) || o instanceof String || o instanceof StringBuffer || o instanceof StringBuilder || o instanceof PrimitiveCollections.ImmutableByteArrayList || o instanceof Class || o instanceof Enum || o instanceof UUID;
        if (scalar) {
            if (o instanceof Byte) {
                return "(byte)" + o;
            }
            if (o instanceof Short) {
                return "(short)" + o;
            }
            if (o instanceof Long) {
                return o + "l";
            }
            if (o instanceof Float) {
                return o + "f";
            }
            if (o instanceof Double) {
                return o.toString();
            }
            if (o instanceof Integer) {
                return o.toString();
            }
            if (o instanceof Boolean) {
                return o.toString();
            }
            if (o instanceof UUID) {
                return o.toString();
            }
            if (o instanceof CharSequence) {
                return "\"" + StringUtilities.escapeJavaStandard(o.toString()) + "\"";
            }
            if (o instanceof Character) {
                return "'" + StringUtilities.escapeJavaStandard(o.toString()) + "'";
            }
            if (o instanceof PrimitiveCollections.ImmutableByteArrayList) {
                return DataEncodingUtilities.encodeHexNoDelimiter((PrimitiveCollections.ImmutableByteArrayList)o, 7);
            }
            if (o instanceof Class) {
                return o.toString();
            }
            if (o instanceof Enum) {
                return String.valueOf(o.getClass().getName()) + "." + ((Enum)((Object)o)).name();
            }
            throw new ImpossibleException("you forgot to add a case for it silly me >,>");
        }
        IdentityHashSet identityHashSet = alreadyDone = alreadyDoneM == null ? new IdentityHashSet() : alreadyDoneM;
        if (alreadyDone.contains(o)) {
            return "<instance already represented>";
        }
        alreadyDone.add(o);
        if (o instanceof SimpleTable) {
            o = ((SimpleTable)((Object)o)).toListOfRowsPossiblyLive();
        }
        if (o instanceof Collection || o.getClass().isArray() || o instanceof Slice) {
            boolean isArray = o.getClass().isArray();
            StringBuilder out = new StringBuilder();
            if (isArray) {
                out.append("new ");
                out.append(o.getClass().getCanonicalName());
                out.append("{");
            } else if (o instanceof Slice) {
                Slice s = (Slice)((Object)o);
                Object u = s.getUnderlying();
                out.append("Slice(");
                if (u.getClass().isArray()) {
                    out.append(u.getClass().getCanonicalName());
                } else {
                    out.append(u.getClass().getName());
                }
                out.append(")[");
            } else {
                out.append("(");
                out.append(o.getClass().getName());
                out.append(")[");
            }
            StringUtilities.reprListContents(PolymorphicCollectionUtilities.anyToIterable(o), c -> StringUtilities.reprr(c, classesToDeeplyBeanilyInspect, alreadyDone), out);
            if (isArray) {
                out.append('}');
            } else {
                out.append(']');
            }
            return out.toString();
        }
        if (o instanceof Map) {
            StringBuilder out = new StringBuilder("(");
            out.append(o.getClass().getName());
            out.append("){");
            StringUtilities.reprMapContents((Map)((Object)o), c -> StringUtilities.reprr(c, classesToDeeplyBeanilyInspect, alreadyDone), out);
            out.append("}");
            return out.toString();
        }
        return "(" + o.getClass().getName() + ")" + StringUtilities.repr(o.toString());
    }

    public static String reprMapContents(Map o, FunctionInterfaces.UnaryFunction<Object, String> repr) {
        StringBuilder out = new StringBuilder();
        StringUtilities.reprMapContents(o, repr, out);
        return out.toString();
    }

    public static void reprMapContents(Map o, FunctionInterfaces.UnaryFunction<Object, String> repr, StringBuilder out) {
        if (!o.isEmpty()) {
            out.append("\n\t");
            boolean first = true;
            for (Map.Entry<Object, Object> oEntry : CollectionUtilities.sorted(o.entrySet(), ReprMapKeysBestEffortSortingComparator)) {
                if (!first) {
                    out.append(",\n\t");
                }
                first = false;
                Map.Entry<Object, Object> entry = oEntry;
                out.append(repr.f(entry.getKey()).replace("\n", "\n\t"));
                out.append(": ");
                out.append(repr.f(entry.getValue()).replace("\n", "\n\t"));
            }
            out.append("\n");
        }
    }

    public static String reprMapContents(Map map) {
        StringBuilder out = new StringBuilder();
        StringUtilities.reprMapContents(map, StringUtilities::repr, out);
        return out.toString();
    }

    public static String reprListContents(Iterable o, FunctionInterfaces.UnaryFunction<Object, String> repr) {
        StringBuilder out = new StringBuilder();
        StringUtilities.reprListContents(o, repr, out);
        return out.toString();
    }

    public static void reprListContents(Iterable list, FunctionInterfaces.UnaryFunction<Object, String> repr, StringBuilder out) {
        if (!BasicCollectionUtilities.isEmptyIterable(list)) {
            Collection<String> childrenReprs = CollectionUtilities.mapToNewCollection(input -> ((String)repr.f(input)).replace("\n", "\n\t"), list);
            boolean multiline = false;
            for (String childRepr : childrenReprs) {
                if (!childRepr.contains("\n") && childRepr.length() <= 20) continue;
                multiline = true;
                break;
            }
            if (multiline) {
                out.append("\n\t");
            }
            boolean first = true;
            for (String childRepr : childrenReprs) {
                if (!first) {
                    out.append(multiline ? ",\n\t" : ", ");
                }
                first = false;
                out.append(childRepr);
            }
            if (multiline) {
                out.append("\n");
            }
        }
    }

    public static String reprListContents(Iterable list) {
        StringBuilder out = new StringBuilder();
        StringUtilities.reprListContents(list, StringUtilities::repr, out);
        return out.toString();
    }

    public static String reprListContentsSingleLine(Iterable list) {
        return StringUtilities.singleLineify(StringUtilities.reprListContents(list));
    }

    public static String reprListContents(Object list) {
        return StringUtilities.reprListContents(PolymorphicCollectionUtilities.anyToIterable(list));
    }

    public static String reprListContentsSingleLine(Object list) {
        return StringUtilities.singleLineify(StringUtilities.reprListContents(list));
    }

    public static String reprListContentsV(Object ... list) {
        return StringUtilities.reprListContents(Arrays.asList(list));
    }

    public static String reprListContentsSingleLineV(Object ... list) {
        return StringUtilities.singleLineify(StringUtilities.reprListContents(Arrays.asList(list)));
    }

    public static String singleLineify(String s) {
        return s.replace("\t", "").replace("\n", " ").trim();
    }

    public static String reprSingleLine(Object o) {
        return StringUtilities.singleLineify(StringUtilities.repr(o));
    }

    public static String reprSingleLine(Object o, Class ... classesToDeeplyBeanilyInspect) {
        return StringUtilities.singleLineify(StringUtilities.repr(o, classesToDeeplyBeanilyInspect));
    }

    public static String reprSingleLine(Object o, Collection<Class> classesToDeeplyBeanilyInspect) {
        return StringUtilities.singleLineify(StringUtilities.repr(o, classesToDeeplyBeanilyInspect));
    }

    public static String getSimpleLeadingZeroPaddedIntegerRepresentation(long integer, int minDigits, int radix) {
        long positiveInteger = Math.abs(integer);
        String normal = Long.toString(positiveInteger, radix);
        int normalLength = normal.length();
        if (normalLength >= minDigits) {
            return integer < 0L ? String.valueOf('-') + normal : normal;
        }
        String lz = StringUtilities.mulneg('0', minDigits - normalLength);
        return integer < 0L ? String.valueOf('-') + lz + normal : String.valueOf(lz) + normal;
    }

    public static String getSimpleLeadingZeroPaddedIntegerRepresentation(long integer, int minDigits) {
        return StringUtilities.getSimpleLeadingZeroPaddedIntegerRepresentation(integer, minDigits, 10);
    }

    public static String toFixedLengthBinaryString(boolean v) {
        return v ? "1" : "0";
    }

    public static String toFixedLengthBinaryString(byte v) {
        String s = Integer.toBinaryString(v & 0xFF);
        if (s.length() < 8) {
            s = String.valueOf(StringUtilities.mulnn('0', 8 - s.length())) + s;
        }
        return s;
    }

    public static String toFixedLengthBinaryString(short v) {
        String s = Integer.toBinaryString(v & 0xFFFF);
        if (s.length() < 16) {
            s = String.valueOf(StringUtilities.mulnn('0', 16 - s.length())) + s;
        }
        return s;
    }

    public static String toFixedLengthBinaryString(char v) {
        String s = Integer.toBinaryString(v & 0xFFFF);
        if (s.length() < 16) {
            s = String.valueOf(StringUtilities.mulnn('0', 16 - s.length())) + s;
        }
        return s;
    }

    public static String toFixedLengthBinaryString(int v) {
        String s = Integer.toBinaryString(v);
        if (s.length() < 32) {
            s = String.valueOf(StringUtilities.mulnn('0', 32 - s.length())) + s;
        }
        return s;
    }

    public static String toFixedLengthBinaryString(long v) {
        String s = Long.toBinaryString(v);
        if (s.length() < 64) {
            s = String.valueOf(StringUtilities.mulnn('0', 64 - s.length())) + s;
        }
        return s;
    }

    public static String toFixedLengthBinaryString(int v, int l) {
        String s = Integer.toBinaryString(v);
        if (s.length() < l) {
            s = String.valueOf(StringUtilities.mulnn('0', l - s.length())) + s;
        }
        return s;
    }

    public static String toFixedLengthBinaryString(long v, int l) {
        String s = Long.toBinaryString(v);
        if (s.length() < l) {
            s = String.valueOf(StringUtilities.mulnn('0', l - s.length())) + s;
        }
        return s;
    }

    public static String toFixedLengthHexStringLowercase(byte v) {
        int i = Unsigned.upcast(v);
        if (i <= 15) {
            return "0" + Integer.toHexString(i);
        }
        return Integer.toHexString(i);
    }

    public static String toFixedLengthHexStringLowercase(short v) {
        int i = Unsigned.upcast(v);
        if (i <= 15) {
            return "000" + Integer.toHexString(i);
        }
        if (i <= 255) {
            return "00" + Integer.toHexString(i);
        }
        if (i <= 4095) {
            return "0" + Integer.toHexString(i);
        }
        return Integer.toHexString(i);
    }

    public static String toFixedLengthHexStringLowercase(char v) {
        char i = v;
        if (i <= '\u000f') {
            return "000" + Integer.toHexString(i);
        }
        if (i <= '\u00ff') {
            return "00" + Integer.toHexString(i);
        }
        if (i <= '\u0fff') {
            return "0" + Integer.toHexString(i);
        }
        return Integer.toHexString(i);
    }

    public static String toFixedLengthHexStringLowercase(int v) {
        String s = Integer.toHexString(v);
        int l = s.length();
        if (l > 8) {
            throw new AssertionError();
        }
        if (l == 8) {
            return s;
        }
        char[] c = new char[8];
        int x = 0;
        while (x < 8 - l) {
            c[x] = 48;
            ++x;
        }
        x = 8 - l;
        while (x < 8) {
            c[x] = s.charAt(x - (8 - l));
            ++x;
        }
        return new String(c);
    }

    public static String toFixedLengthHexStringLowercase(long v) {
        String s = Long.toHexString(v);
        int l = s.length();
        if (l > 16) {
            throw new AssertionError();
        }
        if (l == 16) {
            return s;
        }
        char[] c = new char[16];
        int x = 0;
        while (x < 16 - l) {
            c[x] = 48;
            ++x;
        }
        x = 16 - l;
        while (x < 16) {
            c[x] = s.charAt(x - (16 - l));
            ++x;
        }
        return new String(c);
    }

    public static String hexint(byte b) {
        String s = Integer.toHexString(Unsigned.upcast(b)).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', 2 - s.length()) + s;
    }

    public static String hexint(short b) {
        String s = Integer.toHexString(Unsigned.upcast(b)).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', 4 - s.length()) + s;
    }

    public static String hexint(int b) {
        String s = Integer.toHexString(b).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', 8 - s.length()) + s;
    }

    public static String hexint(long b) {
        String s = Long.toHexString(b).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', 16 - s.length()) + s;
    }

    public static String hexint(int b, int l) {
        String s = Integer.toHexString(b).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', l - s.length()) + s;
    }

    public static String hexint(long b, int l) {
        String s = Long.toHexString(b).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', l - s.length()) + s;
    }

    public static String hexint24(int b) {
        String s = Integer.toHexString(b & 0xFFFFFF).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', 6 - s.length()) + s;
    }

    public static String hexint40(long b) {
        String s = Long.toHexString(b & 0xFFFFFFFFFFL).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', 10 - s.length()) + s;
    }

    public static String hexint48(long b) {
        String s = Long.toHexString(b & 0xFFFFFFFFFFFFL).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', 12 - s.length()) + s;
    }

    public static String hexint56(long b) {
        String s = Long.toHexString(b & 0xFFFFFFFFFFFFFFL).toUpperCase();
        return "0x" + StringUtilities.mulnn('0', 14 - s.length()) + s;
    }

    public static String binint(byte b) {
        String s = Integer.toBinaryString(Unsigned.upcast(b)).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', 8 - s.length()) + s;
    }

    public static String binint(short b) {
        String s = Integer.toBinaryString(Unsigned.upcast(b)).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', 16 - s.length()) + s;
    }

    public static String binint(int b) {
        String s = Integer.toBinaryString(b).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', 32 - s.length()) + s;
    }

    public static String binint(long b) {
        String s = Long.toBinaryString(b).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', 64 - s.length()) + s;
    }

    public static String binint(int b, int l) {
        String s = Integer.toBinaryString(b).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', l - s.length()) + s;
    }

    public static String binint(long b, int l) {
        String s = Long.toBinaryString(b).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', l - s.length()) + s;
    }

    public static String binint24(int b) {
        String s = Integer.toBinaryString(b & 0xFFFFFF).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', 24 - s.length()) + s;
    }

    public static String binint40(long b) {
        String s = Long.toBinaryString(b & 0xFFFFFFFFFFL).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', 40 - s.length()) + s;
    }

    public static String binint48(long b) {
        String s = Long.toBinaryString(b & 0xFFFFFFFFFFFFL).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', 48 - s.length()) + s;
    }

    public static String binint56(long b) {
        String s = Long.toBinaryString(b & 0xFFFFFFFFFFFFFFL).toUpperCase();
        return "0b" + StringUtilities.mulnn('0', 56 - s.length()) + s;
    }

    public static String reprBitfield(Object v) {
        if (v instanceof Long) {
            return StringUtilities.reprBitfield((Long)v);
        }
        if (v instanceof Integer) {
            return StringUtilities.reprBitfield((Integer)v);
        }
        if (v instanceof Character) {
            return StringUtilities.reprBitfield(((Character)v).charValue());
        }
        if (v instanceof Short) {
            return StringUtilities.reprBitfield((Short)v);
        }
        if (v instanceof Byte) {
            return StringUtilities.reprBitfield((Byte)v);
        }
        if (v instanceof Boolean) {
            return StringUtilities.reprBitfield((Boolean)v);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(v);
    }

    public static String reprBitfield(long v) {
        return "0b" + StringUtilities.toFixedLengthBinaryString(v) + "L";
    }

    public static String reprBitfield(int v) {
        return "0b" + StringUtilities.toFixedLengthBinaryString(v);
    }

    public static String reprBitfield(char v) {
        return "(char)0b" + StringUtilities.toFixedLengthBinaryString(v);
    }

    public static String reprBitfield(short v) {
        return "(short)0b" + StringUtilities.toFixedLengthBinaryString(v);
    }

    public static String reprBitfield(byte v) {
        return "(byte)0b" + StringUtilities.toFixedLengthBinaryString(v);
    }

    public static String reprBitfield(boolean v) {
        return Boolean.toString(v);
    }

    public static String toFixedLengthBinaryString(Object v) {
        if (v instanceof Long) {
            return StringUtilities.toFixedLengthBinaryString((Long)v);
        }
        if (v instanceof Integer) {
            return StringUtilities.toFixedLengthBinaryString((Integer)v);
        }
        if (v instanceof Character) {
            return StringUtilities.toFixedLengthBinaryString(((Character)v).charValue());
        }
        if (v instanceof Short) {
            return StringUtilities.toFixedLengthBinaryString((Short)v);
        }
        if (v instanceof Byte) {
            return StringUtilities.toFixedLengthBinaryString((Byte)v);
        }
        if (v instanceof Boolean) {
            return StringUtilities.toFixedLengthBinaryString((Boolean)v);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(v);
    }

    public static String simpleIdentifierMunging(Object s) {
        char[] ca = StringUtilities.textthingToPossiblyUnclonedCharArray(s);
        boolean clean = true;
        char[] cArray = ca;
        int n = ca.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!(CharacterPredicates.isAsciiLowercase(c) || CharacterPredicates.isAsciiUppercase(c) || CharacterPredicates.isAsciiDigit(c) || c == '_')) {
                clean = false;
                break;
            }
            ++n2;
        }
        if (clean) {
            return StringUtilities.textthingToString(s);
        }
        StringBuilder b = new StringBuilder();
        int cleanRegionStart = 0;
        int i = 0;
        while (i < ca.length) {
            char c = ca[i];
            if (!(CharacterPredicates.isAsciiDigit(c) || CharacterPredicates.isAsciiLowercase(c) || CharacterPredicates.isAsciiUppercase(c))) {
                if (cleanRegionStart - i > 0) {
                    b.append(ca, cleanRegionStart, i - cleanRegionStart);
                }
                b.append('_');
                StringUtilities.addFourBEHexChars(c, b);
                cleanRegionStart = i + 1;
            }
            ++i;
        }
        if (cleanRegionStart - ca.length > 0) {
            b.append(ca, cleanRegionStart, ca.length - cleanRegionStart);
        }
        return b.toString();
    }

    public static String simpleIdentifierDeMunging(Object s) {
        char[] ca = StringUtilities.textthingToPossiblyUnclonedCharArray(s);
        boolean clean = true;
        char[] cArray = ca;
        int n = ca.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (!(CharacterPredicates.isAsciiLowercase(c) || CharacterPredicates.isAsciiUppercase(c) || CharacterPredicates.isAsciiDigit(c) || c == '_')) {
                clean = false;
                break;
            }
            ++n2;
        }
        if (clean) {
            return StringUtilities.textthingToString(s);
        }
        StringBuilder b = new StringBuilder();
        int cleanRegionStart = 0;
        int i = 0;
        while (i < ca.length) {
            char c = ca[i];
            if (c == '_') {
                if (cleanRegionStart - i > 0) {
                    b.append(ca, cleanRegionStart, i - cleanRegionStart);
                }
                if (i + 1 + 4 <= ca.length) {
                    int v = Integer.parseInt(new String(ca, i + 1, 4), 16);
                    assert (v >= 0 && v <= 65535);
                    b.append((char)i);
                }
                cleanRegionStart = i + 1 + 4;
            }
            ++i;
        }
        if (cleanRegionStart - ca.length > 0) {
            b.append(ca, cleanRegionStart, ca.length - cleanRegionStart);
        }
        return b.toString();
    }

    public static String reverse(String x) {
        if (x.length() < 2) {
            return x;
        }
        char[] c = x.toCharArray();
        ArrayUtilities.reverse(c);
        return new String(c);
    }

    public static int[] utf16ToUCS4Array(char[] utf16) throws UTF16EncodingException {
        int[] a;
        UCS4ReaderFromNormalUTF16Reader utf16Decoder = new UCS4ReaderFromNormalUTF16Reader(new CharArrayReader(utf16));
        try {
            a = TextIOUtilities.readAll(utf16Decoder);
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
        int[] b = new String(utf16).codePoints().toArray();
        WidespreadTestingUtilities.asrt(Arrays.equals(a, b));
        return b;
    }

    public static int[] utf16ToUCS4Array(String utf16) throws UTF16EncodingException {
        int[] a;
        UCS4ReaderFromNormalUTF16Reader utf16Decoder = new UCS4ReaderFromNormalUTF16Reader(new StringReader(utf16));
        try {
            a = TextIOUtilities.readAll(utf16Decoder);
        }
        catch (IOException exc) {
            throw new ImpossibleException(exc);
        }
        int[] b = utf16.codePoints().toArray();
        WidespreadTestingUtilities.asrt(Arrays.equals(a, b));
        return b;
    }

    public static PrimitiveCollections.IntegerList utf16ToUCS4List(String utf16) throws UTF16EncodingException {
        return PrimitiveCollections.intArrayAsList(StringUtilities.utf16ToUCS4Array(utf16));
    }

    public static String ucs4ToUTF16String(List<Integer> list) {
        return StringUtilities.ucs4ToUTF16String(PrimitiveCollections.wrappedIntegerList(list).toIntArraySlicePossiblyLive());
    }

    public static String ucs4ToUTF16String(Slice<int[]> slice) {
        return StringUtilities.ucs4ToUTF16String(slice.getUnderlying(), slice.getOffset(), slice.getLength());
    }

    public static String ucs4ToUTF16String(int[] array) {
        return StringUtilities.ucs4ToUTF16String(array, 0, array.length);
    }

    public static String ucs4ToUTF16String(int[] array, int offset, int length) {
        return new String(array, offset, length);
    }

    public static void defaultWriteUTF16ToUCS4(CharSequence source, UCS4Writer dest) throws IOException {
        StringUtilities.defaultWriteUTF16ToUCS4(source.toString(), dest);
    }

    public static void defaultWriteUTF16ToUCS4(String source, UCS4Writer dest) throws IOException {
        StringUtilities.defaultWriteUTF16toUCS4(new StringReader(source), dest);
    }

    public static void defaultWriteUTF16toUCS4(Reader source, UCS4Writer dest) throws IOException {
        UCS4ReaderFromNormalUTF16Reader utf16Decoder = new UCS4ReaderFromNormalUTF16Reader(source);
        TextIOUtilities.pump(utf16Decoder, dest);
    }

    public static String byteArrayToString(byte[] data) {
        StringBuilder s = new StringBuilder();
        s.append('(');
        s.append(data.length);
        s.append(" immutable bytes) ");
        s.append(DataEncodingUtilities.encodeHex(data, 0, SmallIntegerMathUtilities.least(data.length, 128), 7, null));
        if (data.length > 128) {
            s.append("...");
        }
        return s.toString();
    }

    public static String toStringU64(@ActuallyUnsigned long value, int radix, FunctionInterfaces.UnaryFunctionIntToChar alphabet) {
        if (value == 0L) {
            return String.valueOf(alphabet.f(0));
        }
        return StringUtilities.toStringGenericU64(value, radix, alphabet, MathUtilities::placeValueStandard);
    }

    public static String toStringU64LE(@ActuallyUnsigned long value, int radix, FunctionInterfaces.UnaryFunctionIntToChar alphabet) {
        if (value == 0L) {
            return String.valueOf(alphabet.f(0));
        }
        return StringUtilities.toStringU64GenericLE(value, radix, alphabet, MathUtilities::placeValueStandard);
    }

    public static String toStringU64Bijective(@ActuallyUnsigned long value, int radix, FunctionInterfaces.UnaryFunctionIntToChar alphabet) {
        return StringUtilities.toStringGenericU64(value, radix, alphabet, MathUtilities::placeValueBijective);
    }

    public static String toStringU64BijectiveLE(@ActuallyUnsigned long value, int radix, FunctionInterfaces.UnaryFunctionIntToChar alphabet) {
        return StringUtilities.toStringU64GenericLE(value, radix, alphabet, MathUtilities::placeValueBijective);
    }

    public static String toStringGenericU64(@ActuallyUnsigned long value, int radix, FunctionInterfaces.UnaryFunctionIntToChar alphabet, PlaceValueEncodingAlgorithm encoder) {
        char[] chars = new char[64];
        SimpleContainers.SimpleIntegerContainer count_C = new SimpleContainers.SimpleIntegerContainer(0);
        encoder.encode(value, radix, digit -> {
            int count = count_C.get();
            cArray[64 - ++count] = alphabet.f(BitfieldSafeCasts.safeCastU64toS32(digit));
            count_C.set(count);
        });
        int count = count_C.get();
        return new String(chars, 64 - count, count);
    }

    public static String toStringU64GenericLE(@ActuallyUnsigned long value, int radix, FunctionInterfaces.UnaryFunctionIntToChar alphabet, PlaceValueEncodingAlgorithm encoder) {
        char[] chars = new char[64];
        SimpleContainers.SimpleIntegerContainer count_C = new SimpleContainers.SimpleIntegerContainer(0);
        encoder.encode(value, radix, digit -> {
            int count = count_C.get();
            cArray[count] = alphabet.f(BitfieldSafeCasts.safeCastU64toS32(digit));
            count_C.set(++count);
        });
        int count = count_C.get();
        return new String(chars, 0, count);
    }

    public static String toStringU64LEFromConcreteAlphabet(@ActuallyUnsigned long value, char[] digitsAlphabet) {
        return StringUtilities.toStringU64LE(value, digitsAlphabet.length, d -> digitsAlphabet[d]);
    }

    public static String toStringU64LEFromContiguousAlphabet(@ActuallyUnsigned long value, char digitsStart, char digitsEndInclusive) {
        return StringUtilities.toStringU64LE(value, digitsEndInclusive + '\u0001' - digitsStart, d -> (char)(d + digitsStart));
    }

    public static String toStringU64(@ActuallyUnsigned long value, int radix) {
        return StringUtilities.toStringU64(value, radix, digit -> Character.forDigit(digit, radix));
    }

    public static String toStringU32(@ActuallyUnsigned int value, int radix) {
        if (value == 0) {
            return "0";
        }
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        char[] chars = new char[32];
        int count = 0;
        int digit = 0;
        while (Unsigned.greaterThanU32(value, 0)) {
            digit = Unsigned.modulusU32(value, radix);
            value -= digit;
            value = Unsigned.divideU32(value, radix);
            chars[32 - ++count] = Character.forDigit(digit, radix);
        }
        return new String(chars, 32 - count, count);
    }

    public static String toStringU16(char value, int radix) {
        return StringUtilities.toStringU32(value, radix);
    }

    public static String toStringU8(@ActuallyUnsigned byte value, int radix) {
        return StringUtilities.toStringU32(Unsigned.upcast(value), radix);
    }

    public static String toStringU64(@ActuallyUnsigned long value) {
        return StringUtilities.toStringU64(value, 10);
    }

    public static String toStringU32(@ActuallyUnsigned int value) {
        return StringUtilities.toStringU32(value, 10);
    }

    public static String toStringU16(char value) {
        return StringUtilities.toStringU16(value, 10);
    }

    public static String toStringU8(@ActuallyUnsigned byte value) {
        return StringUtilities.toStringU8(value, 10);
    }

    public static String arrayToString(Object array) {
        if (array == null) {
            return String.valueOf(null);
        }
        if (array instanceof Object[]) {
            return Arrays.toString((Object[])array);
        }
        if (array instanceof boolean[]) {
            return Arrays.toString((boolean[])array);
        }
        if (array instanceof byte[]) {
            return Arrays.toString((byte[])array);
        }
        if (array instanceof char[]) {
            return Arrays.toString((char[])array);
        }
        if (array instanceof short[]) {
            return Arrays.toString((short[])array);
        }
        if (array instanceof float[]) {
            return Arrays.toString((float[])array);
        }
        if (array instanceof int[]) {
            return Arrays.toString((int[])array);
        }
        if (array instanceof double[]) {
            return Arrays.toString((double[])array);
        }
        if (array instanceof long[]) {
            return Arrays.toString((long[])array);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(array);
    }

    public static char[] simple7bitAsciiToUCS2Chars(byte[] asciiBytes) throws MalformedInputException {
        int n = asciiBytes.length;
        char[] c = new char[n];
        int i = 0;
        while (i < n) {
            int b = asciiBytes[i] & 0xFF;
            if (b >= 128) {
                throw new MalformedInputException(i);
            }
            c[i] = (char)b;
            ++i;
        }
        return c;
    }

    public static char[] simpleISO88591ToUCS2Chars(byte[] asciiBytes) {
        int n = asciiBytes.length;
        char[] c = new char[n];
        int i = 0;
        while (i < n) {
            int b = asciiBytes[i] & 0xFF;
            c[i] = (char)b;
            ++i;
        }
        return c;
    }

    public static String canonicalizeWhitespace(String s) {
        return StringUtilities.charuniq(StringUtilities.replaceWhitespace(s, ' '), c -> c == ' ');
    }

    @Nonnull
    public static String charuniq(@Nonnull String s) {
        return StringUtilities.charuniq(s, c -> c == ' ');
    }

    @Nonnull
    public static String charuniq(@Nonnull String s, @Nullable FunctionInterfaces.UnaryFunctionCharToBoolean characterPredicate) {
        StringBuilder rv = new StringBuilder();
        char prev = '\u0000';
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (i == 0) {
                rv.append(c);
            } else if (c != prev || characterPredicate != null && !characterPredicate.f(c)) {
                rv.append(c);
            }
            prev = c;
            ++i;
        }
        return rv.toString();
    }

    public static String replaceWhitespace(String s) {
        return StringUtilities.replaceWhitespace(s, ' ');
    }

    public static String replaceWhitespace(String s, char replacement) {
        return StringUtilities.replaceCharsByPattern(s, CharacterPredicates.WHITESPACE_PATTERN, replacement);
    }

    public static String replaceCharsByPattern(String s, FunctionInterfaces.UnaryFunctionCharToBoolean charPattern, char replacement) {
        return new String(ArrayUtilities.replaceByPatternToNew(s.toCharArray(), charPattern, replacement));
    }

    public static String removeWhitespace(String s) {
        return StringUtilities.replaceWhitespace(s, "");
    }

    public static String replaceWhitespace(String s, String replacement) {
        return StringUtilities.replaceCharsWithStringsByPattern(s, CharacterPredicates.WHITESPACE_PATTERN, replacement);
    }

    public static String replaceCharsWithStringsByPattern(String s, FunctionInterfaces.UnaryFunctionCharToBoolean charPattern, String replacement) {
        StringBuilder b = new StringBuilder();
        int n = s.length();
        int i = 0;
        while (i < n) {
            char c = s.charAt(i);
            if (charPattern.f(c)) {
                b.append(replacement);
            } else {
                b.append(c);
            }
            ++i;
        }
        return b.toString();
    }

    public static String filterString(FunctionInterfaces.UnaryFunctionCharToBoolean predicate, String s) {
        return new String(ArrayUtilities.filterArray(predicate, s.toCharArray()));
    }

    public static String filterAwayWhitespace(String s) {
        return StringUtilities.filterString(CharacterPredicates.WHITESPACE_PATTERN_INVERSE, s);
    }

    public static String filterStringTwoPass(FunctionInterfaces.UnaryFunctionCharToBoolean filterPredicate, String input) {
        int length = input.length();
        int outputSize = 0;
        int i = 0;
        while (i < length) {
            char c = input.charAt(i);
            if (filterPredicate.f(c)) {
                ++outputSize;
            }
            ++i;
        }
        if (outputSize == length) {
            return input;
        }
        char[] output = new char[outputSize];
        int e = 0;
        int i2 = 0;
        while (i2 < length) {
            char c = input.charAt(i2);
            if (filterPredicate.f(c)) {
                output[e] = c;
                ++e;
            }
            ++i2;
        }
        return new String(output);
    }

    public static String canonicalizeOnlyOccurrencesOfCertainString(String string, String substring, FunctionInterfaces.UnaryFunction<String, String> canonicalizer) {
        int nextLocation;
        int n = string.length();
        int nSub = substring.length();
        if (nSub == 0) {
            return string;
        }
        if (nSub > n) {
            return string;
        }
        String stringC = canonicalizer.f(string);
        String substringC = canonicalizer.f(substring);
        assert (stringC.length() == n);
        assert (substringC.length() == nSub);
        boolean first = true;
        int prevLocation = -1;
        StringBuilder b = new StringBuilder();
        while ((nextLocation = stringC.indexOf(substringC, prevLocation + 1)) != -1) {
            if (first) {
                b.append(string, 0, nextLocation);
                first = false;
            } else {
                b.append(string, prevLocation + nSub, nextLocation);
            }
            assert (BasicObjectUtilities.eq((Object)substringC, (Object)canonicalizer.f(string.substring(nextLocation, nextLocation + nSub))));
            b.append(substringC);
            prevLocation = nextLocation;
        }
        if (first) {
            return string;
        }
        b.append(string, prevLocation + nSub, n);
        return b.toString();
    }

    public static int parseIntBase10Unoverloaded(String s) {
        return Integer.parseInt(s);
    }

    public static long parseLongBase10Unoverloaded(String s) {
        return Long.parseLong(s);
    }

    public static String intToStringBase10Unoverloaded(int v) {
        return Integer.toString(v);
    }

    public static String longToStringBase10Unoverloaded(long v) {
        return Long.toString(v);
    }

    public static String toTwoDigitStringWithLeadingZeroPad(long v) {
        boolean negative;
        boolean bl = negative = v < 0L;
        if (v < 10L) {
            return negative ? "-0" + -v : "0" + v;
        }
        return Long.toString(v);
    }

    public static String toThreeDigitStringWithLeadingZeroPad(long v) {
        boolean negative;
        boolean bl = negative = v < 0L;
        if (v < 10L) {
            return negative ? "-00" + -v : "00" + v;
        }
        if (v < 100L) {
            return negative ? "-0" + -v : "0" + v;
        }
        return Long.toString(v);
    }

    public static String zeroPad(long v, int minDigits) {
        return StringUtilities.zeroPad(v, minDigits, false);
    }

    public static String zeroPad(long v, int minDigits, boolean includePlusIfNonnegative) {
        String s = v == Long.MIN_VALUE ? "9223372036854775808" : Long.toString(Math.abs(v));
        String z = StringUtilities.zeroPad(s, minDigits);
        return v < 0L ? String.valueOf('-') + z : (includePlusIfNonnegative ? String.valueOf('+') + z : z);
    }

    public static String zeroPad(String s, int minDigits) {
        int n = minDigits - s.length();
        return n > 0 ? String.valueOf(StringUtilities.mulneg('0', n)) + s : s;
    }

    public static String zpad2(long v) {
        return StringUtilities.toTwoDigitStringWithLeadingZeroPad(v);
    }

    public static String zpad3(long v) {
        return StringUtilities.toThreeDigitStringWithLeadingZeroPad(v);
    }

    public static String zpad(long v, int minDigits) {
        return StringUtilities.zeroPad(v, minDigits);
    }

    public static String zpad(String s, int minDigits) {
        return StringUtilities.zeroPad(s, minDigits);
    }

    public static String szpad(long v, int minDigits) {
        return StringUtilities.zeroPad(v, minDigits, true);
    }

    public static String convertIndentationToTabs(String s) {
        StringBuilder buff = new StringBuilder();
        boolean hasIndentation = false;
        int numberOfSpacesPerIndentLevel = 0;
        boolean first = true;
        String[] stringArray = StringUtilities.splitlines(s);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (first) {
                first = false;
            } else {
                buff.append('\n');
            }
            if (!hasIndentation) {
                if (line.startsWith("\t")) {
                    return s;
                }
                if (line.startsWith(" ")) {
                    numberOfSpacesPerIndentLevel = StringUtilities.countLeading(line, ' ');
                    hasIndentation = true;
                    buff.append('\t');
                    buff.append(line.substring(numberOfSpacesPerIndentLevel));
                } else {
                    buff.append(line);
                }
            } else {
                int numberOfSpacesInThisLine = StringUtilities.countLeading(line, ' ');
                int indentLevel = numberOfSpacesInThisLine / numberOfSpacesPerIndentLevel;
                int i = indentLevel * numberOfSpacesPerIndentLevel;
                StringUtilities.appendMultiple(buff, '\t', indentLevel);
                buff.append(line.substring(i));
            }
            ++n2;
        }
        return buff.toString();
    }

    public static int countLeading(String s, char c) {
        return StringUtilities.countLeadingMatching(s, cc -> cc == c);
    }

    public static int countLeadingMatching(String s, FunctionInterfaces.UnaryFunctionCharToBoolean predicate) {
        int i;
        for (i = 0; i < s.length() && predicate.f(s.charAt(i)); ++i) {
        }
        return i;
    }

    public static List<Object> parseLenientSemanticIndentationToNewCompletely(String lines) throws TextSyntaxCheckedException {
        return StringUtilities.parseLenientSemanticIndentationToNew(CollectionUtilities.asList(StringUtilities.splitlines(lines)));
    }

    public static List<Object> parseLenientSemanticIndentationToNew(List<String> lines) throws TextSyntaxCheckedException {
        ArrayList<Object> blocksAndLines = new ArrayList<Object>();
        PLSIrv r = StringUtilities.parseLenientSemanticIndentation(lines, blocksAndLines);
        if (r.lineIndexWeStoppedAt < lines.size()) {
            if (!lines.get(r.lineIndexWeStoppedAt).startsWith(r.indentation)) {
                throw TextSyntaxCheckedException.inst("Illegal de-indent!");
            }
            throw new AssertionError();
        }
        if (r.lineIndexWeStoppedAt < lines.size()) {
            throw new AssertionError();
        }
        return blocksAndLines;
    }

    public static PLSIrv parseLenientSemanticIndentation(List<String> lines, List<Object> output) throws TextSyntaxCheckedException {
        if (lines.isEmpty()) {
            PLSIrv rv = new PLSIrv();
            rv.lineIndexWeStoppedAt = 0;
            rv.indentation = "";
            return rv;
        }
        String l0 = lines.get(0);
        int i = StringUtilities.indexOf((CharSequence)l0, (char c) -> !Character.isWhitespace(c));
        int end = i == -1 ? l0.length() : i;
        String indentation = l0.substring(0, end);
        int i2 = 0;
        String lastIndentation = null;
        while (i2 < lines.size()) {
            String bareline = lines.get(i2);
            if (!bareline.startsWith(indentation)) {
                PLSIrv rv = new PLSIrv();
                rv.lineIndexWeStoppedAt = i2;
                rv.indentation = indentation;
                return rv;
            }
            String line = bareline.substring(indentation.length());
            if (line.isEmpty() || !Character.isWhitespace(line.charAt(0))) {
                output.add(line);
                ++i2;
                continue;
            }
            ArrayList<Object> o = new ArrayList<Object>();
            PLSIrv r = StringUtilities.parseLenientSemanticIndentation(lines.subList(i2, lines.size()), o);
            if (lastIndentation != null && !BasicObjectUtilities.eq(lastIndentation, (Object)r.indentation)) {
                throw TextSyntaxCheckedException.inst("Illegal de-indent!");
            }
            assert (output.isEmpty() || output.get(output.size() - 1) instanceof String);
            i2 += r.lineIndexWeStoppedAt;
            lastIndentation = r.indentation;
            output.add(o);
        }
        PLSIrv rv = new PLSIrv();
        rv.lineIndexWeStoppedAt = lines.size();
        rv.indentation = indentation;
        return rv;
    }

    public static String reconstituteSemanticIndentationBlocks(List<Object> blocksAndLines, String baseIndentation, String indent) {
        return StringUtilities.joinlines(StringUtilities.reconstituteSemanticIndentationBlocksToLines(blocksAndLines, baseIndentation, indent));
    }

    public static List<String> reconstituteSemanticIndentationBlocksToLines(List<Object> blocksAndLines, String baseIndentation, String indent) {
        ArrayList<String> lines = new ArrayList<String>();
        StringUtilities.reconstituteSemanticIndentationBlocksToLines(blocksAndLines, baseIndentation, indent, lines);
        return lines;
    }

    public static void reconstituteSemanticIndentationBlocksToLines(List<Object> blocksAndLines, String baseIndentation, String indent, @WritableValue List<String> output) {
        for (Object l : blocksAndLines) {
            if (l instanceof String) {
                output.add(String.valueOf(baseIndentation) + l);
                continue;
            }
            StringUtilities.reconstituteSemanticIndentationBlocksToLines((List)l, String.valueOf(baseIndentation) + indent, indent, output);
        }
    }

    public static String getIndentation(String line) {
        int i = CollectionUtilities.findFirstIndex(c -> !Character.isWhitespace(c), line);
        return line.substring(0, i);
    }

    public static String getIndentationFromFirstLine(String s) {
        int i = CollectionUtilities.findFirstIndex(c -> !Character.isWhitespace(c) || c == '\n' || c == '\r', s);
        return s.substring(0, i);
    }

    public static String removeCommonLeadingIndentationAndSurroundingBlankLines(String s) {
        s = StringUtilities.rtrim(s);
        StringBuilder b = new StringBuilder();
        String indent = null;
        String[] stringArray = StringUtilities.splitlines(s);
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (indent == null) {
                if (!line.trim().isEmpty()) {
                    int i = CollectionUtilities.findFirstIndex(c -> !Character.isWhitespace(c), line);
                    if (i == -1) {
                        i = 0;
                    }
                    indent = line.substring(0, i);
                    b.append(line.substring(i));
                    b.append('\n');
                }
            } else {
                b.append(StringUtilities.ltrimstr(line, indent));
                b.append('\n');
            }
            ++n2;
        }
        return b.toString();
    }

    public static Charset getExplicitEndiannessEncodingIfNeeded(Charset encoding) {
        return StringUtilities.getExplicitEndiannessEncodingIfNeeded(encoding, Endianness.nativeByteEndianness());
    }

    public static Charset getExplicitEndiannessEncodingIfNeeded(Charset encoding, Endianness endianness) {
        Objects.requireNonNull(encoding);
        Objects.requireNonNull(endianness);
        if (BasicObjectUtilities.eq((Object)encoding, (Object)StandardCharsets.UTF_16)) {
            return endianness == Endianness.Little ? StandardCharsets.UTF_16LE : StandardCharsets.UTF_16BE;
        }
        return encoding;
    }

    public static boolean containsZeroChar(String s) {
        int n = s.length();
        int i = 0;
        while (i < n) {
            if (s.charAt(i) == '\u0000') {
                return true;
            }
            ++i;
        }
        return false;
    }

    @PossiblySnapshotPossiblyLiveValue
    public static List<String> clipSurroundingEmptyLinesOPC(List<String> lines) {
        return CollectionUtilities.filterMiddleToList(l -> !l.trim().isEmpty(), lines);
    }

    @Nullable
    public static PairOrdered<String, Integer> parseTrailingNonnegativeIntegerOrReturnNull(String s) {
        int i;
        int beforeStart = StringUtilities.lastIndexOf((CharSequence)s, (char c) -> c < '0' || c > '9');
        if (beforeStart == s.length() - 1) {
            return null;
        }
        int start = beforeStart + 1;
        String pre = s.substring(0, start);
        String post = s.substring(start);
        try {
            i = Integer.parseInt(post);
        }
        catch (NumberFormatException exc) {
            throw new ImpossibleException(exc);
        }
        return new PairOrderedImmutable<String, Integer>(pre, i);
    }

    public static void appendln(Appendable a, String s) throws IOException {
        a.append(s);
        a.append('\n');
    }

    public static void appendln(StringBuilder a, String s) {
        a.append(s);
        a.append('\n');
    }

    public static void appendln(StringBuffer a, String s) {
        a.append(s);
        a.append('\n');
    }

    public static void appendln(Appendable a) throws IOException {
        a.append('\n');
    }

    public static void appendln(StringBuilder a) {
        a.append('\n');
    }

    public static void appendln(StringBuffer a) {
        a.append('\n');
    }

    public static String trimIfNotNull(String s) {
        return s == null ? null : s.trim();
    }

    public static int indexOf(String source, int sourceOffset, int sourceCount, String target, int targetOffset, int targetCount, int fromIndex) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        int i = sourceOffset + fromIndex;
        while (i <= max) {
            if (source.charAt(i) != first) {
                while (++i <= max && source.charAt(i) != first) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = targetOffset + 1;
                while (j < end && source.charAt(j) == target.charAt(k)) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i - sourceOffset;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(String source, int sourceOffset, int sourceCount, String target, int targetOffset, int targetCount, int fromIndex, FunctionInterfaces.CharEqualityComparator ceq) {
        if (fromIndex >= sourceCount) {
            return targetCount == 0 ? sourceCount : -1;
        }
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (targetCount == 0) {
            return fromIndex;
        }
        char first = target.charAt(targetOffset);
        int max = sourceOffset + (sourceCount - targetCount);
        int i = sourceOffset + fromIndex;
        while (i <= max) {
            if (!ceq.charsEqual(source.charAt(i), first)) {
                while (++i <= max && !ceq.charsEqual(source.charAt(i), first)) {
                }
            }
            if (i <= max) {
                int j = i + 1;
                int end = j + targetCount - 1;
                int k = targetOffset + 1;
                while (j < end && ceq.charsEqual(source.charAt(j), target.charAt(k))) {
                    ++j;
                    ++k;
                }
                if (j == end) {
                    return i - sourceOffset;
                }
            }
            ++i;
        }
        return -1;
    }

    public static int indexOfCaseInsensitive(String string, String substring, int fromIndex) {
        return StringUtilities.indexOf(string, 0, string.length(), substring, 0, substring.length(), fromIndex, StringUtilities::charsEqualCaseInsensitive);
    }

    public static int indexOfCaseInsensitive(String string, String substring) {
        return StringUtilities.indexOfCaseInsensitive(string, substring, 0);
    }

    public static boolean containsCaseInsensitive(String string, String substring) {
        return StringUtilities.indexOfCaseInsensitive(string, substring) != -1;
    }

    public static boolean charsEqualCaseInsensitive(char a, char b) {
        return Character.toLowerCase(a) == Character.toLowerCase(b) && Character.toUpperCase(a) == Character.toUpperCase(b);
    }

    public static List<String> splitBeforeEachChar(String s, FunctionInterfaces.UnaryFunctionCharToBoolean pattern) {
        ArrayList<String> r = new ArrayList<String>();
        if (!s.isEmpty()) {
            int last = 0;
            int n = s.length();
            int i = 0;
            while (i < n) {
                char c = s.charAt(i);
                if (pattern.f(c) && i > 0) {
                    r.add(s.substring(last, i));
                    last = i;
                }
                ++i;
            }
            r.add(s.substring(last, n));
        }
        return r;
    }

    public static boolean containsNT(@Nullable String container, @Nullable String containee) {
        if (container == null || containee == null) {
            return false;
        }
        return container.contains(containee);
    }

    public static <T extends CharSequence> T requireNonEmpty(@NonnullKeys T s) {
        if (s.length() <= 0) {
            throw new IllegalArgumentException();
        }
        return s;
    }

    public static <I> String mapToString(Mapper<I, Character> mapper, SimpleIterator<I> input) {
        StringBuilder b = new StringBuilder();
        while (true) {
            char o;
            I i;
            try {
                i = input.nextrp();
            }
            catch (StopIterationReturnPath exc) {
                break;
            }
            try {
                o = mapper.f(i).charValue();
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            b.append(o);
        }
        return b.toString();
    }

    public static <I> String mapToString(Mapper<I, Character> mapper, Iterable<I> input) {
        return StringUtilities.mapToString(mapper, SimpleIterator.simpleIterator(input));
    }

    public static <I> String mapToStringConcatenating(Mapper<I, ? extends CharSequence> mapper, SimpleIterator<I> input) {
        StringBuilder b = new StringBuilder();
        while (true) {
            CharSequence o;
            I i;
            try {
                i = input.nextrp();
            }
            catch (StopIterationReturnPath exc) {
                break;
            }
            try {
                o = mapper.f(i);
            }
            catch (FilterAwayReturnPath exc) {
                continue;
            }
            b.append(o);
        }
        return b.toString();
    }

    public static <I> String mapToStringConcatenating(Mapper<I, ? extends CharSequence> mapper, Iterable<I> input) {
        return StringUtilities.mapToStringConcatenating(mapper, SimpleIterator.simpleIterator(input));
    }

    public static String mapToStringConcatenating(Mapper<Character, ? extends CharSequence> mapper, CharSequence input) {
        return StringUtilities.mapToStringConcatenating(mapper, StringUtilities.simpleIteratorChars(input));
    }

    public static SimpleIterator<Character> simpleIteratorChars(final CharSequence x) {
        return new SimpleIterator<Character>(){
            int i = 0;

            @Override
            public Character nextrp() throws StopIterationReturnPath {
                int i = this.i;
                if (i >= x.length()) {
                    throw StopIterationReturnPath.I;
                }
                this.i = i + 1;
                return Character.valueOf(x.charAt(i));
            }
        };
    }

    public static void forEach(FunctionInterfaces.UnaryProcedureChar observer, CharSequence input) {
        int n = input.length();
        int i = 0;
        while (i < n) {
            observer.f(input.charAt(i));
            ++i;
        }
    }

    @Nullable
    public static Integer binarySearchString(FunctionInterfaces.UnaryFunctionCharToObject<Direction1D> predicate, CharSequence list) {
        return MathUtilities.binarySearchS32(i -> (Direction1D)((Object)((Object)predicate.f(list.charAt(i)))), 0, list.length());
    }

    public static String listToString(List<Character> list) {
        if (list instanceof PrimitiveCollections.CharacterList) {
            return StringUtilities.sliceToString(((PrimitiveCollections.CharacterList)list).toCharArraySlicePossiblyLive());
        }
        return StringUtilities.mapToString((I c) -> c, list);
    }

    public static String sliceToString(Slice<char[]> slice) {
        return new String(slice.getUnderlying(), slice.getOffset(), slice.getLength());
    }

    public static String newString(List<Character> list) {
        return StringUtilities.listToString(list);
    }

    public static String newString(Slice<char[]> slice) {
        return StringUtilities.sliceToString(slice);
    }

    public static boolean ifStartsWithThenTrimAndDo(String string, String prefixCandidate, FunctionInterfaces.UnaryProcedure<String> action) {
        String v = StringUtilities.ltrimstrOrNull(string, prefixCandidate);
        if (v != null) {
            action.f(v);
            return true;
        }
        return false;
    }

    public static boolean startsWithWhitespace(String string) {
        return !string.isEmpty() && Character.isWhitespace(string.charAt(0));
    }

    public static boolean endsWithWhitespace(String string) {
        return !string.isEmpty() && Character.isWhitespace(string.charAt(string.length() - 1));
    }

    @Nonnull
    public static String emptyStringIfNull(@Nullable String x) {
        return x == null ? "" : x;
    }

    public static List<String> mapTrimmingAndFilteringAwayEmpties(Iterable<String> strs) {
        return CollectionUtilities.mapToList(s -> {
            if ((s = s.trim()).isEmpty()) {
                throw FilterAwayReturnPath.I;
            }
            return s;
        }, strs);
    }

    public static Set<String> mapTrimmingAndFilteringAwayEmptiesToSet(Iterable<String> strs) {
        return CollectionUtilities.mapToSet(s -> {
            if ((s = s.trim()).isEmpty()) {
                throw FilterAwayReturnPath.I;
            }
            return s;
        }, strs);
    }

    public static int cmpCaseInsensitively(String a, String b) {
        if (a == null || b == null) {
            return BasicObjectUtilities.cmp2(a, b);
        }
        return a.compareToIgnoreCase(b);
    }

    public static int codePointAt(CharSequence s, int index) {
        char c2;
        if (s instanceof String) {
            return ((String)s).codePointAt(index);
        }
        int limit = s.length();
        char c1 = s.charAt(index);
        if (Character.isHighSurrogate(c1) && ++index < limit && Character.isLowSurrogate(c2 = s.charAt(index))) {
            return Character.toCodePoint(c1, c2);
        }
        return c1;
    }

    public static int lengthInCodePoints(CharSequence s) {
        return BitfieldSafeCasts.safeCastS64toS32(s.codePoints().count());
    }

    public static enum CaseSensitivity {
        CaseSensitive,
        CaseINsensitive;

    }

    public static interface CharArrayableCharSequence
    extends CharSequence {
        public char[] toCharArray();

        public void copyIntoCharArray(int var1, char[] var2, int var3, int var4);
    }

    public static class NoStringToRemoveReturnPath
    extends ReturnPath.SingletonReturnPath {
        private static final long serialVersionUID = 1L;
        public static final NoStringToRemoveReturnPath I = new NoStringToRemoveReturnPath();

        protected NoStringToRemoveReturnPath() {
        }

        @Override
        public NoStringToRemoveException toException() {
            return new NoStringToRemoveException();
        }

        public static class NoStringToRemoveException
        extends RuntimeException {
            private static final long serialVersionUID = 1L;

            public NoStringToRemoveException() {
            }

            public NoStringToRemoveException(String message) {
                super(message);
            }

            public NoStringToRemoveException(Throwable cause) {
                super(cause);
            }

            public NoStringToRemoveException(String message, Throwable cause) {
                super(message, cause);
            }
        }
    }

    public static class PLSIrv {
        public int lineIndexWeStoppedAt;
        public String indentation;
    }

    public static class RPBasicNaiveParsingSyntaxDescription<SyntaxIdType, StateIdType>
    implements RPBasicNaiveParsingSyntaxElement {
        public SyntaxIdType id;
        public RPBasicNaiveParsingSyntaxStateDescription<StateIdType> initialState;

        @Override
        public RPBasicNaiveParsingSyntaxDescription<SyntaxIdType, StateIdType> deriveWithAddedTransitions(Map<CharacterPredicates.NaiveCharacterSequencePattern, RPBasicNaiveParsingSyntaxElement> extraTransitions) {
            RPBasicNaiveParsingSyntaxDescription<SyntaxIdType, StateIdType> derived = new RPBasicNaiveParsingSyntaxDescription<SyntaxIdType, StateIdType>();
            derived.id = this.id;
            derived.initialState = this.initialState.deriveWithAddedTransitions((Map)extraTransitions);
            return derived;
        }

        public static class RPBasicNaiveParsingSyntaxStateDescription<StateIdType>
        implements RPBasicNaiveParsingSyntaxElement {
            public StateIdType id;
            public Map<CharacterPredicates.NaiveCharacterSequencePattern, RPBasicNaiveParsingSyntaxElement> transitions;

            @Override
            public RPBasicNaiveParsingSyntaxStateDescription<StateIdType> deriveWithAddedTransitions(Map<CharacterPredicates.NaiveCharacterSequencePattern, RPBasicNaiveParsingSyntaxElement> extraTransitions) {
                RPBasicNaiveParsingSyntaxStateDescription<StateIdType> derived = new RPBasicNaiveParsingSyntaxStateDescription<StateIdType>();
                derived.id = this.id;
                derived.transitions = ObjectUtilities.attemptClone(this.transitions);
                derived.transitions.putAll(extraTransitions);
                return derived;
            }
        }
    }

    public static interface RPBasicNaiveParsingSyntaxElement {
        public RPBasicNaiveParsingSyntaxElement deriveWithAddedTransitions(Map<CharacterPredicates.NaiveCharacterSequencePattern, RPBasicNaiveParsingSyntaxElement> var1);
    }

    public static abstract class RPBasicParsedElementElement {
        public char[] source;
        public int start;
        public int length;

        public String toString() {
            return new String(this.source, this.start, this.length);
        }

        public static abstract class RPBasicParsedElementElement_Chunk {
            public RPBasicNaiveParsingSyntaxDescription syntax;
            public RPBasicNaiveParsingSyntaxDescription.RPBasicNaiveParsingSyntaxStateDescription state;
        }

        public static abstract class RPBasicParsedElementElement_Embed {
            public RPBasicNaiveParsingSyntaxDescription syntax;
        }
    }

    public static abstract class Replacement {
        protected int start;
        protected int end;

        public Replacement() {
        }

        public Replacement(int start, int end) {
            this.start = start;
            this.end = end;
        }

        public int getStart() {
            return this.start;
        }

        public void setStart(int start) {
            this.start = start;
        }

        public int getEnd() {
            return this.end;
        }

        public void setEnd(int end) {
            this.end = end;
        }

        public abstract void write(Writer var1) throws IOException;
    }

    public static interface ReplacementBoss {
        public String whatDoBoss(int var1, String var2);
    }

    @SignalType
    public static interface Reprable {
        default public String reprThis() {
            return this.toString();
        }
    }

    public static class StaticReplacement
    extends Replacement {
        protected String replacement;

        public StaticReplacement() {
        }

        public StaticReplacement(int start, int end, String replacement) {
            this.start = start;
            this.end = end;
            this.replacement = replacement;
        }

        public String getReplacement() {
            return this.replacement;
        }

        public void setReplacement(String replacement) {
            this.replacement = replacement;
        }

        @Override
        public void write(Writer out) throws IOException {
            String r = this.getReplacement();
            if (r != null) {
                out.write(r);
            }
        }
    }

    public static interface StringScanner {
        @Nullable
        public Interval findNextOrNullIfNone(@Nonnull String var1, int var2);
    }

    public static class TransparentArraySharingCharSequence
    implements CharSequence {
        public char[] source;
        public int offset;
        public int length;

        public TransparentArraySharingCharSequence() {
        }

        public TransparentArraySharingCharSequence(char[] source) {
            this(source, 0, source.length);
        }

        public TransparentArraySharingCharSequence(char[] source, int offset, int length) {
            this.source = source;
            this.offset = offset;
            this.length = length;
        }

        @Override
        public char charAt(int index) {
            return this.source[this.offset + index];
        }

        @Override
        public int length() {
            return this.length == -1 ? this.source.length - this.offset : this.length;
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new TransparentArraySharingCharSequence(this.source, start + this.offset, end - start);
        }

        @Override
        public String toString() {
            return new String(this.source, this.offset, this.length);
        }
    }

    public static enum WhatToDoWithEmpties {
        LeaveInEmpties,
        LeaveOutEmpties;

    }
}

