/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.ui.gui.edos;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.FileImageOutputStream;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import rebound.concurrency.threads.Scheduler;
import rebound.hci.graphics2d.gui.awt.components.ExtJFCFileFilter;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.blk.FromBLKConverter;
import rebound.jagent.lib.blk.ToBLKConverter;
import rebound.jagent.lib.c16.FromC16Converter;
import rebound.jagent.lib.c16.ToC16Converter;
import rebound.jagent.lib.s16.FromS16Converter;
import rebound.jagent.lib.s16.ToS16Converter;
import rebound.jagent.ui.gui.edos.EdosApplicationCoordinator;
import rebound.jagent.ui.gui.edos.EdosDiplomat;
import rebound.jagent.ui.gui.edos.ExportContactSheetDialog;
import rebound.jagent.ui.gui.edos.ExportSetDialog;
import rebound.jagent.ui.gui.edos.sedpane.MemoryImageStorage;
import rebound.jagent.ui.gui.edos.sedpane.Sedpane;
import rebound.jagent.ui.gui.edos.sedpane.SedpaneImageMutationListener;
import rebound.text.CharacterPredicates;
import rebound.text.IndependentCursor;
import rebound.text.StringUtilities;

public class EdosWindow
extends JFrame {
    public static final long DEFAULT_STATUS_CLEAR_DELAY = 3000L;
    public static final boolean UseAboutMenuItem = !EdosApplicationCoordinator.AppleJavaExtentionsPresent;
    public static final boolean UseQuitMenuItem = !EdosApplicationCoordinator.AppleJavaExtentionsPresent;
    protected EdosApplicationCoordinator edosApplicationCoordinator;
    protected boolean addAtSelection = true;
    protected JPanel pane;
    protected Sedpane sedpane;
    protected JLabel statusLabel;
    protected JMenuBar mnu;
    protected JMenu mnuFile;
    protected JMenu mnuEdit;
    protected JMenu mnuHelp;
    protected JMenuItem mnuFileNew;
    protected JMenuItem mnuFileSave;
    protected JMenuItem mnuFileOpen;
    protected JMenuItem mnuFileClose;
    protected JMenuItem mnuFileQuit;
    protected JMenuItem mnuFileImport;
    protected JMenuItem mnuFileImportSet;
    protected JMenuItem mnuFileImportContactSheet;
    protected JMenuItem mnuFileExport;
    protected JMenuItem mnuFileExportSet;
    protected JMenuItem mnuFileExportContactSheet;
    protected JMenuItem mnuEditClearAll;
    protected JCheckBoxMenuItem mnuEdit565;
    protected JCheckBoxMenuItem mnuEditTransparencyEmulation;
    protected JMenuItem mnuHelpAbout;
    protected Color statusInfoColor = Color.blue;
    protected Color statusErrorColor = Color.red.darker();
    protected Scheduler statusClearer = new Scheduler();
    protected long statusClearDelay = 3000L;
    protected JFileChooser spriteJFC;
    protected JFileChooser imageJFC;
    protected JFileChooser singletonImageJFC;
    protected ExportSetDialog exportSetDialog;
    protected ExportContactSheetDialog exportContactSheetDialog;

    public EdosWindow() {
        super("Edos");
        this.setJMenuBar(this.getMnu());
        this.setSize(500, 500);
        this.setDefaultCloseOperation(0);
        this.doLayout();
        this.setContentPane(this.getPane());
        this.clearStatusText();
    }

    public JPanel getPane() {
        if (this.pane == null) {
            this.pane = new JPanel(true){

                @Override
                public void doLayout() {
                    super.doLayout();
                    int width = this.getWidth();
                    int height = this.getHeight();
                    EdosWindow.this.getSedpane().setSize(width, height - 20);
                    EdosWindow.this.getSedpane().setLocation(0, 0);
                    EdosWindow.this.getStatusLabel().setSize(width, 20);
                    EdosWindow.this.getStatusLabel().setLocation(0, height - 20);
                }
            };
            this.pane.add(this.getSedpane());
            this.pane.add(this.getStatusLabel());
        }
        return this.pane;
    }

    public Sedpane getSedpane() {
        if (this.sedpane == null) {
            this.sedpane = new Sedpane();
            this.sedpane.setImageStorage(new MemoryImageStorage());
            this.sedpane.setDnDiplomat(new EdosDiplomat(this));
            this.sedpane.setImageMutationListener(new SedpaneImageMutationListener(){

                @Override
                public void imagesReordered(int source, int dest) {
                    EdosWindow.this.clearStatusText();
                }

                @Override
                public void imagesCleared() {
                    EdosWindow.this.clearStatusText();
                }

                @Override
                public void imageDeleted(int index) {
                    EdosWindow.this.clearStatusText();
                }

                @Override
                public void imageAdded(int index) {
                }
            });
            this.addKeyListener(this.sedpane);
        }
        return this.sedpane;
    }

    public JLabel getStatusLabel() {
        if (this.statusLabel == null) {
            this.statusLabel = new JLabel();
            this.statusLabel.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    EdosWindow.this.clearStatusText();
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }
            });
        }
        return this.statusLabel;
    }

    public JMenuBar getMnu() {
        if (this.mnu == null) {
            this.mnu = new JMenuBar();
            this.mnu.add(this.getMnuFile());
            this.mnu.add(this.getMnuEdit());
            if (UseAboutMenuItem) {
                this.mnu.add(this.getMnuHelp());
            }
        }
        return this.mnu;
    }

    public JMenu getMnuFile() {
        if (this.mnuFile == null) {
            this.mnuFile = new JMenu("File");
            this.mnuFile.add(this.getMnuFileNew());
            this.mnuFile.add(this.getMnuFileOpen());
            this.mnuFile.add(this.getMnuFileSave());
            this.mnuFile.add(this.getMnuFileImport());
            this.mnuFile.add(this.getMnuFileExport());
            this.mnuFile.add(this.getMnuFileImportSet());
            this.mnuFile.add(this.getMnuFileExportSet());
            this.mnuFile.add(this.getMnuFileImportContactSheet());
            this.mnuFile.add(this.getMnuFileExportContactSheet());
            this.mnuFile.add(this.getMnuFileClose());
            if (UseQuitMenuItem) {
                this.mnuFile.add(this.getMnuFileQuit());
            }
        }
        return this.mnuFile;
    }

    public JMenuItem getMnuFileNew() {
        if (this.mnuFileNew == null) {
            this.mnuFileNew = new JMenuItem("New");
            this.mnuFileNew.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileNew.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.newClicked();
                }
            });
        }
        return this.mnuFileNew;
    }

    public JMenuItem getMnuFileOpen() {
        if (this.mnuFileOpen == null) {
            this.mnuFileOpen = new JMenuItem("Open");
            this.mnuFileOpen.setAccelerator(KeyStroke.getKeyStroke(79, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileOpen.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.openClicked();
                }
            });
        }
        return this.mnuFileOpen;
    }

    public JMenuItem getMnuFileSave() {
        if (this.mnuFileSave == null) {
            this.mnuFileSave = new JMenuItem("Save");
            this.mnuFileSave.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.saveClicked();
                }
            });
        }
        return this.mnuFileSave;
    }

    public JMenuItem getMnuFileImport() {
        if (this.mnuFileImport == null) {
            this.mnuFileImport = new JMenuItem("Import Images");
            this.mnuFileImport.setAccelerator(KeyStroke.getKeyStroke(73, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileImport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.importImageClicked();
                }
            });
        }
        return this.mnuFileImport;
    }

    public JMenuItem getMnuFileImportSet() {
        if (this.mnuFileImportSet == null) {
            this.mnuFileImportSet = new JMenuItem("Import Set");
            this.mnuFileImportSet.setAccelerator(KeyStroke.getKeyStroke(73, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileImportSet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.importSetClicked();
                }
            });
        }
        return this.mnuFileImportSet;
    }

    public JMenuItem getMnuFileImportContactSheet() {
        if (this.mnuFileImportContactSheet == null) {
            this.mnuFileImportContactSheet = new JMenuItem("Import Contact Sheet");
            this.mnuFileImportContactSheet.setAccelerator(KeyStroke.getKeyStroke(73, 0x200 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileImportContactSheet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.importContactSheetClicked();
                }
            });
        }
        return this.mnuFileImportContactSheet;
    }

    public JMenuItem getMnuFileExport() {
        if (this.mnuFileExport == null) {
            this.mnuFileExport = new JMenuItem("Export Selected Image");
            this.mnuFileExport.setAccelerator(KeyStroke.getKeyStroke(69, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileExport.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.exportImageClicked();
                }
            });
        }
        return this.mnuFileExport;
    }

    public JMenuItem getMnuFileExportSet() {
        if (this.mnuFileExportSet == null) {
            this.mnuFileExportSet = new JMenuItem("Export Set");
            this.mnuFileExportSet.setAccelerator(KeyStroke.getKeyStroke(69, 0x40 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileExportSet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.exportSetClicked();
                }
            });
        }
        return this.mnuFileExportSet;
    }

    public JMenuItem getMnuFileExportContactSheet() {
        if (this.mnuFileExportContactSheet == null) {
            this.mnuFileExportContactSheet = new JMenuItem("Export Contact Sheet");
            this.mnuFileExportContactSheet.setAccelerator(KeyStroke.getKeyStroke(69, 0x200 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileExportContactSheet.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.exportContactSheetClicked();
                }
            });
        }
        return this.mnuFileExportContactSheet;
    }

    public JMenuItem getMnuFileClose() {
        if (this.mnuFileClose == null) {
            this.mnuFileClose = new JMenuItem("Close window");
            this.mnuFileClose.setAccelerator(KeyStroke.getKeyStroke(87, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.closeClicked();
                }
            });
        }
        return this.mnuFileClose;
    }

    public JMenuItem getMnuFileQuit() {
        if (this.mnuFileQuit == null) {
            this.mnuFileQuit = new JMenuItem("Quit");
            this.mnuFileQuit.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuFileQuit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.quitClicked();
                }
            });
        }
        return this.mnuFileQuit;
    }

    public JMenu getMnuEdit() {
        if (this.mnuEdit == null) {
            this.mnuEdit = new JMenu("Edit");
            this.mnuEdit.add(this.getMnuEditClearAll());
            this.mnuEdit.add(this.getMnuEdit565());
            this.mnuEdit.add(this.getMnuEditTransparencyEmulation());
        }
        return this.mnuEdit;
    }

    public JCheckBoxMenuItem getMnuEdit565() {
        if (this.mnuEdit565 == null) {
            this.mnuEdit565 = new JCheckBoxMenuItem("565 Mode?");
            this.mnuEdit565.setSelected(true);
            this.mnuEdit565.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EdosWindow.this.clearStatusText();
                }
            });
        }
        return this.mnuEdit565;
    }

    public JCheckBoxMenuItem getMnuEditTransparencyEmulation() {
        if (this.mnuEditTransparencyEmulation == null) {
            this.mnuEditTransparencyEmulation = new JCheckBoxMenuItem("Transparency emulation (pure black)?");
            this.mnuEditTransparencyEmulation.setSelected(false);
            this.mnuEditTransparencyEmulation.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    EdosWindow.this.clearStatusText();
                }
            });
        }
        return this.mnuEditTransparencyEmulation;
    }

    public JMenuItem getMnuEditClearAll() {
        if (this.mnuEditClearAll == null) {
            this.mnuEditClearAll = new JMenuItem("Clear All");
            this.mnuEditClearAll.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.clearAllClicked();
                }
            });
        }
        return this.mnuEditClearAll;
    }

    public JMenu getMnuHelp() {
        if (this.mnuHelp == null) {
            this.mnuHelp = new JMenu("Help");
            this.mnuHelp.add(this.getMnuHelpAbout());
        }
        return this.mnuHelp;
    }

    public JMenuItem getMnuHelpAbout() {
        if (this.mnuHelpAbout == null) {
            this.mnuHelpAbout = new JMenuItem("About");
            this.mnuHelpAbout.setAccelerator(KeyStroke.getKeyStroke(112, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
            this.mnuHelpAbout.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    EdosWindow.this.aboutClicked();
                }
            });
        }
        return this.mnuHelpAbout;
    }

    public JFileChooser getSpriteFileChooser() {
        if (this.spriteJFC == null) {
            this.spriteJFC = new JFileChooser();
            this.spriteJFC.setAcceptAllFileFilterUsed(true);
            this.spriteJFC.addChoosableFileFilter(new ExtJFCFileFilter("Meta-Room background", "blk"));
            this.spriteJFC.addChoosableFileFilter(new ExtJFCFileFilter("Uncompressed Sprite File", "s16"));
            this.spriteJFC.addChoosableFileFilter(new ExtJFCFileFilter("Compressed Sprite File", "c16"));
            this.spriteJFC.addChoosableFileFilter(new ExtJFCFileFilter("All Creatures Graphics Files", "c16", "s16", "blk"));
        }
        return this.spriteJFC;
    }

    public JFileChooser getImageFileChooser() {
        if (this.imageJFC == null) {
            this.imageJFC = new JFileChooser();
            this.imageJFC.setMultiSelectionEnabled(true);
            this.imageJFC.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File f) {
                    return !f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Most image files";
                }
            });
        }
        return this.imageJFC;
    }

    public JFileChooser getSingletonImageFileChooser() {
        if (this.singletonImageJFC == null) {
            this.singletonImageJFC = new JFileChooser();
            this.singletonImageJFC.setMultiSelectionEnabled(false);
            this.singletonImageJFC.addChoosableFileFilter(new javax.swing.filechooser.FileFilter(){

                @Override
                public boolean accept(File f) {
                    return !f.isDirectory();
                }

                @Override
                public String getDescription() {
                    return "Most image files";
                }
            });
        }
        return this.singletonImageJFC;
    }

    public ExportSetDialog getExportSetDialog() {
        if (this.exportSetDialog == null) {
            this.exportSetDialog = new ExportSetDialog();
            this.exportSetDialog.setCallback(this);
        }
        return this.exportSetDialog;
    }

    public ExportContactSheetDialog getExportContactSheetDialog() {
        if (this.exportContactSheetDialog == null) {
            this.exportContactSheetDialog = new ExportContactSheetDialog();
            this.exportContactSheetDialog.setCallback(this);
        }
        return this.exportContactSheetDialog;
    }

    public synchronized void newClicked() {
        this.getApplicationCoordinator().newWindow();
    }

    public synchronized void saveClicked() {
        if (this.getSpriteFileChooser().showSaveDialog(null) == 0) {
            this.saveSafe(this.getSpriteFileChooser().getSelectedFile());
        }
    }

    public synchronized void saveSafe(File f) {
        try {
            this.save(f);
        }
        catch (IOException exc) {
            JOptionPane.showMessageDialog(null, "An error has occurred during writing of this file, here's a message: " + exc.getMessage(), "!", 0);
        }
    }

    public synchronized void openClicked() {
        this.repaint();
        this.getMnu().repaint();
        this.getMnuFile().repaint();
        this.getMnuFileOpen().repaint();
        if (this.getSpriteFileChooser().showOpenDialog(null) == 0) {
            this.openSafe(this.getSpriteFileChooser().getSelectedFile());
        }
        this.repaint();
        this.getMnu().repaint();
        this.getMnuFile().repaint();
        this.getMnuFileOpen().repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                EdosWindow.this.repaint();
                EdosWindow.this.getMnu().repaint();
                EdosWindow.this.getMnuFile().repaint();
                EdosWindow.this.getMnuFileOpen().repaint();
            }
        });
    }

    public synchronized void openSafe(File f) {
        try {
            this.open(f);
        }
        catch (FileNotFoundException exc) {
            JOptionPane.showMessageDialog(null, "The file ceased to exist!", "!", 0);
        }
        catch (IOException exc) {
            JOptionPane.showMessageDialog(null, "An error has occurred during opening of this file, here's a message: " + exc.getMessage(), "!", 0);
        }
    }

    public synchronized void importImageClicked() {
        if (this.getImageFileChooser().showOpenDialog(null) == 0) {
            this.importImageSafe(this.getImageFileChooser().getSelectedFiles());
        }
    }

    public synchronized void importImageSafe(File ... f) {
        int index = 0;
        index = this.isAddAtSelection() ? this.getSedpane().getSelectedImageIndex() : this.getSedpane().getImageCount();
        this.importImageSafe(index, f);
    }

    public synchronized void importImageSafe(int index, File ... f) {
        try {
            this.importImages(f, index);
        }
        catch (IOException exc) {
            JOptionPane.showMessageDialog(null, "An error has occurred during writing of this file, here's a message: " + exc.getMessage(), "!", 0);
        }
    }

    public synchronized void exportImageClicked() {
        BufferedImage selectedImage = this.getSelectedImage();
        if (selectedImage != null && this.getImageFileChooser().showSaveDialog(null) == 0) {
            try {
                this.exportImage(this.getImageFileChooser().getSelectedFile(), selectedImage);
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(null, "An error has occurred during writing of this file, here's a message: " + exc.getMessage(), "!", 0);
            }
        }
    }

    public synchronized void importSetClicked() {
        if (this.getSingletonImageFileChooser().showOpenDialog(null) == 0) {
            try {
                int index = 0;
                index = this.isAddAtSelection() ? this.getSedpane().getSelectedImageIndex() : this.getSedpane().getImageCount();
                this.importSet(this.getSingletonImageFileChooser().getSelectedFile(), index);
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(null, "An error has occurred during writing of this file, here's a message: " + exc.getMessage(), "!", 0);
            }
        }
    }

    public synchronized void exportSetClicked() {
        if (this.getSedpane().getImageCount() == 0) {
            this.setErrorText("No images to export.");
        } else {
            this.getExportSetDialog().display();
        }
    }

    public synchronized void importContactSheetClicked() {
        if (this.getSingletonImageFileChooser().showOpenDialog(null) == 0) {
            try {
                int index = 0;
                index = this.isAddAtSelection() ? this.getSedpane().getSelectedImageIndex() : this.getSedpane().getImageCount();
                File file = this.getSingletonImageFileChooser().getSelectedFile();
                String raw = null;
                int tilewidth = 0;
                int tileheight = 0;
                boolean validTileDimensions = false;
                raw = JOptionPane.showInputDialog(null, new String[]{"And what are the tile sizes?", "Example: 100x100"}, "Enter tile size", 3);
                if (raw == null) {
                    return;
                }
                char[] rawdata = raw.toCharArray();
                IndependentCursor cursor = new IndependentCursor();
                while (cursor.getCursor() < rawdata.length && !CharacterPredicates.isDigit(rawdata[cursor.getCursor()], 10)) {
                    cursor.setCursor(cursor.getCursor() + 1);
                }
                tilewidth = (int)StringUtilities.parseBasicNumber(rawdata, 0, rawdata.length, cursor, 10);
                while (cursor.getCursor() < rawdata.length && !CharacterPredicates.isDigit(rawdata[cursor.getCursor()], 10)) {
                    cursor.setCursor(cursor.getCursor() + 1);
                }
                tileheight = (int)StringUtilities.parseBasicNumber(rawdata, 0, rawdata.length, cursor, 10);
                validTileDimensions = tilewidth != 0 && tileheight != 0;
                if (!validTileDimensions) {
                    this.popupError("Sorry, but " + raw + " are invalid dimensions.");
                    return;
                }
                this.importContactSheet(file, index, tilewidth, tileheight);
            }
            catch (IOException exc) {
                this.popupError("An error has occurred during writing of this file, here's a message: " + exc.getMessage());
            }
        }
    }

    public synchronized void exportContactSheetClicked() {
        if (this.getSedpane().getImageCount() == 0) {
            this.setErrorText("No images to export.");
        } else {
            boolean allSameSize = false;
            allSameSize = true;
            int width = 0;
            int height = 0;
            boolean dimensionsSet = false;
            int i = 0;
            while (i < this.getSedpane().getImageCount()) {
                BufferedImage image = this.getSedpane().getImageStorage().load(i);
                if (!dimensionsSet) {
                    width = image.getWidth();
                    height = image.getHeight();
                    dimensionsSet = true;
                } else if (width != image.getWidth() || height != image.getHeight()) {
                    allSameSize = false;
                    break;
                }
                ++i;
            }
            if (!allSameSize) {
                this.popupError("Cannot export sheet: not all images are the same size.");
                return;
            }
            this.getExportContactSheetDialog().display();
        }
    }

    public synchronized void exportSetCallback(File dir, String base, int firstIndex, ImageWriterSpi format) {
        try {
            this.exportSet(dir, base, firstIndex, format);
        }
        catch (IOException exc) {
            System.err.println("Error occurred exporting set:\n" + exc.toString());
            exc.printStackTrace();
            this.popupError("An IO error occurred exporting the set: " + exc.getMessage());
        }
    }

    public synchronized void exportContactSheetCallback(File file, int width, int height, ImageWriterSpi format) {
        try {
            this.exportContactSheet(file, width, height, format);
        }
        catch (IOException exc) {
            System.err.println("Error occurred exporting contact sheet:\n" + exc.toString());
            exc.printStackTrace();
            this.popupError("An IO error occurred exporting the set: " + exc.getMessage());
        }
    }

    public synchronized void clearAllClicked() {
        this.getSedpane().clear();
    }

    public synchronized void aboutClicked() {
        this.getApplicationCoordinator().aboutClicked();
    }

    public synchronized void closeClicked() {
        this.getApplicationCoordinator().closeWindow(this);
    }

    public synchronized void quitClicked() {
        this.getApplicationCoordinator().safeQuit();
    }

    public synchronized boolean is565() {
        return this.getMnuEdit565().isSelected();
    }

    public synchronized boolean isTransparencyEmulationPureBlackSet() {
        return this.getMnuEditTransparencyEmulation().isSelected();
    }

    public synchronized BufferedImage getSelectedImage() {
        if (this.getSedpane().hasSelection()) {
            return this.getSedpane().getImageStorage().load(this.getSedpane().getSelectedImageIndex());
        }
        return null;
    }

    public synchronized boolean isAddAtSelection() {
        if (this.getSedpane().getSelectedImageIndex() != -1) {
            return this.addAtSelection;
        }
        return false;
    }

    public synchronized void setAddAtSelection(boolean addAtSelection) {
        this.addAtSelection = addAtSelection;
    }

    public synchronized long getStatusClearDelay() {
        return this.statusClearDelay;
    }

    public synchronized void setStatusClearDelay(long delay) {
        this.statusClearDelay = delay;
    }

    public synchronized void clearStatusText() {
        this.getStatusLabel().setForeground(this.statusInfoColor);
        this.getStatusLabel().setText(String.valueOf(this.getSedpane().getImageCount()) + " images,  565 mode " + (this.is565() ? "enabled" : "disabled") + ",  transparency em. " + (this.isTransparencyEmulationPureBlackSet() ? "pure black" : "off"));
        this.repaint();
    }

    public synchronized void setStatusText(String text) {
        this.getStatusLabel().setForeground(this.statusInfoColor);
        this.getStatusLabel().setText(text);
        this.repaint();
        this.resetClearTask();
    }

    public synchronized void setErrorText(String text) {
        this.getStatusLabel().setForeground(this.statusErrorColor);
        this.getStatusLabel().setText(text);
        this.repaint();
        this.resetClearTask();
    }

    public synchronized void popupError(String text) {
        this.setErrorText(text);
        JOptionPane.showMessageDialog(null, text, "Error", 0);
    }

    public synchronized void popupInfo(String text) {
        this.setStatusText(text);
        JOptionPane.showMessageDialog(null, text, "Info", 1);
    }

    public synchronized int getColumnCount() {
        return this.getSedpane().getMatrixWidth();
    }

    public synchronized int getRowCount() {
        return this.getSedpane().getMatrixHeight();
    }

    public synchronized int getFrameCount() {
        return this.getSedpane().getImageCount();
    }

    public synchronized boolean ask(String question) {
        return JOptionPane.showConfirmDialog(null, question, "?", 0, 3) == 0;
    }

    protected void resetClearTask() {
        if (this.getStatusClearDelay() > 0L) {
            this.statusClearer.unregisterAll();
            this.statusClearer.register(new Runnable(){

                @Override
                public void run() {
                    EdosWindow.this.clearStatusText();
                }
            }, System.currentTimeMillis() + this.getStatusClearDelay());
        }
    }

    public void load(File f) {
        String ln = f.getName().toLowerCase();
        try {
            if (ln.endsWith(".c16") || ln.endsWith(".s16") || ln.endsWith(".blk")) {
                this.open(f);
            } else {
                this.importImage(f, this.getSedpane().getImageCount());
            }
        }
        catch (FileNotFoundException exc) {
            JOptionPane.showMessageDialog(null, "Could not find " + f.getName(), "Load error", 0);
        }
        catch (IOException exc) {
            JOptionPane.showMessageDialog(null, "Error occurred loading " + f.getName() + " : \"" + exc.getMessage() + "\"", "Load error", 0);
        }
    }

    public void save(File f) throws IOException {
        f = f.getAbsoluteFile();
        int dot = f.getName().lastIndexOf(".");
        String ext = ".c16";
        if (dot != -1) {
            ext = f.getName().substring(dot);
        }
        if (ext.equalsIgnoreCase(".blk")) {
            BufferedImage sel = this.getSelectedImage();
            if (sel != null) {
                this.writeBLK(f, sel);
            } else if (this.getSedpane().getImageCount() == 1) {
                this.writeBLK(f, this.getSedpane().getImageStorage().load(0));
            } else {
                this.popupInfo("You must select which image to export.");
            }
        } else {
            BufferedImage[] frames = this.getSedpane().getImageStorage().loadAll();
            if (ext.equalsIgnoreCase(".s16")) {
                this.writeS16(f, frames);
            } else if (ext.equalsIgnoreCase(".spr")) {
                this.writeSPR(f, frames);
            } else {
                this.writeC16(f, frames);
            }
        }
    }

    public void writeBLK(final File dest, final BufferedImage image) {
        final ToBLKConverter toconv = new ToBLKConverter();
        toconv.setBits565(this.is565());
        Thread writer = new Thread(){

            @Override
            public void run() {
                EdosWindow.this.setStatusText("BLK Conversion has initiated...");
                toconv.setBackground(image);
                try {
                    toconv.write(dest);
                    EdosWindow.this.setStatusText("BLK Writing has finished.");
                }
                catch (IOException exc) {
                    EdosWindow.this.setErrorText("An I/O error occurred during BLK writing: " + exc.getMessage());
                }
                catch (FormatMismatchException exc) {
                    EdosWindow.this.setErrorText("A format error occurred during BLK writing: " + exc.getMessage());
                }
            }
        };
        writer.start();
    }

    public void writeC16(final File dest, final BufferedImage[] images) {
        final ToC16Converter toconv = new ToC16Converter();
        toconv.setBits565(this.is565());
        toconv.setTransparencyEmulation(this.isTransparencyEmulationPureBlackSet());
        Thread writer = new Thread(){

            @Override
            public void run() {
                EdosWindow.this.setStatusText("C16 Conversion has initiated...");
                toconv.setFrames(images);
                try {
                    toconv.write(dest);
                    EdosWindow.this.setStatusText("C16 Writing has finished.");
                }
                catch (IOException exc) {
                    EdosWindow.this.setErrorText("An I/O error occurred during C16 writing: " + exc.getMessage());
                }
                catch (FormatMismatchException exc) {
                    EdosWindow.this.setErrorText("A format error occurred during C16 writing: " + exc.getMessage());
                }
            }
        };
        writer.start();
    }

    public void writeS16(final File dest, final BufferedImage[] images) {
        final ToS16Converter toconv = new ToS16Converter();
        toconv.setBits565(this.is565());
        Thread writer = new Thread(){

            @Override
            public void run() {
                EdosWindow.this.setStatusText("S16 Writing has initiated...");
                toconv.setFrames(images);
                try {
                    toconv.write(dest);
                    EdosWindow.this.setStatusText("S16 Writing has finished.");
                }
                catch (IOException exc) {
                    EdosWindow.this.setErrorText("An I/O error occurred during S16 writing: " + exc.getMessage());
                }
                catch (FormatMismatchException exc) {
                    EdosWindow.this.setErrorText("A format error occurred during S16 writing: " + exc.getMessage());
                }
            }
        };
        writer.start();
    }

    public void writeSPR(File dest, BufferedImage[] images) {
        this.popupInfo("Creatures 1 .spr files are not yet supported, email rprogrammer@gmail.com if you want them.");
    }

    public void open(File f) throws FileNotFoundException, IOException {
        int dot = f.getName().lastIndexOf(".");
        String ext = ".c16";
        if (dot != -1) {
            ext = f.getName().substring(dot);
        }
        if (ext.equalsIgnoreCase(".blk")) {
            this.readBLK(f);
        } else if (ext.equalsIgnoreCase(".s16")) {
            this.readS16(f);
        } else if (ext.equalsIgnoreCase(".spr")) {
            this.readSPR(f);
        } else {
            this.readC16(f);
        }
    }

    public void readBLK(final File src) {
        final FromBLKConverter fromconv = new FromBLKConverter();
        Thread writer = new Thread(){

            @Override
            public void run() {
                EdosWindow.this.setStatusText("BLK Reading has initiated...");
                try {
                    fromconv.read(src);
                    EdosWindow.this.setStatusText("BLK Reading has finished.");
                    EdosWindow.this.getSedpane().clear();
                    EdosWindow.this.getSedpane().add(fromconv.getBackground());
                }
                catch (IOException exc) {
                    EdosWindow.this.setErrorText("An i/o error occurred during BLK reading: " + exc.getMessage());
                }
                catch (FormatMismatchException exc) {
                    EdosWindow.this.setErrorText("A blk validity error occurred during BLK reading: " + exc.getMessage());
                }
            }
        };
        writer.start();
    }

    public void readC16(final File src) {
        final FromC16Converter fromconv = new FromC16Converter();
        Thread writer = new Thread(){

            @Override
            public void run() {
                EdosWindow.this.setStatusText("C16 Reading has initiated...");
                try {
                    fromconv.read(src);
                    EdosWindow.this.setStatusText("C16 Reading has finished.");
                    EdosWindow.this.getSedpane().setImages(fromconv.getFrames());
                }
                catch (IOException exc) {
                    EdosWindow.this.setErrorText("An i/o error occurred during C16 reading: " + exc.getMessage());
                }
                catch (FormatMismatchException exc) {
                    EdosWindow.this.setErrorText("The file doesn't appear to be a valid C16 file: " + exc.getMessage());
                }
            }
        };
        writer.start();
    }

    public void readS16(final File src) {
        final FromS16Converter fromconv = new FromS16Converter();
        Thread writer = new Thread(){

            @Override
            public void run() {
                EdosWindow.this.setStatusText("S16 Reading has initiated...");
                try {
                    fromconv.read(src);
                    EdosWindow.this.setStatusText("S16 Reading has finished.");
                    EdosWindow.this.getSedpane().setImages(fromconv.getFrames());
                }
                catch (IOException exc) {
                    EdosWindow.this.setErrorText("An i/o error occurred during S16 reading: " + exc.getMessage());
                }
                catch (FormatMismatchException exc) {
                    EdosWindow.this.setErrorText("The file doesn't appear to be a valid S16 file: " + exc.getMessage());
                }
            }
        };
        writer.start();
    }

    public void readSPR(File dest) {
        this.popupInfo("SPR Reading is not supported yet.");
    }

    public void importImage(BufferedImage img, int index) {
        this.getSedpane().add(img, index);
    }

    public void importImage(File file, int index) throws IOException {
        if (!file.exists()) {
            this.setErrorText(String.valueOf(file.getName()) + " does not exist.");
            return;
        }
        if (!file.isFile()) {
            this.setErrorText(String.valueOf(file.getName()) + " is not a file.");
            return;
        }
        this.setStatusText("Importing " + file.getName());
        BufferedImage image = ImageIO.read(file);
        if (image == null) {
            this.setErrorText("Could not import " + file.getName());
        } else {
            this.importImage(image, index);
            this.setStatusText("Done.");
        }
    }

    public void importImages(File[] files, int index) throws IOException {
        int currentIndex = index;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            this.importImage(f, currentIndex);
            ++currentIndex;
            ++n2;
        }
    }

    public void importImages(List<File> files, int index) throws IOException {
        int currentIndex = index;
        for (File f : files) {
            this.importImage(f, currentIndex);
            ++currentIndex;
        }
    }

    public void exportImage(File file, BufferedImage image) throws IOException {
        ImageWriterSpi format = null;
        String lowercaseName = file.getName().toLowerCase();
        Iterator<ImageWriterSpi> spis = IIORegistry.getDefaultInstance().getServiceProviders(ImageWriterSpi.class, true);
        block0: while (spis.hasNext()) {
            ImageWriterSpi spi = spis.next();
            String[] stringArray = spi.getFileSuffixes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                if (lowercaseName.endsWith(suffix.toLowerCase())) {
                    format = spi;
                    break block0;
                }
                ++n2;
            }
        }
        if (format == null) {
            this.popupError("I don't know how to make that type of file.");
        } else {
            this.exportImage(file, image, format);
        }
    }

    public void exportImage(File file, BufferedImage image, ImageWriterSpi format) throws IOException {
        if (!this.prepareFileForExport(file)) {
            return;
        }
        this.setStatusText("Exporting " + file.getName());
        ImageWriter writer = format.createWriterInstance();
        FileImageOutputStream out = new FileImageOutputStream(file);
        writer.setOutput(out);
        writer.write(image);
        out.close();
        writer.dispose();
        this.setStatusText("Done.");
    }

    public void importSet(File representative, int imageInsertionIndex) throws IOException {
        char c;
        if (!representative.isFile()) {
            this.popupError("Could not import " + representative + " - it is not a file.");
            return;
        }
        String name = representative.getName();
        int lastDotPos = name.lastIndexOf(46);
        int start = 0;
        start = lastDotPos == -1 ? name.length() : lastDotPos;
        int index = start;
        while (--index >= 0 && Character.digit(c = name.charAt(index), 10) != -1) {
        }
        final String setPrefix = name.substring(0, index + 1);
        final String setSuffix = name.substring(start);
        File dir = representative.getParentFile();
        final String lowerPrefix = setPrefix.toLowerCase();
        final String lowerSuffix = setSuffix.toLowerCase();
        File[] setMembers = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                String lowerName = file.getName().toLowerCase();
                return lowerName.startsWith(lowerPrefix) && lowerName.endsWith(lowerSuffix);
            }
        });
        Arrays.sort(setMembers, new Comparator<File>(){

            @Override
            public int compare(File a, File b) {
                int bIndex;
                String aname = a.getName();
                String bname = b.getName();
                int prefixLength = setPrefix.length();
                int suffixLength = setSuffix.length();
                String aIndexPart = aname.substring(prefixLength, aname.length() - suffixLength);
                String bIndexPart = bname.substring(prefixLength, bname.length() - suffixLength);
                int aIndex = StringUtilities.parseIntegerLeniently(aIndexPart, 10, 0);
                if (aIndex > (bIndex = StringUtilities.parseIntegerLeniently(bIndexPart, 10, 0).intValue())) {
                    return 1;
                }
                if (aIndex < bIndex) {
                    return -1;
                }
                return 0;
            }
        });
        this.importImages(setMembers, imageInsertionIndex);
    }

    public void exportSet(File dir, String base, int firstSetIndex, ImageWriterSpi format) throws IOException {
        boolean answer;
        if (!dir.isDirectory()) {
            this.popupError(String.valueOf(dir.getAbsolutePath()) + " is not a valid directory.");
            return;
        }
        if (base == null) {
            base = "";
        }
        File[] setFiles = null;
        setFiles = new File[this.getSedpane().getImageCount()];
        int baseDotPos = base.lastIndexOf(46);
        String basePrefix = null;
        String baseSuffix22 = null;
        if (baseDotPos == -1) {
            basePrefix = base;
            baseSuffix22 = "";
        } else {
            basePrefix = base.substring(0, baseDotPos);
            baseSuffix22 = base.substring(baseDotPos);
        }
        int endsWithSupportedSuffix = 0;
        String baseSuffixLowerCase = baseSuffix22.toLowerCase();
        String[] stringArray = format.getFileSuffixes();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            if (baseSuffixLowerCase.endsWith(ext.toLowerCase())) {
                endsWithSupportedSuffix = 1;
                break;
            }
            ++n2;
        }
        if (endsWithSupportedSuffix == 0 && format.getFileSuffixes().length > 0) {
            baseSuffix22 = String.valueOf(baseSuffix22) + "." + format.getFileSuffixes()[0];
        }
        int i22 = 0;
        while (i22 < setFiles.length) {
            setFiles[i22] = new File(dir, String.valueOf(basePrefix) + (i22 + firstSetIndex) + baseSuffix22);
            ++i22;
        }
        boolean atleastOneExists = false;
        File[] i22 = setFiles;
        endsWithSupportedSuffix = setFiles.length;
        int baseSuffix22 = 0;
        while (baseSuffix22 < endsWithSupportedSuffix) {
            File file = i22[baseSuffix22];
            if (file.exists()) {
                atleastOneExists = true;
                break;
            }
            ++baseSuffix22;
        }
        if (atleastOneExists && !(answer = this.ask("Some of these files exist, are you sure you want to overwrite?"))) {
            return;
        }
        ImageWriter writer = format.createWriterInstance();
        int i = 0;
        while (i < setFiles.length) {
            File file = setFiles[i];
            if (this.prepareFileForExport(file)) {
                BufferedImage image = this.getSedpane().getImageStorage().load(i);
                FileImageOutputStream fios = new FileImageOutputStream(file);
                writer.reset();
                writer.setOutput(fios);
                writer.write(image);
                fios.close();
            }
            ++i;
        }
        writer.dispose();
    }

    public void importContactSheet(File sheetFile, int insertionIndex, int tilewidth, int tileheight) throws IOException {
        if (tilewidth == 0 || tileheight == 0) {
            this.setErrorText("Dimensions " + tilewidth + "x" + tileheight + " are invalid.");
            return;
        }
        BufferedImage sheet = null;
        this.setStatusText("Loading sheet file " + sheetFile.getName());
        sheet = ImageIO.read(sheetFile);
        if (sheet.getWidth() == 0 || sheet.getHeight() == 0) {
            this.popupError(String.valueOf(sheetFile.getName()) + " is an invalid image file.");
            return;
        }
        int cols = 0;
        int rows = 0;
        if (sheet.getWidth() % tilewidth != 0 || sheet.getHeight() % tileheight != 0) {
            this.popupError(String.valueOf(tilewidth) + "x" + tileheight + " tiles would not fit evenly into a " + sheet.getWidth() + "x" + sheet.getHeight() + " sheet.");
            return;
        }
        if (tilewidth > sheet.getWidth() || tileheight > sheet.getHeight()) {
            this.popupError("Tiles cannot be larger than the sheet!");
            return;
        }
        cols = sheet.getWidth() / tilewidth;
        rows = sheet.getHeight() / tileheight;
        WritableRaster sheetRaster = sheet.getRaster();
        int currentIndex = insertionIndex;
        int i = 0;
        while (i < cols * rows) {
            int col = i % cols;
            int row = i / cols;
            this.setStatusText("Sequestering tile " + (i + 1) + " of " + cols * rows + " (" + (col + 1) + "," + (row + 1) + ")");
            WritableRaster child = sheetRaster.createWritableChild(col * tilewidth, row * tileheight, tilewidth, tileheight, 0, 0, null);
            BufferedImage tile = new BufferedImage(sheet.getColorModel(), child, sheet.isAlphaPremultiplied(), null);
            this.importImage(tile, currentIndex);
            ++currentIndex;
            ++i;
        }
        this.setStatusText("Done.");
    }

    public void exportContactSheet(File file, int cols, int rows, ImageWriterSpi format) throws IOException {
        if (!this.prepareFileForExport(file)) {
            return;
        }
        if (this.getSedpane().getImageCount() == 0) {
            this.setErrorText("No images to export.");
            return;
        }
        if (this.getSedpane().getImageCount() == 1) {
            this.setStatusText("Exporting " + file.getName());
            this.exportImage(file, this.getSedpane().getImageStorage().load(0), format);
            this.setStatusText("Done.");
            return;
        }
        if (cols * rows != this.getSedpane().getImageCount()) {
            this.setErrorText(String.valueOf(this.getSedpane().getImageCount()) + " images doesn't make a " + cols + "x" + rows + " grid.");
            return;
        }
        int tilewidth = 0;
        int tileheight = 0;
        BufferedImage representative = this.getSedpane().getImageStorage().load(0);
        tilewidth = representative.getWidth();
        tileheight = representative.getHeight();
        int i = 1;
        while (i < this.getSedpane().getImageCount()) {
            BufferedImage image = this.getSedpane().getImageStorage().load(i);
            if (image.getWidth() != tilewidth || image.getHeight() != tileheight) {
                this.setErrorText("Not all images are the same size.");
                return;
            }
            ++i;
        }
        this.setStatusText("Generating " + cols + "x" + rows + " contact sheet...");
        BufferedImage sheet = null;
        sheet = new BufferedImage(tilewidth * cols, tileheight * rows, 2);
        ColorConvertOp converter = new ColorConvertOp(null);
        int i2 = 0;
        while (i2 < this.getSedpane().getImageCount()) {
            int col = i2 % cols;
            int row = i2 / cols;
            BufferedImage tile = this.getSedpane().getImageStorage().load(i2);
            BufferedImage compatibleTile = null;
            if (tile.getColorModel().equals(sheet.getColorModel()) && tile.getSampleModel().equals(sheet.getSampleModel())) {
                compatibleTile = tile;
            } else {
                compatibleTile = new BufferedImage(tile.getWidth(), tile.getHeight(), 2);
                converter.filter(tile, compatibleTile);
            }
            sheet.getRaster().setDataElements(col * tilewidth, row * tileheight, compatibleTile.getRaster());
            ++i2;
        }
        this.setStatusText("Exporting " + file.getName());
        ImageWriter writer = format.createWriterInstance();
        FileImageOutputStream out = new FileImageOutputStream(file);
        writer.setOutput(out);
        writer.write(sheet);
        out.close();
        writer.dispose();
        this.setStatusText("Done.");
    }

    protected boolean prepareFileForExport(File file) {
        if (file.exists()) {
            if (!file.isFile()) {
                this.setErrorText(String.valueOf(file.getName()) + " is not a file.");
                return false;
            }
            file.delete();
        }
        if (file.exists()) {
            this.setErrorText(String.valueOf(file.getName()) + " still exists.");
            return false;
        }
        return true;
    }

    public EdosApplicationCoordinator getApplicationCoordinator() {
        return this.edosApplicationCoordinator;
    }

    public void setApplicationCoordinator(EdosApplicationCoordinator edosApplicationCoordinator) {
        this.edosApplicationCoordinator = edosApplicationCoordinator;
    }
}

