/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.util;

import from.java.io.forr.rebound.io.iio.ByteArrayOutputByteStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.io.iio.InputByteStream;
import rebound.io.iio.OutputByteStream;
import rebound.io.iio.ResettableInputByteStream;
import rebound.io.iio.unions.CloseableFlushableOutputByteStreamInterface;
import rebound.io.iio.unions.CloseableInputByteStreamInterface;
import rebound.math.SmallIntegerMathUtilities;
import rebound.util.BasicExceptionUtilities;
import rebound.util.collections.ArrayUtilities;

public class BasicIOUtilities {
    public static byte read1(InputByteStream in) throws EOFException, IOException {
        int v = in.read();
        if (v == -1) {
            throw new EOFException();
        }
        return (byte)v;
    }

    public static long pump(InputByteStream in, OutputByteStream out, int bufferSize) throws IOException {
        long total = 0L;
        byte[] buffer = new byte[bufferSize];
        int amt = in.read(buffer);
        while (amt >= 0) {
            total = SmallIntegerMathUtilities.safe_add_s64(total, amt);
            out.write(buffer, 0, amt);
            amt = in.read(buffer);
        }
        return total;
    }

    public static long pump(InputByteStream in, OutputByteStream out) throws IOException {
        return BasicIOUtilities.pump(in, out, 4096);
    }

    @ActuallyUnsigned
    public static long pumpFixed(InputByteStream in, OutputByteStream out, @ActuallyUnsigned long length, int bufferSize) throws IOException {
        if (length > 0L) {
            byte[] buffer = new byte[bufferSize];
            int amt = 0;
            long curr = 0L;
            while (Long.compareUnsigned(curr, length) < 0) {
                amt = in.read(buffer, 0, Math.min(bufferSize, (int)(length - curr)));
                if (amt < 0) {
                    return curr;
                }
                curr = SmallIntegerMathUtilities.safe_add_u64(curr, amt);
                out.write(buffer, 0, amt);
            }
            return curr;
        }
        return 0L;
    }

    public static long pumpFixed(InputByteStream in, OutputByteStream out, long length) throws IOException {
        return BasicIOUtilities.pumpFixed(in, out, length, 4096);
    }

    public static long discard(InputByteStream in, long amount) throws IOException {
        long skipped = 0L;
        long c = 0L;
        while (skipped < amount) {
            c = in.skip(amount - skipped);
            if (c < 0L) {
                return skipped;
            }
            skipped += c;
        }
        return skipped;
    }

    public static long discard(InputByteStream in) throws IOException {
        long skipped = 0L;
        long c = 0L;
        while ((c = in.skip(65536L)) > 0L) {
            skipped += c;
        }
        return skipped;
    }

    public static long discardByReading(InputByteStream in, long amount) throws IOException {
        byte[] dummyBuff = new byte[1024];
        long skipped = 0L;
        long c = 0L;
        while (skipped < amount) {
            c = in.read(dummyBuff, 0, (int)Math.min((long)dummyBuff.length, amount - skipped));
            if (c == -1L) {
                return skipped;
            }
            skipped += c;
        }
        return skipped;
    }

    public static long discardByReading(InputByteStream in) throws IOException {
        byte[] dummyBuff = new byte[1024];
        long skipped = 0L;
        long c = 0L;
        while ((c = (long)in.read(dummyBuff, 0, dummyBuff.length)) != -1L) {
            skipped += c;
        }
        return skipped;
    }

    public static void readFully(InputByteStream in, byte[] buff, int offset, int len) throws EOFException, IOException {
        int read = 0;
        while (read < len) {
            int r = in.read(buff, offset + read, len - read);
            if (r < 0) {
                throw new EOFException("Premature EOF");
            }
            read += r;
        }
        return;
    }

    public static void readFully(InputByteStream in, byte[] buff) throws EOFException, IOException {
        BasicIOUtilities.readFully(in, buff, 0, buff.length);
    }

    public static byte[] readFullyToNew(InputByteStream in, int length) throws EOFException, IOException {
        if (length == 0) {
            return ArrayUtilities.EmptyByteArray;
        }
        byte[] b = new byte[length];
        BasicIOUtilities.readFully(in, b);
        return b;
    }

    public static void skipFully(InputByteStream in, @ActuallyUnsigned long len, byte[] dummyBuffer) throws EOFException, IOException {
        Objects.requireNonNull(dummyBuffer);
        long total = 0L;
        int amt = 0;
        int toRead = 0;
        do {
            if ((amt = in.read(dummyBuffer, 0, toRead = len - total > (long)dummyBuffer.length ? dummyBuffer.length : (int)(len - total))) >= 0) continue;
            throw new EOFException("Premature EOF");
        } while ((total = SmallIntegerMathUtilities.safe_add_u64(total, amt)) < len);
    }

    public static void skipFully(InputByteStream in, long len) throws EOFException, IOException {
        BasicIOUtilities.skipFully(in, len, new byte[4096]);
    }

    public static int readAsMuchAsPossible(InputByteStream in, byte[] buff, int offset, int len) throws IOException {
        int read = 0;
        int r = 0;
        while ((r = in.read(buff, offset + read, len - read)) >= 0 && (read += r) < len) {
        }
        return read;
    }

    public static int readAsMuchAsPossible(InputByteStream in, byte[] buff) throws IOException {
        return BasicIOUtilities.readAsMuchAsPossible(in, buff, 0, buff.length);
    }

    public static byte[] readAll(@Nonnull InputByteStream in) throws IOException {
        ByteArrayOutputByteStream buff = new ByteArrayOutputByteStream();
        BasicIOUtilities.pump(in, buff);
        return buff.toByteArray();
    }

    public static boolean checkMagic(InputByteStream in, byte[] magic) throws IOException {
        int c = 0;
        int i = 0;
        while (i < magic.length) {
            c = in.read();
            if (c == -1) {
                return false;
            }
            if ((byte)c != magic[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void closeWithoutError(Closeable closeableThing) {
        try {
            closeableThing.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeAllWithoutError(Closeable ... ss) {
        if (ss != null) {
            Closeable[] closeableArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                Closeable s = closeableArray[n2];
                BasicIOUtilities.closeWithoutError(s);
                ++n2;
            }
        }
    }

    public static void closeAll(Closeable ... ss) throws IOException {
        if (ss != null) {
            Throwable exc = null;
            Closeable[] closeableArray = ss;
            int n = ss.length;
            int n2 = 0;
            while (n2 < n) {
                Closeable s = closeableArray[n2];
                try {
                    s.close();
                }
                catch (Throwable e) {
                    if (exc == null) {
                        exc = e;
                    }
                    exc.addSuppressed(e);
                }
                ++n2;
            }
            if (exc != null) {
                if (exc instanceof IOException) {
                    throw (IOException)exc;
                }
                BasicExceptionUtilities.rethrowSafe(exc);
            }
        }
    }

    public static enum EmptyInputByteStream implements CloseableInputByteStreamInterface,
    ResettableInputByteStream
    {
        I;


        @Override
        public void close() {
        }

        @Override
        public int read() {
            return -1;
        }

        @Override
        public int read(byte[] b) {
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) {
            return -1;
        }

        @Override
        public long skip(long n) {
            return 0L;
        }

        @Override
        public void seekToStart() throws IOException {
        }
    }

    public static enum NullOutputStream implements CloseableFlushableOutputByteStreamInterface
    {
        I;


        @Override
        public void write(byte[] b) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }
    }
}

