/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.ucs4;

import java.io.IOException;
import rebound.io.ucs4.UCS4Reader;

public abstract class AbstractUCS4Reader
implements UCS4Reader {
    protected static final int maxSkipBufferSize = 8192;
    protected int[] skipBuffer = null;

    @Override
    public long skip(long amountRequested) throws IOException {
        if (amountRequested < 0L) {
            throw new IllegalArgumentException("skip value is negative");
        }
        int skipBufferSize = (int)Math.min(amountRequested, 8192L);
        if (this.skipBuffer == null || this.skipBuffer.length < skipBufferSize) {
            this.skipBuffer = new int[skipBufferSize];
        }
        long remaining = amountRequested;
        while (remaining > 0L) {
            int amt = this.read(this.skipBuffer, 0, (int)Math.min(remaining, (long)skipBufferSize));
            if (amt == -1) break;
            remaining -= (long)amt;
        }
        return amountRequested - remaining;
    }
}

