/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.streaming.api;

import java.io.EOFException;
import java.io.IOException;
import javax.annotation.Nonnegative;
import rebound.annotations.hints.Final;
import rebound.annotations.hints.IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.io.streaming.api.BlockReadStream;
import rebound.io.streaming.api.BlockWriteStream;
import rebound.io.streaming.api.ClosedStreamException;
import rebound.io.streaming.api.UnitReadStream;
import rebound.io.streaming.api.UnitWriteStream;
import rebound.util.collections.Slice;

public class StreamAPIs {

    public static interface BooleanBlockReadStream
    extends BlockReadStream<Boolean, boolean[]>,
    BooleanUnitReadStream {
        @Nonnegative
        public int read(boolean[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(boolean[] buffer) throws IOException, ClosedStreamException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(Slice<boolean[]> buffer) throws IOException, ClosedStreamException {
            return this.read(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface BooleanBlockWriteStream
    extends BlockWriteStream<Boolean, boolean[]>,
    BooleanUnitWriteStream {
        @Nonnegative
        public int write(boolean[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(boolean[] buffer) throws IOException, ClosedStreamException {
            return this.write(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(Slice<boolean[]> buffer) throws IOException, ClosedStreamException {
            return this.write(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface BooleanUnitReadStream
    extends UnitReadStream<Boolean> {
        public boolean read() throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Boolean readPossiblyBoxing() throws EOFException, IOException, ClosedStreamException {
            return this.read();
        }
    }

    public static interface BooleanUnitWriteStream
    extends UnitWriteStream<Boolean> {
        public void write(boolean var1) throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void writePossiblyUnboxing(Boolean unit) throws EOFException, IOException, ClosedStreamException {
            this.write(unit);
        }
    }

    public static interface ByteBlockReadStream
    extends BlockReadStream<Byte, byte[]>,
    ByteUnitReadStream {
        @Nonnegative
        public int read(byte[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(byte[] buffer) throws IOException, ClosedStreamException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(Slice<byte[]> buffer) throws IOException, ClosedStreamException {
            return this.read(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface ByteBlockWriteStream
    extends BlockWriteStream<Byte, byte[]>,
    ByteUnitWriteStream {
        @Nonnegative
        public int write(byte[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(byte[] buffer) throws IOException, ClosedStreamException {
            return this.write(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(Slice<byte[]> buffer) throws IOException, ClosedStreamException {
            return this.write(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface ByteUnitReadStream
    extends UnitReadStream<Byte> {
        public byte read() throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Byte readPossiblyBoxing() throws EOFException, IOException, ClosedStreamException {
            return this.read();
        }
    }

    public static interface ByteUnitWriteStream
    extends UnitWriteStream<Byte> {
        public void write(byte var1) throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void writePossiblyUnboxing(Byte unit) throws EOFException, IOException, ClosedStreamException {
            this.write(unit);
        }
    }

    public static interface CharBlockReadStream
    extends BlockReadStream<Character, char[]>,
    CharUnitReadStream {
        @Nonnegative
        public int read(char[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(char[] buffer) throws IOException, ClosedStreamException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(Slice<char[]> buffer) throws IOException, ClosedStreamException {
            return this.read(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface CharBlockWriteStream
    extends BlockWriteStream<Character, char[]>,
    CharUnitWriteStream {
        @Nonnegative
        public int write(char[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(char[] buffer) throws IOException, ClosedStreamException {
            return this.write(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(Slice<char[]> buffer) throws IOException, ClosedStreamException {
            return this.write(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface CharUnitReadStream
    extends UnitReadStream<Character> {
        public char read() throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Character readPossiblyBoxing() throws EOFException, IOException, ClosedStreamException {
            return Character.valueOf(this.read());
        }
    }

    public static interface CharUnitWriteStream
    extends UnitWriteStream<Character> {
        public void write(char var1) throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void writePossiblyUnboxing(Character unit) throws EOFException, IOException, ClosedStreamException {
            this.write(unit.charValue());
        }
    }

    public static interface DoubleBlockReadStream
    extends BlockReadStream<Double, double[]>,
    DoubleUnitReadStream {
        @Nonnegative
        public int read(double[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(double[] buffer) throws IOException, ClosedStreamException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(Slice<double[]> buffer) throws IOException, ClosedStreamException {
            return this.read(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface DoubleBlockWriteStream
    extends BlockWriteStream<Double, double[]>,
    DoubleUnitWriteStream {
        @Nonnegative
        public int write(double[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(double[] buffer) throws IOException, ClosedStreamException {
            return this.write(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(Slice<double[]> buffer) throws IOException, ClosedStreamException {
            return this.write(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface DoubleUnitReadStream
    extends UnitReadStream<Double> {
        public double read() throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Double readPossiblyBoxing() throws EOFException, IOException, ClosedStreamException {
            return this.read();
        }
    }

    public static interface DoubleUnitWriteStream
    extends UnitWriteStream<Double> {
        public void write(double var1) throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void writePossiblyUnboxing(Double unit) throws EOFException, IOException, ClosedStreamException {
            this.write(unit);
        }
    }

    public static interface FloatBlockReadStream
    extends BlockReadStream<Float, float[]>,
    FloatUnitReadStream {
        @Nonnegative
        public int read(float[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(float[] buffer) throws IOException, ClosedStreamException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(Slice<float[]> buffer) throws IOException, ClosedStreamException {
            return this.read(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface FloatBlockWriteStream
    extends BlockWriteStream<Float, float[]>,
    FloatUnitWriteStream {
        @Nonnegative
        public int write(float[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(float[] buffer) throws IOException, ClosedStreamException {
            return this.write(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(Slice<float[]> buffer) throws IOException, ClosedStreamException {
            return this.write(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface FloatUnitReadStream
    extends UnitReadStream<Float> {
        public float read() throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Float readPossiblyBoxing() throws EOFException, IOException, ClosedStreamException {
            return Float.valueOf(this.read());
        }
    }

    public static interface FloatUnitWriteStream
    extends UnitWriteStream<Float> {
        public void write(float var1) throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void writePossiblyUnboxing(Float unit) throws EOFException, IOException, ClosedStreamException {
            this.write(unit.floatValue());
        }
    }

    public static interface IntBlockReadStream
    extends BlockReadStream<Integer, int[]>,
    IntUnitReadStream {
        @Nonnegative
        public int read(int[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(int[] buffer) throws IOException, ClosedStreamException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(Slice<int[]> buffer) throws IOException, ClosedStreamException {
            return this.read(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface IntBlockWriteStream
    extends BlockWriteStream<Integer, int[]>,
    IntUnitWriteStream {
        @Nonnegative
        public int write(int[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(int[] buffer) throws IOException, ClosedStreamException {
            return this.write(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(Slice<int[]> buffer) throws IOException, ClosedStreamException {
            return this.write(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface IntUnitReadStream
    extends UnitReadStream<Integer> {
        public int read() throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Integer readPossiblyBoxing() throws EOFException, IOException, ClosedStreamException {
            return this.read();
        }
    }

    public static interface IntUnitWriteStream
    extends UnitWriteStream<Integer> {
        public void write(int var1) throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void writePossiblyUnboxing(Integer unit) throws EOFException, IOException, ClosedStreamException {
            this.write(unit);
        }
    }

    public static interface LongBlockReadStream
    extends BlockReadStream<Long, long[]>,
    LongUnitReadStream {
        @Nonnegative
        public int read(long[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(long[] buffer) throws IOException, ClosedStreamException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(Slice<long[]> buffer) throws IOException, ClosedStreamException {
            return this.read(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface LongBlockWriteStream
    extends BlockWriteStream<Long, long[]>,
    LongUnitWriteStream {
        @Nonnegative
        public int write(long[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(long[] buffer) throws IOException, ClosedStreamException {
            return this.write(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(Slice<long[]> buffer) throws IOException, ClosedStreamException {
            return this.write(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface LongUnitReadStream
    extends UnitReadStream<Long> {
        public long read() throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Long readPossiblyBoxing() throws EOFException, IOException, ClosedStreamException {
            return this.read();
        }
    }

    public static interface LongUnitWriteStream
    extends UnitWriteStream<Long> {
        public void write(long var1) throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void writePossiblyUnboxing(Long unit) throws EOFException, IOException, ClosedStreamException {
            this.write(unit);
        }
    }

    public static interface ReferenceBlockReadStream<D>
    extends BlockReadStream<D, D[]>,
    ReferenceUnitReadStream<D> {
        @Nonnegative
        public int read(D[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(D[] buffer) throws IOException, ClosedStreamException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(Slice<D[]> buffer) throws IOException, ClosedStreamException {
            return this.read(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface ReferenceBlockWriteStream<D>
    extends BlockWriteStream<D, D[]>,
    ReferenceUnitWriteStream<D> {
        @Nonnegative
        public int write(D[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(D[] buffer) throws IOException, ClosedStreamException {
            return this.write(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(Slice<D[]> buffer) throws IOException, ClosedStreamException {
            return this.write(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface ReferenceUnitReadStream<D>
    extends UnitReadStream<D> {
        public D read() throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public D readPossiblyBoxing() throws EOFException, IOException, ClosedStreamException {
            return this.read();
        }
    }

    public static interface ReferenceUnitWriteStream<D>
    extends UnitWriteStream<D> {
        public void write(D var1) throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void writePossiblyUnboxing(D unit) throws EOFException, IOException, ClosedStreamException {
            this.write(unit);
        }
    }

    public static interface ShortBlockReadStream
    extends BlockReadStream<Short, short[]>,
    ShortUnitReadStream {
        @Nonnegative
        public int read(short[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(short[] buffer) throws IOException, ClosedStreamException {
            return this.read(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int read(Slice<short[]> buffer) throws IOException, ClosedStreamException {
            return this.read(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface ShortBlockWriteStream
    extends BlockWriteStream<Short, short[]>,
    ShortUnitWriteStream {
        @Nonnegative
        public int write(short[] var1, int var2, int var3) throws IOException, ClosedStreamException;

        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(short[] buffer) throws IOException, ClosedStreamException {
            return this.write(buffer, 0, buffer.length);
        }

        @Override
        @Final
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public int write(Slice<short[]> buffer) throws IOException, ClosedStreamException {
            return this.write(buffer.getUnderlying(), buffer.getOffset(), buffer.getLength());
        }
    }

    public static interface ShortUnitReadStream
    extends UnitReadStream<Short> {
        public short read() throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public Short readPossiblyBoxing() throws EOFException, IOException, ClosedStreamException {
            return this.read();
        }
    }

    public static interface ShortUnitWriteStream
    extends UnitWriteStream<Short> {
        public void write(short var1) throws EOFException, IOException, ClosedStreamException;

        @Override
        @IntendedToNOTBeSubclassedImplementedOrOverriddenByApiUser
        default public void writePossiblyUnboxing(Short unit) throws EOFException, IOException, ClosedStreamException {
            this.write(unit);
        }
    }
}

