/*
 * Decompiled with CFR 0.152.
 */
package rebound.concurrency.threads;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.ThreadSafe;
import rebound.annotations.semantic.temporal.concurrencyprimitives.threadspecification.AnyThreads;

@AnyThreads
@ThreadSafe
public interface BasicSchedulerService {
    public void shutdownCleanlyEventually();

    public void shutdownCleanlyNow();

    public void scheduleRelative(Runnable var1, long var2);

    default public void scheduleAbsolute(Runnable task, long systemNanotimeToExecuteAt) {
        long delayNS = systemNanotimeToExecuteAt - System.nanoTime();
        this.scheduleRelative(task, delayNS);
    }

    public static BasicSchedulerService wrapJavaConcurrency(final ScheduledExecutorService x) {
        return new BasicSchedulerService(){

            @Override
            public void scheduleRelative(Runnable task, long nanosecondsFromNowToExecute) {
                x.schedule(task, nanosecondsFromNowToExecute, TimeUnit.NANOSECONDS);
            }

            @Override
            public void shutdownCleanlyEventually() {
                x.shutdown();
            }

            @Override
            public void shutdownCleanlyNow() {
                x.shutdownNow();
            }
        };
    }
}

