/*
 * Decompiled with CFR 0.152.
 */
package rebound.bits;

import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.exceptions.DivisionByZeroException;
import rebound.exceptions.OverflowException;
import rebound.util.objectutil.JavaNamespace;

public class Unsigned
implements JavaNamespace {
    public static final long LONG_MAX_VALUE = -1L;
    public static final long LONG_MIN_VALUE = 0L;
    public static final int INT_MAX_VALUE = -1;
    public static final int INT_MIN_VALUE = 0;
    public static final short SHORT_MAX_VALUE = -1;
    public static final short SHORT_MIN_VALUE = 0;
    public static final byte BYTE_MAX_VALUE = -1;
    public static final byte BYTE_MIN_VALUE = 0;
    public static final long LONG_NEGFLAG = Long.MIN_VALUE;
    public static final long LONG_DATAMASK = Long.MAX_VALUE;
    public static final int INT_NEGFLAG = Integer.MIN_VALUE;
    public static final int INT_DATAMASK = Integer.MAX_VALUE;
    public static final short SHORT_NEGFLAG = Short.MIN_VALUE;
    public static final short SHORT_DATAMASK = Short.MAX_VALUE;
    public static final byte BYTE_NEGFLAG = -128;
    public static final byte BYTE_DATAMASK = 127;
    public static final float INT_HIGH_BIT_IN_SINGLEFLOAT = 2.1474836E9f;
    public static final float LONG_HIGH_BIT_IN_SINGLEFLOAT = 9.223372E18f;
    public static final double INT_HIGH_BIT_IN_DOUBLEFLOAT = 2.147483648E9;
    public static final double LONG_HIGH_BIT_IN_DOUBLEFLOAT = 9.223372036854776E18;
    public static final float INT_MAX_SIGNED_VALUE_IN_SINGLEFLOAT = 2.1474836E9f;
    public static final float INT_MAX_UNSIGNED_VALUE_IN_SINGLEFLOAT = 4.2949673E9f;
    public static final double INT_MAX_SIGNED_VALUE_IN_DOUBLEFLOAT = 2.147483647E9;
    public static final double INT_MAX_UNSIGNED_VALUE_IN_DOUBLEFLOAT = 4.294967295E9;
    public static final float LONG_MAX_SIGNED_VALUE_IN_SINGLEFLOAT = 9.223372E18f;
    public static final float LONG_MAX_UNSIGNED_VALUE_IN_SINGLEFLOAT = 1.8446744E19f;
    public static final double LONG_MAX_SIGNED_VALUE_IN_DOUBLEFLOAT = 9.223372036854776E18;
    public static final double LONG_MAX_UNSIGNED_VALUE_IN_DOUBLEFLOAT = 1.8446744073709552E19;

    @ActuallyUnsigned
    public static long divideU64(@ActuallyUnsigned long a, @ActuallyUnsigned long b) {
        boolean bnega;
        if (b == 0L) {
            throw new DivisionByZeroException();
        }
        if (a == 0L) {
            return 0L;
        }
        if (b == 1L) {
            return a;
        }
        if (a == b) {
            return 1L;
        }
        boolean anega = a < 0L;
        boolean bl = bnega = b < 0L;
        if (anega) {
            a &= Long.MAX_VALUE;
        }
        if (bnega) {
            b &= Long.MAX_VALUE;
        }
        long c = 0L;
        long mod1 = 0L;
        if (b > 0L) {
            c = a / b;
            mod1 = a % b;
        }
        if (anega && !bnega) {
            c += Long.MIN_VALUE / -b;
            long mod2 = -(Long.MIN_VALUE % b);
            if (mod1 + mod2 >= b) {
                ++c;
            }
        } else {
            if (!anega && bnega) {
                return 0L;
            }
            if (anega && bnega) {
                if (a >= b) {
                    return 1L;
                }
                return 0L;
            }
        }
        return c;
    }

    @ActuallyUnsigned
    public static int divideU32(@ActuallyUnsigned int a, @ActuallyUnsigned int b) {
        boolean bnega;
        if (b == 0) {
            throw new DivisionByZeroException();
        }
        if (a == 0) {
            return 0;
        }
        if (b == 1) {
            return a;
        }
        if (a == b) {
            return 1;
        }
        boolean anega = a < 0;
        boolean bl = bnega = b < 0;
        if (anega) {
            a &= Integer.MAX_VALUE;
        }
        if (bnega) {
            b &= Integer.MAX_VALUE;
        }
        int c = 0;
        int mod1 = 0;
        if (b > 0) {
            c = a / b;
            mod1 = a % b;
        }
        if (anega && !bnega) {
            c += Integer.MIN_VALUE / -b;
            int mod2 = -(Integer.MIN_VALUE % b);
            if (mod1 + mod2 >= b) {
                ++c;
            }
        } else {
            if (!anega && bnega) {
                return 0;
            }
            if (anega && bnega) {
                if (a >= b) {
                    return 1;
                }
                return 0;
            }
        }
        return c;
    }

    @ActuallyUnsigned
    public static byte divideU8(@ActuallyUnsigned byte a, @ActuallyUnsigned byte b) {
        boolean bnega;
        if (b == 0) {
            throw new DivisionByZeroException();
        }
        if (a == 0) {
            return 0;
        }
        if (b == 1) {
            return a;
        }
        if (a == b) {
            return 1;
        }
        boolean anega = a < 0;
        boolean bl = bnega = b < 0;
        if (anega) {
            a = (byte)(a & 0x7F);
        }
        if (bnega) {
            b = (byte)(b & 0x7F);
        }
        byte c = 0;
        byte mod1 = 0;
        if (b > 0) {
            c = (byte)(a / b);
            mod1 = (byte)(a % b);
        }
        if (anega && !bnega) {
            c = (byte)(c + (byte)(-128 / -b));
            byte mod2 = (byte)(-(-128 % b));
            if (mod1 + mod2 >= b) {
                c = (byte)(c + 1);
            }
        } else {
            if (!anega && bnega) {
                return 0;
            }
            if (anega && bnega) {
                if (a >= b) {
                    return 1;
                }
                return 0;
            }
        }
        return c;
    }

    @ActuallyUnsigned
    public static long modulusU64(@ActuallyUnsigned long a, @ActuallyUnsigned long b) {
        long div = Unsigned.divideU64(a, b);
        long inaccurateA = div * b;
        return a - inaccurateA;
    }

    @ActuallyUnsigned
    public static int modulusU32(@ActuallyUnsigned int a, @ActuallyUnsigned int b) {
        int div = Unsigned.divideU32(a, b);
        int inaccurateA = div * b;
        return a - inaccurateA;
    }

    @ActuallyUnsigned
    public static byte modulusU8(@ActuallyUnsigned byte a, @ActuallyUnsigned byte b) {
        byte div = Unsigned.divideU8(a, b);
        byte inaccurateA = (byte)(div * b);
        return (byte)(a - inaccurateA);
    }

    public static boolean lessThanU8(@ActuallyUnsigned byte a, @ActuallyUnsigned byte b) {
        if (a < 0 && b >= 0) {
            return false;
        }
        if (a >= 0 && b < 0) {
            return true;
        }
        return a < b;
    }

    public static boolean lessThanU16(@ActuallyUnsigned short a, @ActuallyUnsigned short b) {
        if (a < 0 && b >= 0) {
            return false;
        }
        if (a >= 0 && b < 0) {
            return true;
        }
        return a < b;
    }

    public static boolean lessThanU32(@ActuallyUnsigned int a, @ActuallyUnsigned int b) {
        if (a < 0 && b >= 0) {
            return false;
        }
        if (a >= 0 && b < 0) {
            return true;
        }
        return a < b;
    }

    public static boolean lessThanU64(@ActuallyUnsigned long a, @ActuallyUnsigned long b) {
        if (a < 0L && b >= 0L) {
            return false;
        }
        if (a >= 0L && b < 0L) {
            return true;
        }
        return a < b;
    }

    public static boolean greaterThanU8(@ActuallyUnsigned byte a, @ActuallyUnsigned byte b) {
        if (a < 0 && b >= 0) {
            return true;
        }
        if (a >= 0 && b < 0) {
            return false;
        }
        return a > b;
    }

    public static boolean greaterThanU16(@ActuallyUnsigned short a, @ActuallyUnsigned short b) {
        if (a < 0 && b >= 0) {
            return true;
        }
        if (a >= 0 && b < 0) {
            return false;
        }
        return a > b;
    }

    public static boolean greaterThanU32(@ActuallyUnsigned int a, @ActuallyUnsigned int b) {
        if (a < 0 && b >= 0) {
            return true;
        }
        if (a >= 0 && b < 0) {
            return false;
        }
        return a > b;
    }

    public static boolean greaterThanU64(@ActuallyUnsigned long a, @ActuallyUnsigned long b) {
        if (a < 0L && b >= 0L) {
            return true;
        }
        if (a >= 0L && b < 0L) {
            return false;
        }
        return a > b;
    }

    public static boolean lessThanEqualToU8(@ActuallyUnsigned byte a, @ActuallyUnsigned byte b) {
        if (a == b) {
            return true;
        }
        if (a < 0 && b >= 0) {
            return false;
        }
        if (a >= 0 && b < 0) {
            return true;
        }
        return a <= b;
    }

    public static boolean lessThanEqualToU16(@ActuallyUnsigned short a, @ActuallyUnsigned short b) {
        if (a == b) {
            return true;
        }
        if (a < 0 && b >= 0) {
            return false;
        }
        if (a >= 0 && b < 0) {
            return true;
        }
        return a <= b;
    }

    public static boolean lessThanEqualToU32(@ActuallyUnsigned int a, @ActuallyUnsigned int b) {
        if (a == b) {
            return true;
        }
        if (a < 0 && b >= 0) {
            return false;
        }
        if (a >= 0 && b < 0) {
            return true;
        }
        return a <= b;
    }

    public static boolean lessThanEqualToU64(@ActuallyUnsigned long a, @ActuallyUnsigned long b) {
        if (a == b) {
            return true;
        }
        if (a < 0L && b >= 0L) {
            return false;
        }
        if (a >= 0L && b < 0L) {
            return true;
        }
        return a <= b;
    }

    public static boolean greaterThanEqualToU8(@ActuallyUnsigned byte a, @ActuallyUnsigned byte b) {
        if (a == b) {
            return true;
        }
        if (a < 0 && b >= 0) {
            return true;
        }
        if (a >= 0 && b < 0) {
            return false;
        }
        return a >= b;
    }

    public static boolean greaterThanEqualToU16(@ActuallyUnsigned short a, @ActuallyUnsigned short b) {
        if (a == b) {
            return true;
        }
        if (a < 0 && b >= 0) {
            return true;
        }
        if (a >= 0 && b < 0) {
            return false;
        }
        return a >= b;
    }

    public static boolean greaterThanEqualToU32(@ActuallyUnsigned int a, @ActuallyUnsigned int b) {
        if (a == b) {
            return true;
        }
        if (a < 0 && b >= 0) {
            return true;
        }
        if (b < 0 && a >= 0) {
            return false;
        }
        return a >= b;
    }

    public static boolean greaterThanEqualToU64(@ActuallyUnsigned long a, @ActuallyUnsigned long b) {
        if (a == b) {
            return true;
        }
        if (a < 0L && b >= 0L) {
            return true;
        }
        if (a >= 0L && b < 0L) {
            return false;
        }
        return a >= b;
    }

    public static int upcast(@ActuallyUnsigned byte b) {
        return Unsigned.upcastTo32(b);
    }

    public static int upcast(@ActuallyUnsigned short b) {
        return Unsigned.upcastTo32(b);
    }

    public static long upcast(@ActuallyUnsigned int b) {
        return Unsigned.upcastTo64(b);
    }

    public static int upcastTo32(@ActuallyUnsigned byte b) {
        return b & 0xFF;
    }

    public static int upcastTo32(@ActuallyUnsigned short b) {
        return b & 0xFFFF;
    }

    public static long upcastTo64(@ActuallyUnsigned byte b) {
        return (long)b & 0xFFL;
    }

    public static long upcastTo64(@ActuallyUnsigned short b) {
        return (long)b & 0xFFFFL;
    }

    public static long upcastTo64(@ActuallyUnsigned int b) {
        return (long)b & 0xFFFFFFFFL;
    }

    public static int[] upcastAll(@ActuallyUnsigned byte[] a) {
        int[] rv = new int[a.length];
        int i = 0;
        while (i < a.length) {
            rv[i] = a[i] & 0xFF;
            ++i;
        }
        return rv;
    }

    public static int[] upcastAll(@ActuallyUnsigned short[] a) {
        int[] rv = new int[a.length];
        int i = 0;
        while (i < a.length) {
            rv[i] = a[i] & 0xFFFF;
            ++i;
        }
        return rv;
    }

    public static long[] upcastAll(@ActuallyUnsigned int[] a) {
        long[] rv = new long[a.length];
        int i = 0;
        while (i < a.length) {
            rv[i] = (long)a[i] & 0xFFFFFFFFL;
            ++i;
        }
        return rv;
    }

    public static float safeCastU8toF32(@ActuallyUnsigned byte unsigned) {
        return Unsigned.upcast(unsigned);
    }

    public static float safeCastU16toF32(char unsigned) {
        return Unsigned.upcast(unsigned);
    }

    public static float safeCastU32toF32(@ActuallyUnsigned int unsigned) {
        if (unsigned >= 0) {
            return unsigned;
        }
        return (float)(unsigned & Integer.MAX_VALUE) + 2.1474836E9f;
    }

    public static float safeCastU64toF32(@ActuallyUnsigned long unsigned) {
        if (unsigned >= 0L) {
            return unsigned;
        }
        return (float)(unsigned & Long.MAX_VALUE) + 9.223372E18f;
    }

    public static double safeCastU8toF64(@ActuallyUnsigned byte unsigned) {
        return Unsigned.upcast(unsigned);
    }

    public static double safeCastU16toF64(char unsigned) {
        return Unsigned.upcast(unsigned);
    }

    public static double safeCastU32toF64(@ActuallyUnsigned int unsigned) {
        if (unsigned >= 0) {
            return unsigned;
        }
        return (double)(unsigned & Integer.MAX_VALUE) + 2.147483648E9;
    }

    public static double safeCastU64toF64(@ActuallyUnsigned long unsigned) {
        if (unsigned >= 0L) {
            return unsigned;
        }
        return (double)(unsigned & Long.MAX_VALUE) + 9.223372036854776E18;
    }

    @ActuallyUnsigned
    public static int safeCastF32toU32(float floatingValue) throws OverflowException {
        if (floatingValue > 4.2949673E9f || floatingValue < 0.0f) {
            throw new OverflowException();
        }
        if (floatingValue > 2.1474836E9f) {
            return (int)(floatingValue - 2.1474836E9f) | Integer.MIN_VALUE;
        }
        return (int)floatingValue;
    }

    @ActuallyUnsigned
    public static long safeCastF32toU64(float floatingValue) throws OverflowException {
        if (floatingValue > 1.8446744E19f || floatingValue < 0.0f) {
            throw new OverflowException();
        }
        if (floatingValue > 9.223372E18f) {
            return (long)(floatingValue - 9.223372E18f) | Long.MIN_VALUE;
        }
        return (long)floatingValue;
    }

    @ActuallyUnsigned
    public static int safeCastF64toU32(double floatingValue) throws OverflowException {
        if (floatingValue > 4.294967295E9 || floatingValue < 0.0) {
            throw new OverflowException();
        }
        if (floatingValue > 2.147483647E9) {
            return (int)(floatingValue - 2.147483647E9) | Integer.MIN_VALUE;
        }
        return (int)floatingValue;
    }

    @ActuallyUnsigned
    public static long safeCastF64toU64(double floatingValue) throws OverflowException {
        if (floatingValue > 1.8446744073709552E19 || floatingValue < 0.0) {
            throw new OverflowException();
        }
        if (floatingValue > 9.223372036854776E18) {
            return (long)(floatingValue - 9.223372036854776E18) | Long.MIN_VALUE;
        }
        return (long)floatingValue;
    }

    public static short upcastU8toS16(@ActuallyUnsigned byte input) {
        return (short)(input & 0xFF);
    }

    public static int upcastU8toS32(@ActuallyUnsigned byte input) {
        return input & 0xFF;
    }

    public static long upcastU8toS64(@ActuallyUnsigned byte input) {
        return (long)input & 0xFFL;
    }

    public static long upcastU16toS64(@ActuallyUnsigned short input) {
        return (long)input & 0xFFFFL;
    }

    public static long upcastU32toS64(@ActuallyUnsigned int input) {
        return (long)input & 0xFFFFFFFFL;
    }

    public static char upcastU8toU16(@ActuallyUnsigned byte input) {
        return (char)(input & 0xFF);
    }

    @ActuallyUnsigned
    public static int upcastU8toU32(@ActuallyUnsigned byte input) {
        return input & 0xFF;
    }

    @ActuallyUnsigned
    public static long upcastU8toU64(@ActuallyUnsigned byte input) {
        return (long)input & 0xFFL;
    }

    @ActuallyUnsigned
    public static long upcastU32toU64(@ActuallyUnsigned int input) {
        return (long)input & 0xFFFFFFFFL;
    }

    public static short reinterpretLowBitsAsS16(char in) {
        return (short)in;
    }

    public static short reinterpretLowBitsAsS16(int in) {
        return (short)in;
    }

    public static short reinterpretLowBitsAsS16(long in) {
        return (short)in;
    }

    public static char reinterpretLowBitsAsU16(short in) {
        return (char)in;
    }

    public static char reinterpretLowBitsAsU16(int in) {
        return (char)in;
    }

    public static char reinterpretLowBitsAsU16(long in) {
        return (char)in;
    }

    public static int reinterpretLowBitsAsU24(int in) {
        return in & 0xFFFFFF;
    }

    public static int reinterpretLowBitsAsU24(long in) {
        return Unsigned.reinterpretLowBitsAsU24((int)in);
    }

    public static int reinterpretLowBitsAsS24(int in) {
        return Unsigned.signextendInt24(in & 0xFFFFFF);
    }

    public static int reinterpretLowBitsAsS24(long in) {
        return Unsigned.reinterpretLowBitsAsS24((int)in);
    }

    public static int reinterpretLowBitsAsS32(long in) {
        return (int)in;
    }

    public static long reinterpretLowBitsAsU40(long in) {
        return in & 0xFFFFFFFFFFL;
    }

    public static long reinterpretLowBitsAsS40(long in) {
        return Unsigned.signextendLong40(in & 0xFFFFFFFFFFL);
    }

    public static long reinterpretLowBitsAsU48(long in) {
        return in & 0xFFFFFFFFFFFFL;
    }

    public static long reinterpretLowBitsAsS48(long in) {
        return Unsigned.signextendLong48(in & 0xFFFFFFFFFFFFL);
    }

    public static long reinterpretLowBitsAsU56(long in) {
        return in & 0xFFFFFFFFFFFFFFL;
    }

    public static long reinterpretLowBitsAsS56(long in) {
        return Unsigned.signextendLong56(in & 0xFFFFFFFFFFFFFFL);
    }

    public static long reinterpretLowBitsAsU32(int in) {
        return in & 0xFFFFFFFF;
    }

    public static long reinterpretLowBitsAsU32(long in) {
        return in & 0xFFFFFFFFFFFFFFFFL;
    }

    public static int signextendInt24(int value24) {
        return value24 | ((value24 & 0x800000) >>> 23) * -16777216;
    }

    public static long signextendLong40(long value40) {
        return value40 | ((value40 & 0x8000000000L) >>> 39) * -1099511627776L;
    }

    public static long signextendLong48(long value48) {
        return value48 | ((value48 & 0x800000000000L) >>> 47) * -281474976710656L;
    }

    public static long signextendLong56(long value56) {
        return value56 | ((value56 & 0x80000000000000L) >>> 55) * -72057594037927936L;
    }
}

