/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.primitives;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class UnsignedLong
extends Number
implements Comparable<UnsignedLong>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final long UNSIGNED_MASK = Long.MAX_VALUE;
    public static final UnsignedLong ZERO = new UnsignedLong(0L);
    public static final UnsignedLong ONE = new UnsignedLong(1L);
    public static final UnsignedLong MAX_VALUE = new UnsignedLong(-1L);
    private final long value;
    private static final int[] maxSafeDigits = new int[37];
    private static final long[] maxValueDivs = new long[37];
    private static final int[] maxValueMods = new int[37];

    private UnsignedLong(long value) {
        this.value = value;
    }

    public static UnsignedLong fromLongBits(long bits) {
        return new UnsignedLong(bits);
    }

    public static UnsignedLong valueOf(long value) {
        if (value < 0L) {
            throw new IllegalArgumentException("value (" + value + ") is outside the range for an unsigned long value");
        }
        return UnsignedLong.fromLongBits(value);
    }

    public static UnsignedLong valueOf(BigInteger value) {
        Objects.requireNonNull(value);
        if (value.signum() < 0 || value.bitLength() > 64) {
            throw new IllegalArgumentException("value (" + value + ") is outside the range for an unsigned long value");
        }
        return UnsignedLong.fromLongBits(value.longValue());
    }

    public static UnsignedLong valueOf(String string) {
        return UnsignedLong.valueOf(string, 10);
    }

    public static UnsignedLong valueOf(String string, int radix) {
        return UnsignedLong.fromLongBits(UnsignedLong.parseUnsignedLong(string, radix));
    }

    @CheckReturnValue
    public UnsignedLong plus(UnsignedLong val) {
        return UnsignedLong.fromLongBits(this.value + Objects.requireNonNull(val).value);
    }

    @CheckReturnValue
    public UnsignedLong minus(UnsignedLong val) {
        return UnsignedLong.fromLongBits(this.value - Objects.requireNonNull(val).value);
    }

    @CheckReturnValue
    public UnsignedLong times(UnsignedLong val) {
        return UnsignedLong.fromLongBits(this.value * Objects.requireNonNull(val).value);
    }

    @CheckReturnValue
    public UnsignedLong dividedBy(UnsignedLong val) {
        return UnsignedLong.fromLongBits(UnsignedLong.divide(this.value, Objects.requireNonNull(val).value));
    }

    @CheckReturnValue
    public UnsignedLong mod(UnsignedLong val) {
        return UnsignedLong.fromLongBits(UnsignedLong.remainder(this.value, Objects.requireNonNull(val).value));
    }

    @Override
    public int intValue() {
        return (int)this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public float floatValue() {
        float fValue = this.value & Long.MAX_VALUE;
        if (this.value < 0L) {
            fValue += 9.223372E18f;
        }
        return fValue;
    }

    @Override
    public double doubleValue() {
        double dValue = this.value & Long.MAX_VALUE;
        if (this.value < 0L) {
            dValue += 9.223372036854776E18;
        }
        return dValue;
    }

    public BigInteger bigIntegerValue() {
        BigInteger bigInt = BigInteger.valueOf(this.value & Long.MAX_VALUE);
        if (this.value < 0L) {
            bigInt = bigInt.setBit(63);
        }
        return bigInt;
    }

    @Override
    public int compareTo(UnsignedLong o) {
        Objects.requireNonNull(o);
        return UnsignedLong.compare(this.value, o.value);
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj instanceof UnsignedLong) {
            UnsignedLong other = (UnsignedLong)obj;
            return this.value == other.value;
        }
        return false;
    }

    public String toString() {
        return UnsignedLong.toString(this.value);
    }

    public String toString(int radix) {
        return UnsignedLong.toString(this.value, radix);
    }

    @CheckReturnValue
    private static String toString(long x) {
        return UnsignedLong.toString(x, 10);
    }

    @CheckReturnValue
    private static String toString(long x, int radix) {
        if (radix < 2 || radix > 36) {
            throw new IllegalArgumentException("radix (" + radix + ") must be between Character.MIN_RADIX and Character.MAX_RADIX");
        }
        if (x == 0L) {
            return "0";
        }
        char[] buf = new char[64];
        int i = buf.length;
        if (x < 0L) {
            long quotient = UnsignedLong.divide(x, radix);
            long rem = x - quotient * (long)radix;
            buf[--i] = Character.forDigit((int)rem, radix);
            x = quotient;
        }
        while (x > 0L) {
            buf[--i] = Character.forDigit((int)(x % (long)radix), radix);
            x /= (long)radix;
        }
        return new String(buf, i, buf.length - i);
    }

    private static long parseUnsignedLong(String s, int radix) {
        Objects.requireNonNull(s);
        if (s.length() == 0) {
            throw new NumberFormatException("empty string");
        }
        if (radix < 2 || radix > 36) {
            throw new NumberFormatException("illegal radix: " + radix);
        }
        int max_safe_pos = maxSafeDigits[radix] - 1;
        long value = 0L;
        int pos = 0;
        while (pos < s.length()) {
            int digit = Character.digit(s.charAt(pos), radix);
            if (digit == -1) {
                throw new NumberFormatException(s);
            }
            if (pos > max_safe_pos && UnsignedLong.overflowInParse(value, digit, radix)) {
                throw new NumberFormatException("Too large for unsigned long: " + s);
            }
            value = value * (long)radix + (long)digit;
            ++pos;
        }
        return value;
    }

    private static boolean overflowInParse(long current, int digit, int radix) {
        if (current >= 0L) {
            if (current < maxValueDivs[radix]) {
                return false;
            }
            if (current > maxValueDivs[radix]) {
                return true;
            }
            return digit > maxValueMods[radix];
        }
        return true;
    }

    @CheckReturnValue
    private static long divide(long dividend, long divisor) {
        long quotient;
        if (divisor < 0L) {
            if (UnsignedLong.compare(dividend, divisor) < 0) {
                return 0L;
            }
            return 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long rem = dividend - (quotient = (dividend >>> 1) / divisor << 1) * divisor;
        return quotient + (long)(UnsignedLong.compare(rem, divisor) >= 0 ? 1 : 0);
    }

    @CheckReturnValue
    private static int compare(long a, long b) {
        return (a = UnsignedLong.flip(a)) < (b = UnsignedLong.flip(b)) ? -1 : (a > b ? 1 : 0);
    }

    private static long flip(long a) {
        return a ^ Long.MIN_VALUE;
    }

    @CheckReturnValue
    private static long remainder(long dividend, long divisor) {
        long rem;
        if (divisor < 0L) {
            if (UnsignedLong.compare(dividend, divisor) < 0) {
                return dividend;
            }
            return dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        return rem - (UnsignedLong.compare(rem = dividend - quotient * divisor, divisor) >= 0 ? divisor : 0L);
    }
}

