/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.List;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.semantic.SignalType;
import rebound.annotations.semantic.temporal.ConstantReturnValue;
import rebound.util.collections.KnowsLengthFixedness;
import rebound.util.collections.PolymorphicCollectionUtilities;
import rebound.util.collections.Slice;
import rebound.util.collections.TransparentContiguousArrayBackedCollection;
import rebound.util.collections.WeakCollection;
import rebound.util.objectutil.UnderlyingInstanceAccessible;

@SignalType
public interface Sublist<E>
extends List<E>,
UnderlyingInstanceAccessible<List<E>>,
KnowsLengthFixedness,
TransparentContiguousArrayBackedCollection,
WeakCollection {
    @Override
    @ConstantReturnValue
    @ImplementationTransparency
    public List<E> getUnderlying();

    @ConstantReturnValue
    @ImplementationTransparency
    public int getSublistStartingIndex();

    @Override
    default public Boolean isFixedLengthNotVariableLength() {
        return PolymorphicCollectionUtilities.isFixedLengthNotVariableLength(this.getUnderlying());
    }

    @Override
    default public boolean isWeakCollection() {
        return WeakCollection.is(this.getUnderlying());
    }

    @Override
    default public boolean isTransparentContiguousArrayBackedCollection() {
        return TransparentContiguousArrayBackedCollection.is(this.getUnderlying());
    }

    default public Slice<?> getLiveContiguousArrayBackingUNSAFE() {
        Slice s = ((TransparentContiguousArrayBackedCollection)this.getUnderlying()).getLiveContiguousArrayBackingUNSAFE();
        return (Slice)s.subslice(this.getSublistStartingIndex(), this.size());
    }
}

