/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.hints.IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser;
import rebound.util.collections.CollectionWithGetArbitraryElement;
import rebound.util.collections.CollectionWithGetExtantInstanceNatural;
import rebound.util.collections.CollectionWithPopArbitraryElement;

public class MapSet<E, V>
extends AbstractSet<E>
implements CollectionWithGetArbitraryElement<E>,
CollectionWithPopArbitraryElement<E>,
CollectionWithGetExtantInstanceNatural<E> {
    protected Map<E, V> underlyingMap;

    public MapSet() {
    }

    public MapSet(Map<E, V> underlyingMap) {
        this.underlyingMap = underlyingMap;
    }

    @ImplementationTransparency
    public Map<E, V> getUnderlyingMap() {
        return this.underlyingMap;
    }

    @ImplementationTransparency
    public void setUnderlyingMap(Map<E, V> underlyingMap) {
        this.underlyingMap = underlyingMap;
    }

    @Override
    public Iterator<E> iterator() {
        return this.underlyingMap.keySet().iterator();
    }

    @Override
    public int size() {
        return this.underlyingMap.size();
    }

    @Override
    public boolean add(E e) {
        boolean previouslyContained = this.contains(e);
        if (!previouslyContained) {
            Object dummyValue = this.usesElementsAsTheirOwnValues() ? e : this.getDummyValueIfNotUsingElementsThemselves();
            this.underlyingMap.put(e, dummyValue);
        }
        return !previouslyContained;
    }

    @Override
    public boolean addAll(Iterable<? extends E> c) {
        boolean atLeastOne = false;
        for (E e : c) {
            atLeastOne |= this.add(e);
        }
        return atLeastOne;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll((Iterable<? extends E>)c);
    }

    @Override
    public boolean remove(Object o) {
        return this.underlyingMap.remove(o) != null;
    }

    @Override
    public void clear() {
        this.underlyingMap.clear();
    }

    @Override
    public boolean isEmpty() {
        return this.underlyingMap.isEmpty();
    }

    @Override
    public int hashCode() {
        return this.underlyingMap.keySet().hashCode();
    }

    @Override
    public boolean contains(Object o) {
        return this.underlyingMap.containsKey(o);
    }

    @Override
    public E popArbitraryElement() {
        if (this.isEmpty()) {
            return null;
        }
        Iterator<E> i = this.iterator();
        if (!i.hasNext()) {
            return null;
        }
        E e = i.next();
        i.remove();
        return e;
    }

    @Override
    public E getArbitraryElement() {
        if (this.isEmpty()) {
            return null;
        }
        Iterator<E> i = this.iterator();
        if (!i.hasNext()) {
            return null;
        }
        E e = i.next();
        return e;
    }

    public E getArbitraryElementFromAntiIntersection(Set<E> otherSet) {
        if (this.isEmpty()) {
            return null;
        }
        if (otherSet.isEmpty()) {
            return this.getArbitraryElement();
        }
        for (E e : this) {
            if (otherSet.contains(e)) continue;
            return e;
        }
        return null;
    }

    @Override
    public E getExtantInstance(E possiblyEquivalentButDifferentInstance) {
        if (!this.usesElementsAsTheirOwnValues()) {
            throw new UnsupportedOperationException();
        }
        return (E)this.underlyingMap.get(possiblyEquivalentButDifferentInstance);
    }

    @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
    public boolean usesElementsAsTheirOwnValues() {
        return true;
    }

    @IntendedToOptionallyBeSubclassedImplementedOrOverriddenByApiUser
    protected V getDummyValueIfNotUsingElementsThemselves() {
        return null;
    }
}

