/*
 * Decompiled with CFR 0.152.
 */
package rebound.util.collections;

import java.util.Iterator;
import java.util.NoSuchElementException;
import rebound.exceptions.ImpossibleException;

public class ConcatenatingIterator<E>
implements Iterator<E> {
    protected Iterator<Iterator<E>> underlying;
    protected boolean bof = true;
    protected boolean alreadyRemoved = false;
    protected Iterator<E> previous;
    protected Iterator<E> current;
    protected boolean bofInCurrent;

    public ConcatenatingIterator(Iterator<Iterator<E>> underlying) {
        this.underlying = underlying;
        this.advanceIterators();
        this.bofInCurrent = true;
    }

    protected void advanceIterators() {
        do {
            if (!this.underlying.hasNext()) {
                this.current = null;
                return;
            }
            this.current = this.underlying.next();
        } while (!this.current.hasNext());
    }

    @Override
    public boolean hasNext() {
        if (this.current == null) {
            return false;
        }
        if (!this.current.hasNext()) {
            throw new ImpossibleException();
        }
        return true;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.current == null) {
            throw new ImpossibleException();
        }
        this.bof = false;
        this.alreadyRemoved = false;
        while (true) {
            if (this.current.hasNext()) {
                this.bofInCurrent = false;
                E e = this.current.next();
                if (!this.current.hasNext()) {
                    this.advanceIterators();
                }
                return e;
            }
            this.previous = this.current;
            this.bofInCurrent = true;
            this.advanceIterators();
        }
    }

    @Override
    public void remove() {
        if (this.bof || this.alreadyRemoved) {
            throw new IllegalStateException();
        }
        if (this.bofInCurrent) {
            if (this.previous == null) {
                throw new ImpossibleException();
            }
            this.previous.remove();
        } else {
            this.current.remove();
        }
        this.alreadyRemoved = true;
    }
}

