/*
 * Decompiled with CFR 0.152.
 */
package rebound.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import rebound.annotations.semantic.simpledata.ActuallyUnsigned;
import rebound.bits.BitUtilities;
import rebound.bits.BitfieldSafeCasts;
import rebound.exceptions.StructuredClassCastException;
import rebound.util.BasicExceptionUtilities;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;

public class Primitives
implements JavaNamespace {
    public static final int JSIZEOF_BYTES_BYTE = 1;
    public static final int JSIZEOF_BYTES_CHAR = 2;
    public static final int JSIZEOF_BYTES_SHORT = 2;
    public static final int JSIZEOF_BYTES_FLOAT = 4;
    public static final int JSIZEOF_BYTES_INT = 4;
    public static final int JSIZEOF_BYTES_DOUBLE = 8;
    public static final int JSIZEOF_BYTES_LONG = 8;
    public static final int JSIZEOF_BITS_BYTE = 8;
    public static final int JSIZEOF_BITS_CHAR = 16;
    public static final int JSIZEOF_BITS_SHORT = 16;
    public static final int JSIZEOF_BITS_FLOAT = 32;
    public static final int JSIZEOF_BITS_INT = 32;
    public static final int JSIZEOF_BITS_DOUBLE = 64;
    public static final int JSIZEOF_BITS_LONG = 64;
    public static final float FLOAT_MIN_VALUE = Float.MIN_VALUE;
    public static final float FLOAT_MAX_VALUE = Float.MAX_VALUE;
    public static final double DOUBLE_MIN_VALUE = Double.MIN_VALUE;
    public static final double DOUBLE_MAX_VALUE = Double.MAX_VALUE;
    public static final byte BYTE_MIN_VALUE = -128;
    public static final short SHORT_MIN_VALUE = Short.MIN_VALUE;
    public static final int SINT24_MIN_VALUE = -8388608;
    public static final int INT_MIN_VALUE = Integer.MIN_VALUE;
    public static final long SLONG40_MIN_VALUE = -549755813888L;
    public static final long SLONG48_MIN_VALUE = -140737488355328L;
    public static final long SLONG56_MIN_VALUE = -36028797018963968L;
    public static final long LONG_MIN_VALUE = Long.MIN_VALUE;
    public static final byte BYTE_MAX_VALUE = 127;
    public static final short SHORT_MAX_VALUE = Short.MAX_VALUE;
    public static final int SINT24_MAX_VALUE = 0x7FFFFF;
    public static final int INT_MAX_VALUE = Integer.MAX_VALUE;
    public static final long SLONG40_MAX_VALUE = 0x7FFFFFFFFFL;
    public static final long SLONG48_MAX_VALUE = 0x7FFFFFFFFFFFL;
    public static final long SLONG56_MAX_VALUE = 0x7FFFFFFFFFFFFFL;
    public static final long LONG_MAX_VALUE = Long.MAX_VALUE;
    public static final char CHAR_MIN_VALUE = '\u0000';
    public static final int UINT24_MIN_VALUE = 0;
    public static final long ULONG40_MIN_VALUE = 0L;
    public static final long ULONG48_MIN_VALUE = 0L;
    public static final long ULONG56_MIN_VALUE = 0L;
    public static final char CHAR_MAX_VALUE = '\uffff';
    public static final int UINT24_MAX_VALUE = 0xFFFFFF;
    public static final long ULONG40_MAX_VALUE = 0xFFFFFFFFFFL;
    public static final long ULONG48_MAX_VALUE = 0xFFFFFFFFFFFFL;
    public static final long ULONG56_MAX_VALUE = 0xFFFFFFFFFFFFFFL;
    public static final long S8_MIN_VALUE = -128L;
    public static final long S16_MIN_VALUE = -32768L;
    public static final long S24_MIN_VALUE = -8388608L;
    public static final long S32_MIN_VALUE = Integer.MIN_VALUE;
    public static final long S40_MIN_VALUE = -549755813888L;
    public static final long S48_MIN_VALUE = -140737488355328L;
    public static final long S56_MIN_VALUE = -36028797018963968L;
    public static final long S64_MIN_VALUE = Long.MIN_VALUE;
    public static final long S8_MAX_VALUE = 127L;
    public static final long S16_MAX_VALUE = 32767L;
    public static final long S24_MAX_VALUE = 0x7FFFFFL;
    public static final long S32_MAX_VALUE = Integer.MAX_VALUE;
    public static final long S40_MAX_VALUE = 0x7FFFFFFFFFL;
    public static final long S48_MAX_VALUE = 0x7FFFFFFFFFFFL;
    public static final long S56_MAX_VALUE = 0x7FFFFFFFFFFFFFL;
    public static final long S64_MAX_VALUE = Long.MAX_VALUE;
    public static final long U8_MIN_VALUE = 0L;
    public static final long U16_MIN_VALUE = 0L;
    public static final long U24_MIN_VALUE = 0L;
    public static final long U32_MIN_VALUE = 0L;
    public static final long U40_MIN_VALUE = 0L;
    public static final long U48_MIN_VALUE = 0L;
    public static final long U56_MIN_VALUE = 0L;
    public static final long U64_MIN_VALUE = 0L;
    public static final long U8_MAX_VALUE = 255L;
    public static final long U16_MAX_VALUE = 65535L;
    public static final long U24_MAX_VALUE = 0xFFFFFFL;
    public static final long U32_MAX_VALUE = 0xFFFFFFFFL;
    public static final long U40_MAX_VALUE = 0xFFFFFFFFFFL;
    public static final long U48_MAX_VALUE = 0xFFFFFFFFFFFFL;
    public static final long U56_MAX_VALUE = 0xFFFFFFFFFFFFFFL;
    @ActuallyUnsigned
    public static final long U64_MAX_VALUE = -1L;
    public static final List<Class> Primitive_Types = Collections.unmodifiableList(Arrays.asList(Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Float.TYPE, Integer.TYPE, Double.TYPE, Long.TYPE));
    public static final List<Class> Primitive_Wrapper_Types = Collections.unmodifiableList(Arrays.asList(Boolean.class, Byte.class, Character.class, Short.class, Float.class, Integer.class, Double.class, Long.class));

    public static boolean eqSane(float a, float b) {
        return a == b || a != a && b != b;
    }

    public static boolean eqSane(double a, double b) {
        return a == b || a != a && b != b;
    }

    public static boolean eqSane(Float a, Float b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return Primitives.eqSane(a.floatValue(), b.floatValue());
    }

    public static boolean eqSane(Double a, Double b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        return Primitives.eqSane((double)a, (double)b);
    }

    public static boolean eqSane(boolean a, boolean b) {
        return a == b;
    }

    public static boolean eqSane(byte a, byte b) {
        return a == b;
    }

    public static boolean eqSane(char a, char b) {
        return a == b;
    }

    public static boolean eqSane(short a, short b) {
        return a == b;
    }

    public static boolean eqSane(int a, int b) {
        return a == b;
    }

    public static boolean eqSane(long a, long b) {
        return a == b;
    }

    public static boolean isTrueAndNotNull(Object x) {
        return x != null && x instanceof Boolean && (Boolean)x != false;
    }

    public static boolean isFalseAndNotNull(Object x) {
        return x != null && x instanceof Boolean && (Boolean)x == false;
    }

    public static boolean isTrueOrNull(Boolean x) {
        return x == null || x != false;
    }

    public static boolean isFalseOrNull(Boolean x) {
        return x == null || x == false;
    }

    public static boolean falseIfNullOrPass(Boolean x) {
        return x != null && x != false;
    }

    public static boolean trueIfNullOrPass(Boolean x) {
        return x == null || x != false;
    }

    public static boolean eq(Boolean a, Boolean b) {
        return BasicObjectUtilities.eq((Object)a, (Object)b);
    }

    public static boolean eq(Boolean a, boolean b) {
        return a != null && a == b;
    }

    public static boolean eq(boolean a, Boolean b) {
        return b != null && b == a;
    }

    public static boolean eq(boolean a, boolean b) {
        return a == b;
    }

    public static boolean eq(Character a, Character b) {
        return BasicObjectUtilities.eq((Object)a, (Object)b);
    }

    public static boolean eq(Character a, char b) {
        return a != null && a.charValue() == b;
    }

    public static boolean eq(char a, Character b) {
        return b != null && b.charValue() == a;
    }

    public static boolean eq(char a, char b) {
        return a == b;
    }

    public static boolean eq(Byte a, Byte b) {
        return BasicObjectUtilities.eq((Object)a, (Object)b);
    }

    public static boolean eq(Byte a, byte b) {
        return a != null && a == b;
    }

    public static boolean eq(byte a, Byte b) {
        return b != null && b == a;
    }

    public static boolean eq(byte a, byte b) {
        return a == b;
    }

    public static boolean eq(Short a, Short b) {
        return BasicObjectUtilities.eq((Object)a, (Object)b);
    }

    public static boolean eq(Short a, short b) {
        return a != null && a == b;
    }

    public static boolean eq(short a, Short b) {
        return b != null && b == a;
    }

    public static boolean eq(short a, short b) {
        return a == b;
    }

    public static boolean eq(Integer a, Integer b) {
        return BasicObjectUtilities.eq((Object)a, (Object)b);
    }

    public static boolean eq(Integer a, int b) {
        return a != null && a == b;
    }

    public static boolean eq(int a, Integer b) {
        return b != null && b == a;
    }

    public static boolean eq(int a, int b) {
        return a == b;
    }

    public static boolean eq(Long a, Long b) {
        return BasicObjectUtilities.eq((Object)a, (Object)b);
    }

    public static boolean eq(Long a, long b) {
        return a != null && a == b;
    }

    public static boolean eq(long a, Long b) {
        return b != null && b == a;
    }

    public static boolean eq(long a, long b) {
        return a == b;
    }

    public static boolean eq(Float a, Float b) {
        return BasicObjectUtilities.eq((Object)a, (Object)b);
    }

    public static boolean eq(Float a, float b) {
        return a != null && a.floatValue() == b;
    }

    public static boolean eq(float a, Float b) {
        return b != null && b.floatValue() == a;
    }

    public static boolean eq(float a, float b) {
        return a == b;
    }

    public static boolean eq(Double a, Double b) {
        return BasicObjectUtilities.eq((Object)a, (Object)b);
    }

    public static boolean eq(Double a, double b) {
        return a != null && a == b;
    }

    public static boolean eq(double a, Double b) {
        return b != null && b == a;
    }

    public static boolean eq(double a, double b) {
        return a == b;
    }

    public static boolean numeqPrimitiveWrappers(Object a, Object b) {
        a = Primitives.normalizeIfIntegerPrimitive(a);
        b = Primitives.normalizeIfIntegerPrimitive(b);
        if (a instanceof Long) {
            long aa = (Long)a;
            if (b instanceof Long) {
                long bb = (Long)b;
                return aa == bb;
            }
            if (b instanceof Double) {
                double bb = (Double)b;
                return (double)aa == bb;
            }
            if (b instanceof Float) {
                float bb = ((Float)b).floatValue();
                return (float)aa == bb;
            }
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(b);
        }
        if (a instanceof Double) {
            double aa = (Double)a;
            if (b instanceof Long) {
                long bb = (Long)b;
                return aa == (double)bb;
            }
            if (b instanceof Double) {
                double bb = (Double)b;
                return aa == bb;
            }
            if (b instanceof Float) {
                float bb = ((Float)b).floatValue();
                return aa == (double)bb;
            }
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(b);
        }
        if (a instanceof Float) {
            float aa = ((Float)a).floatValue();
            if (b instanceof Long) {
                long bb = (Long)b;
                return aa == (float)bb;
            }
            if (b instanceof Double) {
                double bb = (Double)b;
                return (double)aa == bb;
            }
            if (b instanceof Float) {
                float bb = ((Float)b).floatValue();
                return aa == bb;
            }
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(b);
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(b);
    }

    public static boolean unboxNT(Boolean wrappedValue, boolean nullValue) {
        return wrappedValue == null ? nullValue : wrappedValue;
    }

    public static byte unboxNT(Byte wrappedValue, byte nullValue) {
        return wrappedValue == null ? nullValue : wrappedValue;
    }

    public static short unboxNT(Short wrappedValue, short nullValue) {
        return wrappedValue == null ? nullValue : wrappedValue;
    }

    public static char unboxNT(Character wrappedValue, char nullValue) {
        return wrappedValue == null ? nullValue : wrappedValue.charValue();
    }

    public static int unboxNT(Integer wrappedValue, int nullValue) {
        return wrappedValue == null ? nullValue : wrappedValue;
    }

    public static float unboxNT(Float wrappedValue, float nullValue) {
        return wrappedValue == null ? nullValue : wrappedValue.floatValue();
    }

    public static long unboxNT(Long wrappedValue, long nullValue) {
        return wrappedValue == null ? nullValue : wrappedValue;
    }

    public static double unboxNT(Double wrappedValue, double nullValue) {
        return wrappedValue == null ? nullValue : wrappedValue;
    }

    public static <E> E[] box(Object primitiveArray) {
        if (primitiveArray == null) {
            return null;
        }
        if (primitiveArray instanceof boolean[]) {
            return Primitives.box((boolean[])primitiveArray);
        }
        if (primitiveArray instanceof byte[]) {
            return Primitives.box((byte[])primitiveArray);
        }
        if (primitiveArray instanceof char[]) {
            return Primitives.box((char[])primitiveArray);
        }
        if (primitiveArray instanceof short[]) {
            return Primitives.box((short[])primitiveArray);
        }
        if (primitiveArray instanceof float[]) {
            return Primitives.box((float[])primitiveArray);
        }
        if (primitiveArray instanceof int[]) {
            return Primitives.box((int[])primitiveArray);
        }
        if (primitiveArray instanceof double[]) {
            return Primitives.box((double[])primitiveArray);
        }
        if (primitiveArray instanceof long[]) {
            return Primitives.box((long[])primitiveArray);
        }
        throw new StructuredClassCastException(primitiveArray.getClass());
    }

    public static void boxInto(Object primitiveArray, Object[] destWrapperArray) {
        if (primitiveArray instanceof boolean[]) {
            Primitives.boxInto((boolean[])primitiveArray, destWrapperArray);
        } else if (primitiveArray instanceof byte[]) {
            Primitives.boxInto((byte[])primitiveArray, destWrapperArray);
        } else if (primitiveArray instanceof char[]) {
            Primitives.boxInto((char[])primitiveArray, destWrapperArray);
        } else if (primitiveArray instanceof short[]) {
            Primitives.boxInto((short[])primitiveArray, destWrapperArray);
        } else if (primitiveArray instanceof float[]) {
            Primitives.boxInto((float[])primitiveArray, destWrapperArray);
        } else if (primitiveArray instanceof int[]) {
            Primitives.boxInto((int[])primitiveArray, destWrapperArray);
        } else if (primitiveArray instanceof double[]) {
            Primitives.boxInto((double[])primitiveArray, destWrapperArray);
        } else if (primitiveArray instanceof long[]) {
            Primitives.boxInto((long[])primitiveArray, destWrapperArray);
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(primitiveArray);
        }
    }

    public static Object unbox(Object[] wrapperArray) {
        if (wrapperArray == null) {
            return null;
        }
        if (wrapperArray instanceof Boolean[]) {
            return Primitives.unbox((Boolean[])wrapperArray);
        }
        if (wrapperArray instanceof Byte[]) {
            return Primitives.unbox((Byte[])wrapperArray);
        }
        if (wrapperArray instanceof Character[]) {
            return Primitives.unbox((Character[])wrapperArray);
        }
        if (wrapperArray instanceof Short[]) {
            return Primitives.unbox((Short[])wrapperArray);
        }
        if (wrapperArray instanceof Float[]) {
            return Primitives.unbox((Float[])wrapperArray);
        }
        if (wrapperArray instanceof Integer[]) {
            return Primitives.unbox((Integer[])wrapperArray);
        }
        if (wrapperArray instanceof Double[]) {
            return Primitives.unbox((Double[])wrapperArray);
        }
        if (wrapperArray instanceof Long[]) {
            return Primitives.unbox((Long[])wrapperArray);
        }
        throw new StructuredClassCastException(wrapperArray.getClass());
    }

    public static Object unboxNT(Object[] wrapperArray, Object nullValue) {
        if (wrapperArray == null) {
            return null;
        }
        if (wrapperArray instanceof Boolean[]) {
            return Primitives.unboxNT(wrapperArray, nullValue);
        }
        if (wrapperArray instanceof Byte[]) {
            return Primitives.unboxNT(wrapperArray, nullValue);
        }
        if (wrapperArray instanceof Character[]) {
            return Primitives.unboxNT(wrapperArray, nullValue);
        }
        if (wrapperArray instanceof Short[]) {
            return Primitives.unboxNT(wrapperArray, nullValue);
        }
        if (wrapperArray instanceof Float[]) {
            return Primitives.unboxNT(wrapperArray, nullValue);
        }
        if (wrapperArray instanceof Integer[]) {
            return Primitives.unboxNT(wrapperArray, nullValue);
        }
        if (wrapperArray instanceof Double[]) {
            return Primitives.unboxNT(wrapperArray, nullValue);
        }
        if (wrapperArray instanceof Long[]) {
            return Primitives.unboxNT(wrapperArray, nullValue);
        }
        throw new StructuredClassCastException(wrapperArray.getClass());
    }

    public static Object getBoxing(Object array, int index) {
        if (array instanceof boolean[]) {
            return ((boolean[])array)[index];
        }
        if (array instanceof byte[]) {
            return ((byte[])array)[index];
        }
        if (array instanceof char[]) {
            return Character.valueOf(((char[])array)[index]);
        }
        if (array instanceof short[]) {
            return ((short[])array)[index];
        }
        if (array instanceof float[]) {
            return Float.valueOf(((float[])array)[index]);
        }
        if (array instanceof int[]) {
            return ((int[])array)[index];
        }
        if (array instanceof double[]) {
            return ((double[])array)[index];
        }
        if (array instanceof long[]) {
            return ((long[])array)[index];
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(array);
    }

    public static void setBoxing(Object array, int index, Object value) {
        if (array instanceof boolean[]) {
            ((boolean[])array)[index] = (Boolean)value;
        } else if (array instanceof byte[]) {
            ((byte[])array)[index] = (Byte)value;
        } else if (array instanceof char[]) {
            ((char[])array)[index] = ((Character)value).charValue();
        } else if (array instanceof short[]) {
            ((short[])array)[index] = (Short)value;
        } else if (array instanceof float[]) {
            ((float[])array)[index] = ((Float)value).floatValue();
        } else if (array instanceof int[]) {
            ((int[])array)[index] = (Integer)value;
        } else if (array instanceof double[]) {
            ((double[])array)[index] = (Double)value;
        } else if (array instanceof long[]) {
            ((long[])array)[index] = (Long)value;
        } else {
            throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(array);
        }
    }

    public static Boolean[] box(boolean[] src) {
        int srclen = src.length;
        Boolean[] rv = new Boolean[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static void boxInto(boolean[] src, Object[] dest) {
        int srclen = src.length;
        int i = 0;
        while (i < srclen) {
            dest[i] = src[i];
            ++i;
        }
    }

    public static boolean[] unbox(Boolean[] src) {
        int srclen = src.length;
        boolean[] rv = new boolean[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static boolean[] unboxNT(Boolean[] src, boolean nullValue) {
        int srclen = src.length;
        boolean[] rv = new boolean[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Primitives.unboxNT(src[i], nullValue);
            ++i;
        }
        return rv;
    }

    public static Byte[] box(byte[] src) {
        int srclen = src.length;
        Byte[] rv = new Byte[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static void boxInto(byte[] src, Object[] dest) {
        int srclen = src.length;
        int i = 0;
        while (i < srclen) {
            dest[i] = src[i];
            ++i;
        }
    }

    public static byte[] unbox(Byte[] src) {
        int srclen = src.length;
        byte[] rv = new byte[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static byte[] unboxNT(Byte[] src, byte nullValue) {
        int srclen = src.length;
        byte[] rv = new byte[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Primitives.unboxNT(src[i], nullValue);
            ++i;
        }
        return rv;
    }

    public static Character[] box(char[] src) {
        int srclen = src.length;
        Character[] rv = new Character[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Character.valueOf(src[i]);
            ++i;
        }
        return rv;
    }

    public static void boxInto(char[] src, Object[] dest) {
        int srclen = src.length;
        int i = 0;
        while (i < srclen) {
            dest[i] = Character.valueOf(src[i]);
            ++i;
        }
    }

    public static char[] unbox(Character[] src) {
        int srclen = src.length;
        char[] rv = new char[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i].charValue();
            ++i;
        }
        return rv;
    }

    public static char[] unboxNT(Character[] src, char nullValue) {
        int srclen = src.length;
        char[] rv = new char[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Primitives.unboxNT(src[i], nullValue);
            ++i;
        }
        return rv;
    }

    public static Short[] box(short[] src) {
        int srclen = src.length;
        Short[] rv = new Short[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static void boxInto(short[] src, Object[] dest) {
        int srclen = src.length;
        int i = 0;
        while (i < srclen) {
            dest[i] = src[i];
            ++i;
        }
    }

    public static short[] unbox(Short[] src) {
        int srclen = src.length;
        short[] rv = new short[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static short[] unboxNT(Short[] src, short nullValue) {
        int srclen = src.length;
        short[] rv = new short[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Primitives.unboxNT(src[i], nullValue);
            ++i;
        }
        return rv;
    }

    public static Float[] box(float[] src) {
        int srclen = src.length;
        Float[] rv = new Float[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Float.valueOf(src[i]);
            ++i;
        }
        return rv;
    }

    public static void boxInto(float[] src, Object[] dest) {
        int srclen = src.length;
        int i = 0;
        while (i < srclen) {
            dest[i] = Float.valueOf(src[i]);
            ++i;
        }
    }

    public static float[] unbox(Float[] src) {
        int srclen = src.length;
        float[] rv = new float[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i].floatValue();
            ++i;
        }
        return rv;
    }

    public static float[] unboxNT(Float[] src, float nullValue) {
        int srclen = src.length;
        float[] rv = new float[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Primitives.unboxNT(src[i], nullValue);
            ++i;
        }
        return rv;
    }

    public static Integer[] box(int[] src) {
        int srclen = src.length;
        Integer[] rv = new Integer[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static void boxInto(int[] src, Object[] dest) {
        int srclen = src.length;
        int i = 0;
        while (i < srclen) {
            dest[i] = src[i];
            ++i;
        }
    }

    public static int[] unbox(Integer[] src) {
        int srclen = src.length;
        int[] rv = new int[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static int[] unboxNT(Integer[] src, int nullValue) {
        int srclen = src.length;
        int[] rv = new int[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Primitives.unboxNT(src[i], nullValue);
            ++i;
        }
        return rv;
    }

    public static Double[] box(double[] src) {
        int srclen = src.length;
        Double[] rv = new Double[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static void boxInto(double[] src, Object[] dest) {
        int srclen = src.length;
        int i = 0;
        while (i < srclen) {
            dest[i] = src[i];
            ++i;
        }
    }

    public static double[] unbox(Double[] src) {
        int srclen = src.length;
        double[] rv = new double[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static double[] unboxNT(Double[] src, double nullValue) {
        int srclen = src.length;
        double[] rv = new double[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Primitives.unboxNT(src[i], nullValue);
            ++i;
        }
        return rv;
    }

    public static Long[] box(long[] src) {
        int srclen = src.length;
        Long[] rv = new Long[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static void boxInto(long[] src, Object[] dest) {
        int srclen = src.length;
        int i = 0;
        while (i < srclen) {
            dest[i] = src[i];
            ++i;
        }
    }

    public static long[] unbox(Long[] src) {
        int srclen = src.length;
        long[] rv = new long[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = src[i];
            ++i;
        }
        return rv;
    }

    public static long[] unboxNT(Long[] src, long nullValue) {
        int srclen = src.length;
        long[] rv = new long[srclen];
        int i = 0;
        while (i < srclen) {
            rv[i] = Primitives.unboxNT(src[i], nullValue);
            ++i;
        }
        return rv;
    }

    public static List boxList(Object wrappedArray) {
        return Arrays.asList(Primitives.box(wrappedArray));
    }

    public static Object unboxList(List wrappedList, Class primitiveType) {
        Class wrapperClass = Primitives.getWrapperClassFromPrimitiveOrPassThroughWrapper(primitiveType);
        if (wrapperClass == Boolean.class) {
            return Primitives.unboxListBoolean(wrappedList);
        }
        if (wrapperClass == Byte.class) {
            return Primitives.unboxListByte(wrappedList);
        }
        if (wrapperClass == Short.class) {
            return Primitives.unboxListShort(wrappedList);
        }
        if (wrapperClass == Character.class) {
            return Primitives.unboxListCharacter(wrappedList);
        }
        if (wrapperClass == Integer.class) {
            return Primitives.unboxListInteger(wrappedList);
        }
        if (wrapperClass == Float.class) {
            return Primitives.unboxListFloat(wrappedList);
        }
        if (wrapperClass == Long.class) {
            return Primitives.unboxListLong(wrappedList);
        }
        if (wrapperClass == Double.class) {
            return Primitives.unboxListDouble(wrappedList);
        }
        throw new StructuredClassCastException(wrapperClass);
    }

    public static Object unboxListNT(List wrappedList, Object nullValue) {
        Class<?> wrapperClass = nullValue.getClass();
        if (wrapperClass == Boolean.class) {
            return Primitives.unboxListBooleanNT(wrappedList, (Boolean)nullValue);
        }
        if (wrapperClass == Byte.class) {
            return Primitives.unboxListByteNT(wrappedList, (Byte)nullValue);
        }
        if (wrapperClass == Short.class) {
            return Primitives.unboxListShortNT(wrappedList, (Short)nullValue);
        }
        if (wrapperClass == Character.class) {
            return Primitives.unboxListCharacterNT(wrappedList, ((Character)nullValue).charValue());
        }
        if (wrapperClass == Integer.class) {
            return Primitives.unboxListIntegerNT(wrappedList, (Integer)nullValue);
        }
        if (wrapperClass == Float.class) {
            return Primitives.unboxListFloatNT(wrappedList, ((Float)nullValue).floatValue());
        }
        if (wrapperClass == Long.class) {
            return Primitives.unboxListLongNT(wrappedList, (Long)nullValue);
        }
        if (wrapperClass == Double.class) {
            return Primitives.unboxListDoubleNT(wrappedList, (Double)nullValue);
        }
        throw new StructuredClassCastException(wrapperClass);
    }

    public static List<Boolean> boxList(boolean[] wrappedArray) {
        return Arrays.asList(Primitives.box(wrappedArray));
    }

    public static boolean[] unboxListBoolean(List<Boolean> wrappedList) {
        return Primitives.unbox(wrappedList.toArray(new Boolean[wrappedList.size()]));
    }

    public static boolean[] unboxListBooleanNT(List<Boolean> wrappedList, boolean nullValue) {
        return Primitives.unboxNT(wrappedList.toArray(new Boolean[wrappedList.size()]), nullValue);
    }

    public static List<Byte> boxList(byte[] wrappedArray) {
        return Arrays.asList(Primitives.box(wrappedArray));
    }

    public static byte[] unboxListByte(List<Byte> wrappedList) {
        return Primitives.unbox(wrappedList.toArray(new Byte[wrappedList.size()]));
    }

    public static byte[] unboxListByteNT(List<Byte> wrappedList, byte nullValue) {
        return Primitives.unboxNT(wrappedList.toArray(new Byte[wrappedList.size()]), nullValue);
    }

    public static List<Short> boxList(short[] wrappedArray) {
        return Arrays.asList(Primitives.box(wrappedArray));
    }

    public static short[] unboxListShort(List<Short> wrappedList) {
        return Primitives.unbox(wrappedList.toArray(new Short[wrappedList.size()]));
    }

    public static short[] unboxListShortNT(List<Short> wrappedList, short nullValue) {
        return Primitives.unboxNT(wrappedList.toArray(new Short[wrappedList.size()]), nullValue);
    }

    public static List<Character> boxList(char[] wrappedArray) {
        return Arrays.asList(Primitives.box(wrappedArray));
    }

    public static char[] unboxListCharacter(List<Character> wrappedList) {
        return Primitives.unbox(wrappedList.toArray(new Character[wrappedList.size()]));
    }

    public static char[] unboxListCharacterNT(List<Character> wrappedList, char nullValue) {
        return Primitives.unboxNT(wrappedList.toArray(new Character[wrappedList.size()]), nullValue);
    }

    public static List<Integer> boxList(int[] wrappedArray) {
        return Arrays.asList(Primitives.box(wrappedArray));
    }

    public static int[] unboxListInteger(List<Integer> wrappedList) {
        return Primitives.unbox(wrappedList.toArray(new Integer[wrappedList.size()]));
    }

    public static int[] unboxListIntegerNT(List<Integer> wrappedList, int nullValue) {
        return Primitives.unboxNT(wrappedList.toArray(new Integer[wrappedList.size()]), nullValue);
    }

    public static List<Float> boxList(float[] wrappedArray) {
        return Arrays.asList(Primitives.box(wrappedArray));
    }

    public static float[] unboxListFloat(List<Float> wrappedList) {
        return Primitives.unbox(wrappedList.toArray(new Float[wrappedList.size()]));
    }

    public static float[] unboxListFloatNT(List<Float> wrappedList, float nullValue) {
        return Primitives.unboxNT(wrappedList.toArray(new Float[wrappedList.size()]), nullValue);
    }

    public static List<Long> boxList(long[] wrappedArray) {
        return Arrays.asList(Primitives.box(wrappedArray));
    }

    public static long[] unboxListLong(List<Long> wrappedList) {
        return Primitives.unbox(wrappedList.toArray(new Long[wrappedList.size()]));
    }

    public static long[] unboxListLongNT(List<Long> wrappedList, long nullValue) {
        return Primitives.unboxNT(wrappedList.toArray(new Long[wrappedList.size()]), nullValue);
    }

    public static List<Double> boxList(double[] wrappedArray) {
        return Arrays.asList(Primitives.box(wrappedArray));
    }

    public static double[] unboxListDouble(List<Double> wrappedList) {
        return Primitives.unbox(wrappedList.toArray(new Double[wrappedList.size()]));
    }

    public static double[] unboxListDoubleNT(List<Double> wrappedList, double nullValue) {
        return Primitives.unboxNT(wrappedList.toArray(new Double[wrappedList.size()]), nullValue);
    }

    public static byte[] castByteArrayToByteArray(byte[] src) {
        byte[] rvs = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static byte[] castCharArrayToByteArray(char[] src) {
        byte[] rvs = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (byte)src[i];
            ++i;
        }
        return rvs;
    }

    public static byte[] castShortArrayToByteArray(short[] src) {
        byte[] rvs = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (byte)src[i];
            ++i;
        }
        return rvs;
    }

    public static byte[] castFloatArrayToByteArray(float[] src) {
        byte[] rvs = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (byte)src[i];
            ++i;
        }
        return rvs;
    }

    public static byte[] castIntArrayToByteArray(int[] src) {
        byte[] rvs = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (byte)src[i];
            ++i;
        }
        return rvs;
    }

    public static byte[] castDoubleArrayToByteArray(double[] src) {
        byte[] rvs = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (byte)src[i];
            ++i;
        }
        return rvs;
    }

    public static byte[] castLongArrayToByteArray(long[] src) {
        byte[] rvs = new byte[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (byte)src[i];
            ++i;
        }
        return rvs;
    }

    public static char[] castByteArrayToCharArray(byte[] src) {
        char[] rvs = new char[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (char)src[i];
            ++i;
        }
        return rvs;
    }

    public static char[] castCharArrayToCharArray(char[] src) {
        char[] rvs = new char[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static char[] castShortArrayToCharArray(short[] src) {
        char[] rvs = new char[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (char)src[i];
            ++i;
        }
        return rvs;
    }

    public static char[] castFloatArrayToCharArray(float[] src) {
        char[] rvs = new char[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (char)src[i];
            ++i;
        }
        return rvs;
    }

    public static char[] castIntArrayToCharArray(int[] src) {
        char[] rvs = new char[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (char)src[i];
            ++i;
        }
        return rvs;
    }

    public static char[] castDoubleArrayToCharArray(double[] src) {
        char[] rvs = new char[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (char)src[i];
            ++i;
        }
        return rvs;
    }

    public static char[] castLongArrayToCharArray(long[] src) {
        char[] rvs = new char[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (char)src[i];
            ++i;
        }
        return rvs;
    }

    public static short[] castByteArrayToShortArray(byte[] src) {
        short[] rvs = new short[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static short[] castCharArrayToShortArray(char[] src) {
        short[] rvs = new short[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (short)src[i];
            ++i;
        }
        return rvs;
    }

    public static short[] castShortArrayToShortArray(short[] src) {
        short[] rvs = new short[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static short[] castFloatArrayToShortArray(float[] src) {
        short[] rvs = new short[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (short)src[i];
            ++i;
        }
        return rvs;
    }

    public static short[] castIntArrayToShortArray(int[] src) {
        short[] rvs = new short[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (short)src[i];
            ++i;
        }
        return rvs;
    }

    public static short[] castDoubleArrayToShortArray(double[] src) {
        short[] rvs = new short[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (short)src[i];
            ++i;
        }
        return rvs;
    }

    public static short[] castLongArrayToShortArray(long[] src) {
        short[] rvs = new short[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (short)src[i];
            ++i;
        }
        return rvs;
    }

    public static float[] castByteArrayToFloatArray(byte[] src) {
        float[] rvs = new float[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static float[] castCharArrayToFloatArray(char[] src) {
        float[] rvs = new float[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static float[] castShortArrayToFloatArray(short[] src) {
        float[] rvs = new float[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static float[] castFloatArrayToFloatArray(float[] src) {
        float[] rvs = new float[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static float[] castIntArrayToFloatArray(int[] src) {
        float[] rvs = new float[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static float[] castDoubleArrayToFloatArray(double[] src) {
        float[] rvs = new float[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (float)src[i];
            ++i;
        }
        return rvs;
    }

    public static float[] castLongArrayToFloatArray(long[] src) {
        float[] rvs = new float[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static int[] castByteArrayToIntArray(byte[] src) {
        int[] rvs = new int[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static int[] castCharArrayToIntArray(char[] src) {
        int[] rvs = new int[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static int[] castShortArrayToIntArray(short[] src) {
        int[] rvs = new int[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static int[] castFloatArrayToIntArray(float[] src) {
        int[] rvs = new int[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (int)src[i];
            ++i;
        }
        return rvs;
    }

    public static int[] castIntArrayToIntArray(int[] src) {
        int[] rvs = new int[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static int[] castDoubleArrayToIntArray(double[] src) {
        int[] rvs = new int[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (int)src[i];
            ++i;
        }
        return rvs;
    }

    public static int[] castLongArrayToIntArray(long[] src) {
        int[] rvs = new int[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (int)src[i];
            ++i;
        }
        return rvs;
    }

    public static double[] castByteArrayToDoubleArray(byte[] src) {
        double[] rvs = new double[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static double[] castCharArrayToDoubleArray(char[] src) {
        double[] rvs = new double[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static double[] castShortArrayToDoubleArray(short[] src) {
        double[] rvs = new double[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static double[] castFloatArrayToDoubleArray(float[] src) {
        double[] rvs = new double[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static double[] castIntArrayToDoubleArray(int[] src) {
        double[] rvs = new double[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static double[] castDoubleArrayToDoubleArray(double[] src) {
        double[] rvs = new double[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static double[] castLongArrayToDoubleArray(long[] src) {
        double[] rvs = new double[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static long[] castByteArrayToLongArray(byte[] src) {
        long[] rvs = new long[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static long[] castCharArrayToLongArray(char[] src) {
        long[] rvs = new long[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static long[] castShortArrayToLongArray(short[] src) {
        long[] rvs = new long[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static long[] castFloatArrayToLongArray(float[] src) {
        long[] rvs = new long[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (long)src[i];
            ++i;
        }
        return rvs;
    }

    public static long[] castIntArrayToLongArray(int[] src) {
        long[] rvs = new long[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static long[] castDoubleArrayToLongArray(double[] src) {
        long[] rvs = new long[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = (long)src[i];
            ++i;
        }
        return rvs;
    }

    public static long[] castLongArrayToLongArray(long[] src) {
        long[] rvs = new long[src.length];
        int i = 0;
        while (i < src.length) {
            rvs[i] = src[i];
            ++i;
        }
        return rvs;
    }

    public static long castIntegerPrimitiveWrapperToLong(Object x) {
        if (x instanceof Byte) {
            return ((Byte)x).byteValue();
        }
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        if (x instanceof Short) {
            return ((Short)x).shortValue();
        }
        if (x instanceof Integer) {
            return ((Integer)x).intValue();
        }
        if (x instanceof Long) {
            return (Long)x;
        }
        throw BasicExceptionUtilities.newClassCastExceptionOrNullPointerException(x);
    }

    public static long getBitfieldLengthOfType(Class c) {
        if (c == Byte.TYPE || c == Byte.class) {
            return 8L;
        }
        if (c == Short.TYPE || c == Short.class) {
            return 16L;
        }
        if (c == Character.TYPE || c == Character.class) {
            return 16L;
        }
        if (c == Integer.TYPE || c == Integer.class) {
            return 32L;
        }
        if (c == Long.TYPE || c == Long.class) {
            return 64L;
        }
        throw new IllegalArgumentException();
    }

    public static long getBitfieldLengthOfComponentType(Class c) {
        if (c != null && c.isArray()) {
            return Primitives.getBitfieldLengthOfType(c.getComponentType());
        }
        throw new IllegalArgumentException(c + " isn't an array Class!");
    }

    public static long getIntegerArrayElement(Object array, @ActuallyUnsigned long index, boolean signextend) {
        int index32 = BitfieldSafeCasts.safeCastU64toS32(index);
        if (array instanceof long[]) {
            return ((long[])array)[index32];
        }
        if (array instanceof int[]) {
            return signextend ? ((int[])array)[index32] : ((int[])array)[index32] & BitUtilities.getMask32(32);
        }
        if (array instanceof char[]) {
            return signextend ? (short)((char[])array)[index32] : ((char[])array)[index32];
        }
        if (array instanceof short[]) {
            return signextend ? ((short[])array)[index32] : ((short[])array)[index32] & BitUtilities.getMask32(16);
        }
        if (array instanceof byte[]) {
            return signextend ? ((byte[])array)[index32] : ((byte[])array)[index32] & BitUtilities.getMask32(8);
        }
        throw new IllegalArgumentException("this is not a bitfield array!: " + array);
    }

    public static long getIntegerValue(Object wrappedValue, boolean signextend) {
        if (wrappedValue == null) {
            throw new NullPointerException();
        }
        if (!Primitives.isIntegerPrimitiveOrWrapperClass(wrappedValue.getClass())) {
            throw new StructuredClassCastException(wrappedValue.getClass());
        }
        if (signextend) {
            return ((Number)wrappedValue).longValue();
        }
        return ((Number)wrappedValue).longValue() & BitUtilities.getMask64(Primitives.getBitfieldLengthOfType(wrappedValue.getClass()));
    }

    public static long bitcastToLongUnsigned(boolean x) {
        return x ? 1L : 0L;
    }

    public static long bitcastToLongUnsigned(byte x) {
        return (long)x & 0xFFL;
    }

    public static long bitcastToLongUnsigned(char x) {
        return x;
    }

    public static long bitcastToLongUnsigned(short x) {
        return (long)x & 0xFFFFL;
    }

    public static long bitcastToLongUnsigned(float x) {
        return (long)Float.floatToRawIntBits(x) & 0xFFFFFFFFL;
    }

    public static long bitcastToLongUnsigned(int x) {
        return (long)x & 0xFFFFFFFFL;
    }

    public static long bitcastToLongUnsigned(double x) {
        return Double.doubleToRawLongBits(x);
    }

    public static long bitcastToLongUnsigned(long x) {
        return x;
    }

    public static long bitcastToLongTwosSignExtending(boolean x) {
        return x ? -1L : 0L;
    }

    public static long bitcastToLongTwosSignExtending(byte x) {
        return x;
    }

    public static long bitcastToLongTwosSignExtending(char x) {
        return (short)x;
    }

    public static long bitcastToLongTwosSignExtending(short x) {
        return x;
    }

    public static long bitcastToLongTwosSignExtending(float x) {
        return Float.floatToRawIntBits(x);
    }

    public static long bitcastToLongTwosSignExtending(int x) {
        return x;
    }

    public static long bitcastToLongTwosSignExtending(double x) {
        return Double.doubleToRawLongBits(x);
    }

    public static long bitcastToLongTwosSignExtending(long x) {
        return x;
    }

    public static boolean bitcastFromLongToBoolean(long x) {
        return (x & 1L) != 0L;
    }

    public static byte bitcastFromLongToByte(long x) {
        return (byte)x;
    }

    public static char bitcastFromLongToChar(long x) {
        return (char)x;
    }

    public static short bitcastFromLongToShort(long x) {
        return (short)x;
    }

    public static float bitcastFromLongToFloat(long x) {
        return Float.intBitsToFloat((int)x);
    }

    public static int bitcastFromLongToInt(long x) {
        return (int)x;
    }

    public static double bitcastFromLongToDouble(long x) {
        return Double.longBitsToDouble(x);
    }

    public static long bitcastFromLongToLong(long x) {
        return x;
    }

    public static Class getWrapperClassFromPrimitiveStrict(Class c) {
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        return c;
    }

    public static Class getPrimitiveClassFromWrapperStrict(Class c) throws IllegalArgumentException {
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        throw new IllegalArgumentException();
    }

    public static Class getPrimitiveClassFromWrapperOrPassThroughPrimitive(Class c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == Boolean.class) {
            return Boolean.TYPE;
        }
        if (c == Byte.class) {
            return Byte.TYPE;
        }
        if (c == Short.class) {
            return Short.TYPE;
        }
        if (c == Character.class) {
            return Character.TYPE;
        }
        if (c == Integer.class) {
            return Integer.TYPE;
        }
        if (c == Float.class) {
            return Float.TYPE;
        }
        if (c == Long.class) {
            return Long.TYPE;
        }
        if (c == Double.class) {
            return Double.TYPE;
        }
        if (c == Boolean.TYPE || c == Byte.TYPE || c == Short.TYPE || c == Character.TYPE || c == Integer.TYPE || c == Float.TYPE || c == Long.TYPE || c == Double.TYPE) {
            return c;
        }
        throw new StructuredClassCastException("Not a primitive or wrapper class >,>", c);
    }

    public static Class getWrapperClassFromPrimitiveOrPassThroughWrapper(Class c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == Boolean.TYPE) {
            return Boolean.class;
        }
        if (c == Byte.TYPE) {
            return Byte.class;
        }
        if (c == Short.TYPE) {
            return Short.class;
        }
        if (c == Character.TYPE) {
            return Character.class;
        }
        if (c == Integer.TYPE) {
            return Integer.class;
        }
        if (c == Float.TYPE) {
            return Float.class;
        }
        if (c == Long.TYPE) {
            return Long.class;
        }
        if (c == Double.TYPE) {
            return Double.class;
        }
        if (c == Boolean.class || c == Byte.class || c == Short.class || c == Character.class || c == Integer.class || c == Float.class || c == Long.class || c == Double.class) {
            return c;
        }
        throw new StructuredClassCastException("Not a primitive or wrapper class >,> : ", c);
    }

    public static boolean isPrimitiveWrapperClass(Class c) {
        return c == Boolean.class || c == Character.class || c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class;
    }

    public static boolean isNumericPrimitiveWrapperClass(Class c) {
        return c == Byte.class || c == Short.class || c == Integer.class || c == Long.class || c == Float.class || c == Double.class;
    }

    public static boolean isIntegerPrimitiveWrapperClass(Class c) {
        return c == Byte.class || c == Short.class || c == Character.class || c == Integer.class || c == Long.class;
    }

    public static boolean isFloatingPrimitiveWrapperClass(Class c) {
        return c == Float.class || c == Double.class;
    }

    public static boolean isPrimitiveClass(Class c) {
        return c == Boolean.TYPE || c == Character.TYPE || c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE || c == Long.TYPE || c == Float.TYPE || c == Double.TYPE;
    }

    public static boolean isNumericPrimitiveClass(Class c) {
        return c == Byte.TYPE || c == Short.TYPE || c == Integer.TYPE || c == Long.TYPE || c == Float.TYPE || c == Double.TYPE;
    }

    public static boolean isIntegerPrimitiveClass(Class c) {
        return c == Byte.TYPE || c == Short.TYPE || c == Character.TYPE || c == Integer.TYPE || c == Long.TYPE;
    }

    public static boolean isFloatingPrimitiveClass(Class c) {
        return c == Float.TYPE || c == Double.TYPE;
    }

    public static boolean isPrimitiveOrWrapperClass(Class c) {
        return Primitives.isPrimitiveClass(c) || Primitives.isPrimitiveWrapperClass(c);
    }

    public static boolean isNumericPrimitiveOrWrapperClass(Class c) {
        return Primitives.isNumericPrimitiveClass(c) || Primitives.isNumericPrimitiveWrapperClass(c);
    }

    public static boolean isIntegerPrimitiveOrWrapperClass(Class c) {
        return Primitives.isIntegerPrimitiveClass(c) || Primitives.isIntegerPrimitiveWrapperClass(c);
    }

    public static boolean isFloatingPrimitiveOrWrapperClass(Class c) {
        return Primitives.isFloatingPrimitiveClass(c) || Primitives.isFloatingPrimitiveWrapperClass(c);
    }

    public static boolean isPrimitiveWrapperInstance(Object o) {
        return o instanceof Boolean || o instanceof Character || o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double;
    }

    public static boolean isNumericPrimitiveWrapperInstance(Object o) {
        return o instanceof Byte || o instanceof Short || o instanceof Integer || o instanceof Long || o instanceof Float || o instanceof Double;
    }

    public static boolean isIntegerPrimitiveWrapperInstance(Object o) {
        return o instanceof Byte || o instanceof Short || o instanceof Character || o instanceof Integer || o instanceof Long;
    }

    public static boolean isFloatingPrimitiveWrapperInstance(Object o) {
        return o instanceof Float || o instanceof Double;
    }

    public static int hashprim(boolean x) {
        return x ? 1231 : 1237;
    }

    public static int hashprim(long x) {
        return (int)x ^ (int)(x >>> 32);
    }

    public static int hashprim(float x) {
        return Float.floatToIntBits(x);
    }

    public static int hashprim(double x) {
        return Primitives.hashprim(Double.doubleToLongBits(x));
    }

    public static int hashprim(byte x) {
        return x;
    }

    public static int hashprim(short x) {
        return x;
    }

    public static int hashprim(char x) {
        return x;
    }

    public static int hashprim(int x) {
        return x;
    }

    @Nonnull
    public static Object normalizePrimitive(@Nonnull Object input) {
        if (input == null) {
            throw new NullPointerException();
        }
        if (input instanceof Integer || input instanceof Short || input instanceof Character || input instanceof Byte) {
            return ((Number)input).longValue();
        }
        if (input instanceof Float) {
            return ((Float)input).doubleValue();
        }
        return input;
    }

    @Nonnull
    public static Object normalizeIfIntegerPrimitive(@Nonnull Object input) {
        if (input == null) {
            throw new NullPointerException();
        }
        if (input instanceof Integer || input instanceof Short || input instanceof Character || input instanceof Byte) {
            return ((Number)input).longValue();
        }
        return input;
    }

    @Nonnull
    public static Object typeMassageAmongstIntegerPrimitives(@Nonnull Object input, @Nonnull Class destType, boolean actuallyUnsigned) {
        if (input == null) {
            throw new NullPointerException();
        }
        if (!Primitives.isIntegerPrimitiveWrapperInstance(input)) {
            throw new IllegalArgumentException("Not an integer primitive type!!: " + input.getClass());
        }
        long value64 = (Long)Primitives.normalizePrimitive(input);
        return Primitives.typeMassageAmongstIntegerPrimitives(value64, destType, actuallyUnsigned);
    }

    @Nonnull
    public static Object typeMassageAmongstIntegerPrimitives(@Nonnull long value64, @Nonnull Class destType, boolean actuallyUnsigned) {
        if (destType == Byte.TYPE || destType == Byte.class) {
            return actuallyUnsigned ? BitfieldSafeCasts.safeCastS64toU8(value64) : BitfieldSafeCasts.safeCastS64toS8(value64);
        }
        if (destType == Short.TYPE || destType == Short.class) {
            return actuallyUnsigned ? BitfieldSafeCasts.safeCastS64toU16(value64) : BitfieldSafeCasts.safeCastS64toS16(value64);
        }
        if (destType == Character.TYPE || destType == Character.class) {
            return BitfieldSafeCasts.safeCastS64toU16(value64);
        }
        if (destType == Integer.TYPE || destType == Integer.class) {
            return actuallyUnsigned ? BitfieldSafeCasts.safeCastS64toU32(value64) : BitfieldSafeCasts.safeCastS64toS32(value64);
        }
        if (destType == Long.TYPE || destType == Long.class) {
            return actuallyUnsigned ? BitfieldSafeCasts.safeCastS64toU64(value64) : value64;
        }
        throw new IllegalArgumentException("Not an integer primitive type!!: " + destType);
    }
}

