/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.parsing.apis.tokenstream;

import rebound.annotations.semantic.SignalType;
import rebound.text.parsing.apis.tokenstream.Tokenlike;

@SignalType
public interface WherefulToken
extends Tokenlike {
    public int getStartingCharacterIndexInSource();

    default public int getEndingIndexInSource() {
        return this.getStartingCharacterIndexInSource() + this.getLengthOfMaskedSource();
    }

    public static int simpleTokensHashCode(WherefulToken t, int typingHashCode) {
        int prime = 31;
        int result = 1;
        result = 31 * result + t.getStartingCharacterIndexInSource();
        result = 31 * result + t.getLengthOfMaskedSource();
        return result;
    }

    public static boolean simpleTokensEqualNotCountingTyping(WherefulToken a, WherefulToken b) {
        if (a == b) {
            return true;
        }
        if (a == null || b == null) {
            return false;
        }
        return a.getStartingCharacterIndexInSource() == b.getStartingCharacterIndexInSource() && a.getLengthOfMaskedSource() == b.getLengthOfMaskedSource();
    }
}

