/*
 * Decompiled with CFR 0.152.
 */
package rebound.text.encodings.detection.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.text.encodings.detection.TextEncodingDetector;
import rebound.util.collections.CollectionUtilities;
import rebound.util.functional.throwing.FunctionalInterfacesThrowingCheckedExceptionsStandard;

public class CascadedTextEncodingDetector
implements TextEncodingDetector {
    protected final Iterable<TextEncodingDetector> underlyings;

    public CascadedTextEncodingDetector(Iterable<TextEncodingDetector> underlyings) {
        this.underlyings = underlyings;
    }

    public CascadedTextEncodingDetector(TextEncodingDetector ... underlyings) {
        this(CollectionUtilities.asList(underlyings));
    }

    @ImplementationTransparency
    public Iterable<TextEncodingDetector> getUnderlyings() {
        return this.underlyings;
    }

    @Override
    public Charset detectEncoding(FunctionalInterfacesThrowingCheckedExceptionsStandard.NullaryFunctionThrowingIOException<InputStream> opener) throws IOException, UnsupportedCharsetException {
        for (TextEncodingDetector u : this.underlyings) {
            Charset d = u.detectEncoding(opener);
            if (d == null) continue;
            return d;
        }
        return null;
    }
}

