/*
 * Decompiled with CFR 0.152.
 */
package rebound.jagent.lib.c16;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import rebound.bits.Bytes;
import rebound.bits.Unsigned;
import rebound.io.iio.RandomAccessBytes;
import rebound.io.iio.sio.RandomAccessFileWrapper;
import rebound.io.util.BasicIOUtilities;
import rebound.jagent.lib.FormatMismatchException;
import rebound.jagent.lib.c16.DataMap;
import rebound.jagent.lib.c16.FromC16Notifee;

public class FromC16Converter {
    protected boolean bits565;
    protected BufferedImage[] frames;
    protected int[] widths;
    protected int[] heights;
    protected FromC16Notifee notifee;

    public void read(File path) throws IOException, FormatMismatchException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (RandomAccessFileWrapper file = new RandomAccessFileWrapper(new RandomAccessFile(path, "r"));){
            this.read(file);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public void read(RandomAccessBytes file) throws IOException, FormatMismatchException {
        DataMap map = new DataMap();
        if (this.notifee != null) {
            this.notifee.startC16Reading();
        }
        this.readHeaders(file, map);
        this.readImageDatii(file, map);
        if (this.notifee != null) {
            this.notifee.finC16Reading();
        }
    }

    protected void readHeaders(RandomAccessBytes file, DataMap map) throws IOException, FormatMismatchException {
        int flags = Bytes.getLittleInt(file);
        boolean bl = this.bits565 = (flags & 1) != 0;
        if ((flags & 2) == 0) {
            throw new FormatMismatchException("Attempting to read (what looks like) a S16 or BLK file, when expecting a C16");
        }
        int count = Unsigned.upcast(Bytes.getLittleShort(file));
        map.offsets = new int[count][];
        this.widths = new int[count];
        this.heights = new int[count];
        this.frames = new BufferedImage[count];
        int i = 0;
        while (i < count) {
            this.readHeader(file, map, i);
            ++i;
        }
    }

    protected void readHeader(RandomAccessBytes file, DataMap map, int index) throws IOException {
        int line0 = Bytes.getLittleInt(file);
        int width = Unsigned.upcast(Bytes.getLittleShort(file));
        int height = Unsigned.upcast(Bytes.getLittleShort(file));
        this.widths[index] = width;
        this.heights[index] = height;
        map.offsets[index] = new int[height];
        map.offsets[index][0] = line0;
        int o = 1;
        while (o < height) {
            map.offsets[index][o] = Bytes.getLittleInt(file);
            ++o;
        }
    }

    protected void readImageDatii(RandomAccessBytes file, DataMap map) throws IOException, FormatMismatchException {
        int i = 0;
        while (i < this.frames.length) {
            this.readImageData(file, map, i);
            if (this.notifee != null) {
                this.notifee.finC16ReadingFrame(i, this.frames.length);
            }
            ++i;
        }
    }

    protected void readImageData(RandomAccessBytes file, DataMap map, int index) throws IOException, FormatMismatchException {
        BufferedImage img = this.frames[index] = new BufferedImage(this.widths[index], this.heights[index], 2);
        int x = 0;
        long flen = file.length();
        int row = 0;
        while (row < img.getHeight()) {
            file.seek(map.offsets[index][row]);
            x = 0;
            while (x < img.getWidth()) {
                if (file.getFilePointer() >= flen) {
                    throw new FormatMismatchException("C16 File appears to be truncated at image " + index);
                }
                x += this.readRun(file, index, x, row);
            }
            ++row;
        }
    }

    protected int readRun(RandomAccessBytes file, int index, int x, int y) throws IOException {
        int tag = Bytes.getLittleShort(file);
        boolean transparent = (tag & 1) == 0;
        int runlength = 0;
        runlength = tag;
        runlength >>>= 1;
        if (!transparent) {
            byte[] rawdata = new byte[runlength * 2];
            BasicIOUtilities.readFully(file, rawdata);
            int[] directImageData = ((DataBufferInt)this.frames[index].getRaster().getDataBuffer()).getData();
            int i = 0;
            int e = y * this.widths[index] + x;
            int hiPacked = 0;
            int argbPacked = 0;
            while (i < rawdata.length) {
                hiPacked = rawdata[i] & 0xFF | (rawdata[i + 1] & 0xFF) << 8;
                i += 2;
                argbPacked = this.bits565 ? 0xFF000000 | (hiPacked & 0xF800) << 8 | (hiPacked & 0x7E0) << 5 | (hiPacked & 0x1F) << 3 : 0xFF000000 | (hiPacked & 0x7C00) << 9 | (hiPacked & 0x3E0) << 6 | (hiPacked & 0x1F) << 3;
                directImageData[e++] = argbPacked;
            }
        }
        return runlength;
    }

    public FromC16Notifee getNotifee() {
        return this.notifee;
    }

    public void setNotifee(FromC16Notifee notifee) {
        this.notifee = notifee;
    }

    public boolean isBits565() {
        return this.bits565;
    }

    public BufferedImage[] getFrames() {
        return this.frames;
    }
}

