/*
 * Decompiled with CFR 0.152.
 */
package rebound.io.ucs4;

import java.io.IOException;
import java.util.Arrays;
import rebound.io.ucs4.UCS4Writer;

public class UCS4ArrayWriter
implements UCS4Writer {
    protected int[] buf;
    protected int count;

    public UCS4ArrayWriter() {
        this(32);
    }

    public UCS4ArrayWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative initial size: " + initialSize);
        }
        this.buf = new int[initialSize];
    }

    @Override
    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    @Override
    public void write(int[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.buf = Arrays.copyOf(this.buf, Math.max(this.buf.length << 1, newcount));
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void writeTo(UCS4Writer out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public int[] toIntArray() {
        return Arrays.copyOf(this.buf, this.count);
    }

    public int size() {
        return this.count;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
    }
}

