/*
 * Decompiled with CFR 0.152.
 */
package rebound.io;

import from.java.io.forr.rebound.io.iio.ByteArrayInputByteStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.annotations.semantic.temporal.ConstantReturnValue;
import rebound.io.util.JRECompatIOUtilities;
import rebound.math.SmallIntegerMathUtilities;
import rebound.testing.WidespreadTestingUtilities;

@NotThreadSafe
public class HeadReopenableInputStream {
    protected InputStream underlying;
    protected InputStream streamForThem;
    protected int headSize;
    protected byte[] cache;

    public HeadReopenableInputStream(InputStream underlying, int headSize) {
        SmallIntegerMathUtilities.requireNonNegative(headSize);
        this.underlying = underlying;
        this.headSize = headSize;
        this.cache = null;
    }

    @ConstantReturnValue
    @Nonnull
    public InputStream stream() throws IOException {
        this.ensureHeadCached();
        WidespreadTestingUtilities.asrt(this.streamForThem != null);
        return this.streamForThem;
    }

    @ImplementationTransparency
    @Nonnegative
    public int getSize() {
        return this.headSize;
    }

    @ImplementationTransparency
    public boolean isCachingEntirety() {
        return this.headSize == 0;
    }

    @Nonnull
    public InputStream openNewHeadStream() throws IOException {
        this.ensureHeadCached();
        WidespreadTestingUtilities.asrt(this.cache != null);
        return new ByteArrayInputByteStream(this.cache);
    }

    @ImplementationTransparency
    public void ensureHeadCached() throws IOException {
        if (this.cache == null) {
            if (this.isCachingEntirety()) {
                this.cache = JRECompatIOUtilities.readAll(this.underlying);
                this.streamForThem = null;
            } else {
                this.cache = JRECompatIOUtilities.readAsMuchAsPossibleToNew(this.underlying, this.headSize);
                ByteArrayInputStream b = new ByteArrayInputStream(this.cache);
                this.streamForThem = this.cache.length < this.headSize ? b : new SequenceInputStream(b, this.underlying);
            }
            WidespreadTestingUtilities.asrt(this.cache != null);
        }
    }
}

