/*
 * Decompiled with CFR 0.152.
 */
package rebound.hci.graphics2d.gui.awt.components;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import rebound.hci.graphics2d.gui.componentinterfaces.AbstractFileChooser;
import rebound.hci.graphics2d.gui.componentinterfaces.AbstractFilesChooser;

public class JFileChooserWrapper
implements AbstractFileChooser,
AbstractFilesChooser {
    protected JFileChooser jfc;
    protected Component parent;
    protected JFileChooserDisplayType displayType;
    protected String customApproveButtonText;

    public JFileChooserWrapper() {
    }

    public JFileChooserWrapper(JFileChooser jfc) {
        this.setJFileChooser(jfc);
    }

    public boolean prompt() {
        if (this.getDisplayType() == JFileChooserDisplayType.OPEN) {
            return this.jfc.showOpenDialog(this.getParent()) == 0;
        }
        if (this.displayType == JFileChooserDisplayType.SAVE) {
            return this.jfc.showSaveDialog(this.getParent()) == 0;
        }
        if (this.displayType == JFileChooserDisplayType.CUSTOM) {
            return this.jfc.showDialog(this.getParent(), this.getCustomApproveButtonText()) == 0;
        }
        return this.jfc.showOpenDialog(this.getParent()) == 0;
    }

    @Override
    public File promptOne() {
        if (this.prompt()) {
            return this.jfc.getSelectedFile();
        }
        return null;
    }

    @Override
    public File[] promptMultiple() {
        if (this.prompt()) {
            return this.jfc.getSelectedFiles();
        }
        return null;
    }

    public JFileChooser getJFileChooser() {
        return this.jfc;
    }

    public void setJFileChooser(JFileChooser jfc) {
        this.jfc = jfc;
    }

    public JFileChooserDisplayType getDisplayType() {
        return this.displayType;
    }

    public void setDisplayType(JFileChooserDisplayType displayType) {
        this.displayType = displayType;
    }

    public String getCustomApproveButtonText() {
        return this.customApproveButtonText;
    }

    public void setCustomApproveButtonText(String customApproveButtonText) {
        this.customApproveButtonText = customApproveButtonText;
    }

    public Component getParent() {
        return this.parent;
    }

    public void setParent(Component parent) {
        this.parent = parent;
    }

    public static enum JFileChooserDisplayType {
        OPEN,
        SAVE,
        CUSTOM;

    }
}

