/*
 * Decompiled with CFR 0.152.
 */
package rebound.file;

import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import rebound.GlobalCodeMetastuffContext;
import rebound.annotations.hints.ImplementationTransparency;
import rebound.exceptions.ImPrettySureThisNeverActuallyHappensRuntimeException;
import rebound.exceptions.ImpossibleException;
import rebound.exceptions.NoFreeResourceFoundException;
import rebound.exceptions.NotFoundException;
import rebound.exceptions.OverflowException;
import rebound.exceptions.WrappedThrowableRuntimeException;
import rebound.file.ContainingFolderAndRelativePathWithinIt;
import rebound.file.InvalidPathNameIOException;
import rebound.file.SymlinkCycleIOException;
import rebound.io.util.BasicIOUtilities;
import rebound.io.util.FSIOUtilities;
import rebound.io.util.JRECompatIOUtilities;
import rebound.math.SmallIntegerMathUtilities;
import rebound.testing.WidespreadTestingUtilities;
import rebound.text.StringUtilities;
import rebound.util.collections.ArrayUtilities;
import rebound.util.collections.CollectionUtilities;
import rebound.util.container.SimpleContainers;
import rebound.util.functional.FunctionInterfaces;
import rebound.util.functional.throwing.FunctionalInterfacesThrowingCheckedExceptionsStandard;
import rebound.util.objectutil.BasicObjectUtilities;
import rebound.util.objectutil.JavaNamespace;
import rebound.util.objectutil.ObjectUtilities;

public class FSUtilities
implements JavaNamespace {
    public static final File UserUUIDBase = new File(System.getProperty("user.home"), ".uuid");
    public static final Predicate<File> DescendRecurse_Always = new Predicate<File>(){

        @Override
        public boolean test(File dir) {
            return true;
        }
    };
    public static final Predicate<File> DescendRecurse_Never = new Predicate<File>(){

        @Override
        public boolean test(File dir) {
            return false;
        }
    };
    public static final Predicate<File> DescendRecurse_IfReadable = new Predicate<File>(){

        @Override
        public boolean test(File dir) {
            return dir.canRead();
        }
    };
    public static final Predicate<File> DescendRecurse_NoSymlinks = new Predicate<File>(){

        @Override
        public boolean test(File dir) {
            return !FSUtilities.isSymlink(dir);
        }
    };
    public static final Predicate<File> DescendRecurse_IfReadableAndNotSymlink = new Predicate<File>(){

        @Override
        public boolean test(File dir) {
            return dir.canRead() && !FSUtilities.isSymlink(dir);
        }
    };

    public static File fnull(String path) {
        return path == null ? null : new File(path);
    }

    public static File fnex(String path) {
        return path == null ? NonExistantFile.inst() : new File(path);
    }

    @Nonnull
    public static String[] listDirectoryBasenamesOrThrow(@Nonnull File d) throws IOException {
        Objects.requireNonNull(d);
        String[] children = d.list();
        if (children == null) {
            throw new IOException("I/O Error listing directory: " + StringUtilities.repr(d.getPath()));
        }
        return children;
    }

    @Nonnull
    public static File[] listDirectoryFilesOrThrow(@Nonnull File d) throws IOException {
        Objects.requireNonNull(d);
        File[] children = d.listFiles();
        if (children == null) {
            throw new IOException("I/O Error listing directory: " + StringUtilities.repr(d.getPath()));
        }
        return children;
    }

    public static void checkDir(File d) throws ImpossibleException {
        if (!d.isDirectory()) {
            throw new ImpossibleException("Not a directory: " + StringUtilities.repr(d.getAbsolutePath()));
        }
    }

    public static void checkFile(File f) throws ImpossibleException {
        FSUtilities.checkRegularOrSpecialFile(f);
    }

    public static void checkRegularFile(File f) throws ImpossibleException {
        if (!FSUtilities.isRegularFile(f)) {
            throw new ImpossibleException("Not a regular file: " + StringUtilities.repr(f.getAbsolutePath()));
        }
    }

    public static void checkRegularOrSpecialFile(File f) throws ImpossibleException {
        if (!FSUtilities.isSpecialOrRegularFile(f)) {
            throw new ImpossibleException("Not a regular-or-special file: " + StringUtilities.repr(f.getAbsolutePath()));
        }
    }

    public static void ensureDirLeafMandatory(File d) {
        try {
            FSUtilities.ensureDirLeafThrowing(d);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static void ensureDirLeafThrowing(File d) throws IOException {
        if (d.isDirectory()) {
            return;
        }
        if (FSUtilities.lexists(d)) {
            throw new IOException("Monkey wrench: We tried to make this a directory but it's already something else: " + StringUtilities.repr(d.getAbsolutePath()));
        }
        d.mkdir();
        if (d.isDirectory()) {
            return;
        }
        if (FSUtilities.lexists(d)) {
            throw new IOException("Monkey wrench: We tried to make this a directory but it's already something else: " + StringUtilities.repr(d.getAbsolutePath()));
        }
        throw new IOException("We tried to make this a directory but failed: " + StringUtilities.repr(d.getAbsolutePath()));
    }

    public static void ensureDirsWholePathMandatory(File d) {
        try {
            FSUtilities.ensureDirsWholePathThrowing(d);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static void ensureDirsWholePathThrowing(File d) throws IOException {
        if (d.isDirectory()) {
            return;
        }
        if (FSUtilities.lexists(d)) {
            throw new IOException("Monkey wrench: We tried to make this a directory but it's already something else: " + StringUtilities.repr(d.getAbsolutePath()));
        }
        d.mkdirs();
        if (d.isDirectory()) {
            return;
        }
        if (FSUtilities.lexists(d)) {
            throw new IOException("Monkey wrench: We tried to make this a directory but it's already something else: " + StringUtilities.repr(d.getAbsolutePath()));
        }
        throw new IOException("We tried to make this a directory but failed: " + StringUtilities.repr(d.getAbsolutePath()));
    }

    public static void ensureRenameThrowing(File oldPath, File newPath) throws IOException {
        oldPath = FSUtilities.normpath(oldPath.getAbsoluteFile());
        newPath = FSUtilities.normpath(newPath.getAbsoluteFile());
        if (!FSUtilities.lexists(oldPath)) {
            throw new IOException("Couldn't rename: " + StringUtilities.repr(oldPath.getAbsolutePath()) + " to: " + StringUtilities.repr(newPath.getAbsolutePath()) + " because the source didn't exist!");
        }
        if (FSUtilities.lexists(newPath)) {
            throw new IOException("Couldn't rename: " + StringUtilities.repr(oldPath.getAbsolutePath()) + " to: " + StringUtilities.repr(newPath.getAbsolutePath()) + " because the destination already existed!");
        }
        if (!oldPath.renameTo(newPath)) {
            throw new IOException("Couldn't rename: " + StringUtilities.repr(oldPath.getAbsolutePath()) + " to: " + StringUtilities.repr(newPath.getAbsolutePath()));
        }
    }

    public static void ensureEmptyFileThrowing(File f) throws IOException {
        if (f.isFile() && f.length() == 0L) {
            return;
        }
        if (FSUtilities.lexists(f)) {
            throw new IOException("Monkey wrench: We tried to make this an empty file but it's already something else: " + StringUtilities.repr(f.getAbsolutePath()));
        }
        f.createNewFile();
        if (f.isFile()) {
            if (f.length() != 0L) {
                throw new IOException("Monkey wrench: We tried to make this an empty file but (unless the JRE or OS is breaking API standards), it seems like something started writing to it *as soon as we made it!!* X'D  : " + StringUtilities.repr(f.getAbsolutePath()));
            }
            return;
        }
        if (FSUtilities.lexists(f)) {
            throw new IOException("Monkey wrench: We tried to make this an empty file but it's already something else: " + StringUtilities.repr(f.getAbsolutePath()));
        }
        throw new IOException("We tried to make this an empty file but failed: " + StringUtilities.repr(f.getAbsolutePath()));
    }

    public static void ensureFileThrowing(File f) throws IOException {
        if (f.isFile()) {
            return;
        }
        if (FSUtilities.lexists(f)) {
            throw new IOException("Monkey wrench: We tried to make this an empty file but it's already something else: " + StringUtilities.repr(f.getAbsolutePath()));
        }
        f.createNewFile();
        if (f.isFile()) {
            return;
        }
        if (FSUtilities.lexists(f)) {
            throw new IOException("Monkey wrench: We tried to make this an empty file but it's already something else: " + StringUtilities.repr(f.getAbsolutePath()));
        }
        throw new IOException("We tried to make this an empty file but failed: " + StringUtilities.repr(f.getAbsolutePath()));
    }

    public static void ensureWritableEmptyFileThrowing(File f) throws IOException {
        if (f.isFile() && f.length() == 0L) {
            return;
        }
        if (FSUtilities.lexists(f)) {
            throw new IOException("Monkey wrench: We tried to make this an empty file but it's already something else: " + StringUtilities.repr(f.getAbsolutePath()));
        }
        f.createNewFile();
        if (f.isFile()) {
            if (f.length() != 0L) {
                throw new IOException("Monkey wrench: We tried to make this an empty file but (unless the JRE or OS is breaking API standards), it seems like something started messing with it *as soon as we made it!!* X'D  : " + StringUtilities.repr(f.getAbsolutePath()));
            }
            boolean success = false;
            try {
                Throwable throwable = null;
                Object var3_4 = null;
                try (FileOutputStream out = new FileOutputStream(f);){
                    ((OutputStream)out).write(170);
                    if (f.length() != 1L) {
                        throw new IOException("Monkey wrench: We tried to make this an empty file but (unless the JRE or OS is breaking API standards), it seems like something started messing with it *as soon as we made it!!* X'D  : " + StringUtilities.repr(f.getAbsolutePath()));
                    }
                    ((OutputStream)out).close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                if (f.length() != 1L) {
                    throw new IOException("Monkey wrench: We tried to make this an empty file but (unless the JRE or OS is breaking API standards), it seems like something started messing with it *as soon as we made it!!* X'D  : " + StringUtilities.repr(f.getAbsolutePath()));
                }
                new FileOutputStream(f).close();
                if (f.length() != 0L) {
                    throw new IOException("Monkey wrench: We tried to make this an empty file but (unless the JRE or OS is breaking API standards), it seems like something started messing with it *as soon as we made it!!* X'D  : " + StringUtilities.repr(f.getAbsolutePath()));
                }
                success = true;
            }
            finally {
                if (!success) {
                    FSUtilities.deleteMandatory(f);
                }
            }
            return;
        }
        if (FSUtilities.lexists(f)) {
            throw new IOException("Monkey wrench: We tried to make this an empty file but it's already something else: " + StringUtilities.repr(f.getAbsolutePath()));
        }
        throw new IOException("We tried to make this an empty file but failed: " + StringUtilities.repr(f.getAbsolutePath()));
    }

    public static File createTempFileUnchecked(String prefix, String suffix) throws WrappedThrowableRuntimeException {
        try {
            return File.createTempFile(prefix, suffix);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static boolean canFileExist(File f) {
        boolean lexistsAfter;
        if (FSUtilities.lexists(f)) {
            return true;
        }
        try {
            try {
                f.createNewFile();
            }
            catch (IOException exc) {
                boolean lexistsAfter2 = FSUtilities.lexists(f);
                if (lexistsAfter2) {
                    f.delete();
                }
                return false;
            }
        }
        finally {
            lexistsAfter = FSUtilities.lexists(f);
            if (lexistsAfter) {
                f.delete();
            }
        }
        return lexistsAfter;
    }

    public static void shiftFile(File f, FunctionInterfaces.UnaryFunctionIntToObject<String> nameMaker) {
        File d = f.getParentFile();
        int i = 0;
        while (FSUtilities.lexists(new File(d, nameMaker.f(i)))) {
            ++i;
        }
        int pastLast = i;
        i = pastLast - 1;
        while (i >= 0) {
            String currentName = nameMaker.f(i);
            String nextName = nameMaker.f(i + 1);
            File current = new File(d, currentName);
            File next = new File(d, nextName);
            FSUtilities.renameMandatoryRE(current, next);
            ++i;
        }
        String nextName = nameMaker.f(0);
        File next = new File(d, nextName);
        FSUtilities.renameMandatoryRE(f, next);
    }

    public static void renameMandatory(File file, File newPath) throws IOException {
        if (FSUtilities.lexists(newPath)) {
            throw new IOException("Destination already exists!: Renaming " + StringUtilities.repr(file.getAbsolutePath()) + " -> " + StringUtilities.repr(newPath.getAbsolutePath()));
        }
        if (!FSUtilities.lexists(file)) {
            throw new IOException("Source doesn't exist!: Renaming " + StringUtilities.repr(file.getAbsolutePath()) + " -> " + StringUtilities.repr(newPath.getAbsolutePath()));
        }
        if (!file.renameTo(newPath)) {
            throw new IOException("Renaming " + StringUtilities.repr(file.getAbsolutePath()) + " -> " + StringUtilities.repr(newPath.getAbsolutePath()));
        }
    }

    public static void renameMandatoryRE(File file, File newPath) throws RuntimeException {
        try {
            FSUtilities.renameMandatory(file, newPath);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static File normpath(File f) {
        return new File(FSUtilities.normpathPosix(f.getAbsolutePath(), File.separatorChar));
    }

    public static File normrelpath(File f) {
        return new File(FSUtilities.normpathPosix(f.getPath(), File.separatorChar));
    }

    public static boolean isStrictPath(File f) {
        return FSUtilities.isRoot(f) || FSUtilities.isStrictPathPosix(f.getPath(), File.separatorChar);
    }

    public static boolean isStrictPathPosix(String s) {
        return FSUtilities.isStrictPathPosix(s, '/');
    }

    public static boolean isStrictPathPosix(String s, char c) {
        if (BasicObjectUtilities.eq((Object)s, (Object)new String(new char[]{c}))) {
            return true;
        }
        List<String> es = CollectionUtilities.asList(StringUtilities.split(s, c, -1, StringUtilities.WhatToDoWithEmpties.LeaveInEmpties));
        String e0 = es.get(0);
        List<String> r = es.subList(1, es.size());
        Predicate<String> bad0 = e -> BasicObjectUtilities.eq(e, (Object)".") || BasicObjectUtilities.eq(e, (Object)"..");
        Predicate<String> badR = e -> BasicObjectUtilities.eq(e, (Object)".") || BasicObjectUtilities.eq(e, (Object)"..") || e.isEmpty();
        return !bad0.test(e0) && !CollectionUtilities.forAny(badR, r);
    }

    public static boolean isStrictNonemptyRelativePath(File f) {
        return !FSUtilities.isRoot(f) && FSUtilities.isStrictNonemptyRelativePathPosix(f.getPath(), File.separatorChar);
    }

    public static boolean isStrictNonemptyRelativePathPosix(String s) {
        return FSUtilities.isStrictNonemptyRelativePathPosix(s, '/');
    }

    public static boolean isStrictNonemptyRelativePathPosix(String s, char c) {
        Predicate<String> bad = e -> BasicObjectUtilities.eq(e, (Object)".") || BasicObjectUtilities.eq(e, (Object)"..") || e.isEmpty();
        List<String> es = CollectionUtilities.asList(StringUtilities.split(s, c, -1, StringUtilities.WhatToDoWithEmpties.LeaveInEmpties));
        return !CollectionUtilities.forAny(bad, es);
    }

    public static String normpathPosix(String f) {
        return FSUtilities.normpathPosix(f, '/');
    }

    public static String normpathPosix(String f, char separator) {
        List<String> elements;
        boolean absolute;
        if (f.isEmpty()) {
            return "";
        }
        boolean bl = absolute = f.charAt(0) == separator;
        if (absolute) {
            f = f.substring(1);
        }
        if ((elements = new ArrayList<String>(Arrays.asList(StringUtilities.split(f, separator, -1, StringUtilities.WhatToDoWithEmpties.LeaveOutEmpties)))).size() == 1 && ((String)elements.get(0)).isEmpty()) {
            elements = Collections.emptyList();
        } else {
            int i = 0;
            while (i < elements.size()) {
                String current = elements.get(i);
                if (current.isEmpty()) {
                    throw new AssertionError();
                }
                if (BasicObjectUtilities.eq((Object)current, (Object)".")) {
                    elements.remove(i);
                    continue;
                }
                if (BasicObjectUtilities.eq((Object)current, (Object)"..")) {
                    if (i != 0 && !elements.get(i - 1).equals("..")) {
                        elements.remove(i);
                        elements.remove(i - 1);
                        --i;
                        continue;
                    }
                    if (absolute) {
                        elements.remove(i);
                        continue;
                    }
                    ++i;
                    continue;
                }
                ++i;
            }
        }
        String mainpath = StringUtilities.joinStrings(elements, separator);
        return absolute ? String.valueOf(separator) + mainpath : mainpath;
    }

    @Nullable
    public static String getRelativePath(File f, File relativeBase) {
        return FSUtilities.getRelativePath(f.getAbsolutePath(), relativeBase.getAbsolutePath(), File.separatorChar);
    }

    @Nonnull
    public static String getRelativePathRequiring(File f, File relativeBase) throws NotFoundException {
        String rp = FSUtilities.getRelativePath(f, relativeBase);
        if (rp == null) {
            throw new NotFoundException(String.valueOf(StringUtilities.repr(f.getPath())) + " is not inside " + StringUtilities.repr(relativeBase.getPath()));
        }
        return rp;
    }

    public static boolean containsRealPath(File larger, File smaller) {
        return FSUtilities.containsPath(FSUtilities.realpath(larger), FSUtilities.realpath(smaller));
    }

    public static boolean containsPath(File larger, File smaller) {
        return FSUtilities.getRelativePath(larger, smaller) != null;
    }

    @Nullable
    public static String getRelativePathInPosixSyntax(File f, File relativeBase) {
        String rp = FSUtilities.getRelativePath(f, relativeBase);
        if (rp == null) {
            return null;
        }
        char s = File.separatorChar;
        if (s == '/') {
            return rp;
        }
        if (rp.indexOf(47) != -1) {
            throw new ImpossibleException("The pathname on this OS legitimately contains forward-slashes!!!");
        }
        return rp.replace(s, '/');
    }

    @Nullable
    public static String getRelativePath(String f, String base, char separator) {
        String baseplussep;
        if (f == null) {
            return null;
        }
        if (base == null) {
            return f;
        }
        if (f.equals(base)) {
            return ".";
        }
        if ((f = FSUtilities.normpathPosix(f, separator)).equals(base = FSUtilities.normpathPosix(base, separator))) {
            return ".";
        }
        String string = baseplussep = FSUtilities.isNormalizedRootPath(base, separator) ? base : String.valueOf(base) + separator;
        if (f.startsWith(baseplussep)) {
            return f.substring(baseplussep.length());
        }
        return null;
    }

    public static boolean isNormalizedRootPath(String path, char sep) {
        return path.length() == 1 && path.charAt(0) == sep;
    }

    @Nonnull
    public static String dirnamePosix(String path) {
        return FSUtilities.getAllButLastPathElementOrEmptyPosix(path);
    }

    public static String getFirstPathElement(String path, char sep) {
        int i = path.indexOf(sep);
        return i == -1 ? path : path.substring(0, i);
    }

    public static String getAllButFirstPathElement(String path, char sep) {
        int i = (path = StringUtilities.trim(path, sep)).indexOf(sep);
        return i == -1 ? path : path.substring(i + 1);
    }

    public static String[] splitPathAtFirstOrNullIfNone(String path, char sep) {
        path = StringUtilities.trim(path, sep);
        return StringUtilities.splitonceOrNull(path, sep);
    }

    public static String[] splitPathAtLastOrNullIfNone(String path, char sep) {
        path = StringUtilities.trim(path, sep);
        return StringUtilities.rsplitonceOrNull(path, sep);
    }

    @Nullable
    public static String getAllButLastPathElementOrNull(@Nonnull String path, char sep) {
        path = StringUtilities.trim(path, sep);
        return StringUtilities.rsplitonceReturnPrecedingOrNull(path, sep);
    }

    @Nonnull
    public static String getAllButLastPathElementOrEmpty(String path, char sep) {
        String r = FSUtilities.getAllButLastPathElementOrNull(path, sep);
        return r == null ? "" : r;
    }

    @Nonnull
    public static String getLastPathElement(@Nonnull String path, char delimiter) {
        int dotpos = path.lastIndexOf(delimiter);
        if (dotpos == -1) {
            return path;
        }
        return path.substring(dotpos + 1);
    }

    public static String getFirstPathElement(String path) {
        return FSUtilities.getFirstPathElement(path, File.separatorChar);
    }

    public static String getAllButFirstPathElement(String path) {
        return FSUtilities.getAllButFirstPathElement(path, File.separatorChar);
    }

    public static String[] splitPathAtFirstOrNullIfNone(String path) {
        return FSUtilities.splitPathAtFirstOrNullIfNone(path, File.separatorChar);
    }

    public static String getFirstPathElementPosix(String path) {
        return FSUtilities.getFirstPathElement(path, '/');
    }

    public static String getAllButFirstPathElementPosix(String path) {
        return FSUtilities.getAllButFirstPathElement(path, '/');
    }

    public static String[] splitPathAtFirstOrNullIfNonePoxis(String path) {
        return FSUtilities.splitPathAtFirstOrNullIfNone(path, '/');
    }

    public static String getLastPathElement(String path) {
        return FSUtilities.getLastPathElement(path, File.separatorChar);
    }

    public static String getAllButLastPathElementOrEmpty(String path) {
        return FSUtilities.getAllButLastPathElementOrEmpty(path, File.separatorChar);
    }

    public static String[] splitPathAtLastOrNullIfNone(String path) {
        return FSUtilities.splitPathAtLastOrNullIfNone(path, File.separatorChar);
    }

    public static String getLastPathElementPosix(String path) {
        return FSUtilities.getLastPathElement(path, '/');
    }

    @Nonnull
    public static String getAllButLastPathElementOrEmptyPosix(String path) {
        return FSUtilities.getAllButLastPathElementOrEmpty(path, '/');
    }

    public static String[] splitPathAtLastOrNullIfNonePoxis(String path) {
        return FSUtilities.splitPathAtLastOrNullIfNone(path, '/');
    }

    @Nullable
    public static ContainingFolderAndRelativePathWithinIt getRelativePathFromMultipleBases(File f, Iterable<File> relativeBases) {
        for (File relativeBase : relativeBases) {
            String relativePath = FSUtilities.getRelativePath(f, relativeBase);
            if (relativePath == null) continue;
            return new ContainingFolderAndRelativePathWithinIt(relativeBase, relativePath);
        }
        return null;
    }

    @Nullable
    public static ContainingFolderAndRelativePathWithinIt getRelativePathFromMultipleBases(File f, File ... relativeBases) {
        return FSUtilities.getRelativePathFromMultipleBases(f, Arrays.asList(relativeBases));
    }

    @Nonnull
    public static String getFilenameStem(@Nonnull File file) {
        return FSUtilities.getFilenameStemFromBasename(file.getName());
    }

    @Nonnull
    public static String getFilenameStem(@Nonnull String path, char separatorChar) {
        Objects.requireNonNull(path);
        int dotPos = path.lastIndexOf(46);
        int slashPos = path.lastIndexOf(separatorChar);
        int beginningPos = slashPos == -1 ? 0 : slashPos;
        int endPos = dotPos != -1 && (slashPos == -1 || dotPos > slashPos) ? dotPos : path.length();
        return path.substring(beginningPos, endPos);
    }

    @Nonnull
    public static String getFilenameStem(@Nonnull String path) {
        return FSUtilities.getFilenameStem(path, File.separatorChar);
    }

    @Nonnull
    public static String getFilenameStemFromBasename(@Nonnull String basename) {
        Objects.requireNonNull(basename);
        int dotPos = basename.lastIndexOf(46);
        if (dotPos == -1) {
            return basename;
        }
        return basename.substring(0, dotPos);
    }

    public static String getPathWithoutSuffix(File file) {
        return FSUtilities.getPathWithoutSuffix(file.getPath());
    }

    public static String getPathWithoutSuffix(String path, char separatorChar) {
        if (path == null) {
            return null;
        }
        int dotPos = path.lastIndexOf(46);
        if (dotPos == -1) {
            return path;
        }
        int slashPos = path.lastIndexOf(separatorChar);
        if (slashPos == -1) {
            return path.substring(0, dotPos);
        }
        if (dotPos < slashPos) {
            return path;
        }
        return path.substring(0, dotPos);
    }

    public static String getPathWithoutSuffix(String path) {
        return FSUtilities.getPathWithoutSuffix(path, File.separatorChar);
    }

    @Nullable
    public static String getFilenameExtension(File file) {
        return FSUtilities.getFilenameExtension(file.getName());
    }

    @Nullable
    public static String getFilenameExtension(String path, char separatorChar) {
        if (path == null) {
            return null;
        }
        int dotPos = path.lastIndexOf(46);
        if (dotPos == -1) {
            return null;
        }
        int slashPos = path.lastIndexOf(separatorChar);
        if (slashPos != -1 && dotPos < slashPos) {
            return null;
        }
        return path.substring(dotPos + 1);
    }

    @Nullable
    public static String getFilenameExtension(String path) {
        return FSUtilities.getFilenameExtension(path, File.separatorChar);
    }

    @Nonnull
    public static String getFilenameSuffix(File file) {
        return FSUtilities.getFilenameSuffixFromBasename(file.getName());
    }

    @Nonnull
    public static String getFilenameSuffix(String path) {
        return FSUtilities.getFilenameSuffix(path, File.separatorChar);
    }

    @Nonnull
    public static String getFilenameSuffix(String path, char separatorChar) {
        if (path == null) {
            return null;
        }
        int dotPos = path.lastIndexOf(46);
        if (dotPos == -1) {
            return "";
        }
        int slashPos = path.lastIndexOf(separatorChar);
        if (slashPos != -1 && dotPos < slashPos) {
            return "";
        }
        return path.substring(dotPos);
    }

    @Nonnull
    public static String getFilenameSuffixFromBasename(String path) {
        if (path == null) {
            return null;
        }
        int dotPos = path.lastIndexOf(46);
        if (dotPos == -1) {
            return "";
        }
        return path.substring(dotPos);
    }

    public static boolean isPathAbsolute(String path) {
        return new File(path).isAbsolute();
    }

    public static File resolvePath(String pathname) {
        return new File(pathname).getAbsoluteFile();
    }

    public static File resolvePath(File currentDirectory, String pathname) {
        return FSUtilities.resolvePath(currentDirectory, new File(pathname));
    }

    public static File resolvePath(File currentDirectory, File pathname) {
        return pathname.isAbsolute() ? pathname : new File(currentDirectory, pathname.getPath());
    }

    public static boolean isLegalNonspecialPathStartElement(String n) {
        if (FSUtilities.isLegalNonspecialPathStartElementPosixlike(n, File.separatorChar)) {
            return true;
        }
        return new File(n).isAbsolute();
    }

    public static boolean isLegalNonspecialPathElement(String n) {
        return FSUtilities.isLegalNonspecialPathElementPosixlike(n, File.separatorChar);
    }

    public static boolean isLegalNonspecialPathStartElementPosix(String n) {
        return FSUtilities.isLegalNonspecialPathStartElementPosixlike(n, '/');
    }

    public static boolean isLegalNonspecialPathElementPosix(String n) {
        return FSUtilities.isLegalNonspecialPathElementPosixlike(n, '/');
    }

    public static boolean isLegalNonspecialPathStartElementPosixlike(String n, char sep) {
        if (n.isEmpty() || BasicObjectUtilities.eq((Object)n, (Object)".") || BasicObjectUtilities.eq((Object)n, (Object)"..")) {
            return false;
        }
        return !BasicObjectUtilities.eq((Object)(n = StringUtilities.trim(n, sep)), (Object)".") && !BasicObjectUtilities.eq((Object)n, (Object)"..");
    }

    public static boolean isLegalNonspecialPathElementPosixlike(String n, char sep) {
        if (n.isEmpty() || BasicObjectUtilities.eq((Object)n, (Object)".") || BasicObjectUtilities.eq((Object)n, (Object)"..")) {
            return false;
        }
        if ((n = StringUtilities.rtrim(n, sep)).isEmpty() || BasicObjectUtilities.eq((Object)n, (Object)".") || BasicObjectUtilities.eq((Object)n, (Object)"..")) {
            return false;
        }
        return n.indexOf(sep) == -1;
    }

    public static File joinPathsStrict(Object ... pathElements) {
        return FSUtilities.joinPathsStrictA(pathElements);
    }

    public static File joinPathsLenient(Object ... pathElements) {
        return FSUtilities.joinPathsLenientA(pathElements);
    }

    public static File joinPathsStrictA(Object[] pathElements) {
        return FSUtilities.joinPathsStrictC(CollectionUtilities.asList(pathElements));
    }

    public static File joinPathsLenientA(Object[] pathElements) {
        return FSUtilities.joinPathsLenientC(CollectionUtilities.asList(pathElements));
    }

    public static File joinPathsStrictC(Iterable<?> pathElements) {
        return FSUtilities.joinPathsC(true, pathElements);
    }

    public static File joinPathsLenientC(Iterable<?> pathElements) {
        return FSUtilities.joinPathsC(false, pathElements);
    }

    public static File joinPathsC(boolean strict, Iterable<?> pathElements) {
        File f = null;
        boolean first = true;
        for (Object e : pathElements) {
            String n;
            String string = n = e instanceof File ? ((File)e).getPath() : (String)e;
            if (!strict && (n == null || n.isEmpty())) continue;
            if (strict) {
                Objects.requireNonNull(n);
                if (first) {
                    if (!FSUtilities.isLegalNonspecialPathStartElement(n)) {
                        throw new IllegalArgumentException("Illegal first path element in strict mode: " + StringUtilities.repr(n));
                    }
                } else if (!FSUtilities.isLegalNonspecialPathElement(n)) {
                    throw new IllegalArgumentException("Illegal non-first path element in strict mode: " + StringUtilities.repr(n));
                }
            }
            if (f == null) {
                f = e instanceof File ? (File)e : new File(n);
            } else {
                if (!strict && StringUtilities.forAll(c -> c == File.separatorChar, (CharSequence)n)) {
                    n = "";
                }
                f = new File(f, n);
            }
            first = false;
        }
        return f == null ? new File("") : f;
    }

    public static String joinPathsPosixStrict(String ... pathElements) {
        return FSUtilities.joinPathsPosix(true, pathElements);
    }

    public static String joinPathsPosixLenient(String ... pathElements) {
        return FSUtilities.joinPathsPosix(false, pathElements);
    }

    public static String joinPathsPosix(boolean strict, String ... pathElements) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        String[] stringArray = pathElements;
        int n = pathElements.length;
        int n2 = 0;
        while (n2 < n) {
            String n3 = stringArray[n2];
            if (n3.isEmpty() || n3.equals(".")) {
                first = false;
            } else {
                String nn;
                if (strict) {
                    if (first) {
                        if (!FSUtilities.isLegalNonspecialPathStartElementPosix(n3)) {
                            throw new IllegalArgumentException("Illegal first path element in strict mode: " + StringUtilities.repr(n3));
                        }
                    } else if (!FSUtilities.isLegalNonspecialPathElementPosix(n3)) {
                        throw new IllegalArgumentException("Illegal non-first path element in strict mode: " + StringUtilities.repr(n3));
                    }
                }
                n3 = (nn = StringUtilities.ltrimstrOrNull(n3, "./")) == null ? (first ? (n3.startsWith("/") ? String.valueOf('/') + StringUtilities.trim(n3, '/') : StringUtilities.trim(n3, '/')) : StringUtilities.trim(n3, '/')) : StringUtilities.trim(nn, '/');
                if (n3.isEmpty() || n3.equals(".")) {
                    first = false;
                } else {
                    if (!(first || b.length() == 0 || b.length() == 1 && b.charAt(0) == '/')) {
                        b.append('/');
                    }
                    b.append(n3);
                    first = false;
                }
            }
            ++n2;
        }
        return b.toString();
    }

    public static String[] splitPath(File path) {
        String[] nominal = StringUtilities.split(path.getPath(), File.separatorChar, -1, StringUtilities.WhatToDoWithEmpties.LeaveOutEmpties);
        if (path.getPath().startsWith("/")) {
            return ArrayUtilities.concat1WithArray("/", nominal);
        }
        if (path.getPath().startsWith("\\\\")) {
            return ArrayUtilities.concat1WithArray("\\\\", nominal);
        }
        return nominal;
    }

    public static String[] splitPath(String path, char pathSep) {
        String[] nominal = StringUtilities.split(path, pathSep, -1, StringUtilities.WhatToDoWithEmpties.LeaveOutEmpties);
        if (path.startsWith("/")) {
            return ArrayUtilities.concat1WithArray(String.valueOf(pathSep), nominal);
        }
        return nominal;
    }

    public static String[] splitPathPosix(String path) {
        return FSUtilities.splitPath(path, '/');
    }

    public static String[] listNamesSorted(File dir) {
        Object[] children = dir.list();
        Arrays.sort(children);
        return children;
    }

    public static File[] listSorted(File dir) {
        String[] childrenNames = FSUtilities.listNamesSorted(dir);
        File[] children = new File[childrenNames.length];
        int i = 0;
        while (i < children.length) {
            children[i] = new File(dir, childrenNames[i]);
            ++i;
        }
        return children;
    }

    public static void copyFile(File source, File dest) throws FileNotFoundException, IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(dest);
            JRECompatIOUtilities.pump((InputStream)in, (OutputStream)out);
            out.close();
            in.close();
        }
        catch (Throwable throwable) {
            if (in != null) {
                BasicIOUtilities.closeWithoutError(in);
            }
            if (out != null) {
                BasicIOUtilities.closeWithoutError(out);
            }
            throw throwable;
        }
        if (in != null) {
            BasicIOUtilities.closeWithoutError(in);
        }
        if (out != null) {
            BasicIOUtilities.closeWithoutError(out);
        }
        dest.setLastModified(source.lastModified());
    }

    public static void dumpToNewFile(InputStream in, File dest) throws IOException {
        if (FSUtilities.lexists(dest)) {
            throw new IOException("File " + dest + " already exists.");
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest);
            JRECompatIOUtilities.pump(in, (OutputStream)out);
        }
        catch (IOException exc) {
            BasicIOUtilities.closeWithoutError(out);
            throw exc;
        }
        out.close();
    }

    public static List<String> getClasses(ZipFile cp) {
        ArrayList<String> classes = new ArrayList<String>();
        Enumeration<? extends ZipEntry> e = cp.entries();
        while (e.hasMoreElements()) {
            String name;
            ZipEntry entry = e.nextElement();
            if (entry.isDirectory() || !(name = entry.getName()).endsWith(".class")) continue;
            name = name.replace('/', '.');
            name = name.substring(1, name.length() - 6);
            classes.add(name);
        }
        classes.trimToSize();
        return classes;
    }

    public static String[] getClasses(String cp, boolean recursive) {
        Vector<String> rv = new Vector<String>(8, 16);
        File CP = new File(cp);
        FilenameFilter cf = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                if (new File(dir, name).isDirectory()) {
                    return false;
                }
                int e = name.lastIndexOf(".");
                if (e == -1) {
                    return false;
                }
                String ext = name.substring(e);
                return ext.equalsIgnoreCase(".class");
            }
        };
        String[] cfs = CP.list(cf);
        int i = 0;
        while (i < cfs.length) {
            cfs[i] = cfs[i].substring(0, cfs[i].length() - ".class".length());
            ++i;
        }
        rv.addAll(Arrays.asList(cfs));
        if (recursive) {
            FileFilter df = new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isDirectory();
                }
            };
            File[] dirs = CP.listFiles(df);
            i = 0;
            while (i < dirs.length) {
                String[] currrv = FSUtilities.getClasses(dirs[i].getPath(), true);
                int e = 0;
                while (e < currrv.length) {
                    currrv[e] = String.valueOf(dirs[i].getName()) + "." + currrv[e];
                    ++e;
                }
                rv.addAll(Arrays.asList(currrv));
                ++i;
            }
        }
        rv.trimToSize();
        return rv.toArray(new String[0]);
    }

    public static String[] getClasses(String cp) {
        return FSUtilities.getClasses(cp, true);
    }

    public static boolean deleteRecursively(File f, boolean tryAll) {
        if (FSUtilities.isSymlink(f)) {
            return f.delete();
        }
        if (f.isDirectory()) {
            boolean allSuccess = true;
            File[] children = f.listFiles();
            boolean success = false;
            File[] fileArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                File c = fileArray[n2];
                success = FSUtilities.deleteRecursively(c, tryAll);
                if (!success && !tryAll) {
                    return false;
                }
                allSuccess &= success;
                ++n2;
            }
            if (allSuccess) {
                allSuccess &= f.delete();
            }
            return allSuccess;
        }
        if (f.exists()) {
            return f.delete();
        }
        f.delete();
        return true;
    }

    public static boolean deleteAndCheck(File f) {
        boolean reportedSuccess = f.delete();
        return reportedSuccess || !FSUtilities.lexists(f);
    }

    public static void deleteThrowing(File f) throws IOException {
        boolean success = FSUtilities.deleteAndCheck(f);
        if (!success) {
            throw new IOException("Could not delete file or directory: " + f.getAbsolutePath());
        }
    }

    public static void deleteIfExistsThrowing(File f) throws IOException {
        if (FSUtilities.lexists(f)) {
            FSUtilities.deleteThrowing(f);
        }
    }

    public static void deleteRecursivelyThrowing(File f, boolean tryAll) throws IOException {
        boolean success = FSUtilities.deleteRecursively(f, tryAll);
        if (!success) {
            throw new IOException("Could not completely delete file or directory: " + f.getAbsolutePath());
        }
    }

    public static void deleteMandatory(File f) throws UncheckedIOException {
        try {
            FSUtilities.deleteThrowing(f);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    public static void deleteIfExistsMandatory(File f) throws UncheckedIOException {
        try {
            FSUtilities.deleteIfExistsThrowing(f);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    public static void deleteRecursivelyMandatory(File f, boolean tryAll) throws UncheckedIOException {
        try {
            FSUtilities.deleteRecursivelyThrowing(f, tryAll);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    public static void move(File source, File dest) throws IOException {
        FSUtilities.move(source, dest, (s, d) -> {
            throw new IOException("Couldn't move inner file while copy-moving directory tree: " + StringUtilities.repr(s.getPath()) + " -> " + StringUtilities.repr(d.getPath()));
        });
    }

    public static void move(File source, File dest, FunctionalInterfacesThrowingCheckedExceptionsStandard.BinaryProcedureThrowingIOException<File, File> handleUnmoveableSourceDestFilePair) throws IOException {
        block22: {
            if (FSUtilities.lexists(dest)) {
                dest.delete();
            }
            if (FSUtilities.lexists(dest)) {
                throw new IOException("Could not delete pre-existing destination: " + StringUtilities.repr(dest.getAbsolutePath()));
            }
            if (source.renameTo(dest)) {
                return;
            }
            if (FSUtilities.isSymlink(source)) {
                File content = FSUtilities.readlinkRaw(source);
                FSUtilities.makelinkSymbolic(content, dest);
                dest.setLastModified(source.lastModified());
                source.delete();
            } else if (source.isFile()) {
                dest.createNewFile();
                RandomAccessFile raf = new RandomAccessFile(dest, "rw");
                raf.setLength(source.length());
                raf.close();
                FileInputStream in = null;
                FileOutputStream out = null;
                try {
                    in = new FileInputStream(source);
                    out = new FileOutputStream(dest);
                    JRECompatIOUtilities.pump((InputStream)in, (OutputStream)out);
                }
                catch (Throwable throwable) {
                    if (in != null) {
                        BasicIOUtilities.closeWithoutError(in);
                    }
                    if (out != null) {
                        BasicIOUtilities.closeWithoutError(out);
                    }
                    throw throwable;
                }
                if (in != null) {
                    BasicIOUtilities.closeWithoutError(in);
                }
                if (out != null) {
                    BasicIOUtilities.closeWithoutError(out);
                }
                dest.setLastModified(source.lastModified());
                source.delete();
            } else if (source.isDirectory()) {
                FSUtilities.moveMergingDirectoryTrees(source, dest, handleUnmoveableSourceDestFilePair);
            } else {
                if (source.exists()) {
                    List<String> cmdAndArgs = CollectionUtilities.listof("mv", source.getAbsolutePath(), dest.getAbsolutePath());
                    try {
                        int ec;
                        ProcessBuilder b = new ProcessBuilder(cmdAndArgs);
                        b.inheritIO();
                        Process p = b.start();
                        while (true) {
                            try {
                                ec = p.waitFor();
                            }
                            catch (InterruptedException interruptedException) {
                                continue;
                            }
                            break;
                        }
                        if (ec != 0) {
                            throw new IOException("Command returned non-zero exit status: " + ec);
                        }
                        break block22;
                    }
                    catch (IOException exc) {
                        throw new IOException("System move command (for special file) failed: [" + StringUtilities.reprListContentsSingleLine(cmdAndArgs) + "]", exc);
                    }
                }
                throw new IOException("Tried to move a nonexistant file:   " + StringUtilities.repr(source.getAbsolutePath()));
            }
        }
    }

    public static void moveMergingDirectoryTrees(File source, File dest, FunctionalInterfacesThrowingCheckedExceptionsStandard.BinaryProcedureThrowingIOException<File, File> handleUnmoveableSourceDestFilePair) throws IOException {
        if (source.isDirectory()) {
            if (FSUtilities.lexists(dest)) {
                if (!dest.isDirectory()) {
                    handleUnmoveableSourceDestFilePair.f(source, dest);
                    return;
                }
            } else {
                if (FSUtilities.isSymlink(source)) {
                    FSUtilities.move(source, dest);
                    return;
                }
                FSUtilities.ensureDirLeafThrowing(dest);
            }
            WidespreadTestingUtilities.asrt(source.isDirectory());
            WidespreadTestingUtilities.asrt(dest.isDirectory());
            String[] stringArray = FSUtilities.listDirectoryBasenamesOrThrow(source);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String c = stringArray[n2];
                File s = new File(source, c);
                File d = new File(dest, c);
                FSUtilities.moveMergingDirectoryTrees(s, d, handleUnmoveableSourceDestFilePair);
                ++n2;
            }
            if (!FSUtilities.isSymlink(source) && FSUtilities.listDirectoryBasenamesOrThrow(source).length == 0) {
                FSUtilities.deleteThrowing(source);
            }
        } else {
            FSUtilities.move(source, dest);
        }
    }

    @Nullable
    public static File getUniqueFileOrNull(@Nonnull File dir, @Nullable String prefix, @Nullable String suffix) {
        boolean hasPrefix = prefix != null && prefix.length() > 0;
        boolean hasSuffix = suffix != null && suffix.length() > 0;
        int randTries = 0;
        int addTries = 0;
        int counter = 0;
        File uniq = null;
        StringBuilder nameBuff = new StringBuilder();
        Random random = new Random(System.nanoTime());
        boolean first = true;
        do {
            int number;
            if (first) {
                number = random.nextInt();
                first = false;
            } else if (randTries > 1024) {
                if (addTries > 2048) {
                    return null;
                }
                if (addTries == 0) {
                    counter = random.nextInt();
                }
                number = counter++;
                ++addTries;
            } else {
                number = random.nextInt();
                ++randTries;
            }
            nameBuff.setLength(0);
            if (hasPrefix) {
                nameBuff.append(prefix);
            }
            if (number != 0) {
                String hex = Integer.toHexString(number).toUpperCase();
                int i = 0;
                while (i < 8 - hex.length()) {
                    nameBuff.append('0');
                    ++i;
                }
                nameBuff.append(hex);
            }
            if (!hasSuffix) continue;
            nameBuff.append(suffix);
        } while (FSUtilities.lexists(uniq = new File(dir, nameBuff.toString())));
        return uniq;
    }

    @Nonnull
    public static File getUniqueFileOrThrow(@Nonnull File dir, @Nullable String prefix, @Nullable String suffix) throws NoFreeResourceFoundException {
        File f = FSUtilities.getUniqueFileOrNull(dir, prefix, suffix);
        if (f != null) {
            return f;
        }
        throw new NoFreeResourceFoundException();
    }

    public static File requireExtension(File root, String desiredExtension) {
        if (root.getName().endsWith("." + desiredExtension)) {
            return root;
        }
        return new File(root.getParent(), String.valueOf(root.getName()) + "." + desiredExtension);
    }

    public static boolean compare_r(File a, File b) throws IOException {
        if (a.isFile()) {
            if (!b.isFile()) {
                return false;
            }
            return FSIOUtilities.compare(a, b);
        }
        if (a.isDirectory()) {
            if (!b.isDirectory()) {
                return false;
            }
            Object[] alist = a.list();
            Object[] blist = b.list();
            Arrays.sort(alist);
            Arrays.sort(blist);
            if (!Arrays.equals(alist, blist)) {
                return false;
            }
            Object[] objectArray = alist;
            int n = alist.length;
            int n2 = 0;
            while (n2 < n) {
                Object c = objectArray[n2];
                if (!FSIOUtilities.compare(new File(a, (String)c), new File(b, (String)c))) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        return !b.isFile() && !b.isDirectory();
    }

    public static boolean isAncestor(File ancestorCandidate, File file) {
        File cf;
        File ca = ancestorCandidate.getAbsoluteFile();
        File p = cf = file.getAbsoluteFile();
        while (p != null) {
            if (p.equals(ca)) {
                return true;
            }
            p = p.getParentFile();
        }
        return false;
    }

    public static File[] getFileArray(String ... filenames) {
        File[] files = new File[filenames.length];
        int i = 0;
        while (i < files.length) {
            files[i] = new File(filenames[i]);
            ++i;
        }
        return files;
    }

    public static File[] getFileArray(File dir, String ... basenames) {
        File[] files = new File[basenames.length];
        int i = 0;
        while (i < files.length) {
            files[i] = new File(dir, basenames[i]);
            ++i;
        }
        return files;
    }

    public static String[] getFilenameArray(File ... files) {
        String[] filenames = new String[files.length];
        int i = 0;
        while (i < files.length) {
            filenames[i] = files[i].getPath();
            ++i;
        }
        return filenames;
    }

    public static String[] getBasenameArray(File ... files) {
        String[] filenames = new String[files.length];
        int i = 0;
        while (i < files.length) {
            filenames[i] = files[i].getName();
            ++i;
        }
        return filenames;
    }

    public static File[] getFileArray(List<String> pathnames) {
        File[] files = new File[pathnames.size()];
        int i = 0;
        for (String pathname : pathnames) {
            files[i++] = new File(pathname);
        }
        return files;
    }

    public static List<File> getFileList(String[] pathnames) {
        return Arrays.asList(FSUtilities.getFileArray(pathnames));
    }

    public static List<File> getFileList(List<String> pathnames) {
        return Arrays.asList(FSUtilities.getFileArray(pathnames));
    }

    public static String[] getPathnameArray(File[] files) {
        String[] pathnames = new String[files.length];
        int i = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            pathnames[i++] = file.getPath();
            ++n2;
        }
        return pathnames;
    }

    public static String[] getPathnameArray(List<File> files) {
        String[] pathnames = new String[files.size()];
        int i = 0;
        for (File file : files) {
            pathnames[i++] = file.getPath();
        }
        return pathnames;
    }

    public static List<String> getPathnameList(File[] files) {
        return Arrays.asList(FSUtilities.getPathnameArray(files));
    }

    public static List<String> getPathnameList(List<File> files) {
        return Arrays.asList(FSUtilities.getPathnameArray(files));
    }

    public static boolean isSpecialFile(File f) {
        Objects.requireNonNull(f);
        return f.exists() && !f.isFile() && !f.isDirectory();
    }

    public static boolean isRegularFile(File f) {
        Objects.requireNonNull(f);
        return f.isFile();
    }

    public static boolean isSpecialOrRegularFile(File f) {
        Objects.requireNonNull(f);
        return f.exists() && !f.isDirectory();
    }

    public static boolean samefile(File a, File b) {
        try {
            return Files.isSameFile(a.toPath(), b.toPath());
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static void makelinkHard(File immediateTarget, File pathForHardlink) throws IOException {
        if (!immediateTarget.isFile()) {
            throw new IOException();
        }
        if (FSUtilities.lexists(pathForHardlink)) {
            throw new IOException();
        }
        Files.createLink(pathForHardlink.toPath(), immediateTarget.toPath());
    }

    public static void makelinkHardOrCopy(File immediateTarget, File pathForHardlink) throws IOException {
        if (!immediateTarget.isFile()) {
            throw new IOException();
        }
        if (FSUtilities.lexists(pathForHardlink)) {
            throw new IOException();
        }
        if (!pathForHardlink.getParentFile().isDirectory()) {
            throw new IOException();
        }
        if (FSUtilities.arePathsOnSameFileStore(immediateTarget, pathForHardlink.getParentFile())) {
            Files.createLink(pathForHardlink.toPath(), immediateTarget.toPath());
        } else {
            ObjectUtilities.copy(immediateTarget, pathForHardlink);
        }
    }

    public static boolean isSymlink(File f) {
        Objects.requireNonNull(f);
        if (f instanceof NonExistantFile) {
            return false;
        }
        try {
            return Files.isSymbolicLink(f.toPath());
        }
        catch (InvalidPathException exc) {
            return false;
        }
    }

    public static boolean fexists(File f) {
        Objects.requireNonNull(f);
        if (f instanceof NonExistantFile) {
            return false;
        }
        try {
            return f.exists();
        }
        catch (InvalidPathException exc) {
            return false;
        }
    }

    public static boolean lexists(File f) {
        Objects.requireNonNull(f);
        if (f instanceof NonExistantFile) {
            return false;
        }
        try {
            return f.exists() || FSUtilities.isSymlink(f);
        }
        catch (InvalidPathException exc) {
            return false;
        }
    }

    public static boolean isBrokenSymlink(File f) {
        Objects.requireNonNull(f);
        if (f instanceof NonExistantFile) {
            return false;
        }
        try {
            return !f.exists() && FSUtilities.isSymlink(f);
        }
        catch (InvalidPathException exc) {
            return false;
        }
    }

    public static boolean isExtantSymlink(File f) {
        Objects.requireNonNull(f);
        if (f instanceof NonExistantFile) {
            return false;
        }
        try {
            return f.exists() && FSUtilities.isSymlink(f);
        }
        catch (InvalidPathException exc) {
            return false;
        }
    }

    public static boolean isCyclicSymlink(File f) {
        if (FSUtilities.isSymlink(f)) {
            ArrayList<File> l = new ArrayList<File>();
            l.add(f);
            return FSUtilities._isCyclicSymlink(f, l);
        }
        return false;
    }

    protected static boolean _isCyclicSymlink(File f, List<File> stack) {
        File t = FSUtilities.readlinkAbsoluteRE(f);
        if (stack.contains(t)) {
            return true;
        }
        if (FSUtilities.isSymlink(t)) {
            stack.add(t);
            return FSUtilities._isCyclicSymlink(t, stack);
        }
        return false;
    }

    public static File readlinkRawRE(File f) throws WrappedThrowableRuntimeException {
        Objects.requireNonNull(f);
        try {
            return FSUtilities.readlinkRaw(f);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static File readlinkRaw(File f) throws IOException {
        Objects.requireNonNull(f);
        return Files.readSymbolicLink(f.toPath()).toFile();
    }

    public static File resolveSymlinkTarget(File symlinksTarget, File symlink) {
        File parent;
        if (symlinksTarget.isAbsolute()) {
            return symlinksTarget;
        }
        File root = new File("/");
        if (BasicObjectUtilities.eq((Object)symlink, (Object)root)) {
            parent = root;
        } else {
            parent = symlink.getParentFile();
            if (parent == null) {
                throw new ImPrettySureThisNeverActuallyHappensRuntimeException("Parent == null for this File: " + StringUtilities.repr(symlink.getPath()));
            }
        }
        return FSUtilities.joinPathsLenient(FSUtilities.realpath(parent), symlinksTarget);
    }

    public static File readlinkAbsoluteRE(File f) throws WrappedThrowableRuntimeException {
        Objects.requireNonNull(f);
        try {
            return FSUtilities.readlinkAbsolute(f);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static File readlinkAbsolute(File f) throws IOException {
        Objects.requireNonNull(f);
        return FSUtilities.resolveSymlinkTarget(FSUtilities.readlinkRaw(f), f);
    }

    public static void makelinkSymbolic(File immediateTarget, File pathForSymlink) throws IOException, InvalidPathNameIOException {
        Objects.requireNonNull(immediateTarget);
        Objects.requireNonNull(pathForSymlink);
        pathForSymlink = FSUtilities.normpath(pathForSymlink);
        if (FSUtilities.lexists(pathForSymlink)) {
            throw new IOException("Destination for symlink already exists: " + StringUtilities.repr(pathForSymlink.getAbsolutePath()));
        }
        FSUtilities._makelinkSymbolic(immediateTarget, pathForSymlink);
    }

    public static boolean makelinkSymbolicIfNotAlready(File immediateTarget, File pathForSymlink) throws IOException, InvalidPathNameIOException {
        Objects.requireNonNull(immediateTarget);
        Objects.requireNonNull(pathForSymlink);
        if (FSUtilities.lexists(pathForSymlink)) {
            if (FSUtilities.isThisSymlinkPresent(immediateTarget, pathForSymlink)) {
                return false;
            }
            throw new IOException("Destination for symlink already exists: " + StringUtilities.repr(pathForSymlink.getAbsolutePath()));
        }
        FSUtilities._makelinkSymbolic(immediateTarget, pathForSymlink);
        return true;
    }

    protected static void _makelinkSymbolic(File immediateTarget, File pathForSymlink) throws IOException, InvalidPathNameIOException {
        boolean can = FSUtilities.canFileExist(pathForSymlink);
        try {
            Files.createSymbolicLink(pathForSymlink.toPath(), immediateTarget.toPath(), new FileAttribute[0]);
        }
        catch (IOException exc) {
            if (!can) {
                throw new InvalidPathNameIOException(exc);
            }
            throw exc;
        }
        if (!can) {
            GlobalCodeMetastuffContext.logBug(String.valueOf(StringUtilities.repr(pathForSymlink.getPath())) + " \u2192 " + StringUtilities.repr(immediateTarget.getPath()));
        }
    }

    public static boolean isThisSymlinkPresent(File immediateTarget, File pathForSymlink) throws IOException {
        return FSUtilities.isSymlink(pathForSymlink) && BasicObjectUtilities.eq((Object)FSUtilities.readlinkRaw(pathForSymlink), (Object)immediateTarget);
    }

    public static boolean isRealpathEquivalentSymlinkPresent(File immediateTarget, File pathForSymlink) throws IOException {
        File immediateTargetAbsolute = FSUtilities.resolveSymlinkTarget(immediateTarget, pathForSymlink);
        return FSUtilities.isSymlink(pathForSymlink) && FSUtilities.realpathEq(pathForSymlink, immediateTargetAbsolute);
    }

    public static void remakelinkSymbolic(File immediateTarget, File pathForSymlink) throws IOException {
        Objects.requireNonNull(immediateTarget);
        Objects.requireNonNull(pathForSymlink);
        File oldTarget = null;
        if (FSUtilities.isSymlink(pathForSymlink)) {
            oldTarget = FSUtilities.readlinkRaw(pathForSymlink);
            pathForSymlink.delete();
            if (FSUtilities.lexists(pathForSymlink)) {
                throw new IOException("Destination already exists and we couldn't get rid of it!  (" + StringUtilities.repr(pathForSymlink.getAbsolutePath()) + ")");
            }
        } else if (FSUtilities.lexists(pathForSymlink)) {
            throw new IOException("Destination already exists but isn't a symlink!  (" + StringUtilities.repr(pathForSymlink.getAbsolutePath()) + ")");
        }
        pathForSymlink.delete();
        boolean success = false;
        try {
            FSUtilities.makelinkSymbolic(immediateTarget, pathForSymlink);
            success = true;
        }
        finally {
            if (!success && oldTarget != null) {
                FSUtilities.makelinkSymbolic(oldTarget, pathForSymlink);
            }
        }
    }

    public static boolean lexists_old(File f) {
        if (f instanceof NonExistantFile) {
            return false;
        }
        return f.exists() || FSUtilities.isInParentDirectoryListing(f);
    }

    public static boolean isSymlink_old(File f) {
        if (f instanceof NonExistantFile) {
            return false;
        }
        return FSUtilities.isBrokenSymlink(f) || FSUtilities.isExtantSymlink(f);
    }

    public static boolean isBrokenSymlink_old(File f) {
        if (f instanceof NonExistantFile) {
            return false;
        }
        return !f.exists() && FSUtilities.isInParentDirectoryListing(f);
    }

    public static boolean isExtantSymlink_old(File f) {
        File canonicalFile;
        if (f instanceof NonExistantFile) {
            return false;
        }
        f = FSUtilities.normpath(f);
        String basename = f.getName();
        File namedParent = f.getParentFile();
        if (namedParent == null) {
            return false;
        }
        File canonicalParent = FSUtilities.realpath(namedParent);
        File fileInCanonicalParent = new File(canonicalParent, basename);
        return !fileInCanonicalParent.equals(canonicalFile = FSUtilities.realpath(fileInCanonicalParent));
    }

    public static boolean isInParentDirectoryListing(File f) {
        if (f instanceof NonExistantFile) {
            return false;
        }
        File parent = (f = f.getAbsoluteFile()).getParentFile();
        if (!parent.isDirectory()) {
            return false;
        }
        String[] siblings = parent.list();
        if (siblings == null) {
            throw new WrappedThrowableRuntimeException(new IOException("null directory listing, for file: " + StringUtilities.repr(f.getPath()) + "     This usually means Permission Denied, I've found"));
        }
        String[] stringArray = siblings;
        int n = siblings.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.equals(f.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void recurse(FunctionInterfaces.UnaryProcedure<File> observer, Predicate<File> descendRecurseFilter, Iterable<File> targets) {
        HashSet<File> done = new HashSet<File>();
        Stack<File> todo = new Stack<File>();
        for (File target : targets) {
            observer.f(target);
            if (target.isDirectory()) {
                done.add(FSUtilities.realpath(target));
                if (descendRecurseFilter == null || descendRecurseFilter.test(target)) {
                    todo.push(target);
                }
            }
            while (!todo.isEmpty()) {
                File[] files;
                File dir = (File)todo.pop();
                try {
                    files = dir.listFiles();
                }
                catch (OutOfMemoryError exc) {
                    System.err.println("Out-of-memory error while listing " + StringUtilities.repr(dir.getAbsolutePath()));
                    throw exc;
                }
                if (files == null) {
                    throw new WrappedThrowableRuntimeException(new IOException("Listing directory failed for: " + StringUtilities.repr(dir.getAbsolutePath())));
                }
                File[] fileArray = CollectionUtilities.sorted(files);
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File fRP;
                    File f = fileArray[n2];
                    observer.f(f);
                    if (f.isDirectory() && !done.contains(fRP = FSUtilities.realpath(f)) && (descendRecurseFilter == null || descendRecurseFilter.test(f))) {
                        done.add(fRP);
                        todo.push(f);
                    }
                    ++n2;
                }
            }
        }
    }

    public static void recurse(FunctionInterfaces.UnaryProcedure<File> observer, Iterable<File> targets) {
        FSUtilities.recurse(observer, DescendRecurse_Always, targets);
    }

    public static void recurse(FunctionInterfaces.UnaryProcedure<File> observer, Predicate<File> descendRecurseFilter, File ... targets) {
        FSUtilities.recurse(observer, descendRecurseFilter, Arrays.asList(targets));
    }

    public static void recurse(FunctionInterfaces.UnaryProcedure<File> observer, File ... targets) {
        FSUtilities.recurse(observer, Arrays.asList(targets));
    }

    public static List<File> accumulateFiles(Predicate<File> descendRecurseFilter, Predicate<File> inclusionFilter, Iterable<File> targets) {
        AccumulatingObserver accumulator = new AccumulatingObserver(inclusionFilter, new ArrayList());
        FSUtilities.recurse(accumulator, descendRecurseFilter, targets);
        return accumulator.getCollection();
    }

    public static File[] accumulateFilesA(Predicate<File> descendRecurseFilter, Predicate<File> inclusionFilter, Iterable<File> targets) {
        List<File> l = FSUtilities.accumulateFiles(descendRecurseFilter, inclusionFilter, targets);
        return l.toArray(new File[l.size()]);
    }

    public static List<File> accumulateFiles(Predicate<File> descendRecurseFilter, Predicate<File> inclusionFilter, File ... targets) {
        AccumulatingObserver accumulator = new AccumulatingObserver(inclusionFilter, new ArrayList());
        FSUtilities.recurse(accumulator, descendRecurseFilter, targets);
        return accumulator.getCollection();
    }

    public static File[] accumulateFilesA(Predicate<File> descendRecurseFilter, Predicate<File> inclusionFilter, File ... targets) {
        List<File> l = FSUtilities.accumulateFiles(descendRecurseFilter, inclusionFilter, targets);
        return l.toArray(new File[l.size()]);
    }

    public static List<File> accumulateFiles(Iterable<File> targets) {
        AccumulatingObserver accumulator = new AccumulatingObserver(new ArrayList());
        FSUtilities.recurse(accumulator, targets);
        return accumulator.getCollection();
    }

    public static File[] accumulateFilesA(Iterable<File> targets) {
        List<File> l = FSUtilities.accumulateFiles(targets);
        return l.toArray(new File[l.size()]);
    }

    public static List<File> accumulateFiles(File ... targets) {
        AccumulatingObserver accumulator = new AccumulatingObserver(new ArrayList());
        FSUtilities.recurse(accumulator, targets);
        return accumulator.getCollection();
    }

    public static File[] accumulateFilesA(File ... targets) {
        List<File> l = FSUtilities.accumulateFiles(targets);
        return l.toArray(new File[l.size()]);
    }

    public static List<File> recurseAndExpandFoldersIntoJustFiles(Iterable<File> targets) {
        return FSUtilities.accumulateFiles(DescendRecurse_Always, File::isFile, targets);
    }

    public static int rmdirs(boolean followSymlinks, File ... targets) {
        int before;
        int after;
        final SimpleContainers.SimpleIntegerContainer totalEmptyDirsRemoved = new SimpleContainers.SimpleIntegerContainer();
        do {
            before = totalEmptyDirsRemoved.get();
            FSUtilities.recurse(new FunctionInterfaces.UnaryProcedure<File>(){

                @Override
                public void f(File input) {
                    if (input.isDirectory() && input.list().length == 0) {
                        input.delete();
                        totalEmptyDirsRemoved.set(totalEmptyDirsRemoved.get());
                    }
                }
            }, followSymlinks ? DescendRecurse_Always : DescendRecurse_NoSymlinks, targets);
        } while ((after = totalEmptyDirsRemoved.get()) != before);
        return totalEmptyDirsRemoved.get();
    }

    @Nonnull
    public static File realpathThrowing(@Nonnull File f) throws IOException {
        File r;
        if (f.exists() && (r = f.getCanonicalFile()).exists() && !FSUtilities.isSymlink(r)) {
            File o = FSUtilities._realpathThrowing_ourImpl(f);
            if (!BasicObjectUtilities.eq((Object)r, (Object)o)) {
                throw new AssertionError((Object)("realpath(" + StringUtilities.repr(f.getPath()) + "): " + StringUtilities.repr(r.getPath()) + " != " + StringUtilities.repr(o.getPath())));
            }
            return r;
        }
        return FSUtilities._realpathThrowing_ourImpl(f);
    }

    @ImplementationTransparency
    public static File _realpathThrowing_ourImpl(File f) throws IOException {
        return FSUtilities._realpathThrowing_ourImpl(f, (l, t) -> FSUtilities.resolveSymlinkTarget(t, l));
    }

    @ImplementationTransparency
    public static File _realpathThrowing_ourImpl(File f, LinkDereferencer linkDereferencingPredicate) throws IOException {
        Stack<File> s = new Stack<File>();
        File r = FSUtilities._realpathThrowing_ourImpl(f, s, linkDereferencingPredicate);
        WidespreadTestingUtilities.asrt(s.isEmpty());
        return r;
    }

    protected static File _realpathThrowing_ourImpl(File f, Stack<File> stack, LinkDereferencer linkDereferencingPredicate) throws IOException {
        File p = (f = FSUtilities.normpath(f)).getParentFile();
        if (p == null) {
            return f;
        }
        File d = FSUtilities._realpathThrowing_ourImpl(p, stack, linkDereferencingPredicate);
        String n = f.getName();
        File file = f = BasicObjectUtilities.eq((Object)n, (Object)".") ? d : new File(d, n);
        if (FSUtilities.isSymlink(f)) {
            File it = FSUtilities.readlinkRaw(f);
            File t = linkDereferencingPredicate.dereference(f, it);
            if (t != null) {
                if (stack.contains(f)) {
                    throw new SymlinkCycleIOException("Symbolic link cycle detected!!: " + StringUtilities.repr(f.getPath()));
                }
                stack.add(f);
                File r = FSUtilities._realpathThrowing_ourImpl(t, stack, linkDereferencingPredicate);
                WidespreadTestingUtilities.asrt(stack.pop() == f);
                return r;
            }
            return f;
        }
        return f;
    }

    public static boolean realpathEq(File a, File b) {
        File brp;
        File arp;
        try {
            arp = FSUtilities.realpathThrowing(a);
            brp = FSUtilities.realpathThrowing(b);
        }
        catch (SymlinkCycleIOException exc) {
            block8: {
                if (FSUtilities.isSymlink(a)) {
                    if (FSUtilities.isSymlink(b)) {
                        return BasicObjectUtilities.eq((Object)FSUtilities.readlinkAbsolute(a), (Object)FSUtilities.readlinkAbsolute(b));
                    }
                    return false;
                }
                try {
                    if (!FSUtilities.isSymlink(b)) break block8;
                    return false;
                }
                catch (IOException exc2) {
                    throw new WrappedThrowableRuntimeException(exc2);
                }
            }
            return BasicObjectUtilities.eq((Object)a, (Object)b);
        }
        return BasicObjectUtilities.eq((Object)arp, (Object)brp);
    }

    @Nonnull
    public static File realpath(@Nonnull File f) throws WrappedThrowableRuntimeException {
        try {
            return FSUtilities.realpathThrowing(f);
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static Set<File> getCanonicalSetPathnames(Iterable<File> files) {
        HashSet<File> canonicalSet = new HashSet<File>();
        for (File f : files) {
            canonicalSet.add(FSUtilities.realpath(f));
        }
        return canonicalSet;
    }

    public static Set<File> getCanonicalSetPathnames(File ... files) {
        return FSUtilities.getCanonicalSetPathnames(Arrays.asList(files));
    }

    public static Set<File> getAbsoluteSetPathnames(Iterable<File> files) {
        HashSet<File> canonicalSet = new HashSet<File>();
        for (File f : files) {
            canonicalSet.add(FSUtilities.abspath(f));
        }
        return canonicalSet;
    }

    public static Set<File> getAbsoluteSetPathnames(File ... files) {
        return FSUtilities.getAbsoluteSetPathnames(Arrays.asList(files));
    }

    public static File[] boxFiles(String ... pathnames) {
        if (pathnames == null) {
            return null;
        }
        File[] boxed = new File[pathnames.length];
        int i = 0;
        while (i < pathnames.length) {
            boxed[i] = new File(pathnames[i]);
            ++i;
        }
        return boxed;
    }

    public static List<File> boxFiles(Iterable<String> pathnames) {
        if (pathnames == null) {
            return null;
        }
        ArrayList<File> boxed = new ArrayList<File>();
        for (String pathname : pathnames) {
            boxed.add(new File(pathname));
        }
        return boxed;
    }

    public static String[] unboxFiles(File ... files) {
        if (files == null) {
            return null;
        }
        String[] unboxed = new String[files.length];
        int i = 0;
        while (i < files.length) {
            unboxed[i] = files[i].getPath();
            ++i;
        }
        return unboxed;
    }

    public static List<String> unboxFiles(Iterable<File> files) {
        if (files == null) {
            return null;
        }
        ArrayList<String> unboxed = new ArrayList<String>();
        for (File file : files) {
            unboxed.add(file.getPath());
        }
        return unboxed;
    }

    public static boolean isPathnameContainingPathSeparator(String path) {
        return path.contains(File.pathSeparator);
    }

    public static boolean isPathContainingPathSeparator(File path) {
        return path.getPath().contains(File.pathSeparator);
    }

    public static boolean isAnyPathnameContainingPathSeparator(String ... paths) {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.contains(File.pathSeparator)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAnyPathContainingPathSeparator(File ... paths) {
        File[] fileArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File path = fileArray[n2];
            if (path.getPath().contains(File.pathSeparator)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAnyPathnameContainingPathSeparator(Iterable<String> paths) {
        for (String path : paths) {
            if (!path.contains(File.pathSeparator)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnyPathContainingPathSeparator(Iterable<File> paths) {
        for (File path : paths) {
            if (!path.getPath().contains(File.pathSeparator)) continue;
            return true;
        }
        return false;
    }

    public static void checkPathnameDoesNotContainPathSeparator(String path) throws PathnameContainsPathSeparatorException {
        if (path.contains(File.pathSeparator)) {
            throw PathnameContainsPathSeparatorException.instForAGivenPathname(path);
        }
    }

    public static void checkPathDoesNotContainPathSeparator(File path) throws PathnameContainsPathSeparatorException {
        if (!path.getPath().contains(File.pathSeparator)) {
            throw PathnameContainsPathSeparatorException.instForAGivenPathname(path);
        }
    }

    public static void checkNoPathnameContainsPathSeparator(String ... paths) throws PathnameContainsPathSeparatorException {
        String[] stringArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            if (path.contains(File.pathSeparator)) {
                throw PathnameContainsPathSeparatorException.instForAGivenPathname(path);
            }
            ++n2;
        }
    }

    public static void checkNoPathContainsPathSeparator(File ... paths) throws PathnameContainsPathSeparatorException {
        File[] fileArray = paths;
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            File path = fileArray[n2];
            if (path.getPath().contains(File.pathSeparator)) {
                throw PathnameContainsPathSeparatorException.instForAGivenPathname(path);
            }
            ++n2;
        }
    }

    public static void checkNoPathnameContainsPathSeparator(Iterable<String> paths) throws PathnameContainsPathSeparatorException {
        for (String path : paths) {
            if (!path.contains(File.pathSeparator)) continue;
            throw PathnameContainsPathSeparatorException.instForAGivenPathname(path);
        }
    }

    public static void checkNoPathContainsPathSeparator(Iterable<File> paths) throws PathnameContainsPathSeparatorException {
        for (File path : paths) {
            if (!path.getPath().contains(File.pathSeparator)) continue;
            throw PathnameContainsPathSeparatorException.instForAGivenPathname(path);
        }
    }

    public static File abspath(File f) {
        return f.isAbsolute() ? f : f.getAbsoluteFile();
    }

    public static String[] split3(String f) {
        return FSUtilities.split3(new File(f));
    }

    public static String[] split3(File f) {
        return new String[]{f.getParent(), FSUtilities.getFilenameStem(f), FSUtilities.getFilenameSuffix(f)};
    }

    public static String[] split2posix(String f) {
        String[] stringArray;
        int i = f.indexOf(47);
        if (i == -1) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = ".";
            stringArray = stringArray2;
            stringArray2[1] = f;
        } else {
            String[] stringArray3 = new String[2];
            stringArray3[0] = f.substring(0, i);
            stringArray = stringArray3;
            stringArray3[1] = f.substring(i + 1);
        }
        return stringArray;
    }

    public static Set<File> findFilesWithCaseSensitivelyConflictingBasenames(Set<File> files) {
        List<String> basenames = CollectionUtilities.mapToNewList(File::getName, files);
        Map<String, Integer> c = CollectionUtilities.getCounts(basenames);
        HashSet<File> conflictings = new HashSet<File>();
        for (File f : files) {
            if (c.get(f.getName()) <= 1) continue;
            conflictings.add(f);
        }
        return conflictings;
    }

    public static Set<File> findFilesWithCaseInsensitivelyConflictingBasenames(Set<File> files) {
        List<String> basenames = CollectionUtilities.mapToNewList(f -> f.getName().toLowerCase(), files);
        Map<String, Integer> c = CollectionUtilities.getCounts(basenames);
        HashSet<File> conflictings = new HashSet<File>();
        for (File f2 : files) {
            if (c.get(f2.getName().toLowerCase()) <= 1) continue;
            conflictings.add(f2);
        }
        return conflictings;
    }

    public static Set<File> realpathAndUniquify(Iterable<File> paths) {
        HashSet<File> r = new HashSet<File>();
        for (File p : paths) {
            r.add(FSUtilities.realpath(p));
        }
        return r;
    }

    public static Set<File> abspathAndUniquify(Iterable<File> paths) {
        HashSet<File> r = new HashSet<File>();
        for (File p : paths) {
            r.add(p.getAbsoluteFile());
        }
        return r;
    }

    public static boolean anyOverlapsRealpathed(Collection<File> paths) {
        return FSUtilities.anyOverlapsRealpathed(paths, null);
    }

    public static boolean anyOverlapsRealpathed(Collection<File> paths, @Nullable FunctionInterfaces.BinaryProcedure<File, File> overlapObserver) {
        paths = FSUtilities.realpathAndUniquify(paths);
        return FSUtilities.anyOverlapsRaw(paths, overlapObserver);
    }

    public static boolean anyOverlapsRaw(Collection<File> paths) {
        return FSUtilities.anyOverlapsRaw(paths, null);
    }

    public static boolean anyOverlapsRaw(Collection<File> paths, @Nullable FunctionInterfaces.BinaryProcedure<File, File> overlapObserver) {
        boolean has = false;
        for (File a : paths) {
            a = a.getAbsoluteFile();
            List<String> aSplit = CollectionUtilities.asList(FSUtilities.splitPath(a));
            for (File b : paths) {
                List<String> bSplit;
                if (BasicObjectUtilities.eq((Object)a, (Object)(b = b.getAbsoluteFile())) || !CollectionUtilities.startsWithLists(aSplit, bSplit = CollectionUtilities.asList(FSUtilities.splitPath(b)))) continue;
                if (overlapObserver != null) {
                    overlapObserver.f(a, b);
                }
                has = true;
            }
        }
        return has;
    }

    public static boolean anyOverlapsRawPosix(Collection<String> paths) {
        return FSUtilities.anyOverlapsRawPosix(paths, null);
    }

    public static boolean anyOverlapsRawPosix(Collection<String> paths, @Nullable FunctionInterfaces.BinaryProcedure<String, String> overlapObserver) {
        boolean has = false;
        for (String a : paths) {
            List<String> aSplit = CollectionUtilities.asList(FSUtilities.splitPathPosix(FSUtilities.normpathPosix(a)));
            for (String b : paths) {
                List<String> bSplit;
                if (BasicObjectUtilities.eq((Object)a, (Object)b) || !CollectionUtilities.startsWithLists(aSplit, bSplit = CollectionUtilities.asList(FSUtilities.splitPathPosix(FSUtilities.normpathPosix(b))))) continue;
                if (overlapObserver != null) {
                    overlapObserver.f(a, b);
                }
                has = true;
            }
        }
        return has;
    }

    public static void performSafeFileSystemWriteTwoStageAndCopy(File dest, byte[] data) throws IOException {
        FSUtilities.performSafeFileSystemWriteTwoStageAndCopy(dest, o -> o.write(data));
    }

    public static void performSafeFileSystemWriteTwoStageAndCopy(File dest, WriterProcedure write) throws IOException {
        block29: {
            File p = dest.getParentFile();
            if (!p.isDirectory()) {
                throw new IOException("Not a directory: " + StringUtilities.repr(p.getAbsolutePath()));
            }
            boolean specialFile = FSUtilities.isSpecialFile(dest);
            boolean ex = FSUtilities.lexists(dest);
            if (specialFile || dest.isFile() || !ex) {
                File temporary;
                if (specialFile) {
                    Throwable throwable = null;
                    Object var6_8 = null;
                    try (FileOutputStream out = new FileOutputStream(dest);){
                        write.write(out);
                        break block29;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                if (ex) {
                    WidespreadTestingUtilities.asrt(!FSUtilities.isSymlink(dest = FSUtilities.realpath(dest)));
                }
                if (FSUtilities.lexists(temporary = FSUtilities.getUniqueFileOrNull(p, dest.getName(), ".tmp"))) {
                    throw new IOException("Strange error while making temp file: " + StringUtilities.repr(temporary.getAbsolutePath()));
                }
                FSUtilities.ensureEmptyFileThrowing(temporary);
                if (!temporary.canWrite() && !(temporary = File.createTempFile(dest.getName(), ".tmp")).canWrite()) {
                    GlobalCodeMetastuffContext.logBug();
                }
                boolean success = false;
                try {
                    Throwable throwable = null;
                    Object var8_14 = null;
                    try (FileOutputStream out = new FileOutputStream(temporary);){
                        write.write(out);
                        success = true;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                finally {
                    if (!success) {
                        temporary.delete();
                    }
                }
                WidespreadTestingUtilities.asrt(success);
                FSUtilities.deleteIfExistsMandatory(dest);
                FSUtilities.renameMandatory(temporary, dest);
            } else {
                throw new IOException("Tried to write into an invalid destination!: " + StringUtilities.repr(dest.getAbsolutePath()));
            }
        }
    }

    public static FileChannel openReadonlyNIO(File file) throws IOException {
        return FileSystems.getDefault().provider().newFileChannel(file.toPath(), Collections.singleton(StandardOpenOption.READ), new FileAttribute[0]);
    }

    public static FileChannel openReadwriteNIO(File file) throws IOException {
        return FileSystems.getDefault().provider().newFileChannel(file.toPath(), EnumSet.of(StandardOpenOption.READ, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING), new FileAttribute[0]);
    }

    public static boolean arePathsOnSameFileStore(File a, File b) {
        return FSUtilities.arePathsOnSameFileStore(a.toPath(), b.toPath());
    }

    public static boolean arePathsOnSameFileStore(Path a, Path b) {
        try {
            return BasicObjectUtilities.eq((Object)Files.getFileStore(a), (Object)Files.getFileStore(b));
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static SimpleFileLock lockFile(File f, boolean blocking) throws IOException {
        return blocking ? FSUtilities.lockFileBlocking(f) : FSUtilities.lockFileNonblocking(f);
    }

    @Nonnull
    public static SimpleFileLock lockFileBlocking(File f) throws IOException {
        final FileChannel c = FileChannel.open(f.toPath(), StandardOpenOption.WRITE);
        final FileLock l = c.lock();
        Objects.requireNonNull(l);
        return new SimpleFileLock(){
            boolean closed = false;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    l.release();
                    c.close();
                    this.closed = true;
                }
            }
        };
    }

    @Nullable
    public static SimpleFileLock lockFileNonblocking(File f) throws IOException {
        FileLock l_;
        final FileChannel c = FileChannel.open(f.toPath(), StandardOpenOption.WRITE);
        try {
            l_ = c.tryLock();
        }
        catch (OverlappingFileLockException exc) {
            l_ = null;
        }
        final FileLock l = l_;
        return l == null ? null : new SimpleFileLock(){
            boolean closed = false;

            @Override
            public void close() throws IOException {
                if (!this.closed) {
                    l.release();
                    c.close();
                    this.closed = true;
                }
            }
        };
    }

    public static void doLockedOnFileBlockingOrNotIfNull(@Nullable File f, FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingIOException r) throws IOException {
        if (f == null) {
            r.run();
        } else {
            FSUtilities.doLockedOnFileBlocking(f, r);
        }
    }

    public static void doLockedOnFileBlocking(@Nonnull File f, FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingIOException r) throws IOException {
        Objects.requireNonNull(f);
        Throwable throwable = null;
        Object var3_4 = null;
        try (SimpleFileLock l = FSUtilities.lockFileBlocking(f);){
            r.run();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doLockedOnFileNonblocking(File f, FunctionalInterfacesThrowingCheckedExceptionsStandard.RunnableThrowingIOException r) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            SimpleFileLock l = FSUtilities.lockFileNonblocking(f);
            try {
                if (l == null) {
                    return false;
                }
                r.run();
                return true;
            }
            catch (Throwable throwable2) {
                throw throwable2;
            }
            finally {
                if (l == null) return false;
                l.close();
            }
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            }
            if (throwable == throwable3) throw throwable;
            throwable.addSuppressed(throwable3);
            throw throwable;
        }
    }

    public static String fsescape(String s) {
        return s.replace("\\", "\\e").replace("\u2044", "\\s").replace("/", "\u2044");
    }

    public static String fsdescape(String s) {
        return s.replace("\u2044", "/").replace("\\s", "\u2044").replace("\\e", "\\");
    }

    public static boolean doesPathContainStandardUpwardTraversalMetaElement(String path) {
        return path.equals("..") || path.contains("/../") || path.startsWith("../") || path.endsWith("/..");
    }

    public static boolean isInSetByRealpaths(Iterable<File> set, File f) {
        for (File c : set) {
            if (!FSUtilities.realpathEq(f, c)) continue;
            return true;
        }
        return false;
    }

    public static void repopulateDirectoryWithSymlinksDeletingAllExtantSymlinksButFailingIfAnythingElseInside(File dir, Map<String, File> symlinks) throws IOException {
        if (FSUtilities.lexists(dir)) {
            FSUtilities.ensureDirsWholePathThrowing(dir);
            FSUtilities.clearDirectoryOfSymlinks(dir);
        } else {
            FSUtilities.ensureDirsWholePathThrowing(dir);
        }
        for (Map.Entry<String, File> e : symlinks.entrySet()) {
            if (FSUtilities.doesPathContainStandardUpwardTraversalMetaElement(e.getKey())) {
                throw new IllegalArgumentException(e.getKey());
            }
            File pathForSymlink = new File(dir, e.getKey());
            File immediateTarget = e.getValue();
            FSUtilities.makelinkSymbolic(immediateTarget, pathForSymlink);
        }
    }

    public static void clearDirectoryOfSymlinks(File dir) throws IOException {
        FSUtilities.clearDirectoryOfMatchingEmpties(dir, f -> FSUtilities.isSymlink(f));
    }

    public static void clearDirectoryOfMatchingEmpties(File dir, Predicate<File> pattern) throws IOException {
        File c;
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            c = fileArray[n2];
            if (!pattern.test(c)) {
                throw new IOException("Directory has non-matching file in it!!: " + StringUtilities.repr(c.getAbsolutePath()));
            }
            ++n2;
        }
        fileArray = dir.listFiles();
        n = fileArray.length;
        n2 = 0;
        while (n2 < n) {
            c = fileArray[n2];
            if (!pattern.test(c)) {
                throw new IOException("Directory has non-matching file in it!!: " + StringUtilities.repr(c.getAbsolutePath()));
            }
            c.delete();
            ++n2;
        }
    }

    public static void deleteMatching(File dir, Predicate<File> pattern) throws IOException {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File c = fileArray[n2];
            if (pattern.test(c)) {
                FSUtilities.deleteMandatory(c);
            }
            ++n2;
        }
    }

    public static void createNewFileUnchecked(File f) {
        try {
            f.createNewFile();
        }
        catch (IOException exc) {
            throw new WrappedThrowableRuntimeException(exc);
        }
    }

    public static File getNextFreePathPreservingExtension(File f, Predicate<File> returnNullIf) {
        if (FSUtilities.isRoot(f)) {
            throw new IllegalArgumentException(StringUtilities.repr(f.getAbsolutePath()));
        }
        int i = 1;
        File d = f.getAbsoluteFile().getParentFile();
        Objects.requireNonNull(d);
        String n = f.getName();
        String stem = StringUtilities.splitonceReturnPrecedingOrWhole(n, '.');
        String ext = StringUtilities.splitonceReturnSucceedingOrNull(n, '.');
        do {
            int ii;
            File t;
            if ((t = FSUtilities.getMaxPath(stem, d, arg_0 -> FSUtilities.lambda$9(ii = i, ext, arg_0), s -> String.valueOf(s) + '\u2026' + (ii == 1 ? "" : " (" + ii + ")") + (ext == null ? "" : String.valueOf('.') + ext), x -> FSUtilities.canFileExist(x))) == null) {
                if (ext == null) {
                    throw new WrappedThrowableRuntimeException(new IOException("The first character must have made it illegal!: " + StringUtilities.repr(stem)));
                }
                t = FSUtilities.getMaxPath(n, d, s -> String.valueOf(s) + (ii == 1 ? "" : " (" + ii + ")"), s -> String.valueOf(s) + '\u2026' + (ii == 1 ? "" : " (" + ii + ")"), x -> FSUtilities.canFileExist(x));
                if (t == null) {
                    throw new WrappedThrowableRuntimeException(new IOException("The first character must have made it illegal!: " + StringUtilities.repr(n)));
                }
            }
            if (!FSUtilities.lexists(t)) {
                return t;
            }
            if (!returnNullIf.test(t)) continue;
            return null;
        } while (++i != 0);
        throw new OverflowException();
    }

    public static File getNextFreePathNotPreservingExtension(File f, Predicate<File> returnNullIf) {
        if (FSUtilities.isRoot(f)) {
            throw new IllegalArgumentException(StringUtilities.repr(f.getAbsolutePath()));
        }
        int i = 1;
        File d = f.getAbsoluteFile().getParentFile();
        Objects.requireNonNull(d);
        String n = f.getName();
        do {
            int ii;
            File t;
            if ((t = FSUtilities.getMaxPath(n, d, arg_0 -> FSUtilities.lambda$15(ii = i++, arg_0), s -> String.valueOf(s) + '\u2026' + (ii == 1 ? "" : " (" + ii + ")"), x -> FSUtilities.canFileExist(x))) == null) {
                throw new WrappedThrowableRuntimeException(new IOException("The first character must have made it illegal!: " + StringUtilities.repr(n)));
            }
            if (!FSUtilities.lexists(t)) {
                return t;
            }
            if (!returnNullIf.test(t)) continue;
            return null;
        } while (i != 0);
        throw new OverflowException();
    }

    public static boolean isRoot(File f) {
        return ArrayUtilities.forAny(r -> BasicObjectUtilities.eq((Object)f, r), File.listRoots());
    }

    @Nonnull
    public static File getMaxPath(String sOrig, File dir) {
        File r = FSUtilities.getMaxPath(sOrig, dir, s -> s, s -> String.valueOf(s) + '\u2026', f -> FSUtilities.canFileExist(f));
        if (r == null) {
            throw new WrappedThrowableRuntimeException(new IOException("The first character must have made it illegal!: " + StringUtilities.repr(sOrig)));
        }
        return r;
    }

    @Nullable
    public static File getMaxPath(String sOrig, File dir, FunctionInterfaces.UnaryFunction<String, String> originalPathnameModifier, FunctionInterfaces.UnaryFunction<String, String> truncatedPathnameModifier, Predicate<File> validityTest) {
        StringUtilities.requireNonEmpty(sOrig);
        String s = sOrig;
        File lp = new File(dir, originalPathnameModifier.f(s));
        while (!validityTest.test(lp) && !s.isEmpty()) {
            s = s.substring(0, s.length() - 1);
            lp = new File(dir, truncatedPathnameModifier.f(s));
        }
        if (s.isEmpty()) {
            return null;
        }
        return lp;
    }

    public static Map<String, byte[]> readEntireDirectoryTreeFiles(File d, int entryCountLimit, long fileSizeLimit) {
        return FSUtilities.readEntireDirectoryTreeFiles(d, f -> true, entryCountLimit, fileSizeLimit);
    }

    public static Map<String, FunctionInterfaces.NullaryFunction<byte[]>> readEntireDirectoryTreeFilesLazy(File d, int entryCountLimit, long fileSizeLimit) {
        return FSUtilities.readEntireDirectoryTreeFilesLazy(d, f -> true, entryCountLimit, fileSizeLimit);
    }

    public static Map<String, byte[]> readEntireDirectoryTreeFiles(File d, Predicate<File> p, int entryCountLimit, long fileSizeLimit) {
        return CollectionUtilities.mapdictvalues(v -> (byte[])v.f(), FSUtilities.readEntireDirectoryTreeFilesLazy(d, p, entryCountLimit, fileSizeLimit));
    }

    public static Map<String, FunctionInterfaces.NullaryFunction<byte[]>> readEntireDirectoryTreeFilesLazy(File d, Predicate<File> p, int entryCountLimit, long fileSizeLimit) {
        HashMap<String, FunctionInterfaces.NullaryFunction<byte[]>> rv = new HashMap<String, FunctionInterfaces.NullaryFunction<byte[]>>();
        FSUtilities.recurse((File f) -> {
            if (f.isFile() && p.test((File)f)) {
                int n2 = rv.size();
                if (n2 >= entryCountLimit) {
                    throw new WrappedThrowableRuntimeException(new IOException("Number of files (" + n2 + ") exceeded limit (" + entryCountLimit + ") inside " + StringUtilities.repr(d.getAbsolutePath())));
                }
                String relpath = FSUtilities.getRelativePath(f, d);
                if (relpath == null) {
                    throw new WrappedThrowableRuntimeException(new IOException("getRelativePath(" + StringUtilities.repr(f) + ", " + StringUtilities.repr(d) + ") == null"));
                }
                long l2 = f.length();
                if (l2 > fileSizeLimit) {
                    throw new WrappedThrowableRuntimeException(new IOException("File size (" + l2 + " bytes) exceeded limit (" + fileSizeLimit + " bytes) for " + StringUtilities.repr(f.getAbsolutePath())));
                }
                CollectionUtilities.putNewMandatory(rv, relpath, () -> {
                    try {
                        return FSIOUtilities.readAll(f);
                    }
                    catch (Exception exc) {
                        throw new WrappedThrowableRuntimeException(exc);
                    }
                });
            }
        }, DescendRecurse_Always, d);
        return rv;
    }

    public static void storeEntireDirectoryTreeFilesIntoEmptyParent(File parent, Map<String, byte[]> tree) {
        if (!parent.isDirectory()) {
            throw new WrappedThrowableRuntimeException(new IOException("Not a directory: " + StringUtilities.repr(parent.getAbsolutePath())));
        }
        if (parent.list().length != 0) {
            throw new WrappedThrowableRuntimeException(new IOException("Not an empty directory: " + StringUtilities.repr(parent.getAbsolutePath())));
        }
        for (Map.Entry<String, byte[]> e : tree.entrySet()) {
            String r = e.getKey();
            if (r.contains(String.valueOf(File.separator) + ".." + File.separator)) {
                throw new WrappedThrowableRuntimeException(new IOException("Bad relative path; contains directory ascensions: " + StringUtilities.repr(r)));
            }
            File f = FSUtilities.joinPathsLenient(parent, r);
            try {
                FSUtilities.ensureDirsWholePathThrowing(f.getParentFile());
                FSIOUtilities.writeAll(f, e.getValue());
            }
            catch (IOException exc) {
                throw new WrappedThrowableRuntimeException(exc);
            }
        }
    }

    public static void storeEntireDirectoryTreeFilesIntoParentThatIsEmptySaveForTheseFilenames(File parent, Map<String, byte[]> tree) {
        if (!parent.isDirectory()) {
            throw new WrappedThrowableRuntimeException(new IOException("Not a directory: " + StringUtilities.repr(parent.getAbsolutePath())));
        }
        for (String k : CollectionUtilities.reversed(CollectionUtilities.sorted(tree.keySet()))) {
            if (k.startsWith("../")) {
                throw new WrappedThrowableRuntimeException(new IOException("Bad relative path; contains directory ascensions: " + StringUtilities.repr(k)));
            }
            FSUtilities.deleteIfExistsMandatory(new File(parent, k));
        }
        block1: for (String k : CollectionUtilities.reversed(CollectionUtilities.sorted(tree.keySet()))) {
            while (true) {
                String n;
                FSUtilities.deleteIfExistsMandatory(new File(parent, (n = StringUtilities.splitonceReturnPrecedingOrNull(k, '/')) == null ? k : n));
                if (n == null) continue block1;
                k = n;
            }
        }
        FSUtilities.storeEntireDirectoryTreeFilesIntoEmptyParent(parent, tree);
    }

    public static boolean eqDirTrees(Map<String, byte[]> a, Map<String, byte[]> b) {
        return CollectionUtilities.defaultMapsEquivalent(a, b, (av, bv) -> Arrays.equals(av, bv));
    }

    public static MappedByteBuffer mmap(File f, long startInBytes, int sizeInBytes, boolean writeable) throws IOException {
        return FSUtilities.mmap(f.toPath(), startInBytes, sizeInBytes, writeable);
    }

    public static MappedByteBuffer mmap(Path p, long startInBytes, int sizeInBytes, boolean writeable) throws IOException {
        SmallIntegerMathUtilities.requireNonNegative(sizeInBytes);
        SmallIntegerMathUtilities.requireNonNegative(sizeInBytes);
        Throwable throwable = null;
        Object var6_6 = null;
        try (FileChannel c = writeable ? FileChannel.open(p, StandardOpenOption.READ, StandardOpenOption.WRITE) : FileChannel.open(p, StandardOpenOption.READ);){
            return c.map(writeable ? FileChannel.MapMode.READ_WRITE : FileChannel.MapMode.READ_ONLY, startInBytes, sizeInBytes);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void chx(File f) throws IOException {
        FSUtilities.chmod(f, CollectionUtilities.union(FSUtilities.getmod(f), CollectionUtilities.setof(PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE)));
    }

    public static void normperms(File f) throws IOException {
        if (f.isDirectory()) {
            FSUtilities.setPermsToStandardX(f);
        } else {
            FSUtilities.setPermsToStandardNX(f);
        }
    }

    public static void setPermsToStandardNX(File f) throws IOException {
        FSUtilities.chmod(f, CollectionUtilities.setof(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.GROUP_READ, PosixFilePermission.OTHERS_READ));
    }

    public static void setPermsToStandardX(File f) throws IOException {
        FSUtilities.chmod(f, CollectionUtilities.setof(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_READ, PosixFilePermission.OTHERS_EXECUTE));
    }

    public static Set<PosixFilePermission> getmod(File f) throws IOException {
        return Files.getPosixFilePermissions(f.toPath(), new LinkOption[0]);
    }

    public static void chmod(File f, Set<PosixFilePermission> mode) throws IOException {
        Files.setPosixFilePermissions(f.toPath(), mode);
    }

    public static void withTemporaryFile(FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<File> f) throws IOException {
        FSUtilities.withTemporaryFile(false, f);
    }

    public static void withTemporaryFile(boolean leave, FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<File> f) throws IOException {
        File t = File.createTempFile("temporary-file-", ".tmp");
        try {
            f.f(t);
        }
        finally {
            if (!leave) {
                t.delete();
            }
        }
    }

    public static void withTemporaryDirectory(FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<File> f) throws IOException {
        FSUtilities.withTemporaryDirectory(false, f);
    }

    public static void withTemporaryDirectory(boolean leave, FunctionalInterfacesThrowingCheckedExceptionsStandard.UnaryProcedureThrowingIOException<File> f) throws IOException {
        File t = File.createTempFile("temporary-dir-", "");
        FSUtilities.deleteThrowing(t);
        FSUtilities.ensureDirLeafThrowing(t);
        try {
            f.f(t);
        }
        finally {
            if (!leave) {
                FSUtilities.deleteRecursivelyThrowing(t, false);
            }
        }
    }

    private static /* synthetic */ String lambda$9(int n, String string, String s) {
        return String.valueOf(s) + (n == 1 ? "" : " (" + n + ")") + (string == null ? "" : String.valueOf('.') + string);
    }

    private static /* synthetic */ String lambda$15(int n, String s) {
        return String.valueOf(s) + (n == 1 ? "" : " (" + n + ")");
    }

    public static class AccumulatingObserver<C extends Collection<File>>
    implements FunctionInterfaces.UnaryProcedure<File> {
        protected Predicate<File> matcher;
        protected C collection;

        public AccumulatingObserver() {
        }

        public AccumulatingObserver(C collection) {
            this.setCollection(collection);
        }

        public AccumulatingObserver(Predicate<File> matcher, C collection) {
            this.matcher = matcher;
            this.collection = collection;
        }

        @Override
        public void f(File f) {
            if (this.matcher == null || this.matcher.test(f)) {
                this.collection.add((File)f);
            }
        }

        public C getCollection() {
            return this.collection;
        }

        public void setCollection(C collection) {
            this.collection = collection;
        }

        public Predicate<File> getMatcher() {
            return this.matcher;
        }

        public void setMatcher(Predicate<File> matcher) {
            this.matcher = matcher;
        }
    }

    public static enum FileTypeA {
        Absent,
        Directory,
        NormalOrSpecialFile;

    }

    public static enum FileTypeB {
        Absent,
        Directory,
        SpecialFile,
        NormalFile;

    }

    public static enum FileTypeC {
        Absent,
        Symlink,
        Directory,
        SpecialFile,
        NormalFile;

    }

    public static enum FileTypeD {
        Absent,
        Directory,
        SpecialFile,
        NormalFile,
        SymlinkBroken,
        SymlinkDirectory,
        SymlinkSpecialFile,
        SymlinkNormalFile;

    }

    public static interface LinkDereferencer {
        @Nullable
        public File dereference(@Nonnull File var1, @Nonnull File var2) throws IOException;
    }

    public static class NonExistantFile
    extends File {
        private static final long serialVersionUID = 1L;
        protected static final NonExistantFile I = new NonExistantFile();

        public static NonExistantFile inst() {
            return I;
        }

        protected NonExistantFile() {
            super("");
        }

        @Override
        public String getName() {
            return "<non-existant>";
        }

        @Override
        public String getParent() {
            return null;
        }

        @Override
        public File getParentFile() {
            return null;
        }

        @Override
        public String getPath() {
            return "<non-existant>";
        }

        @Override
        public boolean isAbsolute() {
            return true;
        }

        @Override
        public String getAbsolutePath() {
            return this.getAbsoluteFile().getPath();
        }

        @Override
        public File getAbsoluteFile() {
            return this;
        }

        @Override
        public String getCanonicalPath() throws IOException {
            return this.getCanonicalFile().getPath();
        }

        @Override
        public File getCanonicalFile() throws IOException {
            return this;
        }

        @Override
        @Deprecated
        public URL toURL() throws MalformedURLException {
            return null;
        }

        @Override
        public URI toURI() {
            return null;
        }

        @Override
        public boolean canRead() {
            return false;
        }

        @Override
        public boolean canWrite() {
            return false;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean isDirectory() {
            return false;
        }

        @Override
        public boolean isFile() {
            return false;
        }

        @Override
        public boolean isHidden() {
            return false;
        }

        @Override
        public long lastModified() {
            return 0L;
        }

        @Override
        public long length() {
            return 0L;
        }

        @Override
        public boolean createNewFile() throws IOException {
            throw new IOException("no such file or directory: " + this);
        }

        @Override
        public boolean delete() {
            return false;
        }

        @Override
        public void deleteOnExit() {
        }

        @Override
        public String[] list() {
            return null;
        }

        @Override
        public String[] list(FilenameFilter filter) {
            return null;
        }

        @Override
        public File[] listFiles() {
            return null;
        }

        @Override
        public File[] listFiles(FilenameFilter filter) {
            return null;
        }

        @Override
        public File[] listFiles(FileFilter filter) {
            return null;
        }

        @Override
        public boolean mkdir() {
            return false;
        }

        @Override
        public boolean mkdirs() {
            return false;
        }

        @Override
        public boolean renameTo(File dest) {
            return false;
        }

        @Override
        public boolean setLastModified(long time) {
            return false;
        }

        @Override
        public boolean setReadOnly() {
            return false;
        }

        @Override
        public boolean setWritable(boolean writable, boolean ownerOnly) {
            return false;
        }

        @Override
        public boolean setWritable(boolean writable) {
            return false;
        }

        @Override
        public boolean setReadable(boolean readable, boolean ownerOnly) {
            return false;
        }

        @Override
        public boolean setReadable(boolean readable) {
            return false;
        }

        @Override
        public boolean setExecutable(boolean executable, boolean ownerOnly) {
            return false;
        }

        @Override
        public boolean setExecutable(boolean executable) {
            return false;
        }

        @Override
        public boolean canExecute() {
            return false;
        }

        @Override
        public long getTotalSpace() {
            return 0L;
        }

        @Override
        public long getFreeSpace() {
            return 0L;
        }

        @Override
        public long getUsableSpace() {
            return 0L;
        }

        @Override
        public int compareTo(File pathname) {
            if (this.equals(pathname)) {
                return 0;
            }
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            return obj.getClass() == this.getClass();
        }

        @Override
        public int hashCode() {
            return this.toString().hashCode();
        }

        @Override
        public String toString() {
            return "<nonexistant file>";
        }
    }

    public static class PathnameContainsPathSeparatorException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 1L;

        public PathnameContainsPathSeparatorException() {
            super("A pathname contains a path separator ><!");
        }

        public PathnameContainsPathSeparatorException(File THEHORRIBLYOFFENSIVEPATH) {
            super("Pathname contains a path separator ><!  " + StringUtilities.repr(THEHORRIBLYOFFENSIVEPATH.getPath()));
        }

        protected PathnameContainsPathSeparatorException(String THEHORRIBLYOFFENSIVEPATH) {
            super("Pathname contains a path separator ><!  " + StringUtilities.repr(THEHORRIBLYOFFENSIVEPATH));
        }

        public static PathnameContainsPathSeparatorException instForAGivenPathname(File THEHORRIBLYOFFENSIVEPATH) {
            return new PathnameContainsPathSeparatorException(THEHORRIBLYOFFENSIVEPATH);
        }

        public static PathnameContainsPathSeparatorException instForAGivenPathname(String THEHORRIBLYOFFENSIVEPATH) {
            return new PathnameContainsPathSeparatorException(THEHORRIBLYOFFENSIVEPATH);
        }
    }

    public static interface SimpleFileLock
    extends Closeable {
    }

    public static interface WriterProcedure {
        public void write(OutputStream var1) throws IOException;
    }
}

